theory Conditional_Nonreach_SRS
  imports 
    Conditional_String_Rewriting
begin

lemma srs_co_rewrite_non_reach1:
  assumes co:"srs_co_rewrite_pair S NS"
    and R_NS:"R \<subseteq> NS"
    and st:"(s, t) \<in> S^-1"
  shows "\<not> (s, t) \<in> (srstep R)^*"
proof(rule ccontr)
  assume "\<not> ?thesis"
  hence *:"(s, t) \<in> (srstep R)^*" by auto
  from R_NS have "srstep R \<subseteq> NS" 
    by (metis co sctxt.closure_id srs_co_rewrite_pair_def srstep_eq_closure srstep_mono)
  hence "(srstep R)^* \<subseteq> NS" 
    by (metis co rtrancl_mono srs_co_rewrite_pair_def trans_refl_imp_rtrancl_id)
  hence "(s, t) \<in> NS" using R_NS * by blast
  then show False using co srs_co_rewrite_pair_def st by auto
qed

lemma srs_co_rewrite_non_reach2:
  assumes nst:"\<not> (s, t) \<in> (srstep R)^*"
  shows "\<exists>S NS. srs_co_rewrite_pair S NS \<and> R \<subseteq> NS \<and> (s, t) \<in> S^-1"
proof -
  let ?NS = "(srstep R)^*"
  let ?SS = "UNIV - (srstep R)^*"
  let ?S = "?SS^-1"
  have co:"srs_co_rewrite_pair ?S ?NS" 
    by (simp add: refl_rtrancl sctxt_closed_srsteps srs_co_rewrite_pair_def trans_rtrancl)
  have R_NS:"R \<subseteq> ?NS" by auto
  have *: "(s, t) \<in> ?S^-1" using nst by blast
  show ?thesis by (rule exI[of _ ?S], rule exI[of _ ?NS], insert co R_NS *, auto)
qed

theorem srs_co_rewrite_non_reach:
  "(\<exists>S NS. srs_co_rewrite_pair S NS \<and> R \<subseteq> NS \<and> (s, t) \<in> S^-1) \<longleftrightarrow> (\<not> (s, t) \<in> (srstep R)^*)"
    using srs_co_rewrite_non_reach1 srs_co_rewrite_non_reach2 by metis

lemma csr_step_NS: assumes co:"srs_co_rewrite_pair S NS"
  and lr_NS:"\<forall>s t. (s, t) \<in> (csr_step_n R n) \<longrightarrow> (s, t) \<in> NS"
shows "(u, v) \<in> (csr_step_n R n)\<^sup>* \<Longrightarrow> (u, v) \<in> NS"
proof -
  assume "(u, v) \<in> (csr_step_n R n)\<^sup>*"
  then show "(u, v) \<in> NS" 
  proof(induct)
    case base
    then show ?case using co srs_co_rewrite_pair.refl_NS_point by auto
  next
    case (step y z)
    from step(2) have "(y, z) \<in> NS" using assms by auto
    then show ?case using \<open>(u, y) \<in> NS\<close> \<open>(y, z) \<in> NS\<close>
      by (meson co srs_co_rewrite_pair_def transD)
  qed
qed

lemma csr_lr_step_NS: assumes co:"srs_co_rewrite_pair_extended S NS"
  and lr_NS:"\<forall>s t. (s, t) \<in> (csr_lr_step_n R n) \<longrightarrow> (s, t) \<in> NS"
shows "(u, v) \<in> (csr_lr_step_n R n)\<^sup>* \<Longrightarrow> (u, v) \<in> NS"
proof -
  assume "(u, v) \<in> (csr_lr_step_n R n)\<^sup>*"
  then show "(u, v) \<in> NS" 
  proof(induct)
    case base
    then show ?case 
      by (meson co reflD srs_co_rewrite_pair.refl_NS srs_co_rewrite_pair_extended_def)
  next
    case (step y z)
    from step(2) have "(y, z) \<in> NS" using assms by auto
    then show ?case using \<open>(u, y) \<in> NS\<close> \<open>(y, z) \<in> NS\<close> 
      by (meson co srs_co_rewrite_pair_def srs_co_rewrite_pair_extended.axioms(1) transD)
  qed
qed


lemma csr_r_step_NS: assumes co:"srs_co_rewrite_pair_extended S NS"
  and r_NS:"\<forall>s t. (s, t) \<in> (csr_r_step_n R n) \<longrightarrow> (s, t) \<in> NS"
shows "(u, v) \<in> (csr_r_step_n R n)\<^sup>* \<Longrightarrow> (u, v) \<in> NS"
proof -
  assume "(u, v) \<in> (csr_r_step_n R n)\<^sup>*"
  then show "(u, v) \<in> NS" 
  proof(induct)
    case base
    then show ?case using co
      using srs_co_rewrite_pair.refl_NS_point srs_co_rewrite_pair_extended.axioms(1) by blast
  next
    case (step y z)
    from step(2) have "(y, z) \<in> NS" using assms by auto
    then show ?case using \<open>(u, y) \<in> NS\<close> \<open>(y, z) \<in> NS\<close>
      by (meson co srs_co_rewrite_pair.trans_NS srs_co_rewrite_pair_extended_def transD)
  qed
qed

lemma csr_step_ns_star: 
  assumes co:"srs_co_rewrite_pair S NS"
    and rl_co:"\<forall>l r cs. ((l, r), cs) \<in> R \<longrightarrow> ((l, r) \<in> NS \<or> (\<exists> u v. (u, v) \<in> set cs \<and> (u, v) \<in> S^-1))"
    and st:"(s, t) \<in> (csr_step R)\<^sup>*"
  shows "(s, t) \<in> NS" using st
proof(induct)
  case base
  then show ?case 
    by (meson assms(1) reflD srs_co_rewrite_pair_def)
next
  case (step y z)
  from step(2)  obtain n where yz:"(y, z) \<in> (csr_step_n R n)"
    using csr_step_iff by blast
  have "(y, z) \<in> NS" using yz
  proof(induct n arbitrary:y z)
    case 0
    then show ?case by auto
  next
    case (Suc n)
    from \<open>(y, z) \<in> csr_step_n R (Suc n)\<close> obtain C l r cs 
      where lrcs:"((l, r), cs) \<in> R" and cond:"\<forall>(s\<^sub>i, t\<^sub>i) \<in> set cs. (s\<^sub>i, t\<^sub>i) \<in> (csr_step_n R n)\<^sup>*"
        and y:"y = C\<llangle>l\<rrangle>" and z:"z = C\<llangle>r\<rrangle>" by auto
    have "\<forall>(s\<^sub>i, t\<^sub>i) \<in> set cs. (s\<^sub>i, t\<^sub>i) \<in> NS" using cond Suc(1) co csr_step_NS by force
    hence "\<forall>(s\<^sub>i, t\<^sub>i) \<in> set cs. \<not> (s\<^sub>i, t\<^sub>i) \<in> S^-1" using co srs_co_rewrite_pair_def by auto
    hence *:"\<forall>l r. ((l, r), cs) \<in> R \<longrightarrow> (l, r) \<in> NS" using co rl_co by fastforce
    hence "\<forall>l r C. ((l, r), cs) \<in> R \<longrightarrow> (C\<llangle>l\<rrangle>, C\<llangle>r\<rrangle>) \<in> NS" using * co srs_co_rewrite_pair_def by blast
    then show ?case using Suc lrcs y z by (auto split:prod.splits)
  qed
  then show ?case using yz step
    by (meson co srs_co_rewrite_pair_def transD)
qed

lemma csr_lr_step_ns_star: 
  assumes co:"srs_co_rewrite_pair_extended S NS"
    and rl_co:"\<forall>l r cs. ((l, r), cs) \<in> R \<longrightarrow> ((l, r) \<in> NS \<or> (\<exists> u v. (u, v) \<in> set cs \<and> (u, v) \<in> S^-1))"
  shows "(s, t) \<in> (csr_lr_step R)\<^sup>* \<Longrightarrow> (s, t) \<in> NS" 
proof -
  assume st:"(s, t) \<in> (csr_lr_step R)\<^sup>*"
  then show ?thesis
  proof(induct)
    case base
    then show ?case using co srs_co_rewrite_pair.refl_NS_point srs_co_rewrite_pair_extended_def by blast
  next
    case (step y z)
    from step(2)  obtain n where yz:"(y, z) \<in> (csr_lr_step_n R n)"
      using csr_lr_step_iff by blast
    have "(y, z) \<in> NS" using yz
    proof(induct n arbitrary:y z)
      case 0
      then show ?case by auto
    next
      case (Suc n)
      from \<open>(y, z) \<in> csr_lr_step_n R (Suc n)\<close> obtain C D l r cs 
        where lrcs:"((l, r), cs) \<in> R" and cond:"\<forall>(s\<^sub>i, t\<^sub>i) \<in> set cs. (D\<llangle>s\<^sub>i\<rrangle>, D\<llangle>t\<^sub>i\<rrangle>) \<in> (csr_lr_step_n R n)\<^sup>*"
          and y:"y = C\<llangle>D\<llangle>l\<rrangle>\<rrangle>" and z:"z = C\<llangle>D\<llangle>r\<rrangle>\<rrangle>" by auto
      have "\<forall>(s\<^sub>i, t\<^sub>i) \<in> set cs. (D\<llangle>s\<^sub>i\<rrangle>, D\<llangle>t\<^sub>i\<rrangle>) \<in> NS" using cond Suc(1) co csr_lr_step_NS by blast
      hence "\<forall>(s\<^sub>i, t\<^sub>i) \<in> set cs. \<not> (D\<llangle>s\<^sub>i\<rrangle>, D\<llangle>t\<^sub>i\<rrangle>) \<in> S^-1" using co 
        using srs_co_rewrite_pair.disj_NS_S srs_co_rewrite_pair_extended.axioms(1) by fastforce
      hence "\<forall>(s\<^sub>i, t\<^sub>i) \<in> set cs. \<not> (s\<^sub>i, t\<^sub>i) \<in> S^-1" using co
        using srs_co_rewrite_pair_extended.sctxt_S by fastforce
      hence *:"\<forall>l r. ((l, r), cs) \<in> R \<longrightarrow> (l, r) \<in> NS" using co rl_co by fastforce
      hence "\<forall>l r C. ((l, r), cs) \<in> R \<longrightarrow> (C\<llangle>D\<llangle>l\<rrangle>\<rrangle>, C\<llangle>D\<llangle>r\<rrangle>\<rrangle>) \<in> NS" using * co 
        using sctxt.closedD srs_co_rewrite_pair.sctxt_NS 
        by (meson srs_co_rewrite_pair_extended_def)
      then show ?case using Suc lrcs y z by (auto split:prod.splits)
    qed
    then show ?case unfolding srs_co_rewrite_pair_def using yz step 
      by (meson co srs_co_rewrite_pair.trans_NS srs_co_rewrite_pair_extended.axioms(1) transD)
  qed
qed

lemma csr_r_step_ns_star: 
  assumes co:"srs_co_rewrite_pair_extended S NS"
    and rl_co:"\<forall>l r cs. ((l, r), cs) \<in> R \<longrightarrow> ((l, r) \<in> NS \<or> (\<exists> u v. (u, v) \<in> set cs \<and> (u, v) \<in> S^-1))"
  shows "(s, t) \<in> (csr_r_step R)\<^sup>* \<Longrightarrow> (s, t) \<in> NS" 
proof -
  assume st:"(s, t) \<in> (csr_r_step R)\<^sup>*"
  then show ?thesis
  proof(induct)
    case base
    then show ?case using co srs_co_rewrite_pair.refl_NS_point srs_co_rewrite_pair_extended_def by blast
  next
    case (step y z)
    from step(2)  obtain n where yz:"(y, z) \<in> (csr_r_step_n R n)"
      using csr_r_step_iff by blast
    have "(y, z) \<in> NS" using yz
    proof(induct n arbitrary:y z)
      case 0
      then show ?case by auto
    next
      case (Suc n)
      from \<open>(y, z) \<in> csr_r_step_n R (Suc n)\<close> obtain C w l r cs 
        where lrcs:"((l, r), cs) \<in> R" and cond:"\<forall>(s\<^sub>i, t\<^sub>i) \<in> set cs. (s\<^sub>i @ w, t\<^sub>i @ w) \<in> (csr_r_step_n R n)\<^sup>*"
          and y:"y = C\<llangle>l @ w\<rrangle>" and z:"z = C\<llangle>r @ w\<rrangle>" by auto
      have "\<forall>(s\<^sub>i, t\<^sub>i) \<in> set cs. (s\<^sub>i @ w, t\<^sub>i @ w) \<in> NS" using cond Suc(1) co csr_r_step_NS by force
      hence *:"\<forall>(s\<^sub>i, t\<^sub>i) \<in> set cs. \<not> (s\<^sub>i @ w, t\<^sub>i @ w) \<in> S^-1" using co srs_co_rewrite_pair_extended_def 
          srs_co_rewrite_pair.disj_NS_S by fastforce
      hence "\<forall>(s\<^sub>i, t\<^sub>i) \<in> set cs. \<not> (s\<^sub>i, t\<^sub>i) \<in> S^-1" using co srs_co_rewrite_pair_extended_def 
        by (auto, metis * append.right_neutral case_prodD converseI empty_append sctxt_closed_strings 
            srs_co_rewrite_pair_extended.sctxt_S)
      hence *:"\<forall>l r. ((l, r), cs) \<in> R \<longrightarrow> (l, r) \<in> NS" using co rl_co by fastforce
      hence "\<forall>l r C. ((l, r), cs) \<in> R \<longrightarrow> (C\<llangle>l @ w\<rrangle>, C\<llangle>r @ w\<rrangle>) \<in> NS" using * co srs_co_rewrite_pair_extended_def 
          sctxt.closedD srs_co_rewrite_pair.sctxt_NS
        by (metis append.right_neutral empty_append sctxt_closed_strings)
      then show ?case using Suc lrcs y z by (auto split:prod.splits)
    qed
    then show ?case unfolding srs_co_rewrite_pair_def using yz step 
      by (meson co srs_co_rewrite_pair_def srs_co_rewrite_pair_extended_def transD) 
  qed
qed

lemma csr_cond_rule_imp_n: assumes rl:"((l, r), cs) \<in> R"
  and cond:"\<forall>u v. (u, v) \<in> set cs \<longrightarrow> (u, v) \<in> (csr_step_n R n)\<^sup>*"
shows "(l, r) \<in> (csr_step_n R (Suc n))" using assms 
  by (auto, metis sctxt.cop_nil surj_pair)

lemma csr_cond_rule_imp: assumes rl:"((l, r), cs) \<in> R"
  and cond:"\<forall>u v. (u, v) \<in> set cs \<longrightarrow> (u, v) \<in> (csr_step R)\<^sup>*"
shows "(l, r) \<in> (csr_step R)" using assms csr_cond_rule_imp_n 
  by (metis (no_types, lifting) ballI2 csr_stepI)

lemma inf_co_rewrite_conditional_srs_main:
  assumes "\<exists>S NS. srs_co_rewrite_pair S NS \<and> (\<forall>l r cs. ((l, r), cs) \<in> R \<longrightarrow> ((l, r) \<in> NS \<or> (\<exists> u v. (u, v) \<in> set cs \<and> (u, v) \<in> S^-1))) \<and> (s, t) \<in> S^-1"
  shows "\<not> (s, t) \<in> (csr_step R)\<^sup>*"
proof (rule ccontr)
  assume asm:"\<not> ?thesis"
  hence "(s, t) \<in> (csr_step R)\<^sup>*" by auto
  from assms obtain S NS where co:"srs_co_rewrite_pair S NS" and rl:"(\<forall>l r cs. ((l, r), cs) \<in> R \<longrightarrow> ((l, r) \<in> NS \<or> (\<exists> u v. (u, v) \<in> set cs \<and> (u, v) \<in> S^-1)))"
    and st:"(s, t) \<in> S^-1" by auto
  from csr_step_ns_star[OF co rl] 
  have "(s, t) \<in> NS" using asm by auto
  then show False using co srs_co_rewrite_pair_def st by auto
qed

lemma inf_co_rewrite_conditional_srs_reverse:
  assumes "\<not> (s, t) \<in> (csr_step R)\<^sup>*"
  shows "\<exists>S NS. srs_co_rewrite_pair S NS \<and> (\<forall>l r cs. ((l, r), cs) \<in> R \<longrightarrow> ((l, r) \<in> NS \<or> (\<exists> u v. (u, v) \<in> set cs \<and> (u, v) \<in> S^-1))) \<and> (s, t) \<in> S^-1"
proof -
  let ?NS = "(csr_step R)^*"
  let ?csr_unsat = "\<lambda>R. {(t, s) | s t . \<not> (s, t) \<in> (csr_step R)^*}"
  let ?S = "(?csr_unsat R)"
  have *:"srs_co_rewrite_pair ?S ?NS" unfolding srs_co_rewrite_pair_def 
  proof (auto)
    show "refl ((csr_step R)\<^sup>*)" using refl_rtrancl by blast
    show "trans ((csr_step R)\<^sup>*)" by (simp add: trans_rtrancl)
    show "sctxt.closed ((csr_step R)\<^sup>*)" using csr_step_ctxt_closed by auto
  qed
  have "(s, t) \<in> ?S^-1" using assms by auto
  have **:"(\<forall>l r cs. ((l, r), cs) \<in> R \<longrightarrow> ((l, r) \<in> ?NS \<or> (\<exists> u v. (u, v) \<in> set cs \<and> (u, v) \<in> ?S^-1)))"
    using csr_stepI csr_cond_rule_imp by auto
  show ?thesis by (rule exI[of _ ?S], rule exI[of _ ?NS], insert * ** assms, auto) 
qed

(* The following theorem shows the completeness of the co_rewrite pairs w.r.t infeasibility in conditional string rewriting *)
theorem inf_co_rewrite_conditional_srs:
  "\<exists>S NS. srs_co_rewrite_pair S NS \<and> (\<forall>l r cs. ((l, r), cs) \<in> R \<longrightarrow> ((l, r) \<in> NS \<or> (\<exists> u v. (u, v) \<in> set cs \<and> (u, v) \<in> S^-1))) \<and> (s, t) \<in> S^-1 \<Longrightarrow> \<not> (s, t) \<in> (csr_step R)\<^sup>*"
  "\<not> (s, t) \<in> (csr_step R)\<^sup>* \<Longrightarrow> \<exists>S NS. srs_co_rewrite_pair S NS \<and> (\<forall>l r cs. ((l, r), cs) \<in> R \<longrightarrow> ((l, r) \<in> NS \<or> (\<exists> u v. (u, v) \<in> set cs \<and> (u, v) \<in> S^-1))) \<and> (s, t) \<in> S^-1"
  using inf_co_rewrite_conditional_srs_main inf_co_rewrite_conditional_srs_reverse by auto

lemma csr_step_ns_star_cancel: 
  assumes co:"srs_co_rewrite_pair S NS"
    and NS_cancel:"cancellation_property NS"
    and rl_co:"\<forall>l r cs. ((l, r), cs) \<in> R \<longrightarrow> ((l, r) \<in> NS \<or> (\<exists> u v. (u, v) \<in> set cs \<and> (u, v) \<in> S^-1))"
    and st:"(s @ w, t @ w) \<in> (csr_step R)\<^sup>*"
  shows "(s, t) \<in> NS"
proof -
  from csr_step_ns_star assms
  have "(s @ w, t @ w) \<in> NS" by auto
  then show ?thesis using NS_cancel[unfolded cancellation_property_def] by auto
qed

lemma inf_co_rewrite_conditional_srs_generalized:
  assumes "\<exists>S NS. srs_co_rewrite_pair S NS \<and> cancellation_property NS \<and> (\<forall>l r cs. ((l, r), cs) \<in> R \<longrightarrow> ((l, r) \<in> NS \<or> (\<exists> u v. (u, v) \<in> set cs \<and> (u, v) \<in> S^-1))) \<and> (s, t) \<in> S^-1"
  shows "\<not> (\<exists>u. (s @ u, t @ u) \<in> (csr_step R)\<^sup>*)"
proof (rule ccontr)
  assume "\<not> ?thesis"
  then obtain u where *: "(s @ u, t @ u) \<in> (csr_step R)\<^sup>*" by auto
  from assms obtain S NS where co:"srs_co_rewrite_pair S NS" and NS_cancel:"cancellation_property NS" and rl:"(\<forall>l r cs. ((l, r), cs) \<in> R \<longrightarrow> ((l, r) \<in> NS \<or> (\<exists> u v. (u, v) \<in> set cs \<and> (u, v) \<in> S^-1)))"
    and st:"(s, t) \<in> S^-1" by auto
  from csr_step_ns_star_cancel[OF co NS_cancel rl] 
  have "(s, t) \<in> NS" using * by auto
  then show False using st using co srs_co_rewrite_pair_def by auto
qed

proposition inf_lr_co_rewrite_conditional_srs:
  assumes "\<exists>S NS. srs_co_rewrite_pair_extended S NS \<and> (\<forall>l r cs. ((l, r), cs) \<in> R \<longrightarrow> ((l, r) \<in> NS \<or> (\<exists> u v. (u, v) \<in> set cs \<and> (u, v) \<in> S^-1))) \<and> (s, t) \<in> S^-1"
  shows "\<not> (s, t) \<in> (csr_lr_step R)^*" 
proof (rule ccontr)
  assume "\<not> ?thesis"
  hence *:"(s, t) \<in> (csr_lr_step R)^*" by blast
  from assms obtain S NS where co:"srs_co_rewrite_pair_extended S NS" and rl:"(\<forall>l r cs. ((l, r), cs) \<in> R \<longrightarrow> ((l, r) \<in> NS \<or> (\<exists> u v. (u, v) \<in> set cs \<and> (u, v) \<in> S^-1)))"
    and st:"(s, t) \<in> S^-1" by auto
  from csr_lr_step_ns_star[OF co rl]
  have **:"(s, t) \<in> NS" by (simp add: *)
  from st have "(s, t) \<in> S^-1"
    using co srs_co_rewrite_pair_extended.sctxt_S by blast
  then show False using ** co srs_co_rewrite_pair.disj_NS_S srs_co_rewrite_pair_extended.axioms(1) by fastforce
qed

proposition inf_lr_co_rewrite_conditional_srs_main:
  assumes "\<exists>S NS. srs_co_rewrite_pair_extended S NS \<and> (\<forall>l r cs. ((l, r), cs) \<in> R \<longrightarrow> ((l, r) \<in> NS \<or> (\<exists> u v. (u, v) \<in> set cs \<and> (u, v) \<in> S^-1))) \<and> (s, t) \<in> S^-1"
  shows "\<not> (\<exists>C. (C\<llangle>s\<rrangle>, C\<llangle>t\<rrangle>) \<in> (csr_lr_step R)^*)" 
proof (rule ccontr)
  assume "\<not> ?thesis"
  then obtain C where *:"(C\<llangle>s\<rrangle>, C\<llangle>t\<rrangle>) \<in> (csr_lr_step R)^*" by blast
  from assms obtain S NS where co:"srs_co_rewrite_pair_extended S NS" and rl:"(\<forall>l r cs. ((l, r), cs) \<in> R \<longrightarrow> ((l, r) \<in> NS \<or> (\<exists> u v. (u, v) \<in> set cs \<and> (u, v) \<in> S^-1)))"
    and st:"(s, t) \<in> S^-1" by auto
  from csr_lr_step_ns_star[OF co rl]
  have **:"(C\<llangle>s\<rrangle>, C\<llangle>t\<rrangle>) \<in> NS" by (simp add: *)
  from st have "(C\<llangle>s\<rrangle>, C\<llangle>t\<rrangle>) \<in> S^-1"
    using co srs_co_rewrite_pair_extended.sctxt_S by blast
  then show False using ** co srs_co_rewrite_pair.disj_NS_S srs_co_rewrite_pair_extended.axioms(1) by fastforce
qed

proposition inf_r_co_rewrite_conditional_srs:
  assumes "\<exists>S NS. srs_co_rewrite_pair_extended S NS \<and> (\<forall>l r cs. ((l, r), cs) \<in> R \<longrightarrow> ((l, r) \<in> NS \<or> (\<exists> u v. (u, v) \<in> set cs \<and> (u, v) \<in> S^-1))) \<and> (s, t) \<in> S^-1"
  shows "\<not> (s, t) \<in> (csr_r_step R)^*"
proof (rule ccontr)
  assume "\<not> ?thesis"
  hence  *:"(s, t) \<in> (csr_r_step R)^*" by auto
  from assms obtain S NS where co:"srs_co_rewrite_pair_extended S NS" and rl:"(\<forall>l r cs. ((l, r), cs) \<in> R \<longrightarrow> ((l, r) \<in> NS \<or> (\<exists> u v. (u, v) \<in> set cs \<and> (u, v) \<in> S^-1)))"
    and st:"(s, t) \<in> S^-1" by auto
  from csr_r_step_ns_star[OF co rl] assms
  have "(s, t) \<in> NS" using * by blast
  moreover have "(s, t) \<in> S^-1" using st by auto
  ultimately show False
    by (meson co disjoint_iff_not_equal srs_co_rewrite_pair.disj_NS_S srs_co_rewrite_pair_extended.axioms(1))
qed

proposition inf_r_co_rewrite_conditional_srs_main:
  assumes "\<exists>S NS. srs_co_rewrite_pair_extended S NS \<and> (\<forall>l r cs. ((l, r), cs) \<in> R \<longrightarrow> ((l, r) \<in> NS \<or> (\<exists> u v. (u, v) \<in> set cs \<and> (u, v) \<in> S^-1))) \<and> (s, t) \<in> S^-1"
  shows "\<not> (\<exists>w. (s @ w, t @ w) \<in> (csr_r_step R)^*)"
proof (rule ccontr)
  assume "\<not> ?thesis"
  then obtain w where *:"(s @ w, t @ w) \<in> (csr_r_step R)^*" by auto
  from assms obtain S NS where co:"srs_co_rewrite_pair_extended S NS" and rl:"(\<forall>l r cs. ((l, r), cs) \<in> R \<longrightarrow> ((l, r) \<in> NS \<or> (\<exists> u v. (u, v) \<in> set cs \<and> (u, v) \<in> S^-1)))"
    and st:"(s, t) \<in> S^-1" by auto
  from csr_r_step_ns_star[OF co rl] assms
  have "(s @ w, t @ w) \<in> NS" 
    using * by blast
  moreover have "(s @ w, t @ w) \<in> S^-1" using st 
    by (metis append.right_neutral co empty_append sctxt_closed_strings srs_co_rewrite_pair_extended.sctxt_S) 
  ultimately show False
    by (meson co disjoint_iff_not_equal srs_co_rewrite_pair.disj_NS_S srs_co_rewrite_pair_extended.axioms(1))
qed

context lex
begin

corollary infeasibility_co_lex_S_NS:
  assumes rl:"\<forall>l r cs. ((l, r), cs) \<in> R \<longrightarrow> ((l, r) \<in> lex_NS \<or> (\<exists> u v. (u, v) \<in> set cs \<and> (u, v) \<in> (co_lex_S)^-1))"
    and "(s, t) \<in> (co_lex_S)^-1"
  shows "\<not> (s, t) \<in> (csr_step R)\<^sup>*"
proof -
  have "srs_co_rewrite_pair co_lex_S lex_NS" using co_rewrite_pair_lex_co_lex by blast
  then show ?thesis using assms inf_co_rewrite_conditional_srs_main by blast
qed

corollary infeasibility_lex_S_NS:
  assumes rl:"\<forall>l r cs. ((l, r), cs) \<in> R \<longrightarrow> ((l, r) \<in> lex_NS \<or> (\<exists> u v. (u, v) \<in> set cs \<and> (u, v) \<in> (lex_S)^-1))"
    and "(s, t) \<in> (lex_S)^-1"
  shows "\<not> (s, t) \<in> (csr_step R)\<^sup>*"
proof -
  have "srs_co_rewrite_pair lex_S lex_NS" using co_rewrite_pair_lex by blast
  then show ?thesis using assms inf_co_rewrite_conditional_srs_main by blast
qed

corollary infeasibility_len_S_NS:
  assumes rl:"\<forall>l r cs. ((l, r), cs) \<in> R \<longrightarrow> ((l, r) \<in> len_NS \<or> (\<exists> u v. (u, v) \<in> set cs \<and> (u, v) \<in> (len_S)^-1))"
    and "(s, t) \<in> (len_S)^-1"
  shows "\<not> (s, t) \<in> (csr_step R)\<^sup>*"
proof -
  have "srs_co_rewrite_pair len_S len_NS" using co_rewrite_pair_len by blast
  then show ?thesis using assms inf_co_rewrite_conditional_srs_main by blast
qed

corollary infeasibility_co_shortlex_S_NS:
  assumes rl:"\<forall>l r cs. ((l, r), cs) \<in> R \<longrightarrow> ((l, r) \<in> shortlex_NS \<or> (\<exists> u v. (u, v) \<in> set cs \<and> (u, v) \<in> (co_shortlex_S)^-1))"
    and "(s, t) \<in> (co_shortlex_S)^-1"
  shows "\<not> (s, t) \<in> (csr_step R)\<^sup>*"
proof -
  have "srs_co_rewrite_pair co_shortlex_S shortlex_NS" using co_rewrite_pair_shortlex_co_shortlex by fastforce
  then show ?thesis using assms inf_co_rewrite_conditional_srs_main by blast
qed

corollary infeasibility_shortlex_S_NS:
  assumes rl:"\<forall>l r cs. ((l, r), cs) \<in> R \<longrightarrow> ((l, r) \<in> shortlex_NS \<or> (\<exists> u v. (u, v) \<in> set cs \<and> (u, v) \<in> (shortlex_S)^-1))"
    and "(s, t) \<in> (shortlex_S)^-1"
  shows "\<not> (s, t) \<in> (csr_step R)\<^sup>*"
proof -
  have "srs_co_rewrite_pair shortlex_S shortlex_NS" using co_rewrite_pair_shortlex by blast
  then show ?thesis using assms inf_co_rewrite_conditional_srs_main by blast
qed

corollary infeasibility_shortlex_S_NS_generalized:
  assumes rl:"\<forall>l r cs. ((l, r), cs) \<in> R \<longrightarrow> ((l, r) \<in> shortlex_NS \<or> (\<exists> u v. (u, v) \<in> set cs \<and> (u, v) \<in> (shortlex_S)^-1))"
    and "(s, t) \<in> (shortlex_S)^-1"
  shows "\<not> (\<exists>w. (s @ w, t @ w) \<in> (csr_step R)\<^sup>*)"
proof -
  have "srs_co_rewrite_pair shortlex_S shortlex_NS" using co_rewrite_pair_shortlex by blast
  moreover have "cancellation_property shortlex_NS" using shortlex_cancellation_property by auto
  ultimately show ?thesis using assms inf_co_rewrite_conditional_srs_generalized 
    shortlex_cancellation_property co_rewrite_pair_shortlex inf_co_rewrite_conditional_srs_generalized rl by blast
qed

corollary infeasibility_co_shortlex_S_NS_generalized:
  assumes rl:"\<forall>l r cs. ((l, r), cs) \<in> R \<longrightarrow> ((l, r) \<in> shortlex_NS \<or> (\<exists> u v. (u, v) \<in> set cs \<and> (u, v) \<in> (co_shortlex_S)^-1))"
    and "(s, t) \<in> (co_shortlex_S)^-1"
  shows "\<not> (\<exists>w. (s @ w, t @ w) \<in> (csr_step R)\<^sup>*)"
proof -
  have "srs_co_rewrite_pair co_shortlex_S shortlex_NS" using co_rewrite_pair_shortlex_co_shortlex by fastforce
  moreover have "cancellation_property shortlex_NS" using shortlex_cancellation_property by auto
  ultimately show ?thesis using assms inf_co_rewrite_conditional_srs_generalized 
    shortlex_cancellation_property co_rewrite_pair_shortlex_co_shortlex inf_co_rewrite_conditional_srs_generalized rl by blast
qed

corollary infeasibility_lr_lex_S_NS_main:
  assumes rl:"\<forall>l r cs. ((l, r), cs) \<in> R \<longrightarrow> ((l, r) \<in> lex_NS \<or> (\<exists> u v. (u, v) \<in> set cs \<and> (u, v) \<in> (lex_S)^-1))"
    and "(s, t) \<in> (lex_S)^-1"
  shows "\<not> (s, t) \<in> (csr_lr_step R)^*"
proof -
  have "srs_co_rewrite_pair_extended lex_S lex_NS" using co_rewrite_pair_extended_lex by blast
  then show ?thesis using assms using assms(2) co_rewrite_pair_extended_lex inf_lr_co_rewrite_conditional_srs rl by blast
qed

corollary infeasibility_lr_lex_S_NS:
  assumes rl:"\<forall>l r cs. ((l, r), cs) \<in> R \<longrightarrow> ((l, r) \<in> lex_NS \<or> (\<exists> u v. (u, v) \<in> set cs \<and> (u, v) \<in> (lex_S)^-1))"
    and "(s, t) \<in> (lex_S)^-1"
  shows "\<not> (\<exists>C. (C\<llangle>s\<rrangle>, C\<llangle>t\<rrangle>) \<in> (csr_lr_step R)^*)"
proof -
  have "srs_co_rewrite_pair_extended lex_S lex_NS" using co_rewrite_pair_extended_lex by blast
  then show ?thesis using assms co_rewrite_pair_extended_lex inf_lr_co_rewrite_conditional_srs_main rl by blast
qed

corollary infeasibility_lr_short_lex_S_NS:
  assumes rl:"\<forall>l r cs. ((l, r), cs) \<in> R \<longrightarrow> ((l, r) \<in> shortlex_NS \<or> (\<exists> u v. (u, v) \<in> set cs \<and> (u, v) \<in> (shortlex_S)^-1))"
    and "(s, t) \<in> (shortlex_S)^-1"
  shows "\<not> (\<exists>C. (C\<llangle>s\<rrangle>, C\<llangle>t\<rrangle>) \<in> (csr_lr_step R)^*)"
proof -
  have "srs_co_rewrite_pair_extended shortlex_S shortlex_NS" using co_rewrite_pair_extended_shortlex by auto
  then show ?thesis using assms inf_lr_co_rewrite_conditional_srs_main co_rewrite_pair_extended_shortlex rl by blast
qed

corollary infeasibility_lr_short_lex_S_NS_generalized:
  assumes rl:"\<forall>l r cs. ((l, r), cs) \<in> R \<longrightarrow> ((l, r) \<in> shortlex_NS \<or> (\<exists> u v. (u, v) \<in> set cs \<and> (u, v) \<in> (shortlex_S)^-1))"
    and "(s, t) \<in> (shortlex_S)^-1"
  shows "\<not> (s, t) \<in> (csr_lr_step R)^*"
proof -
  from assms show ?thesis
    by (metis (mono_tags, lifting) co_rewrite_pair_extended_shortlex inf_lr_co_rewrite_conditional_srs)
qed

corollary infeasibility_lr_short_lex_S_NS_main:
  assumes rl:"\<forall>l r cs. ((l, r), cs) \<in> R \<longrightarrow> ((l, r) \<in> shortlex_NS \<or> (\<exists> u v. (u, v) \<in> set cs \<and> (u, v) \<in> (shortlex_S)^-1))"
    and "(s, t) \<in> (shortlex_S)^-1"
  shows "\<not> (\<exists>u v. (u @ s @ v, u @ t @ v) \<in> (csr_lr_step R)^*)"
proof -
  from assms infeasibility_lr_short_lex_S_NS
  have "\<not> (\<exists>C. (C\<llangle>s\<rrangle>, C\<llangle>t\<rrangle>) \<in> (csr_lr_step R)^*)" by auto
  then show ?thesis by (metis ShortLex.more sctxt.cop_nil)
qed

corollary infeasibility_r_lex_S_NS_main:
  assumes rl:"\<forall>l r cs. ((l, r), cs) \<in> R \<longrightarrow> ((l, r) \<in> lex_NS \<or> (\<exists> u v. (u, v) \<in> set cs \<and> (u, v) \<in> (lex_S)^-1))"
    and "(s, t) \<in> (lex_S)^-1"
  shows "\<not> (s , t ) \<in> (csr_r_step R)^*"
proof -
  have "srs_co_rewrite_pair_extended lex_S lex_NS" using co_rewrite_pair_extended_lex by blast
  then show ?thesis using assms inf_r_co_rewrite_conditional_srs by blast
qed

corollary infeasibility_r_lex_S_NS:
  assumes rl:"\<forall>l r cs. ((l, r), cs) \<in> R \<longrightarrow> ((l, r) \<in> lex_NS \<or> (\<exists> u v. (u, v) \<in> set cs \<and> (u, v) \<in> (lex_S)^-1))"
    and "(s, t) \<in> (lex_S)^-1"
  shows "\<not> (\<exists>w. (s @ w, t @ w) \<in> (csr_r_step R)^*)"
proof -
  have "srs_co_rewrite_pair_extended lex_S lex_NS" using co_rewrite_pair_extended_lex by blast
  then show ?thesis using assms co_rewrite_pair_extended_lex inf_r_co_rewrite_conditional_srs_main rl by blast
qed

corollary infeasibility_r_shortlex_S_NS_main:
  assumes rl:"\<forall>l r cs. ((l, r), cs) \<in> R \<longrightarrow> ((l, r) \<in> shortlex_NS \<or> (\<exists> u v. (u, v) \<in> set cs \<and> (u, v) \<in> (shortlex_S)^-1))"
    and "(s, t) \<in> (shortlex_S)^-1"
  shows "\<not> (s, t) \<in> (csr_r_step R)^*"
proof -
  have "srs_co_rewrite_pair_extended shortlex_S shortlex_NS" using co_rewrite_pair_extended_shortlex by auto
  then show ?thesis using assms using inf_r_co_rewrite_conditional_srs by blast
qed

corollary infeasibility_r_shortlex_S_NS:
  assumes rl:"\<forall>l r cs. ((l, r), cs) \<in> R \<longrightarrow> ((l, r) \<in> shortlex_NS \<or> (\<exists> u v. (u, v) \<in> set cs \<and> (u, v) \<in> (shortlex_S)^-1))"
    and "(s, t) \<in> (shortlex_S)^-1"
  shows "\<not> (\<exists>w. (s @ w, t @ w) \<in> (csr_r_step R)^*)"
proof -
  have "srs_co_rewrite_pair_extended shortlex_S shortlex_NS" using co_rewrite_pair_extended_shortlex by auto
  then show ?thesis using assms inf_r_co_rewrite_conditional_srs_main co_rewrite_pair_extended_shortlex rl by blast
qed

end

end