section \<open>Conditional String Rewriting\<close>

theory Conditional_String_Rewriting
  imports
   "HOL-Library.Sublist"
   TRS.Relation_Closure
   String_Rewriting
   ShortLex
begin

type_synonym csrule = "srule \<times> srule list"
type_synonym csrs = "csrule set"

text \<open>A conditional string rewriting step of level @{term n}.\<close>
fun csr_step_n :: "csrs \<Rightarrow> nat \<Rightarrow> string rel"
where
  "csr_step_n R 0 = {}" |
  csr_step_n_Suc: "csr_step_n R (Suc n) =
    {(C\<llangle>l\<rrangle>, C\<llangle>r\<rrangle>) | C l r cs.
      ((l, r), cs) \<in> R \<and> (\<forall> (s\<^sub>i, t\<^sub>i) \<in> set cs. (s\<^sub>i, t\<^sub>i) \<in> (csr_step_n R n)\<^sup>*)}"

definition "csr_step R = (\<Union>n. csr_step_n R n)"

fun csr_lr_step_n :: "csrs \<Rightarrow> nat \<Rightarrow> string rel"
where
  "csr_lr_step_n R 0 = {}" |
  csr_lr_step_n_Suc: "csr_lr_step_n R (Suc n) =
    {(C\<llangle>D\<llangle>l\<rrangle>\<rrangle>, C\<llangle>D\<llangle>r\<rrangle>\<rrangle>) | C D l r cs.
      ((l, r), cs) \<in> R \<and> (\<forall> (s\<^sub>i, t\<^sub>i) \<in> set cs. (D\<llangle>s\<^sub>i\<rrangle>, D\<llangle>t\<^sub>i\<rrangle>) \<in> (csr_lr_step_n R n)\<^sup>*)}"

definition "csr_lr_step R = (\<Union>n. csr_lr_step_n R n)"

fun csr_r_step_n :: "csrs \<Rightarrow> nat \<Rightarrow> string rel"
where
  "csr_r_step_n R 0 = {}" |
  csr_r_step_n_Suc: "csr_r_step_n R (Suc n) =
    {(C\<llangle>l @ w\<rrangle>, C\<llangle>r @ w\<rrangle>) | C l r cs w.
      ((l, r), cs) \<in> R \<and> (\<forall> (s\<^sub>i, t\<^sub>i) \<in> set cs. (s\<^sub>i @ w, t\<^sub>i @ w) \<in> (csr_r_step_n R n)\<^sup>*)}"

definition "csr_r_step R = (\<Union>n. csr_r_step_n R n)"

lemma csr_step_iff:
  "(s, t) \<in> csr_step R \<longleftrightarrow> (\<exists>n. (s, t) \<in> csr_step_n R n)"
  by (auto simp: csr_step_def)

lemma csr_lr_step_iff:
  "(s, t) \<in> csr_lr_step R \<longleftrightarrow> (\<exists>n. (s, t) \<in> csr_lr_step_n R n)"
  by (auto simp: csr_lr_step_def)

lemma csr_r_step_iff:
  "(s, t) \<in> csr_r_step R \<longleftrightarrow> (\<exists>n. (s, t) \<in> csr_r_step_n R n)"
  by (auto simp: csr_r_step_def)

lemma csr_step_n_imp_cstep:
  assumes "(s, t) \<in> csr_step_n R n"
  shows "(s, t) \<in> csr_step R"
  using assms by (auto simp: csr_step_iff)

lemma csr_lr_step_n_imp_cstep:
  assumes "(s, t) \<in> csr_lr_step_n R n"
  shows "(s, t) \<in> csr_lr_step R"
  using assms by (auto simp: csr_lr_step_iff)

lemma csr_r_step_n_imp_cstep:
  assumes "(s, t) \<in> csr_r_step_n R n"
  shows "(s, t) \<in> csr_r_step R"
using assms by (auto simp: csr_r_step_iff)

lemma csr_steps_n_imp_csteps:
  assumes "(s, t) \<in> (csr_step_n R n)\<^sup>*"
  shows "(s, t) \<in> (csr_step R)\<^sup>*"
  using assms by (induct; auto dest: csr_step_n_imp_cstep)

lemma csr_lr_steps_n_imp_csteps:
  assumes "(s, t) \<in> (csr_lr_step_n R n)\<^sup>*"
  shows "(s, t) \<in> (csr_lr_step R)\<^sup>*"
  using assms by (induct; auto dest: csr_lr_step_n_imp_cstep)

lemma csr_r_steps_n_imp_csteps:
  assumes "(s, t) \<in> (csr_r_step_n R n)\<^sup>*"
  shows "(s, t) \<in> (csr_r_step R)\<^sup>*"
using assms by (induct; auto dest: csr_r_step_n_imp_cstep)

lemma csr_steps_n_subset_csteps:
  "(csr_step_n R n)\<^sup>* \<subseteq> (csr_step R)\<^sup>*"
  by (auto dest: csr_steps_n_imp_csteps)

lemma csr_lr_steps_n_subset_csteps:
  "(csr_lr_step_n R n)\<^sup>* \<subseteq> (csr_lr_step R)\<^sup>*"
  by (auto dest: csr_lr_steps_n_imp_csteps)

lemma csr_r_steps_n_subset_csteps:
  "(csr_r_step_n R n)\<^sup>* \<subseteq> (csr_r_step R)\<^sup>*"
  by (auto dest: csr_r_steps_n_imp_csteps)

lemma csr_step_n_SucI [Pure.intro?]:
  assumes "((l, r), cs) \<in> R"
    and "\<forall>(s\<^sub>i, t\<^sub>i) \<in> set cs. (s\<^sub>i, t\<^sub>i) \<in> (csr_step_n R n)\<^sup>*"
    and "s = C\<llangle>l\<rrangle> "
    and "t = C\<llangle>r\<rrangle>"
  shows "(s, t) \<in> csr_step_n R (Suc n)"
  using assms by auto

lemma csr_lr_step_n_SucI [Pure.intro?]:
  assumes "((l, r), cs) \<in> R"
    and "\<forall>(s\<^sub>i, t\<^sub>i) \<in> set cs. (D\<llangle>s\<^sub>i\<rrangle>, D\<llangle>t\<^sub>i\<rrangle>) \<in> (csr_lr_step_n R n)\<^sup>*"
    and "s = C\<llangle>D\<llangle>l\<rrangle>\<rrangle> "
    and "t = C\<llangle>D\<llangle>r\<rrangle>\<rrangle>"
  shows "(s, t) \<in> csr_lr_step_n R (Suc n)"
  using assms by fastforce

lemma csr_r_step_n_SucI [Pure.intro?]:
  assumes "((l, r), cs) \<in> R"
    and "\<forall>(s\<^sub>i, t\<^sub>i) \<in> set cs. (s\<^sub>i @ w, t\<^sub>i @ w) \<in> (csr_r_step_n R n)\<^sup>*"
    and "s = C\<llangle>l @ w\<rrangle> "
    and "t = C\<llangle>r @ w\<rrangle>"
  shows "(s, t) \<in> csr_r_step_n R (Suc n)"
  using assms by fastforce

lemma csr_step_n_SucE:
  assumes "(s, t) \<in> csr_step_n R (Suc n)"
  obtains C l r \<sigma> cs where "((l, r), cs) \<in> R"
    and "\<forall>(s\<^sub>i, t\<^sub>i) \<in> set cs. (s\<^sub>i, t\<^sub>i) \<in> (csr_step_n R n)\<^sup>*"
    and "s = C\<llangle>l\<rrangle>"
    and "t = C\<llangle>r\<rrangle>"
  using assms by auto

lemma csr_lr_step_n_SucE:
  assumes "(s, t) \<in> csr_lr_step_n R (Suc n)"
  obtains C D l r cs where "((l, r), cs) \<in> R"
    and "\<forall>(s\<^sub>i, t\<^sub>i) \<in> set cs. (D\<llangle>s\<^sub>i\<rrangle>, D\<llangle>t\<^sub>i\<rrangle>) \<in> (csr_lr_step_n R n)\<^sup>*"
    and "s = C\<llangle>D\<llangle>l\<rrangle>\<rrangle>"
    and "t = C\<llangle>D\<llangle>r\<rrangle>\<rrangle>"
  using assms by auto

lemma csr_r_step_n_SucE:
  assumes "(s, t) \<in> csr_r_step_n R (Suc n)"
  obtains C l r w cs where "((l, r), cs) \<in> R"
    and "\<forall>(s\<^sub>i, t\<^sub>i) \<in> set cs. (s\<^sub>i @ w, t\<^sub>i @ w) \<in> (csr_r_step_n R n)\<^sup>*"
    and "s = C\<llangle>l @ w\<rrangle>"
    and "t = C\<llangle>r @ w\<rrangle>"
  using assms by auto

lemma csr_step_n_Suc_mono:
  "csr_step_n R n \<subseteq> csr_step_n R (Suc n)"
proof (induct n)
  case (Suc n)
  show ?case
    using rtrancl_mono [OF Suc] by (auto elim!: csr_step_n_SucE intro!: csr_step_n_SucI, blast)
qed simp

lemma csr_lr_step_n_Suc_mono:
  "csr_lr_step_n R n \<subseteq> csr_lr_step_n R (Suc n)"
proof (induct n)
  case (Suc n)
  show ?case
    using rtrancl_mono [OF Suc] by (auto elim!: csr_lr_step_n_SucE intro!: csr_lr_step_n_SucI, blast)
qed simp

lemma csr_r_step_n_Suc_mono:
  "csr_r_step_n R n \<subseteq> csr_r_step_n R (Suc n)"
proof (induct n)
  case (Suc n)
  show ?case
    using rtrancl_mono [OF Suc] by (auto elim!: csr_r_step_n_SucE intro!: csr_r_step_n_SucI, blast)
qed simp

lemma csr_step_n_mono:
  assumes "i \<le> n"
  shows "csr_step_n R i \<subseteq> csr_step_n R n"
using assms
proof (induct "n - i" arbitrary: i)
  case (Suc k)
  hence "k = n - Suc i" and "Suc i \<le> n" by arith+
  hence "csr_step_n R (Suc i) \<subseteq> csr_step_n R n" using Suc.hyps by blast
  then show ?case 
    by (auto, meson csr_step_n_Suc_mono in_mono)
qed simp

lemma csr_lr_step_n_mono:
  assumes "i \<le> n"
  shows "csr_lr_step_n R i \<subseteq> csr_lr_step_n R n"
using assms
proof (induct "n - i" arbitrary: i)
  case (Suc k)
  hence "k = n - Suc i" and "Suc i \<le> n" by arith+
  hence "csr_lr_step_n R (Suc i) \<subseteq> csr_lr_step_n R n" using Suc.hyps by blast
  then show ?case 
    by (auto, meson csr_lr_step_n_Suc_mono in_mono)
qed simp

lemma csr_r_step_n_mono:
  assumes "i \<le> n"
  shows "csr_r_step_n R i \<subseteq> csr_r_step_n R n"
using assms
proof (induct "n - i" arbitrary: i)
  case (Suc k)
  hence "k = n - Suc i" and "Suc i \<le> n" by arith+
  hence "csr_r_step_n R (Suc i) \<subseteq> csr_r_step_n R n" using Suc.hyps by blast
  then show ?case 
    by (auto, meson csr_r_step_n_Suc_mono in_mono)
qed simp

lemma csr_steps_imp_csr_steps_n:
  assumes "(s, t) \<in> (csr_step R)\<^sup>*"
  shows "\<exists>n. (s, t) \<in> (csr_step_n R n)\<^sup>*"
  using assms csr_step_iff 
  by (induct, auto, meson csr_step_n_mono linorder_linear rtrancl.rtrancl_into_rtrancl rtrancl_mono subsetD)

lemma csr_lr_steps_imp_csr_lr_steps_n:
  assumes "(s, t) \<in> (csr_lr_step R)\<^sup>*"
  shows "\<exists>n. (s, t) \<in> (csr_lr_step_n R n)\<^sup>*"
  using assms csr_lr_step_iff 
  by (induct, auto, meson csr_lr_step_n_mono linorder_linear rtrancl.rtrancl_into_rtrancl rtrancl_mono subsetD) 

lemma csr_r_steps_imp_csr_r_steps_n:
  assumes "(s, t) \<in> (csr_r_step R)\<^sup>*"
  shows "\<exists>n. (s, t) \<in> (csr_r_step_n R n)\<^sup>*"
  using assms csr_r_step_iff 
  by (induct, auto, meson csr_r_step_n_mono linorder_linear rtrancl.rtrancl_into_rtrancl rtrancl_mono subsetD) 

lemma all_csr_step_imp_csr_step_n:
  assumes "\<forall>i < (k::nat). (s\<^sub>i i, t\<^sub>i i) \<in> (csr_step R)\<^sup>*"
  shows "\<exists>n. \<forall>i < k. (s\<^sub>i i, t\<^sub>i i) \<in> (csr_step_n R n)\<^sup>*" (is "\<exists>n. \<forall>i < k. ?P i n")  using assms 
proof -
  have "\<forall>i < k. \<exists>n\<^sub>i. ?P i n\<^sub>i"
    using assms by (auto intro: csr_steps_imp_csr_steps_n)
  then obtain f where *: "\<forall>i < k. ?P i (f i)" by metis
  define n where "n \<equiv> Max (set (map f [0 ..< k]))"
  have "\<forall>i < k. f i \<le> n" by (auto simp: n_def)
  then have "\<forall>i < k. ?P i n"
    using csr_step_n_mono [of "f i" n R for i, THEN rtrancl_mono] and * by blast
  then show ?thesis ..
qed

lemma all_csr_lr_step_imp_csr_lr_step_n:
  assumes "\<forall>i < (k::nat). (s\<^sub>i i, t\<^sub>i i) \<in> (csr_lr_step R)\<^sup>*"
  shows "\<exists>n. \<forall>i < k. (s\<^sub>i i, t\<^sub>i i) \<in> (csr_lr_step_n R n)\<^sup>*" (is "\<exists>n. \<forall>i < k. ?P i n")  using assms 
proof -
  have "\<forall>i < k. \<exists>n\<^sub>i. ?P i n\<^sub>i"
    using assms by (auto intro: csr_lr_steps_imp_csr_lr_steps_n)
  then obtain f where *: "\<forall>i < k. ?P i (f i)" by metis
  define n where "n \<equiv> Max (set (map f [0 ..< k]))"
  have "\<forall>i < k. f i \<le> n" by (auto simp: n_def)
  then have "\<forall>i < k. ?P i n"
    using csr_lr_step_n_mono [of "f i" n R for i, THEN rtrancl_mono] and * by blast
  then show ?thesis ..
qed

lemma all_csr_r_step_imp_csr_r_step_n:
  assumes "\<forall>i < (k::nat). (s\<^sub>i i, t\<^sub>i i) \<in> (csr_r_step R)\<^sup>*"
  shows "\<exists>n. \<forall>i < k. (s\<^sub>i i, t\<^sub>i i) \<in> (csr_r_step_n R n)\<^sup>*" (is "\<exists>n. \<forall>i < k. ?P i n")  using assms 
proof -
  have "\<forall>i < k. \<exists>n\<^sub>i. ?P i n\<^sub>i"
    using assms by (auto intro: csr_r_steps_imp_csr_r_steps_n)
  then obtain f where *: "\<forall>i < k. ?P i (f i)" by metis
  define n where "n \<equiv> Max (set (map f [0 ..< k]))"
  have "\<forall>i < k. f i \<le> n" by (auto simp: n_def)
  then have "\<forall>i < k. ?P i n"
    using csr_r_step_n_mono [of "f i" n R for i, THEN rtrancl_mono] and * by blast
  then show ?thesis ..
qed

lemma csr_stepI:
  assumes "((l, r), cs) \<in> R"
    and conds: "\<forall>(s\<^sub>i, t\<^sub>i) \<in> set cs. (s\<^sub>i, t\<^sub>i) \<in> (csr_step R)\<^sup>*"
  shows "(l, r) \<in> csr_step R" using assms 
proof -
  obtain n where "\<forall>(s\<^sub>i, t\<^sub>i) \<in> set cs. (s\<^sub>i, t\<^sub>i) \<in> (csr_step_n R n)\<^sup>*"
  using all_csr_step_imp_csr_step_n[of "length cs" "\<lambda>i. fst (cs ! i)" "\<lambda>i. snd (cs ! i)" R]
  and conds
    by (auto simp: all_set_conv_all_nth split_beta')
  then have "(l, r) \<in> csr_step_n R (Suc n)" using assms csr_step_n_SucI
    by (metis sctxt.cop_nil)
  then show ?thesis using csr_step_iff by blast
qed

lemma csr_lr_stepI:
  assumes "((l, r), cs) \<in> R"
    and conds: "\<forall>(s\<^sub>i, t\<^sub>i) \<in> set cs. (D\<llangle>s\<^sub>i\<rrangle>, D\<llangle>t\<^sub>i\<rrangle>) \<in> (csr_lr_step R)\<^sup>*"
  shows "(C\<llangle>D\<llangle>l\<rrangle>\<rrangle>, C\<llangle>D\<llangle>r\<rrangle>\<rrangle>) \<in> csr_lr_step R" using assms 
proof -
  obtain n where "\<forall>(s\<^sub>i, t\<^sub>i) \<in> set cs. (D\<llangle>s\<^sub>i\<rrangle>, D\<llangle>t\<^sub>i\<rrangle>) \<in> (csr_lr_step_n R n)\<^sup>*"
  using all_csr_lr_step_imp_csr_lr_step_n[of "length cs" "\<lambda>i. D\<llangle>fst (cs ! i)\<rrangle>" "\<lambda>i. D\<llangle>snd (cs ! i)\<rrangle>" R]
  and conds assms
  by (auto simp: all_set_conv_all_nth split_beta') 
  then have "(C\<llangle>D\<llangle>l\<rrangle>\<rrangle>, C\<llangle>D\<llangle>r\<rrangle>\<rrangle>) \<in> csr_lr_step_n R (Suc n)" using assms csr_lr_step_n_SucI 
    by blast
  then show ?thesis using csr_lr_step_iff by blast
qed

lemma csr_r_stepI:
  assumes "((l, r), cs) \<in> R"
    and conds: "\<forall>(s\<^sub>i, t\<^sub>i) \<in> set cs. (s\<^sub>i @ w, t\<^sub>i @ w) \<in> (csr_r_step R)\<^sup>*"
  shows "(C\<llangle>l @ w\<rrangle>, C\<llangle>r @ w\<rrangle>) \<in> csr_r_step R" using assms 
proof -
  obtain n where "\<forall>(s\<^sub>i, t\<^sub>i) \<in> set cs. (s\<^sub>i @ w, t\<^sub>i @ w) \<in> (csr_r_step_n R n)\<^sup>*"
  using all_csr_r_step_imp_csr_r_step_n[of "length cs" "\<lambda>i. fst (cs ! i) @ w" "\<lambda>i. snd (cs ! i) @ w" R]
  and conds assms
  by (auto simp: all_set_conv_all_nth split_beta') 
  then have "(C\<llangle>l @ w\<rrangle>, C\<llangle>r @ w\<rrangle>) \<in> csr_r_step_n R (Suc n)" using assms csr_r_step_n_SucI 
    by blast
  then show ?thesis using csr_r_step_iff by blast
qed

lemma csr_step_n_ctxt:
  assumes "(s, t) \<in> csr_step_n R n"
  shows "(C\<llangle>s\<rrangle>, C\<llangle>t\<rrangle>) \<in> csr_step_n R n" using assms
  by (cases n, auto, metis sctxt.cop_add, insert csr_step_n_SucE)

lemma csr_lr_step_n_ctxt:
  assumes "(s, t) \<in> csr_lr_step_n R n"
  shows "(C\<llangle>s\<rrangle>, C\<llangle>t\<rrangle>) \<in> csr_lr_step_n R n" using assms csr_lr_step_n_SucE
  by (cases n, auto, metis (no_types, lifting) sctxt.cop_add)

lemma csr_r_step_n_ctxt:
  assumes "(s, t) \<in> csr_r_step_n R n"
  shows "(C\<llangle>s\<rrangle>, C\<llangle>t\<rrangle>) \<in> csr_r_step_n R n" using assms csr_r_step_n_SucE
  by (cases n, auto, metis (no_types, lifting) sctxt.cop_add)

lemma csr_step_ctxt_closed:
  "sctxt.closed (csr_step R)"
  by (rule sctxt.closedI) (auto intro: csr_step_n_ctxt simp: csr_step_iff)

lemma csr_lr_step_ctxt_closed:
  "sctxt.closed (csr_lr_step R)"
  by (rule sctxt.closedI) (auto intro: csr_lr_step_n_ctxt simp: csr_lr_step_iff)

lemma csr_r_step_ctxt_closed:
  "sctxt.closed (csr_r_step R)"
  by (rule sctxt.closedI) (auto intro: csr_r_step_n_ctxt simp: csr_r_step_iff)

end
