section \<open>String Rewriting\<close>

theory String_Rewriting
  imports
   "HOL-Library.Sublist"
   TRS.Relation_Closure
   ShortLex
begin

text \<open>SRS (string rewriting system) is a set of string rewriting rules \<close>
type_synonym srule = "string \<times> string"
type_synonym srs  = "srule set"

inductive_set srstep :: "srs \<Rightarrow> srs" for R 
  where
    srstep: "\<And>bef aft. (l, r) \<in> R \<Longrightarrow> s = bef @ l @ aft \<Longrightarrow> t = bef @ r @ aft \<Longrightarrow> (s, t) \<in> srstep R"

lemmas srstepI = srstep.intros [intro]
lemmas srstepE = srstep.cases [elim]

lemma srstep_incl[simp]: "R \<subseteq> srstep R" 
proof(intro subrelI)
  fix l r
  assume "(l, r) \<in> R"
  then show "(l, r) \<in> srstep R" unfolding srstep.simps by blast
qed

lemma srstep_mono[simp]: "R \<subseteq> S \<Longrightarrow> srstep R \<subseteq> srstep S" by force

lemma srstep_union[simp]: "srstep (R \<union> S) = srstep R \<union> srstep S" by auto

lemma srstep_empty [simp]: "srstep {} = {}" by auto

lemma srstep_ID [simp]: "srstep Id = Id"
proof
  show "srstep Id \<subseteq> Id"
  proof(intro subrelI)
    fix s t
    assume "(s, t) \<in> srstep Id"
    then show "(s, t) \<in> Id" by auto
  qed
qed auto

lemma srstep_converse[simp]: "srstep (R\<inverse>) = (srstep R)\<inverse>" by auto

lemma srstep_closed[simp]:"srstep (srstep R) = srstep R" (is "?lhs = ?rhs")
proof 
  show "?lhs \<subseteq> ?rhs" unfolding srstep.simps
  proof(intro subrelI)
    fix s t
    assume "(s, t) \<in> srstep (srstep R)"
    hence "\<exists>bef1 aft1 l1 r1. (l1, r1) \<in> srstep R \<and> s = bef1 @ l1 @ aft1 \<and> t = bef1 @ r1 @ aft1" by blast
    then obtain bef1 aft1 l1 r1 where l1r1:"(l1, r1) \<in> srstep R" and s':"s = bef1 @ l1 @ aft1" and t':"t = bef1 @ r1 @ aft1" by auto
    from l1r1 have "\<exists>bef2 aft2 l r. (l, r) \<in> R \<and> l1 = bef2 @ l @ aft2 \<and> r1 = bef2 @ r @ aft2" by blast
    then obtain bef2 aft2 l r where lr:"(l, r) \<in> R" and l1:"l1 = bef2 @ l @ aft2" and r1:"r1 = bef2 @ r @ aft2" by auto
    have s:"s = bef1 @ bef2 @ l @ aft2 @ aft1" and t:"t = bef1 @ bef2 @ r @ aft2 @ aft1" 
      by (auto simp add:s' t' l1 r1) 
    show "(s, t) \<in> srstep R"
      by (simp add:s t srstepI, insert lr append_eq_appendI, blast) 
  qed
next
  show "?rhs \<subseteq> ?lhs"
  proof(intro subrelI)
    fix s t
    assume "(s, t) \<in> srstep R"
    then show "(s, t) \<in> srstep (srstep R)"
      using srstep_incl by blast
  qed
qed
  
lemma srstep_reflcl[simp]: "srstep (R\<^sup>=) = (srstep R)\<^sup>=" by simp
 
lemma srstep_symcl[simp]: "srstep (R\<^sup>\<leftrightarrow>) = (srstep R)\<^sup>\<leftrightarrow>"
proof
  show "srstep (R\<^sup>\<leftrightarrow>) \<subseteq> (srstep R)\<^sup>\<leftrightarrow>"
  proof(intro subrelI)
    fix s t
    assume "(s, t) \<in> srstep (R\<^sup>\<leftrightarrow>)"
    hence "\<exists>bef aft l r. (l, r) \<in> R\<^sup>\<leftrightarrow> \<and> s = bef @ l @ aft \<and> t = bef @ r @ aft" by blast
    then obtain bef aft l r where lr:"(l, r) \<in> R\<^sup>\<leftrightarrow>" and s:"s = bef @ l @ aft" and t:"t = bef @ r @ aft" by auto
    from lr show "(s, t) \<in> (srstep R)\<^sup>\<leftrightarrow>"
      by (cases "(l, r) \<in> R", insert s t, blast+)
  qed  
next
  show "(srstep R)\<^sup>\<leftrightarrow> \<subseteq> srstep (R\<^sup>\<leftrightarrow>)"
  proof(intro subrelI)
    fix s t
    assume "(s, t) \<in> (srstep R)\<^sup>\<leftrightarrow>"
    then show "(s, t) \<in> srstep (R\<^sup>\<leftrightarrow>)"
    proof
      assume "(s, t) \<in> (srstep R)\<inverse>"
      then show ?thesis by blast
    qed auto
  qed
qed

lemma srs_incl_conv[simp]: "(srstep (E \<union> R))\<^sup>\<leftrightarrow> O (srstep R)\<^sup>= \<subseteq> (srstep (E \<union> R))\<^sup>\<leftrightarrow>\<^sup>*"
proof(rule subrelI)
  fix l r
  assume "(l, r) \<in> (srstep (E \<union> R))\<^sup>\<leftrightarrow> O (srstep R)\<^sup>="
  then obtain u where lu:"(l, u) \<in> (srstep (E \<union> R))\<^sup>\<leftrightarrow>" and ur:"(u, r) \<in> (srstep R)\<^sup>=" by auto
  from ur show "(l, r) \<in> (srstep (E \<union> R))\<^sup>\<leftrightarrow>\<^sup>*"
  proof(cases "u = r")
    case True
    then show ?thesis using lu by blast
  next
    case False note F1 = this
    from lu show ?thesis
    proof(cases "(l, u) \<in> srstep (E \<union> R)")
      case True
      from ur have "(u, r) \<in> srstep (E \<union> R)" using F1 by auto
      then show ?thesis 
        by (meson True converse_rtrancl_into_rtrancl conversionI' r_into_rtrancl)
    next
      case False
      from ur have "(u, r) \<in> srstep (E \<union> R)" using F1 by auto
      then show ?thesis
        by (meson UnCI converse_rtrancl_into_rtrancl conversionI lu r_into_rtrancl)
    qed
  qed
qed

lemma srstep_sctxt [intro]: "(s, t) \<in> srstep R \<Longrightarrow> (C\<llangle>s\<rrangle>, C\<llangle>t\<rrangle>) \<in> srstep R"
proof -
  assume "(s, t) \<in> srstep R"
  hence "\<exists>bef aft l r. (l, r) \<in> R \<and> s = bef @ l @ aft \<and> t = bef @ r @ aft" by blast
  then obtain bef aft l r where lr:"(l, r) \<in> R" 
    and s:"s = bef @ l @ aft" and t:"t = bef @ r @ aft" by auto
  have "\<exists>bef' aft'. C\<llangle>s\<rrangle> = bef'@ s @ aft' \<and> C\<llangle>t\<rrangle> = bef'@ t @ aft'" 
    using sctxt_apply_string.simps
  proof(induct C)
    case Hole
    then show ?case using hole empty_append by metis
  next
    case (More x1 C x3)
    then show ?case  by (metis append_assoc)
  qed
  then obtain bef' aft' where cs:"C\<llangle>s\<rrangle> = bef'@ s @ aft'" and ct:"C\<llangle>t\<rrangle> = bef'@ t @ aft'" by blast
  then show "(C\<llangle>s\<rrangle>, C\<llangle>t\<rrangle>) \<in> srstep R" using append.assoc cs ct lr s t srstepI
    by metis
qed

lemma srsteps_closed_sctxt[simp]:
  assumes "(s, t) \<in> (srstep R)\<^sup>*"
  shows "(C\<llangle>s\<rrangle>, C\<llangle>t\<rrangle>) \<in> (srstep R)\<^sup>*" 
  using assms srstep_sctxt sctxt.closed_rtrancl
  by (simp add: sctxt.closedD sctxt.closedI)

lemma srsteps_sym_closed_sctxt[simp]:
  assumes "(s, t) \<in> (srstep R)\<^sup>\<leftrightarrow>\<^sup>*"
  shows "(C\<llangle>s\<rrangle>, C\<llangle>t\<rrangle>) \<in> (srstep R)\<^sup>\<leftrightarrow>\<^sup>*" 
  by (simp add: assms sctxt.closedD sctxt.closedI sctxt.closed_conversion srstep_sctxt)

lemma sclosed_trancl[simp]: "srstep ((srstep R)\<^sup>\<leftrightarrow>\<^sup>*) =  (srstep R)\<^sup>\<leftrightarrow>\<^sup>*"
proof
  show "srstep ((srstep R)\<^sup>\<leftrightarrow>\<^sup>*) \<subseteq> (srstep R)\<^sup>\<leftrightarrow>\<^sup>*"
  proof(rule subrelI)
    fix s t
    assume "(s, t) \<in> srstep ((srstep R)\<^sup>\<leftrightarrow>\<^sup>*)"
    hence "\<exists>l r bef aft. (l, r) \<in> (srstep R)\<^sup>\<leftrightarrow>\<^sup>* \<and> s = bef @ l @ aft \<and> t = bef @ r @ aft" by blast
    then obtain l r bef aft where lr:"(l, r) \<in> (srstep R)\<^sup>\<leftrightarrow>\<^sup>*" and s:"s = bef @ l @ aft" and t:"t = bef @ r @ aft" by auto
    let ?C = "More bef \<circle> aft"
    from srsteps_sym_closed_sctxt[OF lr, of ?C]
    show "(s, t) \<in> (srstep R)\<^sup>\<leftrightarrow>\<^sup>*"
      by (simp add: s t)
  qed
qed auto

lemma srstep_rule [intro]: "(l, r) \<in> R \<Longrightarrow> (l, r) \<in> srstep R"
  using srstep.srstep empty_append by blast

lemma sctxt_closed_srsteps [intro]: "sctxt.closed ((srstep R)\<^sup>*)" by blast
lemma sctxt_closed_srstep [intro]: "sctxt.closed (srstep R)" by blast

lemma srstep_eq_closure: "srstep R = sctxt.closure R"
proof (auto elim: sctxt.closure.cases)
  fix a b
  assume asm:"(a,b) \<in> srstep R"
  hence "\<exists>l r. (l, r) \<in> R" by (meson srstepE)
  then obtain l r where lr:"(l, r) \<in> R" 
    and "\<exists> bef aft. a = bef @ l @ aft \<and> b = bef @ r @aft" by (meson asm srstepE)
  then obtain bef aft where "a = bef @ l @ aft" and "b = bef @ r @aft" by auto
  then have "\<exists>C. a = C\<llangle>l\<rrangle> \<and> b = C\<llangle>r\<rrangle>" 
    using sctxt_apply_string.simps by metis
  then obtain C where a:"a = C\<llangle>l\<rrangle>" and b:"b = C\<llangle>r\<rrangle>" by auto
  from sctxt.closureI2[OF lr a b]
    show "(a, b) \<in> sctxt.closure R" by auto
qed

definition srstep_c_s :: "srs  \<Rightarrow> srs"
  where "srstep_c_s R = {(s,t) | s t rl C. rl \<in> R \<and> s = C\<llangle>fst rl\<rrangle> \<and> t = C\<llangle>snd rl\<rrangle>}"

lemma srstep_iff_srstep_r_s:
  "(s, t) \<in> srstep R \<longleftrightarrow> (s, t) \<in> srstep_c_s R" (is "?lhs = ?rhs")
proof
  assume asm:"(s, t) \<in> srstep R"
  hence "\<exists>l r. (l, r) \<in> R" by (meson srstepE)
  then obtain l r where lr:"(l, r) \<in> R" 
    and "\<exists> bef aft. s = bef @ l @ aft \<and> t = bef @ r @aft" by (meson asm srstepE)
  then obtain bef aft where "s = bef @ l @ aft" and "t = bef @ r @aft" by auto
  then have "\<exists>C. s = C\<llangle>l\<rrangle> \<and> t = C\<llangle>r\<rrangle>" 
    using sctxt_apply_string.simps by metis
  then obtain C where a:"s = C\<llangle>l\<rrangle>" and b:"t = C\<llangle>r\<rrangle>" by auto
  then show ?rhs unfolding srstep_c_s_def using lr by auto
next
  assume ?rhs
  then obtain l r C where rl:"(l, r) \<in> R" and s:"s = C\<llangle>l\<rrangle>" and t:"t = C\<llangle>r\<rrangle>" 
    unfolding srstep_c_s_def by auto
  then show ?lhs by auto
qed

lemma srstep_srstep_c_s_iff:
  "srstep R = srstep_c_s R" using srstep_iff_srstep_r_s by auto

lemma sctxt_closed_SN_on_sublist:
  assumes sc:"sctxt.closed R" and "SN_on R {t}" and sub:"sublist s t"
  shows "SN_on R {s}"
proof (rule ccontr)
  assume "\<not> SN_on R {s}"
  then obtain A where s:"A 0 = s" and A_chain:"\<forall>i. (A i,A (Suc i)) \<in> R"
    unfolding SN_on_def by best
  from sub have "\<exists>bef aft. t = bef @ s @ aft" 
    by (simp add: sublist_def)
  then obtain C where t:"t = C\<llangle>s\<rrangle>" using sctxt_apply_string.simps
    by metis
  let ?B = "\<lambda>i. C\<llangle>A i\<rrangle>"
  have "\<forall>i. (?B i,?B(Suc i)) \<in> R"
  proof
    fix i
    from A_chain have "(?B i,?B(Suc i)) \<in> sctxt.closure R" by fast
    then show "(?B i,?B(Suc i)) \<in> R" using sc by auto
  qed
  with s have "?B 0 = t \<and> (\<forall>i. (?B i,?B(Suc i)) \<in> R)" using t by simp
  then have "\<not> SN_on R {t}" unfolding SN_on_def by auto
  with assms show "False" by simp
qed

lemma sublist_preserves_SN_gen:
  assumes sctxt: "sctxt.closed R"
  and SN: "SN_on R {t}" and sslist: "strict_sublist s t"
  shows "SN_on R {s}"
proof -
  from sslist have "sublist s t" by auto
  then show ?thesis 
    using sctxt_closed_SN_on_sublist[OF sctxt SN, of s] by simp
qed

lemma sublist_preserves_SN:
  "SN_on (srstep R) {t} \<Longrightarrow> sublist s t \<Longrightarrow> SN_on (srstep R) {s}"
  using sublist_preserves_SN_gen strict_sublist_def by blast

end

