(*
Author: René Thiemann
*)

(* a parallel rewrite relation that restricts instantiation of variables,
   relevant for Toyama's refinement on joining parallel critical pairs *)

theory Par_Step_Var_Restricted
  imports 
    TRS.Trs
    TRS.Multihole_Context
begin

(* preparations *)

(* it is assumed that the context-positions are within the term *)
fun vars_below_hole :: "('f,'v)term \<Rightarrow> ('f,'v)mctxt \<Rightarrow> 'v set" where
  "vars_below_hole t MHole = vars_term t" 
| "vars_below_hole t (MVar y) = {}" 
| "vars_below_hole (Fun _ ts) (MFun _ Cs) = 
     \<Union> (set (map (\<lambda> (t,C). vars_below_hole t C) (zip ts Cs)))" 
| "vars_below_hole (Var _) (MFun _ _) = Code.abort (STR ''assumption in vars_below_hole violated'') (\<lambda> _. {})" 

lemma vars_below_hole_no_hole: "hole_poss C = {} \<Longrightarrow> vars_below_hole t C = {}" 
  by (induct t C rule: vars_below_hole.induct, auto simp: set_zip, blast)

lemma vars_below_hole_mctxt_of_term[simp]: "vars_below_hole t (mctxt_of_term u) = {}" 
  by (rule vars_below_hole_no_hole, auto)

lemma vars_below_hole_vars_term: "vars_below_hole t C \<subseteq> vars_term t" 
  by (induct t C rule: vars_below_hole.induct; force simp: set_zip set_conv_nth)

lemma vars_below_hole_subst[simp]: "vars_below_hole t (C \<cdot>mc \<sigma>) = vars_below_hole t C" 
  by (induct t C rule: vars_below_hole.induct; fastforce simp: set_zip)

lemma vars_below_hole_Fun: assumes "length ls = length Cs" 
  shows "vars_below_hole (Fun f ls) (MFun f Cs) = \<Union> {vars_below_hole (ls ! i) (Cs ! i) | i. i < length Cs}" 
  using assms by (auto simp: set_zip)  

lemma vars_below_hole_term_subst: 
  "hole_poss D \<subseteq> poss t \<Longrightarrow> vars_below_hole (t \<cdot> \<sigma>) D = \<Union> (vars_term ` \<sigma> ` vars_below_hole t D)"
proof (induct t D rule: vars_below_hole.induct)
  case (1 t)
  then show ?case by (auto simp: vars_term_subst)
next
  case (3 f ts g Cs)
  then show ?case by (fastforce simp: set_zip)
next
  case (4 x f Cs)
  hence hp: "hole_poss (MFun f Cs) = {}" by auto
  show ?case unfolding vars_below_hole_no_hole[OF hp] by auto
qed auto


lemma vars_below_hole_eqf: assumes "t =\<^sub>f (C, ts)"
  shows "vars_below_hole t C = \<Union> (vars_term ` set ts)" 
  using assms
proof (induct C arbitrary: t ts)
  case (MVar x)
  from eqf_MVarE[OF MVar(1)]  
  show ?case by auto
next
  case MHole
  from eqf_MHoleE[OF MHole(1)]
  show ?case by auto
next
  case (MFun f Cs t ss)
  from eqf_MFunE[OF MFun(2)] obtain ts sss where
    *: "t = Fun f ts" "length ts = length Cs" "length sss = length Cs" 
    "\<And> i. i < length Cs \<Longrightarrow> ts ! i =\<^sub>f (Cs ! i, sss ! i)"
    "ss = concat sss" by blast
  {
    fix i
    assume i: "i < length Cs" 
    hence mem: "Cs ! i \<in> set Cs" by auto
    from MFun(1)[OF mem *(4)[OF i]]
    have "vars_below_hole (ts ! i) (Cs ! i) = \<Union> (vars_term ` set (sss ! i))" .
  } note IH = this
  show ?case unfolding *(1) *(5) set_concat set_conv_nth[of sss] using IH *(2,3)
    by (auto simp: set_zip)
qed

(* The variable restricted parallel rewrite relation *)

definition "par_rstep_var_restr R V = {(s,t) | s t C infos. 
  (s, t) \<in> par_rstep_mctxt R C infos \<and> vars_below_hole t C \<inter> V = {}}" 

lemma par_rstep_var_restr_mono: assumes "R \<subseteq> S" "W \<subseteq> V" 
  shows "par_rstep_var_restr R V \<subseteq> par_rstep_var_restr S W" 
  unfolding par_rstep_var_restr_def using par_rstep_mctxt_mono[OF assms(1)] assms(2)
  by blast

lemma par_rstep_var_restr_refl[simp]: "(t, t) \<in> par_rstep_var_restr R V" 
  unfolding par_rstep_var_restr_def
  by (standard, intro exI conjI refl, force, rule par_rstep_mctxt_reflI, auto)

(* the most important property: a substitution step and a parallel step can be merged
   into a single parallel step *)
lemma merge_par_rstep_var_restr: 
  assumes subst_R: "\<And> x. (\<delta> x, \<gamma> x) \<in> par_rstep R" 
    and st: "(s, t) \<in> par_rstep_var_restr R V" 
    and subst_eq: "\<And> x. x \<notin> V \<Longrightarrow> \<delta> x = \<gamma> x"
  shows "(s \<cdot> \<delta>, t \<cdot> \<gamma>) \<in> par_rstep R"
proof -
  from st[unfolded par_rstep_var_restr_def] subst_eq
  obtain C infos where st: "(s, t) \<in> par_rstep_mctxt R C infos" 
    and subst_eq: "\<And> x. x \<in> vars_below_hole t C \<Longrightarrow> \<delta> x = \<gamma> x"
    by auto
  thus ?thesis  
  proof (induct C arbitrary: s t infos)
    case (MVar x)
    from par_rstep_mctxt_MVarE[OF this(1)]
    show ?case using subst_R by auto
  next
    case (MHole s t)
    have "(s,t) \<in> par_rstep R" 
      using MHole.prems(1) par_rstep_par_rstep_mctxt_conv by blast
    hence step: "(s \<cdot> \<delta>, t \<cdot> \<delta>) \<in> par_rstep R" 
      by (rule subst_closed_par_rstep)
    have "vars_below_hole t MHole = vars_term t" by simp
    with MHole(2) have t: "t \<cdot> \<delta> = t \<cdot> \<gamma>" by (auto intro: term_subst_eq)
    thus ?case using step by auto
  next
    case (MFun f Cs s t infos)
    let ?n = "length Cs" 
    let ?is = "[0..<?n]" 

    from par_rstep_mctxt_MFunD[OF MFun(2)]
    obtain ss ts Infos
      where s: "s = Fun f ss" 
        and t: "t = Fun f ts" 
        and len: "length ss = length Cs" 
        "length ts = length Cs"
        "length Infos = length Cs" 
        and infos: "infos = concat Infos" 
        and steps: "\<And> i. i<length Cs \<Longrightarrow> (ss ! i, ts ! i) \<in> par_rstep_mctxt R (Cs ! i) (Infos ! i)" 
      by blast
    {
      fix i
      assume i: "i < ?n"
      hence mem: "Cs ! i \<in> set Cs" by auto
      have IH: "(ss ! i \<cdot> \<delta>, ts ! i \<cdot> \<gamma>) \<in> par_rstep R" 
      proof (rule MFun(1)[OF mem steps[OF i]])
        fix x
        assume "x \<in> vars_below_hole (ts ! i) (Cs ! i)" 
        hence "x \<in> vars_below_hole t (MFun f Cs)" unfolding t using i len(2)
          by (auto simp: set_zip)
        from MFun(3)[OF this] show "\<delta> x = \<gamma> x" .
      qed
    }
    thus ?case unfolding s t using len(1-2) MFun(1-2) by auto
  qed
qed

text \<open>the variable restricted parallel rewrite relation is closed under variable renamings, 
  provided that the set of forbidden variables is also renamed (in the inverse way)\<close>
lemma par_rstep_var_restr_subst: 
  assumes "(s,t) \<in> par_rstep_var_restr R (\<gamma> ` V)" 
  and "\<And> x. \<sigma> x \<cdot> (Var o \<gamma>) = Var x" 
shows "(s \<cdot> \<sigma>, t \<cdot> \<sigma>) \<in> par_rstep_var_restr R V"
proof -
  from assms(1)[unfolded par_rstep_var_restr_def, simplified]
  obtain C infos where step: "(s, t) \<in> par_rstep_mctxt R C infos" and vars: "vars_below_hole t C \<inter> \<gamma> ` V = {}"
    by auto
  from step[unfolded par_rstep_mctxt_def, simplified] 
  have "t =\<^sub>f (C, par_rights infos)" by auto
  hence "hole_poss C \<subseteq> poss t" by (metis hole_poss_subset_poss)
  hence hp: "hole_poss (C \<cdot>mc \<sigma>) \<subseteq> poss t" 
    using hole_poss_subst by auto
  from par_rstep_mctxt_subst[OF step, of \<sigma>]
  have step: "(s \<cdot> \<sigma>, t \<cdot> \<sigma>) \<in> par_rstep_mctxt R (C \<cdot>mc \<sigma>) (map (\<lambda>i. i \<cdot>pi \<sigma>) infos)" .
  show "(s \<cdot> \<sigma>, t \<cdot> \<sigma>) \<in> par_rstep_var_restr R V" 
    unfolding par_rstep_var_restr_def
  proof (standard, intro exI conjI, rule refl, rule step)
    show "vars_below_hole (t \<cdot> \<sigma>) (C \<cdot>mc \<sigma>) \<inter> V = {}" 
      unfolding vars_below_hole_term_subst[OF hp] 
      unfolding vars_below_hole_subst
    proof (intro equals0I, elim IntE)
      fix x
      assume "x \<in> \<Union> (vars_term ` \<sigma> ` vars_below_hole t C)" 
      then obtain y where y: "y \<in> vars_below_hole t C" and x: "x \<in> vars_term (\<sigma> y)" by auto
      from y vars have y: "y \<notin> \<gamma> ` V" by auto
      assume "x \<in> V"
      with assms(2)[of y] y x show False unfolding o_def by (cases "\<sigma> y", auto)
    qed
  qed
qed


end