theory Right_Forward_Closure
  imports 
    Narrowing_Impl
begin

definition linear_ctxt :: "('f, 'v) ctxt \<Rightarrow> bool"
where
  "linear_ctxt C = linear_term (C \<langle> Fun undefined [] \<rangle>)"

lemma linear_ctxt_Hole[simp]: "linear_ctxt Hole" 
  unfolding linear_ctxt_def by (auto simp: is_partition_Nil)

lemma is_partition_append: "is_partition (xs @ ys) = (is_partition xs \<and> is_partition ys \<and> (\<Union> (set xs)) \<inter>  (\<Union> (set ys)) = {})" 
  by (induct xs, auto simp: is_partition_Cons is_partition_Nil)

lemma linear_ctxt_apply: "linear_term (C \<langle> t \<rangle>) = (linear_ctxt C \<and> linear_term t \<and> vars_ctxt C \<inter> vars_term t = {})" 
proof (induct C)
  case (More f bef C aft)
  let ?C = "More f bef C aft" 
  have "linear_term (?C \<langle> t \<rangle>) = (
     is_partition (map vars_term bef @ vars_term C\<langle>t\<rangle> # map vars_term aft) \<and>
     linear_term C\<langle>t\<rangle> \<and> (\<forall>x\<in>set bef \<union> set aft. linear_term x))"  (is "_ = (?A \<and> _ \<and> ?B)") by simp
  also have "linear_term C\<langle>t\<rangle> = (linear_ctxt C \<and> linear_term t \<and> vars_ctxt C \<inter> vars_term t = {})" 
    by (auto simp: More)
  also have "(?A \<and> \<dots> \<and> ?B) = (linear_ctxt ?C \<and> linear_term t \<and> vars_ctxt ?C \<inter> vars_term t = {})"
    by (simp add: is_partition_append is_partition_Cons linear_ctxt_def vars_term_ctxt_apply, auto)
  finally show ?case .
qed auto

lemma linear_subst_apply: "linear_term t \<Longrightarrow> (\<And> x. x \<in> vars_term t \<Longrightarrow> linear_term (\<sigma> x)) \<Longrightarrow> 
  (\<And> x y. x \<in> vars_term t \<Longrightarrow> y \<in> vars_term t \<Longrightarrow> x \<noteq> y \<Longrightarrow> vars_term (\<sigma> x) \<inter> vars_term (\<sigma> y) = {})
  \<Longrightarrow> linear_term (t \<cdot> \<sigma>)" 
proof (induction t)
  case (Fun f ts)
  show ?case proof (simp add: o_def, intro conjI ballI)
    fix t
    show "t \<in> set ts \<Longrightarrow> linear_term (t \<cdot> \<sigma>)" 
      by (rule Fun.IH, insert Fun.prems, auto)
  next
    show "is_partition (map (\<lambda>x. vars_term (x \<cdot> \<sigma>)) ts)" 
      unfolding is_partition_def length_map
    proof (intro allI impI)
      fix j i
      assume ij: "j < length ts" "i < j" 
      hence ijts: "i < length ts" "j < length ts" by auto
      from Fun.prems(1)
      have "is_partition (map vars_term ts)" by auto
      from this[unfolded is_partition_def] ij ijts
      have disj: "vars_term (ts ! i) \<inter> vars_term (ts ! j) = {}" by auto 
      have id: "map (\<lambda>x. vars_term (x \<cdot> \<sigma>)) ts ! i \<inter> map (\<lambda>x. vars_term (x \<cdot> \<sigma>)) ts ! j
        = vars_term (ts ! i \<cdot> \<sigma>) \<inter> vars_term (ts ! j \<cdot> \<sigma>)" using ijts by auto
      show "map (\<lambda>x. vars_term (x \<cdot> \<sigma>)) ts ! i \<inter> map (\<lambda>x. vars_term (x \<cdot> \<sigma>)) ts ! j = {}" 
        unfolding id unfolding vars_term_subst using disj Fun.prems(3) ijts
        by (auto simp: set_conv_nth) blast
    qed
  qed
qed auto

lemma vars_ctxt_subst:
  "vars_ctxt (C \<cdot>\<^sub>c \<sigma>) = \<Union>(vars_term ` \<sigma> ` vars_ctxt C)"
  by (induct C, auto simp: vars_term_subst)

lemma linear_ctxt_subst_apply: assumes lin: "linear_ctxt C"
  "(\<And> x. x \<in> vars_ctxt C \<Longrightarrow> linear_term (\<sigma> x))"
  "(\<And> x y. x \<in> vars_ctxt C \<Longrightarrow> y \<in> vars_ctxt C \<Longrightarrow> x \<noteq> y \<Longrightarrow> vars_term (\<sigma> x) \<inter> vars_term (\<sigma> y) = {})"
shows "linear_ctxt (C \<cdot>\<^sub>c \<sigma>)" 
proof -
  have id: "(C \<cdot>\<^sub>c \<sigma>)\<langle>Fun undefined []\<rangle> = (C\<langle>Fun undefined []\<rangle>) \<cdot> \<sigma>" by simp
  show ?thesis  unfolding linear_ctxt_def id
    by (intro linear_subst_apply, insert lin, auto simp: linear_ctxt_def vars_term_ctxt_apply)
qed

context 
  fixes nfs :: bool and Q :: "('f,string)terms" and R :: "('f, string) trs" 
  assumes R: "\<And> l r. (l,r) \<in> R \<Longrightarrow> linear_term r \<and> is_Fun l" 
begin
abbreviation narrows :: "('f,string)rule \<Rightarrow> pos \<Rightarrow> ('f,string)subst \<Rightarrow> ('f,string)trs" 
  where "narrows \<equiv> qnarrows_r_p_s nfs Q R" 

abbreviation rewr :: "('f,string)trs" where "rewr \<equiv> qrstep nfs Q R"

lemmas rewr_imp_qnarrows = qrstep_instance_imp_qnarrows[of _ _ _ nfs Q R]
lemmas narrows_def = qnarrows_r_p_s_def[of nfs Q R]

lemma narrows_linear: assumes narr: "(s,t) \<in> narrows rule p \<mu>" 
  and lin: "linear_term s" 
shows "linear_term t" 
proof -
  obtain l r where rule: "rule = (l,r)" by force
  define C where "C = ctxt_of_pos_term p s" 
  define sp where "sp = s |_ p" 
  from narr[unfolded rule narrows_def fst_conv snd_conv] obtain \<mu>2 where
   p: "p \<in> poss s" and lr: "(l,r) \<in> R" and mgu: "mgu_var_disjoint_string sp l = Some (\<mu>, \<mu>2)" 
   and t: "t = (ctxt_of_pos_term p (s \<cdot> \<mu>)) \<langle>r \<cdot> \<mu>2\<rangle>" 
    by (auto simp: C_def sp_def)
  from p have s: "s = C \<langle> sp \<rangle>" unfolding C_def sp_def by (simp add: ctxt_supt_id)
  from lin[unfolded s linear_ctxt_apply] R[OF lr]
  have lin: "linear_ctxt C" "linear_term sp" "vars_ctxt C \<inter> vars_term sp = {}" "linear_term r" by auto
  have "ctxt_of_pos_term p (s \<cdot> \<mu>) = C \<cdot>\<^sub>c \<mu>" unfolding C_def using p by (rule ctxt_of_pos_term_subst)
  with t have t: "t = (C \<cdot>\<^sub>c \<mu>) \<langle> r \<cdot> \<mu>2 \<rangle>" by simp
  show ?thesis unfolding t linear_ctxt_apply
  proof (intro conjI)
    show "linear_term (r \<cdot> \<mu>2)" 
    proof (rule linear_subst_apply[OF lin(4)])
      fix x y
      assume "x \<in> vars_term r" 
      show "linear_term (\<mu>2 x)" sorry
      show "y \<in> vars_term r \<Longrightarrow> x \<noteq> y \<Longrightarrow> vars_term (\<mu>2 x) \<inter> vars_term (\<mu>2 y) = {}" sorry
    qed
    show "linear_ctxt (C \<cdot>\<^sub>c \<mu>)" 
    proof (rule linear_ctxt_subst_apply[OF lin(1)])
      fix x y
      assume "x \<in> vars_ctxt C" 
      show "linear_term (\<mu> x)" sorry
      show "y \<in> vars_ctxt C \<Longrightarrow> x \<noteq> y \<Longrightarrow> vars_term (\<mu> x) \<inter> vars_term (\<mu> y) = {}" sorry
    qed
    show "vars_ctxt (C \<cdot>\<^sub>c \<mu>) \<inter> vars_term (r \<cdot> \<mu>2) = {}"
      unfolding vars_term_subst vars_ctxt_subst sorry
  qed
qed
end


value (code) "case mgu_var_disjoint_string (Fun ''f'' [Var ''u'', Var ''v'']) (Fun ''f'' [Var ''v'', Fun ''a'' []]) of Some (\<mu>, \<mu>2)
        \<Rightarrow> \<mu>2 ''v''"

value "qnarrows_impl (\<lambda> _. True) False [
  (Fun ''f'' [Fun ''g'' [Var ''x'', Var ''x'']], Fun ''h'' [Var ''x''])]
  (Fun ''k'' [Fun ''f'' [Var ''x''], Var ''y''])" 



end