theory Matrix_Core_Order
  imports 
    Linear_Polynomial
    Matrix_Base
    Monotone_Algebra
begin

locale core_mat_inter =   
  fixes n :: nat
  and \<delta> :: "'a :: {ring_1,zero_less_one,ordered_ab_group_add,ordered_semiring_1,Rings.ordered_semiring_0}" 
begin

sublocale squared_ring_mat n "\<lambda> x y. x - y \<ge> \<delta>"  .

abbreviation mat_add_mon :: "'a mat monoid" where 
  "mat_add_mon \<equiv> \<lparr>carrier = carrier_mat n n, mult = (+), one = 0\<^sub>m n n\<rparr>"

abbreviation mat_sq_ring :: "'a mat ring" where
  "mat_sq_ring \<equiv> ring_mat TYPE('a) n ()"  

definition sum_list_mat where "sum_list_mat \<equiv> list_prod mat_add_mon" 

lemma sum_list_mat_carrier[simp,intro]: "set as \<subseteq> carrier_mat n n \<Longrightarrow> sum_list_mat as \<in> carrier_mat n n" 
  unfolding sum_list_mat_def using wf_list_prod_gen[of mat_add_mon mat_add_mon as]
  by auto

lemma sum_list_mat_simps[simp]: "sum_list_mat [] = 0\<^sub>m n n" 
    "sum_list_mat (x # xs) = x + sum_list_mat xs" 
  unfolding sum_list_mat_def by auto

lemma sum_list_mat_N[intro]: "set as \<subseteq> N \<Longrightarrow> sum_list_mat as \<in> N" 
  by (induct as, auto simp: N_add_closed)


lemma sum_list_mat_append: "set as \<subseteq> carrier_mat n n \<Longrightarrow> set bs \<subseteq> carrier_mat n n \<Longrightarrow>
   sum_list_mat (as @ bs) = sum_list_mat as + sum_list_mat bs"
  by (induct as, auto)

lemma sum_list_split: assumes "set as \<subseteq> carrier_mat n n"
  and "i < length as" 
shows "sum_list_mat as = as ! i + sum_list_mat (take i as @ drop (Suc i) as)" 
proof -
  define bef where "bef = take i as" 
  define aft where "aft = drop (Suc i) as" 
  from assms have as: "as = bef @ as ! i # aft" 
    by (auto simp: id_take_nth_drop bef_def aft_def)
  have carr: "set bef \<subseteq> carrier_mat n n" "set aft \<subseteq> carrier_mat n n" "as ! i \<in> carrier_mat n n" 
    subgoal using assms by (subst (asm) as) auto
    subgoal using assms by (subst (asm) as) auto
    subgoal using assms by (subst (asm) as) auto
    done
  show ?thesis unfolding bef_def[symmetric] aft_def[symmetric]
    apply (subst as)
    apply (subst (1 2) sum_list_mat_append)
    by (insert carr, auto)
qed

context
  fixes II :: "'f \<times> nat \<Rightarrow> 'a mat list \<times> 'a mat" 
  and I :: "nat set" 
  and "typ" :: "'v itself" 
begin

definition alpha :: "'f \<Rightarrow> 'a mat list \<Rightarrow> 'a mat" ("\<alpha>") where 
  "\<alpha> f mats = (case II (f,length mats) of (cs, c) \<Rightarrow> 
     sum_list_mat (map2 (*) cs mats) + c)" 

interpretation mring: semiring mat_sq_ring by (rule Matrix.semiring_mat)

(* TODO: move sum_list_lpoly to LPoly-theory *)
definition sum_list_lpoly where
  "sum_list_lpoly = rec_list (zero_lpoly mat_sq_ring) (\<lambda> x _. sum_lpoly mat_sq_ring x)"

lemma sum_list_lpoly_simps[simp]: 
  "sum_list_lpoly [] = zero_lpoly mat_sq_ring" 
  "sum_list_lpoly (x # xs) = sum_lpoly mat_sq_ring x (sum_list_lpoly xs)" 
  unfolding sum_list_lpoly_def by auto

lemma wf_sum_list_lpoly[simp]: "Ball (set ps) (wf_lpoly mat_sq_ring) \<Longrightarrow> 
  wf_lpoly mat_sq_ring (sum_list_lpoly ps)"
proof (induct ps)
  case Nil
  show ?case by (auto simp: ring_mat_def wf_pvars_def)
next
  case (Cons p ps)
  thus ?case using mring.wf_sum_lpoly by auto
qed

lemma sum_list_lpoly: assumes "Ball (set ps) (wf_lpoly mat_sq_ring)" 
  and wf_ass: "wf_ass mat_sq_ring \<beta>" 
shows "mring.eval_lpoly \<beta> (sum_list_lpoly ps) = sum_list_mat (map (\<lambda> p. mring.eval_lpoly \<beta> p) ps)" 
  using assms(1)
proof (induct ps)
  case Nil
  show ?case using wf_ass by (simp add: ring_mat_simps)
next
  case (Cons p ps)
  thus ?case using wf_ass unfolding sum_list_lpoly_simps list.simps sum_list_mat_simps
    by (simp add: mring.sum_poly_sound ring_mat_simps)
qed

fun subst_lpoly :: "('w1 \<Rightarrow> ('w2,'a mat)l_poly) \<Rightarrow> ('w1,'a mat)l_poly \<Rightarrow> ('w2,'a mat)l_poly" where
  "subst_lpoly \<sigma> (LPoly c cs) = sum_lpoly mat_sq_ring (sum_list_lpoly 
    (map (\<lambda> (x,cx). mul_lpoly mat_sq_ring cx (\<sigma> x)) cs)) (c_lpoly c)"

lemma wf_subst_lpoly: assumes "\<forall> x. wf_lpoly mat_sq_ring (\<sigma> x)" 
  and "wf_lpoly mat_sq_ring p" 
shows "wf_lpoly mat_sq_ring (subst_lpoly \<sigma> p)" 
proof (cases p)
  case (LPoly c cs)
  from assms[unfolded this, simplified]
  have *: "c \<in> carrier_mat n n" "snd ` set cs \<subseteq> carrier_mat n n" 
    by (auto simp: ring_mat_simps wf_pvars_def)
  show ?thesis unfolding LPoly subst_lpoly.simps
    unfolding subst_lpoly_def using * assms
    by (fastforce intro!: mring.wf_sum_lpoly wf_sum_list_lpoly mring.wf_mul_lpoly simp: ring_mat_simps
        wf_pvars_def dest!: set_zip_rightD)
qed

lemma eval_subst_lpoly: assumes "\<forall> x. wf_lpoly mat_sq_ring (\<sigma> x)" 
  and "wf_lpoly mat_sq_ring p"
  and beta: "wf_ass mat_sq_ring \<beta>" 
shows "mring.eval_lpoly \<beta> (subst_lpoly \<sigma> p) = mring.eval_lpoly (\<lambda> x. mring.eval_lpoly \<beta> (\<sigma> x)) p" 
proof (cases p)
  case (LPoly c cs)
  from assms[unfolded this, simplified]
  have *: "c \<in> carrier_mat n n" "snd ` set cs \<subseteq> carrier_mat n n" 
    by (auto simp: ring_mat_simps wf_pvars_def)
  from * have c: "wf_lpoly mat_sq_ring (c_lpoly c)" 
    by (auto simp: ring_mat_simps wf_pvars_def)
  {
    fix x
    from assms have "wf_lpoly mat_sq_ring (\<sigma> x)" by auto
    hence "mring.eval_lpoly \<beta> (\<sigma> x) \<in> carrier_mat n n" using beta
      by (metis mring.wf_eval_lpoly ring_mat_simps(5))
  }
  hence beta': "wf_ass mat_sq_ring (\<lambda> x. mring.eval_lpoly \<beta> (\<sigma> x))" 
    unfolding wf_ass_def by (auto simp add: ring_mat_simps)
  have cc: "mring.eval_lpoly \<beta> (c_lpoly c) = c" using beta c
    by auto
  have sum: "sum_list_mat (map (mring.eval_lpoly \<beta> \<circ> (\<lambda>(x, cx). mul_lpoly mat_sq_ring cx (\<sigma> x))) cs)
    = mring.eval_pvars (\<lambda>x. mring.eval_lpoly \<beta> (\<sigma> x)) cs" (is "?P cs")
    using *(2)
  proof (induct cs)
    case Nil
    show ?case by (simp add: ring_mat_simps)
  next
    case (Cons xcx cs)
    then obtain x cx where xcx: "xcx = (x,cx)" by force
    with Cons(2) have cx: "cx \<in> carrier_mat n n" by auto
    from Cons have IH: "?P cs" by force
    show ?case unfolding xcx 
      apply (simp add: ring_mat_simps)
      apply (subst mring.mul_poly_sound[OF beta])
      subgoal using cx by (simp add: ring_mat_simps)
      subgoal using assms by auto
      apply (unfold ring_mat_simps)
      using IH by auto
  qed
  show ?thesis unfolding LPoly subst_lpoly.simps
    apply (subst mring.sum_poly_sound[OF beta _ c])
    subgoal by (rule wf_sum_list_lpoly, insert assms *, 
          auto intro!: mring.wf_mul_lpoly dest: set_zip_rightD simp: ring_mat_simps)
    apply (unfold ring_mat_simps cc)
    apply (subst sum_list_lpoly[OF _ beta])
    subgoal by (insert assms *, auto intro!: mring.wf_mul_lpoly dest: set_zip_rightD simp: ring_mat_simps)
    apply (simp add: ring_mat_simps)
    apply (unfold sum)
    apply (rule comm_add_mat[OF _ *(1)])    
    by (metis \<open>c \<in> carrier mat_sq_ring \<and> wf_pvars mat_sq_ring cs\<close> beta' mring.wf_eval_pvars ring_mat_simps(5))
qed

 
definition alphap :: "'f \<Rightarrow> ('v, 'a mat) l_poly list \<Rightarrow> ('v, 'a mat) l_poly" ("\<alpha>p") where
  "\<alpha>p f lps = (case II (f,length lps) of (cs, c) \<Rightarrow>
     sum_lpoly mat_sq_ring (sum_list_lpoly (map2 (mul_lpoly mat_sq_ring) cs lps)) (c_lpoly c))"

abbreviation poly_of where "poly_of t \<equiv> eval_term alphap t (var_lpoly mat_sq_ring)" 

definition NS\<^sub>E where "NS\<^sub>E = { (m1,m2) | m1 m2. {m1,m2} \<subseteq> E\<^sub>I I \<and> m1 - m2 \<in> N}" 
definition S\<^sub>E where "S\<^sub>E = { (m1,m2) | m1 m2. {m1,m2} \<subseteq> E\<^sub>I I \<and> m1 - m2 \<in> P\<^sub>I I}" 

definition NS\<^sub>M where "NS\<^sub>M = { (m1,m2) | m1 m2. {m1,m2} \<subseteq> M\<^sub>I I \<and> m1 - m2 \<in> N}" 
definition S\<^sub>M where "S\<^sub>M = { (m1,m2) | m1 m2. {m1,m2} \<subseteq> M\<^sub>I I \<and> m1 - m2 \<in> L\<^sub>I I}" 

definition oneE\<^sub>I :: "'a mat" where "oneE\<^sub>I = mat n n (\<lambda> (i,j). if i = j \<and> i \<in> I then 1 else 0)" 

definition switchE\<^sub>IN :: "('w,'a mat)l_poly \<Rightarrow> ('w,'a mat)l_poly" where
  "switchE\<^sub>IN p = subst_lpoly (\<lambda> x. sum_lpoly mat_sq_ring (var_lpoly mat_sq_ring x) (c_lpoly oneE\<^sub>I)) p" 

definition "sub_lpoly p q = sum_lpoly mat_sq_ring p (mul_lpoly mat_sq_ring (- 1\<^sub>m n) q)"

lemma oneE\<^sub>I_carrier[simp,intro]: "oneE\<^sub>I \<in> carrier_mat n n" unfolding oneE\<^sub>I_def by auto

lemma wf_switchE\<^sub>IN: assumes "wf_lpoly mat_sq_ring p" 
  shows "wf_lpoly mat_sq_ring (switchE\<^sub>IN p)" 
  unfolding switchE\<^sub>IN_def 
  by (rule wf_subst_lpoly[OF _ assms], auto intro!: mring.wf_sum_lpoly simp: ring_mat_simps wf_pvars_def)

lemma wf_sub_lpoly: "wf_lpoly mat_sq_ring p \<Longrightarrow> wf_lpoly mat_sq_ring q \<Longrightarrow> wf_lpoly mat_sq_ring (sub_lpoly p q)" 
  unfolding sub_lpoly_def
  by (intro mring.wf_sum_lpoly, force)
    (intro mring.wf_mul_lpoly, auto simp: ring_mat_simps)

lemma eval_sub_lpoly: assumes p: "wf_lpoly mat_sq_ring p" 
  and q: "wf_lpoly mat_sq_ring q" 
  and beta: "wf_ass mat_sq_ring \<beta>" 
shows "mring.eval_lpoly \<beta> (sub_lpoly p q) = mring.eval_lpoly \<beta> p - mring.eval_lpoly \<beta> q" 
proof -
  have p': "mring.eval_lpoly \<beta> p \<in> carrier_mat n n" using p beta 
    by (metis mring.wf_eval_lpoly ring_mat_simps(5))
  have q': "mring.eval_lpoly \<beta> q \<in> carrier_mat n n" using q beta 
    by (metis mring.wf_eval_lpoly ring_mat_simps(5))
  show ?thesis
    unfolding sub_lpoly_def
    apply (subst mring.sum_poly_sound[OF beta p])
    subgoal using q by (intro mring.wf_mul_lpoly, auto simp: ring_mat_simps)
    apply (unfold ring_mat_simps)
    apply (subst mring.mul_poly_sound[OF beta _ q])
    subgoal using q by (auto simp: ring_mat_simps)
    apply (unfold ring_mat_simps)
    by (intro eq_matI, insert p' q', auto)
qed

fun poly_of_rule_N where "poly_of_rule_N (l,r) = switchE\<^sub>IN (sub_lpoly (poly_of l) (poly_of r))"

definition inter_lpoly :: "'f \<times> nat \<Rightarrow> (nat, 'a mat)l_poly" where
  "inter_lpoly fk = (case II fk of (cs, c) \<Rightarrow> sum_lpoly mat_sq_ring (sum_list_lpoly (map2 (\<lambda> c x. mul_lpoly mat_sq_ring c (var_lpoly mat_sq_ring x)) cs [0..<length cs])) (c_lpoly c))" 

definition inter_lpoly_N :: "'f \<times> nat \<Rightarrow> (nat, 'a mat)l_poly" where
  "inter_lpoly_N = switchE\<^sub>IN o inter_lpoly" 

fun check_lpoly_generic :: "('a mat \<Rightarrow> bool) \<Rightarrow> ('w, 'a mat) l_poly \<Rightarrow> bool" where
  "check_lpoly_generic cond (LPoly c cs) = (cond c \<and> (\<forall> xci \<in> set cs. snd xci \<ge>\<^sub>m 0\<^sub>m n n))" 

definition check_lpoly_N_N :: "('w, 'a mat) l_poly \<Rightarrow> bool" where
  "check_lpoly_N_N = check_lpoly_generic (\<lambda> a. a \<ge>\<^sub>m 0\<^sub>m n n)" 

definition check_lpoly_N_E\<^sub>I :: "('w, 'a mat) l_poly \<Rightarrow> bool" where
  "check_lpoly_N_E\<^sub>I = check_lpoly_generic (\<lambda> a. a \<ge>\<^sub>m oneE\<^sub>I)" 

definition check_lpoly_N_P\<^sub>I :: "nat list \<Rightarrow> ('w, 'a mat) l_poly \<Rightarrow> bool" where
  "check_lpoly_N_P\<^sub>I Il = check_lpoly_generic (\<lambda> a. a \<ge>\<^sub>m 0\<^sub>m n n \<and> (\<exists> i \<in> set Il. \<exists> j \<in> set Il. a $$ (i,j) \<ge> \<delta>))"

definition default_II :: "'f \<times> nat \<Rightarrow> 'a mat list \<times> 'a mat" where
  "default_II fk = (let k = snd fk in (replicate k (1\<^sub>m n), (\<delta> + 1) \<cdot>\<^sub>m 1\<^sub>m n))"

definition II_list_to_II where 
  "II_list_to_II fk_cs fk = (case map_of fk_cs fk of None \<Rightarrow> default_II fk | Some i \<Rightarrow> i)" 

lemma default_II: assumes "default_II (f,k) = (cs, c)"
  shows "set cs \<subseteq> N \<and> length cs = k \<and> c \<in> carrier_mat n n" 
  using assms unfolding default_II_def
  by auto

lemma II_list_to_II_dim: assumes "II = II_list_to_II fk_cs" 
  and fk_cs: "\<And> f k cs c. ((f,k),(cs,c)) \<in> set fk_cs \<Longrightarrow> set cs \<subseteq> N \<and> length cs = k \<and> c \<in> carrier_mat n n"
  and II: "II (f,k) = (cs,c)" 
shows "set cs \<subseteq> N \<and> length cs = k \<and> c \<in> carrier_mat n n" 
proof (cases "map_of fk_cs (f,k)")
  case None
  hence "default_II (f,k) = (cs,c)" using assms unfolding II_list_to_II_def by auto
  from default_II[OF this] show ?thesis by auto
next
  case (Some pair)
  with II have "map_of fk_cs (f,k) = Some (cs,c)" unfolding assms II_list_to_II_def
    by auto
  hence "((f,k),(cs,c)) \<in> set fk_cs" by (rule map_of_SomeD)
  from fk_cs[OF this] show ?thesis .
qed

context (* syntactic shape of II is correct *)
  assumes IIpre: "\<forall> f k cs c. II (f,k) = (cs,c) \<longrightarrow> set cs \<subseteq> N \<and> length cs = k \<and> c \<in> carrier_mat n n" 
begin
lemmas II = IIpre[rule_format]
  
lemma wf_poly_of[simp,intro]: "wf_lpoly mat_sq_ring (poly_of t)" 
proof (induct t)
  case (Var x)
  show ?case by (auto intro!: mring.wf_var_lpoly)
next
  case (Fun f ts)
  obtain c cs where IIf: "II (f,length ts) = (cs,c)" by force
  from II[OF IIf] have *: "set cs \<subseteq> carrier_mat n n" "length cs = length ts" "c \<in> carrier_mat n n" 
    unfolding N_def by auto
  have pc: "wf_lpoly mat_sq_ring (c_lpoly c)" using *(3)
    by (auto simp: wf_pvars_def ring_mat_def)
  show ?case unfolding eval_term.simps 
    unfolding alphap_def[of f "(map poly_of ts)"] length_map IIf split
  proof (intro mring.wf_sum_lpoly[OF wf_sum_list_lpoly pc] ballI)
    fix p 
    assume "p \<in> set (map2 (mul_lpoly mat_sq_ring) cs (map poly_of ts))" 
    with *(2) obtain c t where "c \<in> set cs" "t \<in> set ts" and 
      p: "p = mul_lpoly mat_sq_ring c (poly_of t)" 
      by (force simp: set_conv_nth)
    from this(1-2) *(1) Fun have "c \<in> carrier_mat n n" "wf_lpoly mat_sq_ring (poly_of t)" 
      by auto
    from mring.wf_mul_lpoly[OF _ this(2)] this(1)
    show "wf_lpoly mat_sq_ring p" unfolding p by (auto simp: ring_mat_def)
  qed
qed

lemma eval_poly_of: assumes "range \<beta> \<subseteq> carrier_mat n n" 
  shows "eval_term \<alpha> t \<beta> = mring.eval_lpoly \<beta> (poly_of t)" 
proof -
  from assms have beta[simp]: "wf_ass mat_sq_ring \<beta>" 
    by (auto simp: wf_ass_def ring_mat_def)
  show ?thesis 
  proof (induct t)
    case (Var x)
    show ?case by simp
  next
    case (Fun f ts)
    obtain c cs where IIf: "II (f,length ts) = (cs,c)" by force
    from II[OF IIf] have *: "set cs \<subseteq> carrier_mat n n" "length cs = length ts" "c \<in> carrier_mat n n" 
      unfolding N_def by auto
    have c: "wf_lpoly mat_sq_ring (c_lpoly c)" using *
      by (auto simp: ring_mat_simps wf_pvars_def)
    define list where "list = map2 (mul_lpoly mat_sq_ring) cs (map poly_of ts)" 
    {
      fix p
      assume "p \<in> set list" 
      from this[unfolded list_def] *(2) obtain c t where "c \<in> set cs" "t \<in> set ts" and 
        p: "p = mul_lpoly mat_sq_ring c (poly_of t)" 
        by (force simp: set_conv_nth)
      from this(1-2) *(1) have "c \<in> carrier_mat n n" "wf_lpoly mat_sq_ring (poly_of t)" 
        by auto
      from mring.wf_mul_lpoly[OF _ this(2)] this(1)
      have "wf_lpoly mat_sq_ring p" unfolding p by (auto simp: ring_mat_def) 
    } note wf_list = this 
    have cc: "mring.eval_lpoly \<beta> (c_lpoly c) = c" using c by (auto simp add: ring_mat_simps)
    {
      fix i
      assume i: "i < length ts" 
      hence "ts ! i \<in> set ts" by auto
      from Fun[OF this]
      have "map2 (*) cs (map (\<lambda>s. \<alpha>\<lbrakk>s\<rbrakk>\<beta>) ts) ! i =
        map (mring.eval_lpoly \<beta>) (map2 (mul_lpoly mat_sq_ring) cs (map poly_of ts)) ! i" 
        using * i by (auto simp: o_def , subst mring.mul_poly_sound) (auto simp: ring_mat_simps)
    } note eq = this
    show ?case
      unfolding eval_term.simps alpha_def[of f] alphap_def[of f] length_map IIf split
      unfolding list_def[symmetric]
      apply (subst mring.sum_poly_sound[OF _ _ c], force)
      subgoal using wf_list by (intro wf_sum_list_lpoly, auto)
      apply (subst sum_list_lpoly[OF _ beta])
      subgoal using wf_list by auto
      apply (unfold ring_mat_simps list_def cc)
      apply (rule arg_cong[of _ _ "\<lambda> ls. sum_list_mat ls + c"])
      apply (intro nth_equalityI, force)
      subgoal for i using eq * by auto
      done
  qed
qed

lemma \<alpha>_append: assumes "Suc (length bef + length aft) = k" 
  and "length bef = i" 
  and "II (f,k) = (cs,c)" 
  and "{a,b} \<union> set bef \<union> set aft \<subseteq> carrier_mat n n" 
shows "\<alpha> f (bef @ a # aft) - \<alpha> f (bef @ b # aft) = cs ! i * (a - b)"
proof -
  from II[OF assms(3)]
  have *: "set cs \<subseteq> N" "length cs = k" "c \<in> carrier_mat n n" by auto
  from * assms have "i < k" by auto

  from * have **: "set cs \<subseteq> carrier_mat n n" unfolding N_def by auto
  have len: "Suc (length bef + length aft) = k" using assms by auto
  define list where "list = (\<lambda> a. map2 (*) cs (bef @ a # aft))" 
  have len': "length (list a) = k" for a unfolding list_def using * assms by auto
  define sum where "sum = (\<lambda> a. sum_list_mat (list a))"
  have list: "a \<in> carrier_mat n n \<Longrightarrow> set (list a) \<subseteq> carrier_mat n n" for a
    unfolding list_def
    apply (insert assms, auto intro!: mult_carrier_mat[of _ n n]) 
    subgoal using ** by (auto dest: set_zip_leftD)
    subgoal by (auto dest!: set_zip_rightD)
    done
  have sum: "a \<in> carrier_mat n n \<Longrightarrow> sum a \<in> carrier_mat n n" for a
    unfolding sum_def using list[of a] 
    by (rule sum_list_mat_carrier)

  have take: "take i (list b) = take i (list a)" unfolding list_def using assms(2) 
    by (intro nth_equalityI, auto simp: nth_append)
  have drop: "drop (Suc i) (list b) = drop (Suc i) (list a)" unfolding list_def using assms(2) *(2) \<open>i < k\<close>
    apply (intro nth_equalityI, force)
    by (auto simp: nth_append len)
  define both where "both = sum_list_mat (take i (list a) @ drop (Suc i) (list a))"
  have both: "both \<in> carrier_mat n n" 
    unfolding both_def
    apply (rule sum_list_mat_carrier)
    apply (rule subset_trans[OF _ list[of a]])    
    subgoal by (simp add: set_drop_subset set_take_subset)
    using assms by auto
  have listi: "list a ! i = cs ! i * a" for a unfolding list_def using * \<open>i < k\<close> assms(2) by auto
  have "cs ! i \<in> N" using * \<open>i < k\<close> assms(2) by auto
  hence csi: "cs ! i \<in> carrier_mat n n" unfolding N_def by auto
  from assms have ab: "a \<in> carrier_mat n n" "b \<in> carrier_mat n n" by auto
  from ab csi have listic: "list a ! i \<in> carrier_mat n n" "list b ! i \<in> carrier_mat n n" 
    unfolding listi by auto
  have "\<alpha> f (bef @ a # aft) - \<alpha> f (bef @ b # aft) = sum a + c - (sum b + c)" 
    unfolding alpha_def using len assms(3) split sum_def list_def by simp
  also have "\<dots> = sum a - sum b" using sum[of a] sum[of b] assms * by auto
  also have "\<dots> = list a ! i - list b ! i" 
    unfolding sum_def 
    apply (subst (1 2) sum_list_split[OF list, unfolded len', OF _ \<open>i < k\<close>])
    subgoal using assms by auto
    subgoal using assms by auto
    apply (unfold take drop)
    apply (unfold both_def[symmetric])
    using listic both by auto
  also have "\<dots> = cs ! i * (a - b)" unfolding listi using csi ab
    by (simp add: mult_minus_distrib_mat)
  finally show "\<alpha> f (bef @ a # aft) - \<alpha> f (bef @ b # aft) = cs ! i * (a - b)" by auto
qed

lemma wf_inter_lpoly: "wf_lpoly mat_sq_ring (inter_lpoly fk)"
proof -
  obtain f k where fk: "fk = (f,k)" by force
  obtain cs c where IIf: "II (f,k) = (cs,c)" by force
  from II[OF IIf] have *: "set cs \<subseteq> carrier_mat n n" "length cs = k" "c \<in> carrier_mat n n" 
    by (auto simp: N_def)
  show ?thesis unfolding inter_lpoly_def fk IIf split
    apply (intro mring.wf_sum_lpoly wf_sum_list_lpoly ballI) 
    subgoal for p using *
      by (auto intro!: mring.wf_mul_lpoly simp: ring_mat_simps dest: set_zip_leftD)
    subgoal using * by (auto simp: ring_mat_simps wf_pvars_def)
    done
qed

lemma wf_inter_lpoly_N: "wf_lpoly mat_sq_ring (inter_lpoly_N fk)"
  unfolding inter_lpoly_N_def o_def
  by (rule wf_switchE\<^sub>IN[OF wf_inter_lpoly])

context (* I is syntactic correct *)
  assumes I: "I \<subseteq> {..<n}" 
  and delta0: "\<delta> \<ge> 0" 
begin
lemma one_in_EI: "1\<^sub>m n \<in> E\<^sub>I I" 
  unfolding E\<^sub>I_def using I by auto

lemma oneE\<^sub>I: assumes "a \<in> E\<^sub>I I" 
  shows "\<exists> b \<in> N. a = b + oneE\<^sub>I" 
proof (intro bexI)
  from assms have a: "a \<in> carrier_mat n n" by (auto simp: N_def E\<^sub>I_def)
  show "a - oneE\<^sub>I \<in> N" using assms unfolding N_def E\<^sub>I_def 
    by (auto simp: minus_carrier_mat mat_ge_def oneE\<^sub>I_def)
  show "a = a - oneE\<^sub>I + oneE\<^sub>I" using a unfolding oneE\<^sub>I_def
    by auto
qed

lemma E\<^sub>I_N_closed: 
  assumes "a \<in> E\<^sub>I I" "b \<in> N"
  shows "a + b \<in> E\<^sub>I I"
proof -
  from assms have "a + b \<in> N" 
    by (simp add: E\<^sub>I_def N_add_closed)
  moreover
  {
    fix i
    assume i: "i \<in> I" 
    with I have i_n: "i < n" by auto
    hence id: "(a + b) $$ (i, i) = a $$ (i,i) + b $$ (i,i)" using assms
      by (auto simp: N_def E\<^sub>I_def)
    from assms[unfolded E\<^sub>I_def] i have a: "a $$ (i,i) \<ge> 1" by auto
    from assms[unfolded N_def] i_n have b: "b $$ (i,i) \<ge> 0" 
      by (auto simp: mat_ge_def)
    from a b have "1 \<le> (a + b) $$ (i, i)" unfolding id by (metis add_increasing2) 
  }
  ultimately show ?thesis unfolding E\<^sub>I_def
    by auto
qed

lemma P\<^sub>I_N_closed: 
  assumes "a \<in> P\<^sub>I I" "b \<in> N"
  shows "a + b \<in> P\<^sub>I I" 
proof -
  from assms have "a + b \<in> N" 
    by (simp add: P\<^sub>I_def N_add_closed)
  moreover 
  from assms(1)[unfolded P\<^sub>I_def] obtain i j where 
    ij: "i \<in> I" "j \<in> I" and a: "a $$ (i,j) \<ge> \<delta>" by auto
  from ij I have ij_n: "i < n" "j < n" by auto
  hence id: "(a + b) $$ (i,j) = a $$ (i,j) + b $$ (i,j)" using assms
    by (auto simp: N_def P\<^sub>I_def)
  from assms[unfolded N_def] ij_n have b: "b $$ (i,j) \<ge> 0" 
    by (auto simp: mat_ge_def)
  from a b have "(a + b) $$ (i,j) \<ge> \<delta>" unfolding id by (metis add_increasing2) 
  ultimately show ?thesis unfolding P\<^sub>I_def using ij
    by auto
qed

lemma check_lpoly_generic: assumes wf: "wf_lpoly mat_sq_ring p"
  and cond: "\<forall> a. a \<in> carrier_mat n n \<longrightarrow> cond a \<longrightarrow> a \<in> EPN"
  and EPN: "EPN \<in> {E\<^sub>I I, P\<^sub>I I, N}" 
  and check: "check_lpoly_generic cond p" 
shows "\<forall> \<gamma>. range \<gamma> \<subseteq> N \<longrightarrow> mring.eval_lpoly \<gamma> p \<in> EPN"
proof (intro impI allI, cases p)
  case (LPoly c xcs)
  from check[unfolded LPoly, simplified]
  have c1: "cond c" and xcs1: "\<And> xci. xci \<in>set xcs \<Longrightarrow> snd xci \<ge>\<^sub>m 0\<^sub>m n n" by auto
  from wf[unfolded LPoly, simplified, unfolded wf_pvars_def]
  have c2: "c \<in> carrier_mat n n" and xcs2: "\<And> xci. xci \<in>set xcs \<Longrightarrow> snd xci \<in> carrier_mat n n" 
    by (auto simp: ring_mat_def)
  from c1 c2 cond have c: "c \<in> EPN" by auto
  have xcs: "snd xci \<in> N" if "xci \<in> set xcs" for xci using xcs1[OF that] xcs2[OF that]
    unfolding N_def by simp
  fix \<gamma> :: "'b \<Rightarrow> _" 
  assume gam: "range \<gamma> \<subseteq> N"
  define d where "d = mring.eval_pvars \<gamma> xcs" 
  have d: "d \<in> N" unfolding d_def
    using xcs
  proof (induct xcs)
    case Nil
    show ?case by (auto simp: ring_mat_simps)
  next
    case (Cons xa xcs)
    obtain x a where xa: "xa = (x,a)" by force
    from Cons xa have a: "a \<in> N" by force
    from gam have x: "\<gamma> x \<in> N" by auto
    from a x have ax: "a * \<gamma> x \<in> N" by (rule N_mult_closed)
    from Cons xa have IH: "mring.eval_pvars \<gamma> xcs \<in> N" by auto
    show ?case unfolding xa mring.eval_pvars.simps ring_mat_simps using ax IH by (rule N_add_closed)
  qed
  have "mring.eval_lpoly \<gamma> p = c + d" 
    unfolding LPoly mring.eval_lpoly.simps ring_mat_simps d_def by auto
  also have "c + d \<in> EPN" 
  proof (cases "EPN = N")
    case True
    with c d show ?thesis by (auto simp: N_add_closed)
  next
    case False
    with EPN have "EPN = E\<^sub>I I \<or> EPN = P\<^sub>I I" by auto
    thus ?thesis
    proof
      assume "EPN = E\<^sub>I I" 
      with c d show ?thesis by (auto simp: E\<^sub>I_N_closed)
    next
      assume "EPN = P\<^sub>I I" 
      with c d show ?thesis by (auto simp: P\<^sub>I_N_closed)
    qed
  qed
  finally show "mring.eval_lpoly \<gamma> p \<in> EPN" .
qed

lemma check_lpoly_N_N: assumes wf: "wf_lpoly mat_sq_ring p" 
  and check: "check_lpoly_N_N p" 
shows "\<forall> \<gamma>. range \<gamma> \<subseteq> N \<longrightarrow> mring.eval_lpoly \<gamma> p \<in> N"
  by (rule check_lpoly_generic[OF wf _ _ check[unfolded check_lpoly_N_N_def]])
    (auto simp: N_def)

lemma in_E\<^sub>I_criterion: assumes a: "a \<in> carrier_mat n n"
  and a1: "a \<ge>\<^sub>m oneE\<^sub>I"
shows "a \<in> E\<^sub>I I"
proof -
  {
    fix i j
    assume ij: "i < n" "j < n" 
    with a a1 have a: "a $$ (i,j) \<ge> oneE\<^sub>I $$ (i,j)" unfolding mat_ge_def by auto
    from ij have "oneE\<^sub>I $$ (i,j) \<ge> 0" unfolding oneE\<^sub>I_def by auto
    with a have "a $$ (i,j) \<ge> 0" by auto
  } 
  with a have aN: "a \<in> N" unfolding N_def mat_ge_def by auto
  show ?thesis unfolding E\<^sub>I_def using aN assms I
    unfolding oneE\<^sub>I_def mat_ge_def by auto (smt (verit, best) lessThan_iff subsetD)
qed

lemma check_lpoly_N_E\<^sub>I: assumes wf: "wf_lpoly mat_sq_ring p" 
  and check: "check_lpoly_N_E\<^sub>I p" 
shows "\<forall> \<gamma>. range \<gamma> \<subseteq> N \<longrightarrow> mring.eval_lpoly \<gamma> p \<in> E\<^sub>I I"
  apply (rule check_lpoly_generic[OF wf _ _ check[unfolded check_lpoly_N_E\<^sub>I_def]])
  using in_E\<^sub>I_criterion by auto

lemma check_lpoly_N_P\<^sub>I: assumes wf: "wf_lpoly mat_sq_ring p" 
  and Il: "set Il = I" 
  and check: "check_lpoly_N_P\<^sub>I Il p" 
shows "\<forall> \<gamma>. range \<gamma> \<subseteq> N \<longrightarrow> mring.eval_lpoly \<gamma> p \<in> P\<^sub>I I"
  apply (rule check_lpoly_generic[OF wf _ _ check[unfolded check_lpoly_N_P\<^sub>I_def]])
   apply (unfold Il)
  by (auto simp: P\<^sub>I_def N_def)


lemma switchE\<^sub>IN: assumes "\<forall> \<gamma>. range \<gamma> \<subseteq> N \<longrightarrow> Prop (mring.eval_lpoly \<gamma> (switchE\<^sub>IN p))" 
  and p: "wf_lpoly mat_sq_ring p" 
  shows "\<forall> \<beta>. range \<beta> \<subseteq> E\<^sub>I I \<longrightarrow> Prop (mring.eval_lpoly \<beta> p)" 
proof (intro allI impI)
  fix \<beta> :: "'b \<Rightarrow> _" 
  assume "range \<beta> \<subseteq> E\<^sub>I I" 
  hence "\<forall> x. \<beta> x \<in> E\<^sub>I I" by auto
  with oneE\<^sub>I have "\<forall> x. \<exists> y. y \<in> N \<and> \<beta> x = y + oneE\<^sub>I" by auto
  from choice[OF this] obtain \<gamma> where ran: "range \<gamma> \<subseteq> N" and id: "\<And> x. \<beta> x = \<gamma> x + oneE\<^sub>I" by auto
  from ran have gam: "wf_ass mat_sq_ring \<gamma>" unfolding N_def wf_ass_def by (auto simp: ring_mat_simps)
  from assms ran have "Prop (mring.eval_lpoly \<gamma> (switchE\<^sub>IN p))" by auto
  also have "mring.eval_lpoly \<gamma> (switchE\<^sub>IN p) = mring.eval_lpoly \<beta> p" 
    unfolding switchE\<^sub>IN_def
    apply (subst eval_subst_lpoly[OF _ p gam])
    subgoal by (auto intro!: mring.wf_sum_lpoly simp: ring_mat_simps wf_pvars_def)
    apply (rule arg_cong[of _ _ "\<lambda> b. mring.eval_lpoly b p"])
    apply (intro ext)
    apply (unfold id)
    apply (subst mring.sum_poly_sound[OF gam])
    by (insert gam, auto simp: ring_mat_simps wf_pvars_def)
  finally show "Prop (mring.eval_lpoly \<beta> p)" .
qed

lemma inter_lpoly: assumes
  "\<forall> \<beta>. range \<beta> \<subseteq> E\<^sub>I I \<longrightarrow> mring.eval_lpoly \<beta> (inter_lpoly (f,k)) \<in> E\<^sub>I I" 
  and "length as = k" and "set as \<subseteq> E\<^sub>I I" 
shows "\<alpha> f as \<in> E\<^sub>I I" 
proof -
  obtain cs c where IIf: "II (f,k) = (cs,c)" by force
  from II[OF IIf] have *: "set cs \<subseteq> carrier_mat n n" "length cs = k" "c \<in> carrier_mat n n" 
    by (auto simp: N_def)
  define \<beta> where "\<beta> i = (if i < k then as ! i else 1\<^sub>m n)" for i
  from assms one_in_EI have beta: "range \<beta> \<subseteq> E\<^sub>I I" unfolding \<beta>_def by auto  
  with assms have inEI: "mring.eval_lpoly \<beta> (inter_lpoly (f,k)) \<in> E\<^sub>I I" by auto
  from beta have beta': "wf_ass mat_sq_ring \<beta>" unfolding wf_ass_def ring_mat_simps 
    by (auto simp: E\<^sub>I_def N_def)
  define list where "list = map2 (\<lambda>x y. mul_lpoly mat_sq_ring x (var_lpoly mat_sq_ring y)) cs [0..<length cs]" 
  have cc: "mring.eval_lpoly \<beta> (c_lpoly c) = c" using * by (auto simp add: ring_mat_simps)
  have c: "wf_lpoly mat_sq_ring (c_lpoly c)" using *
    by (auto simp: ring_mat_simps wf_pvars_def)
  {
    fix p
    assume "p \<in> set list" 
    from this[unfolded list_def] *(2) obtain c i where "c \<in> set cs" "i < k" and 
      p: "p = mul_lpoly mat_sq_ring c (var_lpoly mat_sq_ring i)" 
      by (force simp: set_conv_nth)
    from this(1-2) *(1) have "c \<in> carrier_mat n n" "wf_lpoly mat_sq_ring (var_lpoly mat_sq_ring i)" 
      by (auto simp: N_def)
    from mring.wf_mul_lpoly[OF _ this(2)] this(1)
    have "wf_lpoly mat_sq_ring p" unfolding p by (auto simp: ring_mat_def) 
  } note wf_list = this 
  have "mring.eval_lpoly \<beta> (inter_lpoly (f,k)) = \<alpha> f as" 
    unfolding inter_lpoly_def IIf split alpha_def assms
    unfolding list_def[symmetric]
    apply (subst mring.sum_poly_sound[OF beta' wf_sum_list_lpoly c])
    subgoal using wf_list by auto
    apply (unfold ring_mat_simps cc)
    apply (rule arg_cong[of _ _ "\<lambda> t. t + _"])
    apply (subst sum_list_lpoly[OF _ beta'])
    subgoal using wf_list by auto
    apply (rule arg_cong[of _ _ sum_list_mat])
    apply (unfold list_def)
    apply (intro nth_equalityI)
    subgoal using * assms by simp
    subgoal for i using assms * beta'
      apply simp
      by (subst mring.mul_poly_sound[OF beta'])
        (auto simp: ring_mat_simps \<beta>_def)
    done
  with inEI show ?thesis by auto
qed

lemma valid_interpretation_criterion: assumes
  "check_lpoly_N_E\<^sub>I (inter_lpoly_N (f, k))" 
  and "length as = k" and "set as \<subseteq> E\<^sub>I I" 
shows "\<alpha> f as \<in> E\<^sub>I I"
  apply (rule inter_lpoly[OF _ assms(2-3)])
  apply (rule switchE\<^sub>IN[OF _ wf_inter_lpoly])
  apply (rule check_lpoly_N_E\<^sub>I)
  apply (rule wf_switchE\<^sub>IN[OF wf_inter_lpoly])
  using assms(1) unfolding inter_lpoly_N_def o_def by auto

lemma II_list_to_II_EI: assumes "II = II_list_to_II fk_cs" 
  and fk_cs: "\<And> f c. (f,c) \<in> set fk_cs \<Longrightarrow> check_lpoly_N_E\<^sub>I (inter_lpoly_N f)"
shows "\<forall> as f. set as \<subseteq> E\<^sub>I I \<longrightarrow> \<alpha> f as \<in> E\<^sub>I I" 
proof (intro allI impI)
  fix as f
  assume as: "set as \<subseteq> E\<^sub>I I" 
  let ?k = "length as" 
  show "\<alpha> f as \<in> E\<^sub>I I" 
  proof (cases "map_of fk_cs (f,?k)")
    case (Some pair)
    then obtain cs c where map: "map_of fk_cs (f,?k) = Some (cs,c)" by force  
    hence II: "II (f,?k) = (cs,c)" unfolding assms II_list_to_II_def by auto
    from fk_cs[OF map_of_SomeD[OF map]] 
    have "check_lpoly_N_E\<^sub>I (inter_lpoly_N (f, ?k))" by auto
    from valid_interpretation_criterion[OF this _ as]
    show ?thesis by auto
  next
    case None
    hence II: "II (f,?k) = default_II (f,?k)" unfolding assms II_list_to_II_def by auto  
    define sum where "sum = sum_list_mat (map2 (*) (replicate (length as) (1\<^sub>m n)) as)" 
    let ?\<delta> = "\<delta> + 1" 
    {
      fix i
      assume "i < length as" 
      hence "as ! i \<in> E\<^sub>I I" using as by auto
      hence "as ! i \<in> N" unfolding E\<^sub>I_def by auto
      hence "1\<^sub>m n * as ! i \<in> N" unfolding N_def by auto
    } note asN = this
    hence sumN: "sum \<in> N" unfolding sum_def
      by (intro sum_list_mat_N, auto simp: set_conv_nth)
    have EI: "?\<delta> \<cdot>\<^sub>m 1\<^sub>m n \<in> E\<^sub>I I" unfolding E\<^sub>I_def N_def using delta0 I
      by auto
    have "\<alpha> f as = sum + ?\<delta> \<cdot>\<^sub>m 1\<^sub>m n" 
      unfolding alpha_def II split default_II_def Let_def snd_conv sum_def by auto
    also have "\<dots> \<in> E\<^sub>I I" using sumN EI
      by (metis E\<^sub>I_N_closed N_el_in_carr add_carrier_mat comm_add_mat oneE\<^sub>I oneE\<^sub>I_carrier)
    finally show ?thesis .
  qed
qed


lemma wf_poly_of_rule_N: "wf_lpoly mat_sq_ring (poly_of_rule_N lr)" 
  by (cases lr, auto intro!: wf_switchE\<^sub>IN wf_sub_lpoly)

lemma poly_of_rule_N: assumes "\<forall> \<gamma>. range \<gamma> \<subseteq> N \<longrightarrow> Prop (mring.eval_lpoly \<gamma> (poly_of_rule_N (l,r)))"
  shows "\<forall> \<beta>. range \<beta> \<subseteq> E\<^sub>I I \<longrightarrow> Prop (eval_term \<alpha> l \<beta> - eval_term \<alpha> r \<beta>)" 
proof (intro allI impI)
  fix \<beta> :: "'v \<Rightarrow> _" 
  assume beta: "range \<beta> \<subseteq> E\<^sub>I I" 
  hence beta': "wf_ass mat_sq_ring \<beta>" unfolding wf_ass_def by (auto simp: ring_mat_def E\<^sub>I_def N_def)
  have lr: "wf_lpoly mat_sq_ring (sub_lpoly (poly_of l) (poly_of r))" 
    by (intro wf_sub_lpoly, auto)
  from switchE\<^sub>IN[OF assms[unfolded poly_of_rule_N.simps] lr] beta
  have "Prop (mring.eval_lpoly \<beta> (sub_lpoly (poly_of l) (poly_of r)))" by auto
  also have "mring.eval_lpoly \<beta> (sub_lpoly (poly_of l) (poly_of r)) = eval_term \<alpha> l \<beta> - eval_term \<alpha> r \<beta>" 
    using beta'
    apply (subst eval_sub_lpoly, (auto)[3])
    apply (subst (1 2) eval_poly_of)
    by (insert beta', auto simp: wf_ass_def ring_mat_def)
  finally show "Prop (\<alpha>\<lbrakk>l\<rbrakk>\<beta> - \<alpha>\<lbrakk>r\<rbrakk>\<beta>)" .
qed

lemma N_plus_PI_is_PI: assumes "a \<in> N" "b \<in> P\<^sub>I I"
  shows "a + b \<in> P\<^sub>I I" 
proof -
  from assms[unfolded P\<^sub>I_def] obtain i j where 
    ij: "i \<in> I" "j \<in> I" and
    b: "b \<in> N" "b $$ (i,j) \<ge> \<delta>" by auto
  from ij I have ij': "i < n" "j < n" by auto
  have ab: "(a + b) $$ (i, j) = a $$ (i,j) + b $$ (i,j)" using assms b ij' unfolding N_def by auto
  from assms ij' have a0: "a $$ (i,j) \<ge> 0" by (metis N_compo_greater_eq_zero)
  have delt: "\<delta> \<le> (a + b) $$ (i, j)" using a0 b unfolding ab by (metis add_increasing)
  from assms b have abN: "a + b \<in> N" by (metis N_add_closed)
  show ?thesis unfolding P\<^sub>I_def using delt ij abN by auto
qed

lemma N_plus_LI_is_LI: assumes "a \<in> N" "b \<in> L\<^sub>I I"
  shows "a + b \<in> L\<^sub>I I" 
proof -
  from assms[unfolded L\<^sub>I_def] 
  have delt: "\<And> i. i \<in> I \<Longrightarrow> \<exists> j \<in> I. b $$ (i,j) \<ge> \<delta>" 
     and b: "b \<in> N" by auto
  from assms b have abN: "a + b \<in> N" by (metis N_add_closed)
  {
    fix i 
    assume i: "i \<in> I" 
    with delt obtain j where j: "j \<in> I" and delt: "b $$ (i,j) \<ge> \<delta>" by auto
    from i j I have ij': "i < n" "j < n" by auto
    from assms(1) ij' have a: "a $$ (i,j) \<ge> 0" unfolding N_def mat_ge_def by auto
    have ab: "(a + b) $$ (i, j) = a $$ (i,j) + b $$ (i,j)" using assms b ij' unfolding N_def by auto
    also have "\<dots> \<ge> 0 + \<delta>" using delt a by (metis plus_mono)
    finally have "\<exists> j \<in> I. (a + b) $$ (i,j) \<ge> \<delta>" using j by auto
  }
  thus ?thesis using abN unfolding L\<^sub>I_def by auto
qed

lemma E\<^sub>I_n: "a \<in> E\<^sub>I I \<Longrightarrow> a \<in> carrier_mat n n" 
  unfolding E\<^sub>I_def N_def by auto

lemma P\<^sub>I_n: "a \<in> P\<^sub>I I \<Longrightarrow> a \<in> carrier_mat n n" 
  unfolding P\<^sub>I_def N_def by auto

lemma M\<^sub>I_n: "a \<in> M\<^sub>I I \<Longrightarrow> a \<in> carrier_mat n n" 
  unfolding M\<^sub>I_def N_def by auto

lemma L\<^sub>I_n: "a \<in> L\<^sub>I I \<Longrightarrow> a \<in> carrier_mat n n" 
  unfolding L\<^sub>I_def N_def by auto

lemmas N_n = N_el_in_carr

lemma EI_PI_mult: assumes "a \<in> E\<^sub>I I" "b \<in> P\<^sub>I I" 
  shows "a * b \<in> P\<^sub>I I" 
proof -
  from assms[unfolded P\<^sub>I_def] 
  obtain i j where ij: "i \<in> I" "j \<in> I" and bN: "b \<in> N" and delt: "\<delta> \<le> b $$ (i, j)" by auto
  from assms[unfolded E\<^sub>I_def] ij have aN: "a \<in> N" and aii: "1 \<le> a $$ (i,i)" by auto  
  from aN bN have abN: "a * b \<in> N" by (rule N_mult_closed)
  from aN bN have ab: "a \<in> carrier_mat n n" "b \<in> carrier_mat n n" unfolding N_def by auto
  show ?thesis unfolding P\<^sub>I_def
  proof (clarify, intro conjI abN, rule bexI[OF _ ij(1)], rule bexI[OF _ ij(2)])
    from ij I have ij: "i < n" "j < n" by auto
    have "(a * b) $$ (i, j) = (\<Sum>k \<in> {0..<n}. a $$ (i, k) * b $$ (k, j))" 
      by (subst mat_mult_compo_alt[OF ab ij], auto)
    also have "\<dots> = a $$ (i, i) * b $$ (i, j) + (\<Sum>k \<in> {0..<n} - {i}. a $$ (i, k) * b $$ (k, j))" 
      by (subst sum.remove[of _ i], insert ij, auto)
    also have "\<dots> \<ge> 1 * \<delta> + 0" 
      apply (intro add_mono mult_mono sum_nonneg mult_nonneg_nonneg aii delta0 delt)
      by (insert aN bN ij, auto simp: N_def)
    finally show "\<delta> \<le> (a * b) $$ (i, j) - 0" by simp
  qed
qed

lemma MI_LI_mult: assumes "a \<in> M\<^sub>I I" "b \<in> L\<^sub>I I" 
  shows "a * b \<in> L\<^sub>I I" 
proof -
  from assms[unfolded L\<^sub>I_def M\<^sub>I_def] 
  have aN: "a \<in> N" and bN: "b \<in> N" by auto 
  from aN bN have abN: "a * b \<in> N" by (rule N_mult_closed)
  from aN bN have ab: "a \<in> carrier_mat n n" "b \<in> carrier_mat n n" unfolding N_def by auto
  show ?thesis unfolding L\<^sub>I_def
  proof (clarify, intro conjI abN, intro ballI)
    fix i
    assume i: "i \<in> I" 
    from assms[unfolded M\<^sub>I_def] i obtain k where k: "k \<in> I" and a: "a $$ (i,k) \<ge> 1" by auto
    from assms[unfolded L\<^sub>I_def] k obtain j where j: "j \<in> I" and b: "b $$ (k,j) \<ge> \<delta>" by auto
    from i j k I have ij: "i < n" "j < n" and k: "k < n" by auto
    have "(a * b) $$ (i, j) = (\<Sum>l \<in> {0..<n}. a $$ (i, l) * b $$ (l, j))" 
      by (subst mat_mult_compo_alt[OF ab ij], auto)
    also have "\<dots> = a $$ (i, k) * b $$ (k, j) + (\<Sum>l \<in> {0..<n} - {k}. a $$ (i, l) * b $$ (l, j))" 
      by (subst sum.remove[of _ k], insert ij k, auto)
    also have "\<dots> \<ge> 1 * \<delta> + 0" 
      apply (intro add_mono mult_mono sum_nonneg mult_nonneg_nonneg a delta0 b)
      by (insert aN bN ij k, auto simp: N_def)
    finally show "\<exists> j \<in> I. \<delta> \<le> (a * b) $$ (i, j) - 0" using j by auto
  qed
qed


context (* MI interpretation *)
  assumes SN: "SN {(x,y) . y \<ge> 0 \<and> x - y \<ge> \<delta>}"
  and \<alpha>M\<^sub>Ipre: "\<forall> as f. set as \<subseteq> M\<^sub>I I \<longrightarrow> \<alpha> f as \<in> M\<^sub>I I" 
  and Ine: "I \<noteq> {}" 
begin

lemmas \<alpha>M\<^sub>I = \<alpha>M\<^sub>Ipre[rule_format]  

interpretation MI: wf_algebra NS\<^sub>M S\<^sub>M "M\<^sub>I I" \<alpha> "typ" 
proof
  show "S\<^sub>M \<subseteq> NS\<^sub>M" unfolding S\<^sub>M_def NS\<^sub>M_def unfolding L\<^sub>I_def by auto
  show "refl_on (M\<^sub>I I) NS\<^sub>M" unfolding NS\<^sub>M_def 
    by (intro refl_onI, force simp: M\<^sub>I_def dest!: N_n)
  show "NS\<^sub>M O S\<^sub>M \<subseteq> S\<^sub>M" unfolding S\<^sub>M_def NS\<^sub>M_def
  proof (clarsimp, goal_cases) 
    case *: (1 x y z)
    have id: "x - z = (x - y) + (y - z)" using * by (auto dest!: M\<^sub>I_n)
    show ?case unfolding id using * N_plus_LI_is_LI by auto
  qed
  show "S\<^sub>M O NS\<^sub>M \<subseteq> S\<^sub>M" unfolding S\<^sub>M_def NS\<^sub>M_def
  proof (clarsimp, goal_cases)
    case *: (1 x y z)
    have id: "x - z = (y - z) + (x - y)" using * by (auto dest!: M\<^sub>I_n)
    show ?case unfolding id using * N_plus_LI_is_LI by auto
  qed
  show "trans_on (M\<^sub>I I) NS\<^sub>M" 
    unfolding trans_on_def NS\<^sub>M_def 
  proof (clarsimp, goal_cases)
    case *: (1 x y z)
    have id: "x - z = (x - y) + (y - z)" using * by (auto dest!: M\<^sub>I_n)
    show ?case unfolding id using * by (metis N_add_closed)
  qed    
  show "trans_on (M\<^sub>I I) S\<^sub>M" 
    unfolding trans_on_def S\<^sub>M_def 
  proof (clarsimp, goal_cases)
    case *: (1 x y z)
    have id: "x - z = (x - y) + (y - z)" using * by (auto dest!: M\<^sub>I_n)
    show ?case unfolding id using *
      by (intro N_plus_LI_is_LI[of "x - y" "y - z"], auto simp: L\<^sub>I_def)
  qed
  let ?gt = "(\<lambda>x y. \<delta> \<le> x - y)" 
  from delta0 have SN: "SN_one_mono_ordered_semiring_1 \<delta> ?gt" 
    apply (unfold_locales)
    subgoal by (metis dual_order.trans plus_right_mono uminus_add_conv_diff)
    subgoal by (smt (verit, best) add_diff_eq diff_add_cancel dual_order.trans plus_right_mono
          uminus_add_conv_diff)
    subgoal by (metis add_increasing diff_add_cancel order_refl order_trans)
    by (insert SN, auto) 
  have "SN S\<^sub>M"
    apply (intro SN_subset[OF SN_one_mono_ordered_semiring_1.mat_gt_SN[OF SN le_refl, of n]])
    apply (clarify, intro conjI)
  proof -
    fix a b
    assume "(a, b) \<in> S\<^sub>M" 
    from this[unfolded S\<^sub>M_def]
    have *: "a \<in> M\<^sub>I I" "b \<in> M\<^sub>I I" "a - b \<in> L\<^sub>I I" by auto
    show a: "a \<in> carrier_mat n n" using * by (auto dest: M\<^sub>I_n)
    show b: "b \<in> carrier_mat n n" using * by (auto dest: M\<^sub>I_n)
    show "b \<ge>\<^sub>m 0\<^sub>m n n" using *(2) unfolding M\<^sub>I_def N_def by auto
    from * have abN: "a - b \<in> N" unfolding L\<^sub>I_def by auto
    from Ine obtain i where "i \<in> I" by auto
    with * obtain j where "i \<in> I" "j \<in> I" and abdelt: "(a - b) $$ (i,j) \<ge> \<delta>" 
      unfolding L\<^sub>I_def by auto
    with I have ij: "i < n" "j < n" by auto
    show "Mat_gt a b" unfolding mat_gt_def
    proof (intro conjI exI)
      show "i < n" by fact
      show "j < n" by fact
      show "\<delta> \<le> a $$ (i, j) - b $$ (i, j)" using abdelt ij a b by auto
      show "a \<ge>\<^sub>m b" using a b abN
        by (meson N_el_in_carr N_greater_eq_zero mat_comparison_zero_eq)
    qed
  qed
  thus "SN_on S\<^sub>M (M\<^sub>I I)" by fast
  show "\<And>as f. set as \<subseteq> M\<^sub>I I \<Longrightarrow> \<alpha> f as \<in> M\<^sub>I I" by (rule \<alpha>M\<^sub>I)

  (* weak monotonicity *)
  fix a b bef aft f
  assume *: "a \<in> M\<^sub>I I" "b \<in> M\<^sub>I I" "set (bef @ aft) \<subseteq> M\<^sub>I I" "(a, b) \<in> NS\<^sub>M"
  obtain cs c where split: "II (f, Suc (length bef + length aft)) = (cs, c)" by force
  have cs: "cs ! length bef \<in> N" 
    using II[OF split] by auto
  from * have ab: "a - b \<in> N" unfolding NS\<^sub>M_def by auto
  have "\<alpha> f (bef @ a # aft) - \<alpha> f (bef @ b # aft) \<in> N" 
    apply (subst \<alpha>_append[OF refl refl split])
    subgoal using * M\<^sub>I_n by auto
    subgoal using cs ab by (rule N_mult_closed)
    done
  thus "(\<alpha> f (bef @ a # aft), \<alpha> f (bef @ b # aft)) \<in> NS\<^sub>M" 
    unfolding NS\<^sub>M_def using * \<alpha>M\<^sub>I by auto
qed

context
  assumes strictMonoPreM: "\<forall> f k cs c. II (f,k) = (cs,c) \<longrightarrow> set cs \<subseteq> M\<^sub>I I" 
begin

lemmas strictMonoM = strictMonoPreM[rule_format]

interpretation MI: mono_wf_algebra NS\<^sub>M S\<^sub>M "M\<^sub>I I" \<alpha> "typ" 
proof
  fix a b bef aft f
  assume *: "a \<in> M\<^sub>I I" "b \<in> M\<^sub>I I" "set (bef @ aft) \<subseteq> M\<^sub>I I" "(a, b) \<in> S\<^sub>M"
  obtain cs c where split: "II (f, Suc (length bef + length aft)) = (cs, c)" by force
  have cs: "cs ! length bef \<in> M\<^sub>I I"
    using strictMonoM[OF split] II[OF split] by auto
  from * have ab: "a - b \<in> L\<^sub>I I" unfolding S\<^sub>M_def by auto
  have "\<alpha> f (bef @ a # aft) - \<alpha> f (bef @ b # aft) \<in> L\<^sub>I I" 
    apply (subst \<alpha>_append[OF refl refl split])
    subgoal using * M\<^sub>I_n by auto
    subgoal using cs ab by (rule MI_LI_mult)
    done
  thus "(\<alpha> f (bef @ a # aft), \<alpha> f (bef @ b # aft)) \<in> S\<^sub>M" 
    unfolding S\<^sub>M_def using * \<alpha>M\<^sub>I by auto
qed
end (* MI strict mono interpretation *)
end (* MI interpretation *)


context (* EI interpretation *)
  assumes SN: "SN {(x,y) . y \<ge> 0 \<and> x - y \<ge> \<delta>}"
  and \<alpha>E\<^sub>Ipre: "\<forall> as f. set as \<subseteq> E\<^sub>I I \<longrightarrow> \<alpha> f as \<in> E\<^sub>I I" 
begin

lemmas \<alpha>E\<^sub>I = \<alpha>E\<^sub>Ipre[rule_format]  

interpretation EI: wf_algebra NS\<^sub>E S\<^sub>E "E\<^sub>I I" \<alpha> "typ" 
proof
  show "S\<^sub>E \<subseteq> NS\<^sub>E" unfolding S\<^sub>E_def NS\<^sub>E_def unfolding P\<^sub>I_def by auto
  show "refl_on (E\<^sub>I I) NS\<^sub>E" unfolding NS\<^sub>E_def 
    by (intro refl_onI, force simp: E\<^sub>I_def dest!: N_n)
  show "NS\<^sub>E O S\<^sub>E \<subseteq> S\<^sub>E" unfolding S\<^sub>E_def NS\<^sub>E_def
  proof (clarsimp, goal_cases) 
    case *: (1 x y z)
    have id: "x - z = (x - y) + (y - z)" using * by (auto dest!: E\<^sub>I_n)
    show ?case unfolding id using * N_plus_PI_is_PI by auto
  qed
  show "S\<^sub>E O NS\<^sub>E \<subseteq> S\<^sub>E" unfolding S\<^sub>E_def NS\<^sub>E_def
  proof (clarsimp, goal_cases)
    case *: (1 x y z)
    have id: "x - z = (y - z) + (x - y)" using * by (auto dest!: E\<^sub>I_n)
    show ?case unfolding id using * N_plus_PI_is_PI by auto
  qed
  show "trans_on (E\<^sub>I I) NS\<^sub>E" 
    unfolding trans_on_def NS\<^sub>E_def 
  proof (clarsimp, goal_cases)
    case *: (1 x y z)
    have id: "x - z = (x - y) + (y - z)" using * by (auto dest!: E\<^sub>I_n)
    show ?case unfolding id using * by (metis N_add_closed)
  qed    
  show "trans_on (E\<^sub>I I) S\<^sub>E" 
    unfolding trans_on_def S\<^sub>E_def 
  proof (clarsimp, goal_cases)
    case *: (1 x y z)
    have id: "x - z = (x - y) + (y - z)" using * by (auto dest!: E\<^sub>I_n)
    show ?case unfolding id using *
      by (intro N_plus_PI_is_PI[of "x - y" "y - z"], auto simp: P\<^sub>I_def)
  qed
  let ?gt = "(\<lambda>x y. \<delta> \<le> x - y)" 
  from delta0 have SN: "SN_one_mono_ordered_semiring_1 \<delta> ?gt" 
    apply (unfold_locales)
    subgoal by (metis dual_order.trans plus_right_mono uminus_add_conv_diff)
    subgoal by (smt (verit, best) add_diff_eq diff_add_cancel dual_order.trans plus_right_mono
          uminus_add_conv_diff)
    subgoal by (metis add_increasing diff_add_cancel order_refl order_trans)
    by (insert SN, auto) 
  have "SN S\<^sub>E"
    apply (intro SN_subset[OF SN_one_mono_ordered_semiring_1.mat_gt_SN[OF SN le_refl, of n]])
    apply (clarify, intro conjI)
  proof -
    fix a b
    assume "(a, b) \<in> S\<^sub>E" 
    from this[unfolded S\<^sub>E_def]
    have *: "a \<in> E\<^sub>I I" "b \<in> E\<^sub>I I" "a - b \<in> P\<^sub>I I" by auto
    show a: "a \<in> carrier_mat n n" using * by (auto dest: E\<^sub>I_n)
    show b: "b \<in> carrier_mat n n" using * by (auto dest: E\<^sub>I_n)
    show "b \<ge>\<^sub>m 0\<^sub>m n n" using *(2) unfolding E\<^sub>I_def N_def by auto
    from * have abN: "a - b \<in> N" unfolding P\<^sub>I_def by auto
    from * obtain i j where "i \<in> I" "j \<in> I" and abdelt: "(a - b) $$ (i,j) \<ge> \<delta>" 
      unfolding P\<^sub>I_def by auto
    with I have ij: "i < n" "j < n" by auto
    show "Mat_gt a b" unfolding mat_gt_def
    proof (intro conjI exI)
      show "i < n" by fact
      show "j < n" by fact
      show "\<delta> \<le> a $$ (i, j) - b $$ (i, j)" using abdelt ij a b by auto
      show "a \<ge>\<^sub>m b" using a b abN
        by (meson N_el_in_carr N_greater_eq_zero mat_comparison_zero_eq)
    qed
  qed
  thus "SN_on S\<^sub>E (E\<^sub>I I)" by fast
  show "\<And>as f. set as \<subseteq> E\<^sub>I I \<Longrightarrow> \<alpha> f as \<in> E\<^sub>I I" by (rule \<alpha>E\<^sub>I)

  (* weak monotonicity *)
  fix a b bef aft f
  assume *: "a \<in> E\<^sub>I I" "b \<in> E\<^sub>I I" "set (bef @ aft) \<subseteq> E\<^sub>I I" "(a, b) \<in> NS\<^sub>E"
  obtain cs c where split: "II (f, Suc (length bef + length aft)) = (cs, c)" by force
  have cs: "cs ! length bef \<in> N" 
    using II[OF split] by auto
  from * have ab: "a - b \<in> N" unfolding NS\<^sub>E_def by auto
  have "\<alpha> f (bef @ a # aft) - \<alpha> f (bef @ b # aft) \<in> N" 
    apply (subst \<alpha>_append[OF refl refl split])
    subgoal using * E\<^sub>I_n by auto
    subgoal using cs ab by (rule N_mult_closed)
    done
  thus "(\<alpha> f (bef @ a # aft), \<alpha> f (bef @ b # aft)) \<in> NS\<^sub>E" 
    unfolding NS\<^sub>E_def using * \<alpha>E\<^sub>I by auto
qed

lemma EI_ce_compat: assumes "II = II_list_to_II fk_cs" 
  and "I \<noteq> {}" 
  shows "ce_compatible EI.S_A" "ce_compatible EI.NS_A" 
proof -
  define M where "M = max_list (map (snd o fst) fk_cs)" 
  show "ce_compatible EI.S_A" unfolding ce_compatible_def
  proof (intro exI[of _ M] allI impI)
    fix m c
    assume m: "m \<ge> M" 
    {
      fix s t u :: "('f,'v)term" 
      assume u: "u \<in> {s,t}" 
      define comb where "comb = Fun c (t # s # replicate m (Var undefined))" 
      {
        fix \<beta> :: "'v \<Rightarrow> _" 
        assume beta: "range \<beta> \<subseteq> E\<^sub>I I" 
        {
          assume "II (c, Suc (Suc m)) \<noteq> default_II (c, Suc (Suc m))" 
          from this[unfolded assms II_list_to_II_def]
          have "Suc (Suc m) \<in> set (map (snd o fst) fk_cs)" 
            by (force split: option.splits dest!: map_of_SomeD)
          from max_list[OF this, folded M_def] m have False by auto
        }
        hence IIc: "II (c, Suc (Suc m)) = default_II (c, Suc (Suc m))" by auto  
        define v where "v = (if u = s then t else s)" 
        have evalE[simp]: "EI.eval t \<beta> \<in> E\<^sub>I I" for t
          by (meson EI.eval_A beta left_mult_one_mat)
        hence evalN: "EI.eval t \<beta> \<in> N" for t unfolding E\<^sub>I_def by auto
        hence evaln[simp]: "EI.eval t \<beta> \<in> carrier_mat n n" for t by (auto simp: N_def)
        have [simp]: "\<beta> x \<in> carrier_mat n n" "\<beta> x \<in> N" for x 
          using beta E\<^sub>I_n unfolding E\<^sub>I_def by blast+
        note [simp] = left_mult_one_mat[of _ n n]
        define repl where "repl = sum_list_mat (replicate m (\<beta> undefined))" 
        have replN: "repl \<in> N" unfolding repl_def
          by (intro sum_list_mat_N, auto)
        have [simp]: "repl \<in> carrier_mat n n" using replN unfolding N_def by auto
        let ?\<delta> = "\<delta> + 1" 
        define rest where "rest = EI.eval v \<beta> + repl + ?\<delta> \<cdot>\<^sub>m 1\<^sub>m n" 
        from I assms obtain i where i: "i \<in> I" "i < n" by auto
        have "?\<delta> \<cdot>\<^sub>m 1\<^sub>m n \<in> P\<^sub>I I" 
          unfolding P\<^sub>I_def using delta0 i(2)
          by (auto intro!: bexI[OF _ i(1)] simp: N_def)
        hence rest: "rest \<in> P\<^sub>I I" unfolding rest_def using replN evalN[of v] 
          using N_add_closed N_plus_PI_is_PI by presburger
        have restn[simp]: "rest \<in> carrier_mat n n" using rest by (rule P\<^sub>I_n)
        note [simp] = assoc_add_mat[of _ n n]
        note comm = comm_add_mat[of _ n n]
        have "EI.eval comb \<beta> = EI.eval t \<beta> + (EI.eval s \<beta> + repl) + ?\<delta> \<cdot>\<^sub>m 1\<^sub>m n" 
          by (simp add: alpha_def IIc default_II_def repl_def comb_def)
        also have "\<dots> = (EI.eval t \<beta> + EI.eval s \<beta>) + repl + ?\<delta> \<cdot>\<^sub>m 1\<^sub>m n" 
          by simp
        also have "\<dots> = EI.eval u \<beta> + EI.eval v \<beta> + repl + ?\<delta> \<cdot>\<^sub>m 1\<^sub>m n" 
          using u unfolding v_def by (cases "u = s", auto simp: comm) 
        also have "\<dots> = EI.eval u \<beta> + rest" by (simp add: rest_def)
        also have "\<dots> - EI.eval u \<beta> = rest" using evaln[of u] restn
          by (metis add_carrier_mat comm mat_add_eq_minus)
        also have "\<dots> \<in> P\<^sub>I I" by fact
        finally have "EI.eval comb \<beta> - EI.eval u \<beta> \<in> P\<^sub>I I" .
        note this evalE
      }
      hence "(comb, u) \<in> EI.S_A" unfolding EI.S_A_def unfolding S\<^sub>E_def by auto  
    } note main = this  
    show "ce_trs (c,m) \<subseteq> EI.S_A" unfolding ce_trs.simps using main by blast
  qed
  thus "ce_compatible EI.NS_A" using EI.S_A_imp_NS_A unfolding ce_compatible_def
    by blast
qed


lemma EI_S_criterion: 
  assumes "check_lpoly_N_P\<^sub>I Il (poly_of_rule_N lr)"  
  and "set Il = I" 
  shows "lr \<in> EI.S_A" 
proof -
  obtain l r where lr: "lr = (l,r)" by force
  show ?thesis unfolding lr EI.S_A_def unfolding S\<^sub>E_def
    using poly_of_rule_N[OF check_lpoly_N_P\<^sub>I[OF wf_poly_of_rule_N assms(2,1), unfolded lr]]
    by (auto simp add: EI.eval_A)
qed

lemma EI_NS_criterion: 
  assumes "check_lpoly_N_N (poly_of_rule_N lr)"  
  shows "lr \<in> EI.NS_A" 
proof -
  obtain l r where lr: "lr = (l,r)" by force
  show ?thesis unfolding lr EI.NS_A_def unfolding NS\<^sub>E_def
    using poly_of_rule_N[OF check_lpoly_N_N[OF wf_poly_of_rule_N assms, unfolded lr]]
    by (auto simp add: EI.eval_A)
qed

lemma EI_mat_order: assumes "I \<noteq> {}"
  and "II = II_list_to_II fk_cs" 
  shows "redtriple_order EI.S_A EI.NS_A EI.NS_A \<and> ce_compatible EI.NS_A" 
  by (intro conjI EI_ce_compat[of fk_cs] assms EI.redtriple_order)

lemma II_list_to_II_mono: assumes "II = II_list_to_II fk_cs" 
  and fk_cs: "\<And> f csc. (f,csc) \<in> set fk_cs \<Longrightarrow> Ball (set (fst csc)) (\<lambda> a. a \<ge>\<^sub>m oneE\<^sub>I)"
shows "\<forall>f k cs c. II (f, k) = (cs, c) \<longrightarrow> set cs \<subseteq> E\<^sub>I I"
proof (intro allI impI, standard)
  fix f k cs c d
  assume IIf: "II (f, k) = (cs, c)" and d: "d \<in> set cs" 
  thus "d \<in> E\<^sub>I I" 
  proof (cases "map_of fk_cs (f,k)")
    case None
    with d have d: "d = 1\<^sub>m n" using IIf[unfolded assms(1) II_list_to_II_def]
      by (auto simp: default_II_def)
    thus ?thesis using one_in_EI by blast
  next
    case (Some csc)
    from fk_cs[OF map_of_SomeD[OF this]] IIf[unfolded assms(1) II_list_to_II_def] d
    have "d \<ge>\<^sub>m oneE\<^sub>I" by (auto simp: Some)
    moreover from d II[OF IIf] have "d \<in> carrier_mat n n" unfolding N_def by auto
    ultimately show ?thesis by (metis in_E\<^sub>I_criterion)
  qed
qed


context
  assumes strictMonoPreE: "\<forall> f k cs c. II (f,k) = (cs,c) \<longrightarrow> set cs \<subseteq> E\<^sub>I I" 
begin

lemmas strictMonoE = strictMonoPreE[rule_format]

interpretation EI: mono_wf_algebra NS\<^sub>E S\<^sub>E "E\<^sub>I I" \<alpha> "typ" 
proof
  fix a b bef aft f
  assume *: "a \<in> E\<^sub>I I" "b \<in> E\<^sub>I I" "set (bef @ aft) \<subseteq> E\<^sub>I I" "(a, b) \<in> S\<^sub>E"
  obtain cs c where split: "II (f, Suc (length bef + length aft)) = (cs, c)" by force
  have cs: "cs ! length bef \<in> E\<^sub>I I"
    using strictMonoE[OF split] II[OF split] by auto
  from * have ab: "a - b \<in> P\<^sub>I I" unfolding S\<^sub>E_def by auto
  have "\<alpha> f (bef @ a # aft) - \<alpha> f (bef @ b # aft) \<in> P\<^sub>I I" 
    apply (subst \<alpha>_append[OF refl refl split])
    subgoal using * E\<^sub>I_n by auto
    subgoal using cs ab by (rule EI_PI_mult)
    done
  thus "(\<alpha> f (bef @ a # aft), \<alpha> f (bef @ b # aft)) \<in> S\<^sub>E" 
    unfolding S\<^sub>E_def using * \<alpha>E\<^sub>I by auto
qed

lemma EI_mono_mat_order: assumes "I \<noteq> {}"
  and "II = II_list_to_II fk_cs" 
  shows "mono_redtriple_order EI.S_A EI.NS_A EI.NS_A \<and> ce_compatible EI.S_A" 
  by (intro conjI EI_ce_compat[of fk_cs] assms EI.mono_redtriple_order)

end (* strictly monotone E_I *)
end (* E_I mode *)
end (* I is syntactic correct *)
end (* II is syntactic correct (n-dimensional matrices) *)
end (* II parameter *)

declare poly_of_rule_N.simps[simp del]
end (* locale fixing n and delta parameter *)

lemmas core_mat_inter_code =
  core_mat_inter.poly_of_rule_N.simps
  core_mat_inter.switchE\<^sub>IN_def
  core_mat_inter.subst_lpoly.simps
  core_mat_inter.oneE\<^sub>I_def
  core_mat_inter.sub_lpoly_def
  core_mat_inter.alphap_def
  core_mat_inter.sum_list_lpoly_def
  core_mat_inter.check_lpoly_N_P\<^sub>I_def
  core_mat_inter.check_lpoly_N_E\<^sub>I_def
  core_mat_inter.check_lpoly_N_N_def
  core_mat_inter.check_lpoly_generic.simps
  core_mat_inter.inter_lpoly_def
  core_mat_inter.inter_lpoly_N_def
  core_mat_inter.II_list_to_II_def
  core_mat_inter.default_II_def

declare core_mat_inter_code[code]

end (* theory *)

