{-# LANGUAGE EmptyDataDecls, RankNTypes, ScopedTypeVariables #-}

module
  Ceta(Nat, nat_of_integer, Char, Term, Sum(..), Lab, Sum_bot, Proof, Input,
        Answer, Cert_result(..), Property, Tp, Dpp, Ac_dpp, Tp_ops_ext,
        Dpp_ops_ext, Ac_tp_ops_ext, Ac_dpp_ops_ext, explode, version,
        certify_proof)
  where {

import Prelude ((==), (/=), (<), (<=), (>=), (>), (+), (-), (*), (/), (**),
  (>>=), (>>), (=<<), (&&), (||), (^), (^^), (.), ($), ($!), (++), (!!), Eq,
  error, id, return, not, fst, snd, map, filter, concat, concatMap, reverse,
  zip, null, takeWhile, dropWhile, all, any, Integer, negate, abs, divMod,
  String, Bool(True, False), Maybe(Nothing, Just));
import Data.Bits ((.&.), (.|.), (.^.));
import qualified Prelude;
import qualified Data.Bits;
import qualified Uint;
import qualified Array;
import qualified IArray;
import qualified Uint32;
import qualified Uint64;
import qualified Data_Bits;
import qualified Bit_Shifts;
import qualified Str_Literal;

newtype Int = Int_of_integer Integer;

integer_of_int :: Int -> Integer;
integer_of_int (Int_of_integer k) = k;

equal_int :: Int -> Int -> Bool;
equal_int k l = integer_of_int k == integer_of_int l;

instance Eq Int where {
  a == b = equal_int a b;
};

times_int :: Int -> Int -> Int;
times_int k l = Int_of_integer (integer_of_int k * integer_of_int l);

class Times a where {
  times :: a -> a -> a;
};

class (Times a) => Dvd a where {
};

instance Times Int where {
  times = times_int;
};

instance Dvd Int where {
};

uminus_int :: Int -> Int;
uminus_int k = Int_of_integer (negate (integer_of_int k));

zero_int :: Int;
zero_int = Int_of_integer (0 :: Integer);

less_int :: Int -> Int -> Bool;
less_int k l = integer_of_int k < integer_of_int l;

abs_int :: Int -> Int;
abs_int i = (if less_int i zero_int then uminus_int i else i);

class Abs a where {
  absa :: a -> a;
};

instance Abs Int where {
  absa = abs_int;
};

data Num = One | Bit0 Num | Bit1 Num;

one_int :: Int;
one_int = Int_of_integer (1 :: Integer);

class One a where {
  onea :: a;
};

instance One Int where {
  onea = one_int;
};

sgn_int :: Int -> Int;
sgn_int i =
  (if equal_int i zero_int then zero_int
    else (if less_int zero_int i then one_int else uminus_int one_int));

class Sgn a where {
  sgn :: a -> a;
};

instance Sgn Int where {
  sgn = sgn_int;
};

minus_int :: Int -> Int -> Int;
minus_int k l = Int_of_integer (integer_of_int k - integer_of_int l);

plus_int :: Int -> Int -> Int;
plus_int k l = Int_of_integer (integer_of_int k + integer_of_int l);

class Uminus a where {
  uminus :: a -> a;
};

class Minus a where {
  minusa :: a -> a -> a;
};

class Zero a where {
  zerob :: a;
};

class Plus a where {
  plus :: a -> a -> a;
};

class (Plus a) => Semigroup_add a where {
};

class (Semigroup_add a) => Cancel_semigroup_add a where {
};

class (Semigroup_add a) => Ab_semigroup_add a where {
};

class (Ab_semigroup_add a, Cancel_semigroup_add a,
        Minus a) => Cancel_ab_semigroup_add a where {
};

class (Semigroup_add a, Zero a) => Monoid_add a where {
};

class (Ab_semigroup_add a, Monoid_add a) => Comm_monoid_add a where {
};

class (Cancel_ab_semigroup_add a,
        Comm_monoid_add a) => Cancel_comm_monoid_add a where {
};

class (Times a, Zero a) => Mult_zero a where {
};

class (Times a) => Semigroup_mult a where {
};

class (Ab_semigroup_add a, Semigroup_mult a) => Semiring a where {
};

class (Comm_monoid_add a, Mult_zero a, Semiring a) => Semiring_0 a where {
};

class (Cancel_comm_monoid_add a, Semiring_0 a) => Semiring_0_cancel a where {
};

class (Semigroup_mult a) => Ab_semigroup_mult a where {
};

class (Ab_semigroup_mult a, Semiring a) => Comm_semiring a where {
};

class (Comm_semiring a, Semiring_0 a) => Comm_semiring_0 a where {
};

class (Comm_semiring_0 a,
        Semiring_0_cancel a) => Comm_semiring_0_cancel a where {
};

class (One a, Times a) => Power a where {
};

class (Semigroup_mult a, Power a) => Monoid_mult a where {
};

class (One a, Semigroup_add a) => Numeral a where {
};

class (Monoid_mult a, Numeral a, Semiring a) => Semiring_numeral a where {
};

class (One a, Zero a) => Zero_neq_one a where {
};

class (Semiring_numeral a, Semiring_0 a, Zero_neq_one a) => Semiring_1 a where {
};

class (Semiring_0_cancel a, Semiring_1 a) => Semiring_1_cancel a where {
};

class (Ab_semigroup_mult a, Monoid_mult a, Dvd a) => Comm_monoid_mult a where {
};

class (Comm_monoid_mult a, Comm_semiring_0 a,
        Semiring_1 a) => Comm_semiring_1 a where {
};

class (Comm_semiring_0_cancel a, Comm_semiring_1 a,
        Semiring_1_cancel a) => Comm_semiring_1_cancel a where {
};

class (Comm_semiring_1_cancel a) => Comm_semiring_1_cancel_crossproduct a where {
};

class (Semiring_0 a) => Semiring_no_zero_divisors a where {
};

class (Semiring_1 a,
        Semiring_no_zero_divisors a) => Semiring_1_no_zero_divisors a where {
};

class (Semiring_no_zero_divisors a) => Semiring_no_zero_divisors_cancel a where {
};

class (Cancel_semigroup_add a, Minus a, Monoid_add a,
        Uminus a) => Group_add a where {
};

class (Cancel_comm_monoid_add a, Group_add a) => Ab_group_add a where {
};

class (Ab_group_add a, Semiring_0_cancel a) => Ring a where {
};

class (Ring a,
        Semiring_no_zero_divisors_cancel a) => Ring_no_zero_divisors a where {
};

class (Group_add a, Numeral a) => Neg_numeral a where {
};

class (Neg_numeral a, Ring a, Semiring_1_cancel a) => Ring_1 a where {
};

class (Ring_1 a, Ring_no_zero_divisors a,
        Semiring_1_no_zero_divisors a) => Ring_1_no_zero_divisors a where {
};

class (Comm_semiring_0_cancel a, Ring a) => Comm_ring a where {
};

class (Comm_ring a, Comm_semiring_1_cancel a, Ring_1 a) => Comm_ring_1 a where {
};

class (Comm_semiring_1_cancel a,
        Semiring_1_no_zero_divisors a) => Semidom a where {
};

class (Comm_ring_1 a, Ring_1_no_zero_divisors a, Semidom a,
        Comm_semiring_1_cancel_crossproduct a) => Idom a where {
};

instance Plus Int where {
  plus = plus_int;
};

instance Semigroup_add Int where {
};

instance Cancel_semigroup_add Int where {
};

instance Ab_semigroup_add Int where {
};

instance Minus Int where {
  minusa = minus_int;
};

instance Cancel_ab_semigroup_add Int where {
};

instance Zero Int where {
  zerob = zero_int;
};

instance Monoid_add Int where {
};

instance Comm_monoid_add Int where {
};

instance Cancel_comm_monoid_add Int where {
};

instance Mult_zero Int where {
};

instance Semigroup_mult Int where {
};

instance Semiring Int where {
};

instance Semiring_0 Int where {
};

instance Semiring_0_cancel Int where {
};

instance Ab_semigroup_mult Int where {
};

instance Comm_semiring Int where {
};

instance Comm_semiring_0 Int where {
};

instance Comm_semiring_0_cancel Int where {
};

instance Power Int where {
};

instance Monoid_mult Int where {
};

instance Numeral Int where {
};

instance Semiring_numeral Int where {
};

instance Zero_neq_one Int where {
};

instance Semiring_1 Int where {
};

instance Semiring_1_cancel Int where {
};

instance Comm_monoid_mult Int where {
};

instance Comm_semiring_1 Int where {
};

instance Comm_semiring_1_cancel Int where {
};

instance Comm_semiring_1_cancel_crossproduct Int where {
};

instance Semiring_no_zero_divisors Int where {
};

instance Semiring_1_no_zero_divisors Int where {
};

instance Semiring_no_zero_divisors_cancel Int where {
};

instance Uminus Int where {
  uminus = uminus_int;
};

instance Group_add Int where {
};

instance Ab_group_add Int where {
};

instance Ring Int where {
};

instance Ring_no_zero_divisors Int where {
};

instance Neg_numeral Int where {
};

instance Ring_1 Int where {
};

instance Ring_1_no_zero_divisors Int where {
};

instance Comm_ring Int where {
};

instance Comm_ring_1 Int where {
};

instance Semidom Int where {
};

instance Idom Int where {
};

less_eq_int :: Int -> Int -> Bool;
less_eq_int k l = integer_of_int k <= integer_of_int l;

class Ord a where {
  less_eq :: a -> a -> Bool;
  less :: a -> a -> Bool;
};

class (Abs a, Minus a, Uminus a, Zero a, Ord a) => Abs_if a where {
};

instance Ord Int where {
  less_eq = less_eq_int;
  less = less_int;
};

instance Abs_if Int where {
};

class (Semiring_1 a) => Semiring_char_0 a where {
};

class (Semiring_char_0 a, Ring_1 a) => Ring_char_0 a where {
};

instance Semiring_char_0 Int where {
};

instance Ring_char_0 Int where {
};

class (Ord a) => Quasi_order a where {
};

class (Quasi_order a) => Weak_order a where {
};

class (Ord a) => Preorder a where {
};

class (Preorder a, Weak_order a) => Order a where {
};

instance Quasi_order Int where {
};

instance Weak_order Int where {
};

instance Preorder Int where {
};

instance Order Int where {
};

ceq_int :: Maybe (Int -> Int -> Bool);
ceq_int = Just equal_int;

class Ceq a where {
  ceq :: Maybe (a -> a -> Bool);
};

instance Ceq Int where {
  ceq = ceq_int;
};

newtype Phantom a b = Phantom b;

data Set_impla = Set_Choose | Set_Collect | Set_DList | Set_RBT | Set_Monada;

set_impl_int :: Phantom Int Set_impla;
set_impl_int = Phantom Set_RBT;

class Set_impl a where {
  set_impl :: Phantom a Set_impla;
};

instance Set_impl Int where {
  set_impl = set_impl_int;
};

class (Order a) => Linorder a where {
};

instance Linorder Int where {
};

class (Abs a, Sgn a, Idom a) => Idom_abs_sgn a where {
};

instance Idom_abs_sgn Int where {
};

class (Ab_semigroup_add a, Order a) => Ordered_ab_semigroup_add a where {
};

class (Ordered_ab_semigroup_add a) => Strict_ordered_ab_semigroup_add a where {
};

class (Cancel_ab_semigroup_add a,
        Strict_ordered_ab_semigroup_add a) => Ordered_cancel_ab_semigroup_add a where {
};

class (Semigroup_mult a, Order a,
        Mult_zero a) => Ordered_semigroup_mult_zero a where {
};

class (Comm_monoid_add a,
        Ordered_ab_semigroup_add a) => Ordered_comm_monoid_add a where {
};

class (Ordered_comm_monoid_add a, Semiring a) => Ordered_semiring a where {
};

class (Ordered_semigroup_mult_zero a, Ordered_semiring a,
        Semiring_0 a) => Ordered_semiring_0 a where {
};

class (Ordered_cancel_ab_semigroup_add a, Ordered_semiring_0 a,
        Semiring_0_cancel a) => Ordered_cancel_semiring a where {
};

class (Ordered_cancel_ab_semigroup_add a) => Ordered_ab_semigroup_add_imp_le a where {
};

class (Comm_monoid_add a,
        Strict_ordered_ab_semigroup_add a) => Strict_ordered_comm_monoid_add a where {
};

class (Ordered_cancel_ab_semigroup_add a, Ordered_comm_monoid_add a,
        Strict_ordered_comm_monoid_add a) => Ordered_cancel_comm_monoid_add a where {
};

class (Cancel_comm_monoid_add a, Ordered_ab_semigroup_add_imp_le a,
        Ordered_cancel_comm_monoid_add a) => Ordered_ab_semigroup_monoid_add_imp_le a where {
};

class (Ab_group_add a,
        Ordered_ab_semigroup_monoid_add_imp_le a) => Ordered_ab_group_add a where {
};

class (Ordered_ab_group_add a, Ordered_cancel_semiring a,
        Ring a) => Ordered_ring a where {
};

instance Ordered_ab_semigroup_add Int where {
};

instance Strict_ordered_ab_semigroup_add Int where {
};

instance Ordered_cancel_ab_semigroup_add Int where {
};

instance Ordered_semigroup_mult_zero Int where {
};

instance Ordered_comm_monoid_add Int where {
};

instance Ordered_semiring Int where {
};

instance Ordered_semiring_0 Int where {
};

instance Ordered_cancel_semiring Int where {
};

instance Ordered_ab_semigroup_add_imp_le Int where {
};

instance Strict_ordered_comm_monoid_add Int where {
};

instance Ordered_cancel_comm_monoid_add Int where {
};

instance Ordered_ab_semigroup_monoid_add_imp_le Int where {
};

instance Ordered_ab_group_add Int where {
};

instance Ordered_ring Int where {
};

class (Order a, Zero_neq_one a) => Zero_less_one a where {
};

instance Zero_less_one Int where {
};

apsnd :: forall a b c. (a -> b) -> (c, a) -> (c, b);
apsnd f (x, y) = (x, f y);

divmod_integer :: Integer -> Integer -> (Integer, Integer);
divmod_integer k l =
  (if k == (0 :: Integer) then ((0 :: Integer), (0 :: Integer))
    else (if (0 :: Integer) < l
           then (if (0 :: Integer) < k then divMod ( k ) ( l )
                  else (case divMod ( (negate k) ) ( l ) of {
                         (r, s) ->
                           (if s == (0 :: Integer)
                             then (negate r, (0 :: Integer))
                             else (negate r - (1 :: Integer), l - s));
                       }))
           else (if l == (0 :: Integer) then ((0 :: Integer), k)
                  else apsnd negate
                         (if k < (0 :: Integer)
                           then divMod ( (negate k) ) ( (negate l) )
                           else (case divMod ( k ) ( (negate l) ) of {
                                  (r, s) ->
                                    (if s == (0 :: Integer)
                                      then (negate r, (0 :: Integer))
                                      else (negate r - (1 :: Integer),
     negate l - s));
                                })))));

modulo_integer :: Integer -> Integer -> Integer;
modulo_integer k l = snd (divmod_integer k l);

newtype Nat = Nat Integer;

integer_of_nat :: Nat -> Integer;
integer_of_nat (Nat x) = x;

modulo_nat :: Nat -> Nat -> Nat;
modulo_nat m n = Nat (modulo_integer (integer_of_nat m) (integer_of_nat n));

divide_integer :: Integer -> Integer -> Integer;
divide_integer k l = fst (divmod_integer k l);

divide_nat :: Nat -> Nat -> Nat;
divide_nat m n = Nat (divide_integer (integer_of_nat m) (integer_of_nat n));

max :: forall a. (Ord a) => a -> a -> a;
max a b = (if less_eq a b then b else a);

instance Ord Integer where {
  less_eq = (\ a b -> a <= b);
  less = (\ a b -> a < b);
};

nat_of_integer :: Integer -> Nat;
nat_of_integer k = Nat (max (0 :: Integer) k);

newtype Char = Chr Integer;

char_of_integer :: Integer -> Char;
char_of_integer k =
  Chr (if (0 :: Integer) <= k && k < (256 :: Integer) then k
        else modulo_integer k (256 :: Integer));

integer_of_char :: Char -> Integer;
integer_of_char (Chr x) = x;

implode :: [Char] -> String;
implode cs = Str_Literal.literalOfAsciis (map integer_of_char cs);

lit_of_digit :: Nat -> String;
lit_of_digit n = implode [char_of_integer ((48 :: Integer) + integer_of_nat n)];

less_nat :: Nat -> Nat -> Bool;
less_nat m n = integer_of_nat m < integer_of_nat n;

showsl_lit :: String -> String -> String;
showsl_lit = (\ a b -> a ++ b);

showsl_nat :: Nat -> String -> String;
showsl_nat n =
  (if less_nat n (nat_of_integer (10 :: Integer))
    then showsl_lit (lit_of_digit n)
    else showsl_nat (divide_nat n (nat_of_integer (10 :: Integer))) .
           showsl_lit
             (lit_of_digit (modulo_nat n (nat_of_integer (10 :: Integer)))));

nat :: Int -> Nat;
nat = nat_of_integer . integer_of_int;

showsl_int :: Int -> String -> String;
showsl_int i =
  (if less_int i zero_int then showsl_lit "-" . showsl_nat (nat (uminus_int i))
    else showsl_nat (nat i));

showsl_sep ::
  forall a.
    (a -> String -> String) -> (String -> String) -> [a] -> String -> String;
showsl_sep s sep [] = showsl_lit "";
showsl_sep s sep [x] = s x;
showsl_sep s sep (x : v : va) = (s x . sep) . showsl_sep s sep (v : va);

showsl_list_gen ::
  forall a.
    (a -> String -> String) ->
      String -> String -> String -> String -> [a] -> String -> String;
showsl_list_gen showslx e l s r xs =
  (if null xs then showsl_lit e
    else (showsl_lit l . showsl_sep showslx (showsl_lit s) xs) . showsl_lit r);

default_showsl_list ::
  forall a. (a -> String -> String) -> [a] -> String -> String;
default_showsl_list sl = showsl_list_gen sl "[]" "[" ", " "]";

showsl_list_int :: [Int] -> String -> String;
showsl_list_int xs = default_showsl_list showsl_int xs;

class Showl a where {
  showsl :: a -> String -> String;
  showsl_list :: [a] -> String -> String;
};

instance Showl Int where {
  showsl = showsl_int;
  showsl_list = showsl_list_int;
};

cEnum_int :: Maybe ([Int], ((Int -> Bool) -> Bool, (Int -> Bool) -> Bool));
cEnum_int = Nothing;

class Cenum a where {
  cEnum :: Maybe ([a], ((a -> Bool) -> Bool, (a -> Bool) -> Bool));
};

instance Cenum Int where {
  cEnum = cEnum_int;
};

class (Ordered_cancel_ab_semigroup_add a, Ordered_semiring a,
        Semiring_0_cancel a) => Ordered_semiring_strict a where {
};

class (Ordered_ab_semigroup_add a,
        Linorder a) => Linordered_ab_semigroup_add a where {
};

class (Linordered_ab_semigroup_add a,
        Ordered_ab_semigroup_add_imp_le a) => Linordered_cancel_ab_semigroup_add a where {
};

class (Linordered_cancel_ab_semigroup_add a,
        Ordered_ab_semigroup_monoid_add_imp_le a,
        Ordered_cancel_semiring a) => Linordered_semiring a where {
};

class (Linordered_semiring a,
        Ordered_semiring_strict a) => Linordered_semiring_strict a where {
};

class (Ordered_semiring_0 a, Semiring_1 a,
        Zero_less_one a) => Ordered_semiring_1 a where {
};

class (Ordered_semiring_1 a,
        Ordered_semiring_strict a) => Ordered_semiring_1_strict a where {
};

class (Ordered_semiring_0 a, Semiring_1 a,
        Zero_less_one a) => Ordered_semiring_1b a where {
};

class (Ordered_semiring_1b a, Linordered_semiring a,
        Ordered_semiring_1 a) => Linordered_semiring_1 a where {
};

class (Linordered_semiring_1 a, Linordered_semiring_strict a,
        Ordered_semiring_1_strict a) => Linordered_semiring_1_strict a where {
};

class (Abs a, Ordered_ab_group_add a) => Ordered_ab_group_add_abs a where {
};

class (Linordered_cancel_ab_semigroup_add a,
        Ordered_ab_group_add a) => Linordered_ab_group_add a where {
};

class (Linordered_ab_group_add a, Ordered_ab_group_add_abs a, Abs_if a,
        Linordered_semiring a, Ordered_ring a) => Linordered_ring a where {
};

class (Linordered_ring a, Linordered_semiring_strict a,
        Ring_no_zero_divisors a) => Linordered_ring_strict a where {
};

class (Ordered_semiring_0 a,
        Ordered_semiring_strict a) => Semiring_real_line a where {
};

class (Semiring_real_line a,
        Ordered_semiring_1 a) => Semiring_1_real_line a where {
};

class (Comm_semiring_0 a, Ordered_semiring a) => Ordered_comm_semiring a where {
};

class (Comm_semiring_0_cancel a, Ordered_cancel_semiring a,
        Ordered_comm_semiring a) => Ordered_cancel_comm_semiring a where {
};

class (Ordered_cancel_comm_semiring a,
        Ordered_semiring_strict a) => Ordered_comm_semiring_strict a where {
};

class (Linordered_semiring_strict a,
        Ordered_comm_semiring_strict a) => Linordered_comm_semiring_strict a where {
};

class (Semiring_char_0 a, Linorder a, Comm_semiring_1 a,
        Ordered_comm_semiring a,
        Ordered_semiring_1 a) => Linordered_nonzero_semiring a where {
};

class (Linordered_comm_semiring_strict a, Linordered_nonzero_semiring a,
        Semidom a) => Linordered_semidom a where {
};

class (Comm_ring a, Ordered_cancel_comm_semiring a,
        Ordered_ring a) => Ordered_comm_ring a where {
};

class (Ordered_ab_group_add_abs a, Ordered_ring a) => Ordered_ring_abs a where {
};

class (Ring_char_0 a, Semiring_1_real_line a, Idom_abs_sgn a,
        Linordered_ring_strict a, Linordered_semidom a,
        Linordered_semiring_1_strict a, Ordered_comm_ring a,
        Ordered_ring_abs a) => Linordered_idom a where {
};

instance Ordered_semiring_strict Int where {
};

instance Linordered_ab_semigroup_add Int where {
};

instance Linordered_cancel_ab_semigroup_add Int where {
};

instance Linordered_semiring Int where {
};

instance Linordered_semiring_strict Int where {
};

instance Ordered_semiring_1 Int where {
};

instance Ordered_semiring_1_strict Int where {
};

instance Ordered_semiring_1b Int where {
};

instance Linordered_semiring_1 Int where {
};

instance Linordered_semiring_1_strict Int where {
};

instance Ordered_ab_group_add_abs Int where {
};

instance Linordered_ab_group_add Int where {
};

instance Linordered_ring Int where {
};

instance Linordered_ring_strict Int where {
};

instance Semiring_real_line Int where {
};

instance Semiring_1_real_line Int where {
};

instance Ordered_comm_semiring Int where {
};

instance Ordered_cancel_comm_semiring Int where {
};

instance Ordered_comm_semiring_strict Int where {
};

instance Linordered_comm_semiring_strict Int where {
};

instance Linordered_nonzero_semiring Int where {
};

instance Linordered_semidom Int where {
};

instance Ordered_comm_ring Int where {
};

instance Ordered_ring_abs Int where {
};

instance Linordered_idom Int where {
};

class (Ord a) => Non_strict_order a where {
};

class (Ab_semigroup_add a, Monoid_add a,
        Non_strict_order a) => Ordered_ab_semigroup a where {
};

class (Semiring_0 a, Ordered_ab_semigroup a) => Ordered_semiring_0a a where {
};

class (Semiring_1 a, Ordered_semiring_0a a) => Ordered_semiring_1a a where {
};

class (Comm_semiring_1 a, Ordered_semiring_1a a) => Poly_carrier a where {
};

instance Non_strict_order Int where {
};

instance Ordered_ab_semigroup Int where {
};

instance Ordered_semiring_0a Int where {
};

instance Ordered_semiring_1a Int where {
};

instance Poly_carrier Int where {
};

data Ordera = Eqa | Lt | Gt;

comparator_of :: forall a. (Eq a, Linorder a) => a -> a -> Ordera;
comparator_of x y = (if less x y then Lt else (if x == y then Eqa else Gt));

compare_int :: Int -> Int -> Ordera;
compare_int = comparator_of;

ccompare_int :: Maybe (Int -> Int -> Ordera);
ccompare_int = Just compare_int;

class Ccompare a where {
  ccompare :: Maybe (a -> a -> Ordera);
};

instance Ccompare Int where {
  ccompare = ccompare_int;
};

data Mapping_impla = Mapping_Choose | Mapping_Assoc_List | Mapping_RBT
  | Mapping_Mapping;

mapping_impl_int :: Phantom Int Mapping_impla;
mapping_impl_int = Phantom Mapping_RBT;

class Mapping_impl a where {
  mapping_impl :: Phantom a Mapping_impla;
};

instance Mapping_impl Int where {
  mapping_impl = mapping_impl_int;
};

class (Ring a, Poly_carrier a) => Poly_carriera a where {
};

instance Poly_carriera Int where {
};

newtype Rat = Frct (Int, Int);

newtype Mini_alg = Abs_mini_alg (Rat, (Rat, Nat));

newtype Mini_alg_unique = Abs_mini_alg_unique Mini_alg;

zero_rat :: Rat;
zero_rat = Frct (zero_int, one_int);

zero_nat :: Nat;
zero_nat = Nat (0 :: Integer);

ma_of_rat :: Rat -> Mini_alg;
ma_of_rat xa = Abs_mini_alg (xa, (zero_rat, zero_nat));

mau_of_rat :: Rat -> Mini_alg_unique;
mau_of_rat xa = Abs_mini_alg_unique (ma_of_rat xa);

newtype Real = Real_of_u Mini_alg_unique;

ratreal :: Rat -> Real;
ratreal = Real_of_u . mau_of_rat;

of_int :: Int -> Rat;
of_int a = Frct (a, one_int);

real_of_int :: Int -> Real;
real_of_int x = ratreal (of_int x);

class (Linordered_idom a) => Real_embedding a where {
  real_of :: a -> Real;
};

instance Real_embedding Int where {
  real_of = real_of_int;
};

class (Poly_carrier a) => Large_ordered_semiring_1 a where {
};

instance Large_ordered_semiring_1 Int where {
};

class (Real_embedding a,
        Large_ordered_semiring_1 a) => Large_real_ordered_semiring_1 a where {
};

instance Large_real_ordered_semiring_1 Int where {
};

equal_nat :: Nat -> Nat -> Bool;
equal_nat m n = integer_of_nat m == integer_of_nat n;

instance Eq Nat where {
  a == b = equal_nat a b;
};

times_nat :: Nat -> Nat -> Nat;
times_nat m n = Nat (integer_of_nat m * integer_of_nat n);

instance Times Nat where {
  times = times_nat;
};

instance Dvd Nat where {
};

one_nat :: Nat;
one_nat = Nat (1 :: Integer);

instance One Nat where {
  onea = one_nat;
};

plus_nat :: Nat -> Nat -> Nat;
plus_nat m n = Nat (integer_of_nat m + integer_of_nat n);

instance Plus Nat where {
  plus = plus_nat;
};

instance Zero Nat where {
  zerob = zero_nat;
};

instance Semigroup_add Nat where {
};

instance Numeral Nat where {
};

instance Power Nat where {
};

minus_nat :: Nat -> Nat -> Nat;
minus_nat m n = Nat (max (0 :: Integer) (integer_of_nat m - integer_of_nat n));

instance Minus Nat where {
  minusa = minus_nat;
};

min :: forall a. (Ord a) => a -> a -> a;
min a b = (if less_eq a b then a else b);

less_eq_nat :: Nat -> Nat -> Bool;
less_eq_nat m n = integer_of_nat m <= integer_of_nat n;

instance Ord Nat where {
  less_eq = less_eq_nat;
  less = less_nat;
};

inf_nat :: Nat -> Nat -> Nat;
inf_nat = min;

class Inf a where {
  inf :: a -> a -> a;
};

instance Inf Nat where {
  inf = inf_nat;
};

sup_nat :: Nat -> Nat -> Nat;
sup_nat = max;

class Sup a where {
  sup :: a -> a -> a;
};

instance Sup Nat where {
  sup = sup_nat;
};

class Divide a where {
  divide :: a -> a -> a;
};

instance Divide Nat where {
  divide = divide_nat;
};

class (Divide a, Dvd a) => Modulo a where {
  modulo :: a -> a -> a;
};

instance Modulo Nat where {
  modulo = modulo_nat;
};

class (Linorder a, Comm_semiring_1_cancel a) => Interval a where {
};

instance Cancel_semigroup_add Nat where {
};

instance Ab_semigroup_add Nat where {
};

instance Cancel_ab_semigroup_add Nat where {
};

instance Monoid_add Nat where {
};

instance Comm_monoid_add Nat where {
};

instance Cancel_comm_monoid_add Nat where {
};

instance Mult_zero Nat where {
};

instance Semigroup_mult Nat where {
};

instance Semiring Nat where {
};

instance Semiring_0 Nat where {
};

instance Semiring_0_cancel Nat where {
};

instance Ab_semigroup_mult Nat where {
};

instance Comm_semiring Nat where {
};

instance Comm_semiring_0 Nat where {
};

instance Comm_semiring_0_cancel Nat where {
};

instance Monoid_mult Nat where {
};

instance Semiring_numeral Nat where {
};

instance Zero_neq_one Nat where {
};

instance Semiring_1 Nat where {
};

instance Semiring_1_cancel Nat where {
};

instance Comm_monoid_mult Nat where {
};

instance Comm_semiring_1 Nat where {
};

instance Comm_semiring_1_cancel Nat where {
};

instance Quasi_order Nat where {
};

instance Weak_order Nat where {
};

instance Preorder Nat where {
};

instance Order Nat where {
};

instance Linorder Nat where {
};

instance Interval Nat where {
};

instance Semiring_no_zero_divisors Nat where {
};

instance Semiring_1_no_zero_divisors Nat where {
};

instance Semidom Nat where {
};

compare_nat :: Nat -> Nat -> Ordera;
compare_nat = comparator_of;

class Compare a where {
  compare :: a -> a -> Ordera;
};

instance Compare Nat where {
  compare = compare_nat;
};

class (Sup a, Quasi_order a) => Quasi_order_sup a where {
};

class (Quasi_order_sup a) => Quasi_semilattice_sup a where {
};

class (Order a, Quasi_semilattice_sup a) => Semilattice_sup a where {
};

class (Inf a, Order a) => Semilattice_inf a where {
};

class (Semilattice_inf a, Semilattice_sup a) => Lattice a where {
};

instance Quasi_order_sup Nat where {
};

instance Quasi_semilattice_sup Nat where {
};

instance Semilattice_sup Nat where {
};

instance Semilattice_inf Nat where {
};

instance Lattice Nat where {
};

ceq_nat :: Maybe (Nat -> Nat -> Bool);
ceq_nat = Just equal_nat;

instance Ceq Nat where {
  ceq = ceq_nat;
};

set_impl_nat :: Phantom Nat Set_impla;
set_impl_nat = Phantom Set_RBT;

instance Set_impl Nat where {
  set_impl = set_impl_nat;
};

showsl_list_nat :: [Nat] -> String -> String;
showsl_list_nat xs = default_showsl_list showsl_nat xs;

instance Showl Nat where {
  showsl = showsl_nat;
  showsl_list = showsl_list_nat;
};

class (One a, Zero a, Divide a) => Divide_trivial a where {
};

instance Divide_trivial Nat where {
};

class (Divide_trivial a, Semidom a,
        Semiring_no_zero_divisors_cancel a) => Semidom_divide a where {
};

instance Semiring_no_zero_divisors_cancel Nat where {
};

instance Semidom_divide Nat where {
};

class (Comm_semiring_1_cancel a, Modulo a) => Semiring_modulo a where {
};

class (Divide_trivial a, Semiring_modulo a) => Semiring_modulo_trivial a where {
};

class (Semidom_divide a) => Algebraic_semidom a where {
};

class (Algebraic_semidom a,
        Semiring_modulo_trivial a) => Semidom_modulo a where {
};

instance Semiring_modulo Nat where {
};

instance Semiring_modulo_trivial Nat where {
};

instance Algebraic_semidom Nat where {
};

instance Semidom_modulo Nat where {
};

finite_UNIV_nat :: Phantom Nat Bool;
finite_UNIV_nat = Phantom False;

card_UNIV_nat :: Phantom Nat Nat;
card_UNIV_nat = Phantom zero_nat;

class Finite_UNIV a where {
  finite_UNIV :: Phantom a Bool;
};

class (Finite_UNIV a) => Card_UNIV a where {
  card_UNIV :: Phantom a Nat;
};

instance Finite_UNIV Nat where {
  finite_UNIV = finite_UNIV_nat;
};

instance Card_UNIV Nat where {
  card_UNIV = card_UNIV_nat;
};

cEnum_nat :: Maybe ([Nat], ((Nat -> Bool) -> Bool, (Nat -> Bool) -> Bool));
cEnum_nat = Nothing;

instance Cenum Nat where {
  cEnum = cEnum_nat;
};

class (Compare a, Linorder a) => Compare_order a where {
};

instance Compare_order Nat where {
};

ccompare_nat :: Maybe (Nat -> Nat -> Ordera);
ccompare_nat = Just compare_nat;

instance Ccompare Nat where {
  ccompare = ccompare_nat;
};

mapping_impl_nat :: Phantom Nat Mapping_impla;
mapping_impl_nat = Phantom Mapping_RBT;

instance Mapping_impl Nat where {
  mapping_impl = mapping_impl_nat;
};

proper_interval_nat :: Maybe Nat -> Maybe Nat -> Bool;
proper_interval_nat no Nothing = True;
proper_interval_nat Nothing (Just x) = less_nat zero_nat x;
proper_interval_nat (Just x) (Just y) = less_nat one_nat (minus_nat y x);

cproper_interval_nat :: Maybe Nat -> Maybe Nat -> Bool;
cproper_interval_nat = proper_interval_nat;

class (Ccompare a) => Cproper_interval a where {
  cproper_interval :: Maybe a -> Maybe a -> Bool;
};

instance Cproper_interval Nat where {
  cproper_interval = cproper_interval_nat;
};

quotient_of :: Rat -> (Int, Int);
quotient_of (Frct x) = x;

equal_rat :: Rat -> Rat -> Bool;
equal_rat a b = quotient_of a == quotient_of b;

instance Eq Rat where {
  a == b = equal_rat a b;
};

divide_int :: Int -> Int -> Int;
divide_int k l =
  Int_of_integer (divide_integer (integer_of_int k) (integer_of_int l));

gcd_int :: Int -> Int -> Int;
gcd_int (Int_of_integer x) (Int_of_integer y) =
  Int_of_integer (Prelude.gcd x y);

normalize :: (Int, Int) -> (Int, Int);
normalize p =
  (if less_int zero_int (snd p)
    then let {
           a = gcd_int (fst p) (snd p);
         } in (divide_int (fst p) a, divide_int (snd p) a)
    else (if equal_int (snd p) zero_int then (zero_int, one_int)
           else let {
                  a = uminus_int (gcd_int (fst p) (snd p));
                } in (divide_int (fst p) a, divide_int (snd p) a)));

times_rat :: Rat -> Rat -> Rat;
times_rat p q =
  Frct (case quotient_of p of {
         (a, c) -> (case quotient_of q of {
                     (b, d) -> normalize (times_int a b, times_int c d);
                   });
       });

instance Times Rat where {
  times = times_rat;
};

instance Dvd Rat where {
};

abs_rat :: Rat -> Rat;
abs_rat p = Frct (case quotient_of p of {
                   (a, b) -> (abs_int a, b);
                 });

instance Abs Rat where {
  absa = abs_rat;
};

one_rat :: Rat;
one_rat = Frct (one_int, one_int);

instance One Rat where {
  onea = one_rat;
};

sgn_rat :: Rat -> Rat;
sgn_rat p = Frct (sgn_int (fst (quotient_of p)), one_int);

instance Sgn Rat where {
  sgn = sgn_rat;
};

uminus_rat :: Rat -> Rat;
uminus_rat p = Frct (case quotient_of p of {
                      (a, b) -> (uminus_int a, b);
                    });

minus_rat :: Rat -> Rat -> Rat;
minus_rat p q =
  Frct (case quotient_of p of {
         (a, c) ->
           (case quotient_of q of {
             (b, d) ->
               normalize
                 (minus_int (times_int a d) (times_int b c), times_int c d);
           });
       });

plus_rat :: Rat -> Rat -> Rat;
plus_rat p q =
  Frct (case quotient_of p of {
         (a, c) ->
           (case quotient_of q of {
             (b, d) ->
               normalize
                 (plus_int (times_int a d) (times_int b c), times_int c d);
           });
       });

instance Plus Rat where {
  plus = plus_rat;
};

instance Semigroup_add Rat where {
};

instance Cancel_semigroup_add Rat where {
};

instance Ab_semigroup_add Rat where {
};

instance Minus Rat where {
  minusa = minus_rat;
};

instance Cancel_ab_semigroup_add Rat where {
};

instance Zero Rat where {
  zerob = zero_rat;
};

instance Monoid_add Rat where {
};

instance Comm_monoid_add Rat where {
};

instance Cancel_comm_monoid_add Rat where {
};

instance Mult_zero Rat where {
};

instance Semigroup_mult Rat where {
};

instance Semiring Rat where {
};

instance Semiring_0 Rat where {
};

instance Semiring_0_cancel Rat where {
};

instance Ab_semigroup_mult Rat where {
};

instance Comm_semiring Rat where {
};

instance Comm_semiring_0 Rat where {
};

instance Comm_semiring_0_cancel Rat where {
};

instance Power Rat where {
};

instance Monoid_mult Rat where {
};

instance Numeral Rat where {
};

instance Semiring_numeral Rat where {
};

instance Zero_neq_one Rat where {
};

instance Semiring_1 Rat where {
};

instance Semiring_1_cancel Rat where {
};

instance Comm_monoid_mult Rat where {
};

instance Comm_semiring_1 Rat where {
};

instance Comm_semiring_1_cancel Rat where {
};

instance Comm_semiring_1_cancel_crossproduct Rat where {
};

instance Semiring_no_zero_divisors Rat where {
};

instance Semiring_1_no_zero_divisors Rat where {
};

instance Semiring_no_zero_divisors_cancel Rat where {
};

instance Uminus Rat where {
  uminus = uminus_rat;
};

instance Group_add Rat where {
};

instance Ab_group_add Rat where {
};

instance Ring Rat where {
};

instance Ring_no_zero_divisors Rat where {
};

instance Neg_numeral Rat where {
};

instance Ring_1 Rat where {
};

instance Ring_1_no_zero_divisors Rat where {
};

instance Comm_ring Rat where {
};

instance Comm_ring_1 Rat where {
};

instance Semidom Rat where {
};

instance Idom Rat where {
};

inverse_rat :: Rat -> Rat;
inverse_rat p =
  Frct (case quotient_of p of {
         (a, b) ->
           (if equal_int a zero_int then (zero_int, one_int)
             else (times_int (sgn_int a) b, abs_int a));
       });

divide_rat :: Rat -> Rat -> Rat;
divide_rat p q =
  Frct (case quotient_of p of {
         (a, c) -> (case quotient_of q of {
                     (b, d) -> normalize (times_int a d, times_int c b);
                   });
       });

class (Divide a) => Inverse a where {
  inverse :: a -> a;
};

class (Idom a) => Ufd a where {
};

class (Inverse a, Divide_trivial a,
        Ring_1_no_zero_divisors a) => Division_ring a where {
};

class (Idom a, Semidom_divide a) => Idom_divide a where {
};

class (Division_ring a, Idom_divide a, Ufd a) => Field a where {
};

instance Ufd Rat where {
};

instance Divide Rat where {
  divide = divide_rat;
};

instance Divide_trivial Rat where {
};

instance Inverse Rat where {
  inverse = inverse_rat;
};

instance Division_ring Rat where {
};

instance Semidom_divide Rat where {
};

instance Idom_divide Rat where {
};

instance Field Rat where {
};

less_eq_rat :: Rat -> Rat -> Bool;
less_eq_rat p q =
  (case quotient_of p of {
    (a, c) -> (case quotient_of q of {
                (b, d) -> less_eq_int (times_int a d) (times_int c b);
              });
  });

less_rat :: Rat -> Rat -> Bool;
less_rat p q =
  (case quotient_of p of {
    (a, c) -> (case quotient_of q of {
                (b, d) -> less_int (times_int a d) (times_int c b);
              });
  });

instance Ord Rat where {
  less_eq = less_eq_rat;
  less = less_rat;
};

inf_rat :: Rat -> Rat -> Rat;
inf_rat = min;

instance Inf Rat where {
  inf = inf_rat;
};

sup_rat :: Rat -> Rat -> Rat;
sup_rat = max;

instance Sup Rat where {
  sup = sup_rat;
};

instance Abs_if Rat where {
};

instance Quasi_order Rat where {
};

instance Weak_order Rat where {
};

instance Preorder Rat where {
};

instance Order Rat where {
};

instance Linorder Rat where {
};

compare_rat :: Rat -> Rat -> Ordera;
compare_rat = comparator_of;

instance Compare Rat where {
  compare = compare_rat;
};

instance Semiring_char_0 Rat where {
};

instance Ring_char_0 Rat where {
};

instance Quasi_order_sup Rat where {
};

instance Quasi_semilattice_sup Rat where {
};

instance Semilattice_sup Rat where {
};

instance Semilattice_inf Rat where {
};

instance Lattice Rat where {
};

class (Order a) => No_bot a where {
};

instance No_bot Rat where {
};

class (Order a) => No_top a where {
};

instance No_top Rat where {
};

ceq_rat :: Maybe (Rat -> Rat -> Bool);
ceq_rat = Just equal_rat;

instance Ceq Rat where {
  ceq = ceq_rat;
};

set_impl_rat :: Phantom Rat Set_impla;
set_impl_rat = Phantom Set_RBT;

instance Set_impl Rat where {
  set_impl = set_impl_rat;
};

instance Idom_abs_sgn Rat where {
};

instance Ordered_ab_semigroup_add Rat where {
};

instance Strict_ordered_ab_semigroup_add Rat where {
};

instance Ordered_cancel_ab_semigroup_add Rat where {
};

instance Ordered_semigroup_mult_zero Rat where {
};

instance Ordered_comm_monoid_add Rat where {
};

instance Ordered_semiring Rat where {
};

instance Ordered_semiring_0 Rat where {
};

instance Ordered_cancel_semiring Rat where {
};

instance Ordered_ab_semigroup_add_imp_le Rat where {
};

instance Strict_ordered_comm_monoid_add Rat where {
};

instance Ordered_cancel_comm_monoid_add Rat where {
};

instance Ordered_ab_semigroup_monoid_add_imp_le Rat where {
};

instance Ordered_ab_group_add Rat where {
};

instance Ordered_ring Rat where {
};

class (Field a, Ring_char_0 a) => Field_char_0 a where {
};

instance Field_char_0 Rat where {
};

instance Zero_less_one Rat where {
};

showsl_rat :: Rat -> String -> String;
showsl_rat x =
  (case quotient_of x of {
    (d, n) ->
      (if equal_int n one_int then showsl_int d
        else (showsl_int d . showsl_lit "/") . showsl_int n);
  });

showsl_list_rat :: [Rat] -> String -> String;
showsl_list_rat xs = default_showsl_list showsl_rat xs;

instance Showl Rat where {
  showsl = showsl_rat;
  showsl_list = showsl_list_rat;
};

class (Field a, Idom_abs_sgn a) => Field_abs_sgn a where {
};

instance Field_abs_sgn Rat where {
};

cEnum_rat :: Maybe ([Rat], ((Rat -> Bool) -> Bool, (Rat -> Bool) -> Bool));
cEnum_rat = Nothing;

instance Cenum Rat where {
  cEnum = cEnum_rat;
};

class (Order a) => Dense_order a where {
};

instance Dense_order Rat where {
};

instance Ordered_semiring_strict Rat where {
};

instance Linordered_ab_semigroup_add Rat where {
};

instance Linordered_cancel_ab_semigroup_add Rat where {
};

instance Linordered_semiring Rat where {
};

instance Linordered_semiring_strict Rat where {
};

instance Ordered_semiring_1 Rat where {
};

instance Ordered_semiring_1_strict Rat where {
};

instance Ordered_semiring_1b Rat where {
};

instance Linordered_semiring_1 Rat where {
};

instance Linordered_semiring_1_strict Rat where {
};

instance Ordered_ab_group_add_abs Rat where {
};

instance Linordered_ab_group_add Rat where {
};

instance Linordered_ring Rat where {
};

instance Linordered_ring_strict Rat where {
};

instance Semiring_real_line Rat where {
};

instance Semiring_1_real_line Rat where {
};

instance Ordered_comm_semiring Rat where {
};

instance Ordered_cancel_comm_semiring Rat where {
};

instance Ordered_comm_semiring_strict Rat where {
};

instance Linordered_comm_semiring_strict Rat where {
};

instance Linordered_nonzero_semiring Rat where {
};

instance Linordered_semidom Rat where {
};

instance Ordered_comm_ring Rat where {
};

instance Ordered_ring_abs Rat where {
};

instance Linordered_idom Rat where {
};

instance Non_strict_order Rat where {
};

instance Ordered_ab_semigroup Rat where {
};

instance Ordered_semiring_0a Rat where {
};

instance Ordered_semiring_1a Rat where {
};

instance Poly_carrier Rat where {
};

class (Dense_order a, No_bot a, No_top a) => Unbounded_dense_order a where {
};

class (Dense_order a, Linorder a) => Dense_linorder a where {
};

class (Dense_linorder a,
        Unbounded_dense_order a) => Unbounded_dense_linorder a where {
};

class (Field_abs_sgn a, Field_char_0 a, Unbounded_dense_linorder a,
        Linordered_idom a) => Linordered_field a where {
};

instance Unbounded_dense_order Rat where {
};

instance Dense_linorder Rat where {
};

instance Unbounded_dense_linorder Rat where {
};

instance Linordered_field Rat where {
};

ccompare_rat :: Maybe (Rat -> Rat -> Ordera);
ccompare_rat = Just compare_rat;

instance Ccompare Rat where {
  ccompare = ccompare_rat;
};

real_of_rat :: Rat -> Real;
real_of_rat x = ratreal x;

instance Real_embedding Rat where {
  real_of = real_of_rat;
};

class (Linordered_field a) => Archimedean_field a where {
};

class (Archimedean_field a,
        Large_ordered_semiring_1 a) => Floor_ceiling a where {
  floor :: a -> Int;
};

floor_rat :: Rat -> Int;
floor_rat p = (case quotient_of p of {
                (a, b) -> divide_int a b;
              });

instance Archimedean_field Rat where {
};

instance Large_ordered_semiring_1 Rat where {
};

instance Floor_ceiling Rat where {
  floor = floor_rat;
};

instance Large_real_ordered_semiring_1 Rat where {
};

equal_order :: Ordera -> Ordera -> Bool;
equal_order Lt Gt = False;
equal_order Gt Lt = False;
equal_order Eqa Gt = False;
equal_order Gt Eqa = False;
equal_order Eqa Lt = False;
equal_order Lt Eqa = False;
equal_order Gt Gt = True;
equal_order Lt Lt = True;
equal_order Eqa Eqa = True;

newtype Generator a b = Generator (b -> Bool, b -> (a, b));

generator :: forall a b. Generator a b -> (b -> Bool, b -> (a, b));
generator (Generator x) = x;

has_next :: forall a b. Generator a b -> b -> Bool;
has_next g = fst (generator g);

next :: forall a b. Generator a b -> b -> (a, b);
next g = snd (generator g);

sorted_list_subset_fusion ::
  forall a b c.
    (a -> a -> Bool) ->
      (a -> a -> Bool) -> Generator a b -> Generator a c -> b -> c -> Bool;
sorted_list_subset_fusion less eq g1 g2 s1 s2 =
  (if has_next g1 s1
    then (case next g1 s1 of {
           (x, s1a) ->
             has_next g2 s2 &&
               (case next g2 s2 of {
                 (y, s2a) ->
                   (if eq x y
                     then sorted_list_subset_fusion less eq g1 g2 s1a s2a
                     else less y x &&
                            sorted_list_subset_fusion less eq g1 g2 s1 s2a);
               });
         })
    else True);

list_all_fusion :: forall a b. Generator a b -> (a -> Bool) -> b -> Bool;
list_all_fusion g p s =
  (if has_next g s then (case next g s of {
                          (x, sa) -> p x && list_all_fusion g p sa;
                        })
    else True);

data Color = R | B;

data Rbta a b = Empty | Branch Color (Rbta a b) a b (Rbta a b);

rbt_keys_next ::
  forall a b. ([(a, Rbta a b)], Rbta a b) -> (a, ([(a, Rbta a b)], Rbta a b));
rbt_keys_next ((k, t) : kts, Empty) = (k, (kts, t));
rbt_keys_next (kts, Branch c l k v r) = rbt_keys_next ((k, r) : kts, l);

rbt_has_next :: forall a b c. ([(a, Rbta b c)], Rbta b c) -> Bool;
rbt_has_next ([], Empty) = False;
rbt_has_next (vb : vc, va) = True;
rbt_has_next (v, Branch vb vc vd ve vf) = True;

rbt_keys_generator :: forall a b. Generator a ([(a, Rbta a b)], Rbta a b);
rbt_keys_generator = Generator (rbt_has_next, rbt_keys_next);

lt_of_comp :: forall a. (a -> a -> Ordera) -> a -> a -> Bool;
lt_of_comp acomp x y = (case acomp x y of {
                         Eqa -> False;
                         Lt -> True;
                         Gt -> False;
                       });

newtype Mapping_rbt b a = Mapping_RBTa (Rbta b a);

newtype Set_dlist a = Abs_dlist [a];

data Set a = Collect_set (a -> Bool) | DList_set (Set_dlist a)
  | RBT_set (Mapping_rbt a ()) | Set_Monad [a] | Complement (Set a);

list_of_dlist :: forall a. (Ceq a) => Set_dlist a -> [a];
list_of_dlist (Abs_dlist x) = x;

dlist_all :: forall a. (Ceq a) => (a -> Bool) -> Set_dlist a -> Bool;
dlist_all x xc = all x (list_of_dlist xc);

impl_ofb :: forall b a. (Ccompare b) => Mapping_rbt b a -> Rbta b a;
impl_ofb (Mapping_RBTa x) = x;

rbt_init :: forall a b c. Rbta a b -> ([(c, Rbta a b)], Rbta a b);
rbt_init = (\ a -> ([], a));

init ::
  forall a b c. (Ccompare a) => Mapping_rbt a b -> ([(c, Rbta a b)], Rbta a b);
init xa = rbt_init (impl_ofb xa);

collect :: forall a. (Cenum a) => (a -> Bool) -> Set a;
collect p = (case cEnum of {
              Nothing -> Collect_set p;
              Just (enum, _) -> Set_Monad (filter p enum);
            });

list_member :: forall a. (a -> a -> Bool) -> [a] -> a -> Bool;
list_member equal [] y = False;
list_member equal (x : xs) y = equal x y || list_member equal xs y;

the :: forall a. Maybe a -> a;
the (Just x2) = x2;

memberc :: forall a. (Ceq a) => Set_dlist a -> a -> Bool;
memberc xa = list_member (the ceq) (list_of_dlist xa);

rbt_comp_lookup :: forall a b. (a -> a -> Ordera) -> Rbta a b -> a -> Maybe b;
rbt_comp_lookup c Empty k = Nothing;
rbt_comp_lookup c (Branch uu l x y r) k = (case c k x of {
    Eqa -> Just y;
    Lt -> rbt_comp_lookup c l k;
    Gt -> rbt_comp_lookup c r k;
  });

lookupd :: forall a b. (Ccompare a) => Mapping_rbt a b -> a -> Maybe b;
lookupd xa = rbt_comp_lookup (the ccompare) (impl_ofb xa);

memberb :: forall a. (Ccompare a) => Mapping_rbt a () -> a -> Bool;
memberb t x = lookupd t x == Just ();

member :: forall a. (Ceq a, Ccompare a) => a -> Set a -> Bool;
member x (Set_Monad xs) =
  (case ceq of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "member Set_Monad: ceq = None" (\ _ -> member x (Set_Monad xs));
    Just eq -> list_member eq xs x;
  });
member xa (Complement x) = not (member xa x);
member x (RBT_set rbt) = memberb rbt x;
member x (DList_set dxs) = memberc dxs x;
member x (Collect_set a) = a x;

less_eq_set :: forall a. (Cenum a, Ceq a, Ccompare a) => Set a -> Set a -> Bool;
less_eq_set (RBT_set rbt1) (RBT_set rbt2) =
  (case ccompare of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "subset RBT_set RBT_set: ccompare = None"
        (\ _ -> less_eq_set (RBT_set rbt1) (RBT_set rbt2));
    Just c ->
      (case ceq of {
        Nothing ->
          sorted_list_subset_fusion (lt_of_comp c)
            (\ x y -> equal_order (c x y) Eqa) rbt_keys_generator
            rbt_keys_generator (init rbt1) (init rbt2);
        Just eq ->
          sorted_list_subset_fusion (lt_of_comp c) eq rbt_keys_generator
            rbt_keys_generator (init rbt1) (init rbt2);
      });
  });
less_eq_set (Complement a1) (Complement a2) = less_eq_set a2 a1;
less_eq_set (Collect_set p) (Complement a) =
  less_eq_set a (collect (\ x -> not (p x)));
less_eq_set (RBT_set rbt) b =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "subset RBT_set1: ccompare = None" (\ _ -> less_eq_set (RBT_set rbt) b);
    Just _ -> list_all_fusion rbt_keys_generator (\ x -> member x b) (init rbt);
  });
less_eq_set (DList_set dxs) c =
  (case (ceq :: Maybe (a -> a -> Bool)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "subset DList_set1: ceq = None" (\ _ -> less_eq_set (DList_set dxs) c);
    Just _ -> dlist_all (\ x -> member x c) dxs;
  });
less_eq_set (Set_Monad xs) c = all (\ x -> member x c) xs;

equal_set ::
  forall a. (Cenum a, Ceq a, Ccompare a, Eq a) => Set a -> Set a -> Bool;
equal_set a b = less_eq_set a b && less_eq_set b a;

instance (Cenum a, Ceq a, Ccompare a, Eq a) => Eq (Set a) where {
  a == b = equal_set a b;
};

uminus_set :: forall a. Set a -> Set a;
uminus_set (Complement b) = b;
uminus_set (Collect_set p) = Collect_set (\ x -> not (p x));
uminus_set a = Complement a;

balance :: forall a b. Rbta a b -> a -> b -> Rbta a b -> Rbta a b;
balance (Branch R a w x b) s t (Branch R c y z d) =
  Branch R (Branch B a w x b) s t (Branch B c y z d);
balance (Branch R (Branch R a w x b) s t c) y z Empty =
  Branch R (Branch B a w x b) s t (Branch B c y z Empty);
balance (Branch R (Branch R a w x b) s t c) y z (Branch B va vb vc vd) =
  Branch R (Branch B a w x b) s t (Branch B c y z (Branch B va vb vc vd));
balance (Branch R Empty w x (Branch R b s t c)) y z Empty =
  Branch R (Branch B Empty w x b) s t (Branch B c y z Empty);
balance (Branch R (Branch B va vb vc vd) w x (Branch R b s t c)) y z Empty =
  Branch R (Branch B (Branch B va vb vc vd) w x b) s t (Branch B c y z Empty);
balance (Branch R Empty w x (Branch R b s t c)) y z (Branch B va vb vc vd) =
  Branch R (Branch B Empty w x b) s t (Branch B c y z (Branch B va vb vc vd));
balance (Branch R (Branch B ve vf vg vh) w x (Branch R b s t c)) y z
  (Branch B va vb vc vd) =
  Branch R (Branch B (Branch B ve vf vg vh) w x b) s t
    (Branch B c y z (Branch B va vb vc vd));
balance Empty w x (Branch R b s t (Branch R c y z d)) =
  Branch R (Branch B Empty w x b) s t (Branch B c y z d);
balance (Branch B va vb vc vd) w x (Branch R b s t (Branch R c y z d)) =
  Branch R (Branch B (Branch B va vb vc vd) w x b) s t (Branch B c y z d);
balance Empty w x (Branch R (Branch R b s t c) y z Empty) =
  Branch R (Branch B Empty w x b) s t (Branch B c y z Empty);
balance Empty w x (Branch R (Branch R b s t c) y z (Branch B va vb vc vd)) =
  Branch R (Branch B Empty w x b) s t (Branch B c y z (Branch B va vb vc vd));
balance (Branch B va vb vc vd) w x (Branch R (Branch R b s t c) y z Empty) =
  Branch R (Branch B (Branch B va vb vc vd) w x b) s t (Branch B c y z Empty);
balance (Branch B va vb vc vd) w x
  (Branch R (Branch R b s t c) y z (Branch B ve vf vg vh)) =
  Branch R (Branch B (Branch B va vb vc vd) w x b) s t
    (Branch B c y z (Branch B ve vf vg vh));
balance Empty s t Empty = Branch B Empty s t Empty;
balance Empty s t (Branch B va vb vc vd) =
  Branch B Empty s t (Branch B va vb vc vd);
balance Empty s t (Branch v Empty vb vc Empty) =
  Branch B Empty s t (Branch v Empty vb vc Empty);
balance Empty s t (Branch v (Branch B ve vf vg vh) vb vc Empty) =
  Branch B Empty s t (Branch v (Branch B ve vf vg vh) vb vc Empty);
balance Empty s t (Branch v Empty vb vc (Branch B vf vg vh vi)) =
  Branch B Empty s t (Branch v Empty vb vc (Branch B vf vg vh vi));
balance Empty s t (Branch v (Branch B ve vj vk vl) vb vc (Branch B vf vg vh vi))
  = Branch B Empty s t
      (Branch v (Branch B ve vj vk vl) vb vc (Branch B vf vg vh vi));
balance (Branch B va vb vc vd) s t Empty =
  Branch B (Branch B va vb vc vd) s t Empty;
balance (Branch B va vb vc vd) s t (Branch B ve vf vg vh) =
  Branch B (Branch B va vb vc vd) s t (Branch B ve vf vg vh);
balance (Branch B va vb vc vd) s t (Branch v Empty vf vg Empty) =
  Branch B (Branch B va vb vc vd) s t (Branch v Empty vf vg Empty);
balance (Branch B va vb vc vd) s t (Branch v (Branch B vi vj vk vl) vf vg Empty)
  = Branch B (Branch B va vb vc vd) s t
      (Branch v (Branch B vi vj vk vl) vf vg Empty);
balance (Branch B va vb vc vd) s t (Branch v Empty vf vg (Branch B vj vk vl vm))
  = Branch B (Branch B va vb vc vd) s t
      (Branch v Empty vf vg (Branch B vj vk vl vm));
balance (Branch B va vb vc vd) s t
  (Branch v (Branch B vi vn vo vp) vf vg (Branch B vj vk vl vm)) =
  Branch B (Branch B va vb vc vd) s t
    (Branch v (Branch B vi vn vo vp) vf vg (Branch B vj vk vl vm));
balance (Branch v Empty vb vc Empty) s t Empty =
  Branch B (Branch v Empty vb vc Empty) s t Empty;
balance (Branch v Empty vb vc (Branch B ve vf vg vh)) s t Empty =
  Branch B (Branch v Empty vb vc (Branch B ve vf vg vh)) s t Empty;
balance (Branch v (Branch B vf vg vh vi) vb vc Empty) s t Empty =
  Branch B (Branch v (Branch B vf vg vh vi) vb vc Empty) s t Empty;
balance (Branch v (Branch B vf vg vh vi) vb vc (Branch B ve vj vk vl)) s t Empty
  = Branch B (Branch v (Branch B vf vg vh vi) vb vc (Branch B ve vj vk vl)) s t
      Empty;
balance (Branch v Empty vf vg Empty) s t (Branch B va vb vc vd) =
  Branch B (Branch v Empty vf vg Empty) s t (Branch B va vb vc vd);
balance (Branch v Empty vf vg (Branch B vi vj vk vl)) s t (Branch B va vb vc vd)
  = Branch B (Branch v Empty vf vg (Branch B vi vj vk vl)) s t
      (Branch B va vb vc vd);
balance (Branch v (Branch B vj vk vl vm) vf vg Empty) s t (Branch B va vb vc vd)
  = Branch B (Branch v (Branch B vj vk vl vm) vf vg Empty) s t
      (Branch B va vb vc vd);
balance (Branch v (Branch B vj vk vl vm) vf vg (Branch B vi vn vo vp)) s t
  (Branch B va vb vc vd) =
  Branch B (Branch v (Branch B vj vk vl vm) vf vg (Branch B vi vn vo vp)) s t
    (Branch B va vb vc vd);

rbt_comp_ins ::
  forall a b.
    (a -> a -> Ordera) -> (a -> b -> b -> b) -> a -> b -> Rbta a b -> Rbta a b;
rbt_comp_ins c f k v Empty = Branch R Empty k v Empty;
rbt_comp_ins c f k v (Branch B l x y r) =
  (case c k x of {
    Eqa -> Branch B l x (f k y v) r;
    Lt -> balance (rbt_comp_ins c f k v l) x y r;
    Gt -> balance l x y (rbt_comp_ins c f k v r);
  });
rbt_comp_ins c f k v (Branch R l x y r) =
  (case c k x of {
    Eqa -> Branch R l x (f k y v) r;
    Lt -> Branch R (rbt_comp_ins c f k v l) x y r;
    Gt -> Branch R l x y (rbt_comp_ins c f k v r);
  });

paint :: forall a b. Color -> Rbta a b -> Rbta a b;
paint c Empty = Empty;
paint c (Branch uu l k v r) = Branch c l k v r;

rbt_comp_insert_with_key ::
  forall a b.
    (a -> a -> Ordera) -> (a -> b -> b -> b) -> a -> b -> Rbta a b -> Rbta a b;
rbt_comp_insert_with_key c f k v t = paint B (rbt_comp_ins c f k v t);

rbt_comp_insert ::
  forall a b. (a -> a -> Ordera) -> a -> b -> Rbta a b -> Rbta a b;
rbt_comp_insert c = rbt_comp_insert_with_key c (\ _ _ nv -> nv);

inserte ::
  forall a b. (Ccompare a) => a -> b -> Mapping_rbt a b -> Mapping_rbt a b;
inserte xc xd xe =
  Mapping_RBTa (rbt_comp_insert (the ccompare) xc xd (impl_ofb xe));

rbt_baliR :: forall a b. Rbta a b -> a -> b -> Rbta a b -> Rbta a b;
rbt_baliR t1 ab bb (Branch R t2 aa ba (Branch R t3 a b t4)) =
  Branch R (Branch B t1 ab bb t2) aa ba (Branch B t3 a b t4);
rbt_baliR t1 ab bb (Branch R (Branch R t2 aa ba t3) a b Empty) =
  Branch R (Branch B t1 ab bb t2) aa ba (Branch B t3 a b Empty);
rbt_baliR t1 ab bb (Branch R (Branch R t2 aa ba t3) a b (Branch B va vb vc vd))
  = Branch R (Branch B t1 ab bb t2) aa ba
      (Branch B t3 a b (Branch B va vb vc vd));
rbt_baliR t1 a b Empty = Branch B t1 a b Empty;
rbt_baliR t1 a b (Branch B va vb vc vd) =
  Branch B t1 a b (Branch B va vb vc vd);
rbt_baliR t1 a b (Branch v Empty vb vc Empty) =
  Branch B t1 a b (Branch v Empty vb vc Empty);
rbt_baliR t1 a b (Branch v (Branch B ve vf vg vh) vb vc Empty) =
  Branch B t1 a b (Branch v (Branch B ve vf vg vh) vb vc Empty);
rbt_baliR t1 a b (Branch v Empty vb vc (Branch B vf vg vh vi)) =
  Branch B t1 a b (Branch v Empty vb vc (Branch B vf vg vh vi));
rbt_baliR t1 a b (Branch v (Branch B ve vj vk vl) vb vc (Branch B vf vg vh vi))
  = Branch B t1 a b
      (Branch v (Branch B ve vj vk vl) vb vc (Branch B vf vg vh vi));

equal_color :: Color -> Color -> Bool;
equal_color R B = False;
equal_color B R = False;
equal_color B B = True;
equal_color R R = True;

suc :: Nat -> Nat;
suc n = plus_nat n one_nat;

bheight :: forall a b. Rbta a b -> Nat;
bheight Empty = zero_nat;
bheight (Branch c lt k v rt) =
  (if equal_color c B then suc (bheight lt) else bheight lt);

rbt_joinR :: forall a b. Rbta a b -> a -> b -> Rbta a b -> Rbta a b;
rbt_joinR l a b r =
  (if less_eq_nat (bheight l) (bheight r) then Branch R l a b r
    else (case l of {
           Branch R la ab ba ra -> Branch R la ab ba (rbt_joinR ra a b r);
           Branch B la ab ba ra -> rbt_baliR la ab ba (rbt_joinR ra a b r);
         }));

rbt_baliL :: forall a b. Rbta a b -> a -> b -> Rbta a b -> Rbta a b;
rbt_baliL (Branch R (Branch R t1 ab bb t2) aa ba t3) a b t4 =
  Branch R (Branch B t1 ab bb t2) aa ba (Branch B t3 a b t4);
rbt_baliL (Branch R Empty ab bb (Branch R t2 aa ba t3)) a b t4 =
  Branch R (Branch B Empty ab bb t2) aa ba (Branch B t3 a b t4);
rbt_baliL (Branch R (Branch B va vb vc vd) ab bb (Branch R t2 aa ba t3)) a b t4
  = Branch R (Branch B (Branch B va vb vc vd) ab bb t2) aa ba
      (Branch B t3 a b t4);
rbt_baliL Empty a b t2 = Branch B Empty a b t2;
rbt_baliL (Branch B va vb vc vd) a b t2 =
  Branch B (Branch B va vb vc vd) a b t2;
rbt_baliL (Branch v Empty vb vc Empty) a b t2 =
  Branch B (Branch v Empty vb vc Empty) a b t2;
rbt_baliL (Branch v Empty vb vc (Branch B ve vf vg vh)) a b t2 =
  Branch B (Branch v Empty vb vc (Branch B ve vf vg vh)) a b t2;
rbt_baliL (Branch v (Branch B vf vg vh vi) vb vc Empty) a b t2 =
  Branch B (Branch v (Branch B vf vg vh vi) vb vc Empty) a b t2;
rbt_baliL (Branch v (Branch B vf vg vh vi) vb vc (Branch B ve vj vk vl)) a b t2
  = Branch B (Branch v (Branch B vf vg vh vi) vb vc (Branch B ve vj vk vl)) a b
      t2;

rbt_joinL :: forall a b. Rbta a b -> a -> b -> Rbta a b -> Rbta a b;
rbt_joinL l a b r =
  (if less_eq_nat (bheight r) (bheight l) then Branch R l a b r
    else (case r of {
           Branch R la ab ba ra -> Branch R (rbt_joinL l a b la) ab ba ra;
           Branch B la ab ba ra -> rbt_baliL (rbt_joinL l a b la) ab ba ra;
         }));

rbt_join :: forall a b. Rbta a b -> a -> b -> Rbta a b -> Rbta a b;
rbt_join l a b r =
  let {
    bhl = bheight l;
    bhr = bheight r;
  } in (if less_nat bhr bhl then paint B (rbt_joinR l a b r)
         else (if less_nat bhl bhr then paint B (rbt_joinL l a b r)
                else Branch B l a b r));

rbt_split_comp ::
  forall a b.
    (a -> a -> Ordera) -> Rbta a b -> a -> (Rbta a b, (Maybe b, Rbta a b));
rbt_split_comp c Empty k = (Empty, (Nothing, Empty));
rbt_split_comp c (Branch uu l a b r) x =
  (case c x a of {
    Eqa -> (l, (Just b, r));
    Lt -> (case rbt_split_comp c l x of {
            (l1, (beta, l2)) -> (l1, (beta, rbt_join l2 a b r));
          });
    Gt -> (case rbt_split_comp c r x of {
            (r1, (beta, r2)) -> (rbt_join l a b r1, (beta, r2));
          });
  });

folda :: forall a b c. (a -> b -> c -> c) -> Rbta a b -> c -> c;
folda f Empty x = x;
folda f (Branch c lt k v rt) x = folda f rt (f k v (folda f lt x));

rbt_comp_union_swap_rec ::
  forall a b.
    (a -> a -> Ordera) ->
      (a -> b -> b -> b) -> Bool -> Rbta a b -> Rbta a b -> Rbta a b;
rbt_comp_union_swap_rec c f gamma t1 t2 =
  let {
    bh1 = bheight t1;
    bh2 = bheight t2;
  } in (case (if less_nat bh1 bh2 then (not gamma, (t1, (bh1, (t2, bh2))))
               else (gamma, (t2, (bh2, (t1, bh1)))))
         of {
         (gammaa, (t2a, (bh2a, (t1a, _)))) ->
           let {
             fa = (if gammaa then (\ k v va -> f k va v) else f);
           } in (if less_nat bh2a (nat_of_integer (4 :: Integer))
                  then folda (rbt_comp_insert_with_key c fa) t2a t1a
                  else (case t1a of {
                         Empty -> t2a;
                         Branch _ l1 a b r1 ->
                           (case rbt_split_comp c t2a a of {
                             (l2, (beta, r2)) ->
                               rbt_join
                                 (rbt_comp_union_swap_rec c f gammaa l1 l2) a
                                 (case beta of {
                                   Nothing -> b;
                                   Just ca -> fa a b ca;
                                 })
                                 (rbt_comp_union_swap_rec c f gammaa r1 r2);
                           });
                       }));
       });

rbt_comp_union_with_key ::
  forall a b.
    (a -> a -> Ordera) ->
      (a -> b -> b -> b) -> Rbta a b -> Rbta a b -> Rbta a b;
rbt_comp_union_with_key c f t1 t2 =
  paint B (rbt_comp_union_swap_rec c f False t1 t2);

join ::
  forall a b.
    (Ccompare a) => (a -> b -> b -> b) ->
                      Mapping_rbt a b -> Mapping_rbt a b -> Mapping_rbt a b;
join xc xd xe =
  Mapping_RBTa
    (rbt_comp_union_with_key (the ccompare) xc (impl_ofb xd) (impl_ofb xe));

list_insert :: forall a. (a -> a -> Bool) -> a -> [a] -> [a];
list_insert equal x xs = (if list_member equal xs x then xs else x : xs);

insertc :: forall a. (Ceq a) => a -> Set_dlist a -> Set_dlist a;
insertc xb xc = Abs_dlist (list_insert (the ceq) xb (list_of_dlist xc));

fold :: forall a b. (a -> b -> b) -> [a] -> b -> b;
fold f [] s = s;
fold f (x : xs) s = fold f xs (f x s);

foldc :: forall a b. (Ceq a) => (a -> b -> b) -> Set_dlist a -> b -> b;
foldc x xc = fold x (list_of_dlist xc);

unionb :: forall a. (Ceq a) => Set_dlist a -> Set_dlist a -> Set_dlist a;
unionb = foldc insertc;

is_none :: forall a. Maybe a -> Bool;
is_none Nothing = True;
is_none (Just x) = False;

inter_list ::
  forall a. (Ccompare a) => Mapping_rbt a () -> [a] -> Mapping_rbt a ();
inter_list xb xc =
  Mapping_RBTa
    (fold (\ k -> rbt_comp_insert (the ccompare) k ())
      (filter
        (\ x -> not (is_none (rbt_comp_lookup (the ccompare) (impl_ofb xb) x)))
        xc)
      Empty);

length_tailrec :: forall a. [a] -> Nat -> Nat;
length_tailrec [] n = n;
length_tailrec (x : xs) n = length_tailrec xs (suc n);

size_list :: forall a. [a] -> Nat;
size_list xs = length_tailrec xs zero_nat;

map_prod :: forall a b c d. (a -> b) -> (c -> d) -> (a, c) -> (b, d);
map_prod f g (a, b) = (f a, g b);

divmod_nat :: Nat -> Nat -> (Nat, Nat);
divmod_nat m n =
  let {
    k = integer_of_nat m;
    l = integer_of_nat n;
  } in map_prod nat_of_integer nat_of_integer
         (if k == (0 :: Integer) then ((0 :: Integer), (0 :: Integer))
           else (if l == (0 :: Integer) then ((0 :: Integer), k)
                  else divMod ( k ) ( l )));

apfst :: forall a b c. (a -> b) -> (a, c) -> (b, c);
apfst f (x, y) = (f x, y);

rbtreeify_g :: forall a b. Nat -> [(a, b)] -> (Rbta a b, [(a, b)]);
rbtreeify_g n kvs =
  (if equal_nat n zero_nat || equal_nat n one_nat then (Empty, kvs)
    else (case divmod_nat n (nat_of_integer (2 :: Integer)) of {
           (na, r) ->
             (if equal_nat r zero_nat
               then (case rbtreeify_g na kvs of {
                      (t1, (k, v) : kvsa) ->
                        apfst (Branch B t1 k v) (rbtreeify_g na kvsa);
                    })
               else (case rbtreeify_f na kvs of {
                      (t1, (k, v) : kvsa) ->
                        apfst (Branch B t1 k v) (rbtreeify_g na kvsa);
                    }));
         }));

rbtreeify_f :: forall a b. Nat -> [(a, b)] -> (Rbta a b, [(a, b)]);
rbtreeify_f n kvs =
  (if equal_nat n zero_nat then (Empty, kvs)
    else (if equal_nat n one_nat
           then (case kvs of {
                  (k, v) : kvsa -> (Branch R Empty k v Empty, kvsa);
                })
           else (case divmod_nat n (nat_of_integer (2 :: Integer)) of {
                  (na, r) ->
                    (if equal_nat r zero_nat
                      then (case rbtreeify_f na kvs of {
                             (t1, (k, v) : kvsa) ->
                               apfst (Branch B t1 k v) (rbtreeify_g na kvsa);
                           })
                      else (case rbtreeify_f na kvs of {
                             (t1, (k, v) : kvsa) ->
                               apfst (Branch B t1 k v) (rbtreeify_f na kvsa);
                           }));
                })));

rbtreeify :: forall a b. [(a, b)] -> Rbta a b;
rbtreeify kvs = fst (rbtreeify_g (suc (size_list kvs)) kvs);

gen_entries :: forall a b. [((a, b), Rbta a b)] -> Rbta a b -> [(a, b)];
gen_entries [] Empty = [];
gen_entries ((kv, t) : kvts) Empty = kv : gen_entries kvts t;
gen_entries kvts (Branch c l k v r) = gen_entries (((k, v), r) : kvts) l;

entriesa :: forall a b. Rbta a b -> [(a, b)];
entriesa = gen_entries [];

filterd ::
  forall a b.
    (Ccompare a) => ((a, b) -> Bool) -> Mapping_rbt a b -> Mapping_rbt a b;
filterd xb xc = Mapping_RBTa (rbtreeify (filter xb (entriesa (impl_ofb xc))));

map_filter :: forall a b. (a -> Maybe b) -> [a] -> [b];
map_filter f [] = [];
map_filter f (x : xs) = (case f x of {
                          Nothing -> map_filter f xs;
                          Just y -> y : map_filter f xs;
                        });

map_filter_comp_inter ::
  forall a b c d.
    (a -> a -> Ordera) ->
      (a -> b -> c -> d) -> Rbta a b -> Rbta a c -> [(a, d)];
map_filter_comp_inter c f t1 t2 =
  map_filter (\ (k, v) -> (case rbt_comp_lookup c t1 k of {
                            Nothing -> Nothing;
                            Just va -> Just (k, f k va v);
                          }))
    (entriesa t2);

is_rbt_empty :: forall a b. Rbta a b -> Bool;
is_rbt_empty t = (case t of {
                   Empty -> True;
                   Branch _ _ _ _ _ -> False;
                 });

rbt_split_min :: forall a b. Rbta a b -> (a, (b, Rbta a b));
rbt_split_min Empty = error "undefined";
rbt_split_min (Branch uu l a b r) =
  (if is_rbt_empty l then (a, (b, r))
    else (case rbt_split_min l of {
           (aa, (ba, la)) -> (aa, (ba, rbt_join la a b r));
         }));

rbt_join2 :: forall a b. Rbta a b -> Rbta a b -> Rbta a b;
rbt_join2 l r =
  (if is_rbt_empty r then l else (case rbt_split_min r of {
                                   (a, (b, c)) -> rbt_join l a b c;
                                 }));

rbt_comp_inter_swap_rec ::
  forall a b.
    (a -> a -> Ordera) ->
      (a -> b -> b -> b) -> Bool -> Rbta a b -> Rbta a b -> Rbta a b;
rbt_comp_inter_swap_rec c f gamma t1 t2 =
  let {
    bh1 = bheight t1;
    bh2 = bheight t2;
  } in (case (if less_nat bh1 bh2 then (not gamma, (t1, (bh1, (t2, bh2))))
               else (gamma, (t2, (bh2, (t1, bh1)))))
         of {
         (gammaa, (t2a, (bh2a, (t1a, _)))) ->
           let {
             fa = (if gammaa then (\ k v va -> f k va v) else f);
           } in (if less_nat bh2a (nat_of_integer (4 :: Integer))
                  then rbtreeify (map_filter_comp_inter c fa t1a t2a)
                  else (case t1a of {
                         Empty -> Empty;
                         Branch _ l1 a b r1 ->
                           (case rbt_split_comp c t2a a of {
                             (l2, (beta, r2)) ->
                               let {
                                 l = rbt_comp_inter_swap_rec c f gammaa l1 l2;
                                 r = rbt_comp_inter_swap_rec c f gammaa r1 r2;
                               } in (case beta of {
                                      Nothing -> rbt_join2 l r;
                                      Just ba -> rbt_join l a (fa a b ba) r;
                                    });
                           });
                       }));
       });

rbt_comp_inter_with_key ::
  forall a b.
    (a -> a -> Ordera) ->
      (a -> b -> b -> b) -> Rbta a b -> Rbta a b -> Rbta a b;
rbt_comp_inter_with_key c f t1 t2 =
  paint B (rbt_comp_inter_swap_rec c f False t1 t2);

meet ::
  forall a b.
    (Ccompare a) => (a -> b -> b -> b) ->
                      Mapping_rbt a b -> Mapping_rbt a b -> Mapping_rbt a b;
meet xc xd xe =
  Mapping_RBTa
    (rbt_comp_inter_with_key (the ccompare) xc (impl_ofb xd) (impl_ofb xe));

filterc :: forall a. (Ceq a) => (a -> Bool) -> Set_dlist a -> Set_dlist a;
filterc xb xc = Abs_dlist (filter xb (list_of_dlist xc));

inf_set :: forall a. (Ceq a, Ccompare a) => Set a -> Set a -> Set a;
inf_set (RBT_set rbt1) (Set_Monad xs) =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "inter RBT_set Set_Monad: ccompare = None"
        (\ _ -> inf_set (RBT_set rbt1) (Set_Monad xs));
    Just _ -> RBT_set (inter_list rbt1 xs);
  });
inf_set (Set_Monad xs) (RBT_set rbt1) =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "inter Set_Monad RBT_set: ccompare = None"
        (\ _ -> inf_set (RBT_set rbt1) (Set_Monad xs));
    Just _ -> RBT_set (inter_list rbt1 xs);
  });
inf_set (Set_Monad xs) (DList_set dxs2) =
  (case ceq of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "inter Set_Monad DList_set: ceq = None"
        (\ _ -> inf_set (Set_Monad xs) (DList_set dxs2));
    Just eq -> DList_set (filterc (list_member eq xs) dxs2);
  });
inf_set (Set_Monad xs1) (Set_Monad xs2) =
  (case ceq of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "inter Set_Monad Set_Monad: ceq = None"
        (\ _ -> inf_set (Set_Monad xs1) (Set_Monad xs2));
    Just eq -> Set_Monad (filter (list_member eq xs2) xs1);
  });
inf_set (RBT_set rbt) (DList_set dxs) =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "inter RBT_set DList_set: ccompare = None"
        (\ _ -> inf_set (RBT_set rbt) (DList_set dxs));
    Just _ ->
      (case (ceq :: Maybe (a -> a -> Bool)) of {
        Nothing ->
          (error :: forall a. String -> (() -> a) -> a)
            "inter RBT_set DList_set: ceq = None"
            (\ _ -> inf_set (RBT_set rbt) (DList_set dxs));
        Just _ -> RBT_set (inter_list rbt (list_of_dlist dxs));
      });
  });
inf_set (RBT_set rbt1) (RBT_set rbt2) =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "inter RBT_set RBT_set: ccompare = None"
        (\ _ -> inf_set (RBT_set rbt1) (RBT_set rbt2));
    Just _ -> RBT_set (meet (\ _ _ -> id) rbt1 rbt2);
  });
inf_set (DList_set dxs1) (Set_Monad xs) =
  (case ceq of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "inter DList_set Set_Monad: ceq = None"
        (\ _ -> inf_set (DList_set dxs1) (Set_Monad xs));
    Just eq -> DList_set (filterc (list_member eq xs) dxs1);
  });
inf_set (DList_set dxs1) (DList_set dxs2) =
  (case (ceq :: Maybe (a -> a -> Bool)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "inter DList_set DList_set: ceq = None"
        (\ _ -> inf_set (DList_set dxs1) (DList_set dxs2));
    Just _ -> DList_set (filterc (memberc dxs2) dxs1);
  });
inf_set (DList_set dxs) (RBT_set rbt) =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "inter DList_set RBT_set: ccompare = None"
        (\ _ -> inf_set (DList_set dxs) (RBT_set rbt));
    Just _ ->
      (case (ceq :: Maybe (a -> a -> Bool)) of {
        Nothing ->
          (error :: forall a. String -> (() -> a) -> a)
            "inter DList_set RBT_set: ceq = None"
            (\ _ -> inf_set (DList_set dxs) (RBT_set rbt));
        Just _ -> RBT_set (inter_list rbt (list_of_dlist dxs));
      });
  });
inf_set (Complement ba) (Complement b) = Complement (sup_set ba b);
inf_set g (RBT_set rbt2) =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "inter RBT_set2: ccompare = None" (\ _ -> inf_set g (RBT_set rbt2));
    Just _ -> RBT_set (filterd ((\ x -> member x g) . fst) rbt2);
  });
inf_set (RBT_set rbt1) g =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "inter RBT_set1: ccompare = None" (\ _ -> inf_set (RBT_set rbt1) g);
    Just _ -> RBT_set (filterd ((\ x -> member x g) . fst) rbt1);
  });
inf_set h (DList_set dxs2) =
  (case (ceq :: Maybe (a -> a -> Bool)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "inter DList_set2: ceq = None" (\ _ -> inf_set h (DList_set dxs2));
    Just _ -> DList_set (filterc (\ x -> member x h) dxs2);
  });
inf_set (DList_set dxs1) h =
  (case (ceq :: Maybe (a -> a -> Bool)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "inter DList_set1: ceq = None" (\ _ -> inf_set (DList_set dxs1) h);
    Just _ -> DList_set (filterc (\ x -> member x h) dxs1);
  });
inf_set i (Set_Monad xs) = Set_Monad (filter (\ x -> member x i) xs);
inf_set (Set_Monad xs) i = Set_Monad (filter (\ x -> member x i) xs);
inf_set j (Collect_set a) = Collect_set (\ x -> a x && member x j);
inf_set (Collect_set a) j = Collect_set (\ x -> a x && member x j);

sup_set :: forall a. (Ceq a, Ccompare a) => Set a -> Set a -> Set a;
sup_set ba (Complement b) = Complement (inf_set (uminus_set ba) b);
sup_set (Complement ba) b = Complement (inf_set ba (uminus_set b));
sup_set (RBT_set rbt1) (RBT_set rbt2) =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "union RBT_set RBT_set: ccompare = None"
        (\ _ -> sup_set (RBT_set rbt1) (RBT_set rbt2));
    Just _ -> RBT_set (join (\ _ _ -> id) rbt1 rbt2);
  });
sup_set (RBT_set rbt) (DList_set dxs) =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "union RBT_set DList_set: ccompare = None"
        (\ _ -> sup_set (RBT_set rbt) (DList_set dxs));
    Just _ ->
      (case (ceq :: Maybe (a -> a -> Bool)) of {
        Nothing ->
          (error :: forall a. String -> (() -> a) -> a)
            "union RBT_set DList_set: ceq = None"
            (\ _ -> sup_set (RBT_set rbt) (DList_set dxs));
        Just _ -> RBT_set (foldc (\ k -> inserte k ()) dxs rbt);
      });
  });
sup_set (DList_set dxs) (RBT_set rbt) =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "union DList_set RBT_set: ccompare = None"
        (\ _ -> sup_set (RBT_set rbt) (DList_set dxs));
    Just _ ->
      (case (ceq :: Maybe (a -> a -> Bool)) of {
        Nothing ->
          (error :: forall a. String -> (() -> a) -> a)
            "union DList_set RBT_set: ceq = None"
            (\ _ -> sup_set (RBT_set rbt) (DList_set dxs));
        Just _ -> RBT_set (foldc (\ k -> inserte k ()) dxs rbt);
      });
  });
sup_set (DList_set dxs1) (DList_set dxs2) =
  (case (ceq :: Maybe (a -> a -> Bool)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "union DList_set DList_set: ceq = None"
        (\ _ -> sup_set (DList_set dxs1) (DList_set dxs2));
    Just _ -> DList_set (unionb dxs1 dxs2);
  });
sup_set (Set_Monad zs) (RBT_set rbt2) =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "union Set_Monad RBT_set: ccompare = None"
        (\ _ -> sup_set (Set_Monad zs) (RBT_set rbt2));
    Just _ -> RBT_set (fold (\ k -> inserte k ()) zs rbt2);
  });
sup_set (RBT_set rbt1) (Set_Monad zs) =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "union RBT_set Set_Monad: ccompare = None"
        (\ _ -> sup_set (RBT_set rbt1) (Set_Monad zs));
    Just _ -> RBT_set (fold (\ k -> inserte k ()) zs rbt1);
  });
sup_set (Set_Monad ws) (DList_set dxs2) =
  (case (ceq :: Maybe (a -> a -> Bool)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "union Set_Monad DList_set: ceq = None"
        (\ _ -> sup_set (Set_Monad ws) (DList_set dxs2));
    Just _ -> DList_set (fold insertc ws dxs2);
  });
sup_set (DList_set dxs1) (Set_Monad ws) =
  (case (ceq :: Maybe (a -> a -> Bool)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "union DList_set Set_Monad: ceq = None"
        (\ _ -> sup_set (DList_set dxs1) (Set_Monad ws));
    Just _ -> DList_set (fold insertc ws dxs1);
  });
sup_set (Set_Monad xs) (Set_Monad ys) = Set_Monad (xs ++ ys);
sup_set b (Collect_set a) = Collect_set (\ x -> a x || member x b);
sup_set (Collect_set a) b = Collect_set (\ x -> a x || member x b);

instance (Ceq a, Ccompare a) => Inf (Set a) where {
  inf = inf_set;
};

instance (Ceq a, Ccompare a) => Sup (Set a) where {
  sup = sup_set;
};

less_set :: forall a. (Cenum a, Ceq a, Ccompare a) => Set a -> Set a -> Bool;
less_set a b = less_eq_set a b && not (less_eq_set b a);

instance (Cenum a, Ceq a, Ccompare a) => Ord (Set a) where {
  less_eq = less_eq_set;
  less = less_set;
};

instance (Cenum a, Ceq a, Ccompare a) => Quasi_order (Set a) where {
};

instance (Cenum a, Ceq a, Ccompare a) => Weak_order (Set a) where {
};

instance (Cenum a, Ceq a, Ccompare a) => Preorder (Set a) where {
};

instance (Cenum a, Ceq a, Ccompare a) => Order (Set a) where {
};

instance (Cenum a, Ceq a, Ccompare a) => Quasi_order_sup (Set a) where {
};

instance (Cenum a, Ceq a, Ccompare a) => Quasi_semilattice_sup (Set a) where {
};

instance (Cenum a, Ceq a, Ccompare a) => Semilattice_sup (Set a) where {
};

instance (Cenum a, Ceq a, Ccompare a) => Semilattice_inf (Set a) where {
};

instance (Cenum a, Ceq a, Ccompare a) => Lattice (Set a) where {
};

list_all2_fusion ::
  forall a b c d.
    (a -> b -> Bool) -> Generator a c -> Generator b d -> c -> d -> Bool;
list_all2_fusion p g1 g2 s1 s2 =
  (if has_next g1 s1
    then has_next g2 s2 &&
           (case next g1 s1 of {
             (x, s1a) ->
               (case next g2 s2 of {
                 (y, s2a) -> p x y && list_all2_fusion p g1 g2 s1a s2a;
               });
           })
    else not (has_next g2 s2));

set_eq :: forall a. (Cenum a, Ceq a, Ccompare a) => Set a -> Set a -> Bool;
set_eq (RBT_set rbt1) (RBT_set rbt2) =
  (case ccompare of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "set_eq RBT_set RBT_set: ccompare = None"
        (\ _ -> set_eq (RBT_set rbt1) (RBT_set rbt2));
    Just c ->
      (case ceq of {
        Nothing ->
          list_all2_fusion (\ x y -> equal_order (c x y) Eqa) rbt_keys_generator
            rbt_keys_generator (init rbt1) (init rbt2);
        Just eq ->
          list_all2_fusion eq rbt_keys_generator rbt_keys_generator (init rbt1)
            (init rbt2);
      });
  });
set_eq (Complement a) (Complement b) = set_eq a b;
set_eq a b = less_eq_set a b && less_eq_set b a;

ceq_set ::
  forall a. (Cenum a, Ceq a, Ccompare a) => Maybe (Set a -> Set a -> Bool);
ceq_set = (case (ceq :: Maybe (a -> a -> Bool)) of {
            Nothing -> Nothing;
            Just _ -> Just set_eq;
          });

instance (Cenum a, Ceq a, Ccompare a) => Ceq (Set a) where {
  ceq = ceq_set;
};

set_impl_set :: forall a. Phantom (Set a) Set_impla;
set_impl_set = Phantom Set_Choose;

instance Set_impl (Set a) where {
  set_impl = set_impl_set;
};

of_phantom :: forall a b. Phantom a b -> b;
of_phantom (Phantom x) = x;

emptye :: forall a b. (Ccompare a) => Mapping_rbt a b;
emptye = Mapping_RBTa Empty;

emptyc :: forall a. (Ceq a) => Set_dlist a;
emptyc = Abs_dlist [];

set_empty_choose :: forall a. (Ceq a, Ccompare a) => Set a;
set_empty_choose = (case (ccompare :: Maybe (a -> a -> Ordera)) of {
                     Nothing -> (case (ceq :: Maybe (a -> a -> Bool)) of {
                                  Nothing -> Set_Monad [];
                                  Just _ -> DList_set emptyc;
                                });
                     Just _ -> RBT_set emptye;
                   });

set_empty :: forall a. (Ceq a, Ccompare a) => Set_impla -> Set a;
set_empty Set_Collect = Collect_set (\ _ -> False);
set_empty Set_DList = DList_set emptyc;
set_empty Set_RBT = RBT_set emptye;
set_empty Set_Monada = Set_Monad [];
set_empty Set_Choose = set_empty_choose;

fun_upda :: forall a b. (a -> a -> Bool) -> (a -> b) -> a -> b -> a -> b;
fun_upda equal f aa b a = (if equal aa a then b else f a);

balance_right :: forall a b. Rbta a b -> a -> b -> Rbta a b -> Rbta a b;
balance_right a k x (Branch R b s y c) = Branch R a k x (Branch B b s y c);
balance_right (Branch B a k x b) s y Empty =
  balance (Branch R a k x b) s y Empty;
balance_right (Branch B a k x b) s y (Branch B va vb vc vd) =
  balance (Branch R a k x b) s y (Branch B va vb vc vd);
balance_right (Branch R a k x (Branch B b s y c)) t z Empty =
  Branch R (balance (paint R a) k x b) s y (Branch B c t z Empty);
balance_right (Branch R a k x (Branch B b s y c)) t z (Branch B va vb vc vd) =
  Branch R (balance (paint R a) k x b) s y
    (Branch B c t z (Branch B va vb vc vd));
balance_right Empty k x Empty = Empty;
balance_right (Branch R va vb vc Empty) k x Empty = Empty;
balance_right (Branch R va vb vc (Branch R ve vf vg vh)) k x Empty = Empty;
balance_right Empty k x (Branch B va vb vc vd) = Empty;
balance_right (Branch R ve vf vg Empty) k x (Branch B va vb vc vd) = Empty;
balance_right (Branch R ve vf vg (Branch R vi vj vk vl)) k x
  (Branch B va vb vc vd) = Empty;

balance_left :: forall a b. Rbta a b -> a -> b -> Rbta a b -> Rbta a b;
balance_left (Branch R a k x b) s y c = Branch R (Branch B a k x b) s y c;
balance_left Empty k x (Branch B a s y b) =
  balance Empty k x (Branch R a s y b);
balance_left (Branch B va vb vc vd) k x (Branch B a s y b) =
  balance (Branch B va vb vc vd) k x (Branch R a s y b);
balance_left Empty k x (Branch R (Branch B a s y b) t z c) =
  Branch R (Branch B Empty k x a) s y (balance b t z (paint R c));
balance_left (Branch B va vb vc vd) k x (Branch R (Branch B a s y b) t z c) =
  Branch R (Branch B (Branch B va vb vc vd) k x a) s y
    (balance b t z (paint R c));
balance_left Empty k x Empty = Empty;
balance_left Empty k x (Branch R Empty vb vc vd) = Empty;
balance_left Empty k x (Branch R (Branch R ve vf vg vh) vb vc vd) = Empty;
balance_left (Branch B va vb vc vd) k x Empty = Empty;
balance_left (Branch B va vb vc vd) k x (Branch R Empty vf vg vh) = Empty;
balance_left (Branch B va vb vc vd) k x
  (Branch R (Branch R vi vj vk vl) vf vg vh) = Empty;

combine :: forall a b. Rbta a b -> Rbta a b -> Rbta a b;
combine Empty x = x;
combine (Branch v va vb vc vd) Empty = Branch v va vb vc vd;
combine (Branch R a k x b) (Branch R c s y d) =
  (case combine b c of {
    Empty -> Branch R a k x (Branch R Empty s y d);
    Branch R b2 t z c2 -> Branch R (Branch R a k x b2) t z (Branch R c2 s y d);
    Branch B b2 t z c2 -> Branch R a k x (Branch R (Branch B b2 t z c2) s y d);
  });
combine (Branch B a k x b) (Branch B c s y d) =
  (case combine b c of {
    Empty -> balance_left a k x (Branch B Empty s y d);
    Branch R b2 t z c2 -> Branch R (Branch B a k x b2) t z (Branch B c2 s y d);
    Branch B b2 t z c2 ->
      balance_left a k x (Branch B (Branch B b2 t z c2) s y d);
  });
combine (Branch B va vb vc vd) (Branch R b k x c) =
  Branch R (combine (Branch B va vb vc vd) b) k x c;
combine (Branch R a k x b) (Branch B va vb vc vd) =
  Branch R a k x (combine b (Branch B va vb vc vd));

rbt_comp_del :: forall a b. (a -> a -> Ordera) -> a -> Rbta a b -> Rbta a b;
rbt_comp_del c x Empty = Empty;
rbt_comp_del c x (Branch uu a y s b) =
  (case c x y of {
    Eqa -> combine a b;
    Lt -> rbt_comp_del_from_left c x a y s b;
    Gt -> rbt_comp_del_from_right c x a y s b;
  });

rbt_comp_del_from_left ::
  forall a b.
    (a -> a -> Ordera) -> a -> Rbta a b -> a -> b -> Rbta a b -> Rbta a b;
rbt_comp_del_from_left c x (Branch B lt z v rt) y s b =
  balance_left (rbt_comp_del c x (Branch B lt z v rt)) y s b;
rbt_comp_del_from_left c x Empty y s b =
  Branch R (rbt_comp_del c x Empty) y s b;
rbt_comp_del_from_left c x (Branch R va vb vc vd) y s b =
  Branch R (rbt_comp_del c x (Branch R va vb vc vd)) y s b;

rbt_comp_del_from_right ::
  forall a b.
    (a -> a -> Ordera) -> a -> Rbta a b -> a -> b -> Rbta a b -> Rbta a b;
rbt_comp_del_from_right c x a y s (Branch B lt z v rt) =
  balance_right a y s (rbt_comp_del c x (Branch B lt z v rt));
rbt_comp_del_from_right c x a y s Empty =
  Branch R a y s (rbt_comp_del c x Empty);
rbt_comp_del_from_right c x a y s (Branch R va vb vc vd) =
  Branch R a y s (rbt_comp_del c x (Branch R va vb vc vd));

rbt_comp_delete :: forall a b. (a -> a -> Ordera) -> a -> Rbta a b -> Rbta a b;
rbt_comp_delete c k t = paint B (rbt_comp_del c k t);

deletec :: forall a b. (Ccompare a) => a -> Mapping_rbt a b -> Mapping_rbt a b;
deletec xb xc = Mapping_RBTa (rbt_comp_delete (the ccompare) xb (impl_ofb xc));

list_remove1 :: forall a. (a -> a -> Bool) -> a -> [a] -> [a];
list_remove1 equal x [] = [];
list_remove1 equal x (y : xs) =
  (if equal x y then xs else y : list_remove1 equal x xs);

removea :: forall a. (Ceq a) => a -> Set_dlist a -> Set_dlist a;
removea xb xc = Abs_dlist (list_remove1 (the ceq) xb (list_of_dlist xc));

inserta :: forall a. (Ceq a, Ccompare a) => a -> Set a -> Set a;
inserta xa (Complement x) = Complement (remove xa x);
inserta x (RBT_set rbt) =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "insert RBT_set: ccompare = None" (\ _ -> inserta x (RBT_set rbt));
    Just _ -> RBT_set (inserte x () rbt);
  });
inserta x (DList_set dxs) =
  (case (ceq :: Maybe (a -> a -> Bool)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "insert DList_set: ceq = None" (\ _ -> inserta x (DList_set dxs));
    Just _ -> DList_set (insertc x dxs);
  });
inserta x (Set_Monad xs) = Set_Monad (x : xs);
inserta x (Collect_set a) =
  (case ceq of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "insert Collect_set: ceq = None" (\ _ -> inserta x (Collect_set a));
    Just eq -> Collect_set (fun_upda eq a x True);
  });

remove :: forall a. (Ceq a, Ccompare a) => a -> Set a -> Set a;
remove x (Complement a) = Complement (inserta x a);
remove x (RBT_set rbt) =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "remove RBT_set: ccompare = None" (\ _ -> remove x (RBT_set rbt));
    Just _ -> RBT_set (deletec x rbt);
  });
remove x (DList_set dxs) =
  (case (ceq :: Maybe (a -> a -> Bool)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "remove DList_set: ceq = None" (\ _ -> remove x (DList_set dxs));
    Just _ -> DList_set (removea x dxs);
  });
remove x (Collect_set a) =
  (case ceq of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a) "remove Collect: ceq = None"
        (\ _ -> remove x (Collect_set a));
    Just eq -> Collect_set (fun_upda eq a x False);
  });

foldl :: forall a b. (a -> b -> a) -> a -> [b] -> a;
foldl f a [] = a;
foldl f a (x : xs) = foldl f (f a x) xs;

set_aux :: forall a. (Ceq a, Ccompare a) => Set_impla -> [a] -> Set a;
set_aux Set_Monada = Set_Monad;
set_aux Set_Choose =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing -> (case (ceq :: Maybe (a -> a -> Bool)) of {
                 Nothing -> Set_Monad;
                 Just _ -> foldl (\ s x -> inserta x s) (DList_set emptyc);
               });
    Just _ -> foldl (\ s x -> inserta x s) (RBT_set emptye);
  });
set_aux impl = foldl (\ s x -> inserta x s) (set_empty impl);

set :: forall a. (Ceq a, Ccompare a, Set_impl a) => [a] -> Set a;
set xs = set_aux (of_phantom (set_impl :: Phantom a Set_impla)) xs;

subseqs :: forall a. [a] -> [[a]];
subseqs [] = [[]];
subseqs (x : xs) = let {
                     xss = subseqs xs;
                   } in map (\ a -> x : a) xss ++ xss;

cEnum_set ::
  forall a.
    (Cenum a, Ceq a, Ccompare a,
      Set_impl a) => Maybe ([Set a],
                             ((Set a -> Bool) -> Bool,
                               (Set a -> Bool) -> Bool));
cEnum_set =
  (case cEnum of {
    Nothing -> Nothing;
    Just (enum_a, (_, _)) ->
      Just (map set (subseqs enum_a),
             ((\ p -> all p (map set (subseqs enum_a))),
               (\ p -> any p (map set (subseqs enum_a)))));
  });

instance (Cenum a, Ceq a, Ccompare a, Set_impl a) => Cenum (Set a) where {
  cEnum = cEnum_set;
};

finite_UNIV_set :: forall a. (Finite_UNIV a) => Phantom (Set a) Bool;
finite_UNIV_set = Phantom (of_phantom (finite_UNIV :: Phantom a Bool));

instance (Finite_UNIV a) => Finite_UNIV (Set a) where {
  finite_UNIV = finite_UNIV_set;
};

set_less_eq_aux_Compl_fusion ::
  forall a b c.
    (a -> a -> Bool) ->
      (Maybe a -> Maybe a -> Bool) ->
        Generator a b -> Generator a c -> Maybe a -> b -> c -> Bool;
set_less_eq_aux_Compl_fusion less proper_interval g1 g2 ao s1 s2 =
  (if has_next g1 s1
    then (if has_next g2 s2
           then (case next g1 s1 of {
                  (x, s1a) ->
                    (case next g2 s2 of {
                      (y, s2a) ->
                        (if less x y
                          then proper_interval ao (Just x) ||
                                 set_less_eq_aux_Compl_fusion less
                                   proper_interval g1 g2 (Just x) s1a s2
                          else (if less y x
                                 then proper_interval ao (Just y) ||
set_less_eq_aux_Compl_fusion less proper_interval g1 g2 (Just y) s1 s2a
                                 else proper_interval ao (Just y)));
                    });
                })
           else True)
    else True);

compl_set_less_eq_aux_fusion ::
  forall a b c.
    (a -> a -> Bool) ->
      (Maybe a -> Maybe a -> Bool) ->
        Generator a b -> Generator a c -> Maybe a -> b -> c -> Bool;
compl_set_less_eq_aux_fusion less proper_interval g1 g2 ao s1 s2 =
  (if has_next g1 s1
    then (case next g1 s1 of {
           (x, s1a) ->
             (if has_next g2 s2
               then (case next g2 s2 of {
                      (y, s2a) ->
                        (if less x y
                          then not (proper_interval ao (Just x)) &&
                                 compl_set_less_eq_aux_fusion less
                                   proper_interval g1 g2 (Just x) s1a s2
                          else (if less y x
                                 then not (proper_interval ao (Just y)) &&
compl_set_less_eq_aux_fusion less proper_interval g1 g2 (Just y) s1 s2a
                                 else not (proper_interval ao (Just y))));
                    })
               else not (proper_interval ao (Just x)) &&
                      compl_set_less_eq_aux_fusion less proper_interval g1 g2
                        (Just x) s1a s2);
         })
    else (if has_next g2 s2
           then (case next g2 s2 of {
                  (y, s2a) ->
                    not (proper_interval ao (Just y)) &&
                      compl_set_less_eq_aux_fusion less proper_interval g1 g2
                        (Just y) s1 s2a;
                })
           else not (proper_interval ao Nothing)));

set_less_eq_aux_Compl ::
  forall a.
    (a -> a -> Bool) ->
      (Maybe a -> Maybe a -> Bool) -> Maybe a -> [a] -> [a] -> Bool;
set_less_eq_aux_Compl less proper_interval ao [] ys = True;
set_less_eq_aux_Compl less proper_interval ao xs [] = True;
set_less_eq_aux_Compl less proper_interval ao (x : xs) (y : ys) =
  (if less x y
    then proper_interval ao (Just x) ||
           set_less_eq_aux_Compl less proper_interval (Just x) xs (y : ys)
    else (if less y x
           then proper_interval ao (Just y) ||
                  set_less_eq_aux_Compl less proper_interval (Just y) (x : xs)
                    ys
           else proper_interval ao (Just y)));

compl_set_less_eq_aux ::
  forall a.
    (a -> a -> Bool) ->
      (Maybe a -> Maybe a -> Bool) -> Maybe a -> [a] -> [a] -> Bool;
compl_set_less_eq_aux less proper_interval ao [] [] =
  not (proper_interval ao Nothing);
compl_set_less_eq_aux less proper_interval ao [] (y : ys) =
  not (proper_interval ao (Just y)) &&
    compl_set_less_eq_aux less proper_interval (Just y) [] ys;
compl_set_less_eq_aux less proper_interval ao (x : xs) [] =
  not (proper_interval ao (Just x)) &&
    compl_set_less_eq_aux less proper_interval (Just x) xs [];
compl_set_less_eq_aux less proper_interval ao (x : xs) (y : ys) =
  (if less x y
    then not (proper_interval ao (Just x)) &&
           compl_set_less_eq_aux less proper_interval (Just x) xs (y : ys)
    else (if less y x
           then not (proper_interval ao (Just y)) &&
                  compl_set_less_eq_aux less proper_interval (Just y) (x : xs)
                    ys
           else not (proper_interval ao (Just y))));

lexord_eq_fusion ::
  forall a b c.
    (a -> a -> Bool) -> Generator a b -> Generator a c -> b -> c -> Bool;
lexord_eq_fusion less g1 g2 s1 s2 =
  (if has_next g1 s1
    then has_next g2 s2 &&
           (case next g1 s1 of {
             (x, s1a) ->
               (case next g2 s2 of {
                 (y, s2a) ->
                   less x y ||
                     not (less y x) && lexord_eq_fusion less g1 g2 s1a s2a;
               });
           })
    else True);

remdups_sorted :: forall a. (a -> a -> Bool) -> [a] -> [a];
remdups_sorted less [] = [];
remdups_sorted less [x] = [x];
remdups_sorted less (x : y : xs) =
  (if less x y then x : remdups_sorted less (y : xs)
    else remdups_sorted less (y : xs));

quicksort_acc :: forall a. (a -> a -> Bool) -> [a] -> [a] -> [a];
quicksort_acc less ac [] = ac;
quicksort_acc less ac [x] = x : ac;
quicksort_acc less ac (x : v : va) = quicksort_part less ac x [] [] [] (v : va);

quicksort_part ::
  forall a. (a -> a -> Bool) -> [a] -> a -> [a] -> [a] -> [a] -> [a] -> [a];
quicksort_part less ac x lts eqs gts [] =
  quicksort_acc less (eqs ++ x : quicksort_acc less ac gts) lts;
quicksort_part less ac x lts eqs gts (z : zs) =
  (if less x z then quicksort_part less ac x lts eqs (z : gts) zs
    else (if less z x then quicksort_part less ac x (z : lts) eqs gts zs
           else quicksort_part less ac x lts (z : eqs) gts zs));

quicksort :: forall a. (a -> a -> Bool) -> [a] -> [a];
quicksort less = quicksort_acc less [];

gen_keys :: forall a b. [(a, Rbta a b)] -> Rbta a b -> [a];
gen_keys [] Empty = [];
gen_keys ((k, t) : kts) Empty = k : gen_keys kts t;
gen_keys kts (Branch c l k v r) = gen_keys ((k, r) : kts) l;

keysa :: forall a b. Rbta a b -> [a];
keysa = gen_keys [];

keysb :: forall a. (Ccompare a) => Mapping_rbt a () -> [a];
keysb xa = keysa (impl_ofb xa);

csorted_list_of_set :: forall a. (Ceq a, Ccompare a) => Set a -> [a];
csorted_list_of_set (Set_Monad xs) =
  (case ccompare of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "csorted_list_of_set Set_Monad: ccompare = None"
        (\ _ -> csorted_list_of_set (Set_Monad xs));
    Just c -> remdups_sorted (lt_of_comp c) (quicksort (lt_of_comp c) xs);
  });
csorted_list_of_set (DList_set dxs) =
  (case (ceq :: Maybe (a -> a -> Bool)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "csorted_list_of_set DList_set: ceq = None"
        (\ _ -> csorted_list_of_set (DList_set dxs));
    Just _ ->
      (case ccompare of {
        Nothing ->
          (error :: forall a. String -> (() -> a) -> a)
            "csorted_list_of_set DList_set: ccompare = None"
            (\ _ -> csorted_list_of_set (DList_set dxs));
        Just c -> quicksort (lt_of_comp c) (list_of_dlist dxs);
      });
  });
csorted_list_of_set (RBT_set rbt) =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "csorted_list_of_set RBT_set: ccompare = None"
        (\ _ -> csorted_list_of_set (RBT_set rbt));
    Just _ -> keysb rbt;
  });

bot_set :: forall a. (Ceq a, Ccompare a, Set_impl a) => Set a;
bot_set = set_empty (of_phantom (set_impl :: Phantom a Set_impla));

top_set :: forall a. (Ceq a, Ccompare a, Set_impl a) => Set a;
top_set = uminus_set bot_set;

le_of_comp :: forall a. (a -> a -> Ordera) -> a -> a -> Bool;
le_of_comp acomp x y = (case acomp x y of {
                         Eqa -> True;
                         Lt -> True;
                         Gt -> False;
                       });

lexordp_eq :: forall a. (a -> a -> Bool) -> [a] -> [a] -> Bool;
lexordp_eq less [] ys = True;
lexordp_eq less xs [] = null xs;
lexordp_eq less (x : xs) (y : ys) =
  less x y || not (less y x) && lexordp_eq less xs ys;

finite :: forall a. (Finite_UNIV a, Ceq a, Ccompare a) => Set a -> Bool;
finite (Collect_set p) =
  of_phantom (finite_UNIV :: Phantom a Bool) ||
    (error :: forall a. String -> (() -> a) -> a) "finite Collect_set"
      (\ _ -> finite (Collect_set p));
finite (Set_Monad xs) = True;
finite (Complement a) =
  (if of_phantom (finite_UNIV :: Phantom a Bool) then True
    else (if finite a then False
           else (error :: forall a. String -> (() -> a) -> a)
                  "finite Complement: infinite set"
                  (\ _ -> finite (Complement a))));
finite (RBT_set rbt) =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "finite RBT_set: ccompare = None" (\ _ -> finite (RBT_set rbt));
    Just _ -> True;
  });
finite (DList_set dxs) =
  (case (ceq :: Maybe (a -> a -> Bool)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "finite DList_set: ceq = None" (\ _ -> finite (DList_set dxs));
    Just _ -> True;
  });

set_less_aux_Compl_fusion ::
  forall a b c.
    (a -> a -> Bool) ->
      (Maybe a -> Maybe a -> Bool) ->
        Generator a b -> Generator a c -> Maybe a -> b -> c -> Bool;
set_less_aux_Compl_fusion less proper_interval g1 g2 ao s1 s2 =
  (if has_next g1 s1
    then (case next g1 s1 of {
           (x, s1a) ->
             (if has_next g2 s2
               then (case next g2 s2 of {
                      (y, s2a) ->
                        (if less x y
                          then proper_interval ao (Just x) ||
                                 set_less_aux_Compl_fusion less proper_interval
                                   g1 g2 (Just x) s1a s2
                          else (if less y x
                                 then proper_interval ao (Just y) ||
set_less_aux_Compl_fusion less proper_interval g1 g2 (Just y) s1 s2a
                                 else proper_interval ao (Just y)));
                    })
               else proper_interval ao (Just x) ||
                      set_less_aux_Compl_fusion less proper_interval g1 g2
                        (Just x) s1a s2);
         })
    else (if has_next g2 s2
           then (case next g2 s2 of {
                  (y, s2a) ->
                    proper_interval ao (Just y) ||
                      set_less_aux_Compl_fusion less proper_interval g1 g2
                        (Just y) s1 s2a;
                })
           else proper_interval ao Nothing));

compl_set_less_aux_fusion ::
  forall a b c.
    (a -> a -> Bool) ->
      (Maybe a -> Maybe a -> Bool) ->
        Generator a b -> Generator a c -> Maybe a -> b -> c -> Bool;
compl_set_less_aux_fusion less proper_interval g1 g2 ao s1 s2 =
  has_next g1 s1 &&
    has_next g2 s2 &&
      (case next g1 s1 of {
        (x, s1a) ->
          (case next g2 s2 of {
            (y, s2a) ->
              (if less x y
                then not (proper_interval ao (Just x)) &&
                       compl_set_less_aux_fusion less proper_interval g1 g2
                         (Just x) s1a s2
                else (if less y x
                       then not (proper_interval ao (Just y)) &&
                              compl_set_less_aux_fusion less proper_interval g1
                                g2 (Just y) s1 s2a
                       else not (proper_interval ao (Just y))));
          });
      });

set_less_aux_Compl ::
  forall a.
    (a -> a -> Bool) ->
      (Maybe a -> Maybe a -> Bool) -> Maybe a -> [a] -> [a] -> Bool;
set_less_aux_Compl less proper_interval ao [] [] = proper_interval ao Nothing;
set_less_aux_Compl less proper_interval ao [] (y : ys) =
  proper_interval ao (Just y) ||
    set_less_aux_Compl less proper_interval (Just y) [] ys;
set_less_aux_Compl less proper_interval ao (x : xs) [] =
  proper_interval ao (Just x) ||
    set_less_aux_Compl less proper_interval (Just x) xs [];
set_less_aux_Compl less proper_interval ao (x : xs) (y : ys) =
  (if less x y
    then proper_interval ao (Just x) ||
           set_less_aux_Compl less proper_interval (Just x) xs (y : ys)
    else (if less y x
           then proper_interval ao (Just y) ||
                  set_less_aux_Compl less proper_interval (Just y) (x : xs) ys
           else proper_interval ao (Just y)));

compl_set_less_aux ::
  forall a.
    (a -> a -> Bool) ->
      (Maybe a -> Maybe a -> Bool) -> Maybe a -> [a] -> [a] -> Bool;
compl_set_less_aux less proper_interval ao [] ys = False;
compl_set_less_aux less proper_interval ao xs [] = False;
compl_set_less_aux less proper_interval ao (x : xs) (y : ys) =
  (if less x y
    then not (proper_interval ao (Just x)) &&
           compl_set_less_aux less proper_interval (Just x) xs (y : ys)
    else (if less y x
           then not (proper_interval ao (Just y)) &&
                  compl_set_less_aux less proper_interval (Just y) (x : xs) ys
           else not (proper_interval ao (Just y))));

lexord_fusion ::
  forall a b c.
    (a -> a -> Bool) -> Generator a b -> Generator a c -> b -> c -> Bool;
lexord_fusion less g1 g2 s1 s2 =
  (if has_next g1 s1
    then (if has_next g2 s2
           then (case next g1 s1 of {
                  (x, s1a) ->
                    (case next g2 s2 of {
                      (y, s2a) ->
                        less x y ||
                          not (less y x) && lexord_fusion less g1 g2 s1a s2a;
                    });
                })
           else False)
    else has_next g2 s2);

lexordp :: forall a. (a -> a -> Bool) -> [a] -> [a] -> Bool;
lexordp less [] ys = not (null ys);
lexordp less xs [] = False;
lexordp less (x : xs) (y : ys) =
  less x y || not (less y x) && lexordp less xs ys;

comp_of_ords ::
  forall a. (a -> a -> Bool) -> (a -> a -> Bool) -> a -> a -> Ordera;
comp_of_ords le lt x y = (if lt x y then Lt else (if le x y then Eqa else Gt));

ccompare_set ::
  forall a.
    (Finite_UNIV a, Ceq a, Cproper_interval a,
      Set_impl a) => Maybe (Set a -> Set a -> Ordera);
ccompare_set = (case (ccompare :: Maybe (a -> a -> Ordera)) of {
                 Nothing -> Nothing;
                 Just _ -> Just (comp_of_ords cless_eq_set cless_set);
               });

cless_set ::
  forall a.
    (Finite_UNIV a, Ceq a, Cproper_interval a,
      Set_impl a) => Set a -> Set a -> Bool;
cless_set (Complement (RBT_set rbt1)) (RBT_set rbt2) =
  (case ccompare of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "cless_set (Complement RBT_set) RBT_set: ccompare = None"
        (\ _ -> cless_set (Complement (RBT_set rbt1)) (RBT_set rbt2));
    Just c ->
      (finite :: Set a -> Bool) (top_set :: Set a) &&
        compl_set_less_aux_fusion (lt_of_comp c) cproper_interval
          rbt_keys_generator rbt_keys_generator Nothing (init rbt1) (init rbt2);
  });
cless_set (RBT_set rbt1) (Complement (RBT_set rbt2)) =
  (case ccompare of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "cless_set RBT_set (Complement RBT_set): ccompare = None"
        (\ _ -> cless_set (RBT_set rbt1) (Complement (RBT_set rbt2)));
    Just c ->
      (if (finite :: Set a -> Bool) (top_set :: Set a)
        then set_less_aux_Compl_fusion (lt_of_comp c) cproper_interval
               rbt_keys_generator rbt_keys_generator Nothing (init rbt1)
               (init rbt2)
        else True);
  });
cless_set (RBT_set rbta) (RBT_set rbt) =
  (case ccompare of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "cless_set RBT_set RBT_set: ccompare = None"
        (\ _ -> cless_set (RBT_set rbta) (RBT_set rbt));
    Just c ->
      lexord_fusion (\ x y -> lt_of_comp c y x) rbt_keys_generator
        rbt_keys_generator (init rbta) (init rbt);
  });
cless_set (Complement a) (Complement b) =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "cless_set Complement Complement: ccompare = None"
        (\ _ -> cless_set (Complement a) (Complement b));
    Just _ -> lt_of_comp (the ccompare_set) b a;
  });
cless_set (Complement a) b =
  (case ccompare of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "cless_set Complement1: ccompare = None"
        (\ _ -> cless_set (Complement a) b);
    Just c ->
      (if finite a && finite b
        then (finite :: Set a -> Bool) (top_set :: Set a) &&
               compl_set_less_aux (lt_of_comp c) cproper_interval Nothing
                 (csorted_list_of_set a) (csorted_list_of_set b)
        else (error :: forall a. String -> (() -> a) -> a)
               "cless_set Complement1: infinite set"
               (\ _ -> cless_set (Complement a) b));
  });
cless_set a (Complement b) =
  (case ccompare of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "cless_set Complement2: ccompare = None"
        (\ _ -> cless_set a (Complement b));
    Just c ->
      (if finite a && finite b
        then (if (finite :: Set a -> Bool) (top_set :: Set a)
               then set_less_aux_Compl (lt_of_comp c) cproper_interval Nothing
                      (csorted_list_of_set a) (csorted_list_of_set b)
               else True)
        else (error :: forall a. String -> (() -> a) -> a)
               "cless_set Complement2: infinite set"
               (\ _ -> cless_set a (Complement b)));
  });
cless_set a b =
  (case ccompare of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a) "cless_set: ccompare = None"
        (\ _ -> cless_set a b);
    Just c ->
      (if finite a && finite b
        then lexordp (\ x y -> lt_of_comp c y x) (csorted_list_of_set a)
               (csorted_list_of_set b)
        else (error :: forall a. String -> (() -> a) -> a)
               "cless_set: infinite set" (\ _ -> cless_set a b));
  });

cless_eq_set ::
  forall a.
    (Finite_UNIV a, Ceq a, Cproper_interval a,
      Set_impl a) => Set a -> Set a -> Bool;
cless_eq_set (Complement (RBT_set rbt1)) (RBT_set rbt2) =
  (case ccompare of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "cless_eq_set (Complement RBT_set) RBT_set: ccompare = None"
        (\ _ -> cless_eq_set (Complement (RBT_set rbt1)) (RBT_set rbt2));
    Just c ->
      (finite :: Set a -> Bool) (top_set :: Set a) &&
        compl_set_less_eq_aux_fusion (lt_of_comp c) cproper_interval
          rbt_keys_generator rbt_keys_generator Nothing (init rbt1) (init rbt2);
  });
cless_eq_set (RBT_set rbt1) (Complement (RBT_set rbt2)) =
  (case ccompare of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "cless_eq_set RBT_set (Complement RBT_set): ccompare = None"
        (\ _ -> cless_eq_set (RBT_set rbt1) (Complement (RBT_set rbt2)));
    Just c ->
      (if (finite :: Set a -> Bool) (top_set :: Set a)
        then set_less_eq_aux_Compl_fusion (lt_of_comp c) cproper_interval
               rbt_keys_generator rbt_keys_generator Nothing (init rbt1)
               (init rbt2)
        else True);
  });
cless_eq_set (RBT_set rbta) (RBT_set rbt) =
  (case ccompare of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "cless_eq_set RBT_set RBT_set: ccompare = None"
        (\ _ -> cless_eq_set (RBT_set rbta) (RBT_set rbt));
    Just c ->
      lexord_eq_fusion (\ x y -> lt_of_comp c y x) rbt_keys_generator
        rbt_keys_generator (init rbta) (init rbt);
  });
cless_eq_set (Complement a) (Complement b) =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "cless_eq_set Complement Complement: ccompare = None"
        (\ _ -> le_of_comp (the ccompare_set) (Complement a) (Complement b));
    Just _ -> cless_eq_set b a;
  });
cless_eq_set (Complement a) b =
  (case ccompare of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "cless_eq_set Complement1: ccompare = None"
        (\ _ -> cless_eq_set (Complement a) b);
    Just c ->
      (if finite a && finite b
        then (finite :: Set a -> Bool) (top_set :: Set a) &&
               compl_set_less_eq_aux (lt_of_comp c) cproper_interval Nothing
                 (csorted_list_of_set a) (csorted_list_of_set b)
        else (error :: forall a. String -> (() -> a) -> a)
               "cless_eq_set Complement1: infinite set"
               (\ _ -> cless_eq_set (Complement a) b));
  });
cless_eq_set a (Complement b) =
  (case ccompare of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "cless_eq_set Complement2: ccompare = None"
        (\ _ -> cless_eq_set a (Complement b));
    Just c ->
      (if finite a && finite b
        then (if (finite :: Set a -> Bool) (top_set :: Set a)
               then set_less_eq_aux_Compl (lt_of_comp c) cproper_interval
                      Nothing (csorted_list_of_set a) (csorted_list_of_set b)
               else True)
        else (error :: forall a. String -> (() -> a) -> a)
               "cless_eq_set Complement2: infinite set"
               (\ _ -> cless_eq_set a (Complement b)));
  });
cless_eq_set a b =
  (case ccompare of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "cless_eq_set: ccompare = None" (\ _ -> cless_eq_set a b);
    Just c ->
      (if finite a && finite b
        then lexordp_eq (\ x y -> lt_of_comp c y x) (csorted_list_of_set a)
               (csorted_list_of_set b)
        else (error :: forall a. String -> (() -> a) -> a)
               "cless_eq_set: infinite set" (\ _ -> cless_eq_set a b));
  });

instance (Finite_UNIV a, Ceq a, Cproper_interval a,
           Set_impl a) => Ccompare (Set a) where {
  ccompare = ccompare_set;
};

fold_fusion :: forall a b c. Generator a b -> (a -> c -> c) -> b -> c -> c;
fold_fusion g f s b =
  (if has_next g s then (case next g s of {
                          (x, sa) -> fold_fusion g f sa (f x b);
                        })
    else b);

length_last_fusion :: forall a b. Generator a b -> b -> (Nat, a);
length_last_fusion g s =
  (if has_next g s
    then (case next g s of {
           (x, sa) ->
             fold_fusion g (\ xa (n, _) -> (plus_nat n one_nat, xa)) sa
               (one_nat, x);
         })
    else (zero_nat, error "undefined"));

gen_length_fusion :: forall a b. Generator a b -> Nat -> b -> Nat;
gen_length_fusion g n s =
  (if has_next g s then gen_length_fusion g (suc n) (snd (next g s)) else n);

length_fusion :: forall a b. Generator a b -> b -> Nat;
length_fusion g = gen_length_fusion g zero_nat;

list_remdups :: forall a. (a -> a -> Bool) -> [a] -> [a];
list_remdups equal [] = [];
list_remdups equal (x : xs) =
  (if list_member equal xs x then list_remdups equal xs
    else x : list_remdups equal xs);

lengtha :: forall a. (Ceq a) => Set_dlist a -> Nat;
lengtha xa = size_list (list_of_dlist xa);

card :: forall a. (Card_UNIV a, Ceq a, Ccompare a) => Set a -> Nat;
card (Complement a) =
  let {
    aa = card a;
    s = of_phantom (card_UNIV :: Phantom a Nat);
  } in (if less_nat zero_nat s then minus_nat s aa
         else (if finite a then zero_nat
                else (error :: forall a. String -> (() -> a) -> a)
                       "card Complement: infinite"
                       (\ _ -> card (Complement a))));
card (Set_Monad xs) =
  (case ceq of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a) "card Set_Monad: ceq = None"
        (\ _ -> card (Set_Monad xs));
    Just eq -> size_list (list_remdups eq xs);
  });
card (RBT_set rbt) =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "card RBT_set: ccompare = None" (\ _ -> card (RBT_set rbt));
    Just _ -> size_list (keysb rbt);
  });
card (DList_set dxs) =
  (case (ceq :: Maybe (a -> a -> Bool)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a) "card DList_set: ceq = None"
        (\ _ -> card (DList_set dxs));
    Just _ -> lengtha dxs;
  });

proper_interval_set_Compl_aux_fusion ::
  forall a b c.
    (Card_UNIV a, Ceq a, Ccompare a,
      Set_impl a) => (a -> a -> Bool) ->
                       (Maybe a -> Maybe a -> Bool) ->
                         Generator a b ->
                           Generator a c -> Maybe a -> Nat -> b -> c -> Bool;
proper_interval_set_Compl_aux_fusion less proper_interval g1 g2 ao n s1 s2 =
  (if has_next g1 s1
    then (case next g1 s1 of {
           (x, s1a) ->
             (if has_next g2 s2
               then (case next g2 s2 of {
                      (y, s2a) ->
                        (if less x y
                          then proper_interval ao (Just x) ||
                                 proper_interval_set_Compl_aux_fusion less
                                   proper_interval g1 g2 (Just x)
                                   (plus_nat n one_nat) s1a s2
                          else (if less y x
                                 then proper_interval ao (Just y) ||
proper_interval_set_Compl_aux_fusion less proper_interval g1 g2 (Just y)
  (plus_nat n one_nat) s1 s2a
                                 else proper_interval ao (Just x) &&
let {
  m = minus_nat ((card :: Set a -> Nat) (top_set :: Set a)) n;
} in not (equal_nat (minus_nat m (length_fusion g2 s2a))
           (nat_of_integer (2 :: Integer))) ||
       not (equal_nat (minus_nat m (length_fusion g1 s1a))
             (nat_of_integer (2 :: Integer)))));
                    })
               else let {
                      m = minus_nat ((card :: Set a -> Nat) (top_set :: Set a))
                            n;
                    } in (case length_last_fusion g1 s1 of {
                           (len_x, xa) ->
                             not (equal_nat m len_x) &&
                               (if equal_nat m (plus_nat len_x one_nat)
                                 then not (proper_interval (Just xa) Nothing)
                                 else True);
                         }));
         })
    else (if has_next g2 s2
           then (case next g2 s2 of {
                  (_, _) ->
                    let {
                      m = minus_nat ((card :: Set a -> Nat) (top_set :: Set a))
                            n;
                    } in (case length_last_fusion g2 s2 of {
                           (len_y, y) ->
                             not (equal_nat m len_y) &&
                               (if equal_nat m (plus_nat len_y one_nat)
                                 then not (proper_interval (Just y) Nothing)
                                 else True);
                         });
                })
           else less_nat (plus_nat n one_nat)
                  ((card :: Set a -> Nat) (top_set :: Set a))));

proper_interval_Compl_set_aux_fusion ::
  forall a b c.
    (a -> a -> Bool) ->
      (Maybe a -> Maybe a -> Bool) ->
        Generator a b -> Generator a c -> Maybe a -> b -> c -> Bool;
proper_interval_Compl_set_aux_fusion less proper_interval g1 g2 ao s1 s2 =
  has_next g1 s1 &&
    has_next g2 s2 &&
      (case next g1 s1 of {
        (x, s1a) ->
          (case next g2 s2 of {
            (y, s2a) ->
              (if less x y
                then not (proper_interval ao (Just x)) &&
                       proper_interval_Compl_set_aux_fusion less proper_interval
                         g1 g2 (Just x) s1a s2
                else (if less y x
                       then not (proper_interval ao (Just y)) &&
                              proper_interval_Compl_set_aux_fusion less
                                proper_interval g1 g2 (Just y) s1 s2a
                       else not (proper_interval ao (Just x)) &&
                              (has_next g2 s2a || has_next g1 s1a)));
          });
      });

exhaustive_above_fusion ::
  forall a b. (Maybe a -> Maybe a -> Bool) -> Generator a b -> a -> b -> Bool;
exhaustive_above_fusion proper_interval g y s =
  (if has_next g s
    then (case next g s of {
           (x, sa) ->
             not (proper_interval (Just y) (Just x)) &&
               exhaustive_above_fusion proper_interval g x sa;
         })
    else not (proper_interval (Just y) Nothing));

proper_interval_set_aux_fusion ::
  forall a b c.
    (a -> a -> Bool) ->
      (Maybe a -> Maybe a -> Bool) ->
        Generator a b -> Generator a c -> b -> c -> Bool;
proper_interval_set_aux_fusion less proper_interval g1 g2 s1 s2 =
  has_next g2 s2 &&
    (case next g2 s2 of {
      (y, s2a) ->
        (if has_next g1 s1
          then (case next g1 s1 of {
                 (x, s1a) ->
                   (if less x y then False
                     else (if less y x
                            then proper_interval (Just y) (Just x) ||
                                   (has_next g2 s2a ||
                                     not (exhaustive_above_fusion
   proper_interval g1 x s1a))
                            else proper_interval_set_aux_fusion less
                                   proper_interval g1 g2 s1a s2a));
               })
          else has_next g2 s2a || proper_interval (Just y) Nothing);
    });

length_last :: forall a. [a] -> (Nat, a);
length_last [] = (zero_nat, error "undefined");
length_last (x : xs) =
  fold (\ xa (n, _) -> (plus_nat n one_nat, xa)) xs (one_nat, x);

proper_interval_set_Compl_aux ::
  forall a.
    (Card_UNIV a, Ceq a, Ccompare a,
      Set_impl a) => (a -> a -> Bool) ->
                       (Maybe a -> Maybe a -> Bool) ->
                         Maybe a -> Nat -> [a] -> [a] -> Bool;
proper_interval_set_Compl_aux less proper_interval ao n [] [] =
  less_nat (plus_nat n one_nat) ((card :: Set a -> Nat) (top_set :: Set a));
proper_interval_set_Compl_aux less proper_interval ao n [] (y : ys) =
  let {
    m = minus_nat ((card :: Set a -> Nat) (top_set :: Set a)) n;
  } in (case length_last (y : ys) of {
         (len_y, ya) ->
           not (equal_nat m len_y) &&
             (if equal_nat m (plus_nat len_y one_nat)
               then not (proper_interval (Just ya) Nothing) else True);
       });
proper_interval_set_Compl_aux less proper_interval ao n (x : xs) [] =
  let {
    m = minus_nat ((card :: Set a -> Nat) (top_set :: Set a)) n;
  } in (case length_last (x : xs) of {
         (len_x, xa) ->
           not (equal_nat m len_x) &&
             (if equal_nat m (plus_nat len_x one_nat)
               then not (proper_interval (Just xa) Nothing) else True);
       });
proper_interval_set_Compl_aux less proper_interval ao n (x : xs) (y : ys) =
  (if less x y
    then proper_interval ao (Just x) ||
           proper_interval_set_Compl_aux less proper_interval (Just x)
             (plus_nat n one_nat) xs (y : ys)
    else (if less y x
           then proper_interval ao (Just y) ||
                  proper_interval_set_Compl_aux less proper_interval (Just y)
                    (plus_nat n one_nat) (x : xs) ys
           else proper_interval ao (Just x) &&
                  let {
                    m = minus_nat ((card :: Set a -> Nat) (top_set :: Set a)) n;
                  } in not (equal_nat (minus_nat m (size_list ys))
                             (nat_of_integer (2 :: Integer))) ||
                         not (equal_nat (minus_nat m (size_list xs))
                               (nat_of_integer (2 :: Integer)))));

proper_interval_Compl_set_aux ::
  forall a.
    (a -> a -> Bool) ->
      (Maybe a -> Maybe a -> Bool) -> Maybe a -> [a] -> [a] -> Bool;
proper_interval_Compl_set_aux less proper_interval ao (x : xs) (y : ys) =
  (if less x y
    then not (proper_interval ao (Just x)) &&
           proper_interval_Compl_set_aux less proper_interval (Just x) xs
             (y : ys)
    else (if less y x
           then not (proper_interval ao (Just y)) &&
                  proper_interval_Compl_set_aux less proper_interval (Just y)
                    (x : xs) ys
           else not (proper_interval ao (Just x)) &&
                  (if null ys then not (null xs) else True)));
proper_interval_Compl_set_aux less proper_interval ao [] uv = False;
proper_interval_Compl_set_aux less proper_interval ao uu [] = False;

exhaustive_above :: forall a. (Maybe a -> Maybe a -> Bool) -> a -> [a] -> Bool;
exhaustive_above proper_interval x [] = not (proper_interval (Just x) Nothing);
exhaustive_above proper_interval x (y : ys) =
  not (proper_interval (Just x) (Just y)) &&
    exhaustive_above proper_interval y ys;

proper_interval_set_aux ::
  forall a.
    (a -> a -> Bool) -> (Maybe a -> Maybe a -> Bool) -> [a] -> [a] -> Bool;
proper_interval_set_aux less proper_interval xs [] = False;
proper_interval_set_aux less proper_interval [] (y : ys) =
  not (null ys) || proper_interval (Just y) Nothing;
proper_interval_set_aux less proper_interval (x : xs) (y : ys) =
  (if less x y then False
    else (if less y x
           then proper_interval (Just y) (Just x) ||
                  (not (null ys) || not (exhaustive_above proper_interval x xs))
           else proper_interval_set_aux less proper_interval xs ys));

cproper_interval_set ::
  forall a.
    (Card_UNIV a, Ceq a, Cproper_interval a,
      Set_impl a) => Maybe (Set a) -> Maybe (Set a) -> Bool;
cproper_interval_set (Just (Complement (RBT_set rbt1))) (Just (RBT_set rbt2)) =
  (case ccompare of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "cproper_interval (Complement RBT_set) RBT_set: ccompare = None"
        (\ _ ->
          cproper_interval_set (Just (Complement (RBT_set rbt1)))
            (Just (RBT_set rbt2)));
    Just c ->
      (finite :: Set a -> Bool) (top_set :: Set a) &&
        proper_interval_Compl_set_aux_fusion (lt_of_comp c) cproper_interval
          rbt_keys_generator rbt_keys_generator Nothing (init rbt1) (init rbt2);
  });
cproper_interval_set (Just (RBT_set rbt1)) (Just (Complement (RBT_set rbt2))) =
  (case ccompare of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "cproper_interval RBT_set (Complement RBT_set): ccompare = None"
        (\ _ ->
          cproper_interval_set (Just (RBT_set rbt1))
            (Just (Complement (RBT_set rbt2))));
    Just c ->
      (finite :: Set a -> Bool) (top_set :: Set a) &&
        proper_interval_set_Compl_aux_fusion (lt_of_comp c) cproper_interval
          rbt_keys_generator rbt_keys_generator Nothing zero_nat (init rbt1)
          (init rbt2);
  });
cproper_interval_set (Just (RBT_set rbt1)) (Just (RBT_set rbt2)) =
  (case ccompare of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "cproper_interval RBT_set RBT_set: ccompare = None"
        (\ _ ->
          cproper_interval_set (Just (RBT_set rbt1)) (Just (RBT_set rbt2)));
    Just c ->
      (finite :: Set a -> Bool) (top_set :: Set a) &&
        proper_interval_set_aux_fusion (lt_of_comp c) cproper_interval
          rbt_keys_generator rbt_keys_generator (init rbt1) (init rbt2);
  });
cproper_interval_set (Just (Complement a)) (Just (Complement b)) =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "cproper_interval Complement Complement: ccompare = None"
        (\ _ ->
          cproper_interval_set (Just (Complement a)) (Just (Complement b)));
    Just _ -> cproper_interval_set (Just b) (Just a);
  });
cproper_interval_set (Just (Complement a)) (Just b) =
  (case ccompare of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "cproper_interval Complement1: ccompare = None"
        (\ _ -> cproper_interval_set (Just (Complement a)) (Just b));
    Just c ->
      (finite :: Set a -> Bool) (top_set :: Set a) &&
        proper_interval_Compl_set_aux (lt_of_comp c) cproper_interval Nothing
          (csorted_list_of_set a) (csorted_list_of_set b);
  });
cproper_interval_set (Just a) (Just (Complement b)) =
  (case ccompare of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "cproper_interval Complement2: ccompare = None"
        (\ _ -> cproper_interval_set (Just a) (Just (Complement b)));
    Just c ->
      (finite :: Set a -> Bool) (top_set :: Set a) &&
        proper_interval_set_Compl_aux (lt_of_comp c) cproper_interval Nothing
          zero_nat (csorted_list_of_set a) (csorted_list_of_set b);
  });
cproper_interval_set (Just a) (Just b) =
  (case ccompare of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "cproper_interval: ccompare = None"
        (\ _ -> cproper_interval_set (Just a) (Just b));
    Just c ->
      (finite :: Set a -> Bool) (top_set :: Set a) &&
        proper_interval_set_aux (lt_of_comp c) cproper_interval
          (csorted_list_of_set a) (csorted_list_of_set b);
  });

instance (Card_UNIV a, Ceq a, Cproper_interval a,
           Set_impl a) => Cproper_interval (Set a) where {
  cproper_interval = cproper_interval_set;
};

one_list :: forall a. [a];
one_list = [];

instance One [a] where {
  onea = one_list;
};

default_list :: forall a. [a];
default_list = [];

class Default a where {
  defaulta :: a;
};

instance Default [a] where {
  defaulta = default_list;
};

times_list :: forall a. [a] -> [a] -> [a];
times_list p q = p ++ q;

instance Times [a] where {
  times = times_list;
};

instance Power [a] where {
};

less_eq_list :: forall a. (Eq a, Order a) => [a] -> [a] -> Bool;
less_eq_list (x : xs) [] = False;
less_eq_list [] xs = True;
less_eq_list (x : xs) (y : ys) = less x y || x == y && less_eq_list xs ys;

less_list :: forall a. (Eq a, Order a) => [a] -> [a] -> Bool;
less_list xs [] = False;
less_list [] (x : xs) = True;
less_list (x : xs) (y : ys) = less x y || x == y && less_list xs ys;

instance (Eq a, Order a) => Ord [a] where {
  less_eq = less_eq_list;
  less = less_list;
};

class Infinite a where {
};

instance Infinite [a] where {
};

comparator_list :: forall a. (a -> a -> Ordera) -> [a] -> [a] -> Ordera;
comparator_list comp_a [] [] = Eqa;
comparator_list comp_a [] (y : ya) = Lt;
comparator_list comp_a (x : xa) [] = Gt;
comparator_list comp_a (x : xa) (y : ya) =
  (case comp_a x y of {
    Eqa -> comparator_list comp_a xa ya;
    Lt -> Lt;
    Gt -> Gt;
  });

compare_list :: forall a. (Compare a) => [a] -> [a] -> Ordera;
compare_list = comparator_list compare;

instance (Compare a) => Compare [a] where {
  compare = compare_list;
};

instance (Eq a, Order a) => Quasi_order [a] where {
};

instance (Eq a, Order a) => Weak_order [a] where {
};

instance (Eq a, Order a) => Preorder [a] where {
};

instance (Eq a, Order a) => Order [a] where {
};

equality_list :: forall a. (a -> a -> Bool) -> [a] -> [a] -> Bool;
equality_list eq_a [] [] = True;
equality_list eq_a [] (y : ya) = False;
equality_list eq_a (x : xa) [] = False;
equality_list eq_a (x : xa) (y : ya) = eq_a x y && equality_list eq_a xa ya;

ceq_list :: forall a. (Ceq a) => Maybe ([a] -> [a] -> Bool);
ceq_list = (case ceq of {
             Nothing -> Nothing;
             Just eq_a -> Just (equality_list eq_a);
           });

instance (Ceq a) => Ceq [a] where {
  ceq = ceq_list;
};

set_impl_list :: forall a. Phantom [a] Set_impla;
set_impl_list = Phantom Set_Choose;

instance Set_impl [a] where {
  set_impl = set_impl_list;
};

instance (Eq a, Linorder a) => Linorder [a] where {
};

class Countable a where {
};

instance (Countable a) => Countable [a] where {
};

showsl_lista :: forall a. (Showl a) => [a] -> String -> String;
showsl_lista xs = showsl_list xs;

showsl_list_list :: forall a. (Showl a) => [[a]] -> String -> String;
showsl_list_list xs = default_showsl_list showsl_lista xs;

instance (Showl a) => Showl [a] where {
  showsl = showsl_lista;
  showsl_list = showsl_list_list;
};

finite_UNIV_list :: forall a. Phantom [a] Bool;
finite_UNIV_list = Phantom False;

card_UNIV_list :: forall a. Phantom [a] Nat;
card_UNIV_list = Phantom zero_nat;

instance Finite_UNIV [a] where {
  finite_UNIV = finite_UNIV_list;
};

instance Card_UNIV [a] where {
  card_UNIV = card_UNIV_list;
};

cEnum_list ::
  forall a. Maybe ([[a]], (([a] -> Bool) -> Bool, ([a] -> Bool) -> Bool));
cEnum_list = Nothing;

instance Cenum [a] where {
  cEnum = cEnum_list;
};

instance (Compare_order a, Eq a) => Compare_order [a] where {
};

ccompare_list :: forall a. (Ccompare a) => Maybe ([a] -> [a] -> Ordera);
ccompare_list = (case ccompare of {
                  Nothing -> Nothing;
                  Just comp_a -> Just (comparator_list comp_a);
                });

instance (Ccompare a) => Ccompare [a] where {
  ccompare = ccompare_list;
};

mapping_impl_list :: forall a. Phantom [a] Mapping_impla;
mapping_impl_list = Phantom Mapping_Choose;

instance Mapping_impl [a] where {
  mapping_impl = mapping_impl_list;
};

cproper_interval_list ::
  forall a. (Ccompare a) => Maybe [a] -> Maybe [a] -> Bool;
cproper_interval_list xso yso = error "undefined";

instance (Ccompare a) => Cproper_interval [a] where {
  cproper_interval = cproper_interval_list;
};

class Unit_factor a where {
  unit_factor :: a -> a;
};

class (Semidom_divide a, Unit_factor a) => Semidom_divide_unit_factor a where {
};

class (Algebraic_semidom a,
        Semidom_divide_unit_factor a) => Normalization_semidom a where {
  normalizec :: a -> a;
};

class (Semidom_modulo a) => Euclidean_semiring a where {
  euclidean_size :: a -> Nat;
};

class (Normalization_semidom a) => Factorial_semiring a where {
};

class (Euclidean_semiring a,
        Factorial_semiring a) => Normalization_euclidean_semiring a where {
};

gcdc :: forall a. (Normalization_euclidean_semiring a, Eq a) => a -> a -> a;
gcdc a b = (if b == zerob then normalizec a else gcdc b (modulo a b));

lcmc :: forall a. (Normalization_euclidean_semiring a, Eq a) => a -> a -> a;
lcmc a b = normalizec (divide (times a b) (gcdc a b));

euclidean_size_field :: forall a. (Field a, Eq a) => a -> Nat;
euclidean_size_field x = (if x == zerob then zero_nat else one_nat);

rep_mini_alg_unique :: Mini_alg_unique -> Mini_alg;
rep_mini_alg_unique (Abs_mini_alg_unique x) = x;

rep_mini_alg :: Mini_alg -> (Rat, (Rat, Nat));
rep_mini_alg (Abs_mini_alg x) = x;

numeral :: forall a. (Numeral a) => Num -> a;
numeral One = onea;
numeral (Bit0 n) = let {
                     m = numeral n;
                   } in plus m m;
numeral (Bit1 n) = let {
                     m = numeral n;
                   } in plus (plus m m) onea;

of_nat :: forall a. (Semiring_1 a) => Nat -> a;
of_nat n =
  (if equal_nat n zero_nat then zerob
    else (case divmod_nat n (nat_of_integer (2 :: Integer)) of {
           (m, q) -> let {
                       ma = times (numeral (Bit0 One)) (of_nat m);
                     } in (if equal_nat q zero_nat then ma else plus ma onea);
         }));

ma_normalize :: (Rat, (Rat, Nat)) -> (Rat, (Rat, Nat));
ma_normalize x =
  (case x of {
    (a, (b, c)) ->
      (if equal_rat b zero_rat then (a, (zero_rat, zero_nat)) else (a, (b, c)));
  });

ma_inverse :: Mini_alg -> Mini_alg;
ma_inverse xa =
  Abs_mini_alg
    (case rep_mini_alg xa of {
      (p, (q, b)) ->
        let {
          d = inverse_rat
                (minus_rat (times_rat p p)
                  (times_rat (times_rat (of_nat b) q) q));
        } in ma_normalize (times_rat p d, (times_rat (uminus_rat q) d, b));
    });

mau_inverse :: Mini_alg_unique -> Mini_alg_unique;
mau_inverse xa = Abs_mini_alg_unique (ma_inverse (rep_mini_alg_unique xa));

inverse_real :: Real -> Real;
inverse_real (Real_of_u r) = Real_of_u (mau_inverse r);

ma_uminus :: Mini_alg -> Mini_alg;
ma_uminus xa =
  Abs_mini_alg (case rep_mini_alg xa of {
                 (p1, (q1, b1)) -> (uminus_rat p1, (uminus_rat q1, b1));
               });

mau_uminus :: Mini_alg_unique -> Mini_alg_unique;
mau_uminus xa = Abs_mini_alg_unique (ma_uminus (rep_mini_alg_unique xa));

uminus_real :: Real -> Real;
uminus_real (Real_of_u r) = Real_of_u (mau_uminus r);

ma_compatible :: Mini_alg -> Mini_alg -> Bool;
ma_compatible xa xc =
  (case rep_mini_alg xa of {
    (_, (q1, b1)) ->
      (\ (_, (q2, b2)) ->
        equal_rat q1 zero_rat || (equal_rat q2 zero_rat || equal_nat b1 b2));
  })
    (rep_mini_alg xc);

mau_compatible :: Mini_alg_unique -> Mini_alg_unique -> Bool;
mau_compatible xa xc =
  ma_compatible (rep_mini_alg_unique xa) (rep_mini_alg_unique xc);

ma_times :: Mini_alg -> Mini_alg -> Mini_alg;
ma_times xb xc =
  Abs_mini_alg
    ((case rep_mini_alg xb of {
       (p1, (q1, b1)) ->
         (\ (p2, (q2, b2)) ->
           (if equal_rat q1 zero_rat
             then ma_normalize (times_rat p1 p2, (times_rat p1 q2, b2))
             else ma_normalize
                    (plus_rat (times_rat p1 p2)
                       (times_rat (times_rat (of_nat b2) q1) q2),
                      (plus_rat (times_rat p1 q2) (times_rat q1 p2), b1))));
     })
      (rep_mini_alg xc));

mau_times :: Mini_alg_unique -> Mini_alg_unique -> Mini_alg_unique;
mau_times xb xc =
  Abs_mini_alg_unique
    (ma_times (rep_mini_alg_unique xb) (rep_mini_alg_unique xc));

times_real :: Real -> Real -> Real;
times_real (Real_of_u r1) (Real_of_u r2) =
  (if mau_compatible r1 r2 then Real_of_u (mau_times r1 r2)
    else (error :: forall a. String -> (() -> a) -> a) "different base"
           (\ _ -> times_real (Real_of_u r1) (Real_of_u r2)));

divide_real :: Real -> Real -> Real;
divide_real x y = times_real x (inverse_real y);

ma_plus :: Mini_alg -> Mini_alg -> Mini_alg;
ma_plus xb xc =
  Abs_mini_alg
    ((case rep_mini_alg xb of {
       (p1, (q1, b1)) ->
         (\ (p2, (q2, b2)) ->
           (if equal_rat q1 zero_rat then (plus_rat p1 p2, (q2, b2))
             else ma_normalize (plus_rat p1 p2, (plus_rat q1 q2, b1))));
     })
      (rep_mini_alg xc));

mau_plus :: Mini_alg_unique -> Mini_alg_unique -> Mini_alg_unique;
mau_plus xb xc =
  Abs_mini_alg_unique
    (ma_plus (rep_mini_alg_unique xb) (rep_mini_alg_unique xc));

plus_real :: Real -> Real -> Real;
plus_real (Real_of_u r1) (Real_of_u r2) =
  (if mau_compatible r1 r2 then Real_of_u (mau_plus r1 r2)
    else (error :: forall a. String -> (() -> a) -> a) "different base"
           (\ _ -> plus_real (Real_of_u r1) (Real_of_u r2)));

minus_real :: Real -> Real -> Real;
minus_real x y = plus_real x (uminus_real y);

zero_real :: Real;
zero_real = Real_of_u (mau_of_rat zero_rat);

one_real :: Real;
one_real = Real_of_u (mau_of_rat one_rat);

instance Plus Real where {
  plus = plus_real;
};

instance Semigroup_add Real where {
};

instance Cancel_semigroup_add Real where {
};

instance Ab_semigroup_add Real where {
};

instance Minus Real where {
  minusa = minus_real;
};

instance Cancel_ab_semigroup_add Real where {
};

instance Zero Real where {
  zerob = zero_real;
};

instance Monoid_add Real where {
};

instance Comm_monoid_add Real where {
};

instance Cancel_comm_monoid_add Real where {
};

instance Times Real where {
  times = times_real;
};

instance Mult_zero Real where {
};

instance Semigroup_mult Real where {
};

instance Semiring Real where {
};

instance Semiring_0 Real where {
};

instance Semiring_0_cancel Real where {
};

instance Ab_semigroup_mult Real where {
};

instance Comm_semiring Real where {
};

instance Comm_semiring_0 Real where {
};

instance Comm_semiring_0_cancel Real where {
};

instance One Real where {
  onea = one_real;
};

instance Power Real where {
};

instance Monoid_mult Real where {
};

instance Numeral Real where {
};

instance Semiring_numeral Real where {
};

instance Zero_neq_one Real where {
};

instance Semiring_1 Real where {
};

instance Semiring_1_cancel Real where {
};

instance Dvd Real where {
};

instance Comm_monoid_mult Real where {
};

instance Comm_semiring_1 Real where {
};

instance Comm_semiring_1_cancel Real where {
};

instance Comm_semiring_1_cancel_crossproduct Real where {
};

instance Semiring_no_zero_divisors Real where {
};

instance Semiring_1_no_zero_divisors Real where {
};

instance Semiring_no_zero_divisors_cancel Real where {
};

instance Uminus Real where {
  uminus = uminus_real;
};

instance Group_add Real where {
};

instance Ab_group_add Real where {
};

instance Ring Real where {
};

instance Ring_no_zero_divisors Real where {
};

instance Neg_numeral Real where {
};

instance Ring_1 Real where {
};

instance Ring_1_no_zero_divisors Real where {
};

instance Comm_ring Real where {
};

instance Comm_ring_1 Real where {
};

instance Semidom Real where {
};

instance Idom Real where {
};

instance Ufd Real where {
};

instance Divide Real where {
  divide = divide_real;
};

instance Divide_trivial Real where {
};

instance Inverse Real where {
  inverse = inverse_real;
};

instance Division_ring Real where {
};

instance Semidom_divide Real where {
};

instance Idom_divide Real where {
};

instance Field Real where {
};

ma_identity :: Mini_alg -> Mini_alg -> Bool;
ma_identity xa xc = rep_mini_alg xa == rep_mini_alg xc;

mau_equal :: Mini_alg_unique -> Mini_alg_unique -> Bool;
mau_equal xa xc = ma_identity (rep_mini_alg_unique xa) (rep_mini_alg_unique xc);

equal_real :: Real -> Real -> Bool;
equal_real (Real_of_u r1) (Real_of_u r2) = mau_equal r1 r2;

instance Eq Real where {
  a == b = equal_real a b;
};

euclidean_size_real :: Real -> Nat;
euclidean_size_real = euclidean_size_field;

normalize_field :: forall a. (Field a, Eq a) => a -> a;
normalize_field x = (if x == zerob then zerob else onea);

normalize_real :: Real -> Real;
normalize_real = normalize_field;

unit_factor_field :: forall a. (Field a) => a -> a;
unit_factor_field x = x;

unit_factor_real :: Real -> Real;
unit_factor_real = unit_factor_field;

mod_field :: forall a. (Field a, Eq a) => a -> a -> a;
mod_field x y = (if y == zerob then x else zerob);

modulo_real :: Real -> Real -> Real;
modulo_real = mod_field;

instance Modulo Real where {
  modulo = modulo_real;
};

instance Semiring_modulo Real where {
};

instance Semiring_modulo_trivial Real where {
};

instance Algebraic_semidom Real where {
};

instance Semidom_modulo Real where {
};

instance Euclidean_semiring Real where {
  euclidean_size = euclidean_size_real;
};

instance Unit_factor Real where {
  unit_factor = unit_factor_real;
};

instance Semidom_divide_unit_factor Real where {
};

instance Normalization_semidom Real where {
  normalizec = normalize_real;
};

instance Factorial_semiring Real where {
};

instance Normalization_euclidean_semiring Real where {
};

lcm_reala :: Real -> Real -> Real;
lcm_reala = lcmc;

gcd_reala :: Real -> Real -> Real;
gcd_reala = gcdc;

lcmb :: forall a. Set a -> a;
lcmb _ = error "Euclidean_Algorithm.normalization_euclidean_semiring_class.Lcm";

lcm_real :: Set Real -> Real;
lcm_real = lcmb;

gcdb :: forall a. Set a -> a;
gcdb _ = error "Euclidean_Algorithm.normalization_euclidean_semiring_class.Gcd";

gcd_real :: Set Real -> Real;
gcd_real = gcdb;

class (One a, Zero a, Dvd a) => Gcda a where {
  gcda :: a -> a -> a;
  lcma :: a -> a -> a;
};

class (Gcda a) => Gcd a where {
  gcd :: Set a -> a;
  lcm :: Set a -> a;
};

instance Gcda Real where {
  gcda = gcd_reala;
  lcma = lcm_reala;
};

instance Gcd Real where {
  gcd = gcd_real;
  lcm = lcm_real;
};

sqrt_int_maina :: Int -> Int -> (Int, Bool);
sqrt_int_maina x n =
  let {
    x2 = times_int x x;
  } in (if less_eq_int x2 n then (x, equal_int x2 n)
         else sqrt_int_maina
                (divide_int (plus_int (divide_int n x) x)
                  (Int_of_integer (2 :: Integer)))
                n);

binary_power :: forall a. (Monoid_mult a) => a -> Nat -> a;
binary_power x n =
  (if equal_nat n zero_nat then onea
    else (case divmod_nat n (nat_of_integer (2 :: Integer)) of {
           (d, r) -> let {
                       rec = binary_power (times x x) d;
                     } in (if equal_nat r zero_nat then rec else times rec x);
         }));

ceiling :: forall a. (Floor_ceiling a) => a -> Int;
ceiling x = uminus_int (floor (uminus x));

newtype Proper_base = Abs_proper_base Int;

into_base :: Int -> Proper_base;
into_base xa =
  Abs_proper_base
    (if less_eq_int (Int_of_integer (2 :: Integer)) xa then xa
      else Int_of_integer (2 :: Integer));

rep_proper_base :: Proper_base -> Int;
rep_proper_base (Abs_proper_base x) = x;

square_base :: Proper_base -> Proper_base;
square_base xa =
  Abs_proper_base (times_int (rep_proper_base xa) (rep_proper_base xa));

get_base :: Proper_base -> Int;
get_base x = rep_proper_base x;

log_main :: Proper_base -> Int -> (Nat, Int);
log_main b x =
  (if less_int x (get_base b) then (zero_nat, one_int)
    else (case log_main (square_base b) x of {
           (z, bz) -> let {
                        l = times_nat (nat_of_integer (2 :: Integer)) z;
                        bz1 = times_int bz (get_base b);
                      } in (if less_int x bz1 then (l, bz) else (suc l, bz1));
         }));

log_ceiling :: Int -> Int -> Nat;
log_ceiling b x = (case log_main (into_base b) x of {
                    (y, by) -> (if equal_int x by then y else suc y);
                  });

start_value :: Int -> Nat -> Int;
start_value n p =
  binary_power (Int_of_integer (2 :: Integer))
    (nat (ceiling
           (divide_rat (of_nat (log_ceiling (Int_of_integer (2 :: Integer)) n))
             (of_nat p))));

sqrt_int_main :: Int -> (Int, Bool);
sqrt_int_main x =
  sqrt_int_maina (start_value x (nat_of_integer (2 :: Integer))) x;

sqrt_int_ceiling_pos :: Int -> Int;
sqrt_int_ceiling_pos x = (case sqrt_int_main x of {
                           (y, True) -> y;
                           (y, False) -> plus_int y one_int;
                         });

sqrt_int_floor_pos :: Int -> Int;
sqrt_int_floor_pos x = fst (sqrt_int_main x);

int_of_nat :: Nat -> Int;
int_of_nat n = Int_of_integer (integer_of_nat n);

ma_floor :: Mini_alg -> Int;
ma_floor xa =
  (case rep_mini_alg xa of {
    (p, (q, b)) ->
      (case (quotient_of p, quotient_of q) of {
        ((z1, n1), (z2, n2)) ->
          let {
            z2n1 = times_int z2 n1;
            z1n2 = times_int z1 n2;
            n12 = times_int n1 n2;
            prod = times_int (times_int z2n1 z2n1) (int_of_nat b);
          } in divide_int
                 (plus_int z1n2
                   (if less_eq_int zero_int z2n1 then sqrt_int_floor_pos prod
                     else uminus_int (sqrt_int_ceiling_pos prod)))
                 n12;
      });
  });

mau_floor :: Mini_alg_unique -> Int;
mau_floor xa = ma_floor (rep_mini_alg_unique xa);

floor_real :: Real -> Int;
floor_real (Real_of_u r) = mau_floor r;

real_lt :: Real -> Real -> Bool;
real_lt x y =
  let {
    fx = floor_real x;
    fy = floor_real y;
  } in (if less_int fx fy then True
         else (if less_int fy fx then False
                else real_lt
                       (times_real x
                         (ratreal (of_int (Int_of_integer (1024 :: Integer)))))
                       (times_real y
                         (ratreal
                           (of_int (Int_of_integer (1024 :: Integer)))))));

ma_ge_0 :: Mini_alg -> Bool;
ma_ge_0 xa =
  (case rep_mini_alg xa of {
    (p, (q, b)) ->
      let {
        bqq = times_rat (times_rat (of_nat b) q) q;
        pp = times_rat p p;
      } in less_eq_rat zero_rat p && less_eq_rat bqq pp ||
             less_eq_rat zero_rat q && less_eq_rat pp bqq;
  });

mau_ge_0 :: Mini_alg_unique -> Bool;
mau_ge_0 xa = ma_ge_0 (rep_mini_alg_unique xa);

ge_0 :: Real -> Bool;
ge_0 (Real_of_u x) = mau_ge_0 x;

less_real :: Real -> Real -> Bool;
less_real (Real_of_u x) (Real_of_u y) =
  not (equal_real (Real_of_u x) (Real_of_u y)) &&
    (if mau_compatible x y then ge_0 (minus_real (Real_of_u y) (Real_of_u x))
      else real_lt (Real_of_u x) (Real_of_u y));

abs_real :: Real -> Real;
abs_real a = (if less_real a zero_real then uminus_real a else a);

instance Abs Real where {
  absa = abs_real;
};

sgn_real :: Real -> Real;
sgn_real a =
  (if equal_real a zero_real then zero_real
    else (if less_real zero_real a then one_real else uminus_real one_real));

instance Sgn Real where {
  sgn = sgn_real;
};

class (Gcda a, Comm_semiring_1 a) => Comm_monoid_gcd a where {
};

class (Idom a, Comm_monoid_gcd a) => Idom_gcd a where {
};

class (Normalization_semidom a, Comm_monoid_gcd a) => Semiring_gcd a where {
};

class (Semiring_gcd a, Idom_gcd a) => Ring_gcd a where {
};

instance Comm_monoid_gcd Real where {
};

instance Idom_gcd Real where {
};

instance Semiring_gcd Real where {
};

instance Ring_gcd Real where {
};

less_eq_real :: Real -> Real -> Bool;
less_eq_real (Real_of_u x) (Real_of_u y) =
  equal_real (Real_of_u x) (Real_of_u y) ||
    (if mau_compatible x y then ge_0 (minus_real (Real_of_u y) (Real_of_u x))
      else real_lt (Real_of_u x) (Real_of_u y));

instance Ord Real where {
  less_eq = less_eq_real;
  less = less_real;
};

instance Abs_if Real where {
};

instance Semiring_char_0 Real where {
};

instance Ring_char_0 Real where {
};

instance Quasi_order Real where {
};

instance Weak_order Real where {
};

instance Preorder Real where {
};

instance Order Real where {
};

class (Gcd a, Semiring_gcd a) => Semiring_Gcd a where {
};

instance Semiring_Gcd Real where {
};

instance No_bot Real where {
};

instance No_top Real where {
};

ceq_real :: Maybe (Real -> Real -> Bool);
ceq_real = Just equal_real;

instance Ceq Real where {
  ceq = ceq_real;
};

set_impl_real :: Phantom Real Set_impla;
set_impl_real = Phantom Set_RBT;

instance Set_impl Real where {
  set_impl = set_impl_real;
};

instance Linorder Real where {
};

instance Idom_abs_sgn Real where {
};

instance Ordered_ab_semigroup_add Real where {
};

instance Strict_ordered_ab_semigroup_add Real where {
};

instance Ordered_cancel_ab_semigroup_add Real where {
};

instance Ordered_semigroup_mult_zero Real where {
};

instance Ordered_comm_monoid_add Real where {
};

instance Ordered_semiring Real where {
};

instance Ordered_semiring_0 Real where {
};

instance Ordered_cancel_semiring Real where {
};

instance Ordered_ab_semigroup_add_imp_le Real where {
};

instance Strict_ordered_comm_monoid_add Real where {
};

instance Ordered_cancel_comm_monoid_add Real where {
};

instance Ordered_ab_semigroup_monoid_add_imp_le Real where {
};

instance Ordered_ab_group_add Real where {
};

instance Ordered_ring Real where {
};

instance Field_char_0 Real where {
};

instance Zero_less_one Real where {
};

char_0x2F :: Char;
char_0x2F = Chr (47 :: Integer);

char_0x2D :: Char;
char_0x2D = Chr (45 :: Integer);

char_0x39 :: Char;
char_0x39 = Chr (57 :: Integer);

char_0x38 :: Char;
char_0x38 = Chr (56 :: Integer);

char_0x37 :: Char;
char_0x37 = Chr (55 :: Integer);

char_0x36 :: Char;
char_0x36 = Chr (54 :: Integer);

char_0x35 :: Char;
char_0x35 = Chr (53 :: Integer);

char_0x34 :: Char;
char_0x34 = Chr (52 :: Integer);

char_0x33 :: Char;
char_0x33 = Chr (51 :: Integer);

char_0x32 :: Char;
char_0x32 = Chr (50 :: Integer);

char_0x31 :: Char;
char_0x31 = Chr (49 :: Integer);

char_0x30 :: Char;
char_0x30 = Chr (48 :: Integer);

string_of_digit :: Nat -> [Char];
string_of_digit n =
  (if equal_nat n zero_nat then [char_0x30]
    else (if equal_nat n one_nat then [char_0x31]
           else (if equal_nat n (nat_of_integer (2 :: Integer)) then [char_0x32]
                  else (if equal_nat n (nat_of_integer (3 :: Integer))
                         then [char_0x33]
                         else (if equal_nat n (nat_of_integer (4 :: Integer))
                                then [char_0x34]
                                else (if equal_nat n
   (nat_of_integer (5 :: Integer))
                                       then [char_0x35]
                                       else (if equal_nat n
          (nat_of_integer (6 :: Integer))
      then [char_0x36]
      else (if equal_nat n (nat_of_integer (7 :: Integer)) then [char_0x37]
             else (if equal_nat n (nat_of_integer (8 :: Integer))
                    then [char_0x38] else [char_0x39])))))))));

shows_string :: [Char] -> [Char] -> [Char];
shows_string = (\ a b -> a ++ b);

showsp_nat :: Nat -> Nat -> [Char] -> [Char];
showsp_nat p n =
  (if less_nat n (nat_of_integer (10 :: Integer))
    then shows_string (string_of_digit n)
    else showsp_nat p (divide_nat n (nat_of_integer (10 :: Integer))) .
           shows_string
             (string_of_digit (modulo_nat n (nat_of_integer (10 :: Integer)))));

showsp_int :: Nat -> Int -> [Char] -> [Char];
showsp_int p i =
  (if less_int i zero_int
    then shows_string [char_0x2D] . showsp_nat p (nat (uminus_int i))
    else showsp_nat p (nat i));

showsp_rat :: Nat -> Rat -> [Char] -> [Char];
showsp_rat p x =
  (case quotient_of x of {
    (d, n) ->
      (if equal_int n one_int then showsp_int p d
        else (showsp_int p d . shows_string [char_0x2F]) . showsp_int p n);
  });

shows_prec_rat :: Nat -> Rat -> [Char] -> [Char];
shows_prec_rat = showsp_rat;

shows_prec_nat :: Nat -> Nat -> [Char] -> [Char];
shows_prec_nat = showsp_nat;

class Showa a where {
  shows_prec :: Nat -> a -> [Char] -> [Char];
  shows_list :: [a] -> [Char] -> [Char];
};

shows_prec_list :: forall a. (Showa a) => Nat -> [a] -> [Char] -> [Char];
shows_prec_list p xs = shows_list xs;

char_0x74 :: Char;
char_0x74 = Chr (116 :: Integer);

char_0x73 :: Char;
char_0x73 = Chr (115 :: Integer);

char_0x72 :: Char;
char_0x72 = Chr (114 :: Integer);

char_0x71 :: Char;
char_0x71 = Chr (113 :: Integer);

char_0x2B :: Char;
char_0x2B = Chr (43 :: Integer);

char_0x2A :: Char;
char_0x2A = Chr (42 :: Integer);

char_0x29 :: Char;
char_0x29 = Chr (41 :: Integer);

char_0x28 :: Char;
char_0x28 = Chr (40 :: Integer);

shows_prec_char :: Nat -> Char -> [Char] -> [Char];
shows_prec_char p c = (\ a -> c : a);

shows_list_char :: [Char] -> [Char] -> [Char];
shows_list_char cs = shows_string cs;

instance Showa Char where {
  shows_prec = shows_prec_char;
  shows_list = shows_list_char;
};

ma_show_real :: Mini_alg -> [Char];
ma_show_real xa =
  (case rep_mini_alg xa of {
    (p, (q, b)) ->
      let {
        sb = (shows_prec_list zero_nat
                [char_0x73, char_0x71, char_0x72, char_0x74, char_0x28] .
               shows_prec_nat zero_nat b) .
               shows_prec_list zero_nat [char_0x29];
        qb = (if equal_rat q one_rat then sb
               else (if equal_rat q (uminus_rat one_rat)
                      then shows_prec_list zero_nat [char_0x2D] . sb
                      else (shows_prec_rat zero_nat q .
                             shows_prec_list zero_nat [char_0x2A]) .
                             sb));
      } in (if equal_rat q zero_rat then shows_prec_rat zero_nat p []
             else (if equal_rat p zero_rat then qb []
                    else (if less_rat q zero_rat
                           then shows_prec_rat zero_nat p (qb [])
                           else shows_prec_rat zero_nat p
                                  (shows_prec_list zero_nat [char_0x2B]
                                    (qb [])))));
  });

mau_show_real :: Mini_alg_unique -> [Char];
mau_show_real xa = ma_show_real (rep_mini_alg_unique xa);

show_real :: Real -> [Char];
show_real (Real_of_u x) = mau_show_real x;

showsl_real :: Real -> String -> String;
showsl_real x = showsl_lit (implode (show_real x));

showsl_list_real :: [Real] -> String -> String;
showsl_list_real xs = default_showsl_list showsl_real xs;

instance Showl Real where {
  showsl = showsl_real;
  showsl_list = showsl_list_real;
};

instance Field_abs_sgn Real where {
};

cEnum_real :: Maybe ([Real], ((Real -> Bool) -> Bool, (Real -> Bool) -> Bool));
cEnum_real = Nothing;

instance Cenum Real where {
  cEnum = cEnum_real;
};

instance Dense_order Real where {
};

instance Ordered_semiring_strict Real where {
};

instance Linordered_ab_semigroup_add Real where {
};

instance Linordered_cancel_ab_semigroup_add Real where {
};

instance Linordered_semiring Real where {
};

instance Linordered_semiring_strict Real where {
};

instance Ordered_semiring_1 Real where {
};

instance Ordered_semiring_1_strict Real where {
};

instance Ordered_semiring_1b Real where {
};

instance Linordered_semiring_1 Real where {
};

instance Linordered_semiring_1_strict Real where {
};

instance Ordered_ab_group_add_abs Real where {
};

instance Linordered_ab_group_add Real where {
};

instance Linordered_ring Real where {
};

instance Linordered_ring_strict Real where {
};

instance Semiring_real_line Real where {
};

instance Semiring_1_real_line Real where {
};

instance Ordered_comm_semiring Real where {
};

instance Ordered_cancel_comm_semiring Real where {
};

instance Ordered_comm_semiring_strict Real where {
};

instance Linordered_comm_semiring_strict Real where {
};

instance Linordered_nonzero_semiring Real where {
};

instance Linordered_semidom Real where {
};

instance Ordered_comm_ring Real where {
};

instance Ordered_ring_abs Real where {
};

instance Linordered_idom Real where {
};

instance Non_strict_order Real where {
};

instance Ordered_ab_semigroup Real where {
};

instance Ordered_semiring_0a Real where {
};

instance Ordered_semiring_1a Real where {
};

instance Poly_carrier Real where {
};

instance Unbounded_dense_order Real where {
};

instance Dense_linorder Real where {
};

instance Unbounded_dense_linorder Real where {
};

instance Linordered_field Real where {
};

dist_real :: Real -> Real -> Real;
dist_real x y = abs_real (minus_real x y);

class Dist a where {
  dist :: a -> a -> Real;
};

instance Dist Real where {
  dist = dist_real;
};

norm_real :: Real -> Real;
norm_real r = abs_real r;

class Norm a where {
  norm :: a -> Real;
};

instance Norm Real where {
  norm = norm_real;
};

open_real :: Set Real -> Bool;
open_real _ = error "Real_Vector_Spaces.open_real_inst.open_real";

class Open a where {
  open :: Set a -> Bool;
};

instance Open Real where {
  open = open_real;
};

compare_real :: Real -> Real -> Ordera;
compare_real = comparator_of;

ccompare_real :: Maybe (Real -> Real -> Ordera);
ccompare_real = Just compare_real;

instance Ccompare Real where {
  ccompare = ccompare_real;
};

scaleR_real :: Real -> Real -> Real;
scaleR_real a x = times_real a x;

class ScaleR a where {
  scaleR :: Real -> a -> a;
};

instance ScaleR Real where {
  scaleR = scaleR_real;
};

class (Open a) => Topological_space a where {
};

class (Topological_space a) => T0_space a where {
};

instance Topological_space Real where {
};

instance T0_space Real where {
};

class (T0_space a) => T1_space a where {
};

instance T1_space Real where {
};

class (T1_space a) => T2_space a where {
};

instance T2_space Real where {
};

class (T2_space a) => T3_space a where {
};

instance T3_space Real where {
};

class (T3_space a) => T4_space a where {
};

instance T4_space Real where {
};

class (Monoid_add a, Topological_space a) => Topological_monoid_add a where {
};

class (Group_add a, Topological_monoid_add a) => Topological_group_add a where {
};

instance Topological_monoid_add Real where {
};

instance Topological_group_add Real where {
};

class (Minus a, Dist a, Norm a) => Dist_norm a where {
};

instance Dist_norm Real where {
};

data Filter a = Principal (Set a) | Abstract_filter (() -> Filter a);

uniformity_real :: Filter (Real, Real);
uniformity_real =
  Abstract_filter
    (\ _ ->
      (error :: forall a. String -> (() -> a) -> a)
        "uniformity is not executable" (\ _ -> uniformity_real));

class Uniformity a where {
  uniformity :: Filter (a, a);
};

instance Uniformity Real where {
  uniformity = uniformity_real;
};

class (Ab_group_add a, ScaleR a) => Real_vector a where {
};

instance Real_vector Real where {
};

real_of_real :: Real -> Real;
real_of_real x = x;

instance Real_embedding Real where {
  real_of = real_of_real;
};

instance Archimedean_field Real where {
};

instance Large_ordered_semiring_1 Real where {
};

instance Floor_ceiling Real where {
  floor = floor_real;
};

class (Normalization_semidom a) => Normalization_semidom_multiplicative a where {
};

class (Semiring_gcd a,
        Normalization_semidom_multiplicative a) => Semiring_gcd_mult_normalize a where {
};

instance Normalization_semidom_multiplicative Real where {
};

instance Semiring_gcd_mult_normalize Real where {
};

class (Comm_monoid_add a,
        Topological_monoid_add a) => Topological_comm_monoid_add a where {
};

class (Ab_group_add a, Topological_comm_monoid_add a,
        Topological_group_add a) => Topological_ab_group_add a where {
};

instance Topological_comm_monoid_add Real where {
};

instance Topological_ab_group_add Real where {
};

class (Topological_space a) => First_countable_topology a where {
};

class (Dist a, Uniformity a) => Uniformity_dist a where {
};

class (Topological_space a, Uniformity a) => Open_uniformity a where {
};

class (Open_uniformity a) => Uniform_space a where {
};

class (Uniformity_dist a, First_countable_topology a, T4_space a,
        Uniform_space a) => Metric_space a where {
};

instance First_countable_topology Real where {
};

instance Uniformity_dist Real where {
};

instance Open_uniformity Real where {
};

instance Uniform_space Real where {
};

instance Metric_space Real where {
};

class (Sgn a, Norm a, ScaleR a) => Sgn_div_norm a where {
};

instance Sgn_div_norm Real where {
};

class (Factorial_semiring a, Semiring_Gcd a) => Factorial_semiring_gcd a where {
};

class (Factorial_semiring_gcd a, Ring_gcd a,
        Idom_divide a) => Factorial_ring_gcd a where {
};

instance Factorial_semiring_gcd Real where {
};

instance Factorial_ring_gcd Real where {
};

class (Topological_ab_group_add a, Dist_norm a, Metric_space a, Real_vector a,
        Sgn_div_norm a) => Real_normed_vector a where {
};

instance Real_normed_vector Real where {
};

instance Large_real_ordered_semiring_1 Real where {
};

data Term a b = Var b | Fun a [Term a b];

instance (Eq a, Eq b) => Eq (Term a b) where {
  a == b = equal_term a b;
};

equal_term :: forall a b. (Eq a, Eq b) => Term a b -> Term a b -> Bool;
equal_term (Var x1) (Fun x21 x22) = False;
equal_term (Fun x21 x22) (Var x1) = False;
equal_term (Fun x21 x22) (Fun y21 y22) = x21 == y21 && x22 == y22;
equal_term (Var x1) (Var y1) = x1 == y1;

comparator_term ::
  forall a b.
    (a -> a -> Ordera) -> (b -> b -> Ordera) -> Term a b -> Term a b -> Ordera;
comparator_term comp_f comp_v (Var x) (Var y) = comp_v x y;
comparator_term comp_f comp_v (Var x) (Fun ya yb) = Lt;
comparator_term comp_f comp_v (Fun x xa) (Var y) = Gt;
comparator_term comp_f comp_v (Fun x xa) (Fun ya yb) =
  (case comp_f x ya of {
    Eqa -> comparator_list (comparator_term comp_f comp_v) xa yb;
    Lt -> Lt;
    Gt -> Gt;
  });

compare_term ::
  forall a b. (Compare a, Compare b) => Term a b -> Term a b -> Ordera;
compare_term = comparator_term compare compare;

less_eq_term ::
  forall a b. (Compare a, Compare b) => Term a b -> Term a b -> Bool;
less_eq_term = le_of_comp compare_term;

less_term :: forall a b. (Compare a, Compare b) => Term a b -> Term a b -> Bool;
less_term = lt_of_comp compare_term;

instance (Compare a, Compare b) => Ord (Term a b) where {
  less_eq = less_eq_term;
  less = less_term;
};

instance (Compare a, Compare b) => Compare (Term a b) where {
  compare = compare_term;
};

instance (Compare a, Compare b) => Quasi_order (Term a b) where {
};

instance (Compare a, Compare b) => Weak_order (Term a b) where {
};

instance (Compare a, Compare b) => Preorder (Term a b) where {
};

instance (Compare a, Compare b) => Order (Term a b) where {
};

ceq_term :: forall a b. (Eq a, Eq b) => Maybe (Term a b -> Term a b -> Bool);
ceq_term = Just equal_term;

instance (Eq a, Eq b) => Ceq (Term a b) where {
  ceq = ceq_term;
};

set_impl_term :: forall a b. Phantom (Term a b) Set_impla;
set_impl_term = Phantom Set_RBT;

instance Set_impl (Term a b) where {
  set_impl = set_impl_term;
};

instance (Compare a, Compare b) => Linorder (Term a b) where {
};

showsl_term ::
  forall a b.
    (a -> String -> String) ->
      (b -> String -> String) -> Term a b -> String -> String;
showsl_term fun var (Var x) = var x;
showsl_term fun var (Fun f ts) =
  fun f . showsl_list_gen id "" "(" ", " ")" (map (showsl_term fun var) ts);

showsl_terma :: forall a b. (Showl a, Showl b) => Term a b -> String -> String;
showsl_terma t = showsl_term showsl showsl t;

showsl_list_term ::
  forall a b. (Showl a, Showl b) => [Term a b] -> String -> String;
showsl_list_term xs = default_showsl_list showsl_terma xs;

instance (Showl a, Showl b) => Showl (Term a b) where {
  showsl = showsl_terma;
  showsl_list = showsl_list_term;
};

cEnum_term ::
  forall a b.
    Maybe ([Term a b],
            ((Term a b -> Bool) -> Bool, (Term a b -> Bool) -> Bool));
cEnum_term = Nothing;

instance Cenum (Term a b) where {
  cEnum = cEnum_term;
};

instance (Compare a, Compare b) => Compare_order (Term a b) where {
};

finite_UNIV_term :: forall a b. Phantom (Term a b) Bool;
finite_UNIV_term = Phantom False;

instance Finite_UNIV (Term a b) where {
  finite_UNIV = finite_UNIV_term;
};

ccompare_term ::
  forall a b. (Compare a, Compare b) => Maybe (Term a b -> Term a b -> Ordera);
ccompare_term = Just compare_term;

instance (Compare a, Compare b) => Ccompare (Term a b) where {
  ccompare = ccompare_term;
};

cproper_interval_term ::
  forall a b.
    (Compare a, Compare b) => Maybe (Term a b) -> Maybe (Term a b) -> Bool;
cproper_interval_term = (\ _ _ -> False);

instance (Compare a, Compare b) => Cproper_interval (Term a b) where {
  cproper_interval = cproper_interval_term;
};

newtype Mat_impl a = Abs_mat_impl (Nat, (Nat, IArray.IArray (IArray.IArray a)));

rep_mat_impl ::
  forall a. Mat_impl a -> (Nat, (Nat, IArray.IArray (IArray.IArray a)));
rep_mat_impl (Abs_mat_impl x) = x;

length :: forall a. IArray.IArray a -> Nat;
length asa = nat_of_integer (IArray.length asa);

sub :: forall a. IArray.IArray a -> Nat -> a;
sub asa n = IArray.sub (asa, integer_of_nat n);

upt :: Nat -> Nat -> [Nat];
upt i j = (if less_nat i j then i : upt (suc i) j else []);

list_of :: forall a. IArray.IArray a -> [a];
list_of asa = map (sub asa) (upt zero_nat (length asa));

equal_iarray :: forall a. (Eq a) => IArray.IArray a -> IArray.IArray a -> Bool;
equal_iarray asa bs = list_of asa == list_of bs;

instance (Eq a) => Eq (IArray.IArray a) where {
  a == b = equal_iarray a b;
};

mat_equal_impl :: forall a. (Eq a) => Mat_impl a -> Mat_impl a -> Bool;
mat_equal_impl xa xc =
  (case rep_mat_impl xa of {
    (nr1, (nc1, m1)) ->
      (\ (nr2, (nc2, m2)) ->
        equal_nat nr1 nr2 && equal_nat nc1 nc2 && equal_iarray m1 m2);
  })
    (rep_mat_impl xc);

newtype Mat a = Mat_impl (Mat_impl a);

equal_mat :: forall a. (Eq a) => Mat a -> Mat a -> Bool;
equal_mat (Mat_impl m1) (Mat_impl m2) = mat_equal_impl m1 m2;

instance (Eq a) => Eq (Mat a) where {
  a == b = equal_mat a b;
};

ceq_mat :: forall a. (Eq a) => Maybe (Mat a -> Mat a -> Bool);
ceq_mat = Just equal_mat;

instance (Eq a) => Ceq (Mat a) where {
  ceq = ceq_mat;
};

set_impl_mat :: forall a. Phantom (Mat a) Set_impla;
set_impl_mat = Phantom Set_DList;

instance Set_impl (Mat a) where {
  set_impl = set_impl_mat;
};

nth :: forall a. [a] -> Nat -> a;
nth (x : xs) n =
  (if equal_nat n zero_nat then x else nth xs (minus_nat n one_nat));

index_mat_impl :: forall a. Mat_impl a -> (Nat, Nat) -> a;
index_mat_impl xa =
  (case rep_mat_impl xa of {
    (nr, (_, m)) ->
      (\ (i, j) ->
        (if less_nat i nr then sub (sub m i) j
          else sub (IArray.of_list (nth [] (minus_nat i nr))) j));
  });

index_mat :: forall a. Mat a -> (Nat, Nat) -> a;
index_mat (Mat_impl m) ij = index_mat_impl m ij;

dim_row_impl :: forall a. Mat_impl a -> Nat;
dim_row_impl xa = fst (rep_mat_impl xa);

dim_row :: forall a. Mat a -> Nat;
dim_row (Mat_impl m) = dim_row_impl m;

dim_col_impl :: forall a. Mat_impl a -> Nat;
dim_col_impl xa = fst (snd (rep_mat_impl xa));

dim_col :: forall a. Mat a -> Nat;
dim_col (Mat_impl m) = dim_col_impl m;

mat_to_list :: forall a. Mat a -> [[a]];
mat_to_list a =
  map (\ i -> map (\ j -> index_mat a (i, j)) (upt zero_nat (dim_col a)))
    (upt zero_nat (dim_row a));

showsl_mat :: forall a. (Showl a) => Mat a -> String -> String;
showsl_mat a = default_showsl_list id (map showsl_list (mat_to_list a));

showsl_list_mat :: forall a. (Showl a) => [Mat a] -> String -> String;
showsl_list_mat xs = default_showsl_list showsl_mat xs;

instance (Showl a) => Showl (Mat a) where {
  showsl = showsl_mat;
  showsl_list = showsl_list_mat;
};

cEnum_mat ::
  forall a. Maybe ([Mat a], ((Mat a -> Bool) -> Bool, (Mat a -> Bool) -> Bool));
cEnum_mat = Nothing;

instance Cenum (Mat a) where {
  cEnum = cEnum_mat;
};

ccompare_mat :: forall a. Maybe (Mat a -> Mat a -> Ordera);
ccompare_mat = Nothing;

instance Ccompare (Mat a) where {
  ccompare = ccompare_mat;
};

equal_char :: Char -> Char -> Bool;
equal_char c d = integer_of_char c == integer_of_char d;

instance Eq Char where {
  a == b = equal_char a b;
};

less_eq_char :: Char -> Char -> Bool;
less_eq_char c d = integer_of_char c <= integer_of_char d;

less_char :: Char -> Char -> Bool;
less_char c d = integer_of_char c < integer_of_char d;

instance Ord Char where {
  less_eq = less_eq_char;
  less = less_char;
};

instance Quasi_order Char where {
};

instance Weak_order Char where {
};

instance Preorder Char where {
};

instance Order Char where {
};

instance Linorder Char where {
};

compare_char :: Char -> Char -> Ordera;
compare_char = comparator_of;

instance Compare Char where {
  compare = compare_char;
};

ceq_char :: Maybe (Char -> Char -> Bool);
ceq_char = Just equal_char;

instance Ceq Char where {
  ceq = ceq_char;
};

instance Countable Char where {
};

showsl_list_char :: [Char] -> String -> String;
showsl_list_char cs s = showsl_lit (implode cs) s;

showsl_char :: Char -> String -> String;
showsl_char c = showsl_lit (implode [c]);

instance Showl Char where {
  showsl = showsl_char;
  showsl_list = showsl_list_char;
};

instance Compare_order Char where {
};

ccompare_char :: Maybe (Char -> Char -> Ordera);
ccompare_char = Just compare_char;

instance Ccompare Char where {
  ccompare = ccompare_char;
};

data Atom a = Leq Nat a | Geq Nat a;

equal_atom :: forall a. (Eq a) => Atom a -> Atom a -> Bool;
equal_atom (Leq x11 x12) (Geq x21 x22) = False;
equal_atom (Geq x21 x22) (Leq x11 x12) = False;
equal_atom (Geq x21 x22) (Geq y21 y22) = equal_nat x21 y21 && x22 == y22;
equal_atom (Leq x11 x12) (Leq y11 y12) = equal_nat x11 y11 && x12 == y12;

ceq_atom :: forall a. (Eq a) => Maybe (Atom a -> Atom a -> Bool);
ceq_atom = Just equal_atom;

instance (Eq a) => Ceq (Atom a) where {
  ceq = ceq_atom;
};

set_impl_atom :: forall a. Phantom (Atom a) Set_impla;
set_impl_atom = Phantom Set_RBT;

instance Set_impl (Atom a) where {
  set_impl = set_impl_atom;
};

comparator_atom :: forall a. (a -> a -> Ordera) -> Atom a -> Atom a -> Ordera;
comparator_atom comp_a (Leq x xa) (Leq y ya) = (case comparator_of x y of {
         Eqa -> comp_a xa ya;
         Lt -> Lt;
         Gt -> Gt;
       });
comparator_atom comp_a (Leq x xa) (Geq yb yc) = Lt;
comparator_atom comp_a (Geq x xa) (Leq y ya) = Gt;
comparator_atom comp_a (Geq x xa) (Geq yb yc) = (case comparator_of x yb of {
          Eqa -> comp_a xa yc;
          Lt -> Lt;
          Gt -> Gt;
        });

ccompare_atom :: forall a. (Ccompare a) => Maybe (Atom a -> Atom a -> Ordera);
ccompare_atom = (case ccompare of {
                  Nothing -> Nothing;
                  Just comp_a -> Just (comparator_atom comp_a);
                });

instance (Ccompare a) => Ccompare (Atom a) where {
  ccompare = ccompare_atom;
};

data Sum a b = Inl a | Inr b;

equal_sum :: forall a b. (Eq a, Eq b) => Sum a b -> Sum a b -> Bool;
equal_sum (Inl x1) (Inr x2) = False;
equal_sum (Inr x2) (Inl x1) = False;
equal_sum (Inr x2) (Inr y2) = x2 == y2;
equal_sum (Inl x1) (Inl y1) = x1 == y1;

instance (Eq a, Eq b) => Eq (Sum a b) where {
  a == b = equal_sum a b;
};

showsl_sum :: forall a b. (Showl a, Showl b) => Sum a b -> String -> String;
showsl_sum (Inl x) = (showsl_lit "Inl (" . showsl x) . showsl_lit ")";
showsl_sum (Inr x) = (showsl_lit "Inr (" . showsl x) . showsl_lit ")";

showsl_list_sum ::
  forall a b. (Showl a, Showl b) => [Sum a b] -> String -> String;
showsl_list_sum xs = default_showsl_list showsl_sum xs;

instance (Showl a, Showl b) => Showl (Sum a b) where {
  showsl = showsl_sum;
  showsl_list = showsl_list_sum;
};

data Trans_var a = Pre a | Post a | Intermediate a;

equal_trans_var :: forall a. (Eq a) => Trans_var a -> Trans_var a -> Bool;
equal_trans_var (Post x2) (Intermediate x3) = False;
equal_trans_var (Intermediate x3) (Post x2) = False;
equal_trans_var (Pre x1) (Intermediate x3) = False;
equal_trans_var (Intermediate x3) (Pre x1) = False;
equal_trans_var (Pre x1) (Post x2) = False;
equal_trans_var (Post x2) (Pre x1) = False;
equal_trans_var (Intermediate x3) (Intermediate y3) = x3 == y3;
equal_trans_var (Post x2) (Post y2) = x2 == y2;
equal_trans_var (Pre x1) (Pre y1) = x1 == y1;

instance (Eq a) => Eq (Trans_var a) where {
  a == b = equal_trans_var a b;
};

comparator_trans_var ::
  forall a. (a -> a -> Ordera) -> Trans_var a -> Trans_var a -> Ordera;
comparator_trans_var comp_v (Pre x) (Pre y) = comp_v x y;
comparator_trans_var comp_v (Pre x) (Post ya) = Lt;
comparator_trans_var comp_v (Pre x) (Intermediate yb) = Lt;
comparator_trans_var comp_v (Post x) (Pre y) = Gt;
comparator_trans_var comp_v (Post x) (Post ya) = comp_v x ya;
comparator_trans_var comp_v (Post x) (Intermediate yb) = Lt;
comparator_trans_var comp_v (Intermediate x) (Pre y) = Gt;
comparator_trans_var comp_v (Intermediate x) (Post ya) = Gt;
comparator_trans_var comp_v (Intermediate x) (Intermediate yb) = comp_v x yb;

compare_trans_var ::
  forall a. (Compare a) => Trans_var a -> Trans_var a -> Ordera;
compare_trans_var = comparator_trans_var compare;

less_eq_trans_var ::
  forall a. (Compare a) => Trans_var a -> Trans_var a -> Bool;
less_eq_trans_var = le_of_comp compare_trans_var;

less_trans_var :: forall a. (Compare a) => Trans_var a -> Trans_var a -> Bool;
less_trans_var = lt_of_comp compare_trans_var;

instance (Compare a) => Ord (Trans_var a) where {
  less_eq = less_eq_trans_var;
  less = less_trans_var;
};

instance (Compare a) => Quasi_order (Trans_var a) where {
};

instance (Compare a) => Weak_order (Trans_var a) where {
};

instance (Compare a) => Preorder (Trans_var a) where {
};

instance (Compare a) => Order (Trans_var a) where {
};

instance (Compare a) => Linorder (Trans_var a) where {
};

showsl_trans_var :: forall a. (Showl a) => Trans_var a -> String -> String;
showsl_trans_var (Pre v) = showsl v;
showsl_trans_var (Post v) = showsl v . showsl_lit "\'";
showsl_trans_var (Intermediate v) = showsl v . showsl_lit "#";

showsl_list_trans_var ::
  forall a. (Showl a) => [Trans_var a] -> String -> String;
showsl_list_trans_var xs = default_showsl_list showsl_trans_var xs;

instance (Showl a) => Showl (Trans_var a) where {
  showsl = showsl_trans_var;
  showsl_list = showsl_list_trans_var;
};

ccompare_trans_var ::
  forall a. (Ccompare a) => Maybe (Trans_var a -> Trans_var a -> Ordera);
ccompare_trans_var = (case ccompare of {
                       Nothing -> Nothing;
                       Just comp_v -> Just (comparator_trans_var comp_v);
                     });

instance (Ccompare a) => Ccompare (Trans_var a) where {
  ccompare = ccompare_trans_var;
};

mapping_impl_trans_var :: forall a. Phantom (Trans_var a) Mapping_impla;
mapping_impl_trans_var = Phantom Mapping_RBT;

instance Mapping_impl (Trans_var a) where {
  mapping_impl = mapping_impl_trans_var;
};

data Lab a b = Lab (Lab a b) b | FunLab (Lab a b) [Lab a b] | UnLab a
  | Sharp (Lab a b);

instance (Eq a, Eq b) => Eq (Lab a b) where {
  a == b = equal_lab a b;
};

equal_lab :: forall a b. (Eq a, Eq b) => Lab a b -> Lab a b -> Bool;
equal_lab (UnLab x3) (Sharp x4) = False;
equal_lab (Sharp x4) (UnLab x3) = False;
equal_lab (FunLab x21 x22) (Sharp x4) = False;
equal_lab (Sharp x4) (FunLab x21 x22) = False;
equal_lab (FunLab x21 x22) (UnLab x3) = False;
equal_lab (UnLab x3) (FunLab x21 x22) = False;
equal_lab (Lab x11 x12) (Sharp x4) = False;
equal_lab (Sharp x4) (Lab x11 x12) = False;
equal_lab (Lab x11 x12) (UnLab x3) = False;
equal_lab (UnLab x3) (Lab x11 x12) = False;
equal_lab (Lab x11 x12) (FunLab x21 x22) = False;
equal_lab (FunLab x21 x22) (Lab x11 x12) = False;
equal_lab (Sharp x4) (Sharp y4) = equal_lab x4 y4;
equal_lab (UnLab x3) (UnLab y3) = x3 == y3;
equal_lab (FunLab x21 x22) (FunLab y21 y22) = equal_lab x21 y21 && x22 == y22;
equal_lab (Lab x11 x12) (Lab y11 y12) = equal_lab x11 y11 && x12 == y12;

default_lab :: forall a b. (Default a) => Lab a b;
default_lab = UnLab defaulta;

instance (Default a) => Default (Lab a b) where {
  defaulta = default_lab;
};

comparator_lab ::
  forall a b.
    (a -> a -> Ordera) -> (b -> b -> Ordera) -> Lab a b -> Lab a b -> Ordera;
comparator_lab comp_f comp_l (Lab x xa) (Lab y ya) =
  (case comparator_lab comp_f comp_l x y of {
    Eqa -> comp_l xa ya;
    Lt -> Lt;
    Gt -> Gt;
  });
comparator_lab comp_f comp_l (Lab x xa) (FunLab yb yc) = Lt;
comparator_lab comp_f comp_l (Lab x xa) (UnLab yd) = Lt;
comparator_lab comp_f comp_l (Lab x xa) (Sharp ye) = Lt;
comparator_lab comp_f comp_l (FunLab x xa) (Lab y ya) = Gt;
comparator_lab comp_f comp_l (FunLab x xa) (FunLab yb yc) =
  (case comparator_lab comp_f comp_l x yb of {
    Eqa -> comparator_list (comparator_lab comp_f comp_l) xa yc;
    Lt -> Lt;
    Gt -> Gt;
  });
comparator_lab comp_f comp_l (FunLab x xa) (UnLab yd) = Lt;
comparator_lab comp_f comp_l (FunLab x xa) (Sharp ye) = Lt;
comparator_lab comp_f comp_l (UnLab x) (Lab y ya) = Gt;
comparator_lab comp_f comp_l (UnLab x) (FunLab yb yc) = Gt;
comparator_lab comp_f comp_l (UnLab x) (UnLab yd) = comp_f x yd;
comparator_lab comp_f comp_l (UnLab x) (Sharp ye) = Lt;
comparator_lab comp_f comp_l (Sharp x) (Lab y ya) = Gt;
comparator_lab comp_f comp_l (Sharp x) (FunLab yb yc) = Gt;
comparator_lab comp_f comp_l (Sharp x) (UnLab yd) = Gt;
comparator_lab comp_f comp_l (Sharp x) (Sharp ye) =
  comparator_lab comp_f comp_l x ye;

compare_lab ::
  forall a b. (Compare a, Compare b) => Lab a b -> Lab a b -> Ordera;
compare_lab = comparator_lab compare compare;

less_eq_lab :: forall a b. (Compare a, Compare b) => Lab a b -> Lab a b -> Bool;
less_eq_lab = le_of_comp compare_lab;

less_lab :: forall a b. (Compare a, Compare b) => Lab a b -> Lab a b -> Bool;
less_lab = lt_of_comp compare_lab;

instance (Compare a, Compare b) => Ord (Lab a b) where {
  less_eq = less_eq_lab;
  less = less_lab;
};

instance (Compare a, Compare b) => Compare (Lab a b) where {
  compare = compare_lab;
};

instance (Compare a, Compare b) => Quasi_order (Lab a b) where {
};

instance (Compare a, Compare b) => Weak_order (Lab a b) where {
};

instance (Compare a, Compare b) => Preorder (Lab a b) where {
};

instance (Compare a, Compare b) => Order (Lab a b) where {
};

ceq_lab :: forall a b. (Eq a, Eq b) => Maybe (Lab a b -> Lab a b -> Bool);
ceq_lab = Just equal_lab;

instance (Eq a, Eq b) => Ceq (Lab a b) where {
  ceq = ceq_lab;
};

set_impl_lab :: forall a b. Phantom (Lab a b) Set_impla;
set_impl_lab = Phantom Set_RBT;

instance Set_impl (Lab a b) where {
  set_impl = set_impl_lab;
};

instance (Compare a, Compare b) => Linorder (Lab a b) where {
};

showsl_lab :: forall a b. (Showl a, Showl b) => Lab a b -> String -> String;
showsl_lab (UnLab f) = showsl f;
showsl_lab (Lab f l) =
  ((showsl_lab f . showsl_lit "[") . showsl l) . showsl_lit "]";
showsl_lab (Sharp f) = showsl_lab f . showsl_lit "#";
showsl_lab (FunLab f l) =
  showsl_lab f . default_showsl_list id (map showsl_lab l);

showsl_list_lab ::
  forall a b. (Showl a, Showl b) => [Lab a b] -> String -> String;
showsl_list_lab xs = default_showsl_list showsl_lab xs;

instance (Showl a, Showl b) => Showl (Lab a b) where {
  showsl = showsl_lab;
  showsl_list = showsl_list_lab;
};

finite_UNIV_lab :: forall a b. Phantom (Lab a b) Bool;
finite_UNIV_lab = Phantom False;

card_UNIV_lab :: forall a b. Phantom (Lab a b) Nat;
card_UNIV_lab = Phantom zero_nat;

instance Finite_UNIV (Lab a b) where {
  finite_UNIV = finite_UNIV_lab;
};

instance Card_UNIV (Lab a b) where {
  card_UNIV = card_UNIV_lab;
};

cEnum_lab ::
  forall a b.
    Maybe ([Lab a b], ((Lab a b -> Bool) -> Bool, (Lab a b -> Bool) -> Bool));
cEnum_lab = Nothing;

instance Cenum (Lab a b) where {
  cEnum = cEnum_lab;
};

instance (Compare a, Compare b) => Compare_order (Lab a b) where {
};

ccompare_lab ::
  forall a b. (Compare a, Compare b) => Maybe (Lab a b -> Lab a b -> Ordera);
ccompare_lab = Just compare_lab;

instance (Compare a, Compare b) => Ccompare (Lab a b) where {
  ccompare = ccompare_lab;
};

mapping_impl_lab :: forall a b. Phantom (Lab a b) Mapping_impla;
mapping_impl_lab = Phantom Mapping_RBT;

instance Mapping_impl (Lab a b) where {
  mapping_impl = mapping_impl_lab;
};

cproper_interval_lab ::
  forall a b.
    (Compare a, Compare b) => Maybe (Lab a b) -> Maybe (Lab a b) -> Bool;
cproper_interval_lab = (\ _ _ -> False);

instance (Compare a, Compare b) => Cproper_interval (Lab a b) where {
  cproper_interval = cproper_interval_lab;
};

equality_option :: forall a. (a -> a -> Bool) -> Maybe a -> Maybe a -> Bool;
equality_option eq_a Nothing Nothing = True;
equality_option eq_a Nothing (Just y) = False;
equality_option eq_a (Just x) Nothing = False;
equality_option eq_a (Just x) (Just y) = eq_a x y;

ceq_option :: forall a. (Ceq a) => Maybe (Maybe a -> Maybe a -> Bool);
ceq_option = (case ceq of {
               Nothing -> Nothing;
               Just eq_a -> Just (equality_option eq_a);
             });

instance (Ceq a) => Ceq (Maybe a) where {
  ceq = ceq_option;
};

set_impl_option :: forall a. (Set_impl a) => Phantom (Maybe a) Set_impla;
set_impl_option = Phantom (of_phantom (set_impl :: Phantom a Set_impla));

instance (Set_impl a) => Set_impl (Maybe a) where {
  set_impl = set_impl_option;
};

cEnum_option ::
  forall a.
    (Cenum a) => Maybe ([Maybe a],
                         ((Maybe a -> Bool) -> Bool,
                           (Maybe a -> Bool) -> Bool));
cEnum_option =
  (case cEnum of {
    Nothing -> Nothing;
    Just (enum_a, (enum_all_a, enum_ex_a)) ->
      Just (Nothing : map Just enum_a,
             ((\ p -> p Nothing && enum_all_a (\ x -> p (Just x))),
               (\ p -> p Nothing || enum_ex_a (\ x -> p (Just x)))));
  });

instance (Cenum a) => Cenum (Maybe a) where {
  cEnum = cEnum_option;
};

finite_UNIV_option :: forall a. (Finite_UNIV a) => Phantom (Maybe a) Bool;
finite_UNIV_option = Phantom (of_phantom (finite_UNIV :: Phantom a Bool));

instance (Finite_UNIV a) => Finite_UNIV (Maybe a) where {
  finite_UNIV = finite_UNIV_option;
};

comparator_option ::
  forall a. (a -> a -> Ordera) -> Maybe a -> Maybe a -> Ordera;
comparator_option comp_a Nothing Nothing = Eqa;
comparator_option comp_a Nothing (Just y) = Lt;
comparator_option comp_a (Just x) Nothing = Gt;
comparator_option comp_a (Just x) (Just y) = comp_a x y;

ccompare_option ::
  forall a. (Ccompare a) => Maybe (Maybe a -> Maybe a -> Ordera);
ccompare_option = (case ccompare of {
                    Nothing -> Nothing;
                    Just comp_a -> Just (comparator_option comp_a);
                  });

instance (Ccompare a) => Ccompare (Maybe a) where {
  ccompare = ccompare_option;
};

mapping_impl_option ::
  forall a. (Mapping_impl a) => Phantom (Maybe a) Mapping_impla;
mapping_impl_option =
  Phantom (of_phantom (mapping_impl :: Phantom a Mapping_impla));

instance (Mapping_impl a) => Mapping_impl (Maybe a) where {
  mapping_impl = mapping_impl_option;
};

cproper_interval_option ::
  forall a. (Cproper_interval a) => Maybe (Maybe a) -> Maybe (Maybe a) -> Bool;
cproper_interval_option Nothing Nothing = True;
cproper_interval_option Nothing (Just x) = not (is_none x);
cproper_interval_option (Just x) Nothing = cproper_interval x Nothing;
cproper_interval_option (Just x) (Just Nothing) = False;
cproper_interval_option (Just x) (Just (Just y)) = cproper_interval x (Just y);

instance (Cproper_interval a) => Cproper_interval (Maybe a) where {
  cproper_interval = cproper_interval_option;
};

data QDelta = QDelta Rat Rat;

equal_QDelta :: QDelta -> QDelta -> Bool;
equal_QDelta (QDelta x1 x2) (QDelta y1 y2) = equal_rat x1 y1 && equal_rat x2 y2;

instance Eq QDelta where {
  a == b = equal_QDelta a b;
};

one_QDelta :: QDelta;
one_QDelta = QDelta one_rat zero_rat;

instance One QDelta where {
  onea = one_QDelta;
};

qdsnd :: QDelta -> Rat;
qdsnd (QDelta a b) = b;

qdfst :: QDelta -> Rat;
qdfst (QDelta a b) = a;

plus_QDelta :: QDelta -> QDelta -> QDelta;
plus_QDelta qd1 qd2 =
  QDelta (plus_rat (qdfst qd1) (qdfst qd2)) (plus_rat (qdsnd qd1) (qdsnd qd2));

instance Plus QDelta where {
  plus = plus_QDelta;
};

zero_QDelta :: QDelta;
zero_QDelta = QDelta zero_rat zero_rat;

instance Zero QDelta where {
  zerob = zero_QDelta;
};

minus_QDelta :: QDelta -> QDelta -> QDelta;
minus_QDelta qd1 qd2 =
  QDelta (minus_rat (qdfst qd1) (qdfst qd2))
    (minus_rat (qdsnd qd1) (qdsnd qd2));

instance Minus QDelta where {
  minusa = minus_QDelta;
};

uminus_QDelta :: QDelta -> QDelta;
uminus_QDelta qd = QDelta (uminus_rat (qdfst qd)) (uminus_rat (qdsnd qd));

instance Uminus QDelta where {
  uminus = uminus_QDelta;
};

less_eq_QDelta :: QDelta -> QDelta -> Bool;
less_eq_QDelta qd1 qd2 =
  less_rat (qdfst qd1) (qdfst qd2) ||
    equal_rat (qdfst qd1) (qdfst qd2) && less_eq_rat (qdsnd qd1) (qdsnd qd2);

less_QDelta :: QDelta -> QDelta -> Bool;
less_QDelta qd1 qd2 =
  less_rat (qdfst qd1) (qdfst qd2) ||
    equal_rat (qdfst qd1) (qdfst qd2) && less_rat (qdsnd qd1) (qdsnd qd2);

instance Ord QDelta where {
  less_eq = less_eq_QDelta;
  less = less_QDelta;
};

instance Quasi_order QDelta where {
};

instance Weak_order QDelta where {
};

instance Preorder QDelta where {
};

instance Order QDelta where {
};

instance Semigroup_add QDelta where {
};

instance Cancel_semigroup_add QDelta where {
};

instance Monoid_add QDelta where {
};

instance Group_add QDelta where {
};

instance Linorder QDelta where {
};

instance Ab_semigroup_add QDelta where {
};

instance Cancel_ab_semigroup_add QDelta where {
};

instance Comm_monoid_add QDelta where {
};

instance Cancel_comm_monoid_add QDelta where {
};

instance Ab_group_add QDelta where {
};

scaleRat_QDelta :: Rat -> QDelta -> QDelta;
scaleRat_QDelta r qd = QDelta (times_rat r (qdfst qd)) (times_rat r (qdsnd qd));

class ScaleRat a where {
  scaleRat :: Rat -> a -> a;
};

class (Ab_group_add a, ScaleRat a) => Rational_vector a where {
};

class (Order a, Rational_vector a) => Ordered_rational_vector a where {
};

class (Ordered_ab_semigroup_add a, Linorder a,
        Ordered_rational_vector a) => Linordered_rational_vector a where {
};

class (One a, Linordered_rational_vector a) => Lrv a where {
};

instance ScaleRat QDelta where {
  scaleRat = scaleRat_QDelta;
};

instance Rational_vector QDelta where {
};

instance Ordered_rational_vector QDelta where {
};

instance Ordered_ab_semigroup_add QDelta where {
};

instance Linordered_rational_vector QDelta where {
};

instance Lrv QDelta where {
};

ccompare_QDelta :: Maybe (QDelta -> QDelta -> Ordera);
ccompare_QDelta = Just comparator_of;

instance Ccompare QDelta where {
  ccompare = ccompare_QDelta;
};

data Formula a = Atom a | NegAtom a | Conjunction [Formula a]
  | Disjunction [Formula a];

instance (Eq a) => Eq (Formula a) where {
  a == b = equal_formula a b;
};

equal_formula :: forall a. (Eq a) => Formula a -> Formula a -> Bool;
equal_formula (Conjunction x3) (Disjunction x4) = False;
equal_formula (Disjunction x4) (Conjunction x3) = False;
equal_formula (NegAtom x2) (Disjunction x4) = False;
equal_formula (Disjunction x4) (NegAtom x2) = False;
equal_formula (NegAtom x2) (Conjunction x3) = False;
equal_formula (Conjunction x3) (NegAtom x2) = False;
equal_formula (Atom x1) (Disjunction x4) = False;
equal_formula (Disjunction x4) (Atom x1) = False;
equal_formula (Atom x1) (Conjunction x3) = False;
equal_formula (Conjunction x3) (Atom x1) = False;
equal_formula (Atom x1) (NegAtom x2) = False;
equal_formula (NegAtom x2) (Atom x1) = False;
equal_formula (Disjunction x4) (Disjunction y4) = x4 == y4;
equal_formula (Conjunction x3) (Conjunction y3) = x3 == y3;
equal_formula (NegAtom x2) (NegAtom y2) = x2 == y2;
equal_formula (Atom x1) (Atom y1) = x1 == y1;

newtype Poly a = Poly [a];

coeffs :: forall a. (Zero a) => Poly a -> [a];
coeffs (Poly x) = x;

equal_poly :: forall a. (Zero a, Eq a) => Poly a -> Poly a -> Bool;
equal_poly p q = coeffs p == coeffs q;

instance (Zero a, Eq a) => Eq (Poly a) where {
  a == b = equal_poly a b;
};

zero_polya :: forall a. (Zero a) => Poly a;
zero_polya = Poly [];

cCons :: forall a. (Zero a, Eq a) => a -> [a] -> [a];
cCons x xs = (if null xs && x == zerob then [] else x : xs);

plus_coeffs :: forall a. (Comm_monoid_add a, Eq a) => [a] -> [a] -> [a];
plus_coeffs xs [] = xs;
plus_coeffs [] (v : va) = v : va;
plus_coeffs (x : xs) (y : ys) = cCons (plus x y) (plus_coeffs xs ys);

plus_poly :: forall a. (Comm_monoid_add a, Eq a) => Poly a -> Poly a -> Poly a;
plus_poly p q = Poly (plus_coeffs (coeffs p) (coeffs q));

foldr :: forall a b. (a -> b -> b) -> [a] -> b -> b;
foldr f [] = id;
foldr f (x : xs) = f x . foldr f xs;

fold_coeffs :: forall a b. (Zero a) => (a -> b -> b) -> Poly a -> b -> b;
fold_coeffs f p = foldr f (coeffs p);

smult ::
  forall a.
    (Eq a, Comm_semiring_0 a,
      Semiring_no_zero_divisors a) => a -> Poly a -> Poly a;
smult a p = Poly (if a == zerob then [] else map (times a) (coeffs p));

pCons :: forall a. (Zero a, Eq a) => a -> Poly a -> Poly a;
pCons a p = Poly (cCons a (coeffs p));

times_poly ::
  forall a.
    (Eq a, Comm_semiring_0 a,
      Semiring_no_zero_divisors a) => Poly a -> Poly a -> Poly a;
times_poly p q =
  fold_coeffs (\ a pa -> plus_poly (smult a q) (pCons zerob pa)) p zero_polya;

instance (Eq a, Comm_semiring_0 a,
           Semiring_no_zero_divisors a) => Times (Poly a) where {
  times = times_poly;
};

instance (Eq a, Comm_semiring_1 a,
           Semiring_no_zero_divisors a) => Dvd (Poly a) where {
};

one_polya :: forall a. (Comm_semiring_1 a) => Poly a;
one_polya = Poly [onea];

instance (Comm_semiring_1 a) => One (Poly a) where {
  onea = one_polya;
};

uminus_poly :: forall a. (Ab_group_add a) => Poly a -> Poly a;
uminus_poly p = Poly (map uminus (coeffs p));

minus_poly :: forall a. (Ab_group_add a, Eq a) => Poly a -> Poly a -> Poly a;
minus_poly p q = plus_poly p (uminus_poly q);

instance (Comm_monoid_add a, Eq a) => Plus (Poly a) where {
  plus = plus_poly;
};

instance (Comm_monoid_add a, Eq a) => Semigroup_add (Poly a) where {
};

instance (Cancel_comm_monoid_add a,
           Eq a) => Cancel_semigroup_add (Poly a) where {
};

instance (Comm_monoid_add a, Eq a) => Ab_semigroup_add (Poly a) where {
};

instance (Ab_group_add a, Eq a) => Minus (Poly a) where {
  minusa = minus_poly;
};

instance (Ab_group_add a, Eq a) => Cancel_ab_semigroup_add (Poly a) where {
};

instance (Zero a) => Zero (Poly a) where {
  zerob = zero_polya;
};

instance (Comm_monoid_add a, Eq a) => Monoid_add (Poly a) where {
};

instance (Comm_monoid_add a, Eq a) => Comm_monoid_add (Poly a) where {
};

instance (Ab_group_add a, Eq a) => Cancel_comm_monoid_add (Poly a) where {
};

instance (Eq a, Comm_semiring_0 a,
           Semiring_no_zero_divisors a) => Mult_zero (Poly a) where {
};

instance (Eq a, Comm_semiring_0 a,
           Semiring_no_zero_divisors a) => Semigroup_mult (Poly a) where {
};

instance (Eq a, Comm_semiring_0 a,
           Semiring_no_zero_divisors a) => Semiring (Poly a) where {
};

instance (Eq a, Comm_semiring_0 a,
           Semiring_no_zero_divisors a) => Semiring_0 (Poly a) where {
};

instance (Ab_group_add a, Eq a, Comm_semiring_0_cancel a,
           Semiring_no_zero_divisors a) => Semiring_0_cancel (Poly a) where {
};

instance (Eq a, Comm_semiring_0 a,
           Semiring_no_zero_divisors a) => Ab_semigroup_mult (Poly a) where {
};

instance (Eq a, Comm_semiring_0 a,
           Semiring_no_zero_divisors a) => Comm_semiring (Poly a) where {
};

instance (Eq a, Comm_semiring_0 a,
           Semiring_no_zero_divisors a) => Comm_semiring_0 (Poly a) where {
};

instance (Ab_group_add a, Eq a, Comm_semiring_0_cancel a,
           Semiring_no_zero_divisors a) => Comm_semiring_0_cancel (Poly
                            a) where {
};

instance (Eq a, Comm_semiring_1 a,
           Semiring_no_zero_divisors a) => Power (Poly a) where {
};

instance (Eq a, Comm_semiring_1 a,
           Semiring_no_zero_divisors a) => Monoid_mult (Poly a) where {
};

instance (Eq a, Comm_semiring_1 a) => Numeral (Poly a) where {
};

instance (Eq a, Comm_semiring_1 a,
           Semiring_no_zero_divisors a) => Semiring_numeral (Poly a) where {
};

instance (Comm_semiring_1 a) => Zero_neq_one (Poly a) where {
};

instance (Eq a, Comm_semiring_1 a,
           Semiring_no_zero_divisors a) => Semiring_1 (Poly a) where {
};

instance (Eq a, Comm_ring_1 a,
           Semiring_no_zero_divisors a) => Semiring_1_cancel (Poly a) where {
};

instance (Eq a, Comm_semiring_1 a,
           Semiring_no_zero_divisors a) => Comm_monoid_mult (Poly a) where {
};

instance (Eq a, Comm_semiring_1 a,
           Semiring_no_zero_divisors a) => Comm_semiring_1 (Poly a) where {
};

instance (Eq a, Comm_ring_1 a,
           Semiring_no_zero_divisors a) => Comm_semiring_1_cancel (Poly
                            a) where {
};

instance (Eq a, Idom a) => Comm_semiring_1_cancel_crossproduct (Poly a) where {
};

instance (Eq a, Comm_semiring_0 a,
           Semiring_no_zero_divisors a) => Semiring_no_zero_divisors (Poly
                               a) where {
};

instance (Eq a, Comm_semiring_1 a,
           Semiring_1_no_zero_divisors a) => Semiring_1_no_zero_divisors (Poly
                                   a) where {
};

instance (Eq a, Idom a) => Semiring_no_zero_divisors_cancel (Poly a) where {
};

instance (Ab_group_add a) => Uminus (Poly a) where {
  uminus = uminus_poly;
};

instance (Ab_group_add a, Eq a) => Group_add (Poly a) where {
};

instance (Ab_group_add a, Eq a) => Ab_group_add (Poly a) where {
};

instance (Eq a, Comm_ring a,
           Semiring_no_zero_divisors a) => Ring (Poly a) where {
};

instance (Eq a, Idom a) => Ring_no_zero_divisors (Poly a) where {
};

instance (Eq a, Comm_ring_1 a) => Neg_numeral (Poly a) where {
};

instance (Eq a, Comm_ring_1 a,
           Semiring_no_zero_divisors a) => Ring_1 (Poly a) where {
};

instance (Eq a, Idom a) => Ring_1_no_zero_divisors (Poly a) where {
};

instance (Eq a, Comm_ring a,
           Semiring_no_zero_divisors a) => Comm_ring (Poly a) where {
};

instance (Eq a, Comm_ring_1 a,
           Semiring_no_zero_divisors a) => Comm_ring_1 (Poly a) where {
};

instance (Eq a, Idom a) => Semidom (Poly a) where {
};

instance (Eq a, Idom a) => Idom (Poly a) where {
};

minus_poly_rev_list :: forall a. (Group_add a) => [a] -> [a] -> [a];
minus_poly_rev_list (x : xs) (y : ys) = minusa x y : minus_poly_rev_list xs ys;
minus_poly_rev_list xs [] = xs;
minus_poly_rev_list [] (y : ys) = [];

tla :: forall a. [a] -> [a];
tla [] = [];
tla (x21 : x22) = x22;

hda :: forall a. [a] -> a;
hda (x21 : x22) = x21;

divide_poly_main_list ::
  forall a. (Eq a, Idom_divide a) => a -> [a] -> [a] -> [a] -> Nat -> [a];
divide_poly_main_list lc q r d n =
  (if equal_nat n zero_nat then q
    else let {
           cr = hda r;
         } in (if cr == zerob
                then divide_poly_main_list lc (cCons cr q) (tla r) d
                       (minus_nat n one_nat)
                else let {
                       a = divide cr lc;
                       qq = cCons a q;
                       rr = minus_poly_rev_list r (map (times a) d);
                     } in (if hda rr == zerob
                            then divide_poly_main_list lc qq (tla rr) d
                                   (minus_nat n one_nat)
                            else [])));

strip_while :: forall a. (a -> Bool) -> [a] -> [a];
strip_while p = (reverse . dropWhile p) . reverse;

poly_of_list :: forall a. (Comm_monoid_add a, Eq a) => [a] -> Poly a;
poly_of_list asa = Poly (strip_while (\ a -> zerob == a) asa);

divide_poly_list ::
  forall a. (Eq a, Idom_divide a) => Poly a -> Poly a -> Poly a;
divide_poly_list f g =
  let {
    cg = coeffs g;
  } in (if null cg then g
         else let {
                cf = coeffs f;
                cgr = reverse cg;
              } in poly_of_list
                     (divide_poly_main_list (hda cgr) [] (reverse cf) cgr
                       (minus_nat (plus_nat one_nat (size_list cf))
                         (size_list cg))));

divide_poly :: forall a. (Eq a, Idom_divide a) => Poly a -> Poly a -> Poly a;
divide_poly f g = divide_poly_list f g;

instance (Eq a, Idom_divide a) => Divide (Poly a) where {
  divide = divide_poly;
};

instance (Eq a, Idom_divide a) => Divide_trivial (Poly a) where {
};

instance (Eq a, Idom_divide a) => Semidom_divide (Poly a) where {
};

instance (Eq a, Idom_divide a) => Idom_divide (Poly a) where {
};

map_of :: forall a b. (Eq a) => [(a, b)] -> a -> Maybe b;
map_of [] k = Nothing;
map_of ((l, v) : ps) k = (if l == k then Just v else map_of ps k);

count_of :: forall a. (Eq a) => [(a, Nat)] -> a -> Nat;
count_of xs x = (case map_of xs x of {
                  Nothing -> zero_nat;
                  Just n -> n;
                });

newtype Alist b a = Alist [(b, a)];

impl_ofa :: forall b a. Alist b a -> [(b, a)];
impl_ofa (Alist x) = x;

newtype Multiset a = Bag (Alist a Nat);

count :: forall a. (Eq a) => Multiset a -> a -> Nat;
count (Bag xs) = count_of (impl_ofa xs);

subseteq_mset :: forall a. (Eq a) => Multiset a -> Multiset a -> Bool;
subseteq_mset (Bag xs) a =
  all (\ (x, n) -> less_eq_nat n (count a x)) (impl_ofa xs);

equal_multiset :: forall a. (Eq a) => Multiset a -> Multiset a -> Bool;
equal_multiset m1 m2 = subseteq_mset m1 m2 && subseteq_mset m2 m1;

instance (Eq a) => Eq (Multiset a) where {
  a == b = equal_multiset a b;
};

map_default :: forall a b. (Eq a) => a -> b -> (b -> b) -> [(a, b)] -> [(a, b)];
map_default k v f [] = [(k, v)];
map_default k v f (p : ps) =
  (if fst p == k then (k, f (snd p)) : ps else p : map_default k v f ps);

join_raw ::
  forall a b. (Eq a) => (a -> (b, b) -> b) -> [(a, b)] -> [(a, b)] -> [(a, b)];
join_raw f xs ys =
  foldr (\ (k, v) -> map_default k v (\ va -> f k (va, v))) ys xs;

joina ::
  forall a b.
    (Eq a) => (a -> (b, b) -> b) -> Alist a b -> Alist a b -> Alist a b;
joina xc xd xe = Alist (join_raw xc (impl_ofa xd) (impl_ofa xe));

plus_multiset :: forall a. (Eq a) => Multiset a -> Multiset a -> Multiset a;
plus_multiset (Bag xs) (Bag ys) =
  Bag (joina (\ _ (a, b) -> plus_nat a b) xs ys);

instance (Eq a) => Plus (Multiset a) where {
  plus = plus_multiset;
};

emptya :: forall a b. Alist a b;
emptya = Alist [];

zero_multiset :: forall a. Multiset a;
zero_multiset = Bag emptya;

instance Zero (Multiset a) where {
  zerob = zero_multiset;
};

instance (Eq a) => Semigroup_add (Multiset a) where {
};

instance (Eq a) => Monoid_add (Multiset a) where {
};

instance (Eq a) => Ab_semigroup_add (Multiset a) where {
};

instance (Eq a) => Comm_monoid_add (Multiset a) where {
};

newtype Monom a = Abs_monom [(a, Nat)];

rep_monom :: forall a. (Linorder a) => Monom a -> [(a, Nat)];
rep_monom (Abs_monom x) = x;

equal_monom :: forall a. (Eq a, Linorder a) => Monom a -> Monom a -> Bool;
equal_monom xa xc = rep_monom xa == rep_monom xc;

instance (Eq a, Linorder a) => Eq (Monom a) where {
  a == b = equal_monom a b;
};

less_eq_prod :: forall a b. (Ord a, Ord b) => (a, b) -> (a, b) -> Bool;
less_eq_prod (x1, y1) (x2, y2) = less x1 x2 || less_eq x1 x2 && less_eq y1 y2;

less_prod :: forall a b. (Ord a, Ord b) => (a, b) -> (a, b) -> Bool;
less_prod (x1, y1) (x2, y2) = less x1 x2 || less_eq x1 x2 && less y1 y2;

instance (Ord a, Ord b) => Ord (a, b) where {
  less_eq = less_eq_prod;
  less = less_prod;
};

comparator_prod ::
  forall a b.
    (a -> a -> Ordera) -> (b -> b -> Ordera) -> (a, b) -> (a, b) -> Ordera;
comparator_prod comp_a comp_b (x, xa) (y, ya) = (case comp_a x y of {
          Eqa -> comp_b xa ya;
          Lt -> Lt;
          Gt -> Gt;
        });

compare_prod ::
  forall a b. (Compare a, Compare b) => (a, b) -> (a, b) -> Ordera;
compare_prod = comparator_prod compare compare;

instance (Compare a, Compare b) => Compare (a, b) where {
  compare = compare_prod;
};

instance (Order a, Order b) => Quasi_order (a, b) where {
};

instance (Order a, Order b) => Weak_order (a, b) where {
};

instance (Preorder a, Preorder b) => Preorder (a, b) where {
};

instance (Order a, Order b) => Order (a, b) where {
};

equality_prod ::
  forall a b. (a -> a -> Bool) -> (b -> b -> Bool) -> (a, b) -> (a, b) -> Bool;
equality_prod eq_a eq_b (x, xa) (y, ya) = eq_a x y && eq_b xa ya;

ceq_prod :: forall a b. (Ceq a, Ceq b) => Maybe ((a, b) -> (a, b) -> Bool);
ceq_prod = (case ceq of {
             Nothing -> Nothing;
             Just eq_a -> (case ceq of {
                            Nothing -> Nothing;
                            Just eq_b -> Just (equality_prod eq_a eq_b);
                          });
           });

instance (Ceq a, Ceq b) => Ceq (a, b) where {
  ceq = ceq_prod;
};

set_impl_choose2 :: Set_impla -> Set_impla -> Set_impla;
set_impl_choose2 Set_Monada Set_Monada = Set_Monada;
set_impl_choose2 Set_RBT Set_RBT = Set_RBT;
set_impl_choose2 Set_DList Set_DList = Set_DList;
set_impl_choose2 Set_Collect Set_Collect = Set_Collect;
set_impl_choose2 x y = Set_Choose;

set_impl_prod ::
  forall a b. (Set_impl a, Set_impl b) => Phantom (a, b) Set_impla;
set_impl_prod =
  Phantom
    (set_impl_choose2 (of_phantom (set_impl :: Phantom a Set_impla))
      (of_phantom (set_impl :: Phantom b Set_impla)));

instance (Set_impl a, Set_impl b) => Set_impl (a, b) where {
  set_impl = set_impl_prod;
};

instance (Linorder a, Linorder b) => Linorder (a, b) where {
};

showsl_prod :: forall a b. (Showl a, Showl b) => (a, b) -> String -> String;
showsl_prod (x, y) =
  (((showsl_lit "(" . showsl x) . showsl_lit ", ") . showsl y) . showsl_lit ")";

showsl_list_prod ::
  forall a b. (Showl a, Showl b) => [(a, b)] -> String -> String;
showsl_list_prod xs = default_showsl_list showsl_prod xs;

instance (Showl a, Showl b) => Showl (a, b) where {
  showsl = showsl_prod;
  showsl_list = showsl_list_prod;
};

finite_UNIV_prod ::
  forall a b. (Finite_UNIV a, Finite_UNIV b) => Phantom (a, b) Bool;
finite_UNIV_prod =
  Phantom
    (of_phantom (finite_UNIV :: Phantom a Bool) &&
      of_phantom (finite_UNIV :: Phantom b Bool));

card_UNIV_prod :: forall a b. (Card_UNIV a, Card_UNIV b) => Phantom (a, b) Nat;
card_UNIV_prod =
  Phantom
    (times_nat (of_phantom (card_UNIV :: Phantom a Nat))
      (of_phantom (card_UNIV :: Phantom b Nat)));

instance (Finite_UNIV a, Finite_UNIV b) => Finite_UNIV (a, b) where {
  finite_UNIV = finite_UNIV_prod;
};

instance (Card_UNIV a, Card_UNIV b) => Card_UNIV (a, b) where {
  card_UNIV = card_UNIV_prod;
};

product :: forall a b. [a] -> [b] -> [(a, b)];
product [] uu = [];
product (x : xs) ys = map (\ a -> (x, a)) ys ++ product xs ys;

cEnum_prod ::
  forall a b.
    (Cenum a,
      Cenum b) => Maybe ([(a, b)],
                          (((a, b) -> Bool) -> Bool, ((a, b) -> Bool) -> Bool));
cEnum_prod =
  (case cEnum of {
    Nothing -> Nothing;
    Just (enum_a, (enum_all_a, enum_ex_a)) ->
      (case cEnum of {
        Nothing -> Nothing;
        Just (enum_b, (enum_all_b, enum_ex_b)) ->
          Just (product enum_a enum_b,
                 ((\ p -> enum_all_a (\ x -> enum_all_b (\ y -> p (x, y)))),
                   (\ p -> enum_ex_a (\ x -> enum_ex_b (\ y -> p (x, y))))));
      });
  });

instance (Cenum a, Cenum b) => Cenum (a, b) where {
  cEnum = cEnum_prod;
};

instance (Compare_order a, Compare_order b) => Compare_order (a, b) where {
};

ccompare_prod ::
  forall a b. (Ccompare a, Ccompare b) => Maybe ((a, b) -> (a, b) -> Ordera);
ccompare_prod =
  (case ccompare of {
    Nothing -> Nothing;
    Just comp_a -> (case ccompare of {
                     Nothing -> Nothing;
                     Just comp_b -> Just (comparator_prod comp_a comp_b);
                   });
  });

instance (Ccompare a, Ccompare b) => Ccompare (a, b) where {
  ccompare = ccompare_prod;
};

mapping_impl_choose2 :: Mapping_impla -> Mapping_impla -> Mapping_impla;
mapping_impl_choose2 Mapping_RBT Mapping_RBT = Mapping_RBT;
mapping_impl_choose2 Mapping_Assoc_List Mapping_Assoc_List = Mapping_Assoc_List;
mapping_impl_choose2 Mapping_Mapping Mapping_Mapping = Mapping_Mapping;
mapping_impl_choose2 x y = Mapping_Choose;

mapping_impl_prod ::
  forall a b. (Mapping_impl a, Mapping_impl b) => Phantom (a, b) Mapping_impla;
mapping_impl_prod =
  Phantom
    (mapping_impl_choose2 (of_phantom (mapping_impl :: Phantom a Mapping_impla))
      (of_phantom (mapping_impl :: Phantom b Mapping_impla)));

instance (Mapping_impl a, Mapping_impl b) => Mapping_impl (a, b) where {
  mapping_impl = mapping_impl_prod;
};

cproper_interval_prod ::
  forall a b.
    (Cproper_interval a,
      Cproper_interval b) => Maybe (a, b) -> Maybe (a, b) -> Bool;
cproper_interval_prod Nothing Nothing = True;
cproper_interval_prod Nothing (Just (y1, y2)) =
  cproper_interval Nothing (Just y1) || cproper_interval Nothing (Just y2);
cproper_interval_prod (Just (x1, x2)) Nothing =
  cproper_interval (Just x1) Nothing || cproper_interval (Just x2) Nothing;
cproper_interval_prod (Just (x1, x2)) (Just (y1, y2)) =
  cproper_interval (Just x1) (Just y1) ||
    (lt_of_comp (the ccompare) x1 y1 &&
       (cproper_interval (Just x2) Nothing ||
         cproper_interval Nothing (Just y2)) ||
      not (lt_of_comp (the ccompare) y1 x1) &&
        cproper_interval (Just x2) (Just y2));

instance (Cproper_interval a,
           Cproper_interval b) => Cproper_interval (a, b) where {
  cproper_interval = cproper_interval_prod;
};

comparator_unit :: () -> () -> Ordera;
comparator_unit x y = Eqa;

compare_unit :: () -> () -> Ordera;
compare_unit = comparator_unit;

instance Compare () where {
  compare = compare_unit;
};

data Transition_rule a b c d =
  Transition d d (Formula (Term a (Trans_var b, c)));

equal_transition_rule ::
  forall a b c d.
    (Eq a, Eq b, Eq c,
      Eq d) => Transition_rule a b c d -> Transition_rule a b c d -> Bool;
equal_transition_rule (Transition x1 x2 x3) (Transition y1 y2 y3) =
  x1 == y1 && x2 == y2 && equal_formula x3 y3;

ceq_transition_rule ::
  forall a b c d.
    (Eq a, Eq b, Eq c,
      Eq d) => Maybe (Transition_rule a b c d ->
                       Transition_rule a b c d -> Bool);
ceq_transition_rule = Just equal_transition_rule;

instance (Eq a, Eq b, Eq c, Eq d) => Ceq (Transition_rule a b c d) where {
  ceq = ceq_transition_rule;
};

set_impl_transition_rule ::
  forall a b c d. Phantom (Transition_rule a b c d) Set_impla;
set_impl_transition_rule = Phantom Set_RBT;

instance Set_impl (Transition_rule a b c d) where {
  set_impl = set_impl_transition_rule;
};

comparator_formula ::
  forall a. (a -> a -> Ordera) -> Formula a -> Formula a -> Ordera;
comparator_formula comp_a (Atom x) (Atom y) = comp_a x y;
comparator_formula comp_a (Atom x) (NegAtom ya) = Lt;
comparator_formula comp_a (Atom x) (Conjunction yb) = Lt;
comparator_formula comp_a (Atom x) (Disjunction yc) = Lt;
comparator_formula comp_a (NegAtom x) (Atom y) = Gt;
comparator_formula comp_a (NegAtom x) (NegAtom ya) = comp_a x ya;
comparator_formula comp_a (NegAtom x) (Conjunction yb) = Lt;
comparator_formula comp_a (NegAtom x) (Disjunction yc) = Lt;
comparator_formula comp_a (Conjunction x) (Atom y) = Gt;
comparator_formula comp_a (Conjunction x) (NegAtom ya) = Gt;
comparator_formula comp_a (Conjunction x) (Conjunction yb) =
  comparator_list (comparator_formula comp_a) x yb;
comparator_formula comp_a (Conjunction x) (Disjunction yc) = Lt;
comparator_formula comp_a (Disjunction x) (Atom y) = Gt;
comparator_formula comp_a (Disjunction x) (NegAtom ya) = Gt;
comparator_formula comp_a (Disjunction x) (Conjunction yb) = Gt;
comparator_formula comp_a (Disjunction x) (Disjunction yc) =
  comparator_list (comparator_formula comp_a) x yc;

comparator_transition_rule ::
  forall a b c d.
    (a -> a -> Ordera) ->
      (b -> b -> Ordera) ->
        (c -> c -> Ordera) ->
          (d -> d -> Ordera) ->
            Transition_rule a b c d -> Transition_rule a b c d -> Ordera;
comparator_transition_rule comp_f comp_v comp_t comp_l (Transition x xa xb)
  (Transition y ya yb) =
  (case comp_l x y of {
    Eqa ->
      (case comp_l xa ya of {
        Eqa ->
          comparator_formula
            (comparator_term comp_f
              (comparator_prod (comparator_trans_var comp_v) comp_t))
            xb yb;
        Lt -> Lt;
        Gt -> Gt;
      });
    Lt -> Lt;
    Gt -> Gt;
  });

ccompare_transition_rule ::
  forall a b c d.
    (Ccompare a, Ccompare b, Ccompare c,
      Ccompare d) => Maybe (Transition_rule a b c d ->
                             Transition_rule a b c d -> Ordera);
ccompare_transition_rule =
  (case ccompare of {
    Nothing -> Nothing;
    Just comp_f ->
      (case ccompare of {
        Nothing -> Nothing;
        Just comp_v ->
          (case ccompare of {
            Nothing -> Nothing;
            Just comp_t ->
              (case ccompare of {
                Nothing -> Nothing;
                Just comp_l ->
                  Just (comparator_transition_rule comp_f comp_v comp_t comp_l);
              });
          });
      });
  });

instance (Ccompare a, Ccompare b, Ccompare c,
           Ccompare d) => Ccompare (Transition_rule a b c d) where {
  ccompare = ccompare_transition_rule;
};

instance Quasi_order Integer where {
};

instance Weak_order Integer where {
};

instance Preorder Integer where {
};

instance Order Integer where {
};

instance Linorder Integer where {
};

compare_integer :: Integer -> Integer -> Ordera;
compare_integer = comparator_of;

instance Compare Integer where {
  compare = compare_integer;
};

ceq_integer :: Maybe (Integer -> Integer -> Bool);
ceq_integer = Just (\ a b -> a == b);

instance Ceq Integer where {
  ceq = ceq_integer;
};

set_impl_integer :: Phantom Integer Set_impla;
set_impl_integer = Phantom Set_RBT;

instance Set_impl Integer where {
  set_impl = set_impl_integer;
};

showsl_integer :: Integer -> String -> String;
showsl_integer i = showsl_int (Int_of_integer i);

showsl_list_integer :: [Integer] -> String -> String;
showsl_list_integer xs = default_showsl_list showsl_integer xs;

instance Showl Integer where {
  showsl = showsl_integer;
  showsl_list = showsl_list_integer;
};

finite_UNIV_integer :: Phantom Integer Bool;
finite_UNIV_integer = Phantom False;

card_UNIV_integer :: Phantom Integer Nat;
card_UNIV_integer = Phantom zero_nat;

instance Finite_UNIV Integer where {
  finite_UNIV = finite_UNIV_integer;
};

instance Card_UNIV Integer where {
  card_UNIV = card_UNIV_integer;
};

cEnum_integer ::
  Maybe ([Integer], ((Integer -> Bool) -> Bool, (Integer -> Bool) -> Bool));
cEnum_integer = Nothing;

instance Cenum Integer where {
  cEnum = cEnum_integer;
};

instance Compare_order Integer where {
};

ccompare_integer :: Maybe (Integer -> Integer -> Ordera);
ccompare_integer = Just compare_integer;

instance Ccompare Integer where {
  ccompare = ccompare_integer;
};

data Gctxt a b = GCHole | GCFun a [Gctxt a b];

instance (Eq a) => Eq (Gctxt a b) where {
  a == b = equal_gctxt a b;
};

equal_gctxt :: forall a b. (Eq a) => Gctxt a b -> Gctxt a b -> Bool;
equal_gctxt GCHole (GCFun x21 x22) = False;
equal_gctxt (GCFun x21 x22) GCHole = False;
equal_gctxt (GCFun x21 x22) (GCFun y21 y22) = x21 == y21 && x22 == y22;
equal_gctxt GCHole GCHole = True;

ceq_gctxt :: forall a b. (Eq a) => Maybe (Gctxt a b -> Gctxt a b -> Bool);
ceq_gctxt = Just equal_gctxt;

instance (Eq a) => Ceq (Gctxt a b) where {
  ceq = ceq_gctxt;
};

set_impl_gctxt :: forall a b. Phantom (Gctxt a b) Set_impla;
set_impl_gctxt = Phantom Set_RBT;

instance Set_impl (Gctxt a b) where {
  set_impl = set_impl_gctxt;
};

comparator_gctxt ::
  forall a b. (a -> a -> Ordera) -> Gctxt a b -> Gctxt a b -> Ordera;
comparator_gctxt comp_f GCHole GCHole = Eqa;
comparator_gctxt comp_f GCHole (GCFun y ya) = Lt;
comparator_gctxt comp_f (GCFun x xa) GCHole = Gt;
comparator_gctxt comp_f (GCFun x xa) (GCFun y ya) =
  (case comp_f x y of {
    Eqa -> comparator_list (comparator_gctxt comp_f) xa ya;
    Lt -> Lt;
    Gt -> Gt;
  });

compare_gctxt :: forall a b. (Compare a) => Gctxt a b -> Gctxt a b -> Ordera;
compare_gctxt = comparator_gctxt compare;

ccompare_gctxt ::
  forall a b.
    (Compare a, Compare b) => Maybe (Gctxt a b -> Gctxt a b -> Ordera);
ccompare_gctxt = Just compare_gctxt;

instance (Compare a, Compare b) => Ccompare (Gctxt a b) where {
  ccompare = ccompare_gctxt;
};

data Acterm a b = AVar b | AFun a [Acterm a b] | AAC a (Multiset (Acterm a b));

instance (Eq a, Eq b) => Eq (Acterm a b) where {
  a == b = equal_acterm a b;
};

equal_acterm :: forall a b. (Eq a, Eq b) => Acterm a b -> Acterm a b -> Bool;
equal_acterm (AFun x21 x22) (AAC x31 x32) = False;
equal_acterm (AAC x31 x32) (AFun x21 x22) = False;
equal_acterm (AVar x1) (AAC x31 x32) = False;
equal_acterm (AAC x31 x32) (AVar x1) = False;
equal_acterm (AVar x1) (AFun x21 x22) = False;
equal_acterm (AFun x21 x22) (AVar x1) = False;
equal_acterm (AAC x31 x32) (AAC y31 y32) = x31 == y31 && equal_multiset x32 y32;
equal_acterm (AFun x21 x22) (AFun y21 y22) = x21 == y21 && x22 == y22;
equal_acterm (AVar x1) (AVar y1) = x1 == y1;

data Ta_rule a b = TA_rule b [a] a;

equal_ta_rule :: forall a b. (Eq a, Eq b) => Ta_rule a b -> Ta_rule a b -> Bool;
equal_ta_rule (TA_rule x1 x2 x3) (TA_rule y1 y2 y3) =
  x1 == y1 && x2 == y2 && x3 == y3;

instance (Eq a, Eq b) => Eq (Ta_rule a b) where {
  a == b = equal_ta_rule a b;
};

comparator_ta_rule ::
  forall a b.
    (a -> a -> Ordera) ->
      (b -> b -> Ordera) -> Ta_rule a b -> Ta_rule a b -> Ordera;
comparator_ta_rule comp_q comp_f (TA_rule x xa xb) (TA_rule y ya yb) =
  (case comp_f x y of {
    Eqa -> (case comparator_list comp_q xa ya of {
             Eqa -> comp_q xb yb;
             Lt -> Lt;
             Gt -> Gt;
           });
    Lt -> Lt;
    Gt -> Gt;
  });

compare_ta_rule ::
  forall a b. (Compare a, Compare b) => Ta_rule a b -> Ta_rule a b -> Ordera;
compare_ta_rule = comparator_ta_rule compare compare;

less_eq_ta_rule ::
  forall a b. (Compare a, Compare b) => Ta_rule a b -> Ta_rule a b -> Bool;
less_eq_ta_rule = le_of_comp compare_ta_rule;

less_ta_rule ::
  forall a b. (Compare a, Compare b) => Ta_rule a b -> Ta_rule a b -> Bool;
less_ta_rule = lt_of_comp compare_ta_rule;

instance (Compare a, Compare b) => Ord (Ta_rule a b) where {
  less_eq = less_eq_ta_rule;
  less = less_ta_rule;
};

instance (Compare a, Compare b) => Quasi_order (Ta_rule a b) where {
};

instance (Compare a, Compare b) => Weak_order (Ta_rule a b) where {
};

instance (Compare a, Compare b) => Preorder (Ta_rule a b) where {
};

instance (Compare a, Compare b) => Order (Ta_rule a b) where {
};

ceq_ta_rule ::
  forall a b. (Eq a, Eq b) => Maybe (Ta_rule a b -> Ta_rule a b -> Bool);
ceq_ta_rule = Just equal_ta_rule;

instance (Eq a, Eq b) => Ceq (Ta_rule a b) where {
  ceq = ceq_ta_rule;
};

set_impl_ta_rule :: forall a b. Phantom (Ta_rule a b) Set_impla;
set_impl_ta_rule = Phantom Set_RBT;

instance Set_impl (Ta_rule a b) where {
  set_impl = set_impl_ta_rule;
};

instance (Compare a, Compare b) => Linorder (Ta_rule a b) where {
};

showsl_ta_rule ::
  forall a b. (Showl a, Showl b) => Ta_rule a b -> String -> String;
showsl_ta_rule (TA_rule f qs q) =
  ((showsl f . showsl_list qs) . showsl_lit " -> ") . showsl q;

showsl_list_ta_rule ::
  forall a b. (Showl a, Showl b) => [Ta_rule a b] -> String -> String;
showsl_list_ta_rule xs = default_showsl_list showsl_ta_rule xs;

instance (Showl a, Showl b) => Showl (Ta_rule a b) where {
  showsl = showsl_ta_rule;
  showsl_list = showsl_list_ta_rule;
};

cEnum_ta_rule ::
  forall a b.
    Maybe ([Ta_rule a b],
            ((Ta_rule a b -> Bool) -> Bool, (Ta_rule a b -> Bool) -> Bool));
cEnum_ta_rule = Nothing;

instance Cenum (Ta_rule a b) where {
  cEnum = cEnum_ta_rule;
};

finite_UNIV_ta_rule :: forall a b. Phantom (Ta_rule a b) Bool;
finite_UNIV_ta_rule = Phantom False;

instance Finite_UNIV (Ta_rule a b) where {
  finite_UNIV = finite_UNIV_ta_rule;
};

ccompare_ta_rule ::
  forall a b.
    (Ccompare a, Ccompare b) => Maybe (Ta_rule a b -> Ta_rule a b -> Ordera);
ccompare_ta_rule =
  (case ccompare of {
    Nothing -> Nothing;
    Just comp_q -> (case ccompare of {
                     Nothing -> Nothing;
                     Just comp_f -> Just (comparator_ta_rule comp_q comp_f);
                   });
  });

instance (Ccompare a, Ccompare b) => Ccompare (Ta_rule a b) where {
  ccompare = ccompare_ta_rule;
};

cproper_interval_ta_rule ::
  forall a b.
    (Ccompare a,
      Ccompare b) => Maybe (Ta_rule a b) -> Maybe (Ta_rule a b) -> Bool;
cproper_interval_ta_rule = (\ _ _ -> False);

instance (Ccompare a, Ccompare b) => Cproper_interval (Ta_rule a b) where {
  cproper_interval = cproper_interval_ta_rule;
};

data Mctxt a b = MVar b | MHole | MFun a [Mctxt a b];

instance (Eq a, Eq b) => Eq (Mctxt a b) where {
  a == b = equal_mctxt a b;
};

equal_mctxt :: forall a b. (Eq a, Eq b) => Mctxt a b -> Mctxt a b -> Bool;
equal_mctxt MHole (MFun x31 x32) = False;
equal_mctxt (MFun x31 x32) MHole = False;
equal_mctxt (MVar x1) (MFun x31 x32) = False;
equal_mctxt (MFun x31 x32) (MVar x1) = False;
equal_mctxt (MVar x1) MHole = False;
equal_mctxt MHole (MVar x1) = False;
equal_mctxt (MFun x31 x32) (MFun y31 y32) = x31 == y31 && x32 == y32;
equal_mctxt (MVar x1) (MVar y1) = x1 == y1;
equal_mctxt MHole MHole = True;

ceq_mctxt :: forall a b. (Eq a, Eq b) => Maybe (Mctxt a b -> Mctxt a b -> Bool);
ceq_mctxt = Just equal_mctxt;

instance (Eq a, Eq b) => Ceq (Mctxt a b) where {
  ceq = ceq_mctxt;
};

set_impl_mctxt :: forall a b. Phantom (Mctxt a b) Set_impla;
set_impl_mctxt = Phantom Set_RBT;

instance Set_impl (Mctxt a b) where {
  set_impl = set_impl_mctxt;
};

comparator_mctxt ::
  forall a b.
    (a -> a -> Ordera) ->
      (b -> b -> Ordera) -> Mctxt a b -> Mctxt a b -> Ordera;
comparator_mctxt comp_f comp_v (MVar x) (MVar y) = comp_v x y;
comparator_mctxt comp_f comp_v (MVar x) MHole = Lt;
comparator_mctxt comp_f comp_v (MVar x) (MFun ya yb) = Lt;
comparator_mctxt comp_f comp_v MHole (MVar y) = Gt;
comparator_mctxt comp_f comp_v MHole MHole = Eqa;
comparator_mctxt comp_f comp_v MHole (MFun ya yb) = Lt;
comparator_mctxt comp_f comp_v (MFun x xa) (MVar y) = Gt;
comparator_mctxt comp_f comp_v (MFun x xa) MHole = Gt;
comparator_mctxt comp_f comp_v (MFun x xa) (MFun ya yb) =
  (case comp_f x ya of {
    Eqa -> comparator_list (comparator_mctxt comp_f comp_v) xa yb;
    Lt -> Lt;
    Gt -> Gt;
  });

compare_mctxt ::
  forall a b. (Compare a, Compare b) => Mctxt a b -> Mctxt a b -> Ordera;
compare_mctxt = comparator_mctxt compare compare;

ccompare_mctxt ::
  forall a b.
    (Compare a, Compare b) => Maybe (Mctxt a b -> Mctxt a b -> Ordera);
ccompare_mctxt = Just compare_mctxt;

instance (Compare a, Compare b) => Ccompare (Mctxt a b) where {
  ccompare = ccompare_mctxt;
};

data Arctic = MinInfty | Num_arc Int;

equal_arctic :: Arctic -> Arctic -> Bool;
equal_arctic MinInfty (Num_arc x2) = False;
equal_arctic (Num_arc x2) MinInfty = False;
equal_arctic (Num_arc x2) (Num_arc y2) = equal_int x2 y2;
equal_arctic MinInfty MinInfty = True;

instance Eq Arctic where {
  a == b = equal_arctic a b;
};

one_arctic :: Arctic;
one_arctic = Num_arc zero_int;

instance One Arctic where {
  onea = one_arctic;
};

plus_arctic :: Arctic -> Arctic -> Arctic;
plus_arctic MinInfty y = y;
plus_arctic (Num_arc v) MinInfty = Num_arc v;
plus_arctic (Num_arc x) (Num_arc y) = Num_arc (max x y);

instance Plus Arctic where {
  plus = plus_arctic;
};

zero_arctic :: Arctic;
zero_arctic = MinInfty;

instance Zero Arctic where {
  zerob = zero_arctic;
};

instance Semigroup_add Arctic where {
};

instance Numeral Arctic where {
};

times_arctic :: Arctic -> Arctic -> Arctic;
times_arctic MinInfty y = MinInfty;
times_arctic (Num_arc v) MinInfty = MinInfty;
times_arctic (Num_arc x) (Num_arc y) = Num_arc (plus_int x y);

instance Times Arctic where {
  times = times_arctic;
};

instance Power Arctic where {
};

less_eq_arctic :: Arctic -> Arctic -> Bool;
less_eq_arctic MinInfty x = True;
less_eq_arctic (Num_arc uu) MinInfty = False;
less_eq_arctic (Num_arc y) (Num_arc x) = less_eq_int y x;

less_arctic :: Arctic -> Arctic -> Bool;
less_arctic MinInfty x = True;
less_arctic (Num_arc uu) MinInfty = False;
less_arctic (Num_arc y) (Num_arc x) = less_int y x;

instance Ord Arctic where {
  less_eq = less_eq_arctic;
  less = less_arctic;
};

instance Ab_semigroup_add Arctic where {
};

instance Semigroup_mult Arctic where {
};

instance Semiring Arctic where {
};

instance Mult_zero Arctic where {
};

instance Monoid_add Arctic where {
};

instance Comm_monoid_add Arctic where {
};

instance Semiring_0 Arctic where {
};

instance Monoid_mult Arctic where {
};

instance Semiring_numeral Arctic where {
};

instance Zero_neq_one Arctic where {
};

instance Semiring_1 Arctic where {
};

ceq_arctic :: Maybe (Arctic -> Arctic -> Bool);
ceq_arctic = Just equal_arctic;

instance Ceq Arctic where {
  ceq = ceq_arctic;
};

set_impl_arctic :: Phantom Arctic Set_impla;
set_impl_arctic = Phantom Set_RBT;

instance Set_impl Arctic where {
  set_impl = set_impl_arctic;
};

showsl_arctic :: Arctic -> String -> String;
showsl_arctic MinInfty = showsl_lit "-infinity";
showsl_arctic (Num_arc i) = showsl_int i;

showsl_list_arctic :: [Arctic] -> String -> String;
showsl_list_arctic xs = default_showsl_list showsl_arctic xs;

instance Showl Arctic where {
  showsl = showsl_arctic;
  showsl_list = showsl_list_arctic;
};

cEnum_arctic ::
  Maybe ([Arctic], ((Arctic -> Bool) -> Bool, (Arctic -> Bool) -> Bool));
cEnum_arctic = Nothing;

instance Cenum Arctic where {
  cEnum = cEnum_arctic;
};

comparator_arctic :: Arctic -> Arctic -> Ordera;
comparator_arctic MinInfty MinInfty = Eqa;
comparator_arctic MinInfty (Num_arc y) = Lt;
comparator_arctic (Num_arc x) MinInfty = Gt;
comparator_arctic (Num_arc x) (Num_arc y) = comparator_of x y;

compare_arctic :: Arctic -> Arctic -> Ordera;
compare_arctic = comparator_arctic;

ccompare_arctic :: Maybe (Arctic -> Arctic -> Ordera);
ccompare_arctic = Just compare_arctic;

instance Ccompare Arctic where {
  ccompare = ccompare_arctic;
};

instance Non_strict_order Arctic where {
};

instance Ordered_ab_semigroup Arctic where {
};

instance Ordered_semiring_0a Arctic where {
};

instance Ordered_semiring_1a Arctic where {
};

data Filtered a = FPair a Nat;

equal_filtered :: forall a. (Eq a) => Filtered a -> Filtered a -> Bool;
equal_filtered (FPair x1 x2) (FPair y1 y2) = x1 == y1 && equal_nat x2 y2;

instance (Eq a) => Eq (Filtered a) where {
  a == b = equal_filtered a b;
};

comparator_filtered ::
  forall a. (a -> a -> Ordera) -> Filtered a -> Filtered a -> Ordera;
comparator_filtered comp_f (FPair x xa) (FPair y ya) =
  (case comp_f x y of {
    Eqa -> comparator_of xa ya;
    Lt -> Lt;
    Gt -> Gt;
  });

compare_filtered :: forall a. (Compare a) => Filtered a -> Filtered a -> Ordera;
compare_filtered = comparator_filtered compare;

less_eq_filtered :: forall a. (Compare a) => Filtered a -> Filtered a -> Bool;
less_eq_filtered = le_of_comp compare_filtered;

less_filtered :: forall a. (Compare a) => Filtered a -> Filtered a -> Bool;
less_filtered = lt_of_comp compare_filtered;

instance (Compare a) => Ord (Filtered a) where {
  less_eq = less_eq_filtered;
  less = less_filtered;
};

instance (Compare a) => Compare (Filtered a) where {
  compare = compare_filtered;
};

instance (Compare a) => Quasi_order (Filtered a) where {
};

instance (Compare a) => Weak_order (Filtered a) where {
};

instance (Compare a) => Preorder (Filtered a) where {
};

instance (Compare a) => Order (Filtered a) where {
};

equality_filtered ::
  forall a. (a -> a -> Bool) -> Filtered a -> Filtered a -> Bool;
equality_filtered eq_f (FPair x xa) (FPair y ya) = eq_f x y && equal_nat xa ya;

ceq_filtered :: forall a. (Ceq a) => Maybe (Filtered a -> Filtered a -> Bool);
ceq_filtered = (case ceq of {
                 Nothing -> Nothing;
                 Just eq_f -> Just (equality_filtered eq_f);
               });

instance (Ceq a) => Ceq (Filtered a) where {
  ceq = ceq_filtered;
};

set_impl_filtered :: forall a. (Set_impl a) => Phantom (Filtered a) Set_impla;
set_impl_filtered = Phantom (of_phantom (set_impl :: Phantom a Set_impla));

instance (Set_impl a) => Set_impl (Filtered a) where {
  set_impl = set_impl_filtered;
};

instance (Compare a) => Linorder (Filtered a) where {
};

filtered_fun :: forall a. Filtered a -> a;
filtered_fun (FPair f n) = f;

showsl_filtered :: forall a. (Showl a) => Filtered a -> String -> String;
showsl_filtered f = showsl (filtered_fun f);

showsl_list_filtered :: forall a. (Showl a) => [Filtered a] -> String -> String;
showsl_list_filtered xs = default_showsl_list showsl_filtered xs;

instance (Showl a) => Showl (Filtered a) where {
  showsl = showsl_filtered;
  showsl_list = showsl_list_filtered;
};

instance (Compare a) => Compare_order (Filtered a) where {
};

ccompare_filtered ::
  forall a. (Ccompare a) => Maybe (Filtered a -> Filtered a -> Ordera);
ccompare_filtered = (case ccompare of {
                      Nothing -> Nothing;
                      Just comp_f -> Just (comparator_filtered comp_f);
                    });

instance (Ccompare a) => Ccompare (Filtered a) where {
  ccompare = ccompare_filtered;
};

data L_poly a b = LPoly b [(a, b)];

cEnum_l_poly ::
  forall a b.
    Maybe ([L_poly a b],
            ((L_poly a b -> Bool) -> Bool, (L_poly a b -> Bool) -> Bool));
cEnum_l_poly = Nothing;

instance Cenum (L_poly a b) where {
  cEnum = cEnum_l_poly;
};

data Sharp a = Flat a | Sharpa a;

equal_sharp :: forall a. (Eq a) => Sharp a -> Sharp a -> Bool;
equal_sharp (Flat x1) (Sharpa x2) = False;
equal_sharp (Sharpa x2) (Flat x1) = False;
equal_sharp (Sharpa x2) (Sharpa y2) = x2 == y2;
equal_sharp (Flat x1) (Flat y1) = x1 == y1;

instance (Eq a) => Eq (Sharp a) where {
  a == b = equal_sharp a b;
};

comparator_sharp ::
  forall a. (a -> a -> Ordera) -> Sharp a -> Sharp a -> Ordera;
comparator_sharp comp_l (Flat x) (Flat y) = comp_l x y;
comparator_sharp comp_l (Flat x) (Sharpa ya) = Lt;
comparator_sharp comp_l (Sharpa x) (Flat y) = Gt;
comparator_sharp comp_l (Sharpa x) (Sharpa ya) = comp_l x ya;

compare_sharp :: forall a. (Compare a) => Sharp a -> Sharp a -> Ordera;
compare_sharp = comparator_sharp compare;

less_eq_sharp :: forall a. (Compare a) => Sharp a -> Sharp a -> Bool;
less_eq_sharp = le_of_comp compare_sharp;

less_sharp :: forall a. (Compare a) => Sharp a -> Sharp a -> Bool;
less_sharp = lt_of_comp compare_sharp;

instance (Compare a) => Ord (Sharp a) where {
  less_eq = less_eq_sharp;
  less = less_sharp;
};

instance (Compare a) => Compare (Sharp a) where {
  compare = compare_sharp;
};

instance (Compare a) => Quasi_order (Sharp a) where {
};

instance (Compare a) => Weak_order (Sharp a) where {
};

instance (Compare a) => Preorder (Sharp a) where {
};

instance (Compare a) => Order (Sharp a) where {
};

ceq_sharp :: forall a. (Eq a) => Maybe (Sharp a -> Sharp a -> Bool);
ceq_sharp = Just equal_sharp;

instance (Eq a) => Ceq (Sharp a) where {
  ceq = ceq_sharp;
};

set_impl_sharp :: forall a. Phantom (Sharp a) Set_impla;
set_impl_sharp = Phantom Set_RBT;

instance Set_impl (Sharp a) where {
  set_impl = set_impl_sharp;
};

instance (Compare a) => Linorder (Sharp a) where {
};

showsl_sharp :: forall a. (Showl a) => Sharp a -> String -> String;
showsl_sharp (Flat s) = showsl s;
showsl_sharp (Sharpa s) = showsl_lit "#" . showsl s;

showsl_list_sharp :: forall a. (Showl a) => [Sharp a] -> String -> String;
showsl_list_sharp xs = default_showsl_list showsl_sharp xs;

instance (Showl a) => Showl (Sharp a) where {
  showsl = showsl_sharp;
  showsl_list = showsl_list_sharp;
};

cEnum_sharp ::
  forall a.
    Maybe ([Sharp a], ((Sharp a -> Bool) -> Bool, (Sharp a -> Bool) -> Bool));
cEnum_sharp = Nothing;

instance Cenum (Sharp a) where {
  cEnum = cEnum_sharp;
};

instance (Compare a) => Compare_order (Sharp a) where {
};

ccompare_sharp ::
  forall a. (Ccompare a) => Maybe (Sharp a -> Sharp a -> Ordera);
ccompare_sharp = (case ccompare of {
                   Nothing -> Nothing;
                   Just comp_l -> Just (comparator_sharp comp_l);
                 });

instance (Ccompare a) => Ccompare (Sharp a) where {
  ccompare = ccompare_sharp;
};

mapping_impl_sharp :: forall a. Phantom (Sharp a) Mapping_impla;
mapping_impl_sharp = Phantom Mapping_RBT;

instance Mapping_impl (Sharp a) where {
  mapping_impl = mapping_impl_sharp;
};

data La_solver_type = Simplex_Solver | BB_Solver;

default_la_solver_type :: La_solver_type;
default_la_solver_type = BB_Solver;

instance Default La_solver_type where {
  defaulta = default_la_solver_type;
};

showsl_la_solver_type :: La_solver_type -> String -> String;
showsl_la_solver_type BB_Solver = showsl_lit "Branch-and-Bound";
showsl_la_solver_type Simplex_Solver = showsl_lit "Simplex";

showsl_list_la_solver_type :: [La_solver_type] -> String -> String;
showsl_list_la_solver_type xs = default_showsl_list showsl_la_solver_type xs;

instance Showl La_solver_type where {
  showsl = showsl_la_solver_type;
  showsl_list = showsl_list_la_solver_type;
};

data Actxt a b = Hole | More a [b] (Actxt a b) [b];

equal_actxt :: forall a b. (Eq a, Eq b) => Actxt a b -> Actxt a b -> Bool;
equal_actxt Hole (More x21 x22 x23 x24) = False;
equal_actxt (More x21 x22 x23 x24) Hole = False;
equal_actxt (More x21 x22 x23 x24) (More y21 y22 y23 y24) =
  x21 == y21 && x22 == y22 && equal_actxt x23 y23 && x24 == y24;
equal_actxt Hole Hole = True;

instance (Eq a, Eq b) => Eq (Actxt a b) where {
  a == b = equal_actxt a b;
};

ceq_actxt :: forall a b. (Eq a, Eq b) => Maybe (Actxt a b -> Actxt a b -> Bool);
ceq_actxt = Just equal_actxt;

instance (Eq a, Eq b) => Ceq (Actxt a b) where {
  ceq = ceq_actxt;
};

set_impl_actxt :: forall a b. Phantom (Actxt a b) Set_impla;
set_impl_actxt = Phantom Set_RBT;

instance Set_impl (Actxt a b) where {
  set_impl = set_impl_actxt;
};

comparator_actxt ::
  forall a b.
    (a -> a -> Ordera) ->
      (b -> b -> Ordera) -> Actxt a b -> Actxt a b -> Ordera;
comparator_actxt comp_f comp_a Hole Hole = Eqa;
comparator_actxt comp_f comp_a Hole (More y ya yb yc) = Lt;
comparator_actxt comp_f comp_a (More x xa xb xc) Hole = Gt;
comparator_actxt comp_f comp_a (More x xa xb xc) (More y ya yb yc) =
  (case comp_f x y of {
    Eqa -> (case comparator_list comp_a xa ya of {
             Eqa -> (case comparator_actxt comp_f comp_a xb yb of {
                      Eqa -> comparator_list comp_a xc yc;
                      Lt -> Lt;
                      Gt -> Gt;
                    });
             Lt -> Lt;
             Gt -> Gt;
           });
    Lt -> Lt;
    Gt -> Gt;
  });

compare_actxt ::
  forall a b. (Compare a, Compare b) => Actxt a b -> Actxt a b -> Ordera;
compare_actxt = comparator_actxt compare compare;

ccompare_actxt ::
  forall a b.
    (Compare a, Compare b) => Maybe (Actxt a b -> Actxt a b -> Ordera);
ccompare_actxt = Just compare_actxt;

instance (Compare a, Compare b) => Ccompare (Actxt a b) where {
  ccompare = ccompare_actxt;
};

data Location = H | A | Ba | Ra;

equal_location :: Location -> Location -> Bool;
equal_location Ba Ra = False;
equal_location Ra Ba = False;
equal_location A Ra = False;
equal_location Ra A = False;
equal_location A Ba = False;
equal_location Ba A = False;
equal_location H Ra = False;
equal_location Ra H = False;
equal_location H Ba = False;
equal_location Ba H = False;
equal_location H A = False;
equal_location A H = False;
equal_location Ra Ra = True;
equal_location Ba Ba = True;
equal_location A A = True;
equal_location H H = True;

instance Eq Location where {
  a == b = equal_location a b;
};

ceq_location :: Maybe (Location -> Location -> Bool);
ceq_location = Just equal_location;

instance Ceq Location where {
  ceq = ceq_location;
};

set_impl_location :: Phantom Location Set_impla;
set_impl_location = Phantom Set_RBT;

instance Set_impl Location where {
  set_impl = set_impl_location;
};

comparator_location :: Location -> Location -> Ordera;
comparator_location H H = Eqa;
comparator_location H A = Lt;
comparator_location H Ba = Lt;
comparator_location H Ra = Lt;
comparator_location A H = Gt;
comparator_location A A = Eqa;
comparator_location A Ba = Lt;
comparator_location A Ra = Lt;
comparator_location Ba H = Gt;
comparator_location Ba A = Gt;
comparator_location Ba Ba = Eqa;
comparator_location Ba Ra = Lt;
comparator_location Ra H = Gt;
comparator_location Ra A = Gt;
comparator_location Ra Ba = Gt;
comparator_location Ra Ra = Eqa;

compare_location :: Location -> Location -> Ordera;
compare_location = comparator_location;

ccompare_location :: Maybe (Location -> Location -> Ordera);
ccompare_location = Just compare_location;

instance Ccompare Location where {
  ccompare = ccompare_location;
};

data Scg a b = Null | Scg a a [(b, b)] [(b, b)];

equal_scg :: forall a b. (Eq a, Eq b) => Scg a b -> Scg a b -> Bool;
equal_scg Null (Scg x21 x22 x23 x24) = False;
equal_scg (Scg x21 x22 x23 x24) Null = False;
equal_scg (Scg x21 x22 x23 x24) (Scg y21 y22 y23 y24) =
  x21 == y21 && x22 == y22 && x23 == y23 && x24 == y24;
equal_scg Null Null = True;

instance (Eq a, Eq b) => Eq (Scg a b) where {
  a == b = equal_scg a b;
};

comparator_scg ::
  forall a b.
    (a -> a -> Ordera) -> (b -> b -> Ordera) -> Scg a b -> Scg a b -> Ordera;
comparator_scg comp_p_p comp_a_p Null Null = Eqa;
comparator_scg comp_p_p comp_a_p Null (Scg y ya yb yc) = Lt;
comparator_scg comp_p_p comp_a_p (Scg x xa xb xc) Null = Gt;
comparator_scg comp_p_p comp_a_p (Scg x xa xb xc) (Scg y ya yb yc) =
  (case comp_p_p x y of {
    Eqa ->
      (case comp_p_p xa ya of {
        Eqa ->
          (case comparator_list (comparator_prod comp_a_p comp_a_p) xb yb of {
            Eqa -> comparator_list (comparator_prod comp_a_p comp_a_p) xc yc;
            Lt -> Lt;
            Gt -> Gt;
          });
        Lt -> Lt;
        Gt -> Gt;
      });
    Lt -> Lt;
    Gt -> Gt;
  });

compare_scg ::
  forall a b. (Compare a, Compare b) => Scg a b -> Scg a b -> Ordera;
compare_scg = comparator_scg compare compare;

less_eq_scg :: forall a b. (Compare a, Compare b) => Scg a b -> Scg a b -> Bool;
less_eq_scg = le_of_comp compare_scg;

less_scg :: forall a b. (Compare a, Compare b) => Scg a b -> Scg a b -> Bool;
less_scg = lt_of_comp compare_scg;

instance (Compare a, Compare b) => Ord (Scg a b) where {
  less_eq = less_eq_scg;
  less = less_scg;
};

instance (Compare a, Compare b) => Compare (Scg a b) where {
  compare = compare_scg;
};

instance (Compare a, Compare b) => Quasi_order (Scg a b) where {
};

instance (Compare a, Compare b) => Weak_order (Scg a b) where {
};

instance (Compare a, Compare b) => Preorder (Scg a b) where {
};

instance (Compare a, Compare b) => Order (Scg a b) where {
};

instance (Compare a, Compare b) => Linorder (Scg a b) where {
};

instance (Compare a, Compare b) => Compare_order (Scg a b) where {
};

data Arctic_delta a = MinInfty_delta | Num_arc_delta a;

equal_arctic_delta ::
  forall a. (Eq a) => Arctic_delta a -> Arctic_delta a -> Bool;
equal_arctic_delta MinInfty_delta (Num_arc_delta x2) = False;
equal_arctic_delta (Num_arc_delta x2) MinInfty_delta = False;
equal_arctic_delta (Num_arc_delta x2) (Num_arc_delta y2) = x2 == y2;
equal_arctic_delta MinInfty_delta MinInfty_delta = True;

instance (Eq a) => Eq (Arctic_delta a) where {
  a == b = equal_arctic_delta a b;
};

one_arctic_delta :: forall a. (Linordered_field a) => Arctic_delta a;
one_arctic_delta = Num_arc_delta zerob;

instance (Linordered_field a) => One (Arctic_delta a) where {
  onea = one_arctic_delta;
};

plus_arctic_delta ::
  forall a.
    (Linordered_field a) => Arctic_delta a -> Arctic_delta a -> Arctic_delta a;
plus_arctic_delta MinInfty_delta y = y;
plus_arctic_delta (Num_arc_delta v) MinInfty_delta = Num_arc_delta v;
plus_arctic_delta (Num_arc_delta x) (Num_arc_delta y) = Num_arc_delta (max x y);

instance (Linordered_field a) => Plus (Arctic_delta a) where {
  plus = plus_arctic_delta;
};

zero_arctic_delta :: forall a. (Linordered_field a) => Arctic_delta a;
zero_arctic_delta = MinInfty_delta;

instance (Linordered_field a) => Zero (Arctic_delta a) where {
  zerob = zero_arctic_delta;
};

instance (Linordered_field a) => Semigroup_add (Arctic_delta a) where {
};

instance (Linordered_field a) => Numeral (Arctic_delta a) where {
};

times_arctic_delta ::
  forall a.
    (Linordered_field a) => Arctic_delta a -> Arctic_delta a -> Arctic_delta a;
times_arctic_delta MinInfty_delta y = MinInfty_delta;
times_arctic_delta (Num_arc_delta v) MinInfty_delta = MinInfty_delta;
times_arctic_delta (Num_arc_delta x) (Num_arc_delta y) =
  Num_arc_delta (plus x y);

instance (Linordered_field a) => Times (Arctic_delta a) where {
  times = times_arctic_delta;
};

instance (Linordered_field a) => Power (Arctic_delta a) where {
};

less_eq_arctic_delta ::
  forall a. (Ord a) => Arctic_delta a -> Arctic_delta a -> Bool;
less_eq_arctic_delta MinInfty_delta x = True;
less_eq_arctic_delta (Num_arc_delta uu) MinInfty_delta = False;
less_eq_arctic_delta (Num_arc_delta y) (Num_arc_delta x) = less_eq y x;

less_arctic_delta ::
  forall a. (Ord a) => Arctic_delta a -> Arctic_delta a -> Bool;
less_arctic_delta MinInfty_delta x = True;
less_arctic_delta (Num_arc_delta uu) MinInfty_delta = False;
less_arctic_delta (Num_arc_delta y) (Num_arc_delta x) = less y x;

instance (Ord a) => Ord (Arctic_delta a) where {
  less_eq = less_eq_arctic_delta;
  less = less_arctic_delta;
};

instance (Linordered_field a) => Ab_semigroup_add (Arctic_delta a) where {
};

instance (Linordered_field a) => Semigroup_mult (Arctic_delta a) where {
};

instance (Linordered_field a) => Semiring (Arctic_delta a) where {
};

instance (Linordered_field a) => Mult_zero (Arctic_delta a) where {
};

instance (Linordered_field a) => Monoid_add (Arctic_delta a) where {
};

instance (Linordered_field a) => Comm_monoid_add (Arctic_delta a) where {
};

instance (Linordered_field a) => Semiring_0 (Arctic_delta a) where {
};

instance (Linordered_field a) => Monoid_mult (Arctic_delta a) where {
};

instance (Linordered_field a) => Semiring_numeral (Arctic_delta a) where {
};

instance (Linordered_field a) => Zero_neq_one (Arctic_delta a) where {
};

instance (Linordered_field a) => Semiring_1 (Arctic_delta a) where {
};

ceq_arctic_delta ::
  forall a. (Eq a) => Maybe (Arctic_delta a -> Arctic_delta a -> Bool);
ceq_arctic_delta = Just equal_arctic_delta;

instance (Eq a) => Ceq (Arctic_delta a) where {
  ceq = ceq_arctic_delta;
};

set_impl_arctic_delta :: forall a. Phantom (Arctic_delta a) Set_impla;
set_impl_arctic_delta = Phantom Set_RBT;

instance Set_impl (Arctic_delta a) where {
  set_impl = set_impl_arctic_delta;
};

showsl_arctic_delta ::
  forall a. (Showl a) => Arctic_delta a -> String -> String;
showsl_arctic_delta MinInfty_delta = showsl_lit "-infinity";
showsl_arctic_delta (Num_arc_delta x) = showsl x;

showsl_list_arctic_delta ::
  forall a. (Showl a) => [Arctic_delta a] -> String -> String;
showsl_list_arctic_delta xs = default_showsl_list showsl_arctic_delta xs;

instance (Showl a) => Showl (Arctic_delta a) where {
  showsl = showsl_arctic_delta;
  showsl_list = showsl_list_arctic_delta;
};

cEnum_arctic_delta ::
  forall a.
    Maybe ([Arctic_delta a],
            ((Arctic_delta a -> Bool) -> Bool,
              (Arctic_delta a -> Bool) -> Bool));
cEnum_arctic_delta = Nothing;

instance Cenum (Arctic_delta a) where {
  cEnum = cEnum_arctic_delta;
};

comparator_arctic_delta ::
  forall a. (a -> a -> Ordera) -> Arctic_delta a -> Arctic_delta a -> Ordera;
comparator_arctic_delta comp_a MinInfty_delta MinInfty_delta = Eqa;
comparator_arctic_delta comp_a MinInfty_delta (Num_arc_delta y) = Lt;
comparator_arctic_delta comp_a (Num_arc_delta x) MinInfty_delta = Gt;
comparator_arctic_delta comp_a (Num_arc_delta x) (Num_arc_delta y) = comp_a x y;

compare_arctic_delta ::
  forall a. (Compare a) => Arctic_delta a -> Arctic_delta a -> Ordera;
compare_arctic_delta = comparator_arctic_delta compare;

ccompare_arctic_delta ::
  forall a. (Compare a) => Maybe (Arctic_delta a -> Arctic_delta a -> Ordera);
ccompare_arctic_delta = Just compare_arctic_delta;

instance (Compare a) => Ccompare (Arctic_delta a) where {
  ccompare = ccompare_arctic_delta;
};

instance (Linordered_field a) => Non_strict_order (Arctic_delta a) where {
};

instance (Linordered_field a) => Ordered_ab_semigroup (Arctic_delta a) where {
};

instance (Linordered_field a) => Ordered_semiring_0a (Arctic_delta a) where {
};

instance (Linordered_field a) => Ordered_semiring_1a (Arctic_delta a) where {
};

data Sig = ConstF Nat | SumF | MaxF | MaxExtF Nat [(Int, Nat)];

equal_sig :: Sig -> Sig -> Bool;
equal_sig MaxF (MaxExtF x41 x42) = False;
equal_sig (MaxExtF x41 x42) MaxF = False;
equal_sig SumF (MaxExtF x41 x42) = False;
equal_sig (MaxExtF x41 x42) SumF = False;
equal_sig SumF MaxF = False;
equal_sig MaxF SumF = False;
equal_sig (ConstF x1) (MaxExtF x41 x42) = False;
equal_sig (MaxExtF x41 x42) (ConstF x1) = False;
equal_sig (ConstF x1) MaxF = False;
equal_sig MaxF (ConstF x1) = False;
equal_sig (ConstF x1) SumF = False;
equal_sig SumF (ConstF x1) = False;
equal_sig (MaxExtF x41 x42) (MaxExtF y41 y42) = equal_nat x41 y41 && x42 == y42;
equal_sig (ConstF x1) (ConstF y1) = equal_nat x1 y1;
equal_sig MaxF MaxF = True;
equal_sig SumF SumF = True;

instance Eq Sig where {
  a == b = equal_sig a b;
};

showsl_sig :: Sig -> String -> String;
showsl_sig (ConstF n) = showsl_nat n;
showsl_sig MaxF = showsl_lit "max";
showsl_sig SumF = showsl_lit "sum";
showsl_sig (MaxExtF c0 cds) = showsl_lit "maxext";

showsl_list_sig :: [Sig] -> String -> String;
showsl_list_sig xs = default_showsl_list showsl_sig xs;

instance Showl Sig where {
  showsl = showsl_sig;
  showsl_list = showsl_list_sig;
};

data Ty = BoolT | IntT;

equal_ty :: Ty -> Ty -> Bool;
equal_ty BoolT IntT = False;
equal_ty IntT BoolT = False;
equal_ty IntT IntT = True;
equal_ty BoolT BoolT = True;

instance Eq Ty where {
  a == b = equal_ty a b;
};

ceq_ty :: Maybe (Ty -> Ty -> Bool);
ceq_ty = Just equal_ty;

instance Ceq Ty where {
  ceq = ceq_ty;
};

showsl_ty :: Ty -> String -> String;
showsl_ty BoolT = showsl_lit "Bool";
showsl_ty IntT = showsl_lit "Int";

showsl_list_ty :: [Ty] -> String -> String;
showsl_list_ty xs = default_showsl_list showsl_ty xs;

instance Showl Ty where {
  showsl = showsl_ty;
  showsl_list = showsl_list_ty;
};

comparator_ty :: Ty -> Ty -> Ordera;
comparator_ty BoolT BoolT = Eqa;
comparator_ty BoolT IntT = Lt;
comparator_ty IntT BoolT = Gt;
comparator_ty IntT IntT = Eqa;

ccompare_ty :: Maybe (Ty -> Ty -> Ordera);
ccompare_ty = Just comparator_ty;

instance Ccompare Ty where {
  ccompare = ccompare_ty;
};

rel_option :: forall a b. (a -> b -> Bool) -> Maybe a -> Maybe b -> Bool;
rel_option r Nothing (Just y2) = False;
rel_option r (Just y2) Nothing = False;
rel_option r Nothing Nothing = True;
rel_option r (Just x2) (Just y2) = r x2 y2;

newtype Fmap a b = Fmap_of_list [(a, b)];

fmlookup :: forall a b. (Eq a) => Fmap a b -> a -> Maybe b;
fmlookup (Fmap_of_list m) = map_of m;

newtype Fset a = Abs_fset (Set a);

fset_of_list :: forall a. (Ceq a, Ccompare a, Set_impl a) => [a] -> Fset a;
fset_of_list xa = Abs_fset (set xa);

fset :: forall a. Fset a -> Set a;
fset (Abs_fset x) = x;

foldb ::
  forall a b. (Ccompare a) => (a -> b -> b) -> Mapping_rbt a () -> b -> b;
foldb x xc = folda (\ a _ -> x a) (impl_ofb xc);

image ::
  forall a b.
    (Ceq a, Ccompare a, Ceq b, Ccompare b,
      Set_impl b) => (a -> b) -> Set a -> Set b;
image h (RBT_set rbt) =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "image RBT_set: ccompare = None" (\ _ -> image h (RBT_set rbt));
    Just _ -> foldb (inserta . h) rbt bot_set;
  });
image g (DList_set dxs) =
  (case (ceq :: Maybe (a -> a -> Bool)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "image DList_set: ceq = None" (\ _ -> image g (DList_set dxs));
    Just _ -> foldc (inserta . g) dxs bot_set;
  });
image f (Complement (Complement b)) = image f b;
image f (Collect_set a) =
  (error :: forall a. String -> (() -> a) -> a) "image Collect_set"
    (\ _ -> image f (Collect_set a));
image f (Set_Monad xs) = Set_Monad (map f xs);

fimage ::
  forall b a.
    (Ceq b, Ccompare b, Ceq a, Ccompare a,
      Set_impl a) => (b -> a) -> Fset b -> Fset a;
fimage xb xc = Abs_fset (image xb (fset xc));

fmdom ::
  forall a b.
    (Ceq a, Ccompare a, Set_impl a, Ceq b, Ccompare b,
      Set_impl b) => Fmap a b -> Fset a;
fmdom (Fmap_of_list m) = fimage fst (fset_of_list m);

rBT_Impl_rbt_all :: forall a b. (a -> b -> Bool) -> Rbta a b -> Bool;
rBT_Impl_rbt_all p Empty = True;
rBT_Impl_rbt_all p (Branch c l k v r) =
  p k v && rBT_Impl_rbt_all p l && rBT_Impl_rbt_all p r;

alla :: forall a b. (Ccompare a) => (a -> b -> Bool) -> Mapping_rbt a b -> Bool;
alla xb xc = rBT_Impl_rbt_all xb (impl_ofb xc);

ball :: forall a. (Ceq a, Ccompare a) => Set a -> (a -> Bool) -> Bool;
ball (RBT_set rbt) p =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "Ball RBT_set: ccompare = None" (\ _ -> ball (RBT_set rbt) p);
    Just _ -> alla (\ k _ -> p k) rbt;
  });
ball (DList_set dxs) p =
  (case (ceq :: Maybe (a -> a -> Bool)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a) "Ball DList_set: ceq = None"
        (\ _ -> ball (DList_set dxs) p);
    Just _ -> dlist_all p dxs;
  });
ball (Set_Monad xs) p = all p xs;

fmrel ::
  forall a b c.
    (Ceq a, Ccompare a, Set_impl a, Ceq b, Ccompare b, Set_impl b, Ceq c,
      Ccompare c, Eq c,
      Set_impl c) => (a -> b -> Bool) -> Fmap c a -> Fmap c b -> Bool;
fmrel r m n =
  ball (fset (fmdom m)) (\ x -> rel_option r (fmlookup m x) (fmlookup n x)) &&
    ball (fset (fmdom n)) (\ x -> rel_option r (fmlookup m x) (fmlookup n x));

equal_fmap ::
  forall a b.
    (Ceq a, Ccompare a, Eq a, Set_impl a, Ceq b, Ccompare b, Eq b,
      Set_impl b) => Fmap a b -> Fmap a b -> Bool;
equal_fmap = fmrel (\ a b -> a == b);

newtype Linear_poly = LinearPoly (Fmap Nat Rat);

linear_poly_map :: Linear_poly -> Fmap Nat Rat;
linear_poly_map (LinearPoly x) = x;

equal_linear_poly :: Linear_poly -> Linear_poly -> Bool;
equal_linear_poly x y = equal_fmap (linear_poly_map x) (linear_poly_map y);

instance Eq Linear_poly where {
  a == b = equal_linear_poly a b;
};

data Siga = LessF | LeF | SumFa Nat | ConstFa Int | ProdF Nat | EqF;

equal_sigb :: Siga -> Siga -> Bool;
equal_sigb (ProdF x5) EqF = False;
equal_sigb EqF (ProdF x5) = False;
equal_sigb (ConstFa x4) EqF = False;
equal_sigb EqF (ConstFa x4) = False;
equal_sigb (ConstFa x4) (ProdF x5) = False;
equal_sigb (ProdF x5) (ConstFa x4) = False;
equal_sigb (SumFa x3) EqF = False;
equal_sigb EqF (SumFa x3) = False;
equal_sigb (SumFa x3) (ProdF x5) = False;
equal_sigb (ProdF x5) (SumFa x3) = False;
equal_sigb (SumFa x3) (ConstFa x4) = False;
equal_sigb (ConstFa x4) (SumFa x3) = False;
equal_sigb LeF EqF = False;
equal_sigb EqF LeF = False;
equal_sigb LeF (ProdF x5) = False;
equal_sigb (ProdF x5) LeF = False;
equal_sigb LeF (ConstFa x4) = False;
equal_sigb (ConstFa x4) LeF = False;
equal_sigb LeF (SumFa x3) = False;
equal_sigb (SumFa x3) LeF = False;
equal_sigb LessF EqF = False;
equal_sigb EqF LessF = False;
equal_sigb LessF (ProdF x5) = False;
equal_sigb (ProdF x5) LessF = False;
equal_sigb LessF (ConstFa x4) = False;
equal_sigb (ConstFa x4) LessF = False;
equal_sigb LessF (SumFa x3) = False;
equal_sigb (SumFa x3) LessF = False;
equal_sigb LessF LeF = False;
equal_sigb LeF LessF = False;
equal_sigb (ProdF x5) (ProdF y5) = equal_nat x5 y5;
equal_sigb (ConstFa x4) (ConstFa y4) = equal_int x4 y4;
equal_sigb (SumFa x3) (SumFa y3) = equal_nat x3 y3;
equal_sigb EqF EqF = True;
equal_sigb LeF LeF = True;
equal_sigb LessF LessF = True;

instance Eq Siga where {
  a == b = equal_sigb a b;
};

showsl_sigb :: Siga -> String -> String;
showsl_sigb LessF = showsl_lit "<";
showsl_sigb LeF = showsl_lit "<=";
showsl_sigb EqF = showsl_lit "=";
showsl_sigb (SumFa n) = showsl_lit "+";
showsl_sigb (ProdF n) = showsl_lit "*";
showsl_sigb (ConstFa n) = showsl_int n;

showsl_list_sigb :: [Siga] -> String -> String;
showsl_list_sigb xs = default_showsl_list showsl_sigb xs;

instance Showl Siga where {
  showsl = showsl_sigb;
  showsl_list = showsl_list_sigb;
};

comparator_sig :: Siga -> Siga -> Ordera;
comparator_sig LessF LessF = Eqa;
comparator_sig LessF LeF = Lt;
comparator_sig LessF (SumFa y) = Lt;
comparator_sig LessF (ConstFa ya) = Lt;
comparator_sig LessF (ProdF yb) = Lt;
comparator_sig LessF EqF = Lt;
comparator_sig LeF LessF = Gt;
comparator_sig LeF LeF = Eqa;
comparator_sig LeF (SumFa y) = Lt;
comparator_sig LeF (ConstFa ya) = Lt;
comparator_sig LeF (ProdF yb) = Lt;
comparator_sig LeF EqF = Lt;
comparator_sig (SumFa x) LessF = Gt;
comparator_sig (SumFa x) LeF = Gt;
comparator_sig (SumFa x) (SumFa y) = comparator_of x y;
comparator_sig (SumFa x) (ConstFa ya) = Lt;
comparator_sig (SumFa x) (ProdF yb) = Lt;
comparator_sig (SumFa x) EqF = Lt;
comparator_sig (ConstFa x) LessF = Gt;
comparator_sig (ConstFa x) LeF = Gt;
comparator_sig (ConstFa x) (SumFa y) = Gt;
comparator_sig (ConstFa x) (ConstFa ya) = comparator_of x ya;
comparator_sig (ConstFa x) (ProdF yb) = Lt;
comparator_sig (ConstFa x) EqF = Lt;
comparator_sig (ProdF x) LessF = Gt;
comparator_sig (ProdF x) LeF = Gt;
comparator_sig (ProdF x) (SumFa y) = Gt;
comparator_sig (ProdF x) (ConstFa ya) = Gt;
comparator_sig (ProdF x) (ProdF yb) = comparator_of x yb;
comparator_sig (ProdF x) EqF = Lt;
comparator_sig EqF LessF = Gt;
comparator_sig EqF LeF = Gt;
comparator_sig EqF (SumFa y) = Gt;
comparator_sig EqF (ConstFa ya) = Gt;
comparator_sig EqF (ProdF yb) = Gt;
comparator_sig EqF EqF = Eqa;

ccompare_sig :: Maybe (Siga -> Siga -> Ordera);
ccompare_sig = Just comparator_sig;

instance Ccompare Siga where {
  ccompare = ccompare_sig;
};

data Sigb = ConstFb Nat | SumFb | ProdFa | MaxFa;

equal_siga :: Sigb -> Sigb -> Bool;
equal_siga ProdFa MaxFa = False;
equal_siga MaxFa ProdFa = False;
equal_siga SumFb MaxFa = False;
equal_siga MaxFa SumFb = False;
equal_siga SumFb ProdFa = False;
equal_siga ProdFa SumFb = False;
equal_siga (ConstFb x1) MaxFa = False;
equal_siga MaxFa (ConstFb x1) = False;
equal_siga (ConstFb x1) ProdFa = False;
equal_siga ProdFa (ConstFb x1) = False;
equal_siga (ConstFb x1) SumFb = False;
equal_siga SumFb (ConstFb x1) = False;
equal_siga (ConstFb x1) (ConstFb y1) = equal_nat x1 y1;
equal_siga MaxFa MaxFa = True;
equal_siga ProdFa ProdFa = True;
equal_siga SumFb SumFb = True;

instance Eq Sigb where {
  a == b = equal_siga a b;
};

showsl_siga :: Sigb -> String -> String;
showsl_siga (ConstFb n) = showsl_nat n;
showsl_siga MaxFa = showsl_lit "max";
showsl_siga ProdFa = showsl_lit "prod";
showsl_siga SumFb = showsl_lit "sum";

showsl_list_siga :: [Sigb] -> String -> String;
showsl_list_siga xs = default_showsl_list showsl_siga xs;

instance Showl Sigb where {
  showsl = showsl_siga;
  showsl_list = showsl_list_siga;
};

data Cond_constraint a b = CC_cond Bool (Term a b, Term a b)
  | CC_rewr (Term a b) (Term a b)
  | CC_impl [Cond_constraint a b] (Cond_constraint a b)
  | CC_all b (Cond_constraint a b);

instance (Eq a, Eq b) => Eq (Cond_constraint a b) where {
  a == b = equal_cond_constraint a b;
};

equal_cond_constraint ::
  forall a b.
    (Eq a, Eq b) => Cond_constraint a b -> Cond_constraint a b -> Bool;
equal_cond_constraint (CC_impl x31 x32) (CC_all x41 x42) = False;
equal_cond_constraint (CC_all x41 x42) (CC_impl x31 x32) = False;
equal_cond_constraint (CC_rewr x21 x22) (CC_all x41 x42) = False;
equal_cond_constraint (CC_all x41 x42) (CC_rewr x21 x22) = False;
equal_cond_constraint (CC_rewr x21 x22) (CC_impl x31 x32) = False;
equal_cond_constraint (CC_impl x31 x32) (CC_rewr x21 x22) = False;
equal_cond_constraint (CC_cond x11 x12) (CC_all x41 x42) = False;
equal_cond_constraint (CC_all x41 x42) (CC_cond x11 x12) = False;
equal_cond_constraint (CC_cond x11 x12) (CC_impl x31 x32) = False;
equal_cond_constraint (CC_impl x31 x32) (CC_cond x11 x12) = False;
equal_cond_constraint (CC_cond x11 x12) (CC_rewr x21 x22) = False;
equal_cond_constraint (CC_rewr x21 x22) (CC_cond x11 x12) = False;
equal_cond_constraint (CC_all x41 x42) (CC_all y41 y42) =
  x41 == y41 && equal_cond_constraint x42 y42;
equal_cond_constraint (CC_impl x31 x32) (CC_impl y31 y32) =
  x31 == y31 && equal_cond_constraint x32 y32;
equal_cond_constraint (CC_rewr x21 x22) (CC_rewr y21 y22) =
  equal_term x21 y21 && equal_term x22 y22;
equal_cond_constraint (CC_cond x11 x12) (CC_cond y11 y12) =
  x11 == y11 && x12 == y12;

data Itself a = Type;

newtype Rbt b a = RBT (Rbta b a);

data Xml = XML [Char] [([Char], [Char])] [Xml] | XML_text [Char];

newtype Vec_impl a = Abs_vec_impl (Nat, IArray.IArray a);

newtype Vec a = Vec_impl (Vec_impl a);

data Xmldoc = XMLDOC [[Char]] Xml;

data Lts_impl a b c d e =
  Lts_Impl [d] [(e, Transition_rule a b c d)] [(d, Formula (Term a (b, c)))];

data Le_rel = Leq_Rel | Lt_Rel;

data Mapping a b = Assoc_List_Mapping (Alist a b)
  | RBT_Mapping (Mapping_rbt a b) | Mapping (a -> Maybe b);

data State a b =
  State [(Nat, Linear_poly)] (Mapping Nat (a, b)) (Mapping Nat (a, b))
    (Mapping Nat b) Bool (Maybe [a]);

newtype Status a = Abs_status ((a, Nat) -> [Nat]);

data Order_tag = Lex | Mul;

data Istate a =
  IState Nat [(Nat, Linear_poly)] [(a, Atom QDelta)] (Linear_poly -> Maybe Nat)
    [a];

data Xml_error a = TagMismatch [String] | Fatal a;

data Lts_ext a b c d e =
  Lts_ext (Set d) (Set (Transition_rule a b c d)) (d -> Formula (Term a (b, c)))
    e;

data Enat = Enat Nat | Infinity_enat;

data Tpoly a b = PVar a | PNum b | PSum [Tpoly a b] | PMult [Tpoly a b];

data Direction a b =
  Direction (b -> b -> Bool) (State a b -> Mapping Nat (a, b))
    (State a b -> Mapping Nat (a, b)) (State a b -> Nat -> Maybe b)
    (State a b -> Nat -> Maybe b) (State a b -> Nat -> a)
    (State a b -> Nat -> a)
    ((Mapping Nat (a, b) -> Mapping Nat (a, b)) -> State a b -> State a b)
    (Nat -> b -> Atom b) (Nat -> b -> Atom b) (Rat -> Rat -> Bool);

data Crit_pair_info a b =
  Crit_Pair_Info (Term a b) (Maybe (Term a b)) (Term a b) [Term a b]
    (Maybe [[Nat]]) (Maybe (Nat, Nat));

data Cp_join_hints a b = CP_Auto Nat | CP_Sequences [Crit_pair_info a b];

data Pcp_rule_lab_com a b =
  PCP_Sequences_Com ((Term a b, Term a b) -> Nat)
    (Maybe ((Term a b, Term a b) -> Nat)) (Cp_join_hints a b)
    (Cp_join_hints a b);

data Pcp_rule_lab a b =
  PCP_Sequences ((Term a b, Term a b) -> Nat) (Cp_join_hints a b);

data Const_string_sound_proof a b =
  Const_string_sound_proof b [(a, a)] [(Term a b, Term a b)];

data List_order_type = MS_Ext | Max_Ext | Min_Ext | Dms_Ext;

data Core_matrix_mode = E_I | M_I;

data Core_matrix_inter a b =
  Core_Matrix_Inter Core_matrix_mode Nat [Nat] [((a, Nat), ([Mat b], Mat b))];

data Af_entry = Collapse Nat | AFList [Nat];

data Redtriple_impl a = Int_carrier [((a, Nat), (Int, [Int]))]
  | Int_nl_carrier [((a, Nat), [(Monom Nat, Int)])]
  | Neg_Integer_Poly [((a, Nat), [(Monom Nat, Int)])]
  | Rat_carrier [((a, Nat), (Rat, [Rat]))]
  | Rat_nl_carrier Rat [((a, Nat), [(Monom Nat, Rat)])]
  | Real_carrier [((a, Nat), (Real, [Real]))]
  | Real_nl_carrier Real [((a, Nat), [(Monom Nat, Real)])]
  | Arctic_carrier [((a, Nat), (Arctic, [Arctic]))]
  | Arctic_rat_carrier [((a, Nat), (Arctic_delta Rat, [Arctic_delta Rat]))]
  | Int_mat_carrier Nat Nat [((a, Nat), (Mat Int, [Mat Int]))]
  | Rat_mat_carrier Nat Nat [((a, Nat), (Mat Rat, [Mat Rat]))]
  | Real_mat_carrier Nat Nat [((a, Nat), (Mat Real, [Mat Real]))]
  | Core_matrix (Core_matrix_inter a Int)
  | Core_matrix_delta Real (Core_matrix_inter a Real)
  | Arctic_mat_carrier Nat [((a, Nat), (Mat Arctic, [Mat Arctic]))]
  | Arctic_rat_mat_carrier Nat
      [((a, Nat), (Mat (Arctic_delta Rat), [Mat (Arctic_delta Rat)]))]
  | RPO [((a, Nat), (Nat, Order_tag))] [((a, Nat), Af_entry)]
  | KBO ([((a, Nat), (Nat, (Nat, Maybe [Nat])))], Nat) [((a, Nat), Af_entry)]
  | ACKBO ([((a, Nat), (Nat, (Nat, Bool)))], Nat) [((a, Nat), Af_entry)]
  | WPO [((a, Nat), (Nat, ([Nat], Order_tag)))] (Redtriple_impl a)
  | GWPO ([((a, Nat), Nat)], a -> a) (Redtriple_impl a)
  | MSPO (Redtriple_impl a)
  | COWPO [((a, Nat), (Nat, ([Nat], Order_tag)))] (Redtriple_impl a)
  | Max_poly [((a, Nat), Term Sigb Nat)] | Max_monus [((a, Nat), Term Sig Nat)]
  | Filtered_Redtriple [((a, Nat), Af_entry)] (Redtriple_impl a)
  | SCNP List_order_type [((a, Nat), [(Nat, Nat)])] (Redtriple_impl a);

data Complexity_measure a b = Derivational_Complexity [(a, Nat)]
  | Runtime_Complexity [(a, Nat)] [(a, Nat)];

newtype Complexity_class = Comp_Poly Nat;

data Generic_assm_proof a b c d e f g h =
  SN_assm_proof
    (Bool,
      ([Term (Lab a b) c],
        ([(Term (Lab a b) c, Term (Lab a b) c)],
          [(Term (Lab a b) c, Term (Lab a b) c)])))
    d
  | Finite_assm_proof
      (Bool,
        (Bool,
          ([(Term (Lab a b) c, Term (Lab a b) c)],
            ([(Term (Lab a b) c, Term (Lab a b) c)],
              ([Term (Lab a b) c],
                ([(Term (Lab a b) c, Term (Lab a b) c)],
                  [(Term (Lab a b) c, Term (Lab a b) c)]))))))
      e
  | SN_FP_assm_proof
      ([(Actxt (Lab a b) (Term (Lab a b) c), (Term (Lab a b) c, Location))],
        [(Term (Lab a b) c, Term (Lab a b) c)])
      f
  | Not_SN_assm_proof
      (Bool, ([Term (Lab a b) c], [(Term (Lab a b) c, Term (Lab a b) c)])) d
  | Infinite_assm_proof
      (Bool,
        (Bool,
          ([(Term (Lab a b) c, Term (Lab a b) c)],
            ([(Term (Lab a b) c, Term (Lab a b) c)],
              ([Term (Lab a b) c],
                ([(Term (Lab a b) c, Term (Lab a b) c)],
                  [(Term (Lab a b) c, Term (Lab a b) c)]))))))
      e
  | Not_RelSN_assm_proof
      (Bool,
        ([Term (Lab a b) c],
          ([(Term (Lab a b) c, Term (Lab a b) c)],
            [(Term (Lab a b) c, Term (Lab a b) c)])))
      f
  | Not_SN_FP_assm_proof
      ([(Actxt (Lab a b) (Term (Lab a b) c), (Term (Lab a b) c, Location))],
        [(Term (Lab a b) c, Term (Lab a b) c)])
      g
  | Complexity_assm_proof
      ([Term (Lab a b) c],
        ([(Term (Lab a b) c, Term (Lab a b) c)],
          ([(Term (Lab a b) c, Term (Lab a b) c)],
            (Complexity_measure (Lab a b) c, Complexity_class))))
      d
  | Unknown_assm_proof [Char] h;

data Complex_constant_removal_prf a b =
  Complex_Constant_Removal_Proof (Term a b)
    [((Term a b, Term a b), (Term a b, Term a b))];

data Cond_constraint_prf a b = Final
  | Delete_Condition (Cond_constraint a b) (Cond_constraint_prf a b)
  | Different_Constructor (Cond_constraint a b)
  | Same_Constructor (Cond_constraint a b) (Cond_constraint a b)
      (Cond_constraint_prf a b)
  | Variable_Equation b (Term a b) (Cond_constraint a b)
      (Cond_constraint_prf a b)
  | Funarg_Into_Var (Cond_constraint a b) Nat b (Cond_constraint a b)
      (Cond_constraint_prf a b)
  | Simplify_Condition (Cond_constraint a b) [(b, Term a b)]
      (Cond_constraint a b) (Cond_constraint_prf a b)
  | Induction (Cond_constraint a b) [Cond_constraint a b]
      [((Term a b, Term a b),
         ([(Term a b, [b])], (Cond_constraint a b, Cond_constraint_prf a b)))];

data Cond_red_pair_prf a b =
  Cond_Red_Pair_Prf a
    [(Cond_constraint a b, ([(Term a b, Term a b)], Cond_constraint_prf a b))]
    Nat Nat;

data ArithFun = Arg Nat | Const Nat | Sum [ArithFun] | Max [ArithFun]
  | Min [ArithFun] | Prod [ArithFun]
  | IfEqual ArithFun ArithFun ArithFun ArithFun;

data Sl_inter a = SL_Inter Nat [((a, Nat), ArithFun)];

data Sl_variant a b = Rootlab (Maybe (a, Nat)) | Finitelab (Sl_inter a)
  | QuasiFinitelab (Sl_inter a) b;

data Join_info a b = Guided_BFS (Cp_join_hints a b) | Join_NF;

newtype ProjL a = Projection [((a, Nat), Nat)];

data Tree_automaton a b = Tree_Automaton [a] [Ta_rule a b] [(a, a)];

data Ta_relation a = Decision_Proc_Old | Decision_Proc | Id_Relation
  | Some_Relation [(a, a)];

data Boundstype = Roof | Match;

data Bounds_info a b =
  Bounds_Info Boundstype Nat [b] (Tree_automaton b (a, Nat)) (Ta_relation b);

data Trs_termination_proof a b c =
  DP_Trans Bool Bool [(Term (Lab a b) c, Term (Lab a b) c)]
    (Dp_termination_proof a b c)
  | Rule_Removal (Redtriple_impl (Lab a b))
      [(Term (Lab a b) c, Term (Lab a b) c)] (Trs_termination_proof a b c)
  | String_Reversal (Trs_termination_proof a b c)
  | Constant_String (Const_string_sound_proof (Lab a b) c)
      (Trs_termination_proof a b c)
  | Bounds (Bounds_info (Lab a b) c)
  | Uncurry
      (Lab a b,
        ([((Lab a b, Nat), [Lab a b])],
          ([(Term (Lab a b) c, Term (Lab a b) c)],
            [(Term (Lab a b) c, Term (Lab a b) c)])))
      [(Term (Lab a b) c, Term (Lab a b) c)] (Trs_termination_proof a b c)
  | Semlab (Sl_variant (Lab a b) c) [Term (Lab a b) c]
      [(Term (Lab a b) c, Term (Lab a b) c)] (Trs_termination_proof a b c)
  | R_is_Empty
  | Fcc [Actxt (Lab a b) (Term (Lab a b) c)]
      [(Term (Lab a b) c, Term (Lab a b) c)] (Trs_termination_proof a b c)
  | Split [(Term (Lab a b) c, Term (Lab a b) c)] (Trs_termination_proof a b c)
      (Trs_termination_proof a b c)
  | Switch_Innermost (Join_info (Lab a b) c) (Trs_termination_proof a b c)
  | Drop_Equality (Trs_termination_proof a b c)
  | Remove_Nonapplicable_Rules [(Term (Lab a b) c, Term (Lab a b) c)]
      (Trs_termination_proof a b c)
  | Permuting_AFS [((Lab a b, Nat), Af_entry)] (Trs_termination_proof a b c)
  | Right_Ground_Termination
  | Assume_SN
      (Bool,
        ([Term (Lab a b) c],
          ([(Term (Lab a b) c, Term (Lab a b) c)],
            [(Term (Lab a b) c, Term (Lab a b) c)])))
      [Generic_assm_proof a b c (Trs_termination_proof a b c)
         (Dp_termination_proof a b c) (Fptrs_termination_proof a b c) ()
         (Unknown_proof a b c)];

data Fptrs_termination_proof a b c =
  Assume_FP_SN
    ([(Actxt (Lab a b) (Term (Lab a b) c), (Term (Lab a b) c, Location))],
      [(Term (Lab a b) c, Term (Lab a b) c)])
    [Generic_assm_proof a b c (Trs_termination_proof a b c)
       (Dp_termination_proof a b c) (Fptrs_termination_proof a b c) ()
       (Unknown_proof a b c)];

data Dp_termination_proof a b c = P_is_Empty
  | Subterm_Criterion_Proc (ProjL (Lab a b))
      [((Term (Lab a b) c, Term (Lab a b) c),
         [([Nat], ((Term (Lab a b) c, Term (Lab a b) c), Term (Lab a b) c))])]
      [(Term (Lab a b) c, Term (Lab a b) c)] (Dp_termination_proof a b c)
  | Gen_Subterm_Criterion_Proc [((Lab a b, Nat), [Nat])]
      [(Term (Lab a b) c, Term (Lab a b) c)] (Dp_termination_proof a b c)
  | Redpair_Proc (Redtriple_impl (Lab a b))
      [(Term (Lab a b) c, Term (Lab a b) c)] (Dp_termination_proof a b c)
  | Redpair_UR_Proc (Redtriple_impl (Lab a b))
      [(Term (Lab a b) c, Term (Lab a b) c)]
      [(Term (Lab a b) c, Term (Lab a b) c)] (Dp_termination_proof a b c)
  | Usable_Rules_Proc [(Term (Lab a b) c, Term (Lab a b) c)]
      (Dp_termination_proof a b c)
  | Dep_Graph_Proc
      [(Maybe (Dp_termination_proof a b c),
         [(Term (Lab a b) c, Term (Lab a b) c)])]
  | Mono_Redpair_Proc (Redtriple_impl (Lab a b))
      [(Term (Lab a b) c, Term (Lab a b) c)]
      [(Term (Lab a b) c, Term (Lab a b) c)] (Dp_termination_proof a b c)
  | Mono_URM_Redpair_Proc (Redtriple_impl (Lab a b))
      [(Term (Lab a b) c, Term (Lab a b) c)]
      [(Term (Lab a b) c, Term (Lab a b) c)] (Dp_termination_proof a b c)
  | Mono_Redpair_UR_Proc (Redtriple_impl (Lab a b))
      [(Term (Lab a b) c, Term (Lab a b) c)]
      [(Term (Lab a b) c, Term (Lab a b) c)]
      [(Term (Lab a b) c, Term (Lab a b) c)] (Dp_termination_proof a b c)
  | Size_Change_Subterm_Proc
      [((Term (Lab a b) c, Term (Lab a b) c), ([(Nat, Nat)], [(Nat, Nat)]))]
  | Size_Change_Redpair_Proc (Redtriple_impl (Lab a b))
      (Maybe [(Term (Lab a b) c, Term (Lab a b) c)])
      [((Term (Lab a b) c, Term (Lab a b) c), ([(Nat, Nat)], [(Nat, Nat)]))]
  | Uncurry_Proc (Maybe Nat)
      (Lab a b,
        ([((Lab a b, Nat), [Lab a b])],
          ([(Term (Lab a b) c, Term (Lab a b) c)],
            [(Term (Lab a b) c, Term (Lab a b) c)])))
      [(Term (Lab a b) c, Term (Lab a b) c)]
      [(Term (Lab a b) c, Term (Lab a b) c)] (Dp_termination_proof a b c)
  | Fcc_Proc (Lab a b) [Actxt (Lab a b) (Term (Lab a b) c)]
      [(Term (Lab a b) c, Term (Lab a b) c)]
      [(Term (Lab a b) c, Term (Lab a b) c)] (Dp_termination_proof a b c)
  | Split_Proc [(Term (Lab a b) c, Term (Lab a b) c)]
      [(Term (Lab a b) c, Term (Lab a b) c)] (Dp_termination_proof a b c)
      (Dp_termination_proof a b c)
  | Semlab_Proc (Sl_variant (Lab a b) c) [(Term (Lab a b) c, Term (Lab a b) c)]
      [Term (Lab a b) c] [(Term (Lab a b) c, Term (Lab a b) c)]
      (Dp_termination_proof a b c)
  | Switch_Innermost_Proc (Join_info (Lab a b) c) (Dp_termination_proof a b c)
  | Rewriting_Proc (Maybe [(Term (Lab a b) c, Term (Lab a b) c)])
      (Term (Lab a b) c, Term (Lab a b) c) (Term (Lab a b) c, Term (Lab a b) c)
      (Term (Lab a b) c, Term (Lab a b) c) (Term (Lab a b) c, Term (Lab a b) c)
      [Nat] (Dp_termination_proof a b c)
  | Instantiation_Proc (Term (Lab a b) c, Term (Lab a b) c)
      [(Term (Lab a b) c, Term (Lab a b) c)] (Dp_termination_proof a b c)
  | Forward_Instantiation_Proc (Term (Lab a b) c, Term (Lab a b) c)
      [(Term (Lab a b) c, Term (Lab a b) c)]
      (Maybe [(Term (Lab a b) c, Term (Lab a b) c)])
      (Dp_termination_proof a b c)
  | Narrowing_Proc (Term (Lab a b) c, Term (Lab a b) c) [Nat]
      [(Term (Lab a b) c, Term (Lab a b) c)] (Dp_termination_proof a b c)
  | Assume_Finite
      (Bool,
        (Bool,
          ([(Term (Lab a b) c, Term (Lab a b) c)],
            ([(Term (Lab a b) c, Term (Lab a b) c)],
              ([Term (Lab a b) c],
                ([(Term (Lab a b) c, Term (Lab a b) c)],
                  [(Term (Lab a b) c, Term (Lab a b) c)]))))))
      [Generic_assm_proof a b c (Trs_termination_proof a b c)
         (Dp_termination_proof a b c) (Fptrs_termination_proof a b c) ()
         (Unknown_proof a b c)]
  | Q_Reduction_Proc [Term (Lab a b) c] (Dp_termination_proof a b c)
  | Complex_Constant_Removal_Proc (Complex_constant_removal_prf (Lab a b) c)
      (Dp_termination_proof a b c)
  | General_Redpair_Proc (Redtriple_impl (Lab a b))
      [(Term (Lab a b) c, Term (Lab a b) c)]
      [(Term (Lab a b) c, Term (Lab a b) c)] (Cond_red_pair_prf (Lab a b) c)
      [Dp_termination_proof a b c]
  | To_Trs_Proc (Trs_termination_proof a b c);

data Unknown_proof a b c =
  Assume_Unknown [Char]
    [Generic_assm_proof a b c (Trs_termination_proof a b c)
       (Dp_termination_proof a b c) (Fptrs_termination_proof a b c) ()
       (Unknown_proof a b c)];

data Cr_proof a b c =
  SN_WCR (Join_info (Lab a b) c) (Trs_termination_proof a b c)
  | Weakly_Orthogonal | Strongly_Closed Nat
  | Rule_Labeling [((Term (Lab a b) c, Term (Lab a b) c), Nat)]
      [Crit_pair_info (Lab a b) c] (Maybe (Trs_termination_proof a b c))
  | Rule_Labeling_Conv [((Term (Lab a b) c, Term (Lab a b) c), Nat)]
      [Crit_pair_info (Lab a b) [Char]]
      (Maybe (Nat, Trs_termination_proof a b c))
  | Redundant_Rules [(Term (Lab a b) c, Term (Lab a b) c)] Nat
      [[Term (Lab a b) c]] (Cr_proof a b c)
  | Compositional_PCP [(Term (Lab a b) c, Term (Lab a b) c)]
      (Cp_join_hints (Lab a b) c) (Cr_proof a b c)
  | Compositional_PCP_Rule_Lab [(Term (Lab a b) c, Term (Lab a b) c)]
      (Pcp_rule_lab_com (Lab a b) c) (Cr_proof a b c)
  | Parallel_Closed (Maybe Nat)
  | PCP_Closed (Cp_join_hints (Lab a b) c) (Cp_join_hints (Lab a b) c)
  | PCP_Rule_Lab (Pcp_rule_lab (Lab a b) c) | Development_Closed (Maybe Nat)
  | Critical_Pair_Closing_System [(Term (Lab a b) c, Term (Lab a b) c)]
      (Trs_termination_proof a b c) Nat
  | Compositional_PCPS [(Term (Lab a b) c, Term (Lab a b) c)]
      [(Term (Lab a b) c, Term (Lab a b) c)] (Cp_join_hints (Lab a b) c)
      (Cp_join_hints (Lab a b) c) (Trs_termination_proof a b c) (Cr_proof a b c)
  | Persistent_Decomposition [(Lab a b, ([[Char]], [Char]))]
      [([(Term (Lab a b) c, Term (Lab a b) c)], Cr_proof a b c)];

data Comp_res = LESS | EQUAL | GREATER;

newtype Multimap a b = Abs_multimap (b -> a, (Mapping a [b], [b]));

data Ring_ext a b = Ring_ext a (a -> a -> a) b;

data Constraint = LT Linear_poly Rat | GT Linear_poly Rat | LEQ Linear_poly Rat
  | GEQ Linear_poly Rat | EQ Linear_poly Rat;

newtype Sum_bot a b = Sumbot (Sum a b);

newtype Afs a = Abs_afs ((a, Nat) -> Af_entry, Set (a, Nat));

data Rel_impl_ext a b c =
  Rel_impl_ext (Sum (String -> String) ()) (Sum (String -> String) ())
    (String -> String) ((Term a b, Term a b) -> Sum (String -> String) ())
    ((Term a b, Term a b) -> Sum (String -> String) ())
    ((Term a b, Term a b) -> Sum (String -> String) ()) ((a, Nat) -> Set Nat)
    ((a, Nat) -> Set Nat) (Sum (String -> String) ())
    (Sum (String -> String) ()) (Sum (String -> String) ())
    (Sum (String -> String) ()) (Sum (String -> String) ())
    (Sum (String -> String) ()) ((a, Nat) -> Set Nat)
    ([(a, Nat)] -> Sum (String -> String) ()) (Maybe [(a, Nat)])
    (Maybe [(a, Nat)])
    (Complexity_measure a b -> Complexity_class -> Sum (String -> String) ()) c;

newtype Rel_impl_type b a c = Abs_rel_impl_type (c -> Rel_impl_ext b a ());

data Non_join_info a b c d = Diff_NFs
  | Tcap_Non_Unif (Term a b -> Term a b -> b -> Term a b)
  | Tree_Aut_Intersect_Empty (Tree_automaton c a) (Ta_relation c)
      (Tree_automaton c a) (Ta_relation c)
  | Finite_Model_Gt (Sl_variant a b) | Discr_Pair_Gt (Rel_impl_type a b d) d
  | Usable_Rules_Reach_NJ (Non_join_info a b c d)
  | Usable_Rules_Reach_Unif_NJ
      (Sum [(Term a b, Term a b)] [(Term a b, Term a b)])
      (Non_join_info a b c d)
  | Finitely_Reachable
  | Argument_Filter_NJ [((a, Nat), Af_entry)] (Non_join_info a b c d)
  | Grounding [(b, Term a b)] (Non_join_info a b c d)
  | Subterm_NJ [Nat] (Non_join_info a b c d);

data Ncr_proof a b c d = SN_NWCR (Trs_termination_proof a b c)
  | Non_Join (Term (Lab a b) c)
      [([Nat], ((Term (Lab a b) c, Term (Lab a b) c), Term (Lab a b) c))]
      [([Nat], ((Term (Lab a b) c, Term (Lab a b) c), Term (Lab a b) c))]
      (Non_join_info (Lab a b) c d (Redtriple_impl (Lab a b)))
  | NCR_Disj_Subtrs [(Term (Lab a b) c, Term (Lab a b) c)] (Ncr_proof a b c d)
  | NCR_Redundant_Rules [(Term (Lab a b) c, Term (Lab a b) c)] Nat
      (Ncr_proof a b c d)
  | NCR_Persistent_Decomposition [(Lab a b, ([[Char]], [Char]))]
      [(Term (Lab a b) c, Term (Lab a b) c)] (Ncr_proof a b c d)
  | NCR_Rule_Removal [(Term (Lab a b) c, Term (Lab a b) c)]
      [((Term (Lab a b) c, Term (Lab a b) c),
         [([Nat], ((Term (Lab a b) c, Term (Lab a b) c), Term (Lab a b) c))])]
      (Ncr_proof a b c d);

data Oc_irule a b = OC_Deduce (Term a b) (Term a b) (Term a b)
  | OC_Orientl (Term a b) (Term a b) | OC_Orientr (Term a b) (Term a b)
  | OC_Delete (Term a b) | OC_Compose (Term a b) (Term a b) (Term a b)
  | OC_Simplifyl (Term a b) (Term a b) (Term a b)
  | OC_Simplifyr (Term a b) (Term a b) (Term a b)
  | OC_Collapse (Term a b) (Term a b) (Term a b);

newtype Ordered_completion_proof a b = OKB [Oc_irule a b];

data Rule_removal_nonterm_reltrs_prf a b =
  Rule_removal_nonterm_reltrs_prf [(Term a b, Term a b)] [(Term a b, Term a b)];

newtype Rule_removal_nonterm_trs_prf a b = Rule_removal_nonterm_trs_prf
  [(Term a b, Term a b)];

newtype Dp_trans_nontermination_tt_prf a b c = DP_trans_nontermination_tt_prf
  [(Term (Lab a b) c, Term (Lab a b) c)];

data Const_string_complete_proof a b =
  Const_string_complete_proof b [(a, a)] [(Term a b, Term a b)];

newtype Q_increase_nonterm_trs_prf a b = Q_increase_nonterm_trs_prf [Term a b];

newtype Dp_q_reduction_nonterm_prf a b = DP_q_reduction_nonterm_prf [Term a b];

newtype Instantiation_complete_proc_prf a b = Instantiation_complete_proc_prf
  [(Term a b, Term a b)];

data Rule_removal_nonterm_dp_prf a b =
  Rule_removal_nonterm_dp_prf [(Term a b, Term a b)] [(Term a b, Term a b)];

newtype Q_increase_nonterm_dp_prf a b = Q_increase_nonterm_dp_prf [Term a b];

data Rewriting_complete_proc_prf a b =
  Rewriting_complete_proc_prf (Maybe [(Term a b, Term a b)])
    (Term a b, Term a b) (Term a b, Term a b) (Term a b, Term a b)
    (Term a b, Term a b) [Nat];

data Narrowing_complete_proc_prf a b =
  Narrowing_complete_proc_prf (Term a b, Term a b) [Nat] [(Term a b, Term a b)];

data Pat_rule_pos = Pat_Base | Pat_Pump | Pat_Close;

data Pat_eqv_prf a b = Pat_Dom_Renaming [(b, Term a b)]
  | Pat_Irrelevant [(b, Term a b)] [(b, Term a b)]
  | Pat_Simplify [(b, Term a b)] [(b, Term a b)];

data Pat_rule_prf a b = Pat_OrigRule (Term a b, Term a b) Bool
  | Pat_InitPump (Pat_rule_prf a b) [(b, Term a b)] [(b, Term a b)]
  | Pat_InitPumpCtxt (Pat_rule_prf a b) [(b, Term a b)] [Nat] b
  | Pat_Equiv (Pat_rule_prf a b) Bool (Pat_eqv_prf a b)
  | Pat_Narrow (Pat_rule_prf a b) (Pat_rule_prf a b) [Nat]
  | Pat_Inst (Pat_rule_prf a b) [(b, Term a b)] Pat_rule_pos
  | Pat_Rewr (Pat_rule_prf a b)
      (Term a b, [([Nat], ((Term a b, Term a b), Term a b))]) Pat_rule_pos b
  | Pat_Exp_Sigma (Pat_rule_prf a b) Nat;

data Non_loop_prf a b =
  Non_loop_prf (Pat_rule_prf a b) [(b, Term a b)] [(b, Term a b)] Nat Nat [Nat];

data Dp_loop_prf a b =
  DP_loop_prf (Term a b) [([Nat], ((Term a b, Term a b), (Bool, Term a b)))]
    [(b, Term a b)] (Actxt a (Term a b));

data Not_wn_ta_prf a b = Not_wn_ta_prf (Tree_automaton b a) (Ta_relation b);

data Dp_proof_step a = OC1 ([a], [a]) Bool
  | OC2 ([a], [a]) ([a], [a]) ([a], [a]) [a] [a] [a]
  | OC2p ([a], [a]) ([a], [a]) ([a], [a]) [a] [a] [a]
  | OC3 ([a], [a]) ([a], [a]) ([a], [a]) [a] [a]
  | OC3p ([a], [a]) ([a], [a]) ([a], [a]) [a] [a]
  | OCDP1 (([a], ((Nat, (Nat, [a])), [a])), ([a], ((Nat, (Nat, [a])), [a])))
      ([a], [a])
  | OCDP2 (([a], ((Nat, (Nat, [a])), [a])), ([a], ((Nat, (Nat, [a])), [a])))
      ([a], [a])
  | WPEQ (([a], ((Nat, (Nat, [a])), [a])), ([a], ((Nat, (Nat, [a])), [a])))
      (([a], ((Nat, (Nat, [a])), [a])), ([a], ((Nat, (Nat, [a])), [a])))
  | Lift (([a], ((Nat, (Nat, [a])), [a])), ([a], ((Nat, (Nat, [a])), [a])))
      (([a], ((Nat, (Nat, [a])), [a])), ([a], ((Nat, (Nat, [a])), [a])))
  | DPOC1_1 (([a], ((Nat, (Nat, [a])), [a])), ([a], ((Nat, (Nat, [a])), [a])))
      (([a], ((Nat, (Nat, [a])), [a])), ([a], ((Nat, (Nat, [a])), [a])))
      ([a], [a]) [a] [a]
  | DPOC1_2 (([a], ((Nat, (Nat, [a])), [a])), ([a], ((Nat, (Nat, [a])), [a])))
      (([a], ((Nat, (Nat, [a])), [a])), ([a], ((Nat, (Nat, [a])), [a])))
      ([a], [a]) [a] [a] [a]
  | DPOC2 (([a], ((Nat, (Nat, [a])), [a])), ([a], ((Nat, (Nat, [a])), [a])))
      (([a], ((Nat, (Nat, [a])), [a])), ([a], ((Nat, (Nat, [a])), [a])))
      ([a], [a]) [a] [a]
  | DPOC3_1 (([a], ((Nat, (Nat, [a])), [a])), ([a], ((Nat, (Nat, [a])), [a])))
      (([a], ((Nat, (Nat, [a])), [a])), ([a], ((Nat, (Nat, [a])), [a])))
      ([a], [a]) [a] [a]
  | DPOC3_2 (([a], ((Nat, (Nat, [a])), [a])), ([a], ((Nat, (Nat, [a])), [a])))
      (([a], ((Nat, (Nat, [a])), [a])), ([a], ((Nat, (Nat, [a])), [a])))
      ([a], [a]) [a] [a] [a]
  | DPDP1_1 (([a], ((Nat, (Nat, [a])), [a])), ([a], ((Nat, (Nat, [a])), [a])))
      (([a], ((Nat, (Nat, [a])), [a])), ([a], ((Nat, (Nat, [a])), [a])))
      (([a], ((Nat, (Nat, [a])), [a])), ([a], ((Nat, (Nat, [a])), [a]))) [a] [a]
  | DPDP1_2 (([a], ((Nat, (Nat, [a])), [a])), ([a], ((Nat, (Nat, [a])), [a])))
      (([a], ((Nat, (Nat, [a])), [a])), ([a], ((Nat, (Nat, [a])), [a])))
      (([a], ((Nat, (Nat, [a])), [a])), ([a], ((Nat, (Nat, [a])), [a]))) [a] [a]
  | DPDP2_1 (([a], ((Nat, (Nat, [a])), [a])), ([a], ((Nat, (Nat, [a])), [a])))
      (([a], ((Nat, (Nat, [a])), [a])), ([a], ((Nat, (Nat, [a])), [a])))
      (([a], ((Nat, (Nat, [a])), [a])), ([a], ((Nat, (Nat, [a])), [a]))) [a] [a]
  | DPDP2_2 (([a], ((Nat, (Nat, [a])), [a])), ([a], ((Nat, (Nat, [a])), [a])))
      (([a], ((Nat, (Nat, [a])), [a])), ([a], ((Nat, (Nat, [a])), [a])))
      (([a], ((Nat, (Nat, [a])), [a])), ([a], ((Nat, (Nat, [a])), [a]))) [a]
      [a];

data Non_loop_srs_proof a = SE_OC ([a], [a]) [a] [a] [Dp_proof_step a]
  | SE_DP (([a], ((Nat, (Nat, [a])), [a])), ([a], ((Nat, (Nat, [a])), [a]))) [a]
      [a] [Dp_proof_step a];

data Uncurry_nt_proof a b c =
  Uncurry_nt_proof
    (Lab a b,
      ([((Lab a b, Nat), [Lab a b])],
        ([(Term (Lab a b) c, Term (Lab a b) c)],
          [(Term (Lab a b) c, Term (Lab a b) c)])))
    [(Term (Lab a b) c, Term (Lab a b) c)];

data Trs_loop_prf a b =
  TRS_loop_prf (Term a b) [([Nat], ((Term a b, Term a b), Term a b))]
    [(b, Term a b)] (Actxt a (Term a b));

data Rel_trs_loop_prf a b =
  Rel_trs_loop_prf (Term a b)
    [([Nat], ((Term a b, Term a b), (Bool, Term a b)))] [(b, Term a b)]
    (Actxt a (Term a b));

data Reltrs_nontermination_proof a b c = Rel_Loop (Rel_trs_loop_prf (Lab a b) c)
  | Rel_TRS_String_Reversal (Reltrs_nontermination_proof a b c)
  | Rel_Not_Well_Formed
  | Rel_Rule_Removal (Rule_removal_nonterm_reltrs_prf (Lab a b) c)
      (Reltrs_nontermination_proof a b c)
  | Rel_R_Not_SN (Trs_nontermination_proof a b c)
  | Rel_TRS_Assume_Not_SN
      (Bool,
        ([Term (Lab a b) c],
          ([(Term (Lab a b) c, Term (Lab a b) c)],
            [(Term (Lab a b) c, Term (Lab a b) c)])))
      [Generic_assm_proof a b c (Trs_nontermination_proof a b c)
         (Dp_nontermination_proof a b c) (Reltrs_nontermination_proof a b c)
         (Fp_trs_nontermination_proof a b c) (Neg_unknown_proof a b c)];

data Fp_trs_nontermination_proof a b c = FP_TRS_Loop (Trs_loop_prf (Lab a b) c)
  | FP_TRS_Rule_Removal (Rule_removal_nonterm_trs_prf (Lab a b) c)
      (Fp_trs_nontermination_proof a b c)
  | FPTRS_Assume_Not_SN
      ([(Actxt (Lab a b) (Term (Lab a b) c), (Term (Lab a b) c, Location))],
        [(Term (Lab a b) c, Term (Lab a b) c)])
      [Generic_assm_proof a b c (Trs_nontermination_proof a b c)
         (Dp_nontermination_proof a b c) (Reltrs_nontermination_proof a b c)
         (Fp_trs_nontermination_proof a b c) (Neg_unknown_proof a b c)];

data Trs_nontermination_proof a b c = TRS_Loop (Trs_loop_prf (Lab a b) c)
  | TRS_Not_Well_Formed
  | TRS_Rule_Removal (Rule_removal_nonterm_trs_prf (Lab a b) c)
      (Trs_nontermination_proof a b c)
  | TRS_String_Reversal (Trs_nontermination_proof a b c)
  | TRS_Constant_String (Const_string_complete_proof (Lab a b) c)
      (Trs_nontermination_proof a b c)
  | TRS_DP_Trans (Dp_trans_nontermination_tt_prf a b c)
      (Dp_nontermination_proof a b c)
  | TRS_Termination_Switch (Join_info (Lab a b) c)
      (Trs_nontermination_proof a b c)
  | TRS_Nonloop (Non_loop_prf (Lab a b) c)
  | TRS_Nonloop_SRS (Non_loop_srs_proof (Lab a b))
  | TRS_Q_Increase (Q_increase_nonterm_trs_prf (Lab a b) c)
      (Trs_nontermination_proof a b c)
  | TRS_Uncurry (Uncurry_nt_proof a b c) (Trs_nontermination_proof a b c)
  | TRS_Not_WN_Tree_Automaton (Not_wn_ta_prf (Lab a b) c) | TRS_Not_RG_Decision
  | TRS_Assume_Not_SN
      (Bool, ([Term (Lab a b) c], [(Term (Lab a b) c, Term (Lab a b) c)]))
      [Generic_assm_proof a b c (Trs_nontermination_proof a b c)
         (Dp_nontermination_proof a b c) (Reltrs_nontermination_proof a b c)
         (Fp_trs_nontermination_proof a b c) (Neg_unknown_proof a b c)];

data Dp_nontermination_proof a b c = DP_Loop (Dp_loop_prf (Lab a b) c)
  | DP_Nonloop (Non_loop_prf (Lab a b) c)
  | DP_Rule_Removal (Rule_removal_nonterm_dp_prf (Lab a b) c)
      (Dp_nontermination_proof a b c)
  | DP_Q_Increase (Q_increase_nonterm_dp_prf (Lab a b) c)
      (Dp_nontermination_proof a b c)
  | DP_Q_Reduction (Dp_q_reduction_nonterm_prf (Lab a b) c)
      (Dp_nontermination_proof a b c)
  | DP_Termination_Switch (Join_info (Lab a b) c)
      (Dp_nontermination_proof a b c)
  | DP_Instantiation (Instantiation_complete_proc_prf (Lab a b) c)
      (Dp_nontermination_proof a b c)
  | DP_Rewriting (Rewriting_complete_proc_prf (Lab a b) c)
      (Dp_nontermination_proof a b c)
  | DP_Narrowing (Narrowing_complete_proc_prf (Lab a b) c)
      (Dp_nontermination_proof a b c)
  | DP_Assume_Infinite
      (Bool,
        (Bool,
          ([(Term (Lab a b) c, Term (Lab a b) c)],
            ([(Term (Lab a b) c, Term (Lab a b) c)],
              ([Term (Lab a b) c],
                ([(Term (Lab a b) c, Term (Lab a b) c)],
                  [(Term (Lab a b) c, Term (Lab a b) c)]))))))
      [Generic_assm_proof a b c (Trs_nontermination_proof a b c)
         (Dp_nontermination_proof a b c) (Reltrs_nontermination_proof a b c)
         (Fp_trs_nontermination_proof a b c) (Neg_unknown_proof a b c)];

data Neg_unknown_proof a b c =
  Assume_NT_Unknown [Char]
    [Generic_assm_proof a b c (Trs_nontermination_proof a b c)
       (Dp_nontermination_proof a b c) (Reltrs_nontermination_proof a b c)
       (Fp_trs_nontermination_proof a b c) (Neg_unknown_proof a b c)];

data Quasi_reductive_proof a b c =
  Unravel
    [(((Term (Lab a b) c, Term (Lab a b) c),
        [(Term (Lab a b) c, Term (Lab a b) c)]),
       [(Term (Lab a b) c, Term (Lab a b) c)])]
    (Trs_termination_proof a b c);

data Reduction_order_input a = RPO_Input [((a, Nat), (Nat, Order_tag))]
  | KBO_Input ([((a, Nat), (Nat, (Nat, Maybe [Nat])))], Nat);

data Approx_completion_proof a b c =
  SN_WCR_Subsumption (Join_info (Lab a b) c) (Trs_termination_proof a b c)
    (Maybe [((Term (Lab a b) c, Term (Lab a b) c), [Term (Lab a b) c])]);

data Completion_proof a b c =
  SN_WCR_Eq (Join_info (Lab a b) c) (Trs_termination_proof a b c)
    [((Term (Lab a b) c, Term (Lab a b) c), [Term (Lab a b) c])]
    (Maybe [((Term (Lab a b) c, Term (Lab a b) c), [Term (Lab a b) c])]);

data Equational_disproof a b c =
  Completion_and_Normalization_Different [(Term (Lab a b) c, Term (Lab a b) c)]
    (Completion_proof a b c)
  | Approx_and_Completion_and_Normalization_Different
      [(Term (Lab a b) c, Term (Lab a b) c)] (Approx_completion_proof a b c)
  | Ordered_Completion_and_Normalization_Different
      [(Term (Lab a b) c, Term (Lab a b) c)]
      [(Term (Lab a b) [Char], Term (Lab a b) [Char])]
      (Reduction_order_input (Lab a b)) (Ordered_completion_proof (Lab a b) c)
  | Approx_and_Ordered_Completion_and_Normalization_Different
      [(Term (Lab a b) c, Term (Lab a b) c)]
      [(Term (Lab a b) c, Term (Lab a b) c)] (Reduction_order_input (Lab a b));

data Nonreachability_proof a b c d = Nonreachable_Tcap | Nonreachable_Gtcap
  | Nonreachable_ETAC [(Lab a d, Nat)] (Lab a d) (Lab a d)
      (Tree_automaton (Term (Lab a d) b) (Lab a d))
  | Nonreachable_Subst_Approx [(Term (Lab a d) b, Term (Lab a d) b)]
      (Nonreachability_proof a b c d)
  | Nonreachable_Reverse (Nonreachability_proof a b c d)
  | Nonreachable_FGCR (Lab a d) (Lab a d) (Lab a d)
      [(Term (Lab a d) b, Term (Lab a d) b)]
      [(Term (Lab a d) b, Term (Lab a d) b)] (Reduction_order_input (Lab a d))
      (Ordered_completion_proof (Lab a d) b)
  | Nonreachable_Co_Rewrite_Pair (Rel_impl_type (Lab a d) b c) c
  | Nonreachable_Equational_Disproof (Equational_disproof a d b);

data Nonjoinability_proof a b c d = Nonjoinable_Tcap
  | Nonjoinable_Ground_NF (Nonreachability_proof a b c d);

data Inf_transformation a b =
  Ifrit_Rules_Inf [((Term a b, Term a b), [(Term a b, Term a b)])]
  | Left_Inline_Conditions_Inf [((Term a b, Term a b), [(Term a b, Term a b)])]
      [(((Term a b, Term a b), [(Term a b, Term a b)]), [(Term a b, Term a b)])]
  | Right_Inline_Conditions_Inf [((Term a b, Term a b), [(Term a b, Term a b)])]
      [(((Term a b, Term a b), [(Term a b, Term a b)]),
         [(Term a b, Term a b)])];

data Infeasibility_proof a b c d =
  Infeasible_Compound_Conditions (Lab a d) (Nonreachability_proof a b c d)
  | Infeasible_Equation (Term (Lab a d) b) (Term (Lab a d) b)
      (Nonreachability_proof a b c d)
  | Infeasible_Subset [(Term (Lab a d) b, Term (Lab a d) b)]
      (Infeasibility_proof a b c d)
  | Infeasible_Rhss_Equal (Term (Lab a d) b) (Term (Lab a d) b)
      (Term (Lab a d) b) (Nonjoinability_proof a b c d)
  | Infeasible_Trans (Term (Lab a d) b) (Term (Lab a d) b) (Term (Lab a d) b)
      (Nonreachability_proof a b c d)
  | Infeasible_Transform (Inf_transformation (Lab a d) b)
      (Infeasibility_proof a b c d)
  | Infeasible_Split_If
      (Term (Lab a d) b,
        (Term (Lab a d) b,
          [(((Term (Lab a d) b, Term (Lab a d) b),
              [(Term (Lab a d) b, Term (Lab a d) b)]),
             (Lab a d, [Term (Lab a d) b]))]))
      (Nonreachability_proof a b c d)
  | Infeasible_Goal_Lifting (Lab a d) (Lab a d) (Infeasibility_proof a b c d);

data Ccr_transformation a b c d =
  Inline_Conditions_CCRT
    [((Term (Lab a b) c, Term (Lab a b) c),
       [(Term (Lab a b) c, Term (Lab a b) c)])]
    [(((Term (Lab a b) c, Term (Lab a b) c),
        [(Term (Lab a b) c, Term (Lab a b) c)]),
       [(Term (Lab a b) c, Term (Lab a b) c)])]
  | Infeasible_Rule_Removal_CCRT
      [(((Term (Lab a b) c, Term (Lab a b) c),
          [(Term (Lab a b) c, Term (Lab a b) c)]),
         Infeasibility_proof a c d b)];

data Cstep_proof a b =
  Cstep_step ((Term a b, Term a b), [(Term a b, Term a b)]) [Nat]
    (b -> Term a b) (Term a b) (Term a b) [[Cstep_proof a b]];

data Conditional_ncr_proof a b c d e = Unconditional_CNCR (Ncr_proof a b c d)
  | Transformation_CNCR (Ccr_transformation a b c e)
      (Conditional_ncr_proof a b c d e)
  | Non_Join_CNCR (Term (Lab a b) c) (Term (Lab a b) c) (Term (Lab a b) c)
      [Cstep_proof (Lab a b) c] [Cstep_proof (Lab a b) c]
      (Non_join_info (Lab a b) c d (Redtriple_impl (Lab a b)));

data Ao_infeasibility_proof a b c d =
  AO_Infeasibility_Proof (Infeasibility_proof a b c d)
  | AO_Lhss_Equal (Term (Lab a d) b) (Term (Lab a d) b) (Term (Lab a d) b)
      (Nonjoinability_proof a b c d);

data Context_joinable_proof a b =
  Contextual_Join (Term a b) [Cstep_proof a b] [Cstep_proof a b];

data Unfeasible_proof a b =
  UnfeasibleOverlap (Term a b) (Term a b) (Term a b) [Cstep_proof a b]
    [Cstep_proof a b] ((Term a b, Term a b), [(Term a b, Term a b)])
    ((Term a b, Term a b), [(Term a b, Term a b)]);

data Conditional_cr_proof a b c d = Unconditional_CR (Cr_proof a b c)
  | Unravel_CR
      [(((Term (Lab a b) c, Term (Lab a b) c),
          [(Term (Lab a b) c, Term (Lab a b) c)]),
         [(Term (Lab a b) c, Term (Lab a b) c)])]
      (Cr_proof a b c)
  | Transformation_CR (Ccr_transformation a b c d)
      (Conditional_cr_proof a b c d)
  | Almost_Orthogonal_CR
  | Almost_Orthogonal_Modulo_Infeasibility_CR
      [([(Term (Lab a b) c, Term (Lab a b) c)],
         ([(Term (Lab a b) c, Term (Lab a b) c)],
           Ao_infeasibility_proof a c d b))]
  | AL94_CR (Quasi_reductive_proof a b c)
      [(Term (Lab a b) c,
         (Term (Lab a b) c,
           ([(Term (Lab a b) c, Term (Lab a b) c)],
             Context_joinable_proof (Lab a b) c)))]
      [([(Term (Lab a b) c, Term (Lab a b) c)], Infeasibility_proof a c d b)]
      [(c -> Term (Lab a b) c, Unfeasible_proof (Lab a b) c)];

data Ac_dependency_pairs_proof a b =
  AC_dependency_pairs_proof [(Term a b, Term a b)] [(Term a b, Term a b)]
    [(Term a b, Term a b)] [(Term a b, Term a b)];

data Ac_dp_termination_proof a b = AC_P_is_Empty
  | AC_Subterm_Proc [((a, Nat), [Nat])] [(Term a b, Term a b)]
      (Ac_dp_termination_proof a b)
  | AC_Redpair_UR_Proc (Redtriple_impl a) [(Term a b, Term a b)]
      [(Term a b, Term a b)] (Ac_dp_termination_proof a b)
  | AC_Mono_Redpair_UR_Proc (Redtriple_impl a) [(Term a b, Term a b)]
      [(Term a b, Term a b)] [(Term a b, Term a b)]
      (Ac_dp_termination_proof a b)
  | AC_Dep_Graph_Proc
      [(Maybe (Ac_dp_termination_proof a b), [(Term a b, Term a b)])];

data Ac_termination_proof a b c =
  AC_DP_Trans (Ac_dependency_pairs_proof (Lab a b) c)
    (Ac_dp_termination_proof (Lab a b) c) (Ac_dp_termination_proof (Lab a b) c)
  | AC_DP_Trans_Single (Ac_dependency_pairs_proof (Lab a b) c)
      (Ac_dp_termination_proof (Lab a b) c)
  | AC_Rule_Removal (Redtriple_impl (Lab a b))
      [(Term (Lab a b) c, Term (Lab a b) c)] (Ac_termination_proof a b c)
  | AC_R_is_Empty;

data Fresh_variable_addition_info a b c d =
  Fresh_Variable_Addition_Info b c [(d, Formula (Term a (Trans_var b, c)))];

data Transition_removal_info a b c d e =
  Transition_removal_info (Sharp c -> a) [d] b a (d -> e);

data Location_addition_info a b c d e =
  Location_Addition_Info d d e (Transition_rule a b c d);

data Art_edge_impl a b c = Cover_Edge a c | Children_Edge [(b, (a, c))];

data Art_node_impl a b c d e f g =
  Art_Node e (Formula (Term a (b, c))) d (Art_edge_impl e f g);

data Art_impl_ext a b c d e f g h =
  Art_impl_ext [e] [Art_node_impl a b c d e f g] h;

data Invariant_proof a b c d e f g =
  Impact [(d, Formula (Term a (b, c)))] (Art_impl_ext a b c d e f g ());

data Cooperation_proof a b c d e f = Triviala
  | Invariants_Update (Invariant_proof a b c (Sharp d) [Char] e f)
      (Cooperation_proof a b c d e f)
  | Location_Addition (Location_addition_info a b c (Sharp d) e)
      (Cooperation_proof a b c d e f)
  | Fresh_Variable_Addition (Fresh_variable_addition_info a b c e)
      (Cooperation_proof a b c d e f)
  | Transition_Removal (Transition_removal_info [Term a (b, c)] c d e f)
      (Cooperation_proof a b c d e f)
  | Scc_Decomp [([Sharp d], Cooperation_proof a b c d e f)]
  | Cut_Transition_Split [([e], Cooperation_proof a b c d e f)];

data Termination_proof a b c d e f = Trivialb
  | Via_Cooperation
      [([(Sharp e, Transition_rule a b c (Sharp d))],
         Cooperation_proof a b c d (Sharp e) f)]
  | Invariants_Update_LTS (Invariant_proof a b c d [Char] e f)
      (Termination_proof a b c d e f);

data Eq_proof a b = Refl (Term a b) | Sym (Eq_proof a b)
  | Trans (Eq_proof a b) (Eq_proof a b)
  | Assm (Term a b, Term a b) (b -> Term a b) | Cong a [Eq_proof a b];

data Equational_proof a b c = Equational_Proof_Tree (Eq_proof (Lab a b) c)
  | Completion_and_Normalization [(Term (Lab a b) c, Term (Lab a b) c)]
      (Completion_proof a b c)
  | Conversion [Term (Lab a b) c]
  | Conversion_With_History
      [((Term (Lab a b) c, Term (Lab a b) c), [Term (Lab a b) c])];

data Feasibility_proof a b =
  Feasible_Witness [(b, Term a b)] [[Cstep_proof a b]];

data Dt_transformation_info a b =
  DT_Transformation_Info [((Term a b, Term a b), (Term a b, Term a b))]
    [((Term a b, Term a b), (Term a b, Term a b))] [Term a b];

data Wdp_trans_info a b =
  WDP_Trans_Info (Set (a, Nat)) [((Term a b, Term a b), (Term a b, Term a b))]
    [((Term a b, Term a b), (Term a b, Term a b))] [Term a b];

data Complexity_proof a b c =
  Rule_Shift_Complexity (Redtriple_impl (Lab a b))
    [(Term (Lab a b) c, Term (Lab a b) c)]
    (Maybe [(Term (Lab a b) c, Term (Lab a b) c)]) (Complexity_proof a b c)
  | RisEmpty_Complexity
  | Remove_Nonapplicable_Rules_Complexity [(Term (Lab a b) c, Term (Lab a b) c)]
      (Complexity_proof a b c)
  | Matchbounds_Complexity (Bounds_info (Lab a b) c)
  | Matchbounds_Rel_Complexity (Bounds_info (Lab a b) c)
      [(Term (Lab a b) c, Term (Lab a b) c)] (Complexity_proof a b c)
  | DT_Transformation (Dt_transformation_info (Lab a b) c)
      (Complexity_proof a b c)
  | WDP_Transformation (Wdp_trans_info (Lab a b) c) (Complexity_proof a b c)
  | Complexity_Assumption
      ([Term (Lab a b) c],
        ([(Term (Lab a b) c, Term (Lab a b) c)],
          ([(Term (Lab a b) c, Term (Lab a b) c)],
            (Complexity_measure (Lab a b) c, Complexity_class))))
      [Generic_assm_proof a b c (Complexity_proof a b c) () () () ()]
  | Usable_Rules_Complexity [(Term (Lab a b) c, Term (Lab a b) c)]
      (Complexity_proof a b c)
  | Split_Complexity [(Term (Lab a b) c, Term (Lab a b) c)]
      (Complexity_proof a b c) (Complexity_proof a b c);

data Safety_proof a b c d e f g = Trivial
  | Invariant_Assertion (Invariant_proof a b c d e f g)
      (Safety_proof a b c d e f g);

data Ncomm_proof a b c d =
  Non_Join_Comm (Term (Lab a b) c)
    [([Nat], ((Term (Lab a b) c, Term (Lab a b) c), Term (Lab a b) c))]
    [([Nat], ((Term (Lab a b) c, Term (Lab a b) c), Term (Lab a b) c))]
    (Non_join_info (Lab a b) c d (Redtriple_impl (Lab a b)))
  | Swap_Not_Comm (Ncomm_proof a b c d);

data Comm_proof a b c = Parallel_Closed_Comm (Maybe Nat)
  | Development_Closed_Comm (Maybe Nat)
  | PCP_Closed_Comm (Cp_join_hints (Lab a b) c) (Cp_join_hints (Lab a b) c)
  | PCP_Rule_Lab_Comm (Pcp_rule_lab_com (Lab a b) c)
  | PCP_Compositional_Rule_Lab_Comm [(Term (Lab a b) c, Term (Lab a b) c)]
      [(Term (Lab a b) c, Term (Lab a b) c)] (Pcp_rule_lab_com (Lab a b) c)
      (Comm_proof a b c)
  | Compositional_PCPS_Comm [(Term (Lab a b) c, Term (Lab a b) c)]
      [(Term (Lab a b) c, Term (Lab a b) c)]
      [(Term (Lab a b) c, Term (Lab a b) c)] (Cp_join_hints (Lab a b) c)
      (Cp_join_hints (Lab a b) c) (Cp_join_hints (Lab a b) c)
      (Cp_join_hints (Lab a b) c) (Trs_termination_proof a b c)
      (Comm_proof a b c)
  | Swap_Comm (Comm_proof a b c) | CR_Proof (Cr_proof a b c);

data Proof a b c = TRS_Termination_Proof (Trs_termination_proof a b c)
  | Complexity_Proof (Complexity_proof a b c)
  | DP_Termination_Proof (Dp_termination_proof a b c)
  | DP_Nontermination_Proof (Dp_nontermination_proof a b c)
  | TRS_Nontermination_Proof (Trs_nontermination_proof a b c)
  | FP_Termination_Proof (Fptrs_termination_proof a b c)
  | FP_Nontermination_Proof (Fp_trs_nontermination_proof a b c)
  | Relative_TRS_Nontermination_Proof (Reltrs_nontermination_proof a b c)
  | TRS_Confluence_Proof (Cr_proof a b c)
  | TRS_Non_Confluence_Proof (Ncr_proof a b c c)
  | TRS_Non_Commutation_Proof (Ncomm_proof a b c c)
  | TRS_Commutation_Proof (Comm_proof a b c)
  | Completion_Proof (Completion_proof a b c)
  | Ordered_Completion_Proof (Ordered_completion_proof (Lab a b) c)
  | Equational_Proof (Equational_proof a b c)
  | Equational_Disproof (Equational_disproof a b c)
  | Quasi_Reductive_Proof (Quasi_reductive_proof a b c)
  | Conditional_CR_Proof (Conditional_cr_proof a b c (Redtriple_impl (Lab a b)))
  | Conditional_Non_CR_Proof
      (Conditional_ncr_proof a b c c (Redtriple_impl (Lab a b)))
  | Tree_Automata_Closed_Proof (Ta_relation [Char])
  | AC_Termination_Proof (Ac_termination_proof a b c)
  | LTS_Termination_Proof
      (Termination_proof Siga c Ty [Char] [Char] La_solver_type)
  | LTS_Safety_Proof
      (Safety_proof Siga c Ty [Char] [Char] [Char] La_solver_type)
  | Infeasibility_Proof (Infeasibility_proof a c (Redtriple_impl (Lab a b)) b)
  | Feasibility_Proof (Feasibility_proof (Lab a b) c)
  | Unknown_Proof (Unknown_proof a b c)
  | Unknown_Disproof (Neg_unknown_proof a b c);

newtype Renaming2 a = Abs_renaming2 (a -> a, a -> a);

newtype RenamingN a = Abs_renamingN ((Nat, a) -> a, a -> a);

data Le_constraint a = Le_Constraint Le_rel Linear_poly a;

data Linearity a = Non_Linear | Onea | Variable a;

data Ns_constraint a = LEQ_ns Linear_poly a | GEQ_ns Linear_poly a;

newtype Comp_fun_idem b a = Abs_comp_fun_idem (b -> a -> a);

data Domain = Natural Nat | Integera | NegativeInteger | Arctic | Arctic_rat
  | Int_mat Nat Nat | Arctic_mat Nat | Arctic_rat_mat Nat | Rational Rat Nat
  | Rat_mat Nat Nat | Mini_Alg Real Nat | Mini_Alg_mat Nat Nat
  | Int_core_mat Nat [Nat] Core_matrix_mode
  | Real_core_mat Real Nat [Nat] Core_matrix_mode;

data Fp_strategy a b = Outermost | Context_Sensitive [((a, Nat), [Nat])]
  | Forbidden_Patterns [(Actxt a (Term a b), (Term a b, Location))];

data Strategy a b = No_Strategy | Innermost Bool | Innermost_Q Bool [Term a b];

data Input a b =
  DP_input Bool [(Term a b, Term a b)] (Strategy a b) [(Term a b, Term a b)]
  | Inn_TRS_input (Strategy a b) [(Term a b, Term a b)] [(Term a b, Term a b)]
  | FP_TRS_input (Fp_strategy a b) [(Term a b, Term a b)]
  | AC_input [(Term a b, Term a b)] [a] [a]
  | LTS_input (Lts_impl Siga b Ty [Char] [Char])
  | LTS_safety_input (Lts_impl Siga b Ty [Char] [Char]) [[Char]]
  | CTRS_input [((Term a b, Term a b), [(Term a b, Term a b)])]
  | EQ_input [(Term a b, Term a b)]
  | EQ_RO_input [(Term a b, Term a b)] (Reduction_order_input a)
  | EQ_reasoning_input [(Term a b, Term a b)] (Term a b, Term a b)
  | TA_input (Tree_automaton [Char] a) [(Term a b, Term a b)]
  | Infeasibility_input [((Term a b, Term a b), [(Term a b, Term a b)])]
      [(Term a b, Term a b)]
  | Single_TRS_input [(a, Nat)] [(Term a b, Term a b)]
  | Two_TRS_input [(a, Nat)] [(Term a b, Term a b)] [(Term a b, Term a b)]
  | Unknown_input [Char];

data Monoid_ext a b = Monoid_ext (a -> a -> a) a b;

data Ta_ext a b c = Ta_ext (Set a) (Set (Ta_rule a b)) (Set (a, a)) c;

data Answer a b = Decision Bool | Upperbound_Poly Nat
  | Completed_System [(Term a b, Term a b)]
  | Order_Completed_System [(Term a b, Term a b)] [(Term a b, Term a b)];

data Dependance = Ignore | Increase | Decrease | Wild;

newtype Semilattice_set a = Abs_semilattice_set (a -> a -> a);

data Relation_kind = Strict_TRS | Weak_TRS (Maybe Nat);

data Cert_result = Certified | Unsupported String | Error String;

data ComplexityMeasure a b = Derivational (Maybe [(a, Nat)])
  | Runtime (Maybe ([(a, Nat)], [(a, Nat)]));

data Property a b = Termination | Confluence | Commutation | Completion | Safety
  | Entailment | Complexity (ComplexityMeasure a b) | Closed_Under_Rewriting
  | Infeasibility | Unknown_Property;

newtype Subst_incr a b = Abs_subst_incr
  (b -> Term a b, (Set b, Term a b -> [b]));

data Art_edge a b c d e = Cover e | Children [(Transition_rule a b c d, e)];

data Ta_rule_impl a b = TA_rule_impl b [a] a (Rbt a ());

data Ta_impl a b =
  TA_Impl (Rbt a ()) (Rbt (b, Nat) [Ta_rule_impl a b]) [a] (Rbt a ()) [(a, a)]
    (a -> Rbt a ()) (a -> Rbt a ());

newtype Tp b a = TP
  (Bool,
    ([Term b a],
      (Bool,
        ([(Term b a, Term b a)],
          ([(Term b a, Term b a)],
            (Rbt (b, Nat) [(Bool, (Term b a, Term b a))],
              Term b a -> Bool))))));

newtype WfTRS b a = Abs_wfTRS [(Term b a, Term b a)];

data Art_ext a b c d e f =
  Art_ext [e] [e] (e -> Art_edge a b c d e) (e -> d)
    (e -> Formula (Term a (b, c))) f;

data Max_monus_impl a =
  Max_Monus_Impl La_solver_type [((a, Nat), Term Sig Nat)];

newtype Ta_code b a = Abs_ta_code
  (Rbta b (),
    (Rbta (Ta_rule b a) (),
      ([(b, b)],
        (Rbta b (),
          (Rbta (a, Nat) (Rbta ([b], b) ()),
            (Bool, (b -> Rbta b (), b -> Rbta b ())))))));

data Interpretation a = Int_linear_poly ((a, Nat), (Int, [Int]))
  | Rat_linear_poly ((a, Nat), (Rat, [Rat]))
  | Arctic_linear_poly ((a, Nat), (Arctic, [Arctic]))
  | Arctic_rat_linear_poly ((a, Nat), (Arctic_delta Rat, [Arctic_delta Rat]))
  | Real_linear_poly ((a, Nat), (Real, [Real]))
  | Int_matrix ((a, Nat), (Mat Int, [Mat Int]))
  | Rat_matrix ((a, Nat), (Mat Rat, [Mat Rat]))
  | Arctic_matrix ((a, Nat), (Mat Arctic, [Mat Arctic]))
  | Arctic_rat_matrix
      ((a, Nat), (Mat (Arctic_delta Rat), [Mat (Arctic_delta Rat)]))
  | Real_matrix ((a, Nat), (Mat Real, [Mat Real]))
  | Int_core_matrix ((a, Nat), (Mat Int, [Mat Int]))
  | Real_core_matrix Real ((a, Nat), (Mat Real, [Mat Real]))
  | Int_non_linear_poly ((a, Nat), [(Monom Nat, Int)])
  | Rat_non_linear_poly ((a, Nat), [(Monom Nat, Rat)])
  | Real_non_linear_poly ((a, Nat), [(Monom Nat, Real)]);

data C_constraint a b =
  Conditional_C Bool (Term a b, Term a b) (Term a b, Term a b)
  | Unconditional_C Bool (Term a b, Term a b);

newtype Dpp b a = DPP
  (Bool,
    (Bool,
      ([(Term b a, Term b a)],
        ([(Term b a, Term b a)],
          ([Term b a],
            (Bool,
              (Bool,
                ([(Term b a, Term b a)],
                  ([(Term b a, Term b a)],
                    (Rbt (b, Nat) [(Bool, (Term b a, Term b a))],
                      (Rbt (b, Nat) [(Bool, (Term b a, Term b a))],
                        (Bool, Term b a -> Bool))))))))))));

data Max_poly_impl a = Max_Poly_Impl La_solver_type [((a, Nat), Term Sigb Nat)];

newtype Simplex_state a = Simplex_State
  ([Ns_constraint QDelta],
    ((Mapping a [(a, Atom QDelta)],
       (Mapping Nat QDelta -> Mapping Nat QDelta, [a])),
      State a QDelta));

data Poly_constraint a = Poly_Ge [(Monom a, Int)] | Poly_Eq [(Monom a, Int)];

data Lab_filter = No_Lab_Filter | Zero_Zero_Filter;

data Hinter_ext a b c d e =
  Hinter_ext [c] (b -> [d]) (c -> a) (c -> Maybe [a]) e;

newtype Ac_dpp b a = AC_DPP
  ([(Term b a, Term b a)],
    ([(Term b a, Term b a)],
      ([(Term b a, Term b a)],
        ([(Term b a, Term b a)],
          ([(Term b a, Term b a)],
            Rbt (b, Nat) [((), (Term b a, Term b a))])))));

data Gen_g_impl_ext a b c d = Gen_g_impl_ext a b c d;

data Redord_ext a b c =
  Redord_ext (Sum (String -> String) ()) (Term a b -> Term a b -> Bool) a c;

data Condition_type = Bound | Strict | Non_Strict;

data Fp_loop_prf a b =
  FP_loop_prf (Actxt a (Term a b)) [(b, Term a b)] (Term a b)
    [([Nat], ((Term a b, Term a b), Term a b))];

data Sl_ops_ext a b c d e =
  Sl_ops_ext (a -> [b] -> c) (a -> Nat -> c -> Bool) (a -> [b] -> b) [b] b
    ([(Term a d, Term a d)] -> Sum (String -> String) ()) (a -> [b] -> c)
    (a -> Nat -> c -> Bool) (c -> [c]) (a -> Nat -> [c]) e;

data Slm_ops_ext a b c d =
  Slm_ops_ext (a -> [b] -> c) (a -> [b] -> b) [b] b (a -> [b] -> c) d;

data Tp_ops_ext a b c d =
  Tp_ops_ext
    (a -> (Bool,
            (Set (Term b c),
              (Set (Term b c, Term b c), Set (Term b c, Term b c)))))
    (a -> [Term b c]) (a -> [(Term b c, Term b c)])
    (a -> [(Term b c, Term b c)]) (a -> [(Term b c, Term b c)]) (a -> Bool)
    (a -> Term b c -> Bool) (a -> Bool)
    (a -> (b, Nat) -> [(Term b c, Term b c)])
    (a -> [(Term b c, Term b c)] -> [(Term b c, Term b c)] -> a)
    (a -> [(Term b c, Term b c)] ->
            ([(Term b c, Term b c)], [(Term b c, Term b c)]))
    (Bool ->
      [Term b c] -> [(Term b c, Term b c)] -> [(Term b c, Term b c)] -> a)
    (a -> Bool) d;

data Partial_object_ext a b = Partial_object_ext (Set a) b;

newtype Cut_transition_split_info a = Cut_Transition_Split_Info [[a]];

data Dpp_ops_ext a b c d =
  Dpp_ops_ext
    (a -> (Bool,
            (Bool,
              (Set (Term b c, Term b c),
                (Set (Term b c, Term b c),
                  (Set (Term b c),
                    (Set (Term b c, Term b c), Set (Term b c, Term b c))))))))
    (a -> [(Term b c, Term b c)]) (a -> [(Term b c, Term b c)])
    (a -> [(Term b c, Term b c)]) (a -> [Term b c])
    (a -> [(Term b c, Term b c)]) (a -> [(Term b c, Term b c)])
    (a -> [(Term b c, Term b c)]) (a -> Bool) (a -> Bool) (a -> Bool)
    (a -> Term b c -> Bool) (a -> Bool)
    (a -> (b, Nat) -> [(Term b c, Term b c)])
    (a -> (b, Nat) -> [(Term b c, Term b c)]) (a -> [(Term b c, Term b c)] -> a)
    (a -> (Term b c, Term b c) -> [(Term b c, Term b c)] -> a)
    (a -> [(Term b c, Term b c)] -> a)
    (a -> [(Term b c, Term b c)] -> [(Term b c, Term b c)] -> a)
    (a -> [(Term b c, Term b c)] -> [(Term b c, Term b c)] -> a)
    (a -> [(Term b c, Term b c)] ->
            ([(Term b c, Term b c)], [(Term b c, Term b c)]))
    (a -> [(Term b c, Term b c)] ->
            ([(Term b c, Term b c)], [(Term b c, Term b c)]))
    (Bool ->
      Bool ->
        [(Term b c, Term b c)] ->
          [(Term b c, Term b c)] ->
            [Term b c] -> [(Term b c, Term b c)] -> [(Term b c, Term b c)] -> a)
    (a -> Bool) (a -> Bool) (a -> Bool) d;

data Non_inf_order_ext a b c =
  Non_inf_order_ext (Sum (String -> String) ())
    ((Term a b, Term a b) -> Sum (String -> String) ())
    (C_constraint a b -> Sum (String -> String) ())
    ((a, Nat) -> Nat -> Dependance) (String -> String) c;

data Ac_tp_ops_ext a b c d =
  Ac_tp_ops_ext (a -> (Set (Term b c, Term b c), (Set b, Set b)))
    (a -> [(Term b c, Term b c)]) (a -> [b]) (a -> [b])
    ([(Term b c, Term b c)] -> [b] -> [b] -> a)
    (a -> [(Term b c, Term b c)] -> a) (a -> [(Term b c, Term b c)]) d;

data Ordered_semiring_ext a b =
  Ordered_semiring_ext (a -> a -> Bool) (a -> a -> Bool) (a -> a -> a) b;

data Ac_dpp_ops_ext a b c d =
  Ac_dpp_ops_ext
    (a -> (Set (Term b c, Term b c),
            (Set (Term b c, Term b c),
              (Set (Term b c, Term b c),
                (Set (Term b c, Term b c), Set (Term b c, Term b c))))))
    (a -> [(Term b c, Term b c)]) (a -> [(Term b c, Term b c)])
    (a -> [(Term b c, Term b c)]) (a -> [(Term b c, Term b c)])
    (a -> [(Term b c, Term b c)]) (a -> [(Term b c, Term b c)])
    (a -> [(Term b c, Term b c)])
    ([(Term b c, Term b c)] ->
      [(Term b c, Term b c)] ->
        [(Term b c, Term b c)] ->
          [(Term b c, Term b c)] -> [(Term b c, Term b c)] -> a)
    (a -> (b, Nat) -> [(Term b c, Term b c)])
    (a -> (b, Nat) -> [(Term b c, Term b c)])
    (a -> [(Term b c, Term b c)] -> [(Term b c, Term b c)] -> a) (a -> Bool)
    (a -> Bool) (a -> [(Term b c, Term b c)] -> a) d;

data Redord_closure_ext a b c =
  Redord_closure_ext ([b] -> Term a b -> Term a b -> Bool)
    (Sum (String -> String) ()) c;

data Lpoly_order_semiring_ext a b =
  Lpoly_order_semiring_ext Bool a (a -> Bool) (a -> Bool) (a -> Nat)
    (a -> Nat -> Sum (String -> String) ()) (String -> String) b;

data Explicit_minus_semiring_ext a b = Explicit_minus_semiring_ext (a -> a) b;

newtype X_f_status_option_x_x_nat_list_nat_x_f_prod_fun_option a =
  Abs_x_f_status_option_x_x_nat_list_nat_x_f_prod_fun_option
  (Maybe ((a, Nat) -> [Nat]));

newtype
  X_compare_order_x_x_f_afs_option_x_x_nat_x_compare_order_x_x_f_prod_set_af_entry_nat_x_compare_order_x_x_f_prod_fun_prod_option
    a
  = Abs_x_compare_order_x_x_f_afs_option_x_x_nat_x_compare_order_x_x_f_prod_set_af_entry_nat_x_compare_order_x_x_f_prod_fun_prod_option
  (Maybe ((a, Nat) -> Af_entry, Set (a, Nat)));

dom :: forall a b. (Cenum a) => (a -> Maybe b) -> Set a;
dom m = collect (\ a -> not (is_none (m a)));

dlist_ex :: forall a. (Ceq a) => (a -> Bool) -> Set_dlist a -> Bool;
dlist_ex x xc = any x (list_of_dlist xc);

rBT_Impl_rbt_ex :: forall a b. (a -> b -> Bool) -> Rbta a b -> Bool;
rBT_Impl_rbt_ex p Empty = False;
rBT_Impl_rbt_ex p (Branch c l k v r) =
  p k v || (rBT_Impl_rbt_ex p l || rBT_Impl_rbt_ex p r);

ex :: forall a b. (Ccompare a) => (a -> b -> Bool) -> Mapping_rbt a b -> Bool;
ex xb xc = rBT_Impl_rbt_ex xb (impl_ofb xc);

bex :: forall a. (Ceq a, Ccompare a) => Set a -> (a -> Bool) -> Bool;
bex (RBT_set rbt) p =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "Bex RBT_set: ccompare = None" (\ _ -> bex (RBT_set rbt) p);
    Just _ -> ex (\ k _ -> p k) rbt;
  });
bex (DList_set dxs) p =
  (case (ceq :: Maybe (a -> a -> Bool)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a) "Bex DList_set: ceq = None"
        (\ _ -> bex (DList_set dxs) p);
    Just _ -> dlist_ex p dxs;
  });
bex (Set_Monad xs) p = any p xs;

impl_of :: forall b a. (Linorder b) => Rbt b a -> Rbta b a;
impl_of (RBT x) = x;

keys :: forall a b. (Linorder a) => Rbt a b -> [a];
keys x = keysa (impl_of x);

skol ::
  forall a b. (Ceq a, Ccompare a) => Set a -> Term b a -> Term (Sum b a) a;
skol v (Var x) = (if member x v then Fun (Inr x) [] else Var x);
skol v (Fun f ts) = Fun (Inl f) (map (skol v) ts);

drop :: forall a. Nat -> [a] -> [a];
drop n [] = [];
drop n (x : xs) =
  (if equal_nat n zero_nat then x : xs else drop (minus_nat n one_nat) xs);

find :: forall a. (a -> Bool) -> [a] -> Maybe a;
find uu [] = Nothing;
find p (x : xs) = (if p x then Just x else find p xs);

last :: forall a. [a] -> a;
last (x : xs) = (if null xs then x else last xs);

take :: forall a. Nat -> [a] -> [a];
take n [] = [];
take n (x : xs) =
  (if equal_nat n zero_nat then [] else x : take (minus_nat n one_nat) xs);

empty :: forall a b. (Linorder a) => Rbt a b;
empty = RBT Empty;

rbt_ins ::
  forall a b.
    (Compare_order a) => (a -> b -> b -> b) -> a -> b -> Rbta a b -> Rbta a b;
rbt_ins f k v Empty = Branch R Empty k v Empty;
rbt_ins f k v (Branch B l x y r) = (case compare k x of {
                                     Eqa -> Branch B l x (f k y v) r;
                                     Lt -> balance (rbt_ins f k v l) x y r;
                                     Gt -> balance l x y (rbt_ins f k v r);
                                   });
rbt_ins f k v (Branch R l x y r) = (case compare k x of {
                                     Eqa -> Branch R l x (f k y v) r;
                                     Lt -> Branch R (rbt_ins f k v l) x y r;
                                     Gt -> Branch R l x y (rbt_ins f k v r);
                                   });

rbt_insert_with_key ::
  forall a b.
    (Compare_order a) => (a -> b -> b -> b) -> a -> b -> Rbta a b -> Rbta a b;
rbt_insert_with_key f k v t = paint B (rbt_ins f k v t);

rbt_split ::
  forall a b.
    (Compare_order a) => Rbta a b -> a -> (Rbta a b, (Maybe b, Rbta a b));
rbt_split Empty k = (Empty, (Nothing, Empty));
rbt_split (Branch uu l a b r) x =
  (case compare x a of {
    Eqa -> (l, (Just b, r));
    Lt -> (case rbt_split l x of {
            (l1, (beta, l2)) -> (l1, (beta, rbt_join l2 a b r));
          });
    Gt -> (case rbt_split r x of {
            (r1, (beta, r2)) -> (rbt_join l a b r1, (beta, r2));
          });
  });

small_rbt :: forall a b. Rbta a b -> Bool;
small_rbt t = less_nat (bheight t) (nat_of_integer (4 :: Integer));

flip_rbt :: forall a b. Rbta a b -> Rbta a b -> Bool;
flip_rbt t1 t2 = less_nat (bheight t2) (bheight t1);

rbt_union_swap_rec ::
  forall a b.
    (Compare_order a) => (a -> b -> b -> b) ->
                           Bool -> Rbta a b -> Rbta a b -> Rbta a b;
rbt_union_swap_rec f gamma t1 t2 =
  (case (if flip_rbt t2 t1 then (not gamma, (t1, t2)) else (gamma, (t2, t1))) of
    {
    (gammaa, (t2a, t1a)) ->
      let {
        fa = (if gammaa then (\ k v va -> f k va v) else f);
      } in (if small_rbt t2a then folda (rbt_insert_with_key fa) t2a t1a
             else (case t1a of {
                    Empty -> t2a;
                    Branch _ l1 a b r1 ->
                      (case rbt_split t2a a of {
                        (l2, (beta, r2)) ->
                          rbt_join (rbt_union_swap_rec f gammaa l1 l2) a
                            (case beta of {
                              Nothing -> b;
                              Just c -> fa a b c;
                            })
                            (rbt_union_swap_rec f gammaa r1 r2);
                      });
                  }));
  });

rbt_union_with_key ::
  forall a b.
    (Compare_order a) => (a -> b -> b -> b) -> Rbta a b -> Rbta a b -> Rbta a b;
rbt_union_with_key f t1 t2 = paint B (rbt_union_swap_rec f False t1 t2);

rbt_union :: forall a b. (Compare_order a) => Rbta a b -> Rbta a b -> Rbta a b;
rbt_union = rbt_union_with_key (\ _ _ rv -> rv);

union :: forall a b. (Compare_order a) => Rbt a b -> Rbt a b -> Rbt a b;
union xb xc = RBT (rbt_union (impl_of xb) (impl_of xc));

bind :: forall a b. Maybe a -> (a -> Maybe b) -> Maybe b;
bind Nothing f = Nothing;
bind (Just x) f = f x;

zip_option :: forall a b. [a] -> [b] -> Maybe [(a, b)];
zip_option [] [] = Just [];
zip_option (x : xs) (y : ys) =
  bind (zip_option xs ys) (\ zs -> Just ((x, y) : zs));
zip_option (x : xs) [] = Nothing;
zip_option [] (y : ys) = Nothing;

guard :: Bool -> Maybe ();
guard b = (if b then Just () else Nothing);

match_lista ::
  forall a b. (Eq a) => [(Gctxt a b, Term a b)] -> Maybe [(Gctxt a b, b)];
match_lista [] = Just [];
match_lista ((GCHole, t) : ps) = match_lista ps;
match_lista ((GCFun f ss, Fun g ts) : ps) =
  bind (guard (f == g))
    (\ _ -> bind (zip_option ss ts) (\ psa -> match_lista (psa ++ ps)));
match_lista ((GCFun f ss, Var x) : ps) =
  bind (match_lista ps) (\ psa -> Just ((GCFun f ss, x) : psa));

merge_lists ::
  forall a b. (Eq a) => [Gctxt a b] -> [Gctxt a b] -> Maybe [Gctxt a b];
merge_lists [] [] = Just [];
merge_lists (GCHole : cs) (d : ds) =
  bind (merge_lists cs ds) (\ es -> Just (d : es));
merge_lists (c : cs) (GCHole : ds) =
  bind (merge_lists cs ds) (\ es -> Just (c : es));
merge_lists (GCFun f ss : cs) (GCFun g ts : ds) =
  bind (guard (f == g))
    (\ _ ->
      bind (merge_lists ss ts)
        (\ us -> bind (merge_lists cs ds) (\ es -> Just (GCFun f us : es))));
merge_lists [] (d : ds) = Nothing;
merge_lists (c : cs) [] = Nothing;

mergeb :: forall a b. (Eq a) => Gctxt a b -> Gctxt a b -> Maybe (Gctxt a b);
mergeb c d = bind (merge_lists [c] [d]) (\ es -> Just (nth es zero_nat));

merge_var ::
  forall a b.
    (Eq a,
      Eq b) => a -> Gctxt b a ->
                      [(Gctxt b a, a)] ->
                        Maybe ((Gctxt b a, a), [(Gctxt b a, a)]);
merge_var x c [] = Just ((c, x), []);
merge_var x c ((d, y) : ps) =
  (if x == y then bind (mergeb c d) (\ e -> merge_var x e ps)
    else bind (merge_var x c ps) (\ (b, psa) -> Just (b, (d, y) : psa)));

merge_alla ::
  forall a b. (Eq a, Eq b) => [(Gctxt a b, b)] -> Maybe [(Gctxt a b, b)];
merge_alla [] = Just [];
merge_alla ((c, x) : ps) =
  bind (merge_var x c ps)
    (\ (cx, psa) -> bind (merge_alla psa) (\ psb -> Just (cx : psb)));

matchc ::
  forall a b. (Eq a, Eq b) => (Gctxt a b, Term a b) -> Maybe [(Gctxt a b, b)];
matchc (c, t) = bind (match_lista [(c, t)]) merge_alla;

matchb :: forall a b. (Eq a, Eq b) => Gctxt a b -> Term a b -> Bool;
matchb c t = not (is_none (matchc (c, t)));

tcap ::
  forall a b.
    (Compare a, Eq a, Compare b,
      Eq b) => Set (Term a b, Term a b) -> Term a b -> Gctxt a b;
tcap uu (Var uv) = GCHole;
tcap r (Fun f ts) =
  let {
    h = GCFun f (map (tcap r) ts);
  } in (if bex r (\ ra -> matchb h (fst ra)) then GCHole else h);

root :: forall a b. Term a b -> Maybe (a, Nat);
root (Var x) = Nothing;
root (Fun f ts) = Just (f, size_list ts);

transitions_impl ::
  forall a b c d e. Lts_impl a b c d e -> [(e, Transition_rule a b c d)];
transitions_impl (Lts_Impl x1 x2 x3) = x2;

initiala :: forall a b c d e. Lts_impl a b c d e -> [d];
initiala (Lts_Impl x1 x2 x3) = x1;

assertion_impl ::
  forall a b c d e. Lts_impl a b c d e -> [(d, Formula (Term a (b, c)))];
assertion_impl (Lts_Impl x1 x2 x3) = x3;

lookupa :: forall a b. (Eq a) => Alist a b -> a -> Maybe b;
lookupa xa = map_of (impl_ofa xa);

lookupb :: forall a b. (Ccompare a, Eq a) => Mapping a b -> a -> Maybe b;
lookupb (RBT_Mapping t) = lookupd t;
lookupb (Assoc_List_Mapping al) = lookupa al;

lookup_default :: forall a b. (Ccompare b, Eq b) => a -> Mapping b a -> b -> a;
lookup_default d m k = (case lookupb m k of {
                         Nothing -> d;
                         Just v -> v;
                       });

update :: forall a b. (Eq a) => a -> b -> [(a, b)] -> [(a, b)];
update k v [] = [(k, v)];
update k v (p : ps) = (if fst p == k then (k, v) : ps else p : update k v ps);

updatea :: forall a b. (Eq a) => a -> b -> Alist a b -> Alist a b;
updatea xc xd xe = Alist (update xc xd (impl_ofa xe));

fun_upd :: forall a b. (Eq a) => (a -> b) -> a -> b -> a -> b;
fun_upd f a b = (\ x -> (if x == a then b else f x));

updateb ::
  forall a b. (Ccompare a, Eq a) => a -> b -> Mapping a b -> Mapping a b;
updateb k v (RBT_Mapping t) =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "update RBT_Mapping: ccompare = None"
        (\ _ -> updateb k v (RBT_Mapping t));
    Just _ -> RBT_Mapping (inserte k v t);
  });
updateb k v (Assoc_List_Mapping al) = Assoc_List_Mapping (updatea k v al);
updateb k v (Mapping m) = Mapping (fun_upd m k (Just v));

mapping_empty_choose :: forall a b. (Ccompare a) => Mapping a b;
mapping_empty_choose = (case (ccompare :: Maybe (a -> a -> Ordera)) of {
                         Nothing -> Assoc_List_Mapping emptya;
                         Just _ -> RBT_Mapping emptye;
                       });

mapping_empty :: forall a b. (Ccompare a) => Mapping_impla -> Mapping a b;
mapping_empty Mapping_RBT = RBT_Mapping emptye;
mapping_empty Mapping_Assoc_List = Assoc_List_Mapping emptya;
mapping_empty Mapping_Mapping = Mapping (\ _ -> Nothing);
mapping_empty Mapping_Choose = mapping_empty_choose;

emptyb :: forall a b. (Ccompare a, Mapping_impl a) => Mapping a b;
emptyb = mapping_empty (of_phantom (mapping_impl :: Phantom a Mapping_impla));

of_alist ::
  forall a b. (Ccompare a, Eq a, Mapping_impl a) => [(a, b)] -> Mapping a b;
of_alist xs = foldr (\ (a, b) -> updateb a b) xs emptyb;

map_of_default ::
  forall a b. (Ccompare b, Eq b, Mapping_impl b) => a -> [(b, a)] -> b -> a;
map_of_default d xs = lookup_default d (of_alist xs);

assertion_of ::
  forall a b c d e.
    (Ccompare d, Eq d,
      Mapping_impl d) => Lts_impl a b c d e -> d -> Formula (Term a (b, c));
assertion_of pi = map_of_default (Conjunction []) (assertion_impl pi);

lts_of ::
  forall a b c d e.
    (Ccompare a, Eq a, Ccompare b, Eq b, Ccompare c, Eq c, Ceq d, Ccompare d,
      Eq d, Mapping_impl d, Set_impl d, Ceq e, Ccompare e,
      Set_impl e) => Lts_impl a b c d e -> Lts_ext a b c d ();
lts_of pi =
  Lts_ext (set (initiala pi)) (image snd (set (transitions_impl pi)))
    (assertion_of pi) ();

source :: forall a b c d. Transition_rule a b c d -> d;
source (Transition l uu uv) = l;

target :: forall a b c d. Transition_rule a b c d -> d;
target (Transition uu r uv) = r;

membera :: forall a. (Eq a) => [a] -> a -> Bool;
membera [] y = False;
membera (x : xs) y = x == y || membera xs y;

insertb :: forall a. (Eq a) => a -> [a] -> [a];
insertb x xs = (if membera xs x then xs else x : xs);

uniona :: forall a. (Eq a) => [a] -> [a] -> [a];
uniona = fold insertb;

of_fun :: forall a. (Nat -> a) -> Nat -> IArray.IArray a;
of_fun f n = IArray.tabulate (integer_of_nat n, f . nat_of_integer);

vec_of_fun :: forall a. Nat -> (Nat -> a) -> Vec_impl a;
vec_of_fun xb xc = Abs_vec_impl (xb, of_fun xc xb);

vec :: forall a. Nat -> (Nat -> a) -> Vec a;
vec n f = Vec_impl (vec_of_fun n f);

col :: forall a. Mat a -> Nat -> Vec a;
col a j = vec (dim_row a) (\ i -> index_mat a (i, j));

mat_of_fun :: forall a. Nat -> Nat -> ((Nat, Nat) -> a) -> Mat_impl a;
mat_of_fun xc xd xe =
  Abs_mat_impl (xc, (xd, of_fun (\ i -> of_fun (\ j -> xe (i, j)) xd) xc));

mat :: forall a. Nat -> Nat -> ((Nat, Nat) -> a) -> Mat a;
mat nr nc f = Mat_impl (mat_of_fun nr nc f);

row :: forall a. Mat a -> Nat -> Vec a;
row a i = vec (dim_col a) (\ j -> index_mat a (i, j));

funpow :: forall a. Nat -> (a -> a) -> a -> a;
funpow n f =
  (if equal_nat n zero_nat then id else f . funpow (minus_nat n one_nat) f);

val :: QDelta -> Rat -> Rat;
val qd delta = plus_rat (qdfst qd) (times_rat delta (qdsnd qd));

rbt_del :: forall a b. (Compare_order a) => a -> Rbta a b -> Rbta a b;
rbt_del x Empty = Empty;
rbt_del x (Branch c a y s b) = (case compare x y of {
                                 Eqa -> combine a b;
                                 Lt -> rbt_del_from_left x a y s b;
                                 Gt -> rbt_del_from_right x a y s b;
                               });

rbt_del_from_left ::
  forall a b.
    (Compare_order a) => a -> Rbta a b -> a -> b -> Rbta a b -> Rbta a b;
rbt_del_from_left x (Branch B lt z v rt) y s b =
  balance_left (rbt_del x (Branch B lt z v rt)) y s b;
rbt_del_from_left x Empty y s b = Branch R (rbt_del x Empty) y s b;
rbt_del_from_left x (Branch R va vb vc vd) y s b =
  Branch R (rbt_del x (Branch R va vb vc vd)) y s b;

rbt_del_from_right ::
  forall a b.
    (Compare_order a) => a -> Rbta a b -> a -> b -> Rbta a b -> Rbta a b;
rbt_del_from_right x a y s (Branch B lt z v rt) =
  balance_right a y s (rbt_del x (Branch B lt z v rt));
rbt_del_from_right x a y s Empty = Branch R a y s (rbt_del x Empty);
rbt_del_from_right x a y s (Branch R va vb vc vd) =
  Branch R a y s (rbt_del x (Branch R va vb vc vd));

rbt_delete :: forall a b. (Compare_order a) => a -> Rbta a b -> Rbta a b;
rbt_delete k t = paint B (rbt_del k t);

delete :: forall a b. (Compare_order a) => a -> Rbt a b -> Rbt a b;
delete xb xc = RBT (rbt_delete xb (impl_of xc));

rbt_insert :: forall a b. (Compare_order a) => a -> b -> Rbta a b -> Rbta a b;
rbt_insert = rbt_insert_with_key (\ _ _ nv -> nv);

insert :: forall a b. (Compare_order a) => a -> b -> Rbt a b -> Rbt a b;
insert xc xd xe = RBT (rbt_insert xc xd (impl_of xe));

rbt_lookup :: forall a b. (Compare_order a) => Rbta a b -> a -> Maybe b;
rbt_lookup Empty k = Nothing;
rbt_lookup (Branch uu l x y r) k = (case compare k x of {
                                     Eqa -> Just y;
                                     Lt -> rbt_lookup l k;
                                     Gt -> rbt_lookup r k;
                                   });

lookup :: forall a b. (Compare_order a) => Rbt a b -> a -> Maybe b;
lookup x = rbt_lookup (impl_of x);

proja :: forall a b. Term a b -> Nat -> Term a b;
proja (Fun f ts) i = (if less_nat i (size_list ts) then nth ts i else Fun f ts);

filtera :: forall a. (Ceq a, Ccompare a) => (a -> Bool) -> Set a -> Set a;
filtera p a = inf_set a (Collect_set p);

subst :: forall a b. (Eq a) => a -> Term b a -> a -> Term b a;
subst x t = fun_upd Var x t;

bind2 ::
  forall a b c d.
    Sum_bot a b -> (a -> Sum_bot c d) -> (b -> Sum_bot c d) -> Sum_bot c d;
bind2 (Sumbot a) f g = (case a of {
                         Inl aa -> f aa;
                         Inr aa -> g aa;
                       });

merge :: forall a b. (Eq a) => [(a, b)] -> [(a, b)] -> [(a, b)];
merge qs ps = foldr (\ (a, b) -> update a b) ps qs;

entries :: forall a b. (Linorder a) => Rbt a b -> [(a, b)];
entries x = entriesa (impl_of x);

lterms ::
  forall a b. ((a, Nat) -> [(Nat, Nat)]) -> Term a b -> [(Term a b, Nat)];
lterms pi =
  (\ (Fun f ts) ->
    map (\ (i, a) -> (proja (Fun f ts) i, a)) (pi (f, size_list ts)));

lhs :: (Nat, Linear_poly) -> Nat;
lhs (l, r) = l;

rhs :: (Nat, Linear_poly) -> Linear_poly;
rhs (l, r) = r;

ground :: forall a b. Term a b -> Bool;
ground (Var x) = False;
ground (Fun f ts) = all ground ts;

insert_vars_term :: forall a b. (Eq b) => Term a b -> [b] -> [b];
insert_vars_term (Var x) xs = insertb x xs;
insert_vars_term (Fun f ts) xs = foldr insert_vars_term ts xs;

is_Var :: forall a b. Term a b -> Bool;
is_Var (Var x1) = True;
is_Var (Fun x21 x22) = False;

wf_rule :: forall a b. (Eq b) => (Term a b, Term a b) -> Bool;
wf_rule r =
  not (is_Var (fst r)) &&
    all (membera (insert_vars_term (fst r) [])) (insert_vars_term (snd r) []);

fun_of :: forall a b. (Eq a) => [(a, b)] -> a -> b;
fun_of vec x = the (map_of vec x);

char_0x7A :: Char;
char_0x7A = Chr (122 :: Integer);

char_0x79 :: Char;
char_0x79 = Chr (121 :: Integer);

char_0x78 :: Char;
char_0x78 = Chr (120 :: Integer);

char_0x77 :: Char;
char_0x77 = Chr (119 :: Integer);

char_0x76 :: Char;
char_0x76 = Chr (118 :: Integer);

char_0x75 :: Char;
char_0x75 = Chr (117 :: Integer);

char_0x70 :: Char;
char_0x70 = Chr (112 :: Integer);

char_0x6F :: Char;
char_0x6F = Chr (111 :: Integer);

char_0x6E :: Char;
char_0x6E = Chr (110 :: Integer);

char_0x6D :: Char;
char_0x6D = Chr (109 :: Integer);

char_0x6C :: Char;
char_0x6C = Chr (108 :: Integer);

char_0x6B :: Char;
char_0x6B = Chr (107 :: Integer);

char_0x6A :: Char;
char_0x6A = Chr (106 :: Integer);

char_0x69 :: Char;
char_0x69 = Chr (105 :: Integer);

char_0x68 :: Char;
char_0x68 = Chr (104 :: Integer);

char_0x67 :: Char;
char_0x67 = Chr (103 :: Integer);

char_0x66 :: Char;
char_0x66 = Chr (102 :: Integer);

char_0x65 :: Char;
char_0x65 = Chr (101 :: Integer);

char_0x64 :: Char;
char_0x64 = Chr (100 :: Integer);

char_0x63 :: Char;
char_0x63 = Chr (99 :: Integer);

char_0x62 :: Char;
char_0x62 = Chr (98 :: Integer);

char_0x61 :: Char;
char_0x61 = Chr (97 :: Integer);

char_0x5F :: Char;
char_0x5F = Chr (95 :: Integer);

char_0x5A :: Char;
char_0x5A = Chr (90 :: Integer);

char_0x59 :: Char;
char_0x59 = Chr (89 :: Integer);

char_0x58 :: Char;
char_0x58 = Chr (88 :: Integer);

char_0x57 :: Char;
char_0x57 = Chr (87 :: Integer);

char_0x56 :: Char;
char_0x56 = Chr (86 :: Integer);

char_0x55 :: Char;
char_0x55 = Chr (85 :: Integer);

char_0x54 :: Char;
char_0x54 = Chr (84 :: Integer);

char_0x53 :: Char;
char_0x53 = Chr (83 :: Integer);

char_0x52 :: Char;
char_0x52 = Chr (82 :: Integer);

char_0x51 :: Char;
char_0x51 = Chr (81 :: Integer);

char_0x50 :: Char;
char_0x50 = Chr (80 :: Integer);

char_0x4F :: Char;
char_0x4F = Chr (79 :: Integer);

char_0x4E :: Char;
char_0x4E = Chr (78 :: Integer);

char_0x4D :: Char;
char_0x4D = Chr (77 :: Integer);

char_0x4C :: Char;
char_0x4C = Chr (76 :: Integer);

char_0x4B :: Char;
char_0x4B = Chr (75 :: Integer);

char_0x4A :: Char;
char_0x4A = Chr (74 :: Integer);

char_0x49 :: Char;
char_0x49 = Chr (73 :: Integer);

char_0x48 :: Char;
char_0x48 = Chr (72 :: Integer);

char_0x47 :: Char;
char_0x47 = Chr (71 :: Integer);

char_0x46 :: Char;
char_0x46 = Chr (70 :: Integer);

char_0x45 :: Char;
char_0x45 = Chr (69 :: Integer);

char_0x44 :: Char;
char_0x44 = Chr (68 :: Integer);

char_0x43 :: Char;
char_0x43 = Chr (67 :: Integer);

char_0x42 :: Char;
char_0x42 = Chr (66 :: Integer);

char_0x41 :: Char;
char_0x41 = Chr (65 :: Integer);

char_0x3B :: Char;
char_0x3B = Chr (59 :: Integer);

char_0x3A :: Char;
char_0x3A = Chr (58 :: Integer);

char_0x26 :: Char;
char_0x26 = Chr (38 :: Integer);

letters :: [Char];
letters =
  [char_0x61, char_0x62, char_0x63, char_0x64, char_0x65, char_0x66, char_0x67,
    char_0x68, char_0x69, char_0x6A, char_0x6B, char_0x6C, char_0x6D, char_0x6E,
    char_0x6F, char_0x70, char_0x71, char_0x72, char_0x73, char_0x74, char_0x75,
    char_0x76, char_0x77, char_0x78, char_0x79, char_0x7A, char_0x41, char_0x42,
    char_0x43, char_0x44, char_0x45, char_0x46, char_0x47, char_0x48, char_0x49,
    char_0x4A, char_0x4B, char_0x4C, char_0x4D, char_0x4E, char_0x4F, char_0x50,
    char_0x51, char_0x52, char_0x53, char_0x54, char_0x55, char_0x56, char_0x57,
    char_0x58, char_0x59, char_0x5A, char_0x5F, char_0x30, char_0x31, char_0x32,
    char_0x33, char_0x34, char_0x35, char_0x36, char_0x37, char_0x38, char_0x39,
    char_0x26, char_0x3B, char_0x3A, char_0x2D];

explode :: String -> [Char];
explode s = map char_of_integer (Str_Literal.asciisOfLiteral s);

left :: forall a b. a -> Sum_bot a b;
left x = Sumbot (Inl x);

xml_error ::
  forall a b c d.
    String -> ([Xml], (a, (b, (c, [String])))) -> Sum_bot (Xml_error String) d;
xml_error str x =
  (case x of {
    (xmls, (_, (_, (_, pos)))) ->
      let {
        next =
          (case xmls of {
            [] -> "tag close";
            XML tag _ _ : _ -> ("<" ++ implode tag) ++ ">";
            XML_text stra : _ -> ("text element \"" ++ implode stra) ++ "\"";
          });
      } in left (Fatal
                  ((((("parse error on " ++ next) ++ " at ") ++
                      default_showsl_list showsl_lit pos "") ++
                     ":\n") ++
                    str));
  });

mismatch ::
  forall a b.
    String ->
      ([Xml], (a, (Bool, ([String], [String])))) ->
        Sum_bot (Xml_error String) b;
mismatch tag x =
  (case x of {
    (_, (_, (True, (cands, _)))) -> left (TagMismatch (tag : cands));
    (_, (_, (False, (cands, _)))) ->
      xml_error
        ("expecting " ++ default_showsl_list showsl_lit (tag : cands) "") x;
  });

xml_do ::
  forall a.
    String ->
      (([Xml], ([([Char], [Char])], (Bool, ([String], [String])))) ->
        Sum_bot (Xml_error String) a) ->
        (Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
          Sum_bot (Xml_error String) a;
xml_do tag p x =
  (case x of {
    (XML nam atts xmls, (_, (_, (_, pos)))) ->
      (if nam == explode tag then p (xmls, (atts, (False, ([], tag : pos))))
        else mismatch tag ([fst x], snd x));
    (XML_text _, _) -> mismatch tag ([fst x], snd x);
  });

right :: forall a b. a -> Sum_bot b a;
right x = Sumbot (Inr x);

xml_or ::
  forall a b c d e f g.
    ((a, (b, (Bool, (c, d)))) -> Sum_bot (Xml_error e) f) ->
      ((a, (b, (g, ([String], d)))) -> Sum_bot (Xml_error e) f) ->
        (a, (b, (g, (c, d)))) -> Sum_bot (Xml_error e) f;
xml_or p1 p2 x =
  (case x of {
    (x1, (atts, (flag, (cands, rest)))) ->
      bind2 (p1 (x1, (atts, (True, (cands, rest)))))
        (\ a ->
          (case a of {
            TagMismatch cands1 -> p2 (x1, (atts, (flag, (cands1, rest))));
            Fatal aa -> left (Fatal aa);
          }))
        right;
  });

hd :: forall a. (Ceq a) => Set_dlist a -> a;
hd xa = hda (list_of_dlist xa);

tl :: forall a. (Ceq a) => Set_dlist a -> Set_dlist a;
tl xa = Abs_dlist (tla (list_of_dlist xa));

foldli :: forall a b. [a] -> (b -> Bool) -> (a -> b -> b) -> b -> b;
foldli [] c f sigma = sigma;
foldli (x : xs) c f sigma =
  (if c sigma then foldli xs c f (f x sigma) else sigma);

replicate :: forall a. Nat -> a -> [a];
replicate n x =
  (if equal_nat n zero_nat then [] else x : replicate (minus_nat n one_nat) x);

scf_list :: forall a. (Nat -> Nat) -> [a] -> [a];
scf_list scf xs =
  concatMap (\ (x, i) -> replicate (scf i) x)
    (zip xs (upt zero_nat (size_list xs)));

scf_term :: forall a b. ((a, Nat) -> Nat -> Nat) -> Term a b -> Term a b;
scf_term scf (Var x) = Var x;
scf_term scf (Fun f ts) =
  Fun f (scf_list (scf (f, size_list ts)) (map (scf_term scf) ts));

butlast :: forall a. [a] -> [a];
butlast [] = [];
butlast (x : xs) = (if null xs then [] else x : butlast xs);

extract :: forall a. (a -> Bool) -> [a] -> Maybe ([a], (a, [a]));
extract p [] = Nothing;
extract p (x : xs) =
  (if p x then Just ([], (x, xs))
    else (case extract p xs of {
           Nothing -> Nothing;
           Just (ys, (y, zs)) -> Just (x : ys, (y, zs));
         }));

productb ::
  forall a b. (Ceq a, Ceq b) => Set_dlist a -> Set_dlist b -> Set_dlist (a, b);
productb dxs1 dxs2 =
  Abs_dlist (foldc (\ a -> foldc (\ c -> (\ b -> (a, c) : b)) dxs2) dxs1 []);

rbt_product ::
  forall a b c d e.
    (a -> b -> c -> d -> e) -> Rbta a b -> Rbta c d -> Rbta (a, c) e;
rbt_product f rbt1 rbt2 =
  rbtreeify
    (reverse
      (folda (\ a b -> folda (\ c d -> (\ e -> ((a, c), f a b c d) : e)) rbt2)
        rbt1 []));

productd ::
  forall a d b e c.
    (Ccompare a,
      Ccompare b) => (a -> d -> b -> e -> c) ->
                       Mapping_rbt a d ->
                         Mapping_rbt b e -> Mapping_rbt (a, b) c;
productd xc xd xe = Mapping_RBTa (rbt_product xc (impl_ofb xd) (impl_ofb xe));

producta ::
  forall a b.
    (Ccompare a,
      Ccompare b) => Mapping_rbt a () ->
                       Mapping_rbt b () -> Mapping_rbt (a, b) ();
producta rbt1 rbt2 = productd (\ _ _ _ _ -> ()) rbt1 rbt2;

productc ::
  forall a b.
    (Ceq a, Ccompare a, Set_impl a, Ceq b, Ccompare b,
      Set_impl b) => Set a -> Set b -> Set (a, b);
productc (RBT_set rbt1) (RBT_set rbt2) =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "product RBT_set RBT_set: ccompare1 = None"
        (\ _ -> productc (RBT_set rbt1) (RBT_set rbt2));
    Just _ ->
      (case (ccompare :: Maybe (b -> b -> Ordera)) of {
        Nothing ->
          (error :: forall a. String -> (() -> a) -> a)
            "product RBT_set RBT_set: ccompare2 = None"
            (\ _ -> productc (RBT_set rbt1) (RBT_set rbt2));
        Just _ -> RBT_set (producta rbt1 rbt2);
      });
  });
productc a2 (RBT_set rbt2) =
  (case (ccompare :: Maybe (b -> b -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "product RBT_set: ccompare2 = None" (\ _ -> productc a2 (RBT_set rbt2));
    Just _ -> foldb (\ y -> sup_set (image (\ x -> (x, y)) a2)) rbt2 bot_set;
  });
productc (RBT_set rbt1) b2 =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "product RBT_set: ccompare1 = None" (\ _ -> productc (RBT_set rbt1) b2);
    Just _ -> foldb (\ x -> sup_set (image (\ a -> (x, a)) b2)) rbt1 bot_set;
  });
productc (DList_set dxs) (DList_set dys) =
  (case (ceq :: Maybe (a -> a -> Bool)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "product DList_set DList_set: ceq1 = None"
        (\ _ -> productc (DList_set dxs) (DList_set dys));
    Just _ ->
      (case (ceq :: Maybe (b -> b -> Bool)) of {
        Nothing ->
          (error :: forall a. String -> (() -> a) -> a)
            "product DList_set DList_set: ceq2 = None"
            (\ _ -> productc (DList_set dxs) (DList_set dys));
        Just _ -> DList_set (productb dxs dys);
      });
  });
productc a1 (DList_set dys) =
  (case (ceq :: Maybe (b -> b -> Bool)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "product DList_set2: ceq = None" (\ _ -> productc a1 (DList_set dys));
    Just _ -> foldc (\ y -> sup_set (image (\ x -> (x, y)) a1)) dys bot_set;
  });
productc (DList_set dxs) b1 =
  (case (ceq :: Maybe (a -> a -> Bool)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "product DList_set1: ceq = None" (\ _ -> productc (DList_set dxs) b1);
    Just _ -> foldc (\ x -> sup_set (image (\ a -> (x, a)) b1)) dxs bot_set;
  });
productc (Set_Monad xs) (Set_Monad ys) =
  Set_Monad (fold (\ x -> fold (\ y -> (\ a -> (x, y) : a)) ys) xs []);
productc a b = Collect_set (\ (x, y) -> member x a && member y b);

set_Cons ::
  forall a. (Ceq a, Ccompare a, Set_impl a) => Set a -> Set [a] -> Set [a];
set_Cons a xs =
  image (\ (aa, b) -> aa : b)
    (productc (inf_set (image (\ x -> x) a) top_set)
      (inf_set top_set (image (\ xsa -> xsa) xs)));

listset :: forall a. (Ceq a, Ccompare a, Set_impl a) => [Set a] -> Set [a];
listset [] = inserta [] (set_empty (of_phantom set_impl_list));
listset (a : asa) = set_Cons a (listset asa);

remdups :: forall a. (Eq a) => [a] -> [a];
remdups [] = [];
remdups (x : xs) = (if membera xs x then remdups xs else x : remdups xs);

remove1 :: forall a. (Eq a) => a -> [a] -> [a];
remove1 x [] = [];
remove1 x (y : xs) = (if x == y then xs else y : remove1 x xs);

aux ::
  forall a b.
    (Eq a,
      Compare_order b) => (a -> Maybe b) ->
                            Rbt b [a] -> a -> Rbt b [a] -> Rbt b [a];
aux key ma v m =
  (case key v of {
    Nothing -> m;
    Just k ->
      (case lookup ma k of {
        Nothing -> m;
        Just ws ->
          (if membera ws v then (case lookup m k of {
                                  Nothing -> insert k [v] m;
                                  Just vs -> insert k (insertb v vs) m;
                                })
            else m);
      });
  });

ma_coeff :: Mini_alg -> Rat;
ma_coeff xa = fst (snd (rep_mini_alg xa));

mau_coeff :: Mini_alg_unique -> Rat;
mau_coeff xa = ma_coeff (rep_mini_alg_unique xa);

root_int_maina :: Nat -> Int -> Int -> Int -> Int -> (Int, Bool);
root_int_maina pm ipm ip x n =
  let {
    xpm = binary_power x pm;
    xp = times_int xpm x;
  } in (if less_eq_int xp n then (x, equal_int xp n)
         else root_int_maina pm ipm ip
                (divide_int (plus_int (divide_int n xpm) (times_int x ipm)) ip)
                n);

root_int_main :: Nat -> Int -> (Int, Bool);
root_int_main p n =
  (if equal_nat p zero_nat then (one_int, equal_int n one_int)
    else let {
           pm = minus_nat p one_nat;
         } in root_int_maina pm (int_of_nat pm) (int_of_nat p) (start_value n p)
                n);

root_int_floor_pos :: Nat -> Int -> Int;
root_int_floor_pos p x =
  (if equal_nat p zero_nat then zero_int else fst (root_int_main p x));

root_nat_floor :: Nat -> Nat -> Int;
root_nat_floor p x = root_int_floor_pos p (int_of_nat x);

sqrt_int :: Int -> [Int];
sqrt_int x =
  (if less_int x zero_int then []
    else (case sqrt_int_main x of {
           (y, True) ->
             (if equal_int y zero_int then [zero_int] else [y, uminus_int y]);
           (_, False) -> [];
         }));

sqrt_nat :: Nat -> [Nat];
sqrt_nat x = map nat (take one_nat (sqrt_int (int_of_nat x)));

dvd :: forall a. (Eq a, Semidom_modulo a) => a -> a -> Bool;
dvd a b = modulo b a == zerob;

prime_product_factor_main :: Nat -> Nat -> Nat -> Nat -> Nat -> (Nat, Nat);
prime_product_factor_main factor_sq factor_pr limit n i =
  (if less_eq_nat i limit && less_eq_nat (nat_of_integer (2 :: Integer)) i
    then (if dvd i n
           then let {
                  na = divide_nat n i;
                } in (if dvd i na
                       then let {
                              nb = divide_nat na i;
                            } in prime_product_factor_main
                                   (times_nat factor_sq i) factor_pr
                                   (nat (root_nat_floor
  (nat_of_integer (3 :: Integer)) nb))
                                   nb i
                       else (case sqrt_nat na of {
                              [] -> prime_product_factor_main factor_sq
                                      (times_nat factor_pr i)
                                      (nat
(root_nat_floor (nat_of_integer (3 :: Integer)) na))
                                      na (suc i);
                              sn : _ ->
                                (times_nat factor_sq sn, times_nat factor_pr i);
                            }))
           else prime_product_factor_main factor_sq factor_pr limit n (suc i))
    else (factor_sq, times_nat factor_pr n));

prime_product_factor :: Nat -> (Nat, Nat);
prime_product_factor n =
  (case sqrt_nat n of {
    [] -> prime_product_factor_main one_nat one_nat
            (nat (root_nat_floor (nat_of_integer (3 :: Integer)) n)) n
            (nat_of_integer (2 :: Integer));
    s : _ -> (s, one_nat);
  });

ma_sqrt :: Mini_alg -> Mini_alg;
ma_sqrt xa =
  Abs_mini_alg
    (case rep_mini_alg xa of {
      (p, (_, _)) ->
        (case quotient_of p of {
          (a, b) ->
            let {
              aa = abs_int (times_int a b);
            } in (case sqrt_int aa of {
                   [] -> (zero_rat, (inverse_rat (of_int b), nat aa));
                   s : _ ->
                     (divide_rat (of_int s) (of_int b), (zero_rat, zero_nat));
                 });
        });
    });

ma_rat :: Mini_alg -> Rat;
ma_rat xa = fst (rep_mini_alg xa);

mau_sqrt :: Mini_alg_unique -> Mini_alg_unique;
mau_sqrt xa =
  Abs_mini_alg_unique
    (case quotient_of (ma_rat (rep_mini_alg_unique xa)) of {
      (a, b) ->
        (case prime_product_factor (nat (times_int (abs_int a) b)) of {
          (sq, fact) ->
            let {
              ma = ma_of_rat
                     (divide_rat (times_rat (of_int (sgn_int a)) (of_nat sq))
                       (of_int b));
            } in ma_times ma (ma_sqrt (ma_of_rat (of_nat fact)));
        });
    });

sqrt :: Real -> Real;
sqrt (Real_of_u r) =
  (if equal_rat (mau_coeff r) zero_rat then Real_of_u (mau_sqrt r)
    else (error :: forall a. String -> (() -> a) -> a)
           "cannot represent sqrt of irrational number"
           (\ _ -> sqrt (Real_of_u r)));

image_filter ::
  forall a b.
    (Ceq a, Ccompare a, Ceq b, Ccompare b,
      Set_impl b) => (a -> Maybe b) -> Set a -> Set b;
image_filter h (RBT_set rbt) =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "Option.image_filter RBT_set: ccompare = None"
        (\ _ -> image_filter h (RBT_set rbt));
    Just _ -> foldb (\ x a -> (case h x of {
                                Nothing -> a;
                                Just y -> inserta y a;
                              }))
                rbt bot_set;
  });
image_filter g (DList_set dxs) =
  (case (ceq :: Maybe (a -> a -> Bool)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "Option.image_filter DList_set: ceq = None"
        (\ _ -> image_filter g (DList_set dxs));
    Just _ -> foldc (\ x a -> (case g x of {
                                Nothing -> a;
                                Just y -> inserta y a;
                              }))
                dxs bot_set;
  });
image_filter f (Set_Monad xs) = Set_Monad (map_filter f xs);

these :: forall a. (Ceq a, Ccompare a, Set_impl a) => Set (Maybe a) -> Set a;
these a = image_filter (\ x -> x) a;

rbt_bulkload :: forall a b. (Compare_order a) => [(a, b)] -> Rbta a b;
rbt_bulkload xs = foldr (\ (a, b) -> rbt_insert a b) xs Empty;

bulkload :: forall a b. (Compare_order a) => [(a, b)] -> Rbt a b;
bulkload xa = RBT (rbt_bulkload xa);

key :: forall a b c. (a, (Term b c, Term b c)) -> Maybe (b, Nat);
key (uu, (Fun f ts, uv)) = Just (f, size_list ts);
key (uw, (Var ux, uy)) = Nothing;

is_emptya :: forall a b. (Ccompare a) => Mapping_rbt a b -> Bool;
is_emptya xa = (case impl_ofb xa of {
                 Empty -> True;
                 Branch _ _ _ _ _ -> False;
               });

exhaustive_fusion ::
  forall a b. (Maybe a -> Maybe a -> Bool) -> Generator a b -> b -> Bool;
exhaustive_fusion proper_interval g s =
  has_next g s &&
    (case next g s of {
      (x, sa) ->
        not (proper_interval Nothing (Just x)) &&
          exhaustive_above_fusion proper_interval g x sa;
    });

is_UNIV :: forall a. (Card_UNIV a, Ceq a, Cproper_interval a) => Set a -> Bool;
is_UNIV (RBT_set rbt) =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "is_UNIV RBT_set: ccompare = None" (\ _ -> is_UNIV (RBT_set rbt));
    Just _ ->
      of_phantom (finite_UNIV :: Phantom a Bool) &&
        exhaustive_fusion cproper_interval rbt_keys_generator (init rbt);
  });
is_UNIV a =
  let {
    aa = of_phantom (card_UNIV :: Phantom a Nat);
    b = card a;
  } in (if less_nat zero_nat aa then equal_nat aa b
         else (if less_nat zero_nat b then False
                else (error :: forall a. String -> (() -> a) -> a)
                       "is_UNIV called on infinite type and set"
                       (\ _ -> is_UNIV a)));

nulla :: forall a. (Ceq a) => Set_dlist a -> Bool;
nulla xa = null (list_of_dlist xa);

is_empty :: forall a. (Card_UNIV a, Ceq a, Cproper_interval a) => Set a -> Bool;
is_empty (Complement a) = is_UNIV a;
is_empty (RBT_set rbt) =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "is_empty RBT_set: ccompare = None" (\ _ -> is_empty (RBT_set rbt));
    Just _ -> is_emptya rbt;
  });
is_empty (DList_set dxs) =
  (case (ceq :: Maybe (a -> a -> Bool)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "is_empty DList_set: ceq = None" (\ _ -> is_empty (DList_set dxs));
    Just _ -> nulla dxs;
  });
is_empty (Set_Monad xs) = null xs;

gelb :: forall a. (Eq a) => (a -> a -> Bool) -> a -> Maybe a -> Bool;
gelb lt c b = (case b of {
                Nothing -> True;
                Just ba -> lt ba c || ba == c;
              });

geub :: forall a. (Eq a) => (a -> a -> Bool) -> a -> Maybe a -> Bool;
geub lt c b = (case b of {
                Nothing -> False;
                Just ba -> lt ba c || ba == c;
              });

gtlb :: forall a b. (a -> b -> Bool) -> b -> Maybe a -> Bool;
gtlb lt c b = (case b of {
                Nothing -> True;
                Just ba -> lt ba c;
              });

leub :: forall a. (Eq a) => (a -> a -> Bool) -> a -> Maybe a -> Bool;
leub lt c b = (case b of {
                Nothing -> True;
                Just ba -> lt c ba || c == ba;
              });

ltlb :: forall a b. (a -> b -> Bool) -> a -> Maybe b -> Bool;
ltlb lt c b = (case b of {
                Nothing -> False;
                Just a -> lt c a;
              });

ltub :: forall a b. (a -> b -> Bool) -> a -> Maybe b -> Bool;
ltub lt c b = (case b of {
                Nothing -> True;
                Just a -> lt c a;
              });

poly :: forall a. Ns_constraint a -> Linear_poly;
poly (LEQ_ns p a) = p;
poly (GEQ_ns p a) = p;

comp_fun_idem_apply :: forall b a. Comp_fun_idem b a -> b -> a -> a;
comp_fun_idem_apply (Abs_comp_fun_idem x) = x;

set_fold_cfi ::
  forall a b. (Ceq a, Ccompare a) => Comp_fun_idem a b -> b -> Set a -> b;
set_fold_cfi f b (RBT_set rbt) =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "set_fold_cfi RBT_set: ccompare = None"
        (\ _ -> set_fold_cfi f b (RBT_set rbt));
    Just _ -> foldb (comp_fun_idem_apply f) rbt b;
  });
set_fold_cfi f b (DList_set dxs) =
  (case (ceq :: Maybe (a -> a -> Bool)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "set_fold_cfi DList_set: ceq = None"
        (\ _ -> set_fold_cfi f b (DList_set dxs));
    Just _ -> foldc (comp_fun_idem_apply f) dxs b;
  });
set_fold_cfi f b (Set_Monad xs) = fold (comp_fun_idem_apply f) xs b;
set_fold_cfi f b (Collect_set p) =
  (error :: forall a. String -> (() -> a) -> a)
    "set_fold_cfi not supported on Collect_set"
    (\ _ -> set_fold_cfi f b (Collect_set p));
set_fold_cfi f b (Complement a) =
  (error :: forall a. String -> (() -> a) -> a)
    "set_fold_cfi not supported on Complement"
    (\ _ -> set_fold_cfi f b (Complement a));

sup_cfi :: forall a. (Lattice a) => Comp_fun_idem a a;
sup_cfi = Abs_comp_fun_idem sup;

sup_seta ::
  forall a.
    (Finite_UNIV a, Cenum a, Ceq a, Cproper_interval a,
      Set_impl a) => Set (Set a) -> Set a;
sup_seta a =
  (if finite a then set_fold_cfi sup_cfi bot_set a
    else (error :: forall a. String -> (() -> a) -> a) "Sup: infinite"
           (\ _ -> sup_seta a));

add_vars_term :: forall a b. Term a b -> [b] -> [b];
add_vars_term (Var x) xs = x : xs;
add_vars_term (Fun uu ts) xs = foldr add_vars_term ts xs;

vars_term_list :: forall a b. Term a b -> [b];
vars_term_list t = add_vars_term t [];

vars_term :: forall a b. (Ceq b, Ccompare b, Set_impl b) => Term a b -> Set b;
vars_term t = set (vars_term_list t);

vars_rule ::
  forall a b. (Ceq b, Ccompare b, Set_impl b) => (Term a b, Term a b) -> Set b;
vars_rule r = sup_set (vars_term (fst r)) (vars_term (snd r));

vars_trs ::
  forall a b.
    (Compare a, Eq a, Finite_UNIV b, Cenum b, Ceq b, Cproper_interval b,
      Compare b, Eq b, Set_impl b) => Set (Term a b, Term a b) -> Set b;
vars_trs r = sup_seta (image vars_rule r);

nat_of_digit :: Char -> Maybe Nat;
nat_of_digit x =
  (if equal_char x char_0x30 then Just zero_nat
    else (if equal_char x char_0x31 then Just one_nat
           else (if equal_char x char_0x32
                  then Just (nat_of_integer (2 :: Integer))
                  else (if equal_char x char_0x33
                         then Just (nat_of_integer (3 :: Integer))
                         else (if equal_char x char_0x34
                                then Just (nat_of_integer (4 :: Integer))
                                else (if equal_char x char_0x35
                                       then Just (nat_of_integer (5 :: Integer))
                                       else (if equal_char x char_0x36
      then Just (nat_of_integer (6 :: Integer))
      else (if equal_char x char_0x37 then Just (nat_of_integer (7 :: Integer))
             else (if equal_char x char_0x38
                    then Just (nat_of_integer (8 :: Integer))
                    else (if equal_char x char_0x39
                           then Just (nat_of_integer (9 :: Integer))
                           else Nothing))))))))));

obind :: forall a b. Maybe a -> (a -> Maybe b) -> Maybe b;
obind opt f = (case opt of {
                Nothing -> Nothing;
                Just a -> f a;
              });

nat_of_string_aux :: Nat -> [Char] -> Maybe Nat;
nat_of_string_aux n [] = Just n;
nat_of_string_aux n (d : s) =
  obind (nat_of_digit d)
    (\ m ->
      nat_of_string_aux
        (plus_nat (times_nat (nat_of_integer (10 :: Integer)) n) m) s);

nat_of_string :: [Char] -> Sum String Nat;
nat_of_string s =
  (case (if null s then Nothing else nat_of_string_aux zero_nat s) of {
    Nothing -> Inl (("cannot convert \"" ++ implode s) ++ "\" to a number");
    Just a -> Inr a;
  });

safe_head :: forall a. [a] -> Maybe a;
safe_head [] = Nothing;
safe_head (x : xs) = Just x;

sbind :: forall a b c. Sum a b -> (b -> Sum a c) -> Sum a c;
sbind su f = (case su of {
               Inl a -> Inl a;
               Inr a -> f a;
             });

int_of_string :: [Char] -> Sum String Int;
int_of_string s =
  (if safe_head s == Just char_0x2D
    then sbind (nat_of_string (tla s)) (\ n -> Inr (uminus_int (int_of_nat n)))
    else sbind (nat_of_string s) (\ n -> Inr (int_of_nat n)));

xml_take_int ::
  forall a.
    (Int ->
      ([Xml], ([([Char], [Char])], (Bool, ([String], [String])))) ->
        Sum_bot (Xml_error String) a) ->
      ([Xml], ([([Char], [Char])], (Bool, ([String], [String])))) ->
        Sum_bot (Xml_error String) a;
xml_take_int p xs =
  (case xs of {
    ([], _) -> xml_error "expecting an integer" xs;
    (XML _ _ _ : _, _) -> xml_error "expecting an integer" xs;
    (XML_text text : xmls, s) -> (case int_of_string text of {
                                   Inl x -> xml_error x xs;
                                   Inr n -> p n (xmls, s);
                                 });
  });

xml_return ::
  forall a.
    a -> ([Xml], ([([Char], [Char])], (Bool, ([String], [String])))) ->
           Sum_bot (Xml_error String) a;
xml_return v x = (case x of {
                   ([], _) -> right v;
                   (_ : _, _) -> xml_error "expecting tag close" x;
                 });

xml_int ::
  String ->
    (Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
      Sum_bot (Xml_error String) Int;
xml_int tag = xml_do tag (xml_take_int xml_return);

xml_take_nat ::
  forall a.
    (Nat ->
      ([Xml], ([([Char], [Char])], (Bool, ([String], [String])))) ->
        Sum_bot (Xml_error String) a) ->
      ([Xml], ([([Char], [Char])], (Bool, ([String], [String])))) ->
        Sum_bot (Xml_error String) a;
xml_take_nat p xs =
  (case xs of {
    ([], _) -> xml_error "expecting a number" xs;
    (XML _ _ _ : _, _) -> xml_error "expecting a number" xs;
    (XML_text text : xmls, s) -> (case nat_of_string text of {
                                   Inl x -> xml_error x xs;
                                   Inr n -> p n (xmls, s);
                                 });
  });

xml_nat ::
  String ->
    (Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
      Sum_bot (Xml_error String) Nat;
xml_nat tag = xml_do tag (xml_take_nat xml_return);

filterb :: forall a b. ((a, b) -> Bool) -> Alist a b -> Alist a b;
filterb xb xc = Alist (filter xb (impl_ofa xc));

prc_nat :: forall a. ((a, Nat) -> Nat) -> (a, Nat) -> (a, Nat) -> (Bool, Bool);
prc_nat pr = (\ f g -> let {
                         pf = pr f;
                         pg = pr g;
                       } in (less_nat pg pf, less_eq_nat pg pf));

fun_of_map :: forall a b. (a -> Maybe b) -> b -> a -> b;
fun_of_map m d a = (case m a of {
                     Nothing -> d;
                     Just b -> b;
                   });

g_list_to_map_rm_basic_ops ::
  forall a b. (Compare_order a) => [(a, b)] -> Rbt a b;
g_list_to_map_rm_basic_ops l =
  foldl (\ m (k, v) -> insert k v m) empty (reverse l);

ceta_map_of :: forall a b. (Compare_order a) => [(a, b)] -> a -> Maybe b;
ceta_map_of ps = lookup (g_list_to_map_rm_basic_ops ps);

prc ::
  forall a.
    (Compare_order a) => [((a, Nat), Nat)] ->
                           (a, Nat) -> (a, Nat) -> (Bool, Bool);
prc pr_list = prc_nat (fun_of_map (ceta_map_of pr_list) zero_nat);

distinct :: forall a. (Eq a) => [a] -> Bool;
distinct [] = True;
distinct (x : xs) = not (membera xs x) && distinct xs;

superset :: forall a. (Eq a) => [a] -> [a] -> Bool;
superset xs = all (membera xs);

add_mset :: forall a. (Eq a) => a -> Multiset a -> Multiset a;
add_mset x (Bag xs) =
  Bag (joina (\ _ (a, b) -> plus_nat a b) (updatea x one_nat emptya) xs);

mset :: forall a. (Eq a) => [a] -> Multiset a;
mset [] = zero_multiset;
mset (a : x) = add_mset a (mset x);

add ::
  forall a b. Partial_object_ext a (Monoid_ext a (Ring_ext a b)) -> a -> a -> a;
add (Partial_object_ext carrier (Monoid_ext mult one (Ring_ext zero add more)))
  = add;

lvars :: [(Nat, Linear_poly)] -> Set Nat;
lvars t = set (map lhs t);

constraint_to_qdelta_constraint :: Constraint -> [Ns_constraint QDelta];
constraint_to_qdelta_constraint (LT l r) =
  [LEQ_ns l (QDelta r (uminus_rat one_rat))];
constraint_to_qdelta_constraint (GT l r) = [GEQ_ns l (QDelta r one_rat)];
constraint_to_qdelta_constraint (LEQ l r) = [LEQ_ns l (QDelta r zero_rat)];
constraint_to_qdelta_constraint (GEQ l r) = [GEQ_ns l (QDelta r zero_rat)];
constraint_to_qdelta_constraint (EQ l r) =
  [LEQ_ns l (QDelta r zero_rat), GEQ_ns l (QDelta r zero_rat)];

i_constraint_to_qdelta_constraint ::
  forall a. (a, Constraint) -> [(a, Ns_constraint QDelta)];
i_constraint_to_qdelta_constraint (i, c) =
  map (\ a -> (i, a)) (constraint_to_qdelta_constraint c);

to_ns :: forall a. [(a, Constraint)] -> [(a, Ns_constraint QDelta)];
to_ns l = concatMap i_constraint_to_qdelta_constraint l;

funas_term ::
  forall a b. (Ceq a, Ccompare a, Set_impl a) => Term a b -> Set (a, Nat);
funas_term (Var uu) = bot_set;
funas_term (Fun f ts) =
  sup_set (inserta (f, size_list ts) bot_set)
    (foldr (sup_set . funas_term) ts bot_set);

funas_rule ::
  forall a b.
    (Ceq a, Ccompare a, Set_impl a) => (Term a b, Term a b) -> Set (a, Nat);
funas_rule r = sup_set (funas_term (fst r)) (funas_term (snd r));

funas_trs ::
  forall a b.
    (Finite_UNIV a, Cenum a, Ceq a, Cproper_interval a, Compare a, Eq a,
      Set_impl a, Compare b, Eq b) => Set (Term a b, Term a b) -> Set (a, Nat);
funas_trs r = sup_seta (image funas_rule r);

unapp :: forall a b. (Eq a) => a -> Term a b -> (Term a b, [Term a b]);
unapp a (Var x) = (Var x, []);
unapp a (Fun f ss) =
  (if f == a && equal_nat (size_list ss) (nat_of_integer (2 :: Integer))
    then (case unapp a (nth ss zero_nat) of {
           (r, ts) -> (r, ts ++ [nth ss one_nat]);
         })
    else (Fun f ss, []));

is_letter :: Char -> Bool;
is_letter c =
  let {
    ci = integer_of_char c;
  } in (97 :: Integer) <= ci && ci <= (122 :: Integer) ||
         ((65 :: Integer) <= ci && ci <= (90 :: Integer) ||
           ((48 :: Integer) <= ci && ci <= (59 :: Integer) ||
             (ci == (95 :: Integer) ||
               (ci == (38 :: Integer) || ci == (45 :: Integer)))));

update_tokens :: forall a. ([a] -> [a]) -> [a] -> Sum [Char] ([a], [a]);
update_tokens f ts = Inr (ts, f ts);

char_0x3C :: Char;
char_0x3C = Chr (60 :: Integer);

char_0x21 :: Char;
char_0x21 = Chr (33 :: Integer);

comment_error :: () -> [Char];
comment_error x =
  (error :: forall a. String -> (() -> a) -> a) "comment not terminated"
    (\ _ -> []);

comment_error_hyphen :: () -> [Char];
comment_error_hyphen x =
  (error :: forall a. String -> (() -> a) -> a) "double hyphen within comment"
    (\ _ -> []);

rc_open_1 :: [Char] -> [Char];
rc_open_1 [] = [];
rc_open_1 (c : cs) =
  (if integer_of_char c == (60 :: Integer) then rc_open_2 cs
    else c : rc_open_1 cs);

rc_close_3 :: [Char] -> [Char];
rc_close_3 [] = comment_error ();
rc_close_3 (c : cs) =
  (if integer_of_char c == (62 :: Integer) then rc_open_1 cs
    else comment_error_hyphen ());

rc_close_2 :: [Char] -> [Char];
rc_close_2 [] = comment_error ();
rc_close_2 (c : cs) =
  (if integer_of_char c == (45 :: Integer) then rc_close_3 cs
    else rc_close_1 cs);

rc_close_1 :: [Char] -> [Char];
rc_close_1 [] = comment_error ();
rc_close_1 (c : cs) =
  (if integer_of_char c == (45 :: Integer) then rc_close_2 cs
    else rc_close_1 cs);

rc_open_4 :: [Char] -> [Char];
rc_open_4 [] = [char_0x3C, char_0x21, char_0x2D];
rc_open_4 (c : cs) =
  let {
    ic = integer_of_char c;
  } in (if ic == (45 :: Integer) then rc_close_1 cs
         else (if ic == (60 :: Integer)
                then c : char_0x21 : char_0x2D : rc_open_2 cs
                else char_0x3C : char_0x21 : char_0x2D : c : rc_open_1 cs));

rc_open_3 :: [Char] -> [Char];
rc_open_3 [] = [char_0x3C, char_0x21];
rc_open_3 (c : cs) =
  let {
    ic = integer_of_char c;
  } in (if ic == (45 :: Integer) then rc_open_4 cs
         else (if ic == (60 :: Integer) then c : char_0x21 : rc_open_2 cs
                else char_0x3C : char_0x21 : c : rc_open_1 cs));

rc_open_2 :: [Char] -> [Char];
rc_open_2 [] = [char_0x3C];
rc_open_2 (c : cs) =
  let {
    ic = integer_of_char c;
  } in (if ic == (33 :: Integer) then rc_open_3 cs
         else (if ic == (60 :: Integer) then c : rc_open_2 cs
                else char_0x3C : c : rc_open_1 cs));

remove_comments :: [Char] -> [Char];
remove_comments xs = rc_open_1 xs;

returnb :: forall a b. a -> [b] -> Sum [Char] (a, [b]);
returnb x = (\ ts -> Inr (x, ts));

bindb :: forall a b c. Sum a b -> (b -> Sum a c) -> Sum a c;
bindb m f = (case m of {
              Inl a -> Inl a;
              Inr a -> f a;
            });

bindc ::
  forall a b c.
    ([a] -> Sum [Char] (b, [a])) ->
      (b -> [a] -> Sum [Char] (c, [a])) -> [a] -> Sum [Char] (c, [a]);
bindc m f ts = bindb (m ts) (\ (a, b) -> f a b);

char_0x3F :: Char;
char_0x3F = Chr (63 :: Integer);

char_0x3E :: Char;
char_0x3E = Chr (62 :: Integer);

char_0x20 :: Char;
char_0x20 = Chr (32 :: Integer);

char_0x27 :: Char;
char_0x27 = Chr (39 :: Integer);

shows_quote :: ([Char] -> [Char]) -> [Char] -> [Char];
shows_quote s =
  (shows_prec_char zero_nat char_0x27 . s) . shows_prec_char zero_nat char_0x27;

scan_upto :: [Char] -> [Char] -> Sum [Char] ([Char], [Char]);
scan_upto end (t : ts) =
  (if map snd (zip end (t : ts)) == end
    then Inr (end, drop (size_list end) (t : ts))
    else bindb (scan_upto end ts) (\ (res, tsa) -> Inr (t : res, tsa)));
scan_upto end [] =
  Inl ([char_0x64, char_0x69, char_0x64, char_0x20, char_0x6E, char_0x6F,
         char_0x74, char_0x20, char_0x66, char_0x69, char_0x6E, char_0x64,
         char_0x20, char_0x65, char_0x6E, char_0x64, char_0x2D, char_0x6D,
         char_0x61, char_0x72, char_0x6B, char_0x65, char_0x72, char_0x20] ++
        shows_quote (shows_prec_list zero_nat end) []);

trim :: [Char] -> [Char];
trim =
  dropWhile
    (\ c ->
      let {
        ci = integer_of_char c;
      } in (if (34 :: Integer) <= ci then False
             else ci == (32 :: Integer) ||
                    (ci == (10 :: Integer) ||
                      (ci == (9 :: Integer) || ci == (13 :: Integer)))));

spaces :: [Char] -> Sum [Char] ((), [Char]);
spaces cs = Inr ((), trim cs);

parse_header :: [Char] -> Sum [Char] ([[Char]], [Char]);
parse_header ts =
  (if take (nat_of_integer (2 :: Integer)) (trim ts) == [char_0x3C, char_0x3F]
    then bindc (scan_upto [char_0x3F, char_0x3E])
           (\ h -> bindc parse_header (\ hs -> returnb (h : hs))) ts
    else bindc spaces (\ _ -> returnb []) ts);

char_0x2C :: Char;
char_0x2C = Chr (44 :: Integer);

err_expecting :: forall a b. (Showa a) => [Char] -> [a] -> Sum [Char] (b, [a]);
err_expecting msg ts =
  Inl ([char_0x65, char_0x78, char_0x70, char_0x65, char_0x63, char_0x74,
         char_0x69, char_0x6E, char_0x67, char_0x20] ++
        msg ++
          [char_0x2C, char_0x20, char_0x62, char_0x75, char_0x74, char_0x20,
            char_0x66, char_0x6F, char_0x75, char_0x6E, char_0x64, char_0x3A,
            char_0x20] ++
            shows_quote
              (shows_prec_list zero_nat
                (take (nat_of_integer (30 :: Integer)) ts))
              []);

eoi :: forall a. (Showa a) => [a] -> Sum [Char] ((), [a]);
eoi [] = Inr ((), []);
eoi (v : va) =
  err_expecting
    [char_0x65, char_0x6E, char_0x64, char_0x20, char_0x6F, char_0x66,
      char_0x20, char_0x69, char_0x6E, char_0x70, char_0x75, char_0x74]
    (v : va);

char_0x3D :: Char;
char_0x3D = Chr (61 :: Integer);

char_0x22 :: Char;
char_0x22 = Chr (34 :: Integer);

exactly_aux ::
  [Char] -> [Char] -> [Char] -> [Char] -> Sum [Char] ([Char], [Char]);
exactly_aux s i (x : xs) (y : ys) =
  (if equal_char x y then exactly_aux s i xs ys
    else err_expecting ([char_0x22] ++ s ++ [char_0x22]) i);
exactly_aux s i [] xs = Inr (s, trim xs);
exactly_aux s i (x : xs) [] = err_expecting ([char_0x22] ++ s ++ [char_0x22]) i;

exactly :: [Char] -> [Char] -> Sum [Char] ([Char], [Char]);
exactly s x = exactly_aux s x s x;

many :: (Char -> Bool) -> [Char] -> Sum [Char] ([Char], [Char]);
many p (t : ts) =
  (if p t then bindb (many p ts) (\ (rs, tsa) -> Inr (t : rs, tsa))
    else Inr ([], t : ts));
many p [] = Inr ([], []);

parse_attribute_value :: [Char] -> Sum [Char] ([Char], [Char]);
parse_attribute_value =
  bindc (exactly [char_0x22])
    (\ _ ->
      bindc (many (\ y -> not (equal_char char_0x22 y)))
        (\ v -> bindc (exactly [char_0x22]) (\ _ -> returnb v)));

many_letters_main :: [Char] -> ([Char], [Char]);
many_letters_main [] = ([], []);
many_letters_main (c : cs) =
  (if is_letter c then (case many_letters_main cs of {
                         (ds, a) -> (c : ds, a);
                       })
    else ([], c : cs));

parse_name :: [Char] -> Sum [Char] ([Char], [Char]);
parse_name s =
  (case many_letters_main s of {
    (n, ts) ->
      (if null n
        then Inl ([char_0x65, char_0x78, char_0x70, char_0x65, char_0x63,
                    char_0x74, char_0x65, char_0x64, char_0x20, char_0x6C,
                    char_0x65, char_0x74, char_0x74, char_0x65, char_0x72,
                    char_0x20] ++
                   letters ++
                     [char_0x20, char_0x62, char_0x75, char_0x74, char_0x20,
                       char_0x66, char_0x69, char_0x72, char_0x73, char_0x74,
                       char_0x20, char_0x73, char_0x79, char_0x6D, char_0x62,
                       char_0x6F, char_0x6C, char_0x20, char_0x69, char_0x73,
                       char_0x20, char_0x22] ++
                       take one_nat s ++ [char_0x22])
        else Inr (n, trim ts));
  });

parse_attributes :: [Char] -> Sum [Char] ([([Char], [Char])], [Char]);
parse_attributes [] = Inr ([], []);
parse_attributes (c : s) =
  let {
    ic = integer_of_char c;
  } in (if ic == (47 :: Integer) || ic == (62 :: Integer) then Inr ([], c : s)
         else bindc parse_name
                (\ k ->
                  bindc (exactly [char_0x3D])
                    (\ _ ->
                      bindc parse_attribute_value
                        (\ v ->
                          bindc parse_attributes
                            (\ atts -> returnb ((k, v) : atts)))))
                (c : s));

char_0x5D :: Char;
char_0x5D = Chr (93 :: Integer);

char_0x5B :: Char;
char_0x5B = Chr (91 :: Integer);

oneof_closed :: [Char] -> Sum [Char] ([Char], [Char]);
oneof_closed (x : xs) =
  (if equal_char x char_0x3E then Inr ([char_0x3E], trim xs)
    else (if equal_char x char_0x2F && (case xs of {
 [] -> False;
 y : _ -> equal_char y char_0x3E;
                                       })
           then Inr ([char_0x2F, char_0x3E], trim (tla xs))
           else err_expecting
                  [char_0x6F, char_0x6E, char_0x65, char_0x20, char_0x6F,
                    char_0x66, char_0x20, char_0x5B, char_0x2F, char_0x3E,
                    char_0x2C, char_0x20, char_0x3E, char_0x5D]
                  (x : xs)));
oneof_closed [] =
  err_expecting
    [char_0x6F, char_0x6E, char_0x65, char_0x20, char_0x6F, char_0x66,
      char_0x20, char_0x5B, char_0x2F, char_0x3E, char_0x2C, char_0x20,
      char_0x3E, char_0x5D]
    [];

parse_text_main :: [Char] -> [Char] -> ([Char], [Char]);
parse_text_main [] res = ([], reverse (trim res));
parse_text_main (c : cs) res =
  (if integer_of_char c == (60 :: Integer) then (c : cs, reverse (trim res))
    else parse_text_main cs (c : res));

parse_text_impl :: forall a. [Char] -> Sum a (Maybe [Char], [Char]);
parse_text_impl cs =
  (case parse_text_main (trim cs) [] of {
    (rem, txt) ->
      (if null txt then Inr (Nothing, rem) else Inr (Just txt, rem));
  });

parse_text :: [Char] -> Sum [Char] (Maybe [Char], [Char]);
parse_text cs = parse_text_impl cs;

parse_nodes :: [Char] -> Sum [Char] ([Xml], [Char]);
parse_nodes ts =
  (if null ts ||
        take (nat_of_integer (2 :: Integer)) ts == [char_0x3C, char_0x2F]
    then returnb [] ts
    else (if not (equal_char (hda ts) char_0x3C)
           then bindc parse_text
                  (\ t ->
                    bindc parse_nodes (\ ns -> returnb (XML_text (the t) : ns)))
                  ts
           else bindc (exactly [char_0x3C])
                  (\ _ ->
                    bindc parse_name
                      (\ n ->
                        bindc parse_attributes
                          (\ atts ->
                            bindc oneof_closed
                              (\ e ->
                                (if e == [char_0x2F, char_0x3E]
                                  then bindc parse_nodes
 (\ cs -> returnb (XML n atts [] : cs))
                                  else bindc parse_nodes
 (\ cs ->
   bindc (exactly [char_0x3C, char_0x2F])
     (\ _ ->
       bindc (exactly n)
         (\ _ ->
           bindc (exactly [char_0x3E])
             (\ _ ->
               bindc parse_nodes (\ ns -> returnb (XML n atts cs : ns)))))))))))
                  ts));

parse_node :: [Char] -> Sum [Char] (Xml, [Char]);
parse_node =
  bindc (exactly [char_0x3C])
    (\ _ ->
      bindc parse_name
        (\ n ->
          bindc parse_attributes
            (\ atts ->
              bindc oneof_closed
                (\ e ->
                  (if e == [char_0x2F, char_0x3E] then returnb (XML n atts [])
                    else bindc parse_nodes
                           (\ cs ->
                             bindc (exactly [char_0x3C, char_0x2F])
                               (\ _ ->
                                 bindc (exactly n)
                                   (\ _ ->
                                     bindc (exactly [char_0x3E])
                                       (\ _ -> returnb (XML n atts cs))))))))));

parse_doc :: [Char] -> Sum [Char] (Xmldoc, [Char]);
parse_doc =
  bindc (update_tokens remove_comments)
    (\ _ ->
      bindc parse_header
        (\ h ->
          bindc parse_node
            (\ xml -> bindc eoi (\ _ -> returnb (XMLDOC h xml)))));

bool_of_string :: [Char] -> Sum String Bool;
bool_of_string s =
  (if s == [char_0x74, char_0x72, char_0x75, char_0x65] then Inr True
    else (if s == [char_0x66, char_0x61, char_0x6C, char_0x73, char_0x65]
           then Inr False
           else Inl (("cannot convert \"" ++ implode s) ++ "\" into Boolean")));

xml_take_text ::
  forall a.
    ([Char] ->
      ([Xml], ([([Char], [Char])], (Bool, ([String], [String])))) ->
        Sum_bot (Xml_error String) a) ->
      ([Xml], ([([Char], [Char])], (Bool, ([String], [String])))) ->
        Sum_bot (Xml_error String) a;
xml_take_text p xs = (case xs of {
                       ([], _) -> xml_error "expecting a text" xs;
                       (XML _ _ _ : _, _) -> xml_error "expecting a text" xs;
                       (XML_text text : xmls, s) -> p text (xmls, s);
                     });

xml_text ::
  String ->
    (Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
      Sum_bot (Xml_error String) [Char];
xml_text tag = xml_do tag (xml_take_text xml_return);

xml_bool ::
  String ->
    (Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
      Sum_bot (Xml_error String) Bool;
xml_bool tag x =
  bind2 (xml_text tag x) left
    (\ str -> (case bool_of_string str of {
                Inl err -> xml_error err ([fst x], snd x);
                Inr a -> right a;
              }));

xml_leaf ::
  forall a.
    String ->
      a -> (Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
             Sum_bot (Xml_error String) a;
xml_leaf tag ret = xml_do tag (xml_return ret);

xml_take ::
  forall a b.
    ((Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
      Sum_bot (Xml_error String) a) ->
      (a -> ([Xml], ([([Char], [Char])], (Bool, ([String], [String])))) ->
              Sum_bot (Xml_error String) b) ->
        ([Xml], ([([Char], [Char])], (Bool, ([String], [String])))) ->
          Sum_bot (Xml_error String) b;
xml_take p1 p2 x =
  (case x of {
    ([], rest) ->
      bind2 (p1 (XML [] [] [], rest)) left (\ _ -> left (Fatal "unexpected"));
    (xa : xs, (atts, (flag, (cands, rest)))) ->
      bind2 (p1 (xa, (atts, (flag, (cands, rest))))) left
        (\ a -> p2 a (xs, (atts, (False, ([], rest)))));
  });

gt1 ::
  forall a b c d. [(Term a b, Term c d)] -> [(Maybe (a, Nat), Maybe (c, Nat))];
gt1 = map (\ (s, t) -> (root s, root t));

map_term :: forall a b c d. (a -> b) -> (c -> d) -> Term a c -> Term b d;
map_term f1 f2 (Var x1) = Var (f2 x1);
map_term f1 f2 (Fun x21 x22) = Fun (f1 x21) (map (map_term f1 f2) x22);

class_to_term_intern ::
  forall a b. (Nat -> a) -> Nat -> Term b (Sum () a) -> (Nat, Term b a);
class_to_term_intern iv i (Fun f ts) =
  (case foldr (\ t (j, ss) -> (case class_to_term_intern iv j t of {
                                (k, s) -> (k, s : ss);
                              }))
          ts (i, [])
    of {
    (k, ss) -> (k, Fun f ss);
  });
class_to_term_intern iv i (Var (Inl uu)) = (plus_nat i one_nat, Var (iv i));
class_to_term_intern iv i (Var (Inr x)) = (i, Var x);

class_to_term :: forall a. Char -> Term a (Sum () [Char]) -> Term a [Char];
class_to_term c t =
  snd (class_to_term_intern (\ i -> c : shows_prec_nat zero_nat i []) zero_nat
        t);

eval_term :: forall a b c. (a -> [b] -> b) -> Term a c -> (c -> b) -> b;
eval_term i (Var x) alpha = alpha x;
eval_term i (Fun f ss) alpha = i f (map (\ s -> eval_term i s alpha) ss);

eval_subst ::
  forall a b c d. (a -> [b] -> b) -> (c -> Term a d) -> (d -> b) -> c -> b;
eval_subst i theta alpha = (\ x -> eval_term i (theta x) alpha);

subst_of :: forall a b. (Eq a) => [(a, Term b a)] -> a -> Term b a;
subst_of ss = foldr (\ (x, t) sigma -> eval_subst Fun sigma (subst x t)) ss Var;

contains_var_term :: forall a b. (Eq a) => a -> Term b a -> Bool;
contains_var_term x (Var y) = x == y;
contains_var_term x (Fun uu ts) = any (contains_var_term x) ts;

subst_list ::
  forall a b.
    (a -> Term b a) -> [(Term b a, Term b a)] -> [(Term b a, Term b a)];
subst_list sigma ys =
  map (\ p -> (eval_term Fun (fst p) sigma, eval_term Fun (snd p) sigma)) ys;

decompose ::
  forall a b c. (Eq a) => Term a b -> Term a c -> Maybe [(Term a b, Term a c)];
decompose s t =
  (case (s, t) of {
    (Var _, _) -> Nothing;
    (Fun _ _, Var _) -> Nothing;
    (Fun f ss, Fun g ts) -> (if f == g then zip_option ss ts else Nothing);
  });

unify ::
  forall a b.
    (Eq a,
      Eq b) => [(Term a b, Term a b)] ->
                 [(b, Term a b)] -> Maybe [(b, Term a b)];
unify [] bs = Just bs;
unify ((Fun f ss, Fun g ts) : e) bs =
  (case decompose (Fun f ss) (Fun g ts) of {
    Nothing -> Nothing;
    Just us -> unify (us ++ e) bs;
  });
unify ((Var x, t) : e) bs =
  (if equal_term t (Var x) then unify e bs
    else (if contains_var_term x t then Nothing
           else unify (subst_list (subst x t) e) ((x, t) : bs)));
unify ((Fun v va, Var x) : e) bs =
  (if contains_var_term x (Fun v va) then Nothing
    else unify (subst_list (subst x (Fun v va)) e) ((x, Fun v va) : bs));

mgu ::
  forall a b. (Eq a, Eq b) => Term a b -> Term a b -> Maybe (b -> Term a b);
mgu s t = (case unify [(s, t)] [] of {
            Nothing -> Nothing;
            Just res -> Just (subst_of res);
          });

mgu_class ::
  forall a.
    (Eq a) => Term a (Sum () [Char]) ->
                Term a [Char] -> Maybe ([Char] -> Term a [Char]);
mgu_class cs t =
  mgu (class_to_term char_0x7A cs)
    (map_term (\ x -> x) (\ a -> char_0x79 : a) t);

enumerate :: forall a. Nat -> [a] -> [(Nat, a)];
enumerate n [] = [];
enumerate n (x : xs) = (n, x) : enumerate (suc n) xs;

partition :: forall a. (a -> Bool) -> [a] -> ([a], [a]);
partition p [] = ([], []);
partition p (x : xs) =
  (case partition p xs of {
    (yes, no) -> (if p x then (x : yes, no) else (yes, x : no));
  });

removeAll :: forall a. (Eq a) => a -> [a] -> [a];
removeAll x [] = [];
removeAll x (y : xs) = (if x == y then removeAll x xs else y : removeAll x xs);

delete_aux :: forall a b. (Eq a) => a -> [(a, b)] -> [(a, b)];
delete_aux k [] = [];
delete_aux ka ((k, v) : xs) =
  (if ka == k then xs else (k, v) : delete_aux ka xs);

deleteb :: forall a b. (Eq a) => a -> Alist a b -> Alist a b;
deleteb xb xc = Alist (delete_aux xb (impl_ofa xc));

deletea :: forall a b. (Ccompare a, Eq a) => a -> Mapping a b -> Mapping a b;
deletea k (RBT_Mapping t) =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "delete RBT_Mapping: ccompare = None"
        (\ _ -> deletea k (RBT_Mapping t));
    Just _ -> RBT_Mapping (deletec k t);
  });
deletea k (Assoc_List_Mapping al) = Assoc_List_Mapping (deleteb k al);
deletea k (Mapping m) = Mapping (fun_upd m k Nothing);

match_term_list_code ::
  forall a b c.
    (Eq a, Ccompare b, Eq b,
      Eq c) => [(Term a b, Term a c)] ->
                 Mapping b (Term a c) -> Maybe (Mapping b (Term a c));
match_term_list_code [] sigma = Just sigma;
match_term_list_code ((Var x, t) : p) sigma =
  (if is_none (lookupb sigma x) || lookupb sigma x == Just t
    then match_term_list_code p (updateb x t sigma) else Nothing);
match_term_list_code ((Fun f ss, Fun g ts) : p) sigma =
  (case decompose (Fun f ss) (Fun g ts) of {
    Nothing -> Nothing;
    Just us -> match_term_list_code (us ++ p) sigma;
  });
match_term_list_code ((Fun f ss, Var x) : p) sigma = Nothing;

subst_of_map :: forall a b. (a -> b) -> (a -> Maybe b) -> a -> b;
subst_of_map d sigma x = (case sigma x of {
                           Nothing -> d x;
                           Just t -> t;
                         });

map_option :: forall a b. (a -> b) -> Maybe a -> Maybe b;
map_option f Nothing = Nothing;
map_option f (Just x2) = Just (f x2);

match_list ::
  forall a b c.
    (Ccompare a, Eq a, Mapping_impl a, Eq b,
      Eq c) => (a -> Term b c) ->
                 [(Term b a, Term b c)] -> Maybe (a -> Term b c);
match_list d p =
  map_option (subst_of_map d . lookupb) (match_term_list_code p emptyb);

match ::
  forall a b.
    (Eq a, Ccompare b, Eq b,
      Mapping_impl b) => Term a b -> Term a b -> Maybe (b -> Term a b);
match t l = match_list Var [(l, t)];

rep_vec_impl :: forall a. Vec_impl a -> (Nat, IArray.IArray a);
rep_vec_impl (Abs_vec_impl x) = x;

dim_vec_impl :: forall a. Vec_impl a -> Nat;
dim_vec_impl xa = fst (rep_vec_impl xa);

dim_vec :: forall a. Vec a -> Nat;
dim_vec (Vec_impl v) = dim_vec_impl v;

map_mat :: forall a b. (a -> b) -> Mat a -> Mat b;
map_mat f a = mat (dim_row a) (dim_col a) (\ ij -> f (index_mat a ij));

one_mat :: forall a. (One a, Zero a) => Nat -> Mat a;
one_mat n = mat n n (\ (i, j) -> (if equal_nat i j then onea else zerob));

sum_list :: forall a. (Monoid_add a) => [a] -> a;
sum_list xs = foldr plus xs zerob;

interval :: forall a. (Eq a, Interval a) => a -> a -> [a];
interval a b =
  (if less a b then a : interval (plus a onea) b
    else (if a == b then [a] else []));

vec_index_impl :: forall a. Vec_impl a -> Nat -> a;
vec_index_impl xa = (case rep_vec_impl xa of {
                      (_, a) -> sub a;
                    });

vec_index :: forall a. Vec a -> Nat -> a;
vec_index (Vec_impl v) i = vec_index_impl v i;

scalar_prod :: forall a. (Semiring_0 a) => Vec a -> Vec a -> a;
scalar_prod v w =
  let {
    d = minus_nat (dim_vec w) one_nat;
  } in (if less_nat d (dim_vec w)
         then sum_list
                (map (\ i -> times (vec_index v i) (vec_index w i))
                  (interval zero_nat d))
         else zerob);

times_mat :: forall a. (Semiring_0 a) => Mat a -> Mat a -> Mat a;
times_mat a b =
  mat (dim_row a) (dim_col b) (\ (i, j) -> scalar_prod (row a i) (col b j));

pow_mat :: forall a. (Semiring_1 a) => Mat a -> Nat -> Mat a;
pow_mat a k =
  (if equal_nat k zero_nat then one_mat (dim_row a)
    else times_mat (pow_mat a (minus_nat k one_nat)) a);

rBT_Impl_fold1 :: forall a. (a -> a -> a) -> Rbta a () -> a;
rBT_Impl_fold1 f Empty = error "undefined";
rBT_Impl_fold1 f (Branch c Empty k v r) = folda (\ ka _ -> f ka) r k;
rBT_Impl_fold1 f (Branch ca (Branch c l ka va ra) k v r) =
  folda (\ kb _ -> f kb) r (f k (rBT_Impl_fold1 f (Branch c l ka va ra)));

fold1 :: forall a. (Ccompare a) => (a -> a -> a) -> Mapping_rbt a () -> a;
fold1 x xc = rBT_Impl_fold1 x (impl_ofb xc);

filter_comp_minus ::
  forall a b c. (a -> a -> Ordera) -> Rbta a b -> Rbta a c -> [(a, b)];
filter_comp_minus c t1 t2 =
  filter (\ (k, _) -> is_none (rbt_comp_lookup c t2 k)) (entriesa t1);

comp_minus ::
  forall a b. (a -> a -> Ordera) -> Rbta a b -> Rbta a b -> Rbta a b;
comp_minus c t1 t2 =
  (if small_rbt t2 then folda (\ k _ -> rbt_comp_delete c k) t2 t1
    else (if small_rbt t1 then rbtreeify (filter_comp_minus c t1 t2)
           else (case t2 of {
                  Empty -> t1;
                  Branch _ l2 a _ r2 ->
                    (case rbt_split_comp c t1 a of {
                      (l1, (_, r1)) ->
                        rbt_join2 (comp_minus c l1 l2) (comp_minus c r1 r2);
                    });
                })));

rbt_comp_minus ::
  forall a b. (a -> a -> Ordera) -> Rbta a b -> Rbta a b -> Rbta a b;
rbt_comp_minus c t1 t2 = paint B (comp_minus c t1 t2);

minus ::
  forall a.
    (Ccompare a) => Mapping_rbt a () -> Mapping_rbt a () -> Mapping_rbt a ();
minus xb xc =
  Mapping_RBTa (rbt_comp_minus (the ccompare) (impl_ofb xb) (impl_ofb xc));

imagea ::
  forall a b.
    (Ceq a, Ccompare a, Ceq b, Ccompare b,
      Set_impl b) => Set (a, b) -> Set a -> Set b;
imagea (RBT_set rbt) c =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "Image RBT_set: ccompare1 = None" (\ _ -> imagea (RBT_set rbt) c);
    Just _ ->
      (case (ccompare :: Maybe (b -> b -> Ordera)) of {
        Nothing ->
          (error :: forall a. String -> (() -> a) -> a)
            "Image RBT_set: ccompare2 = None" (\ _ -> imagea (RBT_set rbt) c);
        Just _ ->
          foldb (\ (x, y) acc -> (if member x c then inserta y acc else acc))
            rbt bot_set;
      });
  });
imagea (DList_set dxs) b =
  (case (ceq :: Maybe (a -> a -> Bool)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "Image DList_set: ceq1 = None" (\ _ -> imagea (DList_set dxs) b);
    Just _ ->
      (case (ceq :: Maybe (b -> b -> Bool)) of {
        Nothing ->
          (error :: forall a. String -> (() -> a) -> a)
            "Image DList_set: ceq2 = None" (\ _ -> imagea (DList_set dxs) b);
        Just _ ->
          foldc (\ (x, y) acc -> (if member x b then inserta y acc else acc))
            dxs bot_set;
      });
  });
imagea (Set_Monad rxs) a =
  Set_Monad
    (fold (\ (x, y) rest -> (if member x a then y : rest else rest)) rxs []);
imagea x y = image snd (filtera (\ (xa, _) -> member xa y) x);

zero :: forall a b. Partial_object_ext a (Monoid_ext a (Ring_ext a b)) -> a;
zero (Partial_object_ext carrier (Monoid_ext mult one (Ring_ext zero add more)))
  = zero;

b_i_l :: forall a b. State a b -> Mapping Nat (a, b);
b_i_l (State x1 x2 x3 x4 x5 x6) = x2;

indexl :: forall a b. State a b -> Nat -> a;
indexl s = (fst . the) . lookupb (b_i_l s);

b_i_u :: forall a b. State a b -> Mapping Nat (a, b);
b_i_u (State x1 x2 x3 x4 x5 x6) = x3;

indexu :: forall a b. State a b -> Nat -> a;
indexu s = (fst . the) . lookupb (b_i_u s);

args :: forall a b. Term a b -> [Term a b];
args (Var x1) = [];
args (Fun x21 x22) = x22;

aarity :: forall a. (a -> Nat -> [a]) -> a -> Nat -> Nat;
aarity sm f n = minus_nat (size_list (sm f n)) one_nat;

xml_error_to_string :: Xml_error String -> [Char];
xml_error_to_string (Fatal e) = explode ("Fatal: " ++ e);
xml_error_to_string (TagMismatch e) =
  explode ("tag mismatch: " ++ default_showsl_list showsl_lit e "");

parse_xml ::
  forall a.
    ((Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
      Sum_bot (Xml_error String) a) ->
      Xml -> Sum_bot [Char] a;
parse_xml p xml =
  bind2 (xml_take p xml_return ([xml], ([], (False, ([], [])))))
    (left . xml_error_to_string) right;

xml_foldl ::
  forall a b.
    (a -> (Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
            Sum_bot (Xml_error String) b) ->
      (a -> b -> a) ->
        a -> ([Xml], ([([Char], [Char])], (Bool, ([String], [String])))) ->
               Sum_bot (Xml_error String) a;
xml_foldl p f a xs =
  (case xs of {
    ([], _) -> right a;
    (_ : _, _) -> xml_take (p a) (\ b -> xml_foldl p f (f a b)) xs;
  });

map_entry :: forall a b. (Eq a) => a -> (b -> b) -> [(a, b)] -> [(a, b)];
map_entry k f [] = [];
map_entry k f (p : ps) =
  (if fst p == k then (k, f (snd p)) : ps else p : map_entry k f ps);

trivial_mute_fun :: forall a. (Comm_ring_1 a) => a -> a -> (a, (a, a));
trivial_mute_fun x y = (x, (y, onea));

fst_sel_fun :: forall a. [(Nat, a)] -> Nat;
fst_sel_fun x = fst (hda x);

prod_list :: forall a. (Monoid_mult a) => [a] -> a;
prod_list xs = foldr times xs onea;

list_update :: forall a. [a] -> Nat -> a -> [a];
list_update [] i y = [];
list_update (x : xs) i y =
  (if equal_nat i zero_nat then y : xs
    else x : list_update xs (minus_nat i one_nat) y);

mat_swaprows_impl :: forall a. Nat -> Nat -> Mat_impl a -> Mat_impl a;
mat_swaprows_impl xc xd xe =
  Abs_mat_impl
    (case rep_mat_impl xe of {
      (nr, (nc, a)) ->
        (if less_nat xc nr && less_nat xd nr
          then let {
                 ai = sub a xc;
                 aj = sub a xd;
                 arows = list_of a;
                 aa = IArray.of_list
                        (list_update (list_update arows xc aj) xd ai);
               } in (nr, (nc, aa))
          else (nr, (nc, a)));
    });

mat_swaprows :: forall a. Nat -> Nat -> Mat a -> Mat a;
mat_swaprows k l (Mat_impl a) =
  let {
    nr = dim_row_impl a;
  } in (if less_nat l nr && less_nat k nr
         then Mat_impl (mat_swaprows_impl k l a)
         else (error :: forall a. String -> (() -> a) -> a)
                "index out of bounds in mat_swaprows"
                (\ _ -> mat_swaprows k l (Mat_impl a)));

find_non0 ::
  forall a.
    (Eq a, Idom_divide a) => ([(Nat, a)] -> Nat) -> Nat -> Mat a -> Maybe Nat;
find_non0 sel_fun l a =
  let {
    is = upt (suc l) (dim_row a);
    ais = filter (\ (_, ail) -> not (ail == zerob))
            (map (\ i -> (i, index_mat a (i, l))) is);
  } in (case ais of {
         [] -> Nothing;
         _ : _ -> Just (sel_fun ais);
       });

mat_multrow_gen_impl ::
  forall a. (a -> a -> a) -> Nat -> a -> Mat_impl a -> Mat_impl a;
mat_multrow_gen_impl xc xd xe xf =
  Abs_mat_impl
    (case rep_mat_impl xf of {
      (nr, (nc, a)) -> let {
                         ak = sub a xd;
                         arows = list_of a;
                         aka = IArray.of_list (map (xc xe) (list_of ak));
                         aa = IArray.of_list (list_update arows xd aka);
                       } in (nr, (nc, aa));
    });

mat_multrow_gen :: forall a. (a -> a -> a) -> Nat -> a -> Mat a -> Mat a;
mat_multrow_gen mul k aa (Mat_impl a) =
  Mat_impl (mat_multrow_gen_impl mul k aa a);

mat_addrow_gen_impl ::
  forall a.
    (a -> a -> a) ->
      (a -> a -> a) -> a -> Nat -> Nat -> Mat_impl a -> Mat_impl a;
mat_addrow_gen_impl xd xe xf xh xi xj =
  Abs_mat_impl
    (case rep_mat_impl xj of {
      (nr, (nc, a)) ->
        (if less_nat xi nr
          then let {
                 ak = sub a xh;
                 al = sub a xi;
                 aka = of_fun (\ i -> xd (xe xf (sub al i)) (sub ak i))
                         (min (length ak) (length al));
                 aa = of_fun (\ i -> (if equal_nat i xh then aka else sub a i))
                        (length a);
               } in (nr, (nc, aa))
          else (nr, (nc, a)));
    });

mat_addrow_gen ::
  forall a. (a -> a -> a) -> (a -> a -> a) -> a -> Nat -> Nat -> Mat a -> Mat a;
mat_addrow_gen ad mul aa k l (Mat_impl a) =
  (if less_nat l (dim_row_impl a)
    then Mat_impl (mat_addrow_gen_impl ad mul aa k l a)
    else (error :: forall a. String -> (() -> a) -> a)
           "index out of bounds in mat_addrow"
           (\ _ -> mat_addrow_gen ad mul aa k l (Mat_impl a)));

mute ::
  forall a.
    (Eq a,
      Idom_divide a) => (a -> a -> (a, (a, a))) ->
                          a -> Nat -> Nat -> (a, Mat a) -> (a, Mat a);
mute mf a_ll k l (r, a) =
  let {
    p = index_mat a (k, l);
  } in (if p == zerob then (r, a)
         else (case mf a_ll p of {
                (q, (pa, _)) ->
                  (times r q,
                    mat_addrow_gen plus times (uminus pa) k l
                      (mat_multrow_gen times k q a));
              }));

sub1 ::
  forall a.
    (Eq a,
      Idom_divide a) => (a -> a -> (a, (a, a))) ->
                          a -> Nat -> Nat -> (a, Mat a) -> (a, Mat a);
sub1 mf q k l rA =
  (if equal_nat k zero_nat then rA
    else mute mf q (plus_nat l (suc (minus_nat k one_nat))) l
           (sub1 mf q (minus_nat k one_nat) l rA));

sub2 ::
  forall a.
    (Eq a,
      Idom_divide a) => ([(Nat, a)] -> Nat) ->
                          (a -> a -> (a, (a, a))) ->
                            Nat -> Nat -> (a, Mat a) -> (a, Mat a);
sub2 sel_fun mf d l (r, a) =
  (case find_non0 sel_fun l a of {
    Nothing -> (r, a);
    Just m ->
      let {
        aa = mat_swaprows m l a;
      } in sub1 mf (index_mat aa (l, l)) (minus_nat d (suc l)) l (uminus r, aa);
  });

sub3 ::
  forall a.
    (Eq a,
      Idom_divide a) => ([(Nat, a)] -> Nat) ->
                          (a -> a -> (a, (a, a))) ->
                            Nat -> Nat -> (a, Mat a) -> (a, Mat a);
sub3 sel_fun mf d l rA =
  (if equal_nat l zero_nat then rA
    else sub2 sel_fun mf d (minus_nat l one_nat)
           (sub3 sel_fun mf d (minus_nat l one_nat) rA));

triangulize ::
  forall a.
    (Eq a,
      Idom_divide a) => ([(Nat, a)] -> Nat) ->
                          (a -> a -> (a, (a, a))) -> Mat a -> (a, Mat a);
triangulize sel_fun mf a = sub3 sel_fun mf (dim_row a) (dim_row a) (onea, a);

diag_mat :: forall a. Mat a -> [a];
diag_mat a = map (\ i -> index_mat a (i, i)) (upt zero_nat (dim_row a));

det_code ::
  forall a.
    (Eq a,
      Idom_divide a) => ([(Nat, a)] -> Nat) ->
                          (a -> a -> (a, (a, a))) -> Mat a -> a;
det_code sel_fun mf a =
  (if equal_nat (dim_row a) (dim_col a)
    then (case triangulize sel_fun mf a of {
           (m, aa) -> divide (prod_list (diag_mat aa)) m;
         })
    else zerob);

det :: forall a. (Eq a, Idom_divide a) => Mat a -> a;
det a = det_code fst_sel_fun trivial_mute_fun a;

form_or :: forall a. Formula a -> Formula a -> Formula a;
form_or (Disjunction []) psi = psi;
form_or (Atom v) (Disjunction []) = Atom v;
form_or (NegAtom v) (Disjunction []) = NegAtom v;
form_or (Conjunction v) (Disjunction []) = Conjunction v;
form_or (Disjunction (va : vb)) (Disjunction []) = Disjunction (va : vb);
form_or (Disjunction (v : va)) (Disjunction (vb : vc)) =
  Disjunction ((v : va) ++ vb : vc);
form_or (Disjunction (v : va)) (Atom vb) = Disjunction ((v : va) ++ [Atom vb]);
form_or (Disjunction (v : va)) (NegAtom vb) =
  Disjunction ((v : va) ++ [NegAtom vb]);
form_or (Disjunction (v : va)) (Conjunction vb) =
  Disjunction ((v : va) ++ [Conjunction vb]);
form_or (Atom v) (Disjunction (va : vb)) = Disjunction (Atom v : va : vb);
form_or (NegAtom v) (Disjunction (va : vb)) = Disjunction (NegAtom v : va : vb);
form_or (Conjunction v) (Disjunction (va : vb)) =
  Disjunction (Conjunction v : va : vb);
form_or (Atom v) (Atom va) = Disjunction [Atom v, Atom va];
form_or (Atom v) (NegAtom va) = Disjunction [Atom v, NegAtom va];
form_or (Atom v) (Conjunction va) = Disjunction [Atom v, Conjunction va];
form_or (NegAtom v) (Atom va) = Disjunction [NegAtom v, Atom va];
form_or (NegAtom v) (NegAtom va) = Disjunction [NegAtom v, NegAtom va];
form_or (NegAtom v) (Conjunction va) = Disjunction [NegAtom v, Conjunction va];
form_or (Conjunction v) (Atom va) = Disjunction [Conjunction v, Atom va];
form_or (Conjunction v) (NegAtom va) = Disjunction [Conjunction v, NegAtom va];
form_or (Conjunction v) (Conjunction va) =
  Disjunction [Conjunction v, Conjunction va];

cnf_form_or :: forall a. Formula a -> Formula a -> Formula a;
cnf_form_or (Conjunction phi_s) (Conjunction psi_s) =
  Conjunction (concatMap (\ phi -> map (form_or phi) psi_s) phi_s);
cnf_form_or (Atom v) psi = form_or (Atom v) psi;
cnf_form_or (NegAtom v) psi = form_or (NegAtom v) psi;
cnf_form_or (Disjunction v) psi = form_or (Disjunction v) psi;
cnf_form_or phi (Atom v) = form_or phi (Atom v);
cnf_form_or phi (NegAtom v) = form_or phi (NegAtom v);
cnf_form_or phi (Disjunction v) = form_or phi (Disjunction v);

form_cnf_ex :: forall a. [Formula a] -> Formula a;
form_cnf_ex [] = Conjunction [Disjunction []];
form_cnf_ex (phi : phi_s) = cnf_form_or phi (form_cnf_ex phi_s);

form_and :: forall a. Formula a -> Formula a -> Formula a;
form_and (Conjunction []) psi = psi;
form_and (Atom v) (Conjunction []) = Atom v;
form_and (NegAtom v) (Conjunction []) = NegAtom v;
form_and (Conjunction (va : vb)) (Conjunction []) = Conjunction (va : vb);
form_and (Disjunction v) (Conjunction []) = Disjunction v;
form_and (Conjunction (v : va)) (Conjunction (vb : vc)) =
  Conjunction ((v : va) ++ vb : vc);
form_and (Conjunction (v : va)) (Atom vb) = Conjunction ((v : va) ++ [Atom vb]);
form_and (Conjunction (v : va)) (NegAtom vb) =
  Conjunction ((v : va) ++ [NegAtom vb]);
form_and (Conjunction (v : va)) (Disjunction vb) =
  Conjunction ((v : va) ++ [Disjunction vb]);
form_and (Atom v) (Conjunction (va : vb)) = Conjunction (Atom v : va : vb);
form_and (NegAtom v) (Conjunction (va : vb)) =
  Conjunction (NegAtom v : va : vb);
form_and (Disjunction v) (Conjunction (va : vb)) =
  Conjunction (Disjunction v : va : vb);
form_and (Atom v) (Atom va) = Conjunction [Atom v, Atom va];
form_and (Atom v) (NegAtom va) = Conjunction [Atom v, NegAtom va];
form_and (Atom v) (Disjunction va) = Conjunction [Atom v, Disjunction va];
form_and (NegAtom v) (Atom va) = Conjunction [NegAtom v, Atom va];
form_and (NegAtom v) (NegAtom va) = Conjunction [NegAtom v, NegAtom va];
form_and (NegAtom v) (Disjunction va) = Conjunction [NegAtom v, Disjunction va];
form_and (Disjunction v) (Atom va) = Conjunction [Disjunction v, Atom va];
form_and (Disjunction v) (NegAtom va) = Conjunction [Disjunction v, NegAtom va];
form_and (Disjunction v) (Disjunction va) =
  Conjunction [Disjunction v, Disjunction va];

form_all :: forall a. [Formula a] -> Formula a;
form_all [] = Conjunction [];
form_all (phi : phi_s) = form_and phi (form_all phi_s);

flatten :: forall a. Formula a -> Formula a;
flatten (Conjunction phi_s) = form_all (map flatten phi_s);
flatten (Disjunction phi_s) = form_cnf_ex (map flatten phi_s);
flatten (Atom v) = Conjunction [Disjunction [Atom v]];
flatten (NegAtom v) = Conjunction [Disjunction [NegAtom v]];

is_Atom :: forall a. Formula a -> Bool;
is_Atom (Atom uu) = True;
is_Atom (NegAtom v) = False;
is_Atom (Conjunction v) = False;
is_Atom (Disjunction v) = False;

gen_set :: forall a b. a -> (b -> a -> a) -> [b] -> a;
gen_set emp ins l = fold ins l emp;

initial :: forall a b c d e. Lts_ext a b c d e -> Set d;
initial (Lts_ext initial transition_rules assertion more) = initial;

untrans_var :: forall a. Trans_var a -> a;
untrans_var (Pre x) = x;
untrans_var (Post x) = x;
untrans_var (Intermediate x) = x;

label :: forall a b. Lab a b -> Nat -> Sum b [Lab a b] -> Lab a b;
label f n (Inl l) = Lab f l;
label f n (Inr l) = FunLab f l;

plus_mat :: forall a. (Plus a) => Mat a -> Mat a -> Mat a;
plus_mat a b =
  mat (dim_row b) (dim_col b) (\ ij -> plus (index_mat a ij) (index_mat b ij));

carrier_mat :: forall a. Nat -> Nat -> Set (Mat a);
carrier_mat nr nc =
  Collect_set (\ a -> equal_nat (dim_row a) nr && equal_nat (dim_col a) nc);

zero_mat :: forall a. (Zero a) => Nat -> Nat -> Mat a;
zero_mat nr nc = mat nr nc (\ _ -> zerob);

ring_mat ::
  forall a b.
    (Semiring_1 a) => Itself a ->
                        Nat ->
                          b -> Partial_object_ext (Mat a)
                                 (Monoid_ext (Mat a) (Ring_ext (Mat a) b));
ring_mat ty n b =
  Partial_object_ext (carrier_mat n n)
    (Monoid_ext times_mat (one_mat n) (Ring_ext (zero_mat n n) plus_mat b));

emptyd :: forall a b. (Ccompare b, Mapping_impl b) => (a -> b) -> Multimap b a;
emptyd xa = Abs_multimap (xa, (emptyb, []));

values :: forall a b. (Linorder a) => Rbt a [b] -> [b];
values m = concatMap snd (entries m);

horner_sum :: forall a b. (Comm_semiring_0 b) => (a -> b) -> b -> [a] -> b;
horner_sum f a xs = foldr (\ x b -> plus (f x) (times a b)) xs zerob;

polya :: forall a. (Comm_semiring_0 a) => Poly a -> a -> a;
polya p a = horner_sum id a (coeffs p);

lex_ext_unbounded ::
  forall a. (a -> a -> (Bool, Bool)) -> [a] -> [a] -> (Bool, Bool);
lex_ext_unbounded f [] [] = (False, True);
lex_ext_unbounded f (uu : uv) [] = (True, True);
lex_ext_unbounded f [] (uw : ux) = (False, False);
lex_ext_unbounded f (a : asa) (b : bs) =
  (case f a b of {
    (True, _) -> (True, True);
    (False, True) -> lex_ext_unbounded f asa bs;
    (False, False) -> (False, False);
  });

spo_ub ::
  forall a b.
    (Eq a,
      Eq b) => (Term a b -> Term a b -> Bool) ->
                 (Term a b -> Term a b -> Bool) -> Term a b -> Term a b -> Bool;
spo_ub cS cNS (Var uu) uv = False;
spo_ub cS cNS (Fun f ss) t =
  any (\ si -> equal_term si t || spo_ub cS cNS si t) ss ||
    (case t of {
      Var _ -> False;
      Fun _ ts ->
        all (spo_ub cS cNS (Fun f ss)) ts &&
          (cS (Fun f ss) t ||
            cNS (Fun f ss) t &&
              fst (lex_ext_unbounded
                    (\ s ta -> (spo_ub cS cNS s ta, equal_term s ta)) ss ts));
    });

boundsl :: forall a b. State a b -> Nat -> Maybe b;
boundsl s = map_option snd . lookupb (b_i_l s);

boundsu :: forall a b. State a b -> Nat -> Maybe b;
boundsu s = map_option snd . lookupb (b_i_u s);

sequences :: forall a b. (Linorder b) => (a -> b) -> [a] -> [[a]];
sequences key (a : b : xs) =
  (if less (key b) (key a) then desc key b [a] xs
    else asc key b (\ ba -> a : ba) xs);
sequences key [x] = [[x]];
sequences key [] = [];

asc ::
  forall a b. (Linorder b) => (a -> b) -> a -> ([a] -> [a]) -> [a] -> [[a]];
asc key a asa (b : bs) =
  (if less_eq (key a) (key b) then asc key b (\ ys -> asa (a : ys)) bs
    else asa [a] : sequences key (b : bs));
asc key a asa [] = [asa [a]];

desc :: forall a b. (Linorder b) => (a -> b) -> a -> [a] -> [a] -> [[a]];
desc key a asa (b : bs) =
  (if less (key b) (key a) then desc key b (a : asa) bs
    else (a : asa) : sequences key (b : bs));
desc key a asa [] = [a : asa];

mergea :: forall a b. (Linorder b) => (a -> b) -> [a] -> [a] -> [a];
mergea key (a : asa) (b : bs) =
  (if less (key b) (key a) then b : mergea key (a : asa) bs
    else a : mergea key asa (b : bs));
mergea key [] bs = bs;
mergea key (v : va) [] = v : va;

merge_pairs :: forall a b. (Linorder b) => (a -> b) -> [[a]] -> [[a]];
merge_pairs key (a : b : xs) = mergea key a b : merge_pairs key xs;
merge_pairs key [] = [];
merge_pairs key [v] = [v];

merge_all :: forall a b. (Linorder b) => (a -> b) -> [[a]] -> [a];
merge_all key [] = [];
merge_all key [x] = x;
merge_all key (v : vb : vc) = merge_all key (merge_pairs key (v : vb : vc));

msort_key :: forall a b. (Linorder b) => (a -> b) -> [a] -> [a];
msort_key key xs = merge_all key (sequences key xs);

sort_key :: forall a b. (Linorder b) => (a -> b) -> [a] -> [a];
sort_key key = msort_key key;

sorted_list_of_set ::
  forall a. (Ceq a, Ccompare a, Eq a, Linorder a) => Set a -> [a];
sorted_list_of_set (RBT_set rbt) =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "sorted_list_of_set RBT_set: ccompare = None"
        (\ _ -> sorted_list_of_set (RBT_set rbt));
    Just _ -> sort_key (\ x -> x) (keysb rbt);
  });
sorted_list_of_set (DList_set dxs) =
  (case (ceq :: Maybe (a -> a -> Bool)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "sorted_list_of_set DList_set: ceq = None"
        (\ _ -> sorted_list_of_set (DList_set dxs));
    Just _ -> sort_key (\ x -> x) (list_of_dlist dxs);
  });
sorted_list_of_set (Set_Monad xs) = sort_key (\ x -> x) (remdups xs);

ordered_keys ::
  forall a b.
    (Ceq a, Ccompare a, Eq a, Linorder a, Set_impl a, Ceq b, Ccompare b,
      Set_impl b) => Fmap a b -> [a];
ordered_keys m = sorted_list_of_set (fset (fmdom m));

vars_list :: Linear_poly -> [Nat];
vars_list lp = ordered_keys (linear_poly_map lp);

valuate :: forall a. (Rational_vector a) => Linear_poly -> (Nat -> a) -> a;
valuate lp val =
  let {
    lpm = linear_poly_map lp;
  } in sum_list
         (map (\ x -> scaleRat (the (fmlookup lpm x)) (val x)) (vars_list lp));

delta_0 :: QDelta -> QDelta -> Rat;
delta_0 qd1 qd2 =
  let {
    c1 = qdfst qd1;
    c2 = qdfst qd2;
    k1 = qdsnd qd1;
    k2 = qdsnd qd2;
  } in (if less_rat c1 c2 && less_rat k2 k1
         then divide_rat (minus_rat c2 c1) (minus_rat k1 k2) else one_rat);

delta_0_val :: Ns_constraint QDelta -> (Nat -> QDelta) -> Rat;
delta_0_val (LEQ_ns lll rrr) vl = delta_0 (valuate lll vl) rrr;
delta_0_val (GEQ_ns lll rrr) vl = delta_0 rrr (valuate lll vl);

delta_0_val_min :: [Ns_constraint QDelta] -> (Nat -> QDelta) -> Rat;
delta_0_val_min [] vl = one_rat;
delta_0_val_min (h : t) vl = min (delta_0_val_min t vl) (delta_0_val h vl);

tabulate ::
  forall a b.
    (Ccompare a, Eq a, Mapping_impl a) => [a] -> (a -> b) -> Mapping a b;
tabulate xs f = fold (\ k -> updateb k (f k)) xs emptyb;

map2fun :: forall a. (Zero a) => Mapping Nat a -> Nat -> a;
map2fun v = (\ x -> (case lookupb v x of {
                      Nothing -> zerob;
                      Just y -> y;
                    }));

from_ns :: Mapping Nat QDelta -> [Ns_constraint QDelta] -> Mapping Nat Rat;
from_ns vl cs =
  let {
    delta = delta_0_val_min cs (map2fun vl);
  } in tabulate (remdups (concatMap vars_list (map poly cs)))
         (\ var -> val (map2fun vl var) delta);

uBI_upd ::
  forall a b.
    (Linorder b) => Direction a b ->
                      (Mapping Nat (a, b) -> Mapping Nat (a, b)) ->
                        State a b -> State a b;
uBI_upd (Direction x1 x2 x3 x4 x5 x6 x7 x8 x9 x10 x11) = x8;

update_B_I ::
  forall a b c d e.
    (Ccompare a,
      Eq a) => ((Mapping a (b, c) -> Mapping a (b, c)) -> d -> e) ->
                 b -> a -> c -> d -> e;
update_B_I field_update i x c s = field_update (updateb x (i, c)) s;

lt :: forall a b. (Linorder b) => Direction a b -> b -> b -> Bool;
lt (Direction x1 x2 x3 x4 x5 x6 x7 x8 x9 x10 x11) = x1;

ub :: forall a b. (Linorder b) => Direction a b -> State a b -> Nat -> Maybe b;
ub (Direction x1 x2 x3 x4 x5 x6 x7 x8 x9 x10 x11) = x5;

li :: forall a b. (Linorder b) => Direction a b -> State a b -> Nat -> a;
li (Direction x1 x2 x3 x4 x5 x6 x7 x8 x9 x10 x11) = x6;

lb :: forall a b. (Linorder b) => Direction a b -> State a b -> Nat -> Maybe b;
lb (Direction x1 x2 x3 x4 x5 x6 x7 x8 x9 x10 x11) = x4;

v_update :: forall a b. Mapping Nat a -> State b a -> State b a;
v_update v (State t bil biu v_old u uc) = State t bil biu v u uc;

v :: forall a b. State a b -> Mapping Nat b;
v (State x1 x2 x3 x4 x5 x6) = x4;

t :: forall a b. State a b -> [(Nat, Linear_poly)];
t (State x1 x2 x3 x4 x5 x6) = x1;

get_var_coeff :: Fmap Nat Rat -> Nat -> Rat;
get_var_coeff lp v = (case fmlookup lp v of {
                       Nothing -> zero_rat;
                       Just c -> c;
                     });

coeffa :: Linear_poly -> Nat -> Rat;
coeffa lp = get_var_coeff (linear_poly_map lp);

rhs_eq_val ::
  forall a.
    (Minus a, Plus a, Zero a,
      ScaleRat a) => Mapping Nat a -> Nat -> a -> (Nat, Linear_poly) -> a;
rhs_eq_val v x_i c e =
  let {
    x_j = lhs e;
    a_i_j = coeffa (rhs e) x_i;
  } in plus (map2fun v x_j) (scaleRat a_i_j (minusa c (map2fun v x_i)));

update_code :: forall a b. (Lrv a) => Nat -> a -> State b a -> State b a;
update_code x c s =
  v_update
    (updateb x c
      (foldl (\ va e -> updateb (lhs e) (rhs_eq_val (v s) x c e) va) (v s)
        (t s)))
    s;

set_unsat :: forall a b. (Eq a) => [a] -> State a b -> State a b;
set_unsat i (State t bil biu v u uc) =
  State t bil biu v True (Just (remdups i));

assert_bound_codea ::
  forall a b.
    (Eq a, Eq b,
      Lrv b) => Direction a b -> a -> Nat -> b -> State a b -> State a b;
assert_bound_codea dir i x c s =
  (if geub (lt dir) c (ub dir s x) then s
    else let {
           sa = update_B_I (uBI_upd dir) i x c s;
         } in (if ltlb (lt dir) c (lb dir s x) then set_unsat [i, li dir s x] sa
                else (if not (member x (lvars (t sa))) &&
                           lt dir c (map2fun (v s) x)
                       then update_code x c sa else sa)));

b_i_u_update ::
  forall a b.
    (Mapping Nat (a, b) -> Mapping Nat (a, b)) -> State a b -> State a b;
b_i_u_update up (State t bil biu v u uc) = State t bil (up biu) v u uc;

positive :: forall a b. (Linorder b) => Direction a b;
positive =
  Direction less b_i_l b_i_u boundsl boundsu indexl indexu b_i_u_update Leq Geq
    less_eq_rat;

b_i_l_update ::
  forall a b.
    (Mapping Nat (a, b) -> Mapping Nat (a, b)) -> State a b -> State a b;
b_i_l_update up (State t bil biu v u uc) = State t (up bil) biu v u uc;

negative :: forall a b. (Linorder b) => Direction a b;
negative =
  Direction (\ x y -> less y x) b_i_u b_i_l boundsu boundsl indexu indexl
    b_i_l_update Geq Leq (\ x y -> less_eq_rat y x);

assert_bound_code ::
  forall a b. (Eq a, Eq b, Lrv b) => (a, Atom b) -> State a b -> State a b;
assert_bound_code (i, Leq x c) s = assert_bound_codea positive i x c s;
assert_bound_code (i, Geq x c) s = assert_bound_codea negative i x c s;

u :: forall a b. State a b -> Bool;
u (State x1 x2 x3 x4 x5 x6) = x5;

assert_bound_loop_code ::
  forall a b. (Eq a, Eq b, Lrv b) => [(a, Atom b)] -> State a b -> State a b;
assert_bound_loop_code ats s =
  foldl (\ sa a -> (if u sa then sa else assert_bound_code a sa)) s ats;

init_state :: forall a b. (Zero b) => [(Nat, Linear_poly)] -> State a b;
init_state t =
  State t (mapping_empty (of_phantom mapping_impl_nat))
    (mapping_empty (of_phantom mapping_impl_nat))
    (tabulate (remdups (map lhs t ++ concatMap (vars_list . rhs) t))
      (\ _ -> zerob))
    False Nothing;

min_satisfying :: forall a. (Linorder a) => (a -> Bool) -> [a] -> Maybe a;
min_satisfying p l =
  let {
    xs = filter p l;
  } in (if null xs then Nothing else Just (foldl min (hda xs) (tla xs)));

le_ubound :: forall a. (Eq a, Linorder a) => a -> Maybe a -> Bool;
le_ubound c b = leub less c b;

ge_lbound :: forall a. (Eq a, Linorder a) => a -> Maybe a -> Bool;
ge_lbound c b = gelb less c b;

in_bounds ::
  forall a b.
    (Eq b, Linorder b) => a -> (a -> b) -> (a -> Maybe b, a -> Maybe b) -> Bool;
in_bounds x v (lb, ub) = ge_lbound (v x) (lb x) && le_ubound (v x) (ub x);

min_lvar_not_in_bounds ::
  forall a b. (Zero b, Eq b, Linorder b) => State a b -> Maybe Nat;
min_lvar_not_in_bounds s =
  min_satisfying
    (\ x -> not (in_bounds x (map2fun (v s)) (boundsl s, boundsu s)))
    (map lhs (t s));

fmmap :: forall a b c. (a -> b) -> Fmap c a -> Fmap c b;
fmmap f (Fmap_of_list m) = Fmap_of_list (map (apsnd f) m);

fmempty :: forall a b. Fmap a b;
fmempty = Fmap_of_list [];

scale :: Rat -> Fmap Nat Rat -> Fmap Nat Rat;
scale r lp = (if equal_rat r zero_rat then fmempty else fmmap (times_rat r) lp);

scaleRat_linear_poly :: Rat -> Linear_poly -> Linear_poly;
scaleRat_linear_poly r p = LinearPoly (scale r (linear_poly_map p));

uminus_linear_poly :: Linear_poly -> Linear_poly;
uminus_linear_poly lp = scaleRat_linear_poly (uminus_rat one_rat) lp;

fmfilter :: forall a b. (a -> Bool) -> Fmap a b -> Fmap a b;
fmfilter p (Fmap_of_list m) = Fmap_of_list (filter (\ (k, _) -> p k) m);

fmdrop :: forall a b. (Eq a) => a -> Fmap a b -> Fmap a b;
fmdrop a = fmfilter (\ aa -> not (aa == a));

fmadd :: forall a b. (Eq a) => Fmap a b -> Fmap a b -> Fmap a b;
fmadd (Fmap_of_list m) (Fmap_of_list n) = Fmap_of_list (merge m n);

fmupd :: forall a b. (Eq a) => a -> b -> Fmap a b -> Fmap a b;
fmupd k v m = fmadd m (Fmap_of_list [(k, v)]);

set_var_coeff :: Nat -> Rat -> Fmap Nat Rat -> Fmap Nat Rat;
set_var_coeff v c lp =
  (if equal_rat c zero_rat then fmdrop v lp else fmupd v c lp);

add_monom :: Rat -> Nat -> Fmap Nat Rat -> Fmap Nat Rat;
add_monom c v lp = set_var_coeff v (plus_rat c (get_var_coeff lp v)) lp;

adda :: Fmap Nat Rat -> Fmap Nat Rat -> Fmap Nat Rat;
adda lp1 lp2 =
  foldl (\ lp v -> add_monom (get_var_coeff lp1 v) v lp) lp2 (ordered_keys lp1);

plus_linear_poly :: Linear_poly -> Linear_poly -> Linear_poly;
plus_linear_poly p1 p2 =
  LinearPoly (adda (linear_poly_map p1) (linear_poly_map p2));

minus_linear_poly :: Linear_poly -> Linear_poly -> Linear_poly;
minus_linear_poly lp1 lp2 = plus_linear_poly lp1 (uminus_linear_poly lp2);

vara :: Nat -> Linear_poly;
vara x = LinearPoly (set_var_coeff x one_rat fmempty);

subst_var :: Nat -> Linear_poly -> Linear_poly -> Linear_poly;
subst_var v lpa lp =
  minus_linear_poly
    (plus_linear_poly lp (scaleRat_linear_poly (coeffa lp v) lpa))
    (scaleRat_linear_poly (coeffa lp v) (vara v));

subst_var_eq_code ::
  Nat -> Linear_poly -> (Nat, Linear_poly) -> (Nat, Linear_poly);
subst_var_eq_code v lp eq = (lhs eq, subst_var v lp (rhs eq));

eq_idx_for_lvar_aux :: [(Nat, Linear_poly)] -> Nat -> Nat -> Nat;
eq_idx_for_lvar_aux [] x i = i;
eq_idx_for_lvar_aux (eq : t) x i =
  (if equal_nat (lhs eq) x then i
    else eq_idx_for_lvar_aux t x (plus_nat i one_nat));

eq_idx_for_lvar :: [(Nat, Linear_poly)] -> Nat -> Nat;
eq_idx_for_lvar t x = eq_idx_for_lvar_aux t x zero_nat;

eq_for_lvar_code :: [(Nat, Linear_poly)] -> Nat -> (Nat, Linear_poly);
eq_for_lvar_code t v = nth t (eq_idx_for_lvar t v);

pivot_eq :: (Nat, Linear_poly) -> Nat -> (Nat, Linear_poly);
pivot_eq e y =
  let {
    cy = coeffa (rhs e) y;
  } in (y, plus_linear_poly
             (scaleRat_linear_poly (divide_rat (uminus_rat one_rat) cy)
               (minus_linear_poly (rhs e) (scaleRat_linear_poly cy (vara y))))
             (scaleRat_linear_poly (divide_rat one_rat cy) (vara (lhs e))));

pivot_tableau_code ::
  Nat -> Nat -> [(Nat, Linear_poly)] -> [(Nat, Linear_poly)];
pivot_tableau_code x_i x_j t =
  let {
    eq = eq_for_lvar_code t x_i;
    eqa = pivot_eq eq x_j;
  } in map (\ e ->
             (if equal_nat (lhs e) (lhs eq) then eqa
               else subst_var_eq_code x_j (rhs eqa) e))
         t;

t_update :: forall a b. [(Nat, Linear_poly)] -> State a b -> State a b;
t_update t (State t_old bil biu v u uc) = State t bil biu v u uc;

pivot_code :: forall a b. (Lrv b) => Nat -> Nat -> State a b -> State a b;
pivot_code x_i x_j s = t_update (pivot_tableau_code x_i x_j (t s)) s;

pivot_and_update_code ::
  forall a b. (Lrv a) => Nat -> Nat -> a -> State b a -> State b a;
pivot_and_update_code x_i x_j c s = update_code x_i c (pivot_code x_i x_j s);

ui :: forall a b. (Linorder b) => Direction a b -> State a b -> Nat -> a;
ui (Direction x1 x2 x3 x4 x5 x6 x7 x8 x9 x10 x11) = x7;

unsat_indices ::
  forall a b.
    (Eq a,
      Linorder b) => Direction a b ->
                       State a b -> [Nat] -> (Nat, Linear_poly) -> [a];
unsat_indices dir s vs eq =
  let {
    r = rhs eq;
    lia = li dir s;
    uia = ui dir s;
  } in remdups
         (lia (lhs eq) :
           map (\ x ->
                 (if less_rat (coeffa r x) zero_rat then lia x else uia x))
             vs);

min_rvar_incdec_eq ::
  forall a b.
    (Eq a,
      Lrv b) => Direction a b -> State a b -> (Nat, Linear_poly) -> Sum [a] Nat;
min_rvar_incdec_eq dir s eq =
  let {
    rvars = vars_list (rhs eq);
  } in (case min_satisfying
               (\ x ->
                 less_rat zero_rat (coeffa (rhs eq) x) &&
                   ltub (lt dir) (map2fun (v s) x) (ub dir s x) ||
                   less_rat (coeffa (rhs eq) x) zero_rat &&
                     gtlb (lt dir) (map2fun (v s) x) (lb dir s x))
               rvars
         of {
         Nothing -> Inl (unsat_indices dir s rvars eq);
         Just a -> Inr a;
       });

check_codea ::
  forall a b. (Eq a, Lrv b) => Direction a b -> Nat -> State a b -> State a b;
check_codea dir x_i s =
  let {
    l_i = the (lb dir s x_i);
  } in (case min_rvar_incdec_eq dir s (eq_for_lvar_code (t s) x_i) of {
         Inl i -> set_unsat i s;
         Inr x_j -> pivot_and_update_code x_i x_j l_i s;
       });

lt_lbound :: forall a. (Linorder a) => a -> Maybe a -> Bool;
lt_lbound c b = ltlb less c b;

check_code :: forall a b. (Eq a, Eq b, Lrv b) => State a b -> State a b;
check_code s =
  (if u s then s
    else (case min_lvar_not_in_bounds s of {
           Nothing -> s;
           Just x_i ->
             let {
               dir = (if lt_lbound (map2fun (v s) x_i) (boundsl s x_i)
                       then positive else negative);
             } in check_code (check_codea dir x_i s);
         }));

assert_all_state_code ::
  forall a b.
    (Eq a, Eq b, Lrv b) => [(Nat, Linear_poly)] -> [(a, Atom b)] -> State a b;
assert_all_state_code t ats =
  check_code (assert_bound_loop_code ats (init_state t));

u_c :: forall a b. State a b -> Maybe [a];
u_c (State x1 x2 x3 x4 x5 x6) = x6;

assert_all_code ::
  forall a b.
    (Eq a, Eq b,
      Lrv b) => [(Nat, Linear_poly)] ->
                  [(a, Atom b)] -> Sum [a] (Mapping Nat b);
assert_all_code t asa = let {
                          s = assert_all_state_code t asa;
                        } in (if u s then Inl (the (u_c s)) else Inr (v s));

max_var :: Linear_poly -> Nat;
max_var lp = let {
               vl = vars_list lp;
             } in (if null vl then zero_nat else foldl max (hda vl) (tla vl));

normalize_ns_constraint ::
  forall a. (Lrv a) => Ns_constraint a -> Ns_constraint a;
normalize_ns_constraint (LEQ_ns l r) =
  let {
    v = max_var l;
    c = coeffa l v;
  } in (if equal_rat c zero_rat then LEQ_ns l r
         else let {
                ic = inverse_rat c;
              } in (if less_rat c zero_rat
                     then GEQ_ns (scaleRat_linear_poly ic l) (scaleRat ic r)
                     else LEQ_ns (scaleRat_linear_poly ic l) (scaleRat ic r)));
normalize_ns_constraint (GEQ_ns l r) =
  let {
    v = max_var l;
    c = coeffa l v;
  } in (if equal_rat c zero_rat then GEQ_ns l r
         else let {
                ic = inverse_rat c;
              } in (if less_rat c zero_rat
                     then LEQ_ns (scaleRat_linear_poly ic l) (scaleRat ic r)
                     else GEQ_ns (scaleRat_linear_poly ic l) (scaleRat ic r)));

pivot_tableau_eq ::
  [(Nat, Linear_poly)] ->
    (Nat, Linear_poly) ->
      [(Nat, Linear_poly)] ->
        Nat ->
          ([(Nat, Linear_poly)], ((Nat, Linear_poly), [(Nat, Linear_poly)]));
pivot_tableau_eq t1 eq t2 x = let {
                                eqa = pivot_eq eq x;
                                m = map (subst_var_eq_code x (rhs eqa));
                              } in (m t1, (eqa, m t2));

preprocess_opt ::
  forall a.
    (Lrv a) => Set Nat ->
                 [(Nat, Linear_poly)] ->
                   [(Nat, Linear_poly)] ->
                     ([(Nat, Linear_poly)], Mapping Nat a -> Mapping Nat a);
preprocess_opt x t1 [] = (t1, id);
preprocess_opt xa t1 ((x, p) : t2) =
  (if not (member x xa)
    then (case preprocess_opt xa t1 t2 of {
           (t, tv) -> (t, (\ v -> updateb x (valuate p (map2fun v)) v) . tv);
         })
    else (case find (\ xb -> not (member xb xa)) (vars_list p) of {
           Nothing -> preprocess_opt xa ((x, p) : t1) t2;
           Just y ->
             (case pivot_tableau_eq t1 (x, p) t2 y of {
               (tt1, ((z, q), tt2)) ->
                 (case preprocess_opt xa tt1 tt2 of {
                   (t, tv) ->
                     (t, (\ v -> updateb z (valuate q (map2fun v)) v) . tv);
                 });
             });
         }));

atom_var :: forall a. Atom a -> Nat;
atom_var (Leq var a) = var;
atom_var (Geq var a) = var;

preprocess_part_2 ::
  forall a b c.
    (Ceq a, Ccompare a, Set_impl a, Ccompare b, Eq b,
      Lrv c) => [(a, Atom b)] ->
                  [(Nat, Linear_poly)] ->
                    ([(Nat, Linear_poly)], Mapping Nat c -> Mapping Nat c);
preprocess_part_2 asa t =
  preprocess_opt (image atom_var (image snd (set asa))) [] t;

start_fresh_variable :: forall a. [(a, Ns_constraint QDelta)] -> Nat;
start_fresh_variable [] = zero_nat;
start_fresh_variable ((i, h) : t) =
  max (plus_nat (max_var (poly h)) one_nat) (start_fresh_variable t);

unsatIndices :: forall a. Istate a -> [a];
unsatIndices (IState x1 x2 x3 x4 x5) = x5;

tableau :: forall a. Istate a -> [(Nat, Linear_poly)];
tableau (IState x1 x2 x3 x4 x5) = x2;

atoms :: forall a. Istate a -> [(a, Atom QDelta)];
atoms (IState x1 x2 x3 x4 x5) = x3;

zeroa :: Fmap Nat Rat;
zeroa = fmempty;

zero_linear_poly :: Linear_poly;
zero_linear_poly = LinearPoly zeroa;

qdelta_constraint_to_atom :: Ns_constraint QDelta -> Nat -> Atom QDelta;
qdelta_constraint_to_atom (LEQ_ns l r) v = Leq v r;
qdelta_constraint_to_atom (GEQ_ns l r) v = Geq v r;

firstFreshVariable :: forall a. Istate a -> Nat;
firstFreshVariable (IState x1 x2 x3 x4 x5) = x1;

is_monom :: Linear_poly -> Bool;
is_monom l = equal_nat (size_list (vars_list l)) one_nat;

poly_Mapping :: forall a. Istate a -> Linear_poly -> Maybe Nat;
poly_Mapping (IState x1 x2 x3 x4 x5) = x4;

linear_poly_to_eq :: Linear_poly -> Nat -> (Nat, Linear_poly);
linear_poly_to_eq p v = (v, p);

zero_satisfies :: forall a. (Lrv a) => Ns_constraint a -> Bool;
zero_satisfies (LEQ_ns l r) = less_eq zerob r;
zero_satisfies (GEQ_ns l r) = less_eq r zerob;

monom_var :: Linear_poly -> Nat;
monom_var l = max_var l;

monom_coeff :: Linear_poly -> Rat;
monom_coeff l = coeffa l (monom_var l);

monom_to_atom :: Ns_constraint QDelta -> Atom QDelta;
monom_to_atom (LEQ_ns l r) =
  (if less_rat (monom_coeff l) zero_rat
    then Geq (monom_var l) (scaleRat_QDelta (inverse_rat (monom_coeff l)) r)
    else Leq (monom_var l) (scaleRat_QDelta (inverse_rat (monom_coeff l)) r));
monom_to_atom (GEQ_ns l r) =
  (if less_rat (monom_coeff l) zero_rat
    then Leq (monom_var l) (scaleRat_QDelta (inverse_rat (monom_coeff l)) r)
    else Geq (monom_var l) (scaleRat_QDelta (inverse_rat (monom_coeff l)) r));

preprocessa :: forall a. [(a, Ns_constraint QDelta)] -> Nat -> Istate a;
preprocessa [] v = IState v [] [] (\ _ -> Nothing) [];
preprocessa ((i, h) : t) v =
  let {
    s = preprocessa t v;
    p = poly h;
    is_monom_h = is_monom p;
    va = firstFreshVariable s;
    ta = tableau s;
    a = atoms s;
    m = poly_Mapping s;
    u = unsatIndices s;
  } in (if is_monom_h then IState va ta ((i, monom_to_atom h) : a) m u
         else (if equal_linear_poly p zero_linear_poly
                then (if zero_satisfies h then s else IState va ta a m (i : u))
                else (case m p of {
                       Nothing ->
                         IState (plus_nat va one_nat)
                           (linear_poly_to_eq p va : ta)
                           ((i, qdelta_constraint_to_atom h va) : a)
                           (fun_upd m p (Just va)) u;
                       Just vaa ->
                         IState va ta ((i, qdelta_constraint_to_atom h vaa) : a)
                           m u;
                     })));

preprocess_part_1 ::
  forall a.
    [(a, Ns_constraint QDelta)] ->
      ([(Nat, Linear_poly)], ([(a, Atom QDelta)], [a]));
preprocess_part_1 l = let {
                        start = start_fresh_variable l;
                        is = preprocessa l start;
                      } in (tableau is, (atoms is, unsatIndices is));

preprocess ::
  forall a.
    (Ceq a, Ccompare a,
      Set_impl a) => [(a, Ns_constraint QDelta)] ->
                       ([(Nat, Linear_poly)],
                         ([(a, Atom QDelta)],
                           (Mapping Nat QDelta -> Mapping Nat QDelta, [a])));
preprocess l =
  (case preprocess_part_1 (map (map_prod id normalize_ns_constraint) l) of {
    (t, (asa, ui)) -> (case preprocess_part_2 asa t of {
                        (ta, tv) -> (ta, (asa, (tv, ui)));
                      });
  });

solve_exec_ns_code ::
  forall a.
    (Ceq a, Ccompare a, Eq a,
      Set_impl a) => [(a, Ns_constraint QDelta)] ->
                       Sum [a] (Mapping Nat QDelta);
solve_exec_ns_code s =
  (case preprocess s of {
    (t, (asa, (trans_v, []))) -> (case assert_all_code t asa of {
                                   Inl a -> Inl a;
                                   Inr v -> Inr (trans_v v);
                                 });
    (_, (_, (_, i : _))) -> Inl [i];
  });

solve_exec_code ::
  forall a.
    (Ceq a, Ccompare a, Eq a,
      Set_impl a) => [(a, Constraint)] -> Sum [a] (Mapping Nat Rat);
solve_exec_code cs = let {
                       csa = to_ns cs;
                     } in (case solve_exec_ns_code csa of {
                            Inl a -> Inl a;
                            Inr v -> Inr (from_ns v (map snd csa));
                          });

simplex_index ::
  forall a.
    (Ceq a, Ccompare a, Eq a,
      Set_impl a) => [(a, Constraint)] -> Sum [a] (Mapping Nat Rat);
simplex_index = solve_exec_code;

simplex :: [Constraint] -> Sum [Nat] (Mapping Nat Rat);
simplex cs = simplex_index (zip (upt zero_nat (size_list cs)) cs);

binda :: forall a b c. Sum_bot a b -> (b -> Sum_bot a c) -> Sum_bot a c;
binda (Sumbot a) f = (case a of {
                       Inl b -> Sumbot (Inl b);
                       Inr aa -> f aa;
                     });

tcapI ::
  forall a b. (Eq a, Eq b) => [(Term a b, Term a b)] -> Term a b -> Gctxt a b;
tcapI uu (Var uv) = GCHole;
tcapI r (Fun f ts) =
  let {
    h = GCFun f (map (tcapI r) ts);
  } in (if any (\ ra -> matchb h (fst ra)) r then GCHole else h);

hvf_top :: forall a b. (Eq a) => a -> Nat -> Term a b -> Bool;
hvf_top a n (Fun f ts) =
  (if f == a && equal_nat (size_list ts) n then not (is_Var (hda ts))
    else True);
hvf_top a n (Var uu) = False;

version :: String;
version = " [hg: unknown]";

status :: forall a. Status a -> (a, Nat) -> [Nat];
status (Abs_status x) = x;

af_wpo :: forall a. ((a, Nat) -> Set Nat) -> Status a -> (a, Nat) -> Set Nat;
af_wpo pi sigma f = sup_set (set (status sigma f)) (pi f);

xml_change ::
  forall a b.
    ((Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
      Sum_bot (Xml_error String) a) ->
      (a -> ([Xml], ([([Char], [Char])], (Bool, ([String], [String])))) ->
              Sum_bot (Xml_error String) b) ->
        (Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
          Sum_bot (Xml_error String) b;
xml_change p f x = bind2 (p x) left (\ a -> (case x of {
      (_, rest) -> f a ([], rest);
    }));

isOK :: forall a b. Sum a b -> Bool;
isOK m = (case m of {
           Inl _ -> False;
           Inr _ -> True;
         });

mapM :: forall a b c. (a -> Sum b c) -> [a] -> Sum b [c];
mapM f [] = Inr [];
mapM f (x : xs) = bindb (f x) (\ y -> bindb (mapM f xs) (\ ys -> Inr (y : ys)));

form_not :: forall a. Formula a -> Formula a;
form_not (Atom a) = NegAtom a;
form_not (NegAtom a) = Atom a;
form_not (Conjunction phi_s) = Disjunction (map form_not phi_s);
form_not (Disjunction phi_s) = Conjunction (map form_not phi_s);

get_Atom :: forall a. Formula a -> a;
get_Atom (Atom a) = a;
get_Atom (NegAtom a) = a;

sharp_term :: forall a b. (a -> a) -> Term a b -> Term a b;
sharp_term shp (Var x) = Var x;
sharp_term shp (Fun f ss) = Fun (shp f) ss;

gwpo_s ::
  forall a b.
    (Term a b -> Term a b -> Bool) ->
      (Term a b -> Term a b -> Bool) ->
        ((a, Nat) -> (a, Nat) -> (Bool, Bool)) ->
          (a -> a) -> Term a b -> Term a b -> Bool;
gwpo_s cS cNS prc shp l r =
  not (is_Var l) &&
    not (is_Var r) &&
      (cS (sharp_term shp l) (sharp_term shp r) ||
        cNS (sharp_term shp l) (sharp_term shp r) &&
          fst (prc (the (root l)) (the (root r))));

gen_ball ::
  forall a b c d e f.
    (a -> (b -> b) -> (c -> d -> e) -> Bool -> f) -> a -> (c -> e) -> f;
gen_ball it m p = it m (\ x -> x) (\ x _ -> p x) True;

gen_balla ::
  forall a b c d e.
    (a -> (b -> b) -> (c -> d -> Bool) -> Bool -> e) -> a -> (c -> Bool) -> e;
gen_balla it s p = it s (\ x -> x) (\ x _ -> p x) True;

gen_pick ::
  forall a b c d e f.
    (a -> (Maybe b -> Bool) -> (c -> d -> Maybe c) -> Maybe e -> Maybe f) ->
      a -> f;
gen_pick it s =
  the (it s (\ a -> (case a of {
                      Nothing -> True;
                      Just _ -> False;
                    }))
         (\ x _ -> Just x)
        Nothing);

one :: forall a b. Partial_object_ext a (Monoid_ext a b) -> a;
one (Partial_object_ext carrier (Monoid_ext mult one more)) = one;

remdups_adj :: forall a. (Eq a) => [a] -> [a];
remdups_adj [] = [];
remdups_adj [x] = [x];
remdups_adj (x : y : xs) =
  (if x == y then remdups_adj (x : xs) else x : remdups_adj (y : xs));

base :: forall a. (a, Nat) -> a;
base (f, h) = f;

lift :: forall a. Nat -> a -> (a, Nat);
lift h f = (f, h);

roof ::
  forall a b.
    (Ceq b, Ccompare b, Set_impl b) => (Term a b, Term a b) -> Term a b -> Bool;
roof (l, r) = let {
                xs = vars_term_list r;
              } in (\ t -> let {
                             xt = vars_term t;
                           } in all (\ x -> member x xt) xs);

matches ::
  forall a b c.
    (Eq a, Eq b, Ccompare c, Eq c,
      Mapping_impl c) => Term a b -> Term a c -> Bool;
matches t p = (case match_list (\ _ -> t) [(p, t)] of {
                Nothing -> False;
                Just _ -> True;
              });

smult_mat :: forall a. (Times a) => a -> Mat a -> Mat a;
smult_mat aa a = map_mat (times aa) a;

rep_multimap :: forall a b. Multimap a b -> (b -> a, (Mapping a [b], [b]));
rep_multimap (Abs_multimap x) = x;

option_list_to_list :: forall a. Maybe [a] -> [a];
option_list_to_list Nothing = [];
option_list_to_list (Just asa) = asa;

insertd :: forall a b. (Ccompare b, Eq b) => a -> Multimap b a -> Multimap b a;
insertd xb xc =
  Abs_multimap (case rep_multimap xc of {
                 (f, (m, alla)) -> let {
                                     k = f xb;
                                     old = option_list_to_list (lookupb m k);
                                     new = xb : old;
                                   } in (f, (updateb k new m, xb : alla));
               });

lookupc :: forall a b. (Ccompare a, Eq a) => Multimap a b -> a -> [b];
lookupc xa = (case rep_multimap xa of {
               (_, (m, _)) -> (\ k -> option_list_to_list (lookupb m k));
             });

valuesa :: forall a b. Multimap a b -> [b];
valuesa xa = (case rep_multimap xa of {
               (_, (_, alla)) -> alla;
             });

is_Inr :: forall a b. Sum a b -> Bool;
is_Inr (Inr uu) = True;
is_Inr (Inl uv) = False;

one_monom :: forall a. (Linorder a) => Monom a;
one_monom = Abs_monom [];

poly_split ::
  forall a b.
    (Eq a, Linorder a,
      Zero b) => Monom a -> [(Monom a, b)] -> (b, [(Monom a, b)]);
poly_split m p = (case extract (\ (n, _) -> m == n) p of {
                   Nothing -> (zerob, p);
                   Just (p1, ((_, c), p2)) -> (c, p1 ++ p2);
                 });

max_v ::
  forall a b.
    (Zero a, Ord a) => a -> ((b, Nat) -> [(Monom Nat, a)]) -> [(b, Nat)] -> a;
max_v v i fs =
  max v (foldr (\ f m -> max m (fst (poly_split one_monom (i f)))) fs zerob);

order :: forall a. (Eq a, Idom_divide a) => a -> Poly a -> Nat;
order a p =
  (if (case coeffs p of {
        [] -> True;
        _ : _ -> False;
      })
    then (error :: forall a. String -> (() -> a) -> a)
           "order of polynomial 0 undefined" (\ _ -> order a p)
    else (if not (polya p a == zerob) then zero_nat
           else suc (order a
                      (divide_poly p
                        (pCons (uminus a) (pCons onea zero_polya))))));

relcomp ::
  forall a b c.
    (Ceq a, Ccompare a, Set_impl a, Ceq b, Ccompare b, Ceq c, Ccompare c,
      Set_impl c) => Set (a, b) -> Set (b, c) -> Set (a, c);
relcomp (RBT_set rbt1) (RBT_set rbt2) =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "relcomp RBT_set RBT_set: ccompare1 = None"
        (\ _ -> relcomp (RBT_set rbt1) (RBT_set rbt2));
    Just _ ->
      (case ccompare of {
        Nothing ->
          (error :: forall a. String -> (() -> a) -> a)
            "relcomp RBT_set RBT_set: ccompare2 = None"
            (\ _ -> relcomp (RBT_set rbt1) (RBT_set rbt2));
        Just c_b ->
          (case (ccompare :: Maybe (c -> c -> Ordera)) of {
            Nothing ->
              (error :: forall a. String -> (() -> a) -> a)
                "relcomp RBT_set RBT_set: ccompare3 = None"
                (\ _ -> relcomp (RBT_set rbt1) (RBT_set rbt2));
            Just _ ->
              foldb (\ (x, y) ->
                      foldb (\ (ya, z) a ->
                              (if not (equal_order (c_b y ya) Eqa) then a
                                else inserta (x, z) a))
                        rbt2)
                rbt1 bot_set;
          });
      });
  });
relcomp (RBT_set rbt3) (DList_set dxs1) =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "relcomp RBT_set DList_set: ccompare1 = None"
        (\ _ -> relcomp (RBT_set rbt3) (DList_set dxs1));
    Just _ ->
      (case (ccompare :: Maybe (b -> b -> Ordera)) of {
        Nothing ->
          (error :: forall a. String -> (() -> a) -> a)
            "relcomp RBT_set DList_set: ccompare2 = None"
            (\ _ -> relcomp (RBT_set rbt3) (DList_set dxs1));
        Just _ ->
          (case ceq of {
            Nothing ->
              (error :: forall a. String -> (() -> a) -> a)
                "relcomp RBT_set DList_set: ceq2 = None"
                (\ _ -> relcomp (RBT_set rbt3) (DList_set dxs1));
            Just eq ->
              (case (ceq :: Maybe (c -> c -> Bool)) of {
                Nothing ->
                  (error :: forall a. String -> (() -> a) -> a)
                    "relcomp RBT_set DList_set: ceq3 = None"
                    (\ _ -> relcomp (RBT_set rbt3) (DList_set dxs1));
                Just _ ->
                  foldb (\ (x, y) ->
                          foldc (\ (ya, z) a ->
                                  (if eq y ya then inserta (x, z) a else a))
                            dxs1)
                    rbt3 bot_set;
              });
          });
      });
  });
relcomp (DList_set dxs2) (RBT_set rbt4) =
  (case (ceq :: Maybe (a -> a -> Bool)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "relcomp DList_set RBT_set: ceq1 = None"
        (\ _ -> relcomp (DList_set dxs2) (RBT_set rbt4));
    Just _ ->
      (case (ccompare :: Maybe (b -> b -> Ordera)) of {
        Nothing ->
          (error :: forall a. String -> (() -> a) -> a)
            "relcomp DList_set RBT_set: ceq2 = None"
            (\ _ -> relcomp (DList_set dxs2) (RBT_set rbt4));
        Just _ ->
          (case ceq of {
            Nothing ->
              (error :: forall a. String -> (() -> a) -> a)
                "relcomp DList_set RBT_set: ccompare2 = None"
                (\ _ -> relcomp (DList_set dxs2) (RBT_set rbt4));
            Just eq ->
              (case (ccompare :: Maybe (c -> c -> Ordera)) of {
                Nothing ->
                  (error :: forall a. String -> (() -> a) -> a)
                    "relcomp DList_set RBT_set: ccompare3 = None"
                    (\ _ -> relcomp (DList_set dxs2) (RBT_set rbt4));
                Just _ ->
                  foldc (\ (x, y) ->
                          foldb (\ (ya, z) a ->
                                  (if eq y ya then inserta (x, z) a else a))
                            rbt4)
                    dxs2 bot_set;
              });
          });
      });
  });
relcomp (DList_set dxs3) (DList_set dxs4) =
  (case (ceq :: Maybe (a -> a -> Bool)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "relcomp DList_set DList_set: ceq1 = None"
        (\ _ -> relcomp (DList_set dxs3) (DList_set dxs4));
    Just _ ->
      (case ceq of {
        Nothing ->
          (error :: forall a. String -> (() -> a) -> a)
            "relcomp DList_set DList_set: ceq2 = None"
            (\ _ -> relcomp (DList_set dxs3) (DList_set dxs4));
        Just eq ->
          (case (ceq :: Maybe (c -> c -> Bool)) of {
            Nothing ->
              (error :: forall a. String -> (() -> a) -> a)
                "relcomp DList_set DList_set: ceq3 = None"
                (\ _ -> relcomp (DList_set dxs3) (DList_set dxs4));
            Just _ ->
              foldc (\ (x, y) ->
                      foldc (\ (ya, z) a ->
                              (if eq y ya then inserta (x, z) a else a))
                        dxs4)
                dxs3 bot_set;
          });
      });
  });
relcomp (Set_Monad xs1) (Set_Monad xs2) =
  (case ceq of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "relcomp Set_Monad Set_Monad: ceq = None"
        (\ _ -> relcomp (Set_Monad xs1) (Set_Monad xs2));
    Just eq ->
      fold (\ (x, y) ->
             fold (\ (ya, z) a -> (if eq y ya then inserta (x, z) a else a))
               xs2)
        xs1 bot_set;
  });
relcomp (RBT_set rbt1) (Set_Monad xs3) =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "relcomp RBT_set Set_Monad: ccompare1 = None"
        (\ _ -> relcomp (RBT_set rbt1) (Set_Monad xs3));
    Just _ ->
      (case ccompare of {
        Nothing ->
          (error :: forall a. String -> (() -> a) -> a)
            "relcomp RBT_set Set_Monad: ccompare2 = None"
            (\ _ -> relcomp (RBT_set rbt1) (Set_Monad xs3));
        Just c_b ->
          foldb (\ (x, y) ->
                  fold (\ (ya, z) a ->
                         (if not (equal_order (c_b y ya) Eqa) then a
                           else inserta (x, z) a))
                    xs3)
            rbt1 bot_set;
      });
  });
relcomp (Set_Monad xs4) (RBT_set rbt5) =
  (case (ccompare :: Maybe (c -> c -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "relcomp Set_Monad RBT_set: ccompare1 = None"
        (\ _ -> relcomp (Set_Monad xs4) (RBT_set rbt5));
    Just _ ->
      (case ccompare of {
        Nothing ->
          (error :: forall a. String -> (() -> a) -> a)
            "relcomp Set_Monad RBT_set: ccompare2 = None"
            (\ _ -> relcomp (Set_Monad xs4) (RBT_set rbt5));
        Just c_b ->
          fold (\ (x, y) ->
                 foldb (\ (ya, z) a ->
                         (if not (equal_order (c_b y ya) Eqa) then a
                           else inserta (x, z) a))
                   rbt5)
            xs4 bot_set;
      });
  });
relcomp (DList_set dxs3) (Set_Monad xs5) =
  (case (ceq :: Maybe (a -> a -> Bool)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "relcomp DList_set Set_Monad: ceq1 = None"
        (\ _ -> relcomp (DList_set dxs3) (Set_Monad xs5));
    Just _ ->
      (case ceq of {
        Nothing ->
          (error :: forall a. String -> (() -> a) -> a)
            "relcomp DList_set Set_Monad: ceq2 = None"
            (\ _ -> relcomp (DList_set dxs3) (Set_Monad xs5));
        Just eq ->
          foldc (\ (x, y) ->
                  fold (\ (ya, z) a ->
                         (if eq y ya then inserta (x, z) a else a))
                    xs5)
            dxs3 bot_set;
      });
  });
relcomp (Set_Monad xs6) (DList_set dxs4) =
  (case ceq of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "relcomp Set_Monad DList_set: ceq1 = None"
        (\ _ -> relcomp (Set_Monad xs6) (DList_set dxs4));
    Just eq ->
      (case (ceq :: Maybe (c -> c -> Bool)) of {
        Nothing ->
          (error :: forall a. String -> (() -> a) -> a)
            "relcomp Set_Monad DList_set: ceq2 = None"
            (\ _ -> relcomp (Set_Monad xs6) (DList_set dxs4));
        Just _ ->
          fold (\ (x, y) ->
                 foldc (\ (ya, z) a ->
                         (if eq y ya then inserta (x, z) a else a))
                   dxs4)
            xs6 bot_set;
      });
  });

mspo_ub ::
  forall a b.
    (Eq a,
      Eq b) => (Term a b -> Term a b -> Bool) ->
                 (Term a b -> Term a b -> Bool) ->
                   (Term a b -> Term a b -> Bool) ->
                     Term a b -> Term a b -> Bool;
mspo_ub cS cNS cH s t = cH s t && spo_ub cS cNS s t;

max_sls :: forall a. (Linorder a) => Semilattice_set a;
max_sls = Abs_semilattice_set max;

errora :: forall a b. a -> Sum_bot a b;
errora x = Sumbot (Inl x);

tcapRM2 ::
  forall a b.
    (Eq a,
      Eq b) => ((a, Nat) -> [(Term a b, Term a b)]) -> Term a b -> Gctxt a b;
tcapRM2 uu (Var uv) = GCHole;
tcapRM2 rm (Fun f ts) =
  let {
    h = GCFun f (map (tcapRM2 rm) ts);
    n = size_list ts;
  } in (if any (\ r -> matchb h (fst r)) (rm (f, n)) then GCHole else h);

tcapRM ::
  forall a b.
    (Eq a,
      Eq b) => Bool ->
                 ((a, Nat) -> [(Term a b, Term a b)]) -> Term a b -> Gctxt a b;
tcapRM nlv rm = (if nlv then tcapRM2 rm else (\ _ -> GCHole));

rrewrite ::
  forall a b.
    (Eq a, Ccompare b, Eq b,
      Mapping_impl b) => [(Term a b, Term a b)] -> Term a b -> [Term a b];
rrewrite r s =
  concatMap (\ (l, ra) -> (case match s l of {
                            Nothing -> [];
                            Just sigma -> [eval_term Fun ra sigma];
                          }))
    r;

rewrite ::
  forall a b.
    (Eq a, Ccompare b, Eq b,
      Mapping_impl b) => [(Term a b, Term a b)] -> Term a b -> [Term a b];
rewrite r s =
  rrewrite r s ++
    (case s of {
      Var _ -> [];
      Fun f ss ->
        concatMap
          (\ (i, si) ->
            map (\ ti -> Fun f (list_update ss i ti)) (rewrite r si))
          (zip (upt zero_nat (size_list ss)) ss);
    });

hvf_term :: forall a b. (Eq a) => a -> Term a b -> Bool;
hvf_term a t = (case unapp a t of {
                 (Var _, ts) -> null ts;
                 (Fun _ us, ts) -> all (hvf_term a) (us ++ ts);
               });

max_list :: [Nat] -> Nat;
max_list [] = zero_nat;
max_list (x : xs) = max x (max_list xs);

char_0x23 :: Char;
char_0x23 = Chr (35 :: Integer);

special_map :: [Char] -> Maybe [Char];
special_map =
  map_of
    [([char_0x71, char_0x75, char_0x6F, char_0x74], [char_0x22]),
      ([char_0x23, char_0x33, char_0x34], [char_0x22]),
      ([char_0x61, char_0x6D, char_0x70], [char_0x26]),
      ([char_0x23, char_0x33, char_0x38], [char_0x26]),
      ([char_0x61, char_0x70, char_0x6F, char_0x73], [char_0x27]),
      ([char_0x23, char_0x33, char_0x39], [char_0x27]),
      ([char_0x6C, char_0x74], [char_0x3C]),
      ([char_0x23, char_0x36, char_0x30], [char_0x3C]),
      ([char_0x67, char_0x74], [char_0x3E]),
      ([char_0x23, char_0x36, char_0x32], [char_0x3E])];

filter_mset :: forall a. (a -> Bool) -> Multiset a -> Multiset a;
filter_mset p (Bag xs) = Bag (filterb (p . fst) xs);

filter_fun ::
  forall a b.
    Multiset (Term a b) ->
      ((a, Nat) -> (a, Nat) -> Bool) -> (a, Nat) -> Multiset (Term a b);
filter_fun t p f = filter_mset (\ a -> (case a of {
 Var _ -> False;
 Fun g ts -> p (g, size_list ts) f;
                                       }))
                     t;

check :: forall a. Bool -> a -> Sum a ();
check b e = (if b then Inr () else Inl e);

or_ok :: forall a. Sum a () -> Sum a () -> Sum a ();
or_ok (Inl a) b = b;
or_ok (Inr a) b = Inr a;

degree :: Complexity_class -> Nat;
degree (Comp_Poly d) = d;

gwpo_ns ::
  forall a b.
    (Eq a,
      Eq b) => (Term a b -> Term a b -> Bool) ->
                 (Term a b -> Term a b -> Bool) ->
                   ((a, Nat) -> (a, Nat) -> (Bool, Bool)) ->
                     (a -> a) -> Term a b -> Term a b -> Bool;
gwpo_ns cS cNS prc shp l r =
  equal_term l r ||
    not (is_Var l) &&
      not (is_Var r) &&
        (cS (sharp_term shp l) (sharp_term shp r) ||
          cNS (sharp_term shp l) (sharp_term shp r) &&
            snd (prc (the (root l)) (the (root r))));

gen_image ::
  forall a b c d e f g h.
    (a -> (b -> Bool) -> (c -> d -> e) -> f -> g) ->
      f -> (h -> d -> e) -> (c -> h) -> a -> g;
gen_image it1 emp2 ins2 f s1 = it1 s1 (\ _ -> True) (\ x -> ins2 (f x)) emp2;

catch_errora :: forall a b c. Sum a b -> (a -> Sum c b) -> Sum c b;
catch_errora m f = (case m of {
                     Inl a -> f a;
                     Inr a -> Inr a;
                   });

check_no_edge ::
  forall a.
    (a -> String -> String) ->
      ((a, a) -> Bool) -> a -> a -> Sum (String -> String) ();
check_no_edge ss g m n =
  check (not (g (m, n)))
    (((showsl_lit "edge from " . ss m) . showsl_lit " to ") . ss n);

forallM :: forall a b. (a -> Sum b ()) -> [a] -> Sum (a, b) ();
forallM f [] = Inr ();
forallM f (x : xs) =
  bindb (catch_errora (f x) (\ xa -> Inl (x, xa))) (\ _ -> forallM f xs);

check_edges ::
  forall a.
    (a -> String -> String) ->
      ((a, a) -> Bool) -> [a] -> [a] -> Sum (String -> String) ();
check_edges ss g c d =
  catch_errora
    (forallM
      (\ n ->
        catch_errora (forallM (check_no_edge ss g n) d) (\ x -> Inl (snd x)))
      c)
    (\ x -> Inl (snd x));

mult :: forall a b. Partial_object_ext a (Monoid_ext a b) -> a -> a -> a;
mult (Partial_object_ext carrier (Monoid_ext mult one more)) = mult;

comp2eq :: forall a b. (a -> b -> Comp_res) -> a -> b -> Bool;
comp2eq cmp a b = (case cmp a b of {
                    LESS -> False;
                    EQUAL -> True;
                    GREATER -> False;
                  });

prec_ext ::
  forall a b. (Eq a) => (a -> Maybe (Nat, b)) -> a -> a -> (Bool, Bool);
prec_ext prwm =
  (\ f g ->
    (case prwm f of {
      Nothing -> (False, f == g);
      Just pf ->
        (case prwm g of {
          Nothing -> (True, True);
          Just pg ->
            (less_nat (fst pg) (fst pf), less_eq_nat (fst pg) (fst pf));
        });
    }));

assertion ::
  forall a b c d e. Lts_ext a b c d e -> d -> Formula (Term a (b, c));
assertion (Lts_ext initial transition_rules assertion more) = assertion;

map_of_total ::
  forall a b.
    (Ccompare a, Eq a,
      Mapping_impl a) => (a -> String -> String) -> [(a, b)] -> a -> b;
map_of_total err xys =
  let {
    m = of_alist xys;
  } in (\ x ->
         (case lookupb m x of {
           Nothing ->
             (error :: forall a. String -> (() -> a) -> a) (err x "")
               (\ _ -> the Nothing);
           Just y -> y;
         }));

transition_of ::
  forall a b c d e.
    (Ccompare e, Eq e, Mapping_impl e,
      Showl e) => Lts_impl a b c d e -> e -> Transition_rule a b c d;
transition_of pi =
  map_of_total
    (\ a ->
      ((showsl_lit "access to non-existing transition " . showsl a) .
        showsl_lit "\navailable transitions:\n") .
        showsl_list (map fst (transitions_impl pi)))
    (transitions_impl pi);

matcha :: forall a b. (Term a b, Term a b) -> Term a b -> Bool;
matcha = (\ _ _ -> True);

fold_impl :: forall a b. (a -> Nat -> b -> b) -> b -> [(a, Nat)] -> b;
fold_impl fn e ((a, n) : ms) = fold_impl fn (fn a n e) ms;
fold_impl fn e [] = e;

foldd :: forall a b. (a -> Nat -> b -> b) -> b -> Alist a Nat -> b;
foldd f e al = fold_impl f e (impl_ofa al);

set_mset :: forall a. (Ceq a, Ccompare a, Set_impl a) => Multiset a -> Set a;
set_mset (Bag ms) =
  foldd (\ a n -> (if equal_nat n zero_nat then (\ m -> m) else inserta a))
    bot_set ms;

fresh_strings_list :: [Char] -> Nat -> [[Char]] -> Nat -> [[Char]];
fresh_strings_list name offset used n =
  take n
    (filter (\ s -> not (membera (remdups used) s))
      (map (\ i -> name ++ shows_prec_nat zero_nat (plus_nat i offset) [])
        (upt zero_nat (plus_nat n (size_list (remdups used))))));

fresh_string :: [Char] -> [[Char]] -> [Char];
fresh_string pre = (\ s -> hda (fresh_strings_list pre one_nat s one_nat));

mapMa :: forall a b. (a -> Maybe b) -> [a] -> Maybe [b];
mapMa f [] = Just [];
mapMa f (x : xs) =
  bind (f x) (\ y -> bind (mapMa f xs) (\ ys -> Just (y : ys)));

degreea :: forall a. (Zero a) => Poly a -> Nat;
degreea p = minus_nat (size_list (coeffs p)) one_nat;

pderiv_coeffs_code ::
  forall a.
    (Eq a, Comm_semiring_1 a, Semiring_no_zero_divisors a) => a -> [a] -> [a];
pderiv_coeffs_code f (x : xs) =
  cCons (times f x) (pderiv_coeffs_code (plus f onea) xs);
pderiv_coeffs_code f [] = [];

pderiv_coeffs ::
  forall a.
    (Eq a, Comm_semiring_1 a, Semiring_no_zero_divisors a) => [a] -> [a];
pderiv_coeffs xs = pderiv_coeffs_code onea (tla xs);

pderiv ::
  forall a.
    (Eq a, Comm_semiring_1 a, Semiring_no_zero_divisors a) => Poly a -> Poly a;
pderiv p = Poly (pderiv_coeffs (coeffs p));

converse ::
  forall a b.
    (Ceq a, Ccompare a, Set_impl a, Ceq b, Ccompare b,
      Set_impl b) => Set (a, b) -> Set (b, a);
converse r = image (\ (x, y) -> (y, x)) r;

returna :: forall a b. a -> Sum_bot b a;
returna x = Sumbot (Inr x);

the_Var :: forall a b. Term a b -> b;
the_Var (Var x1) = x1;

sum_mset :: forall a. (Comm_monoid_add a) => Multiset a -> a;
sum_mset (Bag ms) = foldd (\ a n -> funpow n (plus a)) zerob ms;

vars_term_ms :: forall a b. (Eq b) => Term a b -> Multiset b;
vars_term_ms (Var x) = add_mset x zero_multiset;
vars_term_ms (Fun f ts) = sum_mset (mset (map vars_term_ms ts));

in_poss :: forall a b. [Nat] -> Term a b -> Bool;
in_poss [] uu = True;
in_poss (i : p) (Fun f ts) = less_nat i (size_list ts) && in_poss p (nth ts i);
in_poss (i : p) (Var uv) = False;

subt_at :: forall a b. Term a b -> [Nat] -> Term a b;
subt_at s [] = s;
subt_at (Fun f ss) (i : p) = subt_at (nth ss i) p;

add_funs_term :: forall a b. Term a b -> [a] -> [a];
add_funs_term (Var uu) fs = fs;
add_funs_term (Fun f ts) fs = f : foldr add_funs_term ts fs;

add_funs_rule :: forall a b. (Term a b, Term a b) -> [a] -> [a];
add_funs_rule r fs = add_funs_term (fst r) (add_funs_term (snd r) fs);

funs_trs_list :: forall a b. [(Term a b, Term a b)] -> [a];
funs_trs_list trs = foldr add_funs_rule trs [];

instance_rule ::
  forall a b c.
    (Eq a, Eq b, Ccompare c, Eq c,
      Mapping_impl c) => (Term a b, Term a b) -> (Term a c, Term a c) -> Bool;
instance_rule lr st =
  not (is_none
        (match_list (\ _ -> fst lr) [(fst st, fst lr), (snd st, snd lr)]));

map_funs_rule ::
  forall a b c. (a -> b) -> (Term a c, Term a c) -> (Term b c, Term b c);
map_funs_rule fg lr =
  (map_term fg (\ x -> x) (fst lr), map_term fg (\ x -> x) (snd lr));

add_vars_rule :: forall a b. (Term a b, Term a b) -> [b] -> [b];
add_vars_rule r xs = add_vars_term (fst r) (add_vars_term (snd r) xs);

vars_trs_list :: forall a b. [(Term a b, Term a b)] -> [b];
vars_trs_list trs = foldr add_vars_rule trs [];

is_root_step ::
  forall a b.
    (Compare a, Eq a, Ccompare b, Compare b, Eq b,
      Mapping_impl b) => Set (Term a b, Term a b) ->
                           Term a b -> Term a b -> Bool;
is_root_step r s t =
  bex r (\ (l, ra) -> (case match_list Var [(l, s), (ra, t)] of {
                        Nothing -> False;
                        Just _ -> True;
                      }));

is_rstep ::
  forall a b.
    (Compare a, Eq a, Ccompare b, Compare b, Eq b,
      Mapping_impl b) => Set (Term a b, Term a b) ->
                           Term a b -> Term a b -> Bool;
is_rstep r (Fun f ts) (Fun g ss) =
  f == g &&
    equal_nat (size_list ts) (size_list ss) &&
      any (\ i ->
            ss == list_update ts i (nth ss i) &&
              is_rstep r (nth ts i) (nth ss i))
        (upt zero_nat (size_list ss)) ||
    is_root_step r (Fun f ts) (Fun g ss);
is_rstep r (Var v) t = is_root_step r (Var v) t;
is_rstep r s (Var v) = is_root_step r s (Var v);

elem_list_to_rm ::
  forall a b. (Compare_order b) => (a -> b) -> [a] -> Rbt b [a];
elem_list_to_rm key [] = empty;
elem_list_to_rm key (d : ds) = let {
                                 t = elem_list_to_rm key ds;
                                 k = key d;
                               } in (case lookup t k of {
                                      Nothing -> insert k [d] t;
                                      Just dataa -> insert k (d : dataa) t;
                                    });

term_map ::
  forall a b. (Compare_order a) => [Term a b] -> (a, Nat) -> [Term a b];
term_map ts = fun_of_map (lookup (elem_list_to_rm (the . root) ts)) [];

label_depth :: forall a b. Lab a b -> Nat;
label_depth (UnLab uu) = zero_nat;
label_depth (Lab f uv) = suc (label_depth f);
label_depth (FunLab f uw) = suc (label_depth f);
label_depth (Sharp f) = suc (label_depth f);

gen_label :: forall a b. Lab a b -> Nat -> Lab a b;
gen_label f n =
  (if equal_nat n zero_nat then f
    else FunLab (gen_label f (minus_nat n one_nat)) []);

fmap ::
  forall a b.
    (Eq a,
      Eq b) => Lab a b ->
                 Nat ->
                   [((Lab a b, Nat), [Lab a b])] -> Lab a b -> Nat -> Lab a b;
fmap a nn sml =
  let {
    m = suc (max_list (map label_depth (a : concatMap snd sml)));
  } in (\ f n -> (if (f, n) == (a, nn) then a else gen_label f m));

enum_vectors :: forall a b. [a] -> [b] -> [[(b, a)]];
enum_vectors c [] = [[]];
enum_vectors c (x : xs) =
  let {
    a = enum_vectors c xs;
  } in concatMap (\ vec -> map (\ ca -> (x, ca) : vec) c) a;

replace_impl :: forall a. (Eq a) => a -> [a] -> [a] -> [a];
replace_impl a bs m =
  (if membera m a then bs ++ filter (\ b -> not (b == a)) m else m);

index_term_aux ::
  forall a b.
    Int -> Term a b -> (Int, Term (a, (Term a b, Int)) (b, (Term a b, Int)));
index_term_aux i (Var v) = (plus_int i one_int, Var (v, (Var v, i)));
index_term_aux i (Fun f ts) =
  (case index_term_aux_list i ts of {
    (j, ss) -> (plus_int j one_int, Fun (f, (Fun f ts, j)) ss);
  });

index_term_aux_list ::
  forall a b.
    Int ->
      [Term a b] -> (Int, [Term (a, (Term a b, Int)) (b, (Term a b, Int))]);
index_term_aux_list i [] = (i, []);
index_term_aux_list i (t : ts) =
  (case index_term_aux i t of {
    (j, s) -> map_prod id (\ a -> s : a) (index_term_aux_list j ts);
  });

index_term ::
  forall a b. Term a b -> Term (a, (Term a b, Int)) (b, (Term a b, Int));
index_term t = snd (index_term_aux zero_int t);

lex_ext_unbounded_mem ::
  forall a.
    (Mapping (Int, Int) (Bool, Bool) ->
      (a, a) -> ((Bool, Bool), Mapping (Int, Int) (Bool, Bool))) ->
      Mapping (Int, Int) (Bool, Bool) ->
        [a] -> [a] -> ((Bool, Bool), Mapping (Int, Int) (Bool, Bool));
lex_ext_unbounded_mem f mem [] [] = ((False, True), mem);
lex_ext_unbounded_mem f mem (uu : uv) [] = ((True, True), mem);
lex_ext_unbounded_mem f mem [] (uw : ux) = ((False, False), mem);
lex_ext_unbounded_mem f mem (a : asa) (b : bs) =
  (case f mem (a, b) of {
    ((True, _), mem_new) -> ((True, True), mem_new);
    ((False, True), mem_new) -> lex_ext_unbounded_mem f mem_new asa bs;
    ((False, False), mem_new) -> ((False, False), mem_new);
  });

equal_order_tag :: Order_tag -> Order_tag -> Bool;
equal_order_tag Lex Mul = False;
equal_order_tag Mul Lex = False;
equal_order_tag Mul Mul = True;
equal_order_tag Lex Lex = True;

or2 :: (Bool, Bool) -> (Bool, Bool) -> (Bool, Bool);
or2 a b = (fst a || fst b, snd a || snd b);

filter_mem ::
  forall a b c d.
    (a -> b) -> (c -> b -> (d, c)) -> (d -> Bool) -> c -> [a] -> ([a], c);
filter_mem pre f post mem [] = ([], mem);
filter_mem pre f post mem (x : xs) =
  (case f mem (pre x) of {
    (c, mema) ->
      (case filter_mem pre f post mema xs of {
        (ys, memb) -> (if post c then (x : ys, memb) else (ys, memb));
      });
  });

mul_ext_mem ::
  forall a.
    (Mapping (Int, Int) (Bool, Bool) ->
      (a, a) -> ((Bool, Bool), Mapping (Int, Int) (Bool, Bool))) ->
      Mapping (Int, Int) (Bool, Bool) ->
        [a] -> [a] -> ((Bool, Bool), Mapping (Int, Int) (Bool, Bool));
mul_ext_mem f mem [] [] = ((False, True), mem);
mul_ext_mem f mem [] (v : va) = ((False, False), mem);
mul_ext_mem f mem (v : va) [] = ((True, True), mem);
mul_ext_mem f mem (v : va) (y : ys) = mul_ext_dom_mem f mem (v : va) [] y ys;

mul_ext_dom_mem ::
  forall a.
    (Mapping (Int, Int) (Bool, Bool) ->
      (a, a) -> ((Bool, Bool), Mapping (Int, Int) (Bool, Bool))) ->
      Mapping (Int, Int) (Bool, Bool) ->
        [a] ->
          [a] -> a -> [a] -> ((Bool, Bool), Mapping (Int, Int) (Bool, Bool));
mul_ext_dom_mem f mem [] xs y ys = ((False, False), mem);
mul_ext_dom_mem f mem (x : xsa) xs y ys =
  (case f mem (x, y) of {
    ((True, _), mem_new_1) ->
      (case filter_mem (\ a -> (x, a)) f (\ p -> not (fst p)) mem_new_1 ys of {
        (ys_new, mem_new_2) ->
          (case mul_ext_mem f mem_new_2 (xsa ++ xs) ys_new of {
            (tmp_res, mem_new_3) ->
              (if snd tmp_res then ((True, True), mem_new_3)
                else mul_ext_dom_mem f mem_new_3 xsa (x : xs) y ys);
          });
      });
    ((False, True), mem_new_1) ->
      (case mul_ext_mem f mem_new_1 (xsa ++ xs) ys of {
        (sns_res_a, mem_new_2) ->
          (if sns_res_a == (True, True) then (sns_res_a, mem_new_2)
            else (case mul_ext_dom_mem f mem_new_2 xsa (x : xs) y ys of {
                   (sns_res_b, a) -> (or2 sns_res_a sns_res_b, a);
                 }));
      });
    ((False, False), mem_new_1) ->
      mul_ext_dom_mem f mem_new_1 xsa (x : xs) y ys;
  });

forall_mem ::
  forall a b c d.
    (a -> b) -> (c -> b -> (d, c)) -> (d -> Bool) -> c -> [a] -> (Bool, c);
forall_mem pre f post mem [] = (True, mem);
forall_mem pre f post mem (x : xs) =
  (case f mem (pre x) of {
    (c, mema) ->
      (if post c then forall_mem pre f post mema xs else (False, mema));
  });

exists_mem ::
  forall a b c d.
    (a -> b) -> (c -> b -> (d, c)) -> (d -> Bool) -> c -> [a] -> (Bool, c);
exists_mem pre f post mem [] = (False, mem);
exists_mem pre f post mem (x : xs) =
  (case f mem (pre x) of {
    (c, mema) ->
      (if post c then (True, mema) else exists_mem pre f post mema xs);
  });

name_of :: forall a b. (a, b) -> a;
name_of (a, uu) = a;

stored ::
  forall a b. Term (a, (Term a b, Int)) (b, (Term a b, Int)) -> Term a b;
stored (Var (v, (s, uu))) = s;
stored (Fun (f, (s, uv)) ts) = s;

index :: forall a b. Term (a, (Term a b, Int)) (b, (Term a b, Int)) -> Int;
index (Var (uu, (uv, i))) = i;
index (Fun (uw, (ux, i)) uy) = i;

wpo_mem ::
  forall a b.
    (Eq b) => ((a, Nat) -> (a, Nat) -> (Bool, Bool)) ->
                ((a, Nat) -> Bool) ->
                  Bool ->
                    ((a, Nat) -> Bool) ->
                      (Term a b -> Term a b -> Bool) ->
                        (Term a b -> Term a b -> Bool) ->
                          Status a ->
                            ((a, Nat) -> Order_tag) ->
                              Mapping (Int, Int) (Bool, Bool) ->
                                (Term (a, (Term a b, Int)) (b, (Term a b, Int)),
                                  Term (a, (Term a b, Int))
                                    (b, (Term a b, Int))) ->
                                  ((Bool, Bool),
                                    Mapping (Int, Int) (Bool, Bool));
wpo_mem pr prl ssimple large cS cNS sigma c mem (s, t) =
  let {
    i = index s;
    j = index t;
  } in (case lookupb mem (i, j) of {
         Nothing ->
           (case wpo_main pr prl ssimple large cS cNS sigma c mem (s, t) of {
             (res, mem_new) -> (res, updateb (i, j) res mem_new);
           });
         Just res -> (res, mem);
       });

wpo_main ::
  forall a b.
    (Eq b) => ((a, Nat) -> (a, Nat) -> (Bool, Bool)) ->
                ((a, Nat) -> Bool) ->
                  Bool ->
                    ((a, Nat) -> Bool) ->
                      (Term a b -> Term a b -> Bool) ->
                        (Term a b -> Term a b -> Bool) ->
                          Status a ->
                            ((a, Nat) -> Order_tag) ->
                              Mapping (Int, Int) (Bool, Bool) ->
                                (Term (a, (Term a b, Int)) (b, (Term a b, Int)),
                                  Term (a, (Term a b, Int))
                                    (b, (Term a b, Int))) ->
                                  ((Bool, Bool),
                                    Mapping (Int, Int) (Bool, Bool));
wpo_main pr prl ssimple large cS cNS sigma c mem (s, t) =
  let {
    fs = stored s;
    ft = stored t;
  } in (if cS fs ft then ((True, True), mem)
         else (if cNS fs ft
                then (case s of {
                       Var x ->
                         ((False,
                            (case t of {
                              Var y -> name_of x == name_of y;
                              Fun g ts ->
                                null (status sigma (name_of g, size_list ts)) &&
                                  prl (name_of g, size_list ts);
                            })),
                           mem);
                       Fun f ss ->
                         let {
                           ff = (name_of f, size_list ss);
                           sf = status sigma ff;
                           ssa = map (nth ss) sf;
                         } in (case exists_mem (\ sa -> (sa, t))
                                      (wpo_mem pr prl ssimple large cS cNS sigma
c)
                                      snd mem ssa
                                of {
                                (True, mem_out_1) -> ((True, True), mem_out_1);
                                (False, mem_out_1) ->
                                  (case t of {
                                    Var _ ->
                                      ((False, ssimple && large ff), mem_out_1);
                                    Fun g ts ->
                                      let {
gg = (name_of g, size_list ts);
sg = status sigma gg;
tsa = map (nth ts) sg;
                                      } in
(case pr ff gg of {
  (prs, True) ->
    (case forall_mem (\ a -> (s, a))
            (wpo_mem pr prl ssimple large cS cNS sigma c) fst mem_out_1 tsa
      of {
      (True, mem_out_2) ->
        (if prs then ((True, True), mem_out_2)
          else let {
                 cf = c ff;
                 cg = c gg;
               } in (if equal_order_tag cf Lex && equal_order_tag cg Lex
                      then lex_ext_unbounded_mem
                             (wpo_mem pr prl ssimple large cS cNS sigma c)
                             mem_out_2 ssa tsa
                      else (if equal_order_tag cf Mul && equal_order_tag cg Mul
                             then mul_ext_mem
                                    (wpo_mem pr prl ssimple large cS cNS sigma
                                      c)
                                    mem_out_2 ssa tsa
                             else (if null tsa
                                    then ((not (null ssa), True), mem_out_2)
                                    else ((False, False), mem_out_2)))));
      (False, mem_out_2) -> ((False, False), mem_out_2);
    });
  (_, False) -> ((False, False), mem_out_1);
});
                                  });
                              });
                     })
                else ((False, False), mem)));

wpo_mem_impl ::
  forall a b.
    (Eq b) => ((a, Nat) -> (a, Nat) -> (Bool, Bool)) ->
                ((a, Nat) -> Bool) ->
                  Bool ->
                    ((a, Nat) -> Bool) ->
                      (Term a b -> Term a b -> Bool) ->
                        (Term a b -> Term a b -> Bool) ->
                          Status a ->
                            ((a, Nat) -> Order_tag) ->
                              Term a b -> Term a b -> (Bool, Bool);
wpo_mem_impl pr prl ssimple large cS cNS sigma c s t =
  fst (wpo_mem pr prl ssimple large cS cNS sigma c
        (mapping_empty
          (of_phantom (mapping_impl_prod :: Phantom (Int, Int) Mapping_impla)))
        (index_term s, index_term t));

wpo_ub ::
  forall a b.
    (Eq b) => ((a, Nat) -> (a, Nat) -> (Bool, Bool)) ->
                ((a, Nat) -> Bool) ->
                  Bool ->
                    ((a, Nat) -> Bool) ->
                      (Term a b -> Term a b -> Bool) ->
                        (Term a b -> Term a b -> Bool) ->
                          Status a ->
                            ((a, Nat) -> Order_tag) ->
                              Term a b -> Term a b -> (Bool, Bool);
wpo_ub pr prl ssimple large cS cNS sigma c s t =
  wpo_mem_impl pr prl ssimple large cS cNS sigma c s t;

large_of :: forall a. ((a, Nat) -> Nat) -> Status a -> [(a, Nat)] -> Maybe Nat;
large_of pr sigma fs =
  let {
    m = max_list (map pr fs);
    ls = filter (\ f -> equal_nat (pr f) m) fs;
  } in (if less_nat zero_nat m && all (\ f -> null (status sigma f)) ls
         then Just m else Nothing);

doc_of_string :: [Char] -> Sum [Char] Xmldoc;
doc_of_string s = bindb (parse_doc s) (\ (doc, _) -> Inr doc);

map_xml_text :: ([Char] -> [Char]) -> Xml -> Xml;
map_xml_text f (XML t asa cs) = XML t asa (map (map_xml_text f) cs);
map_xml_text f (XML_text txt) = XML_text (f txt);

cp_peak :: forall a b. Crit_pair_info a b -> Maybe (Term a b);
cp_peak (Crit_Pair_Info x1 x2 x3 x4 x5 x6) = x2;

cpPeak :: forall a b. Crit_pair_info a b -> Term a b;
cpPeak = the . cp_peak;

choice :: forall a b. [Sum a b] -> Sum [a] b;
choice [] = Inl [];
choice (x : xs) =
  catch_errora x (\ e -> catch_errora (choice xs) (\ xa -> Inl (e : xa)));

firstM :: forall a b c. (a -> Sum b c) -> [a] -> Sum [b] a;
firstM f [] = Inl [];
firstM f (x : xs) =
  catch_errora (bindb (f x) (\ _ -> Inr x))
    (\ e -> catch_errora (firstM f xs) (\ xa -> Inl (e : xa)));

gen_filter ::
  forall a b c d e f.
    (a -> (b -> Bool) -> (c -> d -> d) -> e -> f) ->
      e -> (c -> d -> d) -> (c -> Bool) -> a -> f;
gen_filter it1 emp2 ins2 p s1 =
  it1 s1 (\ _ -> True) (\ x s -> (if p x then ins2 x s else s)) emp2;

gt_term ::
  forall a b c d.
    (Eq a,
      Eq c) => Bool ->
                 Bool ->
                   (Maybe (a, Nat) -> Maybe (b, Nat) -> Bool) ->
                     ((a, Nat) -> [(Term a c, Term a c)]) ->
                       Term a c -> Term b d -> Bool;
gt_term nlv ne gt_fun rm s t =
  ne && let {
          root1 = root s;
          root2 = root t;
        } in (is_Var s ||
               (is_Var t ||
                 (gt_fun Nothing Nothing ||
                   (gt_fun root1 root2 ||
                     (gt_fun root1 Nothing || gt_fun Nothing root2))))) &&
               (if nlv
                 then (case root1 of {
                        Nothing -> True;
                        Just fn ->
                          any (\ r -> matchb (tcapRM nlv rm s) (fst r)) (rm fn);
                      })
                 else True);

rd_impl ::
  forall a b c.
    (Eq a) => (Term a b -> Term a c -> Bool) ->
                (Term a b, Term a c) -> [(Term a b, Term a c)];
rd_impl gt (Fun f ss, Fun g ts) =
  (if f == g &&
        equal_nat (size_list ss) (size_list ts) &&
          not (gt (Fun f ss) (Fun g ts))
    then concatMap (rd_impl gt) (zip ss ts) else [(Fun f ss, Fun g ts)]);
rd_impl uu (Var v, t) = [(Var v, t)];
rd_impl uu (s, Var v) = [(s, Var v)];

relpow_impl ::
  forall a b.
    ([a] -> [a]) -> ([a] -> b -> b) -> (a -> b -> Bool) -> [a] -> b -> Nat -> b;
relpow_impl succ un memb new have m =
  (if equal_nat m zero_nat then un new have
    else (if null new then have
           else let {
                  maybe = succ new;
                  havea = un new have;
                  newa = filter (\ n -> not (memb n havea)) maybe;
                } in relpow_impl succ un memb newa havea
                       (minus_nat m one_nat)));

trancl_impl ::
  forall a b.
    ([(a, a)] -> [a] -> [a]) ->
      ([a] -> b -> b) -> (a -> b -> Bool) -> b -> [(a, a)] -> [a] -> b;
trancl_impl gen_succ un memb emp rel =
  let {
    succ = gen_succ rel;
    n = size_list rel;
  } in (\ asa -> relpow_impl succ un memb (succ asa) emp n);

trancl_list_impl :: forall a. (Eq a) => [(a, a)] -> [a] -> [a];
trancl_list_impl =
  trancl_impl
    (\ r asa ->
      remdups
        (map_filter
          (\ x ->
            (if (case x of {
                  (a, _) -> membera asa a;
                })
              then Just (snd x) else Nothing))
          r))
    (\ xs ys -> filter (\ x -> not (membera ys x)) xs ++ ys)
    (\ x xs -> membera xs x) [];

memo_list_trancl :: forall a. (Eq a) => [(a, a)] -> a -> [a];
memo_list_trancl r = let {
                       tr = trancl_list_impl r;
                       rm = map (\ a -> (a, tr [a])) ((remdups . map fst) r);
                     } in (\ a -> (case map_of rm a of {
                                    Nothing -> [];
                                    Just asa -> asa;
                                  }));

mk_gt_fun ::
  forall a b c.
    (Eq a) => [(Term a b, Term a c)] ->
                Maybe (a, Nat) -> Maybe (a, Nat) -> Bool;
mk_gt_fun rs = let {
                 in_trancl = memo_list_trancl (gt1 rs);
               } in (\ f -> membera (in_trancl f));

gT_impl ::
  forall a b c d e.
    (Eq a) => [(Term a b, Term a c)] -> Term a d -> Term a e -> Bool;
gT_impl r s t =
  is_Var s ||
    (is_Var t ||
      (mk_gt_fun r (root s) (root t) ||
        (mk_gt_fun r (root s) Nothing ||
          (mk_gt_fun r Nothing (root t) || mk_gt_fun r Nothing Nothing))));

nodes_lts_impl :: forall a b c d e. (Eq d) => Lts_impl a b c d e -> [d];
nodes_lts_impl pi =
  remdups
    (map (source . snd) (transitions_impl pi) ++
      map (target . snd) (transitions_impl pi));

rec_list :: forall a b. a -> (b -> [b] -> a -> a) -> [b] -> a;
rec_list f1 f2 [] = f1;
rec_list f1 f2 (x21 : x22) = f2 x21 x22 (rec_list f1 f2 x22);

product_lists :: forall a. [[a]] -> [[a]];
product_lists [] = [[]];
product_lists (xs : xss) =
  concatMap (\ x -> map (\ a -> x : a) (product_lists xss)) xs;

height :: forall a. (a, Nat) -> Nat;
height (f, h) = h;

mat_of_rows :: forall a. Nat -> [Vec a] -> Mat a;
mat_of_rows n rs = mat (size_list rs) n (\ (i, a) -> vec_index (nth rs i) a);

vec_of_list_impl :: forall a. [a] -> Vec_impl a;
vec_of_list_impl xa = Abs_vec_impl (size_list xa, IArray.of_list xa);

vec_of_list :: forall a. [a] -> Vec a;
vec_of_list v = Vec_impl (vec_of_list_impl v);

showsl_literal :: String -> String -> String;
showsl_literal s = showsl_lit s;

showsl_monom_list ::
  forall a. (Linorder a, Showl a) => [(a, Nat)] -> String -> String;
showsl_monom_list [(x, p)] =
  (if equal_nat p one_nat then showsl_lit "x" . showsl x
    else ((showsl_lit "x" . showsl x) . showsl_lit "^") . showsl_nat p);
showsl_monom_list ((x, p) : v : va) =
  ((if equal_nat p one_nat then showsl_lit "x" . showsl x
     else ((showsl_lit "x" . showsl x) . showsl_literal "^") . showsl_nat p) .
    showsl_literal "*") .
    showsl_monom_list (v : va);
showsl_monom_list [] = showsl_literal "1";

showsl_monom :: forall a. (Linorder a, Showl a) => Monom a -> String -> String;
showsl_monom xa = showsl_monom_list (rep_monom xa);

showsl_poly ::
  forall a b.
    (Eq a, Linorder a, Showl a, One b, Eq b,
      Showl b) => [(Monom a, b)] -> String -> String;
showsl_poly [] = showsl_lit "0";
showsl_poly ((m, c) : p) =
  (if c == onea then showsl_monom m
    else (if m == one_monom then showsl c
           else (showsl c . showsl_lit "*") . showsl_monom m)) .
    (if null p then id else showsl_lit " + " . showsl_poly p);

check_poly_ge ::
  forall a b.
    (Eq a, Linorder a,
      Ordered_semiring_0a b) => [(Monom a, b)] -> [(Monom a, b)] -> Bool;
check_poly_ge [] q = all (\ (_, d) -> less_eq d zerob) q;
check_poly_ge ((m, c) : p) q =
  (case extract (\ nd -> fst nd == m) q of {
    Nothing -> less_eq zerob c && check_poly_ge p q;
    Just (q1, ((_, d), q2)) -> less_eq d c && check_poly_ge p (q1 ++ q2);
  });

check_poly_gt ::
  forall a b.
    (Ordered_semiring_0a a, Eq b,
      Linorder b) => (a -> a -> Bool) ->
                       [(Monom b, a)] -> [(Monom b, a)] -> Bool;
check_poly_gt gt p q =
  (case poly_split one_monom p of {
    (a1, p1) -> (case poly_split one_monom q of {
                  (b1, q1) -> gt a1 b1 && check_poly_ge p1 q1;
                });
  });

monom_mult_list ::
  forall a. (Eq a, Linorder a) => [(a, Nat)] -> [(a, Nat)] -> [(a, Nat)];
monom_mult_list [] n = n;
monom_mult_list ((x, p) : m) n =
  (case n of {
    [] -> (x, p) : m;
    (y, q) : na ->
      (if x == y then (x, plus_nat p q) : monom_mult_list m na
        else (if less x y then (x, p) : monom_mult_list m n
               else (y, q) : monom_mult_list ((x, p) : m) na));
  });

times_monom :: forall a. (Eq a, Linorder a) => Monom a -> Monom a -> Monom a;
times_monom xb xc = Abs_monom (monom_mult_list (rep_monom xb) (rep_monom xc));

monom_mult_poly ::
  forall a b.
    (Eq a, Linorder a, Eq b,
      Semiring_0 b) => (Monom a, b) -> [(Monom a, b)] -> [(Monom a, b)];
monom_mult_poly uu [] = [];
monom_mult_poly (ma, c) ((m, d) : p) =
  (if times c d == zerob then monom_mult_poly (ma, c) p
    else (times_monom ma m, times c d) : monom_mult_poly (ma, c) p);

poly_add ::
  forall a b.
    (Eq a, Linorder a, Eq b,
      Semiring_0 b) => [(Monom a, b)] -> [(Monom a, b)] -> [(Monom a, b)];
poly_add [] q = q;
poly_add ((m, c) : p) q =
  (case extract (\ mc -> fst mc == m) q of {
    Nothing -> (m, c) : poly_add p q;
    Just (q1, ((_, d), q2)) ->
      (if plus c d == zerob then poly_add p (q1 ++ q2)
        else (m, plus c d) : poly_add p (q1 ++ q2));
  });

poly_mult ::
  forall a b.
    (Eq a, Linorder a, Eq b,
      Semiring_0 b) => [(Monom a, b)] -> [(Monom a, b)] -> [(Monom a, b)];
poly_mult [] q = [];
poly_mult (mc : p) q = poly_add (monom_mult_poly mc q) (poly_mult p q);

one_poly :: forall a b. (Linorder a, Semiring_1 b) => [(Monom a, b)];
one_poly = [(one_monom, onea)];

poly_power ::
  forall a b.
    (Eq a, Linorder a, Eq b,
      Comm_semiring_1 b) => [(Monom a, b)] -> Nat -> [(Monom a, b)];
poly_power uu n =
  (if equal_nat n zero_nat then one_poly
    else poly_mult uu (poly_power uu (minus_nat n one_nat)));

monom_list_subst ::
  forall a b c.
    (Eq b, Linorder b, Eq c,
      Comm_semiring_1 c) => (a -> [(Monom b, c)]) ->
                              [(a, Nat)] -> [(Monom b, c)];
monom_list_subst sigma [] = one_poly;
monom_list_subst sigma ((x, p) : m) =
  poly_mult (poly_power (sigma x) p) (monom_list_subst sigma m);

monom_list :: forall a. (Linorder a) => Monom a -> [(a, Nat)];
monom_list x = rep_monom x;

monom_subst ::
  forall a b c.
    (Linorder a, Eq b, Linorder b, Eq c,
      Comm_semiring_1 c) => (a -> [(Monom b, c)]) -> Monom a -> [(Monom b, c)];
monom_subst sigma m = monom_list_subst sigma (monom_list m);

zero_poly :: forall a b. [(Monom a, b)];
zero_poly = [];

poly_subst ::
  forall a b c.
    (Linorder a, Eq b, Linorder b, Eq c,
      Comm_semiring_1 c) => (a -> [(Monom b, c)]) ->
                              [(Monom a, c)] -> [(Monom b, c)];
poly_subst sigma [] = zero_poly;
poly_subst sigma ((m, c) : p) =
  poly_add (poly_mult [(one_monom, c)] (monom_subst sigma m))
    (poly_subst sigma p);

var_monom :: forall a. (Linorder a) => a -> Monom a;
var_monom xa = Abs_monom [(xa, one_nat)];

eval_terma ::
  forall a b c.
    (Eq b, Poly_carrier b, Eq c,
      Linorder c) => ((a, Nat) -> [(Monom Nat, b)]) ->
                       Term a c -> [(Monom c, b)];
eval_terma uu (Var x) = [(var_monom x, onea)];
eval_terma i (Fun f ts) =
  let {
    ps = map (eval_terma i) ts;
    n = size_list ts;
  } in poly_subst (\ ia -> (if less_nat ia n then nth ps ia else zero_poly))
         (i (f, n));

check_s ::
  forall a b c.
    (Eq a, Poly_carrier a, Showl a, Showl b, Eq c, Linorder c,
      Showl c) => (a -> a -> Bool) ->
                    ((b, Nat) -> [(Monom Nat, a)]) ->
                      (Term b c, Term b c) -> Sum (String -> String) ();
check_s gt i =
  (\ (s, t) ->
    let {
      p = eval_terma i s;
      q = eval_terma i t;
    } in check (check_poly_gt gt p q)
           (((((((showsl_literal "could not ensure " . showsl_terma s) .
                  showsl_literal " > ") .
                 showsl_terma t) .
                showsl_literal " since we\ncould not ensure ") .
               showsl_poly p) .
              showsl_literal " > ") .
             showsl_poly q));

content :: forall a. (Semiring_gcd a) => Poly a -> a;
content p = fold_coeffs gcda p zerob;

curry :: forall a b c. ((a, b) -> c) -> a -> b -> c;
curry f a b = f (a, b);

rep_renaming2 :: forall a. (Infinite a) => Renaming2 a -> (a -> a, a -> a);
rep_renaming2 (Abs_renaming2 x) = x;

rename_1 :: forall a. (Infinite a) => Renaming2 a -> a -> a;
rename_1 xa = fst (rep_renaming2 xa);

rename_2 :: forall a. (Infinite a) => Renaming2 a -> a -> a;
rename_2 xa = snd (rep_renaming2 xa);

scnp_af_to_af ::
  forall a.
    ((a, Nat) -> [(Nat, Nat)]) -> ((a, Nat) -> Set Nat) -> (a, Nat) -> Set Nat;
scnp_af_to_af pia pi =
  (\ (f, n) ->
    let {
      is = map fst (pia (f, n));
    } in (if any (less_eq_nat n) is then sup_set (pi (f, n)) (set is)
           else set is));

semilattice_set_apply :: forall a. Semilattice_set a -> a -> a -> a;
semilattice_set_apply (Abs_semilattice_set x) = x;

set_fold1 ::
  forall a. (Ceq a, Ccompare a, Lattice a) => Semilattice_set a -> Set a -> a;
set_fold1 f (RBT_set rbt) =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "set_fold1 RBT_set: ccompare = None" (\ _ -> set_fold1 f (RBT_set rbt));
    Just _ ->
      (if is_emptya rbt
        then (error :: forall a. String -> (() -> a) -> a)
               "set_fold1 RBT_set: empty set" (\ _ -> set_fold1 f (RBT_set rbt))
        else fold1 (semilattice_set_apply f) rbt);
  });
set_fold1 f (DList_set dxs) =
  (case (ceq :: Maybe (a -> a -> Bool)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "set_fold1 DList_set: ceq = None" (\ _ -> set_fold1 f (DList_set dxs));
    Just _ ->
      (if nulla dxs
        then (error :: forall a. String -> (() -> a) -> a)
               "set_fold1 DList_set: empty set"
               (\ _ -> set_fold1 f (DList_set dxs))
        else foldc (semilattice_set_apply f) (tl dxs) (hd dxs));
  });
set_fold1 f (Set_Monad (x : xs)) = fold (semilattice_set_apply f) xs x;
set_fold1 f (Collect_set p) =
  (error :: forall a. String -> (() -> a) -> a) "set_fold1: Collect_set"
    (\ _ -> set_fold1 f (Collect_set p));
set_fold1 f (Complement a) =
  (error :: forall a. String -> (() -> a) -> a) "set_fold1: Complement"
    (\ _ -> set_fold1 f (Complement a));

projr :: forall a b. Sum a b -> b;
projr (Inr x2) = x2;

rec_term ::
  forall a b c. (a -> b) -> (c -> [(Term c a, b)] -> b) -> Term c a -> b;
rec_term f1 f2 (Var x1) = f1 x1;
rec_term f1 f2 (Fun x21 x22) =
  f2 x21 (map (\ term -> (term, rec_term f1 f2 term)) x22);

mk_subst ::
  forall a b c. (Eq a) => (a -> Term b c) -> [(a, Term b c)] -> a -> Term b c;
mk_subst d xts = (\ x -> (case map_of xts x of {
                           Nothing -> d x;
                           Just t -> t;
                         }));

mk_subst_domain ::
  forall a b. (Eq a, Eq b) => [(a, Term b a)] -> [(a, Term b a)];
mk_subst_domain sigma =
  let {
    tau = mk_subst Var sigma;
  } in filter (\ (x, t) -> not (equal_term (Var x) t))
         (map (\ x -> (x, tau x)) (remdups (map fst sigma)));

subst_eq ::
  forall a b.
    (Cenum a, Ceq a, Ccompare a, Compare a, Eq a, Set_impl a, Compare b,
      Eq b) => [(a, Term b a)] -> [(a, Term b a)] -> Bool;
subst_eq sigma tau = let {
                       sigmaa = mk_subst_domain sigma;
                       taua = mk_subst_domain tau;
                     } in set_eq (set sigmaa) (set taua);

hole_pos :: forall a b. Actxt a b -> [Nat];
hole_pos Hole = [];
hole_pos (More f ss d ts) = size_list ss : hole_pos d;

atLeastLessThan ::
  forall a.
    (Ceq a, Ccompare a, Eq a, Interval a, Set_impl a) => a -> a -> Set a;
atLeastLessThan a b = let {
                        d = minusa b onea;
                      } in (if less d b then set (interval a d) else bot_set);

var_poss :: forall a b. Term a b -> Set [Nat];
var_poss (Var x) = inserta [] (set_empty (of_phantom set_impl_list));
var_poss (Fun f ts) =
  sup_seta
    (image (\ i -> image (\ a -> i : a) (var_poss (nth ts i)))
      (atLeastLessThan zero_nat (size_list ts)));

full_af :: forall a. (a, Nat) -> Set Nat;
full_af fn = atLeastLessThan zero_nat (snd fn);

add_funas_term :: forall a b. Term a b -> [(a, Nat)] -> [(a, Nat)];
add_funas_term (Var uu) fs = fs;
add_funas_term (Fun f ts) fs = (f, size_list ts) : foldr add_funas_term ts fs;

add_funas_rule :: forall a b. (Term a b, Term a b) -> [(a, Nat)] -> [(a, Nat)];
add_funas_rule r fs = add_funas_term (fst r) (add_funas_term (snd r) fs);

funas_trs_list :: forall a b. [(Term a b, Term a b)] -> [(a, Nat)];
funas_trs_list trs = foldr add_funas_rule trs [];

funs_rule_list :: forall a b. (Term a b, Term a b) -> [a];
funs_rule_list r = add_funs_rule r [];

vars_rule_list :: forall a b. (Term a b, Term a b) -> [b];
vars_rule_list r = add_vars_rule r [];

supteq_list :: forall a b. Term a b -> [Term a b];
supteq_list (Var x) = [Var x];
supteq_list (Fun f ts) = Fun f ts : concatMap supteq_list ts;

is_NF_main ::
  forall a b.
    (Compare_order a, Eq a, Ccompare b, Eq b,
      Mapping_impl b) => Bool ->
                           Bool -> ((a, Nat) -> [Term a b]) -> Term a b -> Bool;
is_NF_main var_cond r_empty m =
  (if var_cond then (\ _ -> False)
    else (if r_empty then (\ _ -> True)
           else (\ t ->
                  all (\ u ->
                        (if not (is_Var u)
                          then all (\ l -> not (matches u l)) (m (the (root u)))
                          else True))
                    (supteq_list t))));

is_NF_trs ::
  forall a b c.
    (Compare_order a, Eq a, Ccompare b, Eq b,
      Mapping_impl b) => [(Term a b, c)] -> Term a b -> Bool;
is_NF_trs r =
  is_NF_main (any (\ ra -> is_Var (fst ra)) r) (null r) (term_map (map fst r));

apply_args :: forall a b. a -> Term a b -> [Term a b] -> Term a b;
apply_args a t [] = t;
apply_args a t (s : ss) = apply_args a (Fun a [t, s]) ss;

get_symbol :: forall a. (a -> Nat -> [a]) -> a -> Nat -> Nat -> a;
get_symbol sm f n i = nth (sm f n) i;

mgu_var_disjoint_generic ::
  forall a b c d.
    (Eq b,
      Eq d) => (a -> b) ->
                 (c -> b) ->
                   Term d a -> Term d c -> Maybe (a -> Term d b, c -> Term d b);
mgu_var_disjoint_generic vu wu s t =
  (case mgu (map_term (\ x -> x) vu s) (map_term (\ x -> x) wu t) of {
    Nothing -> Nothing;
    Just gamma -> Just (gamma . vu, gamma . wu);
  });

mgu_vd ::
  forall a b.
    (Infinite a, Eq a,
      Eq b) => Renaming2 a ->
                 Term b a -> Term b a -> Maybe (a -> Term b a, a -> Term b a);
mgu_vd r = mgu_var_disjoint_generic (rename_1 r) (rename_2 r);

prec_exta :: forall a b. (a -> Maybe (Nat, b)) -> a -> a -> Bool;
prec_exta prwm =
  (\ f g -> (case prwm f of {
              Nothing -> False;
              Just pf -> (case prwm g of {
                           Nothing -> True;
                           Just pg -> less_nat (fst pg) (fst pf);
                         });
            }));

rep_afs :: forall a. Afs a -> ((a, Nat) -> Af_entry, Set (a, Nat));
rep_afs (Abs_afs x) = x;

afs :: forall a. Afs a -> (a, Nat) -> Af_entry;
afs xa = fst (rep_afs xa);

char_poly_matrix ::
  forall a.
    (Eq a, Comm_ring_1 a, Semiring_no_zero_divisors a) => Mat a -> Mat (Poly a);
char_poly_matrix a =
  plus_mat
    (smult_mat (pCons zerob (pCons onea zero_polya)) (one_mat (dim_row a)))
    (map_mat (\ aa -> pCons (uminus aa) zero_polya) a);

char_poly :: forall a. (Eq a, Idom_divide a) => Mat a -> Poly a;
char_poly a = det (char_poly_matrix a);

existsM :: forall a b. (a -> Sum b ()) -> [a] -> Sum [b] ();
existsM f [] = Inl [];
existsM f (x : xs) =
  catch_errora (f x)
    (\ e -> catch_errora (existsM f xs) (\ xa -> Inl (e : xa)));

gen_isEmpty :: forall a b c. (a -> (b -> Bool) -> c) -> a -> c;
gen_isEmpty ball m = ball m (\ _ -> False);

gen_isEmptya :: forall a b. (a -> (b -> Bool) -> Bool) -> a -> Bool;
gen_isEmptya ball s = ball s (\ _ -> False);

nonreach ::
  forall a b c.
    (Eq a) => (Term a b -> Term a c -> Bool) -> Term a b -> Term a c -> Bool;
nonreach gt s t =
  (case (s, t) of {
    (Var _, _) -> False;
    (Fun _ _, Var _) -> False;
    (Fun f ss, Fun g ts) ->
      not ((f, size_list ss) == (g, size_list ts)) && not (gt s t);
  });

weight ::
  forall a b.
    ((a, Nat) -> Nat) -> Nat -> ((a, Nat) -> Nat -> Nat) -> Term a b -> Nat;
weight w w0 scf (Var x) = w0;
weight w w0 scf (Fun f ts) =
  let {
    n = size_list ts;
    scff = scf (f, n);
  } in plus_nat (w (f, n))
         (sum_list
           (map (\ (ti, i) -> times_nat (weight w w0 scf ti) (scff i))
             (zip ts (upt zero_nat n))));

kbo_impl ::
  forall a b.
    (Eq b) => ((a, Nat) -> Nat) ->
                Nat ->
                  ((a, Nat) -> (a, Nat) -> (Bool, Bool)) ->
                    (a -> Bool) ->
                      ((a, Nat) -> Nat -> Nat) ->
                        Term a b -> Term a b -> (Bool, Bool);
kbo_impl w w0 prc least scf s t =
  let {
    wt = weight w w0 scf t;
    ws = weight w w0 scf s;
  } in (if subseteq_mset (vars_term_ms (scf_term scf t))
             (vars_term_ms (scf_term scf s)) &&
             less_eq_nat wt ws
         then (if less_nat wt ws then (True, True)
                else (case s of {
                       Var _ -> (False, (case t of {
  Var _ -> True;
  Fun g ts -> null ts && least g;
}));
                       Fun f ss ->
                         (case t of {
                           Var _ -> (True, True);
                           Fun g ts ->
                             let {
                               p = prc (f, size_list ss) (g, size_list ts);
                             } in (if fst p then (True, True)
                                    else (if snd p
   then lex_ext_unbounded (kbo_impl w w0 prc least scf) ss ts
   else (False, False)));
                         });
                     }))
         else (False, False));

kbo_strict ::
  forall a b.
    (Showl a, Eq b,
      Showl b) => ((a, Nat) -> (a, Nat) -> (Bool, Bool)) ->
                    ((a, Nat) -> Nat) ->
                      Nat ->
                        (a -> Bool) ->
                          ((a, Nat) -> Nat -> Nat) ->
                            (Term a b, Term a b) -> Sum (String -> String) ();
kbo_strict pr w w0 least scf =
  (\ (s, t) ->
    check (fst (kbo_impl w w0 pr least scf s t))
      ((((showsl_literal "could not orient " . showsl_terma s) .
          showsl_literal " >KBO ") .
         showsl_terma t) .
        showsl_literal "\n"));

trans_id ::
  forall a.
    (String ->
      (Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
        Sum_bot (Xml_error String) a) ->
      (Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
        Sum_bot (Xml_error String) a;
trans_id trans_id_parser = trans_id_parser "transitionId";

inter_list_set :: forall a. (Eq a) => [a] -> [a] -> [a];
inter_list_set xs ys = filter (membera ys) xs;

list_all2 :: forall a b. (a -> b -> Bool) -> [a] -> [b] -> Bool;
list_all2 p [] ys = null ys;
list_all2 p xs [] = null xs;
list_all2 p (x : xs) (y : ys) = p x y && list_all2 p xs ys;

elements_mat :: forall a. (Ceq a, Ccompare a, Set_impl a) => Mat a -> Set a;
elements_mat a =
  set (concatMap
        (\ i -> map (\ j -> index_mat a (i, j)) (upt zero_nat (dim_col a)))
        (upt zero_nat (dim_row a)));

default_mat_inter :: forall a. (Ring_1 a) => Nat -> Nat -> ([Mat a], Mat a);
default_mat_inter n n1 = (replicate n1 (one_mat n), one_mat n);

pI :: forall a b.
        (Eq a,
          Ring_1 b) => Nat ->
                         [((a, Nat), ([Mat b], Mat b))] ->
                           (a, Nat) -> ([Mat b], Mat b);
pI n fc = (\ (f, n1) -> (case map_of fc (f, n1) of {
                          Nothing -> default_mat_inter n n1;
                          Just val -> val;
                        }));

single_alist_entry :: forall a b. a -> b -> Alist a b;
single_alist_entry xb xc = Alist [(xb, xc)];

image_mset :: forall a b. (Eq b) => (a -> b) -> Multiset a -> Multiset b;
image_mset f (Bag ms) =
  foldd (\ a n -> plus_multiset (Bag (single_alist_entry (f a) n)))
    zero_multiset ms;

subtract_entries_raw ::
  forall a b. (Eq a, Minus b) => [(a, b)] -> [(a, b)] -> [(a, b)];
subtract_entries_raw xs ys =
  foldr (\ (k, v) -> map_entry k (\ va -> minusa va v)) ys xs;

subtract_entries ::
  forall a b. (Eq a, Minus b) => Alist a b -> Alist a b -> Alist a b;
subtract_entries xb xc =
  Alist (subtract_entries_raw (impl_ofa xb) (impl_ofa xc));

minus_multiset :: forall a. (Eq a) => Multiset a -> Multiset a -> Multiset a;
minus_multiset (Bag xs) (Bag ys) = Bag (subtract_entries xs ys);

inter_mset :: forall a. (Eq a) => Multiset a -> Multiset a -> Multiset a;
inter_mset a b = minus_multiset a (minus_multiset a b);

monom_vars_list :: forall a. (Linorder a) => Monom a -> [a];
monom_vars_list xa = map fst (rep_monom xa);

poly_vars_list :: forall a b. (Eq a, Linorder a) => [(Monom a, b)] -> [a];
poly_vars_list p = remdups (concatMap (monom_vars_list . fst) p);

concat_lists :: forall a. [[a]] -> [[a]];
concat_lists [] = [[]];
concat_lists (asa : xs) =
  concatMap (\ vec -> map (\ a -> a : vec) asa) (concat_lists xs);

poly_of ::
  forall a b.
    (Eq a, Linorder a, Eq b, Comm_semiring_1 b) => Tpoly a b -> [(Monom a, b)];
poly_of (PNum i) = (if i == zerob then [] else [(one_monom, i)]);
poly_of (PVar x) = [(var_monom x, onea)];
poly_of (PSum []) = zero_poly;
poly_of (PSum (p : ps)) = poly_add (poly_of p) (poly_of (PSum ps));
poly_of (PMult []) = one_poly;
poly_of (PMult (p : ps)) = poly_mult (poly_of p) (poly_of (PMult ps));

square_possibilities ::
  forall a b.
    (Eq a, Poly_carrier a, Eq b,
      Linorder b) => (a -> [a]) -> [(Monom b, a)] -> [[(Monom b, a)]];
square_possibilities sqrt p =
  let {
    roots =
      map (\ x ->
            map (\ a -> (x, a))
              (sqrt (fst (poly_split (times_monom (var_monom x) (var_monom x))
                           p))))
        (poly_vars_list p);
    choices = (if membera roots [] then [] else concat_lists roots);
    polys =
      map (\ xas ->
            poly_of (PSum (map (\ (x, a) -> PMult [PVar x, PNum a]) xas)))
        choices;
  } in polys;

check_poly_eq ::
  forall a b.
    (Eq a, Linorder a, Eq b,
      Semiring_0 b) => [(Monom a, b)] -> [(Monom a, b)] -> Bool;
check_poly_eq [] q = null q;
check_poly_eq ((m, c) : p) q =
  (case extract (\ nd -> fst nd == m) q of {
    Nothing -> False;
    Just (q1, ((_, d), q2)) -> c == d && check_poly_eq p (q1 ++ q2);
  });

monom_list_degree :: forall a. [(a, Nat)] -> Nat;
monom_list_degree xps = sum_list (map snd xps);

monom_degree :: forall a. (Linorder a) => Monom a -> Nat;
monom_degree xa = monom_list_degree (rep_monom xa);

poly_degree :: forall a b. (Linorder a) => [(Monom a, b)] -> Nat;
poly_degree p = max_list (map (\ (m, _) -> monom_degree m) p);

check_quadratic ::
  forall a.
    (Eq a,
      Poly_carrier a) => (a -> [a]) ->
                           [(Monom Nat, a)] -> Sum (String -> String) ();
check_quadratic sqrt p =
  bindb (check (equal_nat (poly_degree p) (nat_of_integer (2 :: Integer)))
          (showsl_literal "not quadratic"))
    (\ _ ->
      let {
        polys = square_possibilities sqrt p;
      } in check (any (\ q -> check_poly_eq (poly_mult q q) p) polys)
             (showsl_literal "could not find quadratic polynomial"));

check_quadratic_ge_const ::
  forall a b c.
    (Eq a, Poly_carrier a, Eq c,
      Linorder c) => (a -> [a]) ->
                       ((b, Nat) -> [(Monom Nat, a)]) ->
                         (Term b c, Term b c) -> Sum (String -> String) ();
check_quadratic_ge_const sq i st =
  (case st of {
    (s, t) ->
      bindb (check (not (is_Var s))
              (showsl_literal "require non-variables as arguments"))
        (\ _ ->
          let {
            pt = eval_terma i t;
          } in (case poly_split one_monom pt of {
                 (c, p0) ->
                   bindb (check (p0 == zero_poly)
                           (showsl_literal "rhs must evaluate to constant"))
                     (\ _ ->
                       let {
                         ps = i (the (root s));
                       } in (case poly_split one_monom ps of {
                              (d, psx) ->
                                bindb (check (less_eq c d)
(showsl_literal "problem in comparing constants"))
                                  (\ _ -> check_quadratic sq psx);
                            }));
               }));
  });

check_ns ::
  forall a b c.
    (Showl a, Eq b, Poly_carrier b, Showl b, Eq c, Linorder c,
      Showl c) => ((a, Nat) -> [(Monom Nat, b)]) ->
                    (Term a c, Term a c) -> Sum (String -> String) ();
check_ns i =
  (\ (s, t) ->
    let {
      p = eval_terma i s;
      q = eval_terma i t;
    } in check (check_poly_ge p q)
           (((((((showsl_literal "could not ensure " . showsl_terma s) .
                  showsl_literal " >= ") .
                 showsl_terma t) .
                showsl_literal " since we\ncould not ensure ") .
               showsl_poly p) .
              showsl_literal " >= ") .
             showsl_poly q));

check_cc ::
  forall a b c.
    (Eq a, Poly_carrier a, Showl a, Showl b, Eq c, Linorder c,
      Showl c) => (a -> [a]) ->
                    (a -> a -> Bool) ->
                      ((b, Nat) -> [(Monom Nat, a)]) ->
                        C_constraint b c -> Sum (String -> String) ();
check_cc sq gt i (Unconditional_C False st) =
  (if isOK (check_quadratic_ge_const sq i st) then Inr () else check_ns i st);
check_cc sq gt i (Unconditional_C True st) = check_s gt i st;
check_cc sq gt i (Conditional_C True (u, v) (s, t)) =
  let {
    ss = eval_terma i s;
    tt = eval_terma i t;
    uu = eval_terma i u;
    vv = eval_terma i v;
  } in (if check_poly_gt gt ss tt then Inr ()
         else check (check_poly_ge (poly_add ss vv) (poly_add tt uu))
                (((((((showsl_literal "could not ensure " . showsl_terma u) .
                       showsl_literal " > ") .
                      showsl_terma v) .
                     showsl_literal " ==> ") .
                    showsl_terma s) .
                   showsl_literal " > ") .
                  showsl_terma t));
check_cc sq gt i (Conditional_C False (u, v) (s, t)) =
  (if isOK (check_quadratic_ge_const sq i (s, t)) then Inr ()
    else let {
           ss = eval_terma i s;
           tt = eval_terma i t;
           uu = eval_terma i u;
           vv = eval_terma i v;
         } in (if check_poly_ge ss tt then Inr ()
                else check (check_poly_ge (poly_add ss vv) (poly_add tt uu))
                       (((((((showsl_literal "could not ensure " .
                               showsl_terma u) .
                              showsl_literal " >= ") .
                             showsl_terma v) .
                            showsl_literal " ==> ") .
                           showsl_terma s) .
                          showsl_literal " >= ") .
                         showsl_terma t)));

map_poly :: forall b a. (Zero b, Zero a, Eq a) => (b -> a) -> Poly b -> Poly a;
map_poly f p = Poly (strip_while (\ a -> zerob == a) (map f (coeffs p)));

is_left_of :: [Nat] -> [Nat] -> Bool;
is_left_of [] q = False;
is_left_of (i : p) q =
  (case q of {
    [] -> False;
    j : qa ->
      (if less_nat i j then True
        else (if less_nat j i then False else is_left_of p qa));
  });

showsl_pos :: [Nat] -> String -> String;
showsl_pos = showsl_list_gen (\ i -> showsl_nat (suc i)) "empty" "" "." "";

rules_with ::
  forall a b c.
    (Linorder b) => (a -> Bool) ->
                      Rbt (b, Nat) [(a, (Term b c, Term b c))] ->
                        [(Term b c, Term b c)];
rules_with p m =
  map_filter (\ x -> (if (p . fst) x then Just (snd x) else Nothing))
    (values m);

scnp_desc ::
  forall a.
    (Showl a) => [((a, Nat), [(Nat, Nat)])] ->
                   (String -> String) -> String -> String;
scnp_desc af mu =
  (((showsl_lit "SCNP-version with mu = " . mu) .
     showsl_lit " and the level mapping defined by\n") .
    showsl_sep
      (\ (a, b) ->
        (case a of {
          (f, n) ->
            (\ asa ->
              ((showsl_lit "pi(" . showsl f) . showsl_lit ") = ") .
                default_showsl_list
                  (\ (p, l) ->
                    (((showsl_lit "(" .
                        (if less_nat p n then showsl_nat (suc p)
                          else showsl_lit "epsilon")) .
                       showsl_lit ",") .
                      showsl_nat l) .
                      showsl_lit ")")
                  asa);
        })
          b)
      (showsl_literal "\n") af) .
    showsl_literal "\n";

split_rulesb ::
  forall a b c d.
    Tp_ops_ext a b c d ->
      a -> [(Term b c, Term b c)] ->
             ([(Term b c, Term b c)], [(Term b c, Term b c)]);
split_rulesb
  (Tp_ops_ext qreltrs q r rw rules q_empty is_QNF nFQ_subset_NF_rules rules_map
    delete_R_Rw split_rules mk nfs more)
  = split_rules;

delete_R_Rwb ::
  forall a b c d.
    Tp_ops_ext a b c d ->
      a -> [(Term b c, Term b c)] -> [(Term b c, Term b c)] -> a;
delete_R_Rwb
  (Tp_ops_ext qreltrs q r rw rules q_empty is_QNF nFQ_subset_NF_rules rules_map
    delete_R_Rw split_rules mk nfs more)
  = delete_R_Rw;

nfsb :: forall a b c d. Tp_ops_ext a b c d -> a -> Bool;
nfsb (Tp_ops_ext qreltrs q r rw rules q_empty is_QNF nFQ_subset_NF_rules
       rules_map delete_R_Rw split_rules mk nfs more)
  = nfs;

mkc ::
  forall a b c d.
    Tp_ops_ext a b c d ->
      Bool ->
        [Term b c] -> [(Term b c, Term b c)] -> [(Term b c, Term b c)] -> a;
mkc (Tp_ops_ext qreltrs q r rw rules q_empty is_QNF nFQ_subset_NF_rules
      rules_map delete_R_Rw split_rules mk nfs more)
  = mk;

qb :: forall a b c d. Tp_ops_ext a b c d -> a -> [Term b c];
qb (Tp_ops_ext qreltrs q r rw rules q_empty is_QNF nFQ_subset_NF_rules rules_map
     delete_R_Rw split_rules mk nfs more)
  = q;

split_tt ::
  forall a b c.
    (Showl b,
      Showl c) => Tp_ops_ext a b c () -> a -> [(Term b c, Term b c)] -> (a, a);
split_tt i tp r_remove =
  (case split_rulesb i tp r_remove of {
    (r, rw) -> let {
                 tp1 = mkc i (nfsb i tp) (qb i tp) r rw;
                 a = delete_R_Rwb i tp r_remove r_remove;
               } in (tp1, a);
  });

mod_poly_one_main_list ::
  forall a. (Eq a, Comm_ring_1 a) => [a] -> [a] -> Nat -> [a];
mod_poly_one_main_list r d n =
  (if equal_nat n zero_nat then r
    else let {
           a = hda r;
           rr = tla (if a == zerob then r
                      else minus_poly_rev_list r (map (times a) d));
         } in mod_poly_one_main_list rr d (minus_nat n one_nat));

modulo_poly :: forall a. (Field a, Eq a) => Poly a -> Poly a -> Poly a;
modulo_poly f g =
  let {
    cg = coeffs g;
  } in (if null cg then f
         else let {
                cf = coeffs f;
                ilc = inverse (last cg);
                ch = map (times ilc) cg;
                r = mod_poly_one_main_list (reverse cf) (reverse ch)
                      (minus_nat (plus_nat one_nat (size_list cf))
                        (size_list cg));
              } in poly_of_list (reverse r));

sturm_aux :: Poly Real -> Poly Real -> [Poly Real];
sturm_aux p q =
  (if equal_nat (degreea q) zero_nat then [p, q]
    else p : sturm_aux q (uminus_poly (modulo_poly p q)));

sturm :: Poly Real -> [Poly Real];
sturm p = sturm_aux p (pderiv p);

poss_list :: forall a b. Term a b -> [[Nat]];
poss_list (Var x) = [[]];
poss_list (Fun f ss) =
  [] : concatMap (\ (i, a) -> map (\ aa -> i : aa) a)
         (zip (upt zero_nat (size_list ss)) (map poss_list ss));

supt_impl :: forall a b. (Eq a, Eq b) => Term a b -> Term a b -> Bool;
supt_impl (Var x) t = False;
supt_impl (Fun f ss) t = membera ss t || any (\ s -> supt_impl s t) ss;

supt_list :: forall a b. Term a b -> [Term a b];
supt_list (Var x) = [];
supt_list (Fun f ts) = concatMap supteq_list ts;

af_inter ::
  forall a.
    ((a, Nat) -> Set Nat) -> ((a, Nat) -> Set Nat) -> (a, Nat) -> Set Nat;
af_inter pi mu f = inf_set (pi f) (mu f);

empty_af :: forall a. (a, Nat) -> Set Nat;
empty_af fn = set_empty (of_phantom set_impl_nat);

r_sym :: forall a b. Ta_rule a b -> (b, Nat);
r_sym (TA_rule f qs q) = (f, size_list qs);

funas_rule_list :: forall a b. (Term a b, Term a b) -> [(a, Nat)];
funas_rule_list r = add_funas_rule r [];

showsl_rulea ::
  forall a b.
    (a -> String -> String) ->
      (b -> String -> String) ->
        String -> (Term a b, Term a b) -> String -> String;
showsl_rulea fun var arr (l, r) =
  (showsl_term fun var l . showsl_literal arr) . showsl_term fun var r;

showsl_rulesa ::
  forall a b.
    (a -> String -> String) ->
      (b -> String -> String) ->
        String -> [(Term a b, Term a b)] -> String -> String;
showsl_rulesa fun var arr trs =
  showsl_list_gen (showsl_rulea fun var arr) "" "" "\n" "" trs .
    showsl_literal "\n";

showsl_trsa ::
  forall a b.
    (a -> String -> String) ->
      (b -> String -> String) ->
        String -> String -> [(Term a b, Term a b)] -> String -> String;
showsl_trsa fun var name arr r =
  (showsl_literal name . showsl_literal "\n\n") . showsl_rulesa fun var arr r;

showsl_trs ::
  forall a b. (Showl a, Showl b) => [(Term a b, Term a b)] -> String -> String;
showsl_trs = showsl_trsa showsl showsl "rewrite system:" " -> ";

aarity_term ::
  forall a b. (Eq a) => a -> (a -> Nat -> [a]) -> Term a b -> Maybe Nat;
aarity_term a sm t =
  (case unapp a t of {
    (Var _, _) -> Nothing;
    (Fun f ss, ts) ->
      Just (minus_nat (aarity sm f (size_list ss)) (size_list ts));
  });

map_funs_term_wa :: forall a b c. ((a, Nat) -> b) -> Term a c -> Term b c;
map_funs_term_wa fg (Var x) = Var x;
map_funs_term_wa fg (Fun f ts) =
  Fun (fg (f, size_list ts)) (map (map_funs_term_wa fg) ts);

uncurry_top ::
  forall a b. (Eq a) => a -> Nat -> (a -> Nat -> [a]) -> Term a b -> Term a b;
uncurry_top a n sm (Fun f ts) =
  let {
    mt = map (map_funs_term_wa (\ (fa, na) -> get_symbol sm fa na zero_nat));
    t = hda ts;
  } in (if f == a &&
             equal_nat (size_list ts) n &&
               not (is_Var t) &&
                 (case the (root t) of {
                   (h, m) -> not (equal_nat (aarity sm h m) zero_nat);
                 })
         then (case t of {
                Fun g ss ->
                  Fun (get_symbol sm g (size_list ss) one_nat)
                    (mt (ss ++ tla ts));
              })
         else Fun (case (f, size_list ts) of {
                    (fa, na) -> get_symbol sm fa na zero_nat;
                  })
                (mt ts));
uncurry_top a n sm (Var x) = Var x;

aABin :: forall a b. (Eq a) => a -> Acterm a b -> Acterm a b -> Acterm a b;
aABin f (AFun g [s, t]) u =
  (if f == g then AFun f [s, aABin f t u] else AFun f [AFun g [s, t], u]);
aABin f (AVar v) t = AFun f [AVar v, t];
aABin f (AFun v []) t = AFun f [AFun v [], t];
aABin f (AFun v [vb]) t = AFun f [AFun v [vb], t];
aABin f (AFun v (vb : vd : vf : vg)) t = AFun f [AFun v (vb : vd : vf : vg), t];
aABin f (AAC v va) t = AFun f [AAC v va, t];

actop :: forall a b. (Eq a, Eq b) => a -> Term a b -> Multiset (Term a b);
actop f (Fun g [s, t]) =
  (if f == g then plus_multiset (actop f s) (actop f t)
    else add_mset (Fun g [s, t]) zero_multiset);
actop f (Var v) = add_mset (Var v) zero_multiset;
actop f (Fun v []) = add_mset (Fun v []) zero_multiset;
actop f (Fun v [vb]) = add_mset (Fun v [vb]) zero_multiset;
actop f (Fun v (vb : vd : vf : vg)) =
  add_mset (Fun v (vb : vd : vf : vg)) zero_multiset;

aocnf ::
  forall a b.
    (Ceq a, Ccompare a, Eq a, Eq b) => Set a -> Set a -> Term a b -> Acterm a b;
aocnf f_A f_C (Var x) = AVar x;
aocnf f_A f_C (Fun f [s, t]) =
  let {
    a = member f f_A;
    c = member f f_C;
  } in (if a && c
         then AAC f (image_mset (aocnf f_A f_C) (actop f (Fun f [s, t])))
         else (if a then aABin f (aocnf f_A f_C s) (aocnf f_A f_C t)
                else (if c then AAC f (add_mset (aocnf f_A f_C s)
(add_mset (aocnf f_A f_C t) zero_multiset))
                       else AFun f [aocnf f_A f_C s, aocnf f_A f_C t])));
aocnf f_A f_C (Fun f []) = AFun f [];
aocnf f_A f_C (Fun f [t]) = AFun f [aocnf f_A f_C t];
aocnf f_A f_C (Fun f (s : t : u : us)) =
  AFun f
    (aocnf f_A f_C s :
      aocnf f_A f_C t : aocnf f_A f_C u : map (aocnf f_A f_C) us);

list2position :: [Nat] -> [Nat];
list2position [] = [];
list2position (n : ns) = n : list2position ns;

position ::
  (Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
    Sum_bot (Xml_error String) Nat;
position =
  xml_do "position" (xml_take_nat (\ n -> xml_return (minus_nat n one_nat)));

zero_enat :: Enat;
zero_enat = Enat zero_nat;

minus_enat :: Enat -> Enat -> Enat;
minus_enat (Enat a) (Enat b) = Enat (minus_nat a b);
minus_enat Infinity_enat n = Infinity_enat;
minus_enat (Enat a) Infinity_enat = zero_enat;

equal_enat :: Enat -> Enat -> Bool;
equal_enat (Enat nat) Infinity_enat = False;
equal_enat Infinity_enat (Enat nat) = False;
equal_enat (Enat nata) (Enat nat) = equal_nat nata nat;
equal_enat Infinity_enat Infinity_enat = True;

one_enat :: Enat;
one_enat = Enat one_nat;

xml_take_many_sub ::
  forall a b.
    [a] ->
      Nat ->
        Enat ->
          ((Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
            Sum_bot (Xml_error String) a) ->
            ([a] ->
              ([Xml], ([([Char], [Char])], (Bool, ([String], [String])))) ->
                Sum_bot (Xml_error String) b) ->
              ([Xml], ([([Char], [Char])], (Bool, ([String], [String])))) ->
                Sum_bot (Xml_error String) b;
xml_take_many_sub acc minOccurs maxOccurs p1 p2 ([], (atts, (allow, rest))) =
  (if equal_nat minOccurs zero_nat
    then p2 (reverse acc) ([], (atts, (allow, rest)))
    else bind2 (p1 (XML [] [] [], (atts, (False, rest)))) left
           (\ _ -> left (Fatal "unexpected")));
xml_take_many_sub acc minOccurs maxOccurs p1 p2
  (xml : xmls, (atts, (allow, (cands, rest)))) =
  (if equal_enat maxOccurs zero_enat
    then p2 (reverse acc) (xml : xmls, (atts, (allow, (cands, rest))))
    else bind2 (p1 (xml, (atts, (equal_nat minOccurs zero_nat, (cands, rest)))))
           (\ e ->
             (case e of {
               TagMismatch _ ->
                 p2 (reverse acc) (xml : xmls, (atts, (allow, (cands, rest))));
               Fatal _ -> left e;
             }))
           (\ a ->
             xml_take_many_sub (a : acc) (minus_nat minOccurs one_nat)
               (minus_enat maxOccurs one_enat) p1 p2
               (xmls, (atts, (False, ([], rest))))));

pos ::
  (Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
    Sum_bot (Xml_error String) [Nat];
pos = xml_do "positionInTerm"
        (xml_take_many_sub [] zero_nat Infinity_enat position
          (\ lst -> xml_return (list2position lst)));

plain_var ::
  (Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
    Sum_bot (Xml_error String) [Char];
plain_var = xml_text "var";

var ::
  forall a.
    (Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
      Sum_bot (Xml_error String) (Term a [Char]);
var = xml_change plain_var (xml_return . Var);

afsa ::
  forall a.
    (Showl a) => ((Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
                   Sum_bot (Xml_error String) a) ->
                   (Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
                     Sum_bot (Xml_error String) [((a, Nat), Af_entry)];
afsa xml2name =
  xml_do "argumentFilter"
    (xml_take_many_sub [] zero_nat Infinity_enat
      (xml_do "argumentFilterEntry"
        (xml_take xml2name
          (\ name ->
            xml_take (xml_nat "arity")
              (\ arity ->
                xml_take
                  (xml_or
                    (xml_change (xml_nat "collapsing")
                      (\ n -> xml_return (Collapse (minus_nat n one_nat))))
                    (xml_do "nonCollapsing"
                      (xml_take_many_sub [] zero_nat Infinity_enat position
                        (\ ls -> xml_return (AFList ls)))))
                  (\ main -> xml_return ((name, arity), main))))))
      xml_return);

scg_position ::
  (Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
    Sum_bot (Xml_error String) Nat;
scg_position = xml_nat "position";

term ::
  forall a.
    (Showl a) => ((Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
                   Sum_bot (Xml_error String) a) ->
                   Mapping [Char] (Term a [Char]) ->
                     (Xml, ([([Char], [Char])],
                             (Bool, ([String], [String])))) ->
                       Sum_bot (Xml_error String) (Term a [Char]);
term xml2name termMap x =
  xml_or
    (xml_do "funapp"
      (xml_take xml2name
        (\ name ->
          xml_take_many_sub [] zero_nat Infinity_enat (term xml2name termMap)
            (\ args -> xml_return (Fun name args)))))
    (xml_or var
      (xml_change (xml_text "termIndex")
        (\ idx ->
          (case lookupb termMap idx of {
            Nothing ->
              xml_error
                (("term index " ++ implode idx) ++
                  " is unknown in term-index map");
            Just a -> xml_return a;
          }))))
    x;

conditions ::
  forall a.
    (Showl a) => ((Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
                   Sum_bot (Xml_error String) a) ->
                   Mapping [Char] (Term a [Char]) ->
                     String ->
                       (Xml, ([([Char], [Char])],
                               (Bool, ([String], [String])))) ->
                         Sum_bot (Xml_error String)
                           [(Term a [Char], Term a [Char])];
conditions xml2name termMap tag =
  xml_do tag
    (xml_take_many_sub [] zero_nat Infinity_enat
      (xml_do "condition"
        (xml_take (term xml2name termMap)
          (\ l -> xml_take (term xml2name termMap) (\ r -> xml_return (l, r)))))
      xml_return);

xml_take_default ::
  forall a b.
    a -> ((Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
           Sum_bot (Xml_error String) a) ->
           (a -> ([Xml], ([([Char], [Char])], (Bool, ([String], [String])))) ->
                   Sum_bot (Xml_error String) b) ->
             ([Xml], ([([Char], [Char])], (Bool, ([String], [String])))) ->
               Sum_bot (Xml_error String) b;
xml_take_default a p1 p2 xs =
  (case xs of {
    ([], _) -> p2 a xs;
    (xml : xmls, (atts, (allow, (cands, rest)))) ->
      bind2 (p1 (xml, (atts, (True, (cands, rest)))))
        (\ e ->
          (case e of {
            TagMismatch cands1 ->
              p2 a (xml : xmls, (atts, (allow, (cands1, rest))));
            Fatal _ -> left e;
          }))
        (\ aa -> p2 aa (xmls, (atts, (False, ([], rest)))));
  });

crule ::
  forall a.
    (Showl a) => ((Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
                   Sum_bot (Xml_error String) a) ->
                   Mapping [Char] (Term a [Char]) ->
                     String ->
                       (Xml, ([([Char], [Char])],
                               (Bool, ([String], [String])))) ->
                         Sum_bot (Xml_error String)
                           ((Term a [Char], Term a [Char]),
                             [(Term a [Char], Term a [Char])]);
crule xml2name termMap tag =
  xml_do tag
    (xml_take (term xml2name termMap)
      (\ l ->
        xml_take (term xml2name termMap)
          (\ r ->
            xml_take_default [] (conditions xml2name termMap "conditions")
              (\ conds -> xml_return ((l, r), conds)))));

full_rule ::
  forall a.
    (Showl a) => ((Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
                   Sum_bot (Xml_error String) a) ->
                   Mapping [Char] (Term a [Char]) ->
                     (Xml, ([([Char], [Char])],
                             (Bool, ([String], [String])))) ->
                       Sum_bot (Xml_error String)
                         (Term a [Char], Term a [Char]);
full_rule xml2name termMap =
  xml_change (crule xml2name termMap "rule")
    (\ (lr, conds) ->
      (if null conds then xml_return lr
        else xml_error "conditional rule is not allowed here"));

rule ::
  forall a.
    (Showl a) => ((Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
                   Sum_bot (Xml_error String) a) ->
                   Mapping [Char] (Term a [Char]) ->
                     Mapping [Char] (Term a [Char], Term a [Char]) ->
                       (Xml, ([([Char], [Char])],
                               (Bool, ([String], [String])))) ->
                         Sum_bot (Xml_error String)
                           (Term a [Char], Term a [Char]);
rule xml2name termMap ruleMap =
  xml_or
    (xml_change (xml_text "ruleIndex")
      (\ idx ->
        (case lookupb ruleMap idx of {
          Nothing ->
            xml_error
              (("rule index " ++ implode idx) ++ " is unknown in rule map");
          Just a -> xml_return a;
        })))
    (full_rule xml2name termMap);

scg ::
  forall a.
    (Showl a) => ((Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
                   Sum_bot (Xml_error String) a) ->
                   Mapping [Char] (Term a [Char]) ->
                     Mapping [Char] (Term a [Char], Term a [Char]) ->
                       (Xml, ([([Char], [Char])],
                               (Bool, ([String], [String])))) ->
                         Sum_bot (Xml_error String)
                           ((Term a [Char], Term a [Char]),
                             ([(Nat, Nat)], [(Nat, Nat)]));
scg xml2name termIndexMap ruleMap =
  xml_do "sizeChangeGraph"
    (xml_take (rule xml2name termIndexMap ruleMap)
      (\ lr ->
        xml_take_many_sub [] zero_nat Infinity_enat
          (xml_do "edge"
            (xml_take scg_position
              (\ p ->
                xml_take (xml_bool "strict")
                  (\ s ->
                    xml_take scg_position (\ q -> xml_return (s, (p, q)))))))
          (\ edges ->
            xml_return
              (lr, (map_filter
                      (\ x -> (if fst x then Just (snd x) else Nothing)) edges,
                     map_filter
                       (\ x -> (if not (fst x) then Just (snd x) else Nothing))
                       edges)))));

bind2a ::
  forall a b.
    Sum_bot a b -> (a -> Cert_result) -> (b -> Cert_result) -> Cert_result;
bind2a (Sumbot a) f g = (case a of {
                          Inl aa -> f aa;
                          Inr aa -> g aa;
                        });

orig_term :: forall a b. (a -> Maybe b) -> Term a b -> Term a b;
orig_term m (Var x) = Var x;
orig_term m (Fun f []) = (case m f of {
                           Nothing -> Fun f [];
                           Just a -> Var a;
                         });
orig_term m (Fun f (v : va)) = Fun f (map (orig_term m) (v : va));

array_get :: forall a. Array.Array a -> Nat -> a;
array_get (Array.Array a) n = nth a n;

array_set :: forall a. Array.Array a -> Nat -> a -> Array.Array a;
array_set (Array.Array aa) n a = Array.Array (list_update aa n a);

as_length :: forall a. (Array.Array a, Nat) -> Nat;
as_length = snd;

array_shrink :: forall a. Array.Array a -> Nat -> Array.Array a;
array_shrink (Array.Array a) sz =
  (if less_nat (size_list a) sz then error "undefined"
    else Array.Array (take sz a));

array_length :: forall a. Array.Array a -> Nat;
array_length (Array.Array a) = size_list a;

as_shrink :: forall a. (Array.Array a, Nat) -> (Array.Array a, Nat);
as_shrink s =
  (case s of {
    (a, n) ->
      let {
        aa = (if less_eq_nat (times_nat (nat_of_integer (128 :: Integer)) n)
                   (array_length a) &&
                   less_nat (nat_of_integer (4 :: Integer)) n
               then array_shrink a n else a);
      } in (aa, n);
  });

as_take :: forall a. Nat -> (Array.Array a, Nat) -> (Array.Array a, Nat);
as_take m s = (case s of {
                (a, n) -> (if less_nat m n then as_shrink (a, m) else (a, n));
              });

as_top :: forall a. (Array.Array a, Nat) -> a;
as_top s = (case s of {
             (a, n) -> array_get a (minus_nat n one_nat);
           });

as_pop :: forall a. (Array.Array a, Nat) -> (Array.Array a, Nat);
as_pop s = (case s of {
             (a, n) -> as_shrink (a, minus_nat n one_nat);
           });

as_get :: forall a. (Array.Array a, Nat) -> Nat -> a;
as_get s i = (case s of {
               (a, _) -> array_get a i;
             });

while :: forall a. (a -> Bool) -> (a -> a) -> a -> a;
while b c s = (if b s then while b c (c s) else s);

pop_tr ::
  forall a.
    (Compare_order a) => ((Array.Array a, Nat),
                           ((Array.Array Nat, Nat),
                             (Rbta a Int, (Array.Array (Nat, [a]), Nat)))) ->
                           ((Array.Array a, Nat),
                             ((Array.Array Nat, Nat),
                               (Rbta a Int, (Array.Array (Nat, [a]), Nat))));
pop_tr s =
  (case s of {
    (a, (aa, (ab, bb))) ->
      let {
        x = minus_nat (as_length aa) one_nat;
        xa = (case while (\ (xe, _) ->
                           less_nat xe
                             (if equal_nat (plus_nat x one_nat) (as_length aa)
                               then as_length a
                               else as_get aa (plus_nat x one_nat)))
                     (\ (ac, bc) ->
                       (suc ac,
                         rbt_insert (as_get a ac) (uminus_int one_int) bc))
                     (as_get aa x, ab)
               of {
               (_, bc) -> bc;
             });
        xb = as_take (as_top aa) a;
        xc = as_pop aa;
      } in (xb, (xc, (xa, bb)));
  });

gen_disjoint ::
  forall a b c d e f.
    (a -> (b -> b) -> (c -> d -> Bool) -> Bool -> e) ->
      (c -> f -> Bool) -> a -> f -> e;
gen_disjoint it1 mem2 s1 s2 = it1 s1 (\ x -> x) (\ x _ -> not (mem2 x s2)) True;

group_key :: forall a b. (Eq b) => (a -> b) -> [a] -> [[a]];
group_key f [] = [];
group_key f (x : xs) =
  (x : takeWhile (\ y -> f x == f y) xs) :
    group_key f (dropWhile (\ y -> f x == f y) xs);

lec_poly :: forall a. Le_constraint a -> Linear_poly;
lec_poly (Le_Constraint x1 x2 x3) = x2;

constraint_to_le_constraint :: Constraint -> [Le_constraint Rat];
constraint_to_le_constraint (LEQ l x) = [Le_Constraint Leq_Rel l x];
constraint_to_le_constraint (GEQ l x) =
  [Le_Constraint Leq_Rel (uminus_linear_poly l) (uminus_rat x)];
constraint_to_le_constraint (LT l x) = [Le_Constraint Lt_Rel l x];
constraint_to_le_constraint (GT l x) =
  [Le_Constraint Lt_Rel (uminus_linear_poly l) (uminus_rat x)];
constraint_to_le_constraint (EQ l x) =
  [Le_Constraint Leq_Rel l x,
    Le_Constraint Leq_Rel (uminus_linear_poly l) (uminus_rat x)];

normalizea :: [Constraint] -> [Le_constraint Rat];
normalizea cs = concatMap constraint_to_le_constraint cs;

vars_of_constraints :: [Constraint] -> [Nat];
vars_of_constraints cs =
  remdups (concatMap (vars_list . lec_poly) (normalizea cs));

sqrt_int_floor :: Int -> Int;
sqrt_int_floor x =
  (if less_eq_int zero_int x then sqrt_int_floor_pos x
    else uminus_int (sqrt_int_ceiling_pos (uminus_int x)));

det_bound_hadamard :: Nat -> Int -> Int;
det_bound_hadamard n c =
  (if equal_nat n one_nat || dvd (nat_of_integer (2 :: Integer)) n
    then times_int
           (binary_power (int_of_nat n)
             (divide_nat n (nat_of_integer (2 :: Integer))))
           (binary_power (abs_int c) n)
    else sqrt_int_floor
           (binary_power
             (times_int (int_of_nat n)
               (binary_power c (nat_of_integer (2 :: Integer))))
             n));

maxa :: forall a. (Ceq a, Ccompare a, Lattice a, Linorder a) => Set a -> a;
maxa a = set_fold1 max_sls a;

vars :: Linear_poly -> Set Nat;
vars lp = fset (fmdom (linear_poly_map lp));

max_coeff :: Le_constraint Rat -> Rat;
max_coeff (Le_Constraint uu l c) =
  maxa (sup_set (inserta (abs_rat c) (set_empty (of_phantom set_impl_rat)))
         (image (\ x -> abs_rat (coeffa l x)) (vars l)));

max_coeff_constraints :: [Le_constraint Rat] -> Rat;
max_coeff_constraints cs = maxa (set (zero_rat : map max_coeff cs));

lcm_integer :: Integer -> Integer -> Integer;
lcm_integer a b =
  divide_integer (Prelude.abs a * Prelude.abs b) (Prelude.gcd a b);

lcm_int :: Int -> Int -> Int;
lcm_int (Int_of_integer x) (Int_of_integer y) =
  Int_of_integer (lcm_integer x y);

common_denominator :: Le_constraint Rat -> Int;
common_denominator (Le_Constraint uu l c) =
  let {
    coeffs_list = map (coeffa l) (vars_list l);
    denominators = map (snd . quotient_of) (c : coeffs_list);
  } in fold lcm_int denominators one_int;

mul_constraint :: Rat -> Le_constraint Rat -> Le_constraint Rat;
mul_constraint x (Le_Constraint r l c) =
  Le_Constraint r (scaleRat_linear_poly x l) (times_rat x c);

constraint_to_ints :: Le_constraint Rat -> Le_constraint Rat;
constraint_to_ints c = mul_constraint (of_int (common_denominator c)) c;

var_list :: [Constraint] -> [Nat];
var_list cs = let {
                lecs = concatMap constraint_to_le_constraint cs;
                polys = map lec_poly lecs;
              } in remdups (concatMap vars_list polys);

compute_bound_num_of_vars :: [Constraint] -> Int;
compute_bound_num_of_vars cs =
  let {
    le_cs = normalizea cs;
    le_csa = map constraint_to_ints le_cs;
    max_coeff = max_coeff_constraints le_csa;
    n = plus_nat one_nat (size_list (var_list cs));
  } in times_int (int_of_nat (plus_nat n one_nat))
         (det_bound_hadamard n (floor_rat max_coeff));

solution_simplex :: forall a. Simplex_state a -> Nat -> Rat;
solution_simplex (Simplex_State (cs, ((asi, (tv, ui)), s))) =
  map2fun (from_ns (tv (v s)) cs);

i_bounds_to_constraints ::
  forall a.
    [Nat] -> (Nat -> (a, Int)) -> (Nat -> (a, Int)) -> [(a, Constraint)];
i_bounds_to_constraints is lb ub =
  map (\ x -> (fst (lb x), GEQ (vara x) (of_int (snd (lb x))))) is ++
    map (\ x -> (fst (ub x), LEQ (vara x) (of_int (snd (ub x))))) is;

atom_to_qdnsconstr :: Atom Rat -> Ns_constraint QDelta;
atom_to_qdnsconstr atm =
  (case atm of {
    Leq x qdcnst -> LEQ_ns (vara x) (QDelta qdcnst zero_rat);
    Geq x qdcnst -> GEQ_ns (vara x) (QDelta qdcnst zero_rat);
  });

atom_to_qdatom :: Atom Rat -> Atom QDelta;
atom_to_qdatom atm = (case atm of {
                       Leq vr c -> Leq vr (QDelta c zero_rat);
                       Geq vr c -> Geq vr (QDelta c zero_rat);
                     });

update_iatom_in_state ::
  Simplex_state Nat -> (Nat, Atom Rat) -> Simplex_state Nat;
update_iatom_in_state s iatm =
  (case s of {
    Simplex_State (cs, ((asi, (tv, ui)), l3s)) ->
      let {
        csa = list_update cs (fst iatm) (atom_to_qdnsconstr (snd iatm));
        asia = updateb (fst iatm) [(fst iatm, atom_to_qdatom (snd iatm))] asi;
      } in Simplex_State (csa, ((asia, (tv, ui)), l3s));
  });

list_map_to_fun ::
  forall a b. (Ccompare a, Eq a) => Mapping a [(a, b)] -> a -> [(a, b)];
list_map_to_fun m i = (case lookupb m i of {
                        Nothing -> [];
                        Just ias -> ias;
                      });

assert_s ::
  forall a b.
    (Eq a, Eq b, Lrv b) => (a, Atom b) -> State a b -> Sum [a] (State a b);
assert_s a s = let {
                 sa = assert_bound_code a s;
               } in (if u sa then Inl (the (u_c sa)) else Inr sa);

assert_all_s ::
  forall a b.
    (Eq a, Eq b, Lrv b) => [(a, Atom b)] -> State a b -> Sum [a] (State a b);
assert_all_s [] s = Inr s;
assert_all_s (a : asa) s = (case assert_s a s of {
                             Inl aa -> Inl aa;
                             Inr aa -> assert_all_s asa aa;
                           });

assert_simplex ::
  forall a.
    (Ccompare a, Eq a) => a -> Simplex_state a -> Sum [a] (Simplex_state a);
assert_simplex i (Simplex_State (cs, ((asi, (tv, ui)), s))) =
  (if membera ui i then Inl [i]
    else (case assert_all_s (list_map_to_fun asi i) s of {
           Inl a -> Inl a;
           Inr sa -> Inr (Simplex_State (cs, ((asi, (tv, ui)), sa)));
         }));

assert_all_simplex ::
  forall a.
    (Ccompare a, Eq a) => [a] -> Simplex_state a -> Sum [a] (Simplex_state a);
assert_all_simplex [] s = Inr s;
assert_all_simplex (ja : j) s = (case assert_simplex ja s of {
                                  Inl a -> Inl a;
                                  Inr a -> assert_all_simplex j a;
                                });

del_atom_from_state ::
  Simplex_state Nat -> (Nat, Atom Rat) -> Simplex_state Nat;
del_atom_from_state s iatm =
  (case s of {
    Simplex_State (l1, (l2, State t bl bu v c uc)) ->
      let {
        bua = deletea (atom_var (snd iatm)) bu;
        bla = deletea (atom_var (snd iatm)) bl;
      } in Simplex_State (l1, (l2, State t bla bua v c uc));
  });

sum_to_option :: forall a b. Sum a b -> Maybe b;
sum_to_option (Inr x) = Just x;
sum_to_option (Inl uu) = Nothing;

bnb_update_state ::
  [(Nat, Constraint)] ->
    [Nat] ->
      (Nat -> (Nat, Int)) ->
        (Nat -> (Nat, Int)) ->
          Simplex_state Nat -> (Nat, Atom Rat) -> Maybe (Simplex_state Nat);
bnb_update_state cs is lb ub s iatm =
  let {
    idx_list = map fst (i_bounds_to_constraints is lb ub ++ cs);
  } in (case assert_all_simplex (remove1 (fst iatm) idx_list)
               (del_atom_from_state s iatm)
         of {
         Inl _ -> Nothing;
         Inr sa ->
           sum_to_option
             (assert_simplex (fst iatm) (update_iatom_in_state sa iatm));
       });

check_sa ::
  forall a b. (Eq a, Eq b, Lrv b) => State a b -> (State a b, Maybe [a]);
check_sa s = let {
               sa = check_code s;
             } in (if u sa then (sa, Just (the (u_c sa))) else (sa, Nothing));

check_simplex ::
  forall a. (Eq a) => Simplex_state a -> (Simplex_state a, Maybe [a]);
check_simplex (Simplex_State (cs, (asi_tv, s))) =
  (case check_sa s of {
    (sa, a) -> (Simplex_State (cs, (asi_tv, sa)), a);
  });

is_int_rat :: Rat -> Bool;
is_int_rat x = equal_int (snd (quotient_of x)) one_int;

bnb_state_core_p ::
  [(Nat, Constraint)] ->
    [Nat] ->
      Mapping Nat (Nat, Int) ->
        Mapping Nat (Nat, Int) ->
          Simplex_state Nat -> Maybe (Maybe (Nat -> Rat));
bnb_state_core_p cs is lb ub s =
  (case check_simplex s of {
    (x, Nothing) ->
      let {
        v = solution_simplex x;
      } in (case find (\ xa -> not (is_int_rat (v xa))) is of {
             Nothing -> Just (Just v);
             Just xa ->
               let {
                 new_leq =
                   (fst (the (lookupb ub xa)),
                     Leq xa (of_int (floor_rat (v xa))));
                 new_geq =
                   (fst (the (lookupb lb xa)),
                     Geq xa (of_int (ceiling (v xa))));
                 uba = updateb xa (fst (the (lookupb ub xa)), floor_rat (v xa))
                         ub;
                 lba = updateb xa (fst (the (lookupb lb xa)), ceiling (v xa))
                         lb;
               } in bind (case bnb_update_state cs is (the . lookupb lb)
                                 (the . lookupb uba) x new_leq
                           of {
                           Nothing -> Just Nothing;
                           Just a -> bnb_state_core_p cs is lb uba a;
                         })
                      (\ a ->
                        (case a of {
                          Nothing ->
                            (case bnb_update_state cs is (the . lookupb lba)
                                    (the . lookupb ub) x new_geq
                              of {
                              Nothing -> Just Nothing;
                              Just aa -> bnb_state_core_p cs is lba ub aa;
                            });
                          Just va -> Just (Just va);
                        }));
           });
    (_, Just _) -> Just Nothing;
  });

create_map ::
  forall a b.
    (Ccompare a, Eq a, Mapping_impl a) => [(a, b)] -> Mapping a [(a, b)];
create_map [] = emptyb;
create_map ((i, a) : xs) = let {
                             m = create_map xs;
                           } in (case lookupb m i of {
                                  Nothing -> updateb i [(i, a)] m;
                                  Just ias -> updateb i ((i, a) : ias) m;
                                });

init_simplex ::
  forall a.
    (Ceq a, Ccompare a, Eq a, Mapping_impl a,
      Set_impl a) => [(a, Constraint)] -> Simplex_state a;
init_simplex cs =
  let {
    tons_cs = to_ns cs;
  } in Simplex_State
         (map snd tons_cs,
           (case preprocess tons_cs of {
             (t, (asa, (trans_v, ui))) ->
               ((create_map asa, (trans_v, remdups ui)), init_state t);
           }));

bnb_state_init ::
  [Constraint] ->
    [Nat] ->
      (Nat -> Int) ->
        (Nat -> Int) ->
          ([(Nat, Constraint)],
            (Mapping Nat (Nat, Int),
              (Mapping Nat (Nat, Int), Sum [Nat] (Simplex_state Nat))));
bnb_state_init cs is lb ub =
  let {
    lba = zip is (upt zero_nat (size_list is));
    uba = zip is (upt (size_list is) (plus_nat (size_list is) (size_list is)));
    lbb = map (\ (x, y) -> (x, (y, lb x))) lba;
    ubb = map (\ (x, y) -> (x, (y, ub x))) uba;
    lb_m = of_alist lbb;
    ub_m = of_alist ubb;
    csa = zip (upt (plus_nat (size_list is) (size_list is))
                (plus_nat (plus_nat (size_list is) (size_list is))
                  (size_list cs)))
            cs;
    bs = i_bounds_to_constraints is (the . lookupb lb_m) (the . lookupb ub_m) ++
           csa;
    s = assert_all_simplex (map fst bs) (init_simplex bs);
  } in (csa, (lb_m, (ub_m, s)));

branch_and_bound :: [Constraint] -> [Nat] -> Maybe (Nat -> Rat);
branch_and_bound cs is =
  let {
    bnd = compute_bound_num_of_vars cs;
  } in (case bnb_state_init cs is (\ _ -> uminus_int bnd) (\ _ -> bnd) of {
         (_, (_, (_, Inl _))) -> Nothing;
         (csa, (lb_m, (ub_m, Inr s))) ->
           the (bnb_state_core_p csa is lb_m ub_m s);
       });

int_of_rat :: Rat -> Int;
int_of_rat x = fst (quotient_of x);

branch_and_bound_int :: [Constraint] -> Maybe (Nat -> Int);
branch_and_bound_int cs =
  let {
    vs = vars_of_constraints cs;
  } in (case branch_and_bound cs vs of {
         Nothing -> Nothing;
         Just v ->
           Just (\ x -> (if membera vs x then int_of_rat (v x) else zero_int));
       });

la_solver :: La_solver_type -> [Constraint] -> Maybe (Nat -> Int);
la_solver BB_Solver cs = branch_and_bound_int cs;
la_solver Simplex_Solver cs = (case simplex cs of {
                                Inl _ -> Nothing;
                                Inr v -> Just (\ x -> floor_rat (map2fun v x));
                              });

is_NF_subset :: forall a b. (Term a b -> Bool) -> [Term a b] -> Bool;
is_NF_subset is_Q_nf q = all (\ qa -> not (is_Q_nf qa)) q;

icap_impl_gen ::
  forall a.
    (Eq a) => Bool ->
                (Term a [Char] -> Bool) ->
                  [Term a [Char]] ->
                    [Term a [Char]] ->
                      ([Char] -> Bool) ->
                        Term a [Char] -> Term a (Sum () [Char]);
icap_impl_gen nf isQnf ls s sx (Var x) =
  (if nf && sx x then Var (Inr x) else Var (Inl ()));
icap_impl_gen nf isQnf ls s sx (Fun f ts) =
  let {
    t = Fun f (map (icap_impl_gen nf isQnf ls s sx) ts);
  } in (if any (\ l ->
                 (case mgu_class t l of {
                   Nothing -> False;
                   Just mu ->
                     all (\ u ->
                           isQnf (eval_term Fun
                                   (map_term (\ x -> x) (\ a -> char_0x79 : a)
                                     u)
                                   mu))
                       (args l) &&
                       all (\ u -> isQnf (eval_term Fun u mu)) s;
                 }))
             ls
         then Var (Inl ()) else t);

ins_rm_basic_ops :: forall a. (Compare_order a) => a -> Rbt a () -> Rbt a ();
ins_rm_basic_ops x s = insert x () s;

g_from_list_aux_dflt_basic_oops_rm_basic_ops ::
  forall a. (Compare_order a) => Rbt a () -> [a] -> Rbt a ();
g_from_list_aux_dflt_basic_oops_rm_basic_ops accs (x : l) =
  g_from_list_aux_dflt_basic_oops_rm_basic_ops (ins_rm_basic_ops x accs) l;
g_from_list_aux_dflt_basic_oops_rm_basic_ops y [] = y;

empty_rm_basic_ops :: forall a. (Linorder a) => () -> Rbt a ();
empty_rm_basic_ops = (\ _ -> empty);

g_from_list_dflt_basic_oops_rm_basic_ops ::
  forall a. (Compare_order a) => [a] -> Rbt a ();
g_from_list_dflt_basic_oops_rm_basic_ops l =
  g_from_list_aux_dflt_basic_oops_rm_basic_ops (empty_rm_basic_ops ()) l;

memb_rm_basic_ops :: forall a. (Compare_order a) => a -> Rbt a () -> Bool;
memb_rm_basic_ops x s = not (is_none (lookup s x));

ceta_set_of :: forall a. (Compare_order a) => [a] -> a -> Bool;
ceta_set_of ps = let {
                   tree = g_from_list_dflt_basic_oops_rm_basic_ops ps;
                 } in (\ a -> memb_rm_basic_ops a tree);

icap_impl ::
  forall a.
    (Eq a) => (Term a [Char] -> Bool) ->
                [(Term a [Char], Term a [Char])] ->
                  [Term a [Char]] -> Term a [Char] -> Term a (Sum () [Char]);
icap_impl isnf r =
  let {
    ls = map fst r;
    nf = is_NF_subset isnf ls;
    ic = icap_impl_gen nf isnf ls;
  } in (\ s ->
         let {
           sa = map (map_term (\ x -> x) (\ a -> char_0x78 : a)) s;
           sx = ceta_set_of (concatMap vars_term_list sa);
         } in (\ t -> ic sa sx (map_term (\ x -> x) (\ a -> char_0x78 : a) t)));

p_gt_impl ::
  forall a b c.
    (Eq a, Eq b) => [((Term a b, Term a b), c)] -> Term a b -> Term a b -> Bool;
p_gt_impl sa s t =
  (case (s, t) of {
    (Var _, _) -> True;
    (Fun _ _, Var _) -> True;
    (Fun f ss, Fun g ts) ->
      let {
        r = map fst sa;
      } in matchb (tcapI r s) t &&
             ((f, size_list ss) == (g, size_list ts) ||
               gT_impl r s t && any (\ (l, _) -> matchb (tcapI r s) l) r);
  });

rep_subst_incr ::
  forall a b. Subst_incr a b -> (b -> Term a b, (Set b, Term a b -> [b]));
rep_subst_incr (Abs_subst_incr x) = x;

si_W :: forall a b. Subst_incr a b -> Term a b -> [b];
si_W xa = snd (snd (rep_subst_incr xa));

kbo_nstrict ::
  forall a b.
    (Showl a, Eq b,
      Showl b) => ((a, Nat) -> (a, Nat) -> (Bool, Bool)) ->
                    ((a, Nat) -> Nat) ->
                      Nat ->
                        (a -> Bool) ->
                          ((a, Nat) -> Nat -> Nat) ->
                            (Term a b, Term a b) -> Sum (String -> String) ();
kbo_nstrict pr w w0 least scf =
  (\ (s, t) ->
    check (snd (kbo_impl w w0 pr least scf s t))
      ((((showsl_literal "could not orient " . showsl_terma s) .
          showsl_literal " >=KBO ") .
         showsl_terma t) .
        showsl_literal "\n"));

succ_transitions ::
  forall a b c d e.
    (Eq d) => Lts_impl a b c d e -> d -> [Transition_rule a b c d];
succ_transitions (Lts_Impl i ts lc) l =
  concatMap (\ (_, tau) -> (if source tau == l then [tau] else [])) ts;

default_I :: forall a. (Poly_carrier a) => a -> Nat -> [(Monom Nat, a)];
default_I def n =
  (one_monom, def) : map (\ i -> (var_monom i, onea)) (upt zero_nat n);

proper_prefix_list :: [Nat] -> [[Nat]];
proper_prefix_list [] = [];
proper_prefix_list (i : p) = [] : map (\ a -> i : a) (proper_prefix_list p);

prefix_list :: [Nat] -> [[Nat]];
prefix_list p = p : proper_prefix_list p;

rm_iterateoi ::
  forall a b c. Rbta a b -> (c -> Bool) -> ((a, b) -> c -> c) -> c -> c;
rm_iterateoi Empty c f sigma = sigma;
rm_iterateoi (Branch col l k v r) c f sigma =
  (if c sigma
    then let {
           sigmaa = rm_iterateoi l c f sigma;
         } in (if c sigmaa then rm_iterateoi r c f (f (k, v) sigmaa)
                else sigmaa)
    else sigma);

rpo_mem ::
  forall a b.
    (Eq b) => ((a, Nat) -> (a, Nat) -> (Bool, Bool), (a, Nat) -> Bool) ->
                ((a, Nat) -> Order_tag) ->
                  Mapping (Int, Int) (Bool, Bool) ->
                    (Term (a, (Term a b, Int)) (b, (Term a b, Int)),
                      Term (a, (Term a b, Int)) (b, (Term a b, Int))) ->
                      ((Bool, Bool), Mapping (Int, Int) (Bool, Bool));
rpo_mem pr c mem (s, t) =
  let {
    i = index s;
    j = index t;
  } in (case lookupb mem (i, j) of {
         Nothing -> (case rpo_main pr c mem (s, t) of {
                      (res, mem_new) -> (res, updateb (i, j) res mem_new);
                    });
         Just res -> (res, mem);
       });

rpo_main ::
  forall a b.
    (Eq b) => ((a, Nat) -> (a, Nat) -> (Bool, Bool), (a, Nat) -> Bool) ->
                ((a, Nat) -> Order_tag) ->
                  Mapping (Int, Int) (Bool, Bool) ->
                    (Term (a, (Term a b, Int)) (b, (Term a b, Int)),
                      Term (a, (Term a b, Int)) (b, (Term a b, Int))) ->
                      ((Bool, Bool), Mapping (Int, Int) (Bool, Bool));
rpo_main pr c mem (s, t) =
  (case s of {
    Var x ->
      ((False, (case t of {
                 Var y -> name_of x == name_of y;
                 Fun g ts -> null ts && snd pr (name_of g, zero_nat);
               })),
        mem);
    Fun f ss ->
      let {
        ff = (name_of f, size_list ss);
      } in (case exists_mem (\ sa -> (sa, t)) (rpo_mem pr c) snd mem ss of {
             (True, mem_out_1) -> ((True, True), mem_out_1);
             (False, mem_out_1) ->
               (case t of {
                 Var _ -> ((False, False), mem_out_1);
                 Fun g ts ->
                   let {
                     gg = (name_of g, size_list ts);
                   } in (case fst pr ff gg of {
                          (prs, True) ->
                            (case forall_mem (\ a -> (s, a)) (rpo_mem pr c) fst
                                    mem_out_1 ts
                              of {
                              (True, mem_out_2) ->
                                (if prs then ((True, True), mem_out_2)
                                  else let {
 cf = c ff;
 cg = c gg;
                                       } in
 (if equal_order_tag cf Lex && equal_order_tag cg Lex
   then lex_ext_unbounded_mem (rpo_mem pr c) mem_out_2 ss ts
   else (if equal_order_tag cf Mul && equal_order_tag cg Mul
          then mul_ext_mem (rpo_mem pr c) mem_out_2 ss ts
          else (if null ts then ((not (null ss), True), mem_out_2)
                 else ((False, False), mem_out_2)))));
                              (False, mem_out_2) -> ((False, False), mem_out_2);
                            });
                          (_, False) -> ((False, False), mem_out_1);
                        });
               });
           });
  });

scnp_arity :: forall a. [((a, Nat), [(Nat, Nat)])] -> Nat;
scnp_arity af = max_list (map (\ (_, a) -> size_list a) af);

check_supt ::
  forall a b.
    (Eq a, Showl a, Eq b,
      Showl b) => Term a b -> Term a b -> Sum (String -> String) ();
check_supt s t =
  check (supt_impl s t)
    ((showsl_terma t . showsl_literal " is not a proper subterm of ") .
      showsl_terma s);

compute_trancl ::
  forall a.
    (Cenum a, Ceq a, Ccompare a, Set_impl a) => Set a -> Set (a, a) -> Set a;
compute_trancl a r =
  let {
    b = imagea r a;
  } in (if less_eq_set b bot_set then bot_set
         else sup_set b
                (compute_trancl b
                  (filtera
                    (\ ab -> not (member (fst ab) a) && not (member (snd ab) b))
                    r)));

r_lhs_states :: forall a b. Ta_rule a b -> [a];
r_lhs_states (TA_rule x1 x2 x3) = x2;

r_rhs :: forall a b. Ta_rule a b -> a;
r_rhs (TA_rule x1 x2 x3) = x3;

ta_rules :: forall a b c. Ta_ext a b c -> Set (Ta_rule a b);
ta_rules (Ta_ext ta_final ta_rules ta_eps more) = ta_rules;

ta_eps :: forall a b c. Ta_ext a b c -> Set (a, a);
ta_eps (Ta_ext ta_final ta_rules ta_eps more) = ta_eps;

ta_res ::
  forall a b.
    (Cenum a, Ceq a, Ccompare a, Eq a, Set_impl a, Ccompare b,
      Eq b) => Ta_ext a b () -> Term b a -> Set a;
ta_res ta (Var q) = let {
                      a = inserta q bot_set;
                    } in sup_set a (compute_trancl a (ta_eps ta));
ta_res ta (Fun f ts) =
  let {
    qs = map (ta_res ta) ts;
    g = (f, size_list ts);
    a = image r_rhs
          (filtera
            (\ r ->
              r_sym r == g &&
                all (\ qq -> member (snd qq) (fst qq))
                  (zip qs (r_lhs_states r)))
            (ta_rules ta));
  } in sup_set a (compute_trancl a (ta_eps ta));

eq_rule_mod_vars ::
  forall a b.
    (Eq a, Ccompare b, Eq b,
      Mapping_impl b) => (Term a b, Term a b) -> (Term a b, Term a b) -> Bool;
eq_rule_mod_vars lr st = instance_rule lr st && instance_rule st lr;

is_NF_terms ::
  forall a b.
    (Compare_order a, Eq a, Ccompare b, Eq b,
      Mapping_impl b) => [Term a b] -> Term a b -> Bool;
is_NF_terms q = is_NF_main (any is_Var q) (null q) (term_map q);

showsl_rule ::
  forall a b. (Showl a, Showl b) => (Term a b, Term a b) -> String -> String;
showsl_rule = showsl_rulea showsl showsl " -> ";

generate_var :: Nat -> [Char];
generate_var i = char_0x78 : shows_prec_nat zero_nat i [];

uncurry_term ::
  forall a b. (Eq a) => a -> (a -> Nat -> [a]) -> Term a b -> Term a b;
uncurry_term a sm t =
  (case unapp a t of {
    (Var x, ts) -> apply_args a (Var x) (map (uncurry_term a sm) ts);
    (Fun f ss, ts) ->
      let {
        n = size_list ss;
        uss = map (uncurry_term a sm) ss;
        uts = map (uncurry_term a sm) ts;
        aa = aarity sm f n;
        m = min (size_list ts) aa;
        fm = get_symbol sm f n m;
      } in apply_args a (Fun fm (uss ++ take m uts)) (drop m uts);
  });

extract_special :: [Char] -> [Char] -> Maybe ([Char], [Char]);
extract_special acc [] = Nothing;
extract_special acc (x : xs) =
  (if equal_char x char_0x3B
    then map_option (\ s -> (s, xs)) (special_map (reverse acc))
    else extract_special (x : acc) xs);

ctrs ::
  forall a.
    (Showl a) => ((Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
                   Sum_bot (Xml_error String) a) ->
                   Mapping [Char] (Term a [Char]) ->
                     (Xml, ([([Char], [Char])],
                             (Bool, ([String], [String])))) ->
                       Sum_bot (Xml_error String)
                         [((Term a [Char], Term a [Char]),
                            [(Term a [Char], Term a [Char])])];
ctrs xml2name termMap =
  xml_do "ctrs"
    (xml_take
      (xml_do "conditionType"
        (xml_take (xml_do "oriented" (xml_return ())) (\ _ -> xml_return ())))
      (\ _ ->
        xml_take
          (xml_do "rules"
            (xml_take_many_sub [] zero_nat Infinity_enat
              (crule xml2name termMap "rule") xml_return))
          xml_return));

ctxt ::
  forall a.
    (Showl a) => ((Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
                   Sum_bot (Xml_error String) a) ->
                   Mapping [Char] (Term a [Char]) ->
                     (Xml, ([([Char], [Char])],
                             (Bool, ([String], [String])))) ->
                       Sum_bot (Xml_error String) (Actxt a (Term a [Char]));
ctxt xml2name termIndexMap x =
  xml_or (xml_do "box" (xml_return Hole))
    (xml_do "funContext"
      (xml_take xml2name
        (\ name ->
          xml_take
            (xml_do "before"
              (xml_take_many_sub [] zero_nat Infinity_enat
                (term xml2name termIndexMap) xml_return))
            (\ left ->
              xml_take (ctxt xml2name termIndexMap)
                (\ mid ->
                  xml_take
                    (xml_do "after"
                      (xml_take_many_sub [] zero_nat Infinity_enat
                        (term xml2name termIndexMap) xml_return))
                    (\ right -> xml_return (More name left mid right)))))))
    x;

xml_take_optional ::
  forall a b.
    ((Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
      Sum_bot (Xml_error String) a) ->
      (Maybe a ->
        ([Xml], ([([Char], [Char])], (Bool, ([String], [String])))) ->
          Sum_bot (Xml_error String) b) ->
        ([Xml], ([([Char], [Char])], (Bool, ([String], [String])))) ->
          Sum_bot (Xml_error String) b;
xml_take_optional p1 p2 xs =
  (case xs of {
    ([], _) -> p2 Nothing xs;
    (xml : xmls, (atts, (allow, (cands, rest)))) ->
      bind2 (p1 (xml, (atts, (True, (cands, rest)))))
        (\ e ->
          (case e of {
            TagMismatch cands1 ->
              p2 Nothing (xml : xmls, (atts, (allow, (cands1, rest))));
            Fatal _ -> left e;
          }))
        (\ a -> p2 (Just a) (xmls, (atts, (False, ([], rest)))));
  });

relstep ::
  forall a.
    (Showl a) => ((Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
                   Sum_bot (Xml_error String) a) ->
                   Mapping [Char] (Term a [Char]) ->
                     Mapping [Char] (Term a [Char], Term a [Char]) ->
                       (Xml, ([([Char], [Char])],
                               (Bool, ([String], [String])))) ->
                         Sum_bot (Xml_error String)
                           ([Nat],
                             ((Term a [Char], Term a [Char]),
                               (Bool, Term a [Char])));
relstep xml2name termIndexMap ruleMap =
  xml_do "rewriteStep"
    (xml_take pos
      (\ p ->
        xml_take (rule xml2name termIndexMap ruleMap)
          (\ r ->
            xml_take_optional (xml_leaf "relative" ())
              (\ rel ->
                xml_take (term xml2name termIndexMap)
                  (\ t -> xml_return (p, (r, (is_none rel, t))))))));

relsteps ::
  forall a.
    (Showl a) => ((Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
                   Sum_bot (Xml_error String) a) ->
                   Mapping [Char] (Term a [Char]) ->
                     Mapping [Char] (Term a [Char], Term a [Char]) ->
                       (Xml, ([([Char], [Char])],
                               (Bool, ([String], [String])))) ->
                         Sum_bot (Xml_error String)
                           (Term a [Char],
                             [([Nat],
                                ((Term a [Char], Term a [Char]),
                                  (Bool, Term a [Char])))]);
relsteps xml2name termIndexMap ruleMap =
  xml_do "rewriteSequence"
    (xml_take
      (xml_do "startTerm"
        (xml_take (term xml2name termIndexMap) (\ x -> xml_return (id x))))
      (\ start ->
        xml_take_many_sub [] zero_nat Infinity_enat
          (relstep xml2name termIndexMap ruleMap)
          (\ steps -> xml_return (start, steps))));

substa ::
  forall a.
    (Showl a) => ((Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
                   Sum_bot (Xml_error String) a) ->
                   Mapping [Char] (Term a [Char]) ->
                     (Xml, ([([Char], [Char])],
                             (Bool, ([String], [String])))) ->
                       Sum_bot (Xml_error String) [([Char], Term a [Char])];
substa xml2name termIndexMap =
  xml_do "substitution"
    (xml_take_many_sub [] zero_nat Infinity_enat
      (xml_do "substEntry"
        (xml_take (xml_do "var" (xml_take_text xml_return))
          (\ var ->
            xml_take (term xml2name termIndexMap)
              (\ trm -> xml_return (var, trm)))))
      xml_return);

loop ::
  forall a.
    (Showl a) => ((Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
                   Sum_bot (Xml_error String) a) ->
                   Mapping [Char] (Term a [Char]) ->
                     Mapping [Char] (Term a [Char], Term a [Char]) ->
                       (Xml, ([([Char], [Char])],
                               (Bool, ([String], [String])))) ->
                         Sum_bot (Xml_error String)
                           (Term a [Char],
                             ([([Nat],
                                 ((Term a [Char], Term a [Char]),
                                   (Bool, Term a [Char])))],
                               ([([Char], Term a [Char])],
                                 Actxt a (Term a [Char]))));
loop xml2name termIndexMap ruleMap =
  xml_do "loop"
    (xml_take (relsteps xml2name termIndexMap ruleMap)
      (\ (s, rseq) ->
        xml_take (substa xml2name termIndexMap)
          (\ sigma ->
            xml_take (ctxt xml2name termIndexMap)
              (\ c -> xml_return (s, (rseq, (sigma, c)))))));

proj ::
  forall a.
    (Showl a) => ((Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
                   Sum_bot (Xml_error String) a) ->
                   (Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
                     Sum_bot (Xml_error String) (ProjL a);
proj xml2name =
  xml_change (afsa xml2name)
    (\ afl ->
      xml_return
        (Projection (map (\ a -> (case a of {
                                   (fa, Collapse aa) -> (fa, aa);
                                   (fa, AFList _) -> (fa, snd fa);
                                 }))
                      afl)));

proj_term :: forall a b. ((a, Nat) -> Nat) -> Term a b -> Term a b;
proj_term p (Var x) = Var x;
proj_term p (Fun f ts) = let {
                           n = size_list ts;
                           i = p (f, n);
                         } in (if less_nat i n then nth ts i else Fun f ts);

start_term ::
  forall a.
    (Eq a,
      Showl a) => ((Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
                    Sum_bot (Xml_error String) a) ->
                    Mapping [Char] (Term a [Char]) ->
                      Term a [Char] ->
                        (Xml, ([([Char], [Char])],
                                (Bool, ([String], [String])))) ->
                          Sum_bot (Xml_error String) (Term a [Char]);
start_term xml2name termIndexMap t =
  xml_do "startTerm"
    (xml_take (term xml2name termIndexMap)
      (\ s ->
        (if equal_term s t then xml_return t
          else xml_error "<startTerm> does not match lhs")));

rstep ::
  forall a.
    (Showl a) => ((Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
                   Sum_bot (Xml_error String) a) ->
                   Mapping [Char] (Term a [Char]) ->
                     Mapping [Char] (Term a [Char], Term a [Char]) ->
                       (Xml, ([([Char], [Char])],
                               (Bool, ([String], [String])))) ->
                         Sum_bot (Xml_error String)
                           ([Nat],
                             ((Term a [Char], Term a [Char]), Term a [Char]));
rstep xml2name termIndexMap ruleMap =
  xml_do "rewriteStep"
    (xml_take pos
      (\ p ->
        xml_take (rule xml2name termIndexMap ruleMap)
          (\ r ->
            xml_take (term xml2name termIndexMap)
              (\ t -> xml_return (p, (r, t))))));

rseq ::
  forall a.
    (Eq a,
      Showl a) => ((Xml, ([([Char], [Char])], (Bool, ([String], [String])))) ->
                    Sum_bot (Xml_error String) a) ->
                    Mapping [Char] (Term a [Char]) ->
                      Mapping [Char] (Term a [Char], Term a [Char]) ->
                        ((a, Nat) -> Nat) ->
                          (Term a [Char], Term a [Char]) ->
                            (Xml, ([([Char], [Char])],
                                    (Bool, ([String], [String])))) ->
                              Sum_bot (Xml_error String)
                                ((Term a [Char], Term a [Char]),
                                  [([Nat],
                                     ((Term a [Char], Term a [Char]),
                                       Term a [Char]))]);
rseq xml2name termIndexMap ruleMap pi r =
  xml_do "rewriteSequence"
    (xml_take (start_term xml2name termIndexMap (proj_term pi (fst r)))
      (\ _ ->
        xml_take_many_sub [] zero_nat Infinity_enat
          (rstep xml2name termIndexMap ruleMap)
          (\ rseq -> xml_return (r, rseq))));

showsl_eqa ::
  forall a b. (Showl a, Showl b) => (Term a b, Term a b) -> String -> String;
showsl_eqa = showsl_rulea showsl showsl " ->* ";

showsl_conditions ::
  forall a b. (Showl a, Showl b) => [(Term a b, Term a b)] -> String -> String;
showsl_conditions = showsl_sep showsl_eqa (showsl_lit ", ");

showsl_crule ::
  forall a b c d.
    (Showl a, Showl b, Showl c,
      Showl d) => ((Term a b, Term a b), [(Term c d, Term c d)]) ->
                    String -> String;
showsl_crule cr =
  showsl_rule (fst cr) .
    (if null (snd cr) then id
      else showsl_lit " | " . showsl_conditions (snd cr));

mgu_vd_string ::
  forall a.
    (Eq a) => Term a [Char] ->
                Term a [Char] ->
                  Maybe ([Char] -> Term a [Char], [Char] -> Term a [Char]);
mgu_vd_string =
  mgu_var_disjoint_generic (\ a -> char_0x78 : a) (\ a -> char_0x79 : a);

fun_poss_list :: forall a b. Term a b -> [[Nat]];
fun_poss_list (Var x) = [];
fun_poss_list (Fun f ss) =
  [] : concatMap (\ (i, a) -> map (\ aa -> i : aa) a)
         (zip (upt zero_nat (size_list ss)) (map fun_poss_list ss));

check_airr ::
  forall a.
    (Eq a,
      Showl a) => [((Term a [Char], Term a [Char]),
                     [(Term a [Char], Term a [Char])])] ->
                    Term a [Char] -> Sum (String -> String) ();
check_airr r t =
  catch_errora
    (catch_errora
      (forallM
        (\ cr ->
          catch_errora
            (forallM
              (\ p ->
                check (is_none (mgu_vd_string (subt_at t p) (fst (fst cr))))
                  (((((showsl_lit "the term " . showsl_terma t) .
                       showsl_lit
                         " is unifiable with the left-hand side of rule ") .
                      showsl_crule cr) .
                     showsl_lit " at position ") .
                    showsl_pos p))
              (fun_poss_list t))
            (\ x -> Inl (snd x)))
        r)
      (\ x -> Inl (snd x)))
    (\ x ->
      Inl (((showsl_lit "the term " . showsl_terma t) .
             showsl_lit " is not absolutely irreducible") .
            x));

check_subseteq :: forall a. (Eq a) => [a] -> [a] -> Sum a ();
check_subseteq xs ys =
  catch_errora (forallM (\ x -> (if membera ys x then Inr () else Inl x)) xs)
    (\ x -> Inl (snd x));

check_type3 ::
  forall a b.
    (Showl a, Eq b,
      Showl b) => [((Term a b, Term a b), [(Term a b, Term a b)])] ->
                    Sum (String -> String) ();
check_type3 r =
  catch_errora
    (catch_errora
      (forallM
        (\ cr ->
          catch_errora
            (check_subseteq (vars_term_list (snd (fst cr)))
              (vars_term_list (fst (fst cr)) ++ vars_trs_list (snd cr)))
            (\ x ->
              Inl ((((showsl_lit "variable " . showsl x) .
                      showsl_lit " occurs only in right-hand side of rule ") .
                     showsl_crule cr) .
                    showsl_literal "\n")))
        r)
      (\ x -> Inl (snd x)))
    (\ x -> Inl (showsl_lit "the CTRS is not of type 3\n" . x));

x_impl ::
  forall a b. ((Term a b, Term a b), [(Term a b, Term a b)]) -> Nat -> [b];
x_impl cr i =
  concat
    (vars_term_list (fst (fst cr)) :
      map (vars_term_list . snd) (take i (snd cr)));

check_dctrs ::
  forall a b.
    (Showl a, Eq b,
      Showl b) => [((Term a b, Term a b), [(Term a b, Term a b)])] ->
                    Sum (String -> String) ();
check_dctrs r =
  catch_errora
    (catch_errora
      (forallM
        (\ cr ->
          catch_errora
            (forallM
              (\ i ->
                catch_errora
                  (check_subseteq (vars_term_list (fst (nth (snd cr) i)))
                    (x_impl cr i))
                  (\ x ->
                    Inl ((((((showsl_lit "variable " . showsl x) .
                              showsl_lit " in condition ") .
                             showsl_rule (nth (snd cr) i)) .
                            showsl_lit " of rule ") .
                           showsl_crule cr) .
                          showsl_lit "violates DCTRS condition\n")))
              (upt zero_nat (size_list (snd cr))))
            (\ x -> Inl (snd x)))
        r)
      (\ x -> Inl (snd x)))
    (\ x -> Inl (showsl_lit "the CTRS is not deterministic\n" . x));

check_varcond_no_Var_lhs ::
  forall a b.
    (Showl a, Showl b) => [(Term a b, Term a b)] -> Sum (String -> String) ();
check_varcond_no_Var_lhs =
  (\ xs ->
    catch_errora
      (forallM
        (\ rule ->
          check (not (is_Var (fst rule)))
            ((showsl_literal "variable left-hand side in rule " .
               showsl_rule rule) .
              showsl_literal "\n"))
        xs)
      (\ x -> Inl (snd x)));

check_wf_ctrs ::
  forall a b.
    (Showl a, Eq b,
      Showl b) => [((Term a b, Term a b), [(Term a b, Term a b)])] ->
                    Sum (String -> String) ();
check_wf_ctrs r =
  catch_errora
    (bindb (check_varcond_no_Var_lhs (map fst r))
      (\ _ -> bindb (check_dctrs r) (\ _ -> check_type3 r)))
    (\ x -> Inl (showsl_lit "the CTRS is not well-formed\n" . x));

cstep_trg :: forall a b. Cstep_proof a b -> Term a b;
cstep_trg (Cstep_step x1 x2 x3 x4 x5 x6) = x5;

cstep_src :: forall a b. Cstep_proof a b -> Term a b;
cstep_src (Cstep_step x1 x2 x3 x4 x5 x6) = x4;

match_rules ::
  forall a b.
    (Eq a, Ccompare b, Eq b,
      Mapping_impl b) => [(Term a b, Term a b)] ->
                           [(Term a b, Term a b)] -> Maybe (b -> Term a b);
match_rules rs_1 rs_2 =
  bind (zip_option (map fst rs_2 ++ map snd rs_2)
         (map fst rs_1 ++ map snd rs_1))
    (match_list Var);

check_crule_variants ::
  forall a b.
    (Eq a, Showl a, Ccompare b, Eq b, Mapping_impl b,
      Showl b) => ((Term a b, Term a b), [(Term a b, Term a b)]) ->
                    ((Term a b, Term a b), [(Term a b, Term a b)]) ->
                      Sum (String -> String) ();
check_crule_variants ra r =
  let {
    rs = fst ra : snd ra;
    rsa = fst r : snd r;
  } in check (not (is_none (match_rules rs rsa)) &&
               not (is_none (match_rules rsa rs)))
         (((showsl_crule ra . showsl_lit " and ") . showsl_crule r) .
           showsl_lit " are not variants of each other\n");

showsl_crules ::
  forall a b c d.
    (Showl a, Showl b, Showl c,
      Showl d) => [((Term a b, Term a b), [(Term c d, Term c d)])] ->
                    String -> String;
showsl_crules ctrs =
  showsl_list_gen showsl_crule "" "" "\n" "" ctrs . showsl_literal "\n";

showsl_ctrs ::
  forall a b c d.
    (Showl a, Showl b, Showl c,
      Showl d) => [((Term a b, Term a b), [(Term c d, Term c d)])] ->
                    String -> String;
showsl_ctrs r = showsl_lit "CTRS:\n\n" . showsl_crules r;

check_variant_in_ctrs ::
  forall a b.
    (Eq a, Showl a, Ccompare b, Eq b, Mapping_impl b,
      Showl b) => [((Term a b, Term a b), [(Term a b, Term a b)])] ->
                    ((Term a b, Term a b), [(Term a b, Term a b)]) ->
                      Sum (String -> String) ();
check_variant_in_ctrs ra r =
  catch_errora
    (catch_errora (existsM (check_crule_variants r) ra)
      (\ x -> Inl (showsl_sep id id x)))
    (\ _ ->
      Inl (((showsl_lit "rule " . showsl_crule r) .
             showsl_lit " is not a variant of any rule in:\n") .
            showsl_ctrs ra));

intp_actxt :: forall a b. (a -> [b] -> b) -> Actxt a b -> b -> b;
intp_actxt i Hole a = a;
intp_actxt i (More f ls c rs) a = i f (ls ++ intp_actxt i c a : rs);

ctxt_of_pos_term :: forall a b. [Nat] -> Term a b -> Actxt a (Term a b);
ctxt_of_pos_term [] t = Hole;
ctxt_of_pos_term (i : ps) (Fun f ts) =
  More f (take i ts) (ctxt_of_pos_term ps (nth ts i)) (drop (suc i) ts);

check_csteps ::
  forall a b.
    (Eq a, Showl a, Ccompare b, Eq b, Mapping_impl b,
      Showl b) => [((Term a b, Term a b), [(Term a b, Term a b)])] ->
                    Term a b ->
                      Term a b ->
                        [Cstep_proof a b] -> Sum (String -> String) ();
check_csteps r s t [] =
  check (equal_term s t)
    ((((showsl_lit "empty rewrite sequence but source " . showsl_terma s) .
        showsl_lit " and target ") .
       showsl_terma t) .
      showsl_lit " differ");
check_csteps r s t [p] =
  bindb (check (equal_term (cstep_src p) s)
          ((showsl_terma (cstep_src p) .
             showsl_lit " does not match the source ") .
            showsl_terma s))
    (\ _ ->
      bindb (check (equal_term (cstep_trg p) t)
              ((showsl_terma (cstep_trg p) .
                 showsl_lit " does not match the target ") .
                showsl_terma t))
        (\ _ -> check_cstep r p));
check_csteps r s t (p : v : va) =
  bindb (check (equal_term (cstep_src p) s)
          ((showsl_terma (cstep_src p) .
             showsl_lit " does not match the source ") .
            showsl_terma s))
    (\ _ ->
      bindb (check_cstep r p) (\ _ -> check_csteps r (cstep_trg p) t (v : va)));

check_cstep ::
  forall a b.
    (Eq a, Showl a, Ccompare b, Eq b, Mapping_impl b,
      Showl b) => [((Term a b, Term a b), [(Term a b, Term a b)])] ->
                    Cstep_proof a b -> Sum (String -> String) ();
check_cstep ra (Cstep_step ((l, r), cs) p sigma s t pss) =
  bindb (check_variant_in_ctrs ra ((l, r), cs))
    (\ _ ->
      bindb (check (equal_nat (size_list pss) (size_list cs))
              (showsl_lit
                "mismatch between number of conditions and number of rewrite sequences"))
        (\ _ ->
          bindb (check
                  (equal_term s
                    (intp_actxt Fun (ctxt_of_pos_term p s)
                      (eval_term Fun l sigma)))
                  ((showsl_terma s .
                     showsl_lit " does not contain an instance of ") .
                    showsl_terma l))
            (\ _ ->
              bindb (check
                      (equal_term t
                        (intp_actxt Fun (ctxt_of_pos_term p s)
                          (eval_term Fun r sigma)))
                      ((showsl_terma t .
                         showsl_lit " does not contain an instance of ") .
                        showsl_terma r))
                (\ _ ->
                  catch_errora
                    (forallM
                      (\ i ->
                        check_csteps ra (eval_term Fun (fst (nth cs i)) sigma)
                          (eval_term Fun (snd (nth cs i)) sigma) (nth pss i))
                      (upt zero_nat (size_list cs)))
                    (\ x -> Inl (snd x))))));

map_funs_crule ::
  forall a b c.
    (a -> b) ->
      ((Term a c, Term a c), [(Term a c, Term a c)]) ->
        ((Term b c, Term b c), [(Term b c, Term b c)]);
map_funs_crule f r =
  ((map_term f (\ x -> x) (fst (fst r)), map_term f (\ x -> x) (snd (fst r))),
    map (map_funs_rule f) (snd r));

skol_crule ::
  forall a b.
    (Compare a, Eq a, Ceq b, Ccompare b, Compare b,
      Eq b) => Set ((Term a b, Term a b), [(Term a b, Term a b)]) ->
                 Set b ->
                   ((Term a b, Term a b), [(Term a b, Term a b)]) ->
                     ((Term (Sum a b) b, Term (Sum a b) b),
                       [(Term (Sum a b) b, Term (Sum a b) b)]);
skol_crule ra v r =
  (if member r ra then map_funs_crule Inl r
    else ((skol v (fst (fst r)), skol v (snd (fst r))),
           map (\ (s, t) -> (skol v s, skol v t)) (snd r)));

skol_cstep_proof ::
  forall a b.
    (Compare a, Eq a, Ceq b, Ccompare b, Compare b,
      Eq b) => Set ((Term a b, Term a b), [(Term a b, Term a b)]) ->
                 Set b -> Cstep_proof a b -> Cstep_proof (Sum a b) b;
skol_cstep_proof r v (Cstep_step rho p sigma s t pss) =
  Cstep_step (skol_crule r v rho) p (skol v . sigma) (skol v s) (skol v t)
    (map (map (skol_cstep_proof r v)) pss);

map_funs_crules ::
  forall a b c.
    (a -> b) ->
      [((Term a c, Term a c), [(Term a c, Term a c)])] ->
        [((Term b c, Term b c), [(Term b c, Term b c)])];
map_funs_crules f r = map (map_funs_crule f) r;

rules2crules ::
  forall a b.
    [(Term a b, Term a b)] -> [((Term a b, Term a b), [(Term a b, Term a b)])];
rules2crules rs = map (\ r -> (r, [])) rs;

skol_rules ::
  forall a b.
    (Compare a, Eq a, Finite_UNIV b, Cenum b, Ceq b, Cproper_interval b,
      Compare b, Eq b,
      Set_impl b) => [(Term a b, Term a b)] ->
                       [(Term (Sum a b) b, Term (Sum a b) b)];
skol_rules cs = let {
                  v = vars_trs (set cs);
                } in map (\ (l, r) -> (skol v l, skol v r)) cs;

check_context_joinablea ::
  forall a b.
    (Compare a, Eq a, Showl a, Finite_UNIV b, Cenum b, Ceq b,
      Cproper_interval b, Compare b, Eq b, Mapping_impl b, Set_impl b,
      Showl b) => Context_joinable_proof a b ->
                    [((Term a b, Term a b), [(Term a b, Term a b)])] ->
                      Term a b ->
                        Term a b ->
                          [(Term a b, Term a b)] -> Sum (String -> String) ();
check_context_joinablea (Contextual_Join u ps qs) r s t cs =
  catch_errora
    (let {
       c = skol_rules cs;
       v = vars_trs (set cs);
       sa = skol v s;
       ta = skol v t;
       ua = skol v u;
       psa = map (skol_cstep_proof (set r) v) ps;
       qsa = map (skol_cstep_proof (set r) v) qs;
       ra = map_funs_crules Inl r ++ rules2crules c;
     } in bindb (check_csteps ra sa ua psa) (\ _ -> check_csteps ra ta ua qsa))
    (\ x ->
      Inl ((((showsl_terma s . showsl_lit " and ") . showsl_terma t) .
             showsl_lit " are not context-joinable\n") .
            x));

check_context_joinable ::
  forall a b.
    (Compare_order a, Eq a, Showl a, Finite_UNIV b, Cenum b, Ceq b,
      Cproper_interval b, Compare b, Infinite b, Eq b, Mapping_impl b,
      Set_impl b,
      Showl b) => [(Term a b,
                     (Term a b,
                       ([(Term a b, Term a b)],
                         Context_joinable_proof a b)))] ->
                    [((Term a b, Term a b), [(Term a b, Term a b)])] ->
                      Term a b ->
                        Term a b ->
                          [(Term a b, Term a b)] -> Sum (String -> String) ();
check_context_joinable cj r s t cs =
  catch_errora
    (existsM
      (\ (sa, (ta, (csa, p))) ->
        bindb (check
                (not (is_none (match_rules ((s, t) : cs) ((sa, ta) : csa)))) id)
          (\ _ ->
            bindb (check
                    (not (is_none (match_rules ((sa, ta) : csa) ((s, t) : cs))))
                    id)
              (\ _ -> check_context_joinablea p r sa ta csa)))
      cj)
    (\ x -> Inl (showsl_sep id (showsl_literal "\n") x));

showsl_coverlap ::
  forall a b c d e f g h.
    (Showl a, Showl b, Showl c, Showl d, Showl e, Showl f, Showl g,
      Showl h) => ((Term a b, Term a b), [(Term c d, Term c d)]) ->
                    ((Term e f, Term e f), [(Term g h, Term g h)]) ->
                      [Nat] -> String -> String;
showsl_coverlap rho_1 rho_2 p =
  ((((showsl_lit "overlap of conditional rules " . showsl_crule rho_1) .
      showsl_lit " and ") .
     showsl_crule rho_2) .
    showsl_lit " at position ") .
    showsl_pos p;

check_overlap ::
  forall a b.
    (Ccompare a, Infinite a, Eq a, Mapping_impl a, Showl a, Eq b,
      Showl b) => (a -> a) ->
                    (a -> a) ->
                      ([((Term b a, Term b a), [(Term b a, Term b a)])] ->
                        Term b a ->
                          Term b a ->
                            [(Term b a, Term b a)] ->
                              Sum (String -> String) ()) ->
                        ([((Term b a, Term b a), [(Term b a, Term b a)])] ->
                          [(Term b a, Term b a)] ->
                            Sum (String -> String) ()) ->
                          ([((Term b a, Term b a), [(Term b a, Term b a)])] ->
                            Term b a ->
                              (a -> Term b a) ->
                                [(Term b a, Term b a)] ->
                                  Sum (String -> String) ()) ->
                            [((Term b a, Term b a), [(Term b a, Term b a)])] ->
                              ((Term b a, Term b a), [(Term b a, Term b a)]) ->
                                ((Term b a, Term b a),
                                  [(Term b a, Term b a)]) ->
                                  [Nat] -> Sum (String -> String) ();
check_overlap xvar yvar check_context_joinable check_infeasible check_unfeasible
  r rho_1 rho_2 p =
  catch_errora
    (case mgu_var_disjoint_generic xvar yvar (subt_at (fst (fst rho_1)) p)
            (fst (fst rho_2))
      of {
      Nothing -> Inr ();
      Just (sigma_1, sigma_2) ->
        let {
          cs = subst_list sigma_1 (snd rho_1) ++ subst_list sigma_2 (snd rho_2);
          s = eval_term Fun (snd (fst rho_1)) sigma_1;
          t = intp_actxt Fun
                (ctxt_of_pos_term p (eval_term Fun (fst (fst rho_1)) sigma_1))
                (eval_term Fun (snd (fst rho_2)) sigma_2);
        } in catch_errora
               (choice
                 [catch_errora
                    (bindb (check (null p) id)
                      (\ _ -> check_crule_variants rho_1 rho_2))
                    (\ x -> Inl (showsl_lit "the overlap is critical\n" . x)),
                   catch_errora (check_context_joinable r s t cs)
                     (\ x ->
                       Inl (showsl_lit
                              "could not be shown to be context-joinable\n" .
                             x)),
                   catch_errora (check_infeasible r cs)
                     (\ x ->
                       Inl (showsl_lit "could not be shown to be infeasible\n" .
                             x)),
                   catch_errora
                     (check_unfeasible r (fst (fst rho_1)) sigma_1 cs)
                     (\ x ->
                       Inl (showsl_lit "could not be shown to be unfeasible\n" .
                             x))])
               (\ x -> Inl (showsl_sep id (showsl_literal "\n") x));
    })
    (\ x -> Inl ((showsl_coverlap rho_1 rho_2 p . showsl_lit ":\n\n") . x));

check_CCPs ::
  forall a b.
    (Ccompare a, Infinite a, Eq a, Mapping_impl a, Showl a, Eq b,
      Showl b) => (a -> a) ->
                    (a -> a) ->
                      ([((Term b a, Term b a), [(Term b a, Term b a)])] ->
                        Term b a ->
                          Term b a ->
                            [(Term b a, Term b a)] ->
                              Sum (String -> String) ()) ->
                        ([((Term b a, Term b a), [(Term b a, Term b a)])] ->
                          [(Term b a, Term b a)] ->
                            Sum (String -> String) ()) ->
                          ([((Term b a, Term b a), [(Term b a, Term b a)])] ->
                            Term b a ->
                              (a -> Term b a) ->
                                [(Term b a, Term b a)] ->
                                  Sum (String -> String) ()) ->
                            [((Term b a, Term b a), [(Term b a, Term b a)])] ->
                              Sum (String -> String) ();
check_CCPs xvar yvar check_context_joinable check_infeasible check_unfeasible r
  = catch_errora
      (forallM
        (\ rho_1 ->
          let {
            l_1 = fst (fst rho_1);
          } in catch_errora
                 (forallM
                   (\ rho_2 ->
                     catch_errora
                       (forallM
                         (check_overlap xvar yvar check_context_joinable
                           check_infeasible check_unfeasible r rho_1 rho_2)
                         (fun_poss_list l_1))
                       (\ x -> Inl (snd x)))
                   r)
                 (\ x -> Inl (snd x)))
        r)
      (\ x -> Inl (snd x));

rule2 ::
  forall a b.
    Unfeasible_proof a b -> ((Term a b, Term a b), [(Term a b, Term a b)]);
rule2 (UnfeasibleOverlap x1 x2 x3 x4 x5 x6 x7) = x7;

rule1 ::
  forall a b.
    Unfeasible_proof a b -> ((Term a b, Term a b), [(Term a b, Term a b)]);
rule1 (UnfeasibleOverlap x1 x2 x3 x4 x5 x6 x7) = x6;

check_unfeasiblea ::
  forall a.
    (Compare a, Eq a,
      Showl a) => Unfeasible_proof a [Char] ->
                    [((Term a [Char], Term a [Char]),
                       [(Term a [Char], Term a [Char])])] ->
                      Term a [Char] ->
                        ([Char] -> Term a [Char]) ->
                          [(Term a [Char], Term a [Char])] ->
                            Sum (String -> String) ();
check_unfeasiblea (UnfeasibleOverlap t u v ps qs rho_1 rho_2) r l mu cs =
  catch_errora
    (let {
       c = skol_rules cs;
       va = vars_trs (set cs);
       ta = skol va t;
       ua = skol va u;
       vb = skol va v;
       psa = map (skol_cstep_proof (set r) va) ps;
       qsa = map (skol_cstep_proof (set r) va) qs;
       ra = map_funs_crules Inl r ++ rules2crules c;
     } in bindb (check (equal_term l (fst (fst rho_1))) id)
            (\ _ ->
              bindb (check
                      (all (\ (a, b) ->
                             (case a of {
                               (la, _) -> (\ _ -> not (is_Var la));
                             })
                               b)
                        r)
                      (showsl_lit "variable left-hand side"))
                (\ _ ->
                  bindb (check_variant_in_ctrs r rho_1)
                    (\ _ ->
                      bindb (check_variant_in_ctrs r rho_2)
                        (\ _ ->
                          bindb (check
                                  (equal_term (eval_term Fun l mu)
                                     (eval_term Fun (fst (fst rho_2)) mu) ||
                                    supt_impl (eval_term Fun l mu)
                                      (eval_term Fun (fst (fst rho_2)) mu))
                                  id)
                            (\ _ ->
                              bindb (check (member t (image fst (set cs))) id)
                                (\ _ ->
                                  bindb (check
  (cs == subst_list mu (snd rho_1 ++ snd rho_2)) id)
                                    (\ _ ->
                                      bindb (check_csteps ra ta ua psa)
(\ _ ->
  bindb (check_csteps ra ta vb qsa)
    (\ _ ->
      bindb (check_airr r u)
        (\ _ ->
          bindb (check_airr r v)
            (\ _ ->
              check (is_none (mgu u v))
                (((showsl_terma u . showsl_lit " and ") . showsl_terma v) .
                  showsl_lit " are unifiable")))))))))))))
    (\ x ->
      Inl (((showsl_lit "conditions " . showsl_conditions cs) .
             showsl_lit " are not unfeasible\n") .
            x));

check_unfeasible ::
  forall a.
    (Compare_order a, Eq a,
      Showl a) => [([Char] -> Term a [Char], Unfeasible_proof a [Char])] ->
                    [((Term a [Char], Term a [Char]),
                       [(Term a [Char], Term a [Char])])] ->
                      Term a [Char] ->
                        ([Char] -> Term a [Char]) ->
                          [(Term a [Char], Term a [Char])] ->
                            Sum (String -> String) ();
check_unfeasible css r l mu cs =
  catch_errora
    (existsM
      (\ (mua, uo) ->
        let {
          cs_1 = snd (rule1 uo);
          cs_2 = snd (rule2 uo);
          csa = subst_list mua (cs_1 ++ cs_2);
          la = fst (fst (rule1 uo));
        } in bindb (check (equal_nat (size_list csa) (size_list cs))
                     (showsl_lit "lengths differ"))
               (\ _ ->
                 bindb (check
                         (not (is_none
                                (match_rules
                                  ((eval_term Fun l mu, eval_term Fun l mu) :
                                    cs)
                                  ((eval_term Fun la mua,
                                     eval_term Fun la mua) :
                                    csa))) &&
                           not (is_none
                                 (match_rules
                                   ((eval_term Fun la mua,
                                      eval_term Fun la mua) :
                                     csa)
                                   ((eval_term Fun l mu, eval_term Fun l mu) :
                                     cs))))
                         id)
                   (\ _ -> check_unfeasiblea uo r la mua csa)))
      css)
    (\ x -> Inl (showsl_sep id (showsl_literal "\n") x));

ta_rules_implb :: forall a b. Tree_automaton a b -> [Ta_rule a b];
ta_rules_implb (Tree_Automaton x1 x2 x3) = x2;

check_rules_subseteq ::
  forall a b.
    (Eq a, Showl a, Eq b,
      Showl b) => [Ta_rule a b] ->
                    Tree_automaton a b -> Sum (String -> String) ();
check_rules_subseteq rs a =
  catch_errora (check_subseteq rs (ta_rules_implb a))
    (\ x ->
      Inl ((showsl_lit "rule " . showsl_ta_rule x) . showsl_lit " is missing"));

ta_final :: forall a b c. Ta_ext a b c -> Set a;
ta_final (Ta_ext ta_final ta_rules ta_eps more) = ta_final;

ta_syms ::
  forall a b.
    (Ccompare a, Eq a, Ceq b, Ccompare b, Eq b,
      Set_impl b) => Ta_ext a b () -> Set (b, Nat);
ta_syms ta = image r_sym (ta_rules ta);

ta_inter_eps_empty ::
  forall a b c d.
    (Ceq a, Ccompare a, Eq a, Set_impl a, Ceq b, Ccompare b, Eq b, Set_impl b,
      Ceq c, Ccompare c, Eq c,
      Set_impl c) => Ta_ext a b () -> Ta_ext c b d -> Ta_ext (a, c) b ();
ta_inter_eps_empty ta t =
  Ta_ext (productc (ta_final ta) (ta_final t))
    (image (\ (TA_rule f ps p, TA_rule _ qs q) -> TA_rule f (zip ps qs) (p, q))
      (sup_seta
        (image
          (\ f ->
            productc (filtera (\ r -> r_sym r == f) (ta_rules ta))
              (filtera (\ r -> r_sym r == f) (ta_rules t)))
          (ta_syms ta))))
    bot_set ();

add_rule_states :: forall a b. (Eq a) => [Ta_rule a b] -> [a] -> [a];
add_rule_states rs ss =
  fold (\ r ssa -> (case r of {
                     TA_rule _ qs q -> insertb q (fold insertb qs ssa);
                   }))
    rs ss;

sig_rules ::
  forall a b.
    (Ceq a, Ccompare a, Eq a, Ccompare b,
      Eq b) => Set (a, Nat) -> b -> Set (Ta_rule b a);
sig_rules f c = image (\ (fa, n) -> TA_rule fa (replicate n c) c) f;

star :: forall a b. a -> Term a b -> Term a b;
star c (Var x) = Fun c [];
star c (Fun f ts) = Fun f (map (star c) ts);

ground_instances_rules ::
  forall a b.
    (Ceq a, Ccompare a, Compare a, Eq a, Compare b,
      Eq b) => Set (a, Nat) -> a -> Term a b -> Set (Ta_rule (Term a b) a);
ground_instances_rules f c (Var x) = sig_rules f (Fun c []);
ground_instances_rules fa c (Fun f ts) =
  sup_set
    (inserta (TA_rule f (map (star c) ts) (star c (Fun f ts)))
      (set_empty (of_phantom set_impl_ta_rule)))
    (sup_seta (image (ground_instances_rules fa c) (set ts)));

ground_instances_ta ::
  forall a b.
    (Ceq a, Ccompare a, Compare a, Eq a, Compare b,
      Eq b) => Set (a, Nat) -> a -> Term a b -> Ta_ext (Term a b) a ();
ground_instances_ta f c t =
  Ta_ext (inserta (star c t) (set_empty (of_phantom set_impl_term)))
    (ground_instances_rules f c t)
    (set_empty
      (of_phantom (set_impl_prod :: Phantom (Term a b, Term a b) Set_impla)))
    ();

sig_rules_list :: forall a b. [(a, Nat)] -> b -> [Ta_rule b a];
sig_rules_list f c = map (\ (fa, n) -> TA_rule fa (replicate n c) c) f;

gi_rules_list ::
  forall a b. [(a, Nat)] -> a -> Term a b -> [Ta_rule (Term a b) a];
gi_rules_list f c (Var x) = sig_rules_list f (Fun c []);
gi_rules_list fa c (Fun f ts) =
  TA_rule f (map (star c) ts) (star c (Fun f ts)) :
    concatMap (gi_rules_list fa c) ts;

growing_rule ::
  forall a b.
    (Eq a, Ceq b, Ccompare b, Eq b, Set_impl b) => (Term a b, Term a b) -> Bool;
growing_rule (l, r) =
  ball (vars_term r)
    (\ x ->
      ball (var_poss l)
        (\ p ->
          (if equal_term (Var x) (subt_at l p)
            then less_eq_nat (size_list p) one_nat else True)));

growing ::
  forall a b.
    (Compare a, Eq a, Ceq b, Ccompare b, Compare b, Eq b,
      Set_impl b) => Set (Term a b, Term a b) -> Bool;
growing r = ball r growing_rule;

check_growing ::
  forall a b.
    (Compare a, Eq a, Ceq b, Ccompare b, Compare b, Eq b,
      Set_impl b) => [(Term a b, Term a b)] -> Sum (String -> String) ();
check_growing r = check (growing (set r)) (showsl_lit "TRS is not growing");

combs :: forall a b. [a] -> [b] -> [[(a, b)]];
combs [] ys = [[]];
combs (x : xs) ys = concatMap (\ l -> map (\ y -> (x, y) : l) ys) (combs xs ys);

state_substs :: forall a b. [a] -> [b] -> [[(a, b)]];
state_substs v q = combs v q;

lhss_impl :: forall a b. (Eq a) => [(a, b)] -> [a];
lhss_impl r = remdups (map fst r);

mp_ta_rules ::
  forall a b c.
    (Eq a,
      Eq b) => [(Term a b, c)] -> [(a, Nat)] -> a -> [Ta_rule (Term a b) a];
mp_ta_rules r f c = concatMap (gi_rules_list f c) (lhss_impl r);

all_interval :: forall a. (Eq a, Interval a) => (a -> Bool) -> a -> a -> Bool;
all_interval p a b =
  (if less a b then p a && all_interval p (plus a onea) b else True) &&
    (if a == b then p a else True);

r_root :: forall a b. Ta_rule a b -> b;
r_root (TA_rule x1 x2 x3) = x1;

reachable_states ::
  forall a b c.
    (Ceq a, Ccompare a, Eq a, Set_impl a, Ccompare b,
      Eq b) => Set (Ta_rule a b) -> Term (Sum b a) c -> Set a;
reachable_states delta (Fun (Inr q) []) = inserta q bot_set;
reachable_states delta (Fun (Inl f) ts) =
  image r_rhs
    (filtera
      (\ r ->
        r_root r == f &&
          equal_nat (size_list (r_lhs_states r)) (size_list ts) &&
            let {
              d = minus_nat (size_list ts) one_nat;
            } in (if less_nat d (size_list ts)
                   then all_interval
                          (\ i ->
                            member (nth (r_lhs_states r) i)
                              (reachable_states delta (nth ts i)))
                          zero_nat d
                   else True))
      delta);
reachable_states delta (Var v) = bot_set;
reachable_states delta (Fun (Inr va) (vb : vc)) = bot_set;

qi :: forall a b.
        (Eq b) => a -> Term a b -> (b -> Term a b) -> Term a b -> Term a b;
qi c t g (Var x) = (if contains_var_term x t then g x else star c (Var x));
qi c t g (Fun f ts) = star c (Fun f ts);

inf_step ::
  forall a b.
    (Ccompare a, Compare a, Eq a, Compare b,
      Eq b) => a -> [(Term a b, Term a b)] ->
                      [[(b, Term a b)]] ->
                        Set (Ta_rule (Term a b) a) ->
                          Set (Ta_rule (Term a b) a);
inf_step c r s delta =
  foldr (sup_set .
          (\ (a, b) ->
            (case a of {
              (l, ra) ->
                (\ theta ->
                  (case l of {
                    Fun f ls ->
                      image (TA_rule f (map (qi c ra (fun_of theta)) ls))
                        ((reachable_states ::
                           Set (Ta_rule (Term a b) a) ->
                             Term (Sum a (Term a b)) b -> Set (Term a b))
                          delta
                          (eval_term Fun (map_term Inl (\ x -> x) ra)
                            ((\ fa -> Fun (Inr fa) []) . fun_of theta)));
                  }));
            })
              b))
    (product r s) (set_empty (of_phantom set_impl_ta_rule));

funas_ta_rule ::
  forall a b. (Ceq b, Ccompare b, Set_impl b) => Ta_rule a b -> Set (b, Nat);
funas_ta_rule r = inserta (r_root r, size_list (r_lhs_states r)) bot_set;

funas_ta ::
  forall a b.
    (Ccompare a, Eq a, Finite_UNIV b, Cenum b, Ceq b, Cproper_interval b, Eq b,
      Set_impl b) => Ta_ext a b () -> Set (b, Nat);
funas_ta a = sup_seta (image funas_ta_rule (ta_rules a));

ta_of_ta ::
  forall a b.
    (Ceq a, Ccompare a, Eq a, Set_impl a, Ccompare b,
      Eq b) => Tree_automaton a b -> Ta_ext a b ();
ta_of_ta (Tree_Automaton fin rules eps) =
  Ta_ext (set fin) (set rules) (set eps) ();

insert_funas_term :: forall a b. (Eq a) => Term a b -> [(a, Nat)] -> [(a, Nat)];
insert_funas_term (Var x) fs = fs;
insert_funas_term (Fun f ts) fs =
  insertb (f, size_list ts) (foldr insert_funas_term ts fs);

insert_funas_rule ::
  forall a b. (Eq a) => (Term a b, Term a b) -> [(a, Nat)] -> [(a, Nat)];
insert_funas_rule r fs =
  insert_funas_term (fst r) (insert_funas_term (snd r) fs);

insert_funas_trs ::
  forall a b. (Eq a) => [(Term a b, Term a b)] -> [(a, Nat)] -> [(a, Nat)];
insert_funas_trs trs = foldr insert_funas_rule trs;

linear_term_impl ::
  forall a b. (Ceq a, Ccompare a) => Set a -> Term b a -> Maybe (Set a);
linear_term_impl xs (Var x) =
  (if member x xs then Nothing else Just (inserta x xs));
linear_term_impl xs (Fun uu []) = Just xs;
linear_term_impl xs (Fun f (t : ts)) =
  (case linear_term_impl xs t of {
    Nothing -> Nothing;
    Just ys -> linear_term_impl ys (Fun f ts);
  });

linear_term :: forall a b. (Ceq b, Ccompare b, Set_impl b) => Term a b -> Bool;
linear_term t = not (is_none (linear_term_impl bot_set t));

check_linear_trs ::
  forall a b.
    (Showl a, Ceq b, Ccompare b, Set_impl b,
      Showl b) => [(Term a b, Term a b)] -> Sum (String -> String) ();
check_linear_trs r =
  catch_errora
    (catch_errora
      (forallM
        (\ x ->
          (if (case x of {
                (l, ra) -> linear_term l && linear_term ra;
              })
            then Inr () else Inl x))
        r)
      (\ x -> Inl (snd x)))
    (\ _ -> Inl (showsl_trs r . showsl_literal "\nis not linear\n"));

reduced_TA ::
  forall a b c.
    (Ccompare a, Eq a, Ceq b, Ccompare b, Eq b,
      Set_impl b) => a -> Ta_ext b a c -> Set b -> Ta_ext b a ();
reduced_TA f ta q =
  Ta_ext bot_set
    (sup_set
      (image
        (\ (TA_rule fa qs a) ->
          TA_rule fa (filter (\ qa -> not (member qa q)) qs) a)
        (filtera (\ r -> not (member (r_rhs r) q)) (ta_rules ta)))
      (image (\ p -> TA_rule f [] (snd p))
        (filtera (\ p -> member (fst p) q && not (member (snd p) q))
          (ta_eps ta))))
    (filtera (\ p -> not (member (fst p) q) && not (member (snd p) q))
      (ta_eps ta))
    ();

new_reach ::
  forall a b c.
    (Ceq a, Ccompare a, Eq a, Set_impl a, Ccompare b,
      Eq b) => Ta_ext a b c -> Set a;
new_reach ta =
  image r_rhs (filtera (\ r -> null (r_lhs_states r)) (ta_rules ta));

ta_reachable ::
  forall a b.
    (Cenum a, Ceq a, Ccompare a, Eq a, Set_impl a, Ccompare b, Default b,
      Eq b) => Ta_ext a b () -> Set a;
ta_reachable ta =
  let {
    q = new_reach ta;
  } in (if less_eq_set q bot_set then bot_set
         else sup_set q (ta_reachable (reduced_TA defaulta ta q)));

ta_empty ::
  forall a b.
    (Cenum a, Ceq a, Ccompare a, Eq a, Set_impl a, Ccompare b, Default b,
      Eq b) => Ta_ext a b () -> Bool;
ta_empty ta = less_eq_set (inf_set (ta_reachable ta) (ta_final ta)) bot_set;

check_etac_nonreachable ::
  forall a b.
    (Finite_UNIV a, Cenum a, Ceq a, Cproper_interval a, Compare a, Default a,
      Eq a, Set_impl a, Showl a, Ceq b, Ccompare b, Compare b, Eq b, Set_impl b,
      Showl b) => [(a, Nat)] ->
                    a -> a -> Tree_automaton (Term a b) a ->
                                [(Term a b, Term a b)] ->
                                  Term a b ->
                                    Term a b -> Sum (String -> String) ();
check_etac_nonreachable f aa c a r s t =
  let {
    fa = set f;
  } in bindb (check (member (aa, zero_nat) fa)
               ((showsl_lit "constant " . showsl aa) .
                 showsl_lit " is not in signature"))
         (\ _ ->
           bindb (check (not (member (c, zero_nat) fa))
                   (showsl_lit "star-symbol is not fresh w.r.t. signature"))
             (\ _ ->
               bindb (catch_errora (check_subseteq (insert_funas_term s []) f)
                       (\ _ -> Inl (showsl_lit "lhs violates signature")))
                 (\ _ ->
                   bindb (catch_errora
                           (check_subseteq (insert_funas_term t []) f)
                           (\ _ -> Inl (showsl_lit "rhs violates signature")))
                     (\ _ ->
                       let {
                         fs = insert_funas_trs r [];
                       } in bindb (catch_errora (check_subseteq fs f)
                                    (\ _ ->
                                      Inl
(showsl_lit "TRS violates signature")))
                              (\ _ ->
                                bindb (check_varcond_no_Var_lhs r)
                                  (\ _ ->
                                    bindb (check_linear_trs r)
                                      (\ _ ->
bindb (check_growing r)
  (\ _ ->
    let {
      aaa = ta_of_ta a;
    } in bindb (check
                 (set_eq (ta_eps aaa)
                   (set_empty
                     (of_phantom
                       (set_impl_prod ::
                         Phantom (Term a b, Term a b) Set_impla))))
                 (showsl_lit "no epsilon transitions allowed"))
           (\ _ ->
             bindb (check (member (star c t) (ta_final aaa))
                     ((showsl_lit "final state for " . showsl_terma t) .
                       showsl_lit " is missing"))
               (\ _ ->
                 bindb (check (less_eq_set (funas_ta aaa) fa)
                         (showsl_lit
                           "the given automaton does not respect the signature"))
                   (\ _ ->
                     let {
                       ts = gi_rules_list f c t;
                       ms = mp_ta_rules r f c;
                     } in bindb (check_rules_subseteq ts a)
                            (\ _ ->
                              bindb (check_rules_subseteq ms a)
                                (\ _ ->
                                  let {
                                    q = add_rule_states ts
  (add_rule_states ms []);
                                    ss = state_substs
   (remdups (concatMap (vars_term_list . snd) r)) q;
                                    d = set (ta_rules_implb a);
                                    da = inf_step c r ss d;
                                  } in bindb
 (check (less_eq_set da d)
   (showsl_lit "the given tree automaton is not closed under completion rules"))
 (\ _ ->
   check (ta_empty (ta_inter_eps_empty aaa (ground_instances_ta fa c s)))
     (showsl_lit
       "the given tree automaton does not certify non-reachability")))))))))))))));

subst_s :: forall a b c. Rel_impl_ext a b c -> Sum (String -> String) ();
subst_s
  (Rel_impl_ext valid standard desc s ns nst af top_af sn subst_s ce_compat
    co_rewr top_mono top_refl mono_af mono not_wst not_sst cpx more)
  = subst_s;

co_rewr :: forall a b c. Rel_impl_ext a b c -> Sum (String -> String) ();
co_rewr
  (Rel_impl_ext valid standard desc s ns nst af top_af sn subst_s ce_compat
    co_rewr top_mono top_refl mono_af mono not_wst not_sst cpx more)
  = co_rewr;

valid :: forall a b c. Rel_impl_ext a b c -> Sum (String -> String) ();
valid (Rel_impl_ext valid standard desc s ns nst af top_af sn subst_s ce_compat
        co_rewr top_mono top_refl mono_af mono not_wst not_sst cpx more)
  = valid;

rel_impl_co_rewrite_pair ::
  forall a b. Rel_impl_ext a b () -> Sum (String -> String) ();
rel_impl_co_rewrite_pair ri =
  catch_errora
    (bindb (valid ri)
      (\ _ ->
        bindb (catch_errora (co_rewr ri)
                (\ x ->
                  Inl (x . showsl_lit
                             "\nproblem in ensuring disjointness property")))
          (\ _ ->
            catch_errora (subst_s ri)
              (\ x ->
                Inl (x . showsl_lit
                           "\nproblem in ensuring stability of strict relation")))))
    (\ x -> Inl (showsl_lit "problem with being a co-rewrite pair\n" . x));

ns :: forall a b c.
        Rel_impl_ext a b c -> (Term a b, Term a b) -> Sum (String -> String) ();
ns (Rel_impl_ext valid standard desc s ns nst af top_af sn subst_s ce_compat
     co_rewr top_mono top_refl mono_af mono not_wst not_sst cpx more)
  = ns;

rel_impl_ns ::
  forall a b.
    Rel_impl_ext a b () -> [(Term a b, Term a b)] -> Sum (String -> String) ();
rel_impl_ns ri =
  (\ xs -> catch_errora (forallM (ns ri) xs) (\ x -> Inl (snd x)));

s :: forall a b c.
       Rel_impl_ext a b c -> (Term a b, Term a b) -> Sum (String -> String) ();
s (Rel_impl_ext valid standard desc s ns nst af top_af sn subst_s ce_compat
    co_rewr top_mono top_refl mono_af mono not_wst not_sst cpx more)
  = s;

check_non_reach_co_rewrite_pair ::
  forall a b.
    (Compare_order a, Showl a,
      Showl b) => Rel_impl_ext a b () ->
                    [(Term a b, Term a b)] ->
                      Term a b -> Term a b -> Sum (String -> String) ();
check_non_reach_co_rewrite_pair rp r sa t =
  catch_errora
    (bindb (rel_impl_co_rewrite_pair rp)
      (\ _ -> bindb (rel_impl_ns rp r) (\ _ -> s rp (t, sa))))
    (\ x ->
      Inl ((showsl_lit
              "problem in disproving non-reachability via co-rewrite pairs" .
             showsl_literal "\n") .
            x));

check_variants_rule ::
  forall a b.
    (Eq a, Showl a, Ccompare b, Eq b, Mapping_impl b,
      Showl b) => (Term a b, Term a b) ->
                    (Term a b, Term a b) -> Sum (String -> String) ();
check_variants_rule ra r =
  check (not (is_none (match_rules [ra] [r])) &&
          not (is_none (match_rules [r] [ra])))
    (((showsl_rule ra . showsl_literal " and ") . showsl_rule r) .
      showsl_literal " are not variants of each other\n");

find_variant_in_trs ::
  forall a b.
    (Eq a, Showl a, Ccompare b, Eq b, Mapping_impl b,
      Showl b) => (Term a b, Term a b) ->
                    [(Term a b, Term a b)] ->
                      Sum (String -> String) (Term a b, Term a b);
find_variant_in_trs ra r =
  catch_errora (firstM (check_variants_rule ra) r)
    (\ x -> Inl (showsl_sep id (showsl_literal "\n") x));

check_rstep_p ::
  forall a b c.
    (Eq a, Ccompare b, Eq b,
      Mapping_impl b) => (Term a b -> Term a b -> Sum (String -> String) c) ->
                           (Term a b, Term a b) ->
                             [Nat] ->
                               Term a b -> Term a b -> Sum (String -> String) c;
check_rstep_p c rho p s t =
  (if not (membera (poss_list t) p)
    then Inl (showsl_literal "no step possible at this position")
    else (case rho of {
           (l, r) ->
             (case match_list Var [(l, subt_at s p), (r, subt_at t p)] of {
               Nothing -> Inl (showsl_literal "rule does not match");
               Just sigma ->
                 (if equal_term t
                       (intp_actxt Fun (ctxt_of_pos_term p s)
                         (eval_term Fun r sigma))
                   then c (eval_term Fun l sigma) (eval_term Fun r sigma)
                   else Inl (showsl_literal "result does not match"));
             });
         }));

check_step_rule ::
  forall a b.
    (Eq a, Showl a, Ccompare b, Eq b, Mapping_impl b,
      Showl b) => (Term a b -> Term a b -> Sum (String -> String) ()) ->
                    (Term a b, Term a b) ->
                      Term a b -> Term a b -> Sum (String -> String) ();
check_step_rule c rho s t =
  catch_errora (existsM (\ p -> check_rstep_p c rho p s t) (poss_list s))
    (\ _ ->
      Inl (((showsl_lit " is not a reduct with respect to " .
              showsl_terma (fst rho)) .
             showsl_lit " -> ") .
            showsl_terma (snd rho)));

check_step ::
  forall a b.
    (Eq a, Showl a, Ccompare b, Eq b, Mapping_impl b,
      Showl b) => (Term a b -> Term a b -> Sum (String -> String) ()) ->
                    [(Term a b, Term a b)] ->
                      Term a b -> Term a b -> Sum (String -> String) ();
check_step c [] s t =
  Inl ((((showsl_lit "no step from " . showsl_terma s) . showsl_lit " to ") .
         showsl_terma t) .
        showsl_lit " found\n");
check_step c (ea : e) s t =
  catch_errora (choice [check_step_rule c ea s t, check_step c e s t])
    (\ x -> Inl (showsl_sep id (showsl_literal "\n") x));

sym_list :: forall a. (Eq a) => [(a, a)] -> [(a, a)];
sym_list xs = uniona xs (map (\ (x, y) -> (y, x)) xs);

check_stepa ::
  forall a b.
    (Eq a, Showl a, Ccompare b, Eq b, Mapping_impl b,
      Showl b) => (Term a b -> Term a b -> Sum (String -> String) ()) ->
                    ([(Term a b, Term a b)], [(Term a b, Term a b)]) ->
                      Oc_irule a b ->
                        Sum (String -> String)
                          ([(Term a b, Term a b)], [(Term a b, Term a b)]);
check_stepa check_ord (e, r) (OC_Deduce s t u) =
  catch_errora
    (let {
       sa = r ++ sym_list e;
     } in bindb (catch_errora (check_step (\ _ _ -> Inr ()) sa s t)
                  (\ x ->
                    Inl (((((showsl_lit " no step from " . showsl_terma s) .
                             showsl_lit " to ") .
                            showsl_terma t) .
                           showsl_literal "\n") .
                          x)))
            (\ _ ->
              bindb (catch_errora (check_step (\ _ _ -> Inr ()) sa s u)
                      (\ x ->
                        Inl (((((showsl_lit " no step from " . showsl_terma s) .
                                 showsl_lit " to ") .
                                showsl_terma u) .
                               showsl_literal "\n") .
                              x)))
                (\ _ -> Inr ((t, u) : e, r))))
    (\ x ->
      Inl (((((((showsl_lit "error in deduce step " . showsl_terma t) .
                 showsl_lit " <- ") .
                showsl_terma s) .
               showsl_lit " -> ") .
              showsl_terma u) .
             showsl_literal "\n") .
            x));
check_stepa check_ord (e, r) (OC_Orientl s t) =
  catch_errora
    (bindb (check_ord s t)
      (\ _ ->
        bindb (find_variant_in_trs (s, t) e)
          (\ st -> Inr (removeAll st e, (s, t) : r))))
    (\ x ->
      Inl (((((showsl_lit "error in orientl step for " . showsl_terma s) .
               showsl_lit " -> ") .
              showsl_terma t) .
             showsl_literal "\n") .
            x));
check_stepa check_ord (e, r) (OC_Orientr s t) =
  catch_errora
    (bindb (check_ord t s)
      (\ _ ->
        bindb (find_variant_in_trs (s, t) e)
          (\ st -> Inr (removeAll st e, (t, s) : r))))
    (\ x ->
      Inl (((((showsl_lit "error in orientr step for " . showsl_terma s) .
               showsl_lit " -> ") .
              showsl_terma t) .
             showsl_literal "\n") .
            x));
check_stepa check_ord (e, r) (OC_Delete s) =
  catch_errora
    (bindb (find_variant_in_trs (s, s) e) (\ ss -> Inr (removeAll ss e, r)))
    (\ x ->
      Inl (((((showsl_lit "error in delete step for " . showsl_terma s) .
               showsl_lit " = ") .
              showsl_terma s) .
             showsl_literal "\n") .
            x));
check_stepa check_ord (e, r) (OC_Compose s t u) =
  catch_errora
    (bindb (find_variant_in_trs (s, t) r)
      (\ st ->
        let {
          ra = removeAll st r;
        } in bindb (catch_errora (check_step check_ord (ra ++ sym_list e) t u)
                     (\ x ->
                       Inl (((((showsl_lit " no ordstep from " .
                                 showsl_terma t) .
                                showsl_lit " to ") .
                               showsl_terma u) .
                              showsl_literal "\n") .
                             x)))
               (\ _ -> Inr (e, (s, u) : ra))))
    (\ x ->
      Inl (((((((((showsl_lit "error in compose step from " . showsl_terma s) .
                   showsl_lit " -> ") .
                  showsl_terma t) .
                 showsl_lit " to ") .
                showsl_terma s) .
               showsl_lit " -> ") .
              showsl_terma u) .
             showsl_literal "\n") .
            x));
check_stepa check_ord (e, r) (OC_Simplifyl s t u) =
  catch_errora
    (bindb (find_variant_in_trs (s, t) e)
      (\ st ->
        let {
          ea = removeAll st e;
        } in bindb (catch_errora (check_step check_ord (r ++ sym_list ea) s u)
                     (\ x ->
                       Inl (((((showsl_lit " no ordstep from " .
                                 showsl_terma s) .
                                showsl_lit " to ") .
                               showsl_terma u) .
                              showsl_literal "\n") .
                             x)))
               (\ _ -> Inr ((u, t) : ea, r))))
    (\ x ->
      Inl (((((((((showsl_lit "error in simplifyl step from " .
                    showsl_terma s) .
                   showsl_lit " = ") .
                  showsl_terma t) .
                 showsl_lit " to ") .
                showsl_terma u) .
               showsl_lit " = ") .
              showsl_terma t) .
             showsl_literal "\n") .
            x));
check_stepa check_ord (e, r) (OC_Simplifyr s t u) =
  catch_errora
    (bindb (find_variant_in_trs (s, t) e)
      (\ st ->
        let {
          ea = removeAll st e;
        } in bindb (catch_errora (check_step check_ord (r ++ sym_list ea) t u)
                     (\ x ->
                       Inl (((((showsl_lit " no ordstep from " .
                                 showsl_terma t) .
                                showsl_lit " to ") .
                               showsl_terma u) .
                              showsl_literal "\n") .
                             x)))
               (\ _ -> Inr ((s, u) : ea, r))))
    (\ x ->
      Inl (((((((((showsl_lit "error in simplifyr step from " .
                    showsl_terma s) .
                   showsl_lit " = ") .
                  showsl_terma t) .
                 showsl_lit " to ") .
                showsl_terma s) .
               showsl_lit " = ") .
              showsl_terma u) .
             showsl_literal "\n") .
            x));
check_stepa check_ord (e, r) (OC_Collapse s t u) =
  catch_errora
    (bindb (find_variant_in_trs (t, s) r)
      (\ ts ->
        let {
          ra = removeAll ts r;
        } in bindb (catch_errora (check_step check_ord (ra ++ sym_list e) t u)
                     (\ x ->
                       Inl (((((showsl_lit " no ordstep from " .
                                 showsl_terma t) .
                                showsl_lit " to ") .
                               showsl_terma u) .
                              showsl_literal "\n") .
                             x)))
               (\ _ -> Inr ((u, s) : e, ra))))
    (\ x ->
      Inl (((((((((showsl_lit "error in collapse step from " . showsl_terma s) .
                   showsl_lit " -> ") .
                  showsl_terma t) .
                 showsl_lit " to ") .
                showsl_terma u) .
               showsl_lit " = ") .
              showsl_terma t) .
             showsl_literal "\n") .
            x));

showsl_eqs ::
  forall a b. (Showl a, Showl b) => [(Term a b, Term a b)] -> String -> String;
showsl_eqs = showsl_trsa showsl showsl "equational system:" " = ";

check_variant_in_trs ::
  forall a b.
    (Eq a, Showl a, Ccompare b, Eq b, Mapping_impl b,
      Showl b) => [(Term a b, Term a b)] ->
                    (Term a b, Term a b) -> Sum (String -> String) ();
check_variant_in_trs ra r =
  catch_errora
    (catch_errora (existsM (check_variants_rule r) ra)
      (\ x -> Inl (showsl_sep id id x)))
    (\ _ ->
      Inl ((showsl_rule r .
             showsl_literal " is not a variant of any rule in ") .
            showsl_trs ra));

check_variants_trs ::
  forall a b.
    (Eq a, Showl a, Ccompare b, Eq b, Mapping_impl b,
      Showl b) => [(Term a b, Term a b)] ->
                    [(Term a b, Term a b)] -> Sum (String -> String) ();
check_variants_trs ra r =
  catch_errora (forallM (check_variant_in_trs r) ra) (\ x -> Inl (snd x));

check_oc ::
  forall a b.
    (Eq a, Showl a, Ccompare b, Eq b, Mapping_impl b,
      Showl b) => (Term a b -> Term a b -> Sum (String -> String) ()) ->
                    ([(Term a b, Term a b)], [(Term a b, Term a b)]) ->
                      ([(Term a b, Term a b)], [(Term a b, Term a b)]) ->
                        [Oc_irule a b] -> Sum (String -> String) ();
check_oc check_ord (ea, ra) (e, r) [] =
  let {
    err = (\ f x y -> (f x . showsl_lit "\nis not a variant of\n") . f y);
  } in bindb (catch_errora (check_variants_trs ea e)
               (\ _ -> Inl (err showsl_eqs ea e)))
         (\ _ ->
           bindb (catch_errora (check_variants_trs e ea)
                   (\ _ -> Inl (err showsl_eqs ea e)))
             (\ _ ->
               bindb (catch_errora (check_variants_trs ra r)
                       (\ _ -> Inl (err showsl_trs ra r)))
                 (\ _ ->
                   catch_errora (check_variants_trs r ra)
                     (\ _ -> Inl (err showsl_trs ra r)))));
check_oc check_ord (ea, ra) (e, r) (x : xs) =
  bindb (check_stepa check_ord (ea, ra) x)
    (\ (eaa, raa) -> check_oc check_ord (eaa, raa) (e, r) xs);

ext_subst ::
  forall a b c d.
    (Showl a, Eq b) => a -> (b -> Term a c) -> Term d b -> b -> Term a c;
ext_subst least sigma l =
  (\ x ->
    (if membera (insert_vars_term l []) x then sigma x else Fun least []));

mord_rewrite ::
  forall a b.
    (Eq a, Showl a, Ccompare b, Eq b, Mapping_impl b,
      Showl b) => (Term a b -> Term a b -> Bool) ->
                    a -> [(Term a b, Term a b)] -> Term a b -> [Term a b];
mord_rewrite check_ord least r s =
  concatMap
    (\ (l, ra) ->
      concatMap
        (\ p ->
          (case match (subt_at s p) l of {
            Nothing -> [];
            Just sigma ->
              let {
                sigmaa = ext_subst least sigma l;
              } in (if check_ord (eval_term Fun l sigmaa)
                         (eval_term Fun ra sigmaa)
                     then [intp_actxt Fun (ctxt_of_pos_term p s)
                             (eval_term Fun ra sigmaa)]
                     else []);
          }))
        (poss_list s))
    r;

first_mord_rewrite ::
  forall a b.
    (Eq a, Showl a, Ccompare b, Eq b, Mapping_impl b,
      Showl b) => (Term a b -> Term a b -> Bool) ->
                    a -> [(Term a b, Term a b)] -> Term a b -> Maybe (Term a b);
first_mord_rewrite check_ord least r s =
  (case mord_rewrite check_ord least r s of {
    [] -> Nothing;
    t : _ -> Just t;
  });

compute_NF :: forall a. (a -> Maybe a) -> a -> Maybe a;
compute_NF f a = (case f a of {
                   Nothing -> Just a;
                   Just aa -> compute_NF f aa;
                 });

compute_mordstep_NF ::
  forall a b.
    (Eq a, Showl a, Ccompare b, Eq b, Mapping_impl b,
      Showl b) => (Term a b -> Term a b -> Bool) ->
                    a -> [(Term a b, Term a b)] -> Term a b -> Maybe (Term a b);
compute_mordstep_NF check_ord least r s =
  compute_NF (first_mord_rewrite check_ord least r) s;

check_instance_joinable ::
  forall a b.
    (Eq a, Showl a, Ccompare b, Eq b, Mapping_impl b,
      Showl b) => (Term a b -> Term a b -> Bool) ->
                    a -> [(Term a b, Term a b)] ->
                           [(Term a b, Term a b)] ->
                             Term a b -> Term a b -> Sum (String -> String) ();
check_instance_joinable check_ord least e r s t =
  (case (compute_mordstep_NF check_ord least (e ++ r) s,
          compute_mordstep_NF check_ord least (e ++ r) t)
    of {
    (Nothing, _) -> Inl (showsl_literal "error: check_instance_joinable");
    (Just _, Nothing) -> Inl (showsl_literal "error: check_instance_joinable");
    (Just u, Just v) ->
      catch_errora
        (choice
          [check (equal_term u v) (showsl_lit "normal forms differ"),
            check_step (\ _ _ -> Inr ()) e u v])
        (\ x -> Inl (showsl_sep id (showsl_literal "\n") x));
  });

check_var_order_joinable ::
  forall a b.
    (Eq a, Showl a, Ccompare b, Infinite b, Eq b, Mapping_impl b, Linorder b,
      Showl b) => a -> ([b] -> Term a b -> Term a b -> Bool) ->
                         [(Term a b, Term a b)] ->
                           [(Term a b, Term a b)] ->
                             Term a b ->
                               Term a b -> [b] -> Sum (String -> String) ();
check_var_order_joinable least ext_check_ord e r s t vperm =
  check_instance_joinable (ext_check_ord vperm) least e r s t;

var_tuples_of_partitioning ::
  forall a.
    (Cenum a, Ceq a, Ccompare a, Eq a, Linorder a) => [Set a] -> [(a, a)];
var_tuples_of_partitioning ps =
  concatMap (\ p -> (case sorted_list_of_set p of {
                      [] -> [];
                      x : xs -> map (\ y -> (y, x)) (x : xs);
                    }))
    (remdups ps);

var_subst_of_partitioning ::
  forall a. (Cenum a, Ceq a, Ccompare a, Eq a, Linorder a) => [Set a] -> a -> a;
var_subst_of_partitioning p =
  (\ x -> (case map_of (var_tuples_of_partitioning p) x of {
            Nothing -> x;
            Just y -> y;
          }));

subst_of_partitioning ::
  forall a b.
    (Cenum a, Ceq a, Ccompare a, Eq a, Linorder a) => [Set a] -> a -> Term b a;
subst_of_partitioning p = (\ x -> Var (var_subst_of_partitioning p x));

insert_into_member_list ::
  forall a.
    (Cenum a, Ceq a, Ccompare a, Eq a,
      Set_impl a) => a -> [Set a] -> Set a -> [Set a];
insert_into_member_list new_el sets s =
  sup_set s (inserta new_el bot_set) : remove1 s sets;

coarser_partitions_with_list ::
  forall a.
    (Cenum a, Ceq a, Ccompare a, Eq a, Set_impl a) => a -> [Set a] -> [[Set a]];
coarser_partitions_with_list new_el p =
  (inserta new_el bot_set : p) : map (insert_into_member_list new_el p) p;

all_coarser_partitions_with_list ::
  forall a.
    (Cenum a, Ceq a, Ccompare a, Eq a,
      Set_impl a) => a -> [[Set a]] -> [[Set a]];
all_coarser_partitions_with_list elem ps =
  concatMap (coarser_partitions_with_list elem) ps;

all_partitions_list ::
  forall a. (Cenum a, Ceq a, Ccompare a, Eq a, Set_impl a) => [a] -> [[Set a]];
all_partitions_list [] = [[]];
all_partitions_list (e : x) =
  all_coarser_partitions_with_list e (all_partitions_list x);

inserts :: forall a. a -> [a] -> [[a]];
inserts x [] = [[x]];
inserts x (y : ys) = (x : y : ys) : map (\ a -> y : a) (inserts x ys);

perms :: forall a. [a] -> [[a]];
perms [] = [[]];
perms (x : xs) = concatMap (inserts x) (perms xs);

insert_vars_rule :: forall a b. (Eq b) => (Term a b, Term a b) -> [b] -> [b];
insert_vars_rule r xs = insert_vars_term (fst r) (insert_vars_term (snd r) xs);

check_var_orders_joinable ::
  forall a b.
    (Eq a, Showl a, Cenum b, Ceq b, Ccompare b, Infinite b, Eq b,
      Mapping_impl b, Linorder b, Set_impl b,
      Showl b) => a -> ([b] -> Term a b -> Term a b -> Bool) ->
                         [(Term a b, Term a b)] ->
                           [(Term a b, Term a b)] ->
                             Term a b -> Term a b -> Sum (String -> String) ();
check_var_orders_joinable least ext_check_ord e r s t =
  let {
    xs = remdups (insert_vars_rule (s, t) []);
  } in catch_errora
         (forallM
           (\ ps ->
             let {
               sigma = subst_of_partitioning ps;
             } in (case (eval_term Fun s sigma, eval_term Fun t sigma) of {
                    (sa, ta) ->
                      let {
                        orders = perms (remdups (insert_vars_rule (sa, ta) []));
                      } in catch_errora
                             (forallM
                               (check_var_order_joinable least ext_check_ord e r
                                 sa ta)
                               orders)
                             (\ x -> Inl (snd x));
                  }))
           (all_partitions_list xs))
         (\ x -> Inl (snd x));

check_rule_instance ::
  forall a b.
    (Eq a, Ccompare b, Eq b,
      Mapping_impl b) => (Term a b, Term a b) ->
                           (Term a b, Term a b) -> Sum (String -> String) ();
check_rule_instance ra r =
  (case match_list Var [(fst r, fst ra), (snd r, snd ra)] of {
    Nothing -> Inl (showsl_lit "rules do not match");
    Just _ -> Inr ();
  });

check_instancea ::
  forall a b.
    (Eq a, Ccompare b, Eq b,
      Mapping_impl b) => [(Term a b, Term a b)] ->
                           Term a b -> Term a b -> Sum (String -> String) ();
check_instancea e s t =
  catch_errora (existsM (check_rule_instance (s, t)) e)
    (\ x -> Inl (showsl_sep id (showsl_literal "\n") x));

catch_error :: forall a b c. Sum_bot a b -> (a -> Sum_bot c b) -> Sum_bot c b;
catch_error (Sumbot a) f = (case a of {
                             Inl aa -> f aa;
                             Inr aa -> Sumbot (Inr aa);
                           });

forallM_bot :: forall a b. (a -> Sum_bot b ()) -> [a] -> Sum_bot (a, b) ();
forallM_bot f [] = returna ();
forallM_bot f (x : xs) =
  binda (catch_error (f x) (\ e -> errora (x, e))) (\ _ -> forallM_bot f xs);

existsM_bot :: forall a b. (a -> Sum_bot b ()) -> [a] -> Sum_bot [b] ();
existsM_bot f [] = errora [];
existsM_bot f (x : xs) =
  catch_error (f x)
    (\ e -> catch_error (existsM_bot f xs) (\ ea -> errora (e : ea)));

choice_bot :: forall a b. [Sum_bot a b] -> Sum_bot [a] b;
choice_bot [] = errora [];
choice_bot (x : xs) =
  catch_error x (\ e -> catch_error (choice_bot xs) (\ ea -> errora (e : ea)));

lifta :: forall a. Sum a () -> Sum_bot a ();
lifta c = (case c of {
            Inl a -> errora a;
            Inr a -> returna a;
          });

check_ground_join_rel_bot ::
  forall a b.
    (Eq a, Showl a, Cenum b, Ceq b, Ccompare b, Infinite b, Eq b,
      Mapping_impl b, Linorder b, Set_impl b,
      Showl b) => (Term a b -> Term a b -> Bool) ->
                    a -> ([b] -> Term a b -> Term a b -> Bool) ->
                           [(Term a b, Term a b)] ->
                             [(Term a b, Term a b)] ->
                               Term a b ->
                                 Term a b -> Sum_bot (String -> String) ();
check_ground_join_rel_bot check_ord least ext_check_ord e r s t =
  (case (s, t) of {
    (Var x, _) ->
      catch_error
        (choice_bot
          [lifta (check (equal_term (Var x) t)
                   (showsl_lit "The terms are different.")),
            catch_error
              (existsM_bot
                (check_ground_join_rel_bot check_ord least ext_check_ord e r
                  (Var x))
                (mord_rewrite check_ord least (e ++ r) t))
              (\ _ -> errora (showsl_lit "No right-rewrite is possible."))])
        (\ ea -> errora (showsl_sep id (showsl_literal "\n") ea));
    (Fun _ _, Var x) ->
      catch_error
        (choice_bot
          [lifta (check (equal_term (Var x) s)
                   (showsl_lit "The terms are different.")),
            catch_error
              (existsM_bot
                (\ u ->
                  check_ground_join_rel_bot check_ord least ext_check_ord e r u
                    (Var x))
                (mord_rewrite check_ord least (e ++ r) s))
              (\ _ -> errora (showsl_lit "No left-rewrite is possible."))])
        (\ ea -> errora (showsl_sep id (showsl_literal "\n") ea));
    (Fun f ss, Fun g ts) ->
      catch_error
        (choice_bot
          [lifta (check (equal_term (Fun f ss) (Fun g ts))
                   (showsl_lit "terms differ")),
            lifta (check_instancea (e ++ r) (Fun f ss) (Fun g ts)),
            catch_error
              (existsM_bot
                (\ u ->
                  check_ground_join_rel_bot check_ord least ext_check_ord e r u
                    (Fun g ts))
                (mord_rewrite check_ord least (e ++ r) (Fun f ss)))
              (\ _ -> errora (showsl_literal "No left-rewrite is possible.")),
            catch_error
              (existsM_bot
                (check_ground_join_rel_bot check_ord least ext_check_ord e r
                  (Fun f ss))
                (mord_rewrite check_ord least (e ++ r) (Fun g ts)))
              (\ _ -> errora (showsl_literal "No right-rewrite is possible.")),
            (if f == g && equal_nat (size_list ss) (size_list ts)
              then catch_error
                     (forallM_bot
                       (\ (a, b) ->
                         check_ground_join_rel_bot check_ord least ext_check_ord
                           e r a b)
                       (zip ss ts))
                     (\ _ ->
                       errora
                         (showsl_literal "Arguments are not ground-joinable."))
              else errora
                     (showsl_literal "The congruence rule does not apply.")),
            lifta (check_var_orders_joinable least ext_check_ord e r (Fun f ss)
                    (Fun g ts))])
        (\ ea -> errora (showsl_sep id (showsl_literal "\n") ea));
  });

case_sum_bot :: forall a b c. a -> (b -> a) -> (c -> a) -> Sum_bot b c -> a;
case_sum_bot f g h (Sumbot p) = (case p of {
                                  Inl a -> g a;
                                  Inr a -> h a;
                                });

check_ground_join_rel ::
  forall a b.
    (Eq a, Showl a, Cenum b, Ceq b, Ccompare b, Infinite b, Eq b,
      Mapping_impl b, Linorder b, Set_impl b,
      Showl b) => (Term a b -> Term a b -> Bool) ->
                    a -> ([b] -> Term a b -> Term a b -> Bool) ->
                           [(Term a b, Term a b)] ->
                             [(Term a b, Term a b)] ->
                               Term a b ->
                                 Term a b -> Sum (String -> String) ();
check_ground_join_rel check_ord least ext_check_ord e r s t =
  case_sum_bot
    (Inl (showsl_literal "Ground joinability could not be established."))
    (\ _ ->
      Inl ((((showsl_lit "The equation " . showsl_terma s) . showsl_lit " = ") .
             showsl_terma t) .
            showsl_lit " is not ground joinable\n"))
    Inr (check_ground_join_rel_bot check_ord least ext_check_ord e r s t);

check_ooverlap_gj ::
  forall a b.
    (Eq a, Showl a, Cenum b, Ceq b, Ccompare b, Infinite b, Eq b,
      Mapping_impl b, Linorder b, Set_impl b,
      Showl b) => (Term a b -> Term a b -> Bool) ->
                    a -> (b -> b) ->
                           (b -> b) ->
                             ([b] -> Term a b -> Term a b -> Bool) ->
                               [(Term a b, Term a b)] ->
                                 [(Term a b, Term a b)] ->
                                   (Term a b, Term a b) ->
                                     (Term a b, Term a b) ->
                                       [Nat] -> Sum (String -> String) ();
check_ooverlap_gj check_ord least xvar yvar ext_check_ord e r rho_1 rho_2 p =
  (case mgu_var_disjoint_generic xvar yvar (fst rho_1) (subt_at (fst rho_2) p)
    of {
    Nothing -> Inr ();
    Just (sigma_1, sigma_2) ->
      let {
        s = intp_actxt Fun
              (ctxt_of_pos_term p (eval_term Fun (fst rho_2) sigma_2))
              (eval_term Fun (snd rho_1) sigma_1);
        a = eval_term Fun (snd rho_2) sigma_2;
      } in check_ground_join_rel check_ord least ext_check_ord e r s a;
  });

check_ECPs_gj ::
  forall a b.
    (Eq a, Showl a, Cenum b, Ceq b, Ccompare b, Infinite b, Eq b,
      Mapping_impl b, Linorder b, Set_impl b,
      Showl b) => (Term a b -> Term a b -> Bool) ->
                    a -> (b -> b) ->
                           (b -> b) ->
                             ([b] -> Term a b -> Term a b -> Bool) ->
                               [(Term a b, Term a b)] ->
                                 [(Term a b, Term a b)] ->
                                   Sum (String -> String) ();
check_ECPs_gj check_ord least xvar yvar ext_check_ord e r =
  catch_errora
    (let {
       ea = sym_list e;
       s = uniona r ea;
     } in catch_errora
            (forallM
              (\ rho_2 ->
                let {
                  l_2 = fst rho_2;
                } in catch_errora
                       (forallM
                         (\ rho_1 ->
                           catch_errora
                             (forallM
                               (check_ooverlap_gj check_ord least xvar yvar
                                 ext_check_ord ea r rho_1 rho_2)
                               (fun_poss_list l_2))
                             (\ x -> Inl (snd x)))
                         s)
                       (\ x -> Inl (snd x)))
              s)
            (\ x -> Inl (snd x)))
    (\ x -> Inl (showsl_lit "Not all extended CPs are ground joinable." . x));

ext_less ::
  forall a b c. Redord_closure_ext a b c -> [b] -> Term a b -> Term a b -> Bool;
ext_less (Redord_closure_ext ext_less valid more) = ext_less;

validc :: forall a b c. Redord_closure_ext a b c -> Sum (String -> String) ();
validc (Redord_closure_ext ext_less valid more) = valid;

min_const :: forall a b c. Redord_ext a b c -> a;
min_const (Redord_ext valid less min_const more) = min_const;

valida :: forall a b c. Redord_ext a b c -> Sum (String -> String) ();
valida (Redord_ext valid less min_const more) = valid;

lessa :: forall a b c. Redord_ext a b c -> Term a b -> Term a b -> Bool;
lessa (Redord_ext valid less min_const more) = less;

check_FGCR_gj ::
  forall a.
    (Compare_order a, Eq a,
      Showl a) => Redord_ext a [Char] () ->
                    Redord_closure_ext a [Char] () ->
                      [(a, Nat)] ->
                        [(Term a [Char], Term a [Char])] ->
                          [(Term a [Char], Term a [Char])] ->
                            Sum (String -> String) ();
check_FGCR_gj ro rc f e r =
  bindb (valida ro)
    (\ _ ->
      bindb (validc rc)
        (\ _ ->
          bindb (catch_errora (check_subseteq (funas_trs_list (uniona e r)) f)
                  (\ x ->
                    Inl ((showsl_lit "the function symbol " . showsl_prod x) .
                          showsl_lit " does not occur in the TRS\n")))
            (\ _ ->
              check_ECPs_gj (lessa ro) (min_const ro) (\ a -> char_0x78 : a)
                (\ a -> char_0x79 : a) (ext_less rc) e r)));

check_FGCR_run_with_closure ::
  forall a.
    (Compare_order a, Eq a,
      Showl a) => Redord_ext a [Char] () ->
                    Redord_closure_ext a [Char] () ->
                      [(a, Nat)] ->
                        [(Term a [Char], Term a [Char])] ->
                          [(Term a [Char], Term a [Char])] ->
                            [(Term a [Char], Term a [Char])] ->
                              [(Term a [Char], Term a [Char])] ->
                                [Oc_irule a [Char]] ->
                                  Sum (String -> String) ();
check_FGCR_run_with_closure ro rc f e_0 r_0 e r steps =
  let {
    check_ord =
      (\ s t ->
        check (lessa ro s t) (showsl_lit "Term pair cannot be oriented."));
  } in bindb (catch_errora (forallM (\ (a, b) -> check_ord a b) r_0)
               (\ x -> Inl (snd x)))
         (\ _ ->
           bindb (catch_errora (check_oc check_ord (e_0, r_0) (e, r) steps)
                   (\ x ->
                     Inl (showsl_lit
                            "The oKB run could not be reconstructed.\n\n" .
                           x)))
             (\ _ ->
               catch_errora (check_FGCR_gj ro rc f e r)
                 (\ x ->
                   Inl (showsl_lit
                          "Ground confluence could not be verified.\n\n" .
                         x))));

order_set_of_permx ::
  forall a. (Ceq a, Ccompare a, Set_impl a) => [a] -> Set (a, a);
order_set_of_permx [] = bot_set;
order_set_of_permx (x : xs) =
  sup_set (set (map (\ a -> (x, a)) xs)) (order_set_of_permx xs);

term_order_of_permx ::
  forall a b c.
    (Ceq a, Ccompare a, Compare a, Eq a, Set_impl a, Compare b, Eq b, Compare c,
      Eq c) => [a] -> Set (Term b a, Term c a);
term_order_of_permx p =
  image (\ (x, y) -> (Var x, Var y)) (order_set_of_permx p);

fun_of_map_funa ::
  forall a b c. (a -> Maybe b) -> (a -> c) -> (b -> c) -> a -> c;
fun_of_map_funa m d f a = (case m a of {
                            Nothing -> d a;
                            Just aa -> f aa;
                          });

prec_weight_repr_to_prec_weight_funs ::
  forall a.
    (Compare_order a,
      Eq a) => ([((a, Nat), (Nat, (Nat, Maybe [Nat])))], Nat) ->
                 ((a, Nat) -> (a, Nat) -> (Bool, Bool),
                   ((a, Nat) -> Nat, (Nat, ([a], (a, Nat) -> Maybe [Nat]))));
prec_weight_repr_to_prec_weight_funs prw_w0 =
  (case prw_w0 of {
    (prw, w0) ->
      let {
        prwm = ceta_map_of prw;
        w_fun = fun_of_map_funa prwm (\ _ -> suc w0) (fst . snd);
        p_fun = prec_ext prwm;
        scf_fun = fun_of_map_funa prwm (\ _ -> Nothing) (snd . snd);
        fs = map fst prw;
        cs = filter
               (\ fn -> equal_nat (snd fn) zero_nat && equal_nat (w_fun fn) w0)
               fs;
        lcs = map_filter
                (\ x ->
                  (if all (\ c -> snd (p_fun c x)) cs then Just (fst x)
                    else Nothing))
                cs;
      } in (p_fun, (w_fun, (w0, (lcs, scf_fun))));
  });

scf_repr_to_scf ::
  forall a. ((a, Nat) -> Maybe [Nat]) -> (a, Nat) -> Nat -> Nat;
scf_repr_to_scf scf fn i = (case scf fn of {
                             Nothing -> one_nat;
                             Just xs -> nth xs i;
                           });

check_scf_entry ::
  forall a. (Showl a) => (a, Nat) -> Maybe [Nat] -> Sum (String -> String) ();
check_scf_entry fn Nothing = Inr ();
check_scf_entry (f, n) (Just es) =
  catch_errora
    (bindb
      (check (equal_nat (size_list es) n)
        (showsl_literal "nr of entries should be " . showsl_nat n))
      (\ _ ->
        check (all (less_nat zero_nat) es)
          (showsl_literal "all entries must be non-zero")))
    (\ x ->
      Inl ((((showsl_literal "problem with subterm coefficients for " .
               showsl_prod (f, n)) .
              showsl_literal ": ") .
             x) .
            showsl_literal "\n"));

prec_weight_repr_to_prec_weight ::
  forall a.
    (Compare_order a, Eq a,
      Showl a) => ([((a, Nat), (Nat, (Nat, Maybe [Nat])))], Nat) ->
                    (Sum (String -> String) (),
                      ((a, Nat) -> (a, Nat) -> (Bool, Bool),
                        ((a, Nat) -> Nat,
                          (Nat, ([a], (a, Nat) -> Nat -> Nat)))));
prec_weight_repr_to_prec_weight prw_w0 =
  (case prec_weight_repr_to_prec_weight_funs prw_w0 of {
    (p_fun, (w_fun, (_, (lcs, scf_fun)))) ->
      (case prw_w0 of {
        (prw, w0) ->
          let {
            fs = map fst prw;
            cw_okay =
              catch_errora
                (forallM
                  (\ fn ->
                    check (if equal_nat (snd fn) zero_nat
                            then less_eq_nat w0 (w_fun fn) else True)
                      ((showsl_literal "weight of constant " .
                         showsl (fst fn)) .
                        showsl_literal " must be at least w0"))
                  (map fst prw))
                (\ x -> Inl (snd x));
            adm = catch_errora
                    (forallM
                      (\ fn ->
                        check (if equal_nat (snd fn) one_nat
                                then (if equal_nat (w_fun fn) zero_nat
                                       then all (snd . p_fun fn) fs else True)
                                else True)
                          ((showsl_literal "unary symbol " . showsl (fst fn)) .
                            showsl_literal
                              " with weight 0 does not have maximal precedence"))
                      (map fst prw))
                    (\ x -> Inl (snd x));
            scf_ok =
              catch_errora
                (forallM (\ fn -> check_scf_entry fn (scf_fun fn))
                  (map fst prw))
                (\ x -> Inl (snd x));
            ok = bindb (check (less_nat zero_nat w0)
                         (showsl_literal "w0 must be larger than 0"))
                   (\ _ -> bindb adm (\ _ -> bindb cw_okay (\ _ -> scf_ok)));
          } in (ok, (p_fun, (w_fun, (w0, (lcs, scf_repr_to_scf scf_fun)))));
      });
  });

check_same_set :: forall a. (Eq a) => [a] -> [a] -> Sum a ();
check_same_set xs ys =
  bindb (check_subseteq xs ys) (\ _ -> check_subseteq ys xs);

create_KBO_redord ::
  forall a b.
    (Compare_order a, Eq a, Showl a,
      Eq b) => ([((a, Nat), (Nat, (Nat, Maybe [Nat])))], Nat) ->
                 [(a, Nat)] -> Redord_ext a b ();
create_KBO_redord pr fs =
  (case prec_weight_repr_to_prec_weight pr of {
    (ch, (p, (w, (w0, (lcs, scf))))) ->
      let {
        valid =
          bindb ch
            (\ _ ->
              bindb (catch_errora (check_same_set fs (map fst (fst pr)))
                      (\ _ ->
                        Inl (showsl_literal " signature does not match ")))
                (\ _ ->
                  bindb (check (less_nat zero_nat (size_list lcs))
                          (showsl_literal
                            "there must be a minimal constant with weight w0"))
                    (\ _ ->
                      check (distinct (map (fst . snd) (fst pr)))
                        (showsl_literal
                          "the given precedence is not injective"))));
      } in Redord_ext valid
             (\ s t -> fst (kbo_impl w w0 p (membera lcs) scf s t))
             (nth lcs zero_nat) ();
  });

kbo_closure ::
  forall a b.
    (Compare a, Eq a, Compare b,
      Eq b) => ((a, Nat) -> Nat) ->
                 Nat ->
                   ((a, Nat) -> Nat -> Nat) ->
                     (a -> Bool) ->
                       ((a, Nat) -> (a, Nat) -> Bool) ->
                         ((a, Nat) -> (a, Nat) -> Bool) ->
                           Set (Term a b, Term a b) ->
                             Term a b -> Term a b -> (Bool, Bool);
kbo_closure w w0 scf least pr_strict pr_weak gt s t =
  (if member (s, t) gt then (True, True)
    else (if subseteq_mset (vars_term_ms (scf_term scf t))
               (vars_term_ms (scf_term scf s)) &&
               less_eq_nat (weight w w0 scf t) (weight w w0 scf s)
           then (if less_nat (weight w w0 scf t) (weight w w0 scf s)
                  then (True, True)
                  else (case s of {
                         Var y -> (False, (case t of {
    Var x -> x == y;
    Fun g ts -> null ts && least g;
  }));
                         Fun f ss ->
                           (case t of {
                             Var _ -> (True, True);
                             Fun g ts ->
                               (if pr_strict (f, size_list ss) (g, size_list ts)
                                 then (True, True)
                                 else (if pr_weak (f, size_list ss)
    (g, size_list ts)
then lex_ext_unbounded (kbo_closure w w0 scf least pr_strict pr_weak gt) ss ts
else (False, False)));
                           });
                       }))
           else (False, False)));

create_KBO_redord_closure ::
  forall a.
    (Compare_order a, Eq a,
      Showl a) => ([((a, Nat), (Nat, (Nat, Maybe [Nat])))], Nat) ->
                    [(a, Nat)] -> Redord_closure_ext a [Char] ();
create_KBO_redord_closure pr fs =
  (case prec_weight_repr_to_prec_weight pr of {
    (_, (p, (w, (w0, (lcs, scf))))) ->
      let {
        ro = (create_KBO_redord ::
               ([((a, Nat), (Nat, (Nat, Maybe [Nat])))], Nat) ->
                 [(a, Nat)] -> Redord_ext a [Char] ())
               pr fs;
      } in Redord_closure_ext
             (\ vp s t ->
               fst (kbo_closure w w0 scf (membera lcs) (\ f g -> fst (p f g))
                     (\ f g -> snd (p f g)) (term_order_of_permx vp) s t))
             (valida ro) ();
  });

debug :: forall a. (String -> String) -> String -> a -> a;
debug i t x = x;

check_ordered_completion_proof_ext ::
  forall a.
    (Compare_order a, Eq a,
      Showl a) => (String -> String) ->
                    [(Term a [Char], Term a [Char])] ->
                      [(Term a [Char], Term a [Char])] ->
                        [(Term a [Char], Term a [Char])] ->
                          Reduction_order_input a ->
                            Ordered_completion_proof a [Char] ->
                              Sum (String -> String) ();
check_ordered_completion_proof_ext i e_0 e r ro (OKB steps) =
  debug i "OKB"
    (case ro of {
      RPO_Input _ -> Inl (showsl_lit "unsupported reduction order\n");
      KBO_Input precw ->
        let {
          f = map fst (fst precw);
        } in catch_errora
               (check_FGCR_run_with_closure (create_KBO_redord precw f)
                 (create_KBO_redord_closure precw f) f e_0 [] e r steps)
               (\ x ->
                 Inl ((i . showsl_lit
                             ": error in ground completeness proof with closure\n") .
                       x));
    });

precw_w0_sig :: forall a b c. ([(a, b)], c) -> [a];
precw_w0_sig precw_w0 = map fst (fst precw_w0);

rulesa :: forall a. (Eq a) => [(a, a)] -> [(a, a)] -> [(a, a)];
rulesa e r = uniona r (sym_list e);

check_ground_term ::
  forall a b. (Showl a, Showl b) => Term a b -> Sum (String -> String) ();
check_ground_term s =
  check (ground s)
    ((showsl_literal "the term " . showsl_terma s) .
      showsl_literal " is not a ground term\n");

check_equational_disproof_oc ::
  forall a.
    (Compare_order a, Eq a,
      Showl a) => (String -> String) ->
                    (Term a [Char], Term a [Char]) ->
                      [(Term a [Char], Term a [Char])] ->
                        [(Term a [Char], Term a [Char])] ->
                          [(Term a [Char], Term a [Char])] ->
                            Reduction_order_input a ->
                              Ordered_completion_proof a [Char] ->
                                Sum (String -> String) ();
check_equational_disproof_oc i eq e_0 e r ro p =
  (case ro of {
    RPO_Input _ -> Inl (showsl_lit "unsupported reduction order");
    KBO_Input precw ->
      bindb (check_ordered_completion_proof_ext i e_0 e r ro p)
        (\ _ ->
          let {
            roa = create_KBO_redord precw (precw_w0_sig precw);
          } in (case eq of {
                 (s, t) ->
                   bindb (catch_errora (check_ground_term s)
                           (\ _ ->
                             Inl (showsl_terma s .
                                   showsl_lit " is not a ground term\n")))
                     (\ _ ->
                       bindb (catch_errora (check_ground_term t)
                               (\ _ ->
                                 Inl (showsl_terma t .
                                       showsl_lit " is not a ground term\n")))
                         (\ _ ->
                           bindb (catch_errora
                                   (check_subseteq (funas_rule_list (s, t))
                                     (precw_w0_sig precw))
                                   (\ _ ->
                                     Inl (showsl_lit
   " goal is not over expected signature\n")))
                             (\ _ ->
                               bindb (catch_errora
                                       (check_subseteq
 (funas_trs_list (e_0 ++ e ++ r)) (precw_w0_sig precw))
                                       (\ _ ->
 Inl (showsl_lit " system is not over expected signature\n")))
                                 (\ _ ->
                                   let {
                                     nf = compute_mordstep_NF (lessa roa)
    (min_const roa) (rulesa e r);
                                   } in (case (nf s, nf t) of {
  (Nothing, _) ->
    Inl (((showsl_lit "error when computing normal forms of " .
            showsl_terma s) .
           showsl_lit " and ") .
          showsl_terma t);
  (Just _, Nothing) ->
    Inl (((showsl_lit "error when computing normal forms of " .
            showsl_terma s) .
           showsl_lit " and ") .
          showsl_terma t);
  (Just sa, Just ta) ->
    (if not (equal_term sa ta) then Inr ()
      else Inl ((((showsl_terma s . showsl_lit " and ") . showsl_terma t) .
                  showsl_lit " have same normal form ") .
                 showsl_terma sa));
})))));
               }));
  });

is_instance_rule ::
  forall a b.
    (Eq a, Ccompare b, Eq b,
      Mapping_impl b) => (Term a b, Term a b) -> (Term a b, Term a b) -> Bool;
is_instance_rule ra r =
  (case match_list Var [(fst r, fst ra), (snd r, snd ra)] of {
    Nothing -> False;
    Just _ -> True;
  });

check_subst_overapproximation ::
  forall a b.
    (Eq a, Showl a, Ccompare b, Eq b, Mapping_impl b,
      Showl b) => [(Term a b, Term a b)] ->
                    [(Term a b, Term a b)] -> Sum (String -> String) ();
check_subst_overapproximation ra r =
  catch_errora
    (catch_errora
      (forallM
        (\ raa ->
          catch_errora (existsM (\ rb -> check (is_instance_rule raa rb) id) r)
            (\ _ ->
              Inl ((showsl_lit "growing rule for " . showsl_rule raa) .
                    showsl_lit " is missing\n")))
        ra)
      (\ x -> Inl (snd x)))
    (\ x ->
      Inl ((((showsl_trs r . showsl_lit "\nis not an overapproximation of\n") .
              showsl_trs ra) .
             showsl_literal "\n") .
            x));

check_ground_completeness ::
  forall a.
    (Compare_order a, Eq a,
      Showl a) => (String -> String) ->
                    [(Term a [Char], Term a [Char])] ->
                      [(Term a [Char], Term a [Char])] ->
                        [(a, Nat)] ->
                          Reduction_order_input a -> Sum (String -> String) ();
check_ground_completeness i e r f ro =
  debug i "check ground completeness"
    (case ro of {
      RPO_Input _ -> Inl (showsl_lit "unsupported reduction order ");
      KBO_Input precw ->
        let {
          kbo = create_KBO_redord precw f;
        } in bindb (check (all (\ (a, b) -> lessa kbo a b) r)
                     (showsl_lit "found unorientable rule in R"))
               (\ _ ->
                 catch_errora
                   (check_FGCR_gj kbo (create_KBO_redord_closure precw f) f e r)
                   (\ x ->
                     Inl ((i . showsl_lit
                                 ": error in ground confluence proof \n") .
                           x)));
    });

check_equational_disproof_by_ground_complete_system ::
  forall a.
    (Compare_order a, Eq a,
      Showl a) => (String -> String) ->
                    (Term a [Char], Term a [Char]) ->
                      [(Term a [Char], Term a [Char])] ->
                        [(Term a [Char], Term a [Char])] ->
                          [(Term a [Char], Term a [Char])] ->
                            Reduction_order_input a ->
                              Sum (String -> String) ();
check_equational_disproof_by_ground_complete_system i eq e_0 e r ro =
  (case ro of {
    RPO_Input _ -> Inl (showsl_lit "unsupported reduction order");
    KBO_Input precw ->
      let {
        f = precw_w0_sig precw;
        kbo = create_KBO_redord precw f;
        _ = ext_less (create_KBO_redord_closure precw f);
      } in (case eq of {
             (s, t) ->
               bindb (catch_errora (check_ground_term s)
                       (\ _ ->
                         Inl (showsl_terma s .
                               showsl_lit " is not a ground term\n")))
                 (\ _ ->
                   bindb (catch_errora (check_ground_term t)
                           (\ _ ->
                             Inl (showsl_terma t .
                                   showsl_lit " is not a ground term\n")))
                     (\ _ ->
                       bindb (catch_errora
                               (check_subseteq (funas_rule_list (s, t)) f)
                               (\ _ ->
                                 Inl (showsl_lit
                                       " goal is not over expected signature\n")))
                         (\ _ ->
                           bindb (catch_errora
                                   (check_subseteq
                                     (funas_trs_list (e_0 ++ e ++ r)) f)
                                   (\ _ ->
                                     Inl (showsl_lit
   " system is not over expected signature\n")))
                             (\ _ ->
                               bindb (check_ground_completeness i e r f ro)
                                 (\ _ ->
                                   bindb (catch_errora
   (catch_errora
     (forallM
       (\ (a, b) -> check_instance_joinable (lessa kbo) (min_const kbo) e r a b)
       e_0)
     (\ x -> Inl (snd x)))
   (\ _ -> Inl (showsl_lit " E_0 is not subsumed by E and R\n")))
                                     (\ _ ->
                                       let {
 nf = compute_mordstep_NF (lessa kbo) (min_const kbo) (rulesa e r);
                                       } in
 (case (nf s, nf t) of {
   (Nothing, _) ->
     Inl (((showsl_lit "error when computing normal forms of " .
             showsl_terma s) .
            showsl_lit " and ") .
           showsl_terma t);
   (Just _, Nothing) ->
     Inl (((showsl_lit "error when computing normal forms of " .
             showsl_terma s) .
            showsl_lit " and ") .
           showsl_terma t);
   (Just sa, Just ta) ->
     (if not (equal_term sa ta) then Inr ()
       else Inl ((((showsl_terma s . showsl_lit " and ") . showsl_terma t) .
                   showsl_lit " have same normal form ") .
                  showsl_terma sa));
 })))))));
           });
  });

applicable_rule_impl ::
  forall a b. (Term a b -> Bool) -> (Term a b, Term a b) -> Bool;
applicable_rule_impl isNF = (\ (l, _) -> all isNF (args l));

check_non_applicable_rules ::
  forall a b.
    (Term a b -> Bool) -> [(Term a b, Term a b)] -> Sum (Term a b, Term a b) ();
check_non_applicable_rules isNF r =
  catch_errora
    (forallM
      (\ x -> (if not (applicable_rule_impl isNF x) then Inr () else Inl x)) r)
    (\ x -> Inl (snd x));

fun_of_map_fun :: forall a b. (a -> Maybe b) -> (a -> b) -> a -> b;
fun_of_map_fun m d a = (case m a of {
                         Nothing -> d a;
                         Just b -> b;
                       });

swap :: forall a b. (a, b) -> (b, a);
swap p = (snd p, fst p);

extract_renamings :: forall a. (Eq a) => [(a, a)] -> (a -> a, a -> a);
extract_renamings old_new =
  (fun_of_map_fun (map_of old_new) id,
    fun_of_map_fun (map_of (map swap old_new)) id);

extract_components ::
  forall a. (Eq a) => [(a, Nat)] -> [(a, a)] -> (a -> a, (a -> a, [a]));
extract_components mu old_new =
  (case extract_renamings old_new of {
    (d, da) ->
      let {
        c = map_filter
              (\ x ->
                (if (case x of {
                      (_, a) -> equal_nat a zero_nat;
                    })
                  then Just (fst x) else Nothing))
              mu;
        nu = map d c;
      } in (d, (da, nu));
  });

check_components ::
  forall a.
    (Eq a,
      Showl a) => [(a, Nat)] ->
                    (a -> a, (a -> a, [a])) -> Sum (String -> String) ();
check_components mu ddNU =
  (case ddNU of {
    (d, (da, nu)) ->
      bindb (catch_errora
              (forallM
                (\ f ->
                  bindb (check (not (membera mu (f, one_nat)))
                          ((showsl_lit "new unary symbol " . showsl f) .
                            showsl_lit " clashes with old symbol"))
                    (\ _ ->
                      bindb (check (d (da f) == f)
                              (showsl_lit
                                 "problem with bijection for renaming of " .
                                showsl f))
                        (\ _ ->
                          check (membera mu (da f, zero_nat))
                            (showsl_lit "problem with inverse renaming of " .
                              showsl f))))
                nu)
              (\ x -> Inl (snd x)))
        (\ _ ->
          catch_errora
            (forallM
              (\ (f, n) ->
                bindb (check (less_eq_nat n one_nat)
                        (showsl_lit "arity > 1 for symbol " . showsl f))
                  (\ _ ->
                    check (if equal_nat n zero_nat
                            then membera nu (d f) && da (d f) == f else True)
                      (showsl_lit
                         "problem with bijection for renaming of constant " .
                        showsl f)))
              mu)
            (\ x -> Inl (snd x)));
  });

str :: forall a b. (a -> a) -> b -> Term a b -> Term a b;
str d uu (Var x) = Var x;
str d x (Fun f [t]) = Fun f [str d x t];
str d x (Fun f []) = Fun (d f) [Var x];
str d x (Fun f (v : vb : vc)) = Fun (d f) [Var x];

choose_var :: forall a b. a -> Term b a -> a;
choose_var x l = hda (vars_term_list l ++ [x]);

check_varcond_subset ::
  forall a b.
    (Showl a, Eq b,
      Showl b) => [(Term a b, Term a b)] -> Sum (String -> String) ();
check_varcond_subset r =
  catch_errora
    (forallM
      (\ rule ->
        catch_errora
          (check_subseteq (insert_vars_term (snd rule) [])
            (insert_vars_term (fst rule) []))
          (\ x ->
            Inl ((((showsl_literal "free variable " . showsl x) .
                    showsl_literal " in right-hand side of rule ") .
                   showsl_rule rule) .
                  showsl_literal "\n")))
      r)
    (\ x -> Inl (snd x));

check_to_srs_sound ::
  forall a b.
    (Cenum a, Ceq a, Ccompare a, Eq a, Set_impl a, Showl a, Eq b,
      Showl b) => a -> [(b, b)] ->
                         [(Term b a, Term b a)] ->
                           [(Term b a, Term b a)] ->
                             [(Term b a, Term b a)] ->
                               [(Term b a, Term b a)] ->
                                 Sum (String -> String) ();
check_to_srs_sound v old_new r s rw sw =
  let {
    mu = funas_trs_list (r ++ rw);
  } in (case extract_components mu old_new of {
         (d, (da, nu)) ->
           bindb (check_components mu (d, (da, nu)))
             (\ _ ->
               bindb (check_varcond_subset r)
                 (\ _ ->
                   bindb (check_varcond_subset rw)
                     (\ _ ->
                       let {
                         checka =
                           (\ ra sa ->
                             catch_errora
                               (forallM
                                 (\ (l, rb) ->
                                   let {
                                     y = choose_var v l;
                                     stra = str d y;
                                     slr = (stra l, stra rb);
                                   } in check
  (less_eq_set (vars_term l) (inserta y bot_set) && membera sa slr)
  (showsl_lit "problem with new rule " . showsl_rule slr))
                                 ra)
                               (\ x -> Inl (snd x)));
                       } in bindb (checka r s) (\ _ -> checka rw sw))));
       });

rwc :: forall a b c d. Tp_ops_ext a b c d -> a -> [(Term b c, Term b c)];
rwc (Tp_ops_ext qreltrs q r rw rules q_empty is_QNF nFQ_subset_NF_rules
      rules_map delete_R_Rw split_rules mk nfs more)
  = rw;

rc :: forall a b c d. Tp_ops_ext a b c d -> a -> [(Term b c, Term b c)];
rc (Tp_ops_ext qreltrs q r rw rules q_empty is_QNF nFQ_subset_NF_rules rules_map
     delete_R_Rw split_rules mk nfs more)
  = r;

const_to_string_sound_tt ::
  forall a b c.
    (Eq a, Showl a, Cenum b, Ceq b, Ccompare b, Eq b, Set_impl b,
      Showl b) => Const_string_sound_proof a b ->
                    Tp_ops_ext c a b () -> c -> Sum (String -> String) c;
const_to_string_sound_tt (Const_string_sound_proof v old_new s) i tp =
  bindb (check_to_srs_sound v old_new (rc i tp) s (rwc i tp) [])
    (\ _ -> Inr (mkc i False [] s []));

nFQ_subset_NF_rulesc :: forall a b c d. Dpp_ops_ext a b c d -> a -> Bool;
nFQ_subset_NF_rulesc
  (Dpp_ops_ext dpp p pw pairs q r rw rules q_empty rules_no_left_var
    rules_non_collapsing is_QNF nFQ_subset_NF_rules rules_map reverse_rules_map
    intersect_pairs replace_pair intersect_rules delete_P_Pw delete_R_Rw
    split_pairs split_rules mk minimal nfs wwf_rules more)
  = nFQ_subset_NF_rules;

rule_match_impl_aux ::
  forall a.
    (Eq a) => (Term a [Char] -> Bool) ->
                [Term a [Char]] -> Term a [Char] -> Term a [Char] -> Bool;
rule_match_impl_aux nfq s fts l =
  (case mgu fts (map_term (\ x -> x) (\ a -> char_0x79 : a) l) of {
    Nothing -> False;
    Just mu ->
      all (\ u ->
            nfq (eval_term Fun (map_term (\ x -> x) (\ a -> char_0x79 : a) u)
                  mu))
        (args l) &&
        all (\ u -> nfq (eval_term Fun u mu)) s;
  });

is_ur_closed_term_af_impl ::
  forall a b c.
    (Compare a, Eq a, Ceq c,
      Ccompare c) => (Term a [Char] -> Bool) ->
                       (Term a b -> Term a (Sum () [Char])) ->
                         ((a, Nat) -> Set Nat) ->
                           [(Term a [Char], c)] ->
                             Set (Term a [Char], c) ->
                               [Term a [Char]] -> Term a b -> Bool;
is_ur_closed_term_af_impl nfq e_cap pi r u s (Var x) = True;
is_ur_closed_term_af_impl nfq e_cap pi r u s (Fun f ts) =
  let {
    n = size_list ts;
    pi_f = pi (f, n);
  } in all (\ (i, t) ->
             (if member i pi_f
               then is_ur_closed_term_af_impl nfq e_cap pi r u s t else True))
         (zip (upt zero_nat n) ts) &&
         let {
           fts = class_to_term char_0x7A (Fun f (map e_cap ts));
         } in all (\ (l, ra) ->
                    member (l, ra) u || not (rule_match_impl_aux nfq s fts l))
                r;

is_QNFc :: forall a b c d. Dpp_ops_ext a b c d -> a -> Term b c -> Bool;
is_QNFc
  (Dpp_ops_ext dpp p pw pairs q r rw rules q_empty rules_no_left_var
    rules_non_collapsing is_QNF nFQ_subset_NF_rules rules_map reverse_rules_map
    intersect_pairs replace_pair intersect_rules delete_P_Pw delete_R_Rw
    split_pairs split_rules mk minimal nfs wwf_rules more)
  = is_QNF;

rulesf :: forall a b c d. Dpp_ops_ext a b c d -> a -> [(Term b c, Term b c)];
rulesf
  (Dpp_ops_ext dpp p pw pairs q r rw rules q_empty rules_no_left_var
    rules_non_collapsing is_QNF nFQ_subset_NF_rules rules_map reverse_rules_map
    intersect_pairs replace_pair intersect_rules delete_P_Pw delete_R_Rw
    split_pairs split_rules mk minimal nfs wwf_rules more)
  = rules;

icap_impl_dpp ::
  forall a b.
    (Eq b) => Dpp_ops_ext a b [Char] () ->
                a -> [Term b [Char]] -> Term b [Char] -> Term b (Sum () [Char]);
icap_impl_dpp i d =
  let {
    qr = nFQ_subset_NF_rulesc i d;
    qnf = is_QNFc i d;
    r = rulesf i d;
    ic = icap_impl_gen qr qnf (map fst r);
  } in (\ s -> let {
                 a = ceta_set_of (concatMap vars_term_list s);
               } in ic s a);

is_ur_closed_af_impl_dpp_mv ::
  forall a b.
    (Compare_order b, Eq b,
      Showl b) => Dpp_ops_ext a b [Char] () ->
                    a -> ((b, Nat) -> Set Nat) ->
                           [(Term b [Char], Term b [Char])] ->
                             [Term b [Char]] -> Term b [Char] -> Bool;
is_ur_closed_af_impl_dpp_mv i d pi u =
  let {
    ic = icap_impl_dpp i d;
    qnf = is_QNFc i d;
    r = rulesf i d;
    urc = (\ s -> is_ur_closed_term_af_impl qnf (ic s) pi r (set u));
  } in (\ s ->
         let {
           sa = map (map_term (\ x -> x) (\ a -> char_0x78 : a)) s;
         } in (\ t ->
                urc sa sa (map_term (\ x -> x) (\ a -> char_0x78 : a) t)));

wwf_rulesa :: forall a b c d. Dpp_ops_ext a b c d -> a -> Bool;
wwf_rulesa
  (Dpp_ops_ext dpp p pw pairs q r rw rules q_empty rules_no_left_var
    rules_non_collapsing is_QNF nFQ_subset_NF_rules rules_map reverse_rules_map
    intersect_pairs replace_pair intersect_rules delete_P_Pw delete_R_Rw
    split_pairs split_rules mk minimal nfs wwf_rules more)
  = wwf_rules;

rules_mapc ::
  forall a b c d.
    Dpp_ops_ext a b c d -> a -> (b, Nat) -> [(Term b c, Term b c)];
rules_mapc
  (Dpp_ops_ext dpp p pw pairs q r rw rules q_empty rules_no_left_var
    rules_non_collapsing is_QNF nFQ_subset_NF_rules rules_map reverse_rules_map
    intersect_pairs replace_pair intersect_rules delete_P_Pw delete_R_Rw
    split_pairs split_rules mk minimal nfs wwf_rules more)
  = rules_map;

minimal :: forall a b c d. Dpp_ops_ext a b c d -> a -> Bool;
minimal
  (Dpp_ops_ext dpp p pw pairs q r rw rules q_empty rules_no_left_var
    rules_non_collapsing is_QNF nFQ_subset_NF_rules rules_map reverse_rules_map
    intersect_pairs replace_pair intersect_rules delete_P_Pw delete_R_Rw
    split_pairs split_rules mk minimal nfs wwf_rules more)
  = minimal;

q_emptyc :: forall a b c d. Dpp_ops_ext a b c d -> a -> Bool;
q_emptyc
  (Dpp_ops_ext dpp p pw pairs q r rw rules q_empty rules_no_left_var
    rules_non_collapsing is_QNF nFQ_subset_NF_rules rules_map reverse_rules_map
    intersect_pairs replace_pair intersect_rules delete_P_Pw delete_R_Rw
    split_pairs split_rules mk minimal nfs wwf_rules more)
  = q_empty;

matchCapRMBelow ::
  forall a b.
    (Eq a,
      Eq b) => ((a, Nat) -> [(Term a b, Term a b)]) ->
                 Term a b -> Term a b -> Bool;
matchCapRMBelow rm l (Fun f ts) = matchb (GCFun f (map (tcapRM2 rm) ts)) l;

forallM_index_aux ::
  forall a b. (a -> Nat -> Sum b ()) -> Nat -> [a] -> Sum ((a, Nat), b) ();
forallM_index_aux p i [] = Inr ();
forallM_index_aux p i (x : xs) =
  bindb (catch_errora (p x i) (\ xa -> Inl ((x, i), xa)))
    (\ _ -> forallM_index_aux p (suc i) xs);

forallM_index ::
  forall a b. (a -> Nat -> Sum b ()) -> [a] -> Sum ((a, Nat), b) ();
forallM_index p xs = forallM_index_aux p zero_nat xs;

check_ur_closed_term_rm_af ::
  forall a b.
    (Eq a, Showl a, Eq b,
      Showl b) => ((a, Nat) -> [(Term a b, Term a b)]) ->
                    [(Term a b, Term a b)] ->
                      ((a, Nat) -> Set Nat) ->
                        Term a b -> Sum (String -> String) ();
check_ur_closed_term_rm_af uu uv uw (Var x) = Inr ();
check_ur_closed_term_rm_af rm ur pi (Fun f ts) =
  let {
    n = size_list ts;
    pia = pi (f, n);
  } in bindb (catch_errora
               (forallM_index
                 (\ t i ->
                   (if member i pia then check_ur_closed_term_rm_af rm ur pi t
                     else Inr ()))
                 ts)
               (\ x -> Inl (snd x)))
         (\ _ ->
           catch_errora
             (forallM
               (\ lr ->
                 check (membera ur lr ||
                         not (matchCapRMBelow rm (fst lr) (Fun f ts)))
                   ((((showsl_lit "due to the subterm " .
                        showsl_terma (Fun f ts)) .
                       showsl_lit " of some usable rhs, rule ") .
                      showsl_rule lr) .
                     showsl_lit " should be usable."))
               (rm (f, n)))
             (\ x -> Inl (snd x)));

check_ur_P_closed_rm_af ::
  forall a b.
    (Eq a, Showl a, Eq b,
      Showl b) => ((a, Nat) -> [(Term a b, Term a b)]) ->
                    [(Term a b, Term a b)] ->
                      ((a, Nat) -> Set Nat) ->
                        [(Term a b, Term a b)] -> Sum (String -> String) ();
check_ur_P_closed_rm_af rm ur pi p =
  bindb (catch_errora
          (catch_errora
            (forallM (\ lr -> check_ur_closed_term_rm_af rm ur pi (snd lr)) ur)
            (\ x -> Inl (snd x)))
          (\ x ->
            Inl (showsl_lit
                   "error when checking closure properties of rhs of usable rules\n" .
                  x)))
    (\ _ ->
      catch_errora
        (catch_errora
          (forallM (\ st -> check_ur_closed_term_rm_af rm ur pi (snd st)) p)
          (\ x -> Inl (snd x)))
        (\ x ->
          Inl (showsl_lit
                 "error when checking closure properties of rhs of DPs\n" .
                x)));

nfsc :: forall a b c d. Dpp_ops_ext a b c d -> a -> Bool;
nfsc (Dpp_ops_ext dpp p pw pairs q r rw rules q_empty rules_no_left_var
       rules_non_collapsing is_QNF nFQ_subset_NF_rules rules_map
       reverse_rules_map intersect_pairs replace_pair intersect_rules
       delete_P_Pw delete_R_Rw split_pairs split_rules mk minimal nfs wwf_rules
       more)
  = nfs;

smart_usable_rules_checker_impl ::
  forall a b.
    (Compare_order b, Eq b,
      Showl b) => Dpp_ops_ext a b [Char] () ->
                    a -> Bool ->
                           ((b, Nat) -> Set Nat) ->
                             Maybe [(Term b [Char], Term b [Char])] ->
                               [(Term b [Char], Term b [Char])] ->
                                 Sum (String -> String)
                                   [(Term b [Char], Term b [Char])];
smart_usable_rules_checker_impl i d ce pi u_opt sts =
  let {
    nfs = nfsc i d;
    m = minimal i d;
    wwf = wwf_rulesa i d;
    qempty = q_emptyc i d;
  } in (case u_opt of {
         Nothing -> Inr (rulesf i d);
         Just u ->
           (if nFQ_subset_NF_rulesc i d &&
                 (nfs || isOK (check_varcond_subset sts)) && (nfs || (m || wwf))
             then let {
                    urc = is_ur_closed_af_impl_dpp_mv i d pi u;
                    check_urc =
                      (\ s t ->
                        check (urc s t)
                          ((showsl_lit "term " . showsl_terma t) .
                            showsl_lit " is not closed under usable rules"));
                  } in bindb (catch_errora
                               (forallM (\ (s, a) -> check_urc [s] a) sts)
                               (\ x -> Inl (snd x)))
                         (\ _ ->
                           bindb (catch_errora
                                   (forallM (\ (l, a) -> check_urc (args l) a)
                                     u)
                                   (\ x -> Inl (snd x)))
                             (\ _ -> Inr u))
             else bindb (check
                          (m && ce && (if nfs then qempty || wwf else True))
                          (showsl_lit
                            "minimality and ce-compatibility and well formedness required"))
                    (\ _ ->
                      bindb (catch_errora
                              (forallM
                                (\ (l, _) ->
                                  check (not (is_Var l))
                                    (showsl_lit
                                      "variables as lhss not allowed"))
                                (rulesf i d))
                              (\ x -> Inl (snd x)))
                        (\ _ ->
                          let {
                            rm = rules_mapc i d;
                          } in bindb (check_ur_P_closed_rm_af rm u pi sts)
                                 (\ _ -> Inr u))));
       });

root_aft_to_entry ::
  forall a b c. a -> Term b c -> ((b, Nat) -> Set Nat) -> [(a, Term b c)];
root_aft_to_entry s t pi =
  let {
    rt = the (root t);
    pi_t = pi rt;
    ts = args t;
  } in map_filter
         (\ x -> (if member x pi_t then Just (s, nth ts x) else Nothing))
         (upt zero_nat (snd rt));

check_no_defined_root ::
  forall a b.
    (Showl a,
      Showl b) => ((a, Nat) -> Bool) -> Term a b -> Sum (String -> String) ();
check_no_defined_root isdef t =
  check (not (isdef (the (root t))))
    ((showsl_literal "the root of " . showsl_terma t) .
      showsl_literal " is defined");

split_pairsa ::
  forall a b c d.
    Dpp_ops_ext a b c d ->
      a -> [(Term b c, Term b c)] ->
             ([(Term b c, Term b c)], [(Term b c, Term b c)]);
split_pairsa
  (Dpp_ops_ext dpp p pw pairs q r rw rules q_empty rules_no_left_var
    rules_non_collapsing is_QNF nFQ_subset_NF_rules rules_map reverse_rules_map
    intersect_pairs replace_pair intersect_rules delete_P_Pw delete_R_Rw
    split_pairs split_rules mk minimal nfs wwf_rules more)
  = split_pairs;

delete_P_Pwa ::
  forall a b c d.
    Dpp_ops_ext a b c d ->
      a -> [(Term b c, Term b c)] -> [(Term b c, Term b c)] -> a;
delete_P_Pwa
  (Dpp_ops_ext dpp p pw pairs q r rw rules q_empty rules_no_left_var
    rules_non_collapsing is_QNF nFQ_subset_NF_rules rules_map reverse_rules_map
    intersect_pairs replace_pair intersect_rules delete_P_Pw delete_R_Rw
    split_pairs split_rules mk minimal nfs wwf_rules more)
  = delete_P_Pw;

pairsb :: forall a b c d. Dpp_ops_ext a b c d -> a -> [(Term b c, Term b c)];
pairsb
  (Dpp_ops_ext dpp p pw pairs q r rw rules q_empty rules_no_left_var
    rules_non_collapsing is_QNF nFQ_subset_NF_rules rules_map reverse_rules_map
    intersect_pairs replace_pair intersect_rules delete_P_Pw delete_R_Rw
    split_pairs split_rules mk minimal nfs wwf_rules more)
  = pairs;

top_mono :: forall a b c. Rel_impl_ext a b c -> Sum (String -> String) ();
top_mono
  (Rel_impl_ext valid standard desc s ns nst af top_af sn subst_s ce_compat
    co_rewr top_mono top_refl mono_af mono not_wst not_sst cpx more)
  = top_mono;

sn :: forall a b c. Rel_impl_ext a b c -> Sum (String -> String) ();
sn (Rel_impl_ext valid standard desc s ns nst af top_af sn subst_s ce_compat
     co_rewr top_mono top_refl mono_af mono not_wst not_sst cpx more)
  = sn;

rel_impl_root_redtriple ::
  forall a b. Rel_impl_ext a b () -> Sum (String -> String) ();
rel_impl_root_redtriple ri =
  catch_errora
    (bindb (valid ri)
      (\ _ ->
        bindb (catch_errora (sn ri)
                (\ x ->
                  Inl (x . showsl_lit
                             "\nproblem in ensuring strong normalization of relation")))
          (\ _ ->
            bindb (catch_errora (subst_s ri)
                    (\ x ->
                      Inl (x . showsl_lit
                                 "\nproblem in ensuring stability of strict relation")))
              (\ _ ->
                catch_errora (top_mono ri)
                  (\ x ->
                    Inl (x . showsl_lit
                               "\nproblem in monotonicity from non-root to root"))))))
    (\ x ->
      Inl (showsl_lit "problem with being a root-reduction triple\n" . x));

ce_compat :: forall a b c. Rel_impl_ext a b c -> Sum (String -> String) ();
ce_compat
  (Rel_impl_ext valid standard desc s ns nst af top_af sn subst_s ce_compat
    co_rewr top_mono top_refl mono_af mono not_wst not_sst cpx more)
  = ce_compat;

top_af :: forall a b c. Rel_impl_ext a b c -> (a, Nat) -> Set Nat;
top_af
  (Rel_impl_ext valid standard desc s ns nst af top_af sn subst_s ce_compat
    co_rewr top_mono top_refl mono_af mono not_wst not_sst cpx more)
  = top_af;

desca :: forall a b c. Rel_impl_ext a b c -> String -> String;
desca (Rel_impl_ext valid standard desc s ns nst af top_af sn subst_s ce_compat
        co_rewr top_mono top_refl mono_af mono not_wst not_sst cpx more)
  = desc;

nst ::
  forall a b c.
    Rel_impl_ext a b c -> (Term a b, Term a b) -> Sum (String -> String) ();
nst (Rel_impl_ext valid standard desc s ns nst af top_af sn subst_s ce_compat
      co_rewr top_mono top_refl mono_af mono not_wst not_sst cpx more)
  = nst;

rel_impl_nst ::
  forall a b.
    Rel_impl_ext a b () -> [(Term a b, Term a b)] -> Sum (String -> String) ();
rel_impl_nst ri =
  (\ xs -> catch_errora (forallM (nst ri) xs) (\ x -> Inl (snd x)));

af :: forall a b c. Rel_impl_ext a b c -> (a, Nat) -> Set Nat;
af (Rel_impl_ext valid standard desc s ns nst af top_af sn subst_s ce_compat
     co_rewr top_mono top_refl mono_af mono not_wst not_sst cpx more)
  = af;

rel_impl_s ::
  forall a b.
    Rel_impl_ext a b () -> [(Term a b, Term a b)] -> Sum (String -> String) ();
rel_impl_s ri = (\ xs -> catch_errora (forallM (s ri) xs) (\ x -> Inl (snd x)));

check_no_var ::
  forall a b. (Showl a, Showl b) => Term a b -> Sum (String -> String) ();
check_no_var t = check (not (is_Var t)) (showsl_literal "variable found\n");

generic_ur_af_root_redtriple_proc ::
  forall a b.
    (Compare_order b, Eq b,
      Showl b) => Dpp_ops_ext a b [Char] () ->
                    Rel_impl_ext b [Char] () ->
                      Maybe [(Term b [Char], Term b [Char])] ->
                        [(Term b [Char], Term b [Char])] ->
                          a -> Sum (String -> String) a;
generic_ur_af_root_redtriple_proc i rp u_opt premove dpp =
  (case catch_errora
          (bindb (rel_impl_root_redtriple rp)
            (\ _ ->
              (case split_pairsa i dpp premove of {
                (ps, pns) ->
                  let {
                    p = pairsb i dpp;
                    pi = af rp;
                    pia = top_af rp;
                    is_def = (\ fn -> not (null (rules_mapc i dpp fn)));
                  } in bindb (catch_errora
                               (forallM
                                 (\ (l, r) ->
                                   bindb (check_no_var l)
                                     (\ _ ->
                                       bindb (check_no_var r)
 (\ _ -> check_no_defined_root is_def r)))
                                 p)
                               (\ x -> Inl (snd x)))
                         (\ _ ->
                           bindb (catch_errora
                                   (forallM (\ (l, _) -> check_no_var l)
                                     (rulesf i dpp))
                                   (\ x -> Inl (snd x)))
                             (\ _ ->
                               bindb (smart_usable_rules_checker_impl i dpp
                                       (isOK (ce_compat rp)) pi u_opt
                                       (concatMap
 (\ (s, t) -> root_aft_to_entry s t pia) p))
                                 (\ u ->
                                   bindb (catch_errora (rel_impl_ns rp u)
   (\ x -> Inl (showsl_lit "problem when orienting (usable) rules\n" . x)))
                                     (\ _ ->
                                       bindb
 (catch_errora (rel_impl_nst rp pns)
   (\ x -> Inl (showsl_lit "problem when orienting DPs\n" . x)))
 (\ _ ->
   catch_errora (rel_impl_s rp ps)
     (\ x -> Inl (showsl_lit "problem when orienting DPs\n" . x)))))));
              })))
          (\ x ->
            Inl (((showsl_lit
                     "could not apply the generic root reduction pair processor with the following\n" .
                    desca rp) .
                   showsl_literal "\n") .
                  x))
    of {
    Inl a -> Inl a;
    Inr _ -> Inr (delete_P_Pwa i dpp premove premove);
  });

top_refl :: forall a b c. Rel_impl_ext a b c -> Sum (String -> String) ();
top_refl
  (Rel_impl_ext valid standard desc s ns nst af top_af sn subst_s ce_compat
    co_rewr top_mono top_refl mono_af mono not_wst not_sst cpx more)
  = top_refl;

standard :: forall a b c. Rel_impl_ext a b c -> Sum (String -> String) ();
standard
  (Rel_impl_ext valid standard desc s ns nst af top_af sn subst_s ce_compat
    co_rewr top_mono top_refl mono_af mono not_wst not_sst cpx more)
  = standard;

rel_impl_redtriple ::
  forall a b. Rel_impl_ext a b () -> Sum (String -> String) ();
rel_impl_redtriple ri =
  catch_errora
    (bindb (valid ri)
      (\ _ ->
        bindb (standard ri)
          (\ _ ->
            bindb (catch_errora (top_refl ri)
                    (\ x ->
                      Inl (x . showsl_lit
                                 "\nproblem in ensuring reflexivity of top-non-strict relation")))
              (\ _ ->
                bindb (catch_errora (sn ri)
                        (\ x ->
                          Inl (x . showsl_lit
                                     "\nproblem in ensuring strong normalization of relation")))
                  (\ _ ->
                    catch_errora (subst_s ri)
                      (\ x ->
                        Inl (x . showsl_lit
                                   "\nproblem in ensuring stability of strict relation")))))))
    (\ x -> Inl (showsl_lit "problem with being a reduction triple\n" . x));

generic_ur_af_redtriple_proc ::
  forall a b.
    (Compare_order b, Eq b,
      Showl b) => Dpp_ops_ext a b [Char] () ->
                    Rel_impl_ext b [Char] () ->
                      Maybe [(Term b [Char], Term b [Char])] ->
                        [(Term b [Char], Term b [Char])] ->
                          a -> Sum (String -> String) a;
generic_ur_af_redtriple_proc i rp u_opt premove dpp =
  (case catch_errora
          (bindb (rel_impl_redtriple rp)
            (\ _ ->
              (case split_pairsa i dpp premove of {
                (ps, pns) ->
                  let {
                    p = pairsb i dpp;
                  } in bindb (smart_usable_rules_checker_impl i dpp
                               (isOK (ce_compat rp)) (af rp) u_opt p)
                         (\ u ->
                           bindb (catch_errora (rel_impl_ns rp u)
                                   (\ x ->
                                     Inl (showsl_lit
    "problem when orienting (usable) rules\n" .
   x)))
                             (\ _ ->
                               bindb (catch_errora (rel_impl_nst rp pns)
                                       (\ x ->
 Inl (showsl_lit "problem when orienting DPs\n" . x)))
                                 (\ _ ->
                                   catch_errora (rel_impl_s rp ps)
                                     (\ x ->
                                       Inl
 (showsl_lit "problem when orienting DPs\n" . x)))));
              })))
          (\ x ->
            Inl (((showsl_lit
                     "could not apply the generic reduction pair processor with the following\n" .
                    desca rp) .
                   showsl_literal "\n") .
                  x))
    of {
    Inl a -> Inl a;
    Inr _ -> Inr (delete_P_Pwa i dpp premove premove);
  });

delete_R_Rwc ::
  forall a b c d.
    Dpp_ops_ext a b c d ->
      a -> [(Term b c, Term b c)] -> [(Term b c, Term b c)] -> a;
delete_R_Rwc
  (Dpp_ops_ext dpp p pw pairs q r rw rules q_empty rules_no_left_var
    rules_non_collapsing is_QNF nFQ_subset_NF_rules rules_map reverse_rules_map
    intersect_pairs replace_pair intersect_rules delete_P_Pw delete_R_Rw
    split_pairs split_rules mk minimal nfs wwf_rules more)
  = delete_R_Rw;

is_ur_closed_term_impl ::
  forall a b c.
    (Compare a, Eq a, Ceq c,
      Ccompare c) => (Term a [Char] -> Bool) ->
                       (Term a b -> Term a (Sum () [Char])) ->
                         [(Term a [Char], c)] ->
                           Set (Term a [Char], c) ->
                             [Term a [Char]] -> Term a b -> Bool;
is_ur_closed_term_impl nfq e_cap r u s (Var x) = True;
is_ur_closed_term_impl nfq e_cap r u s (Fun f ts) =
  all (is_ur_closed_term_impl nfq e_cap r u s) ts &&
    let {
      fts = class_to_term char_0x7A (Fun f (map e_cap ts));
    } in all (\ (l, ra) ->
               member (l, ra) u || not (rule_match_impl_aux nfq s fts l))
           r;

is_ur_closed_impl_dpp_mv ::
  forall a b.
    (Compare_order b, Eq b,
      Showl b) => Dpp_ops_ext a b [Char] () ->
                    a -> [(Term b [Char], Term b [Char])] ->
                           [Term b [Char]] -> Term b [Char] -> Bool;
is_ur_closed_impl_dpp_mv i d u =
  let {
    ic = icap_impl_dpp i d;
    qnf = is_QNFc i d;
    r = rulesf i d;
    urc = (\ s -> is_ur_closed_term_impl qnf (ic s) r (set u));
  } in (\ s ->
         let {
           sa = map (map_term (\ x -> x) (\ a -> char_0x78 : a)) s;
         } in (\ t ->
                urc sa sa (map_term (\ x -> x) (\ a -> char_0x78 : a) t)));

intersect_rulesb ::
  forall a b c d. Dpp_ops_ext a b c d -> a -> [(Term b c, Term b c)] -> a;
intersect_rulesb
  (Dpp_ops_ext dpp p pw pairs q r rw rules q_empty rules_no_left_var
    rules_non_collapsing is_QNF nFQ_subset_NF_rules rules_map reverse_rules_map
    intersect_pairs replace_pair intersect_rules delete_P_Pw delete_R_Rw
    split_pairs split_rules mk minimal nfs wwf_rules more)
  = intersect_rules;

usable_rules_proc ::
  forall a b.
    (Compare_order b, Eq b,
      Showl b) => Dpp_ops_ext a b [Char] () ->
                    [(Term b [Char], Term b [Char])] ->
                      a -> Sum (String -> String) a;
usable_rules_proc i u dpp =
  (case bindb (check (nFQ_subset_NF_rulesc i dpp)
                (showsl_lit "innermost rewriting required"))
          (\ _ ->
            bindb (check (nfsc i dpp || (minimal i dpp || wwf_rulesa i dpp))
                    (showsl_lit
                      "normal form subst, minimality or well-formedness required"))
              (\ _ ->
                let {
                  p = pairsb i dpp;
                  urc = is_ur_closed_impl_dpp_mv i dpp u;
                  check_urc =
                    (\ s t ->
                      check (urc s t)
                        ((showsl_lit "term " . showsl_terma t) .
                          showsl_lit " is not closed under usable rules"));
                  nfs = nfsc i dpp;
                } in bindb (catch_errora
                             (forallM
                               (\ (l, r) ->
                                 bindb (if nfs then Inr ()
 else catch_errora (check_subseteq (vars_term_list r) (vars_term_list l))
        (\ _ -> Inl (showsl_lit "variable condition in P violated")))
                                   (\ _ -> check_urc [l] r))
                               p)
                             (\ x -> Inl (snd x)))
                       (\ _ ->
                         catch_errora
                           (forallM (\ (l, a) -> check_urc (args l) a) u)
                           (\ x -> Inl (snd x)))))
    of {
    Inl a -> Inl a;
    Inr _ -> Inr (intersect_rulesb i dpp u);
  });

mono ::
  forall a b c. Rel_impl_ext a b c -> [(a, Nat)] -> Sum (String -> String) ();
mono (Rel_impl_ext valid standard desc s ns nst af top_af sn subst_s ce_compat
       co_rewr top_mono top_refl mono_af mono not_wst not_sst cpx more)
  = mono;

rel_impl_mono_ce_redpair ::
  forall a b.
    Rel_impl_ext a b () ->
      [(Term a b, Term a b)] ->
        [(Term a b, Term a b)] -> Sum (String -> String) ();
rel_impl_mono_ce_redpair ri s ns =
  catch_errora
    (bindb (valid ri)
      (\ _ ->
        bindb (standard ri)
          (\ _ ->
            bindb (catch_errora (sn ri)
                    (\ x ->
                      Inl (x . showsl_lit
                                 "\nproblem in ensuring strong normalization of relation")))
              (\ _ ->
                bindb (catch_errora (subst_s ri)
                        (\ x ->
                          Inl (x . showsl_lit
                                     "\nproblem in ensuring stability of strict relation")))
                  (\ _ ->
                    bindb (catch_errora (ce_compat ri)
                            (\ x ->
                              Inl (x . showsl_lit
 "\nproblem in ensuring ce-compatibility")))
                      (\ _ ->
                        catch_errora (mono ri (funas_trs_list (s ++ ns)))
                          (\ x ->
                            Inl (x . showsl_lit
                                       "\nproblem in ensuring monotonicity of strict relation"))))))))
    (\ x ->
      Inl (showsl_lit
             "problem with being a ce-compatible monotone reduction pair\n" .
            x));

mono_inn_usable_rules_ce_proc ::
  forall a b.
    (Ceq b, Ccompare b, Compare_order b, Eq b, Set_impl b,
      Showl b) => Dpp_ops_ext a b [Char] () ->
                    Rel_impl_ext b [Char] () ->
                      [(Term b [Char], Term b [Char])] ->
                        [(Term b [Char], Term b [Char])] ->
                          [(Term b [Char], Term b [Char])] ->
                            a -> Sum (String -> String) a;
mono_inn_usable_rules_ce_proc i rp premove rrem ur dpp =
  let {
    r = rulesf i dpp;
    ura = set ur;
    non_ur = filter (\ ra -> not (member ra ura)) r;
    rremove = non_ur ++ rrem;
  } in (case catch_errora
               (bindb (usable_rules_proc i ur dpp)
                 (\ _ ->
                   let {
                     p = pairsb i dpp;
                     us = foldr (sup_set . funas_term . snd) (p ++ ur) bot_set;
                     filt =
                       (\ lr ->
                         ball (funas_term (fst lr)) (\ f -> member f us));
                   } in (case split_pairsa i dpp premove of {
                          (pms, pns) ->
                            (case partition filt pms of {
                              (ps, pnwf) ->
                                (case partition (membera rremove) ur of {
                                  (urms, urns) ->
                                    (case partition filt urms of {
                                      (urs, urnwf) ->
bindb (rel_impl_mono_ce_redpair rp (ps ++ urs) (urns ++ urnwf ++ pns ++ pnwf))
  (\ _ ->
    bindb (catch_errora (rel_impl_ns rp (urns ++ urnwf))
            (\ x ->
              Inl (showsl_lit "problem when orienting usable rules\n" . x)))
      (\ _ ->
        bindb (catch_errora (rel_impl_s rp urs)
                (\ x ->
                  Inl (showsl_lit "problem when orienting usable rules\n" . x)))
          (\ _ ->
            bindb (catch_errora (rel_impl_ns rp (pns ++ pnwf))
                    (\ x ->
                      Inl (showsl_lit "problem when orienting DPs\n" . x)))
              (\ _ ->
                catch_errora (rel_impl_s rp ps)
                  (\ x ->
                    Inl (showsl_lit "problem when orienting DPs\n" . x))))));
                                    });
                                });
                            });
                        })))
               (\ x ->
                 Inl (((showsl_lit
                          "could not apply the innermost usable rules reduction pair processor with the following\n" .
                         desca rp) .
                        showsl_literal "\n") .
                       x))
         of {
         Inl a -> Inl a;
         Inr _ ->
           Inr (delete_R_Rwc i (delete_P_Pwa i dpp premove premove) rremove
                 rremove);
       });

mono_ur_redpair_proc ::
  forall a b c.
    (Ceq b, Ccompare b, Compare b, Eq b, Set_impl b, Showl b, Compare c, Eq c,
      Showl c) => Dpp_ops_ext a b c () ->
                    Rel_impl_ext b c () ->
                      [(Term b c, Term b c)] ->
                        [(Term b c, Term b c)] ->
                          [(Term b c, Term b c)] ->
                            a -> Sum (String -> String) a;
mono_ur_redpair_proc i rp premove rrem ur dpp =
  let {
    r = rulesf i dpp;
    ura = set ur;
    non_ur = filter (\ ra -> not (member ra ura)) r;
    rremove = non_ur ++ rrem;
  } in (case catch_errora
               (bindb (check (minimal i dpp) (showsl_lit "minimality required"))
                 (\ _ ->
                   bindb (check
                           (if nfsc i dpp
                             then (if not (q_emptyc i dpp) then wwf_rulesa i dpp
                                    else True)
                             else True)
                           (showsl_lit "well formedness required"))
                     (\ _ ->
                       let {
                         p = pairsb i dpp;
                         us = foldr (sup_set . funas_term . snd) (p ++ ur)
                                bot_set;
                         rr = set rremove;
                         filt =
                           (\ lr ->
                             ball (funas_term (fst lr)) (\ f -> member f us));
                       } in (case split_pairsa i dpp premove of {
                              (pms, pns) ->
                                (case partition filt pms of {
                                  (ps, pnwf) ->
                                    (case partition (\ u -> member u rr) ur of {
                                      (urms, urns) ->
(case partition filt urms of {
  (urs, urnwf) ->
    let {
      rm = rules_mapc i dpp;
    } in bindb (rel_impl_mono_ce_redpair rp (ps ++ urs)
                 (urns ++ urnwf ++ pns ++ pnwf))
           (\ _ ->
             bindb (check_ur_P_closed_rm_af rm ur full_af p)
               (\ _ ->
                 bindb (catch_errora
                         (forallM
                           (\ (l, _) ->
                             check (not (is_Var l))
                               (showsl_lit "variables as lhss not allowed"))
                           (rulesf i dpp))
                         (\ x -> Inl (snd x)))
                   (\ _ ->
                     bindb (catch_errora (rel_impl_ns rp (urns ++ urnwf))
                             (\ x ->
                               Inl (showsl_lit
                                      "problem when orienting usable rules\n" .
                                     x)))
                       (\ _ ->
                         bindb (catch_errora (rel_impl_s rp urs)
                                 (\ x ->
                                   Inl (showsl_lit
  "problem when orienting usable rules\n" .
 x)))
                           (\ _ ->
                             bindb (catch_errora (rel_impl_ns rp (pns ++ pnwf))
                                     (\ x ->
                                       Inl
 (showsl_lit "problem when orienting DPs\n" . x)))
                               (\ _ ->
                                 catch_errora (rel_impl_s rp ps)
                                   (\ x ->
                                     Inl (showsl_lit
    "problem when orienting DPs\n" .
   x))))))));
});
                                    });
                                });
                            }))))
               (\ x ->
                 Inl (((showsl_lit
                          "could not apply the monotonic reduction pair processor with the following\n" .
                         desca rp) .
                        showsl_literal "\n") .
                       x))
         of {
         Inl a -> Inl a;
         Inr _ ->
           Inr (delete_R_Rwc i (delete_P_Pwa i dpp premove premove) rremove
                 rremove);
       });

generic_mono_ur_redpair_proc ::
  forall a b.
    (Ceq b, Ccompare b, Compare_order b, Eq b, Set_impl b,
      Showl b) => Dpp_ops_ext a b [Char] () ->
                    Rel_impl_ext b [Char] () ->
                      [(Term b [Char], Term b [Char])] ->
                        [(Term b [Char], Term b [Char])] ->
                          [(Term b [Char], Term b [Char])] ->
                            a -> Sum (String -> String) a;
generic_mono_ur_redpair_proc i rp premove rremove ur dpp =
  (if nFQ_subset_NF_rulesc i dpp
    then mono_inn_usable_rules_ce_proc i rp premove rremove ur dpp
    else bindb (check (minimal i dpp)
                 (showsl_lit
                   "minimality or innermost required for mon. red. pair proc. with usable rules"))
           (\ _ -> mono_ur_redpair_proc i rp premove rremove ur dpp));

compat_roota :: forall a b. (Eq a) => Term a b -> Maybe (a, Nat) -> Bool;
compat_roota uu Nothing = False;
compat_roota (Var uv) (Just v) = False;
compat_roota (Fun va vb) (Just v) = root (Fun va vb) == Just v;

usable_rules_gen2 ::
  forall a b.
    (Eq a) => [(Term a b, Term a b)] ->
                (Maybe (a, Nat), Bool) -> [(Term a b, Term a b)];
usable_rules_gen2 r (fn, b) =
  let {
    rr = concatMap (\ (l, ra) -> (if compat_roota l fn then [(l, ra)] else []))
           r;
  } in (if b then rr else map (\ (l, ra) -> (ra, l)) rr);

rel_dep_prod :: Bool -> Dependance -> [Bool];
rel_dep_prod uu Ignore = [];
rel_dep_prod b Increase = [b];
rel_dep_prod b Decrease = [not b];
rel_dep_prod uv Wild = [True, False];

compat_root :: forall a b c. (Eq a) => Term a b -> Term a c -> Bool;
compat_root uu (Var uv) = False;
compat_root (Var uw) (Fun v va) = False;
compat_root (Fun vb vc) (Fun v va) = root (Fun vb vc) == root (Fun v va);

usable_rules_gen1 ::
  forall a b.
    (Eq a) => ((a, Nat) -> Nat -> Dependance) ->
                [(Term a b, Term a b)] ->
                  (Term a b, Bool) -> [(Term a b, Bool)];
usable_rules_gen1 pi r (Var uu, uv) = [];
usable_rules_gen1 pi r (Fun f ts, b) =
  let {
    n = size_list ts;
  } in concatMap
         (\ (l, ra) -> (if compat_root l (Fun f ts) then [(ra, b)] else []))
         r ++
         concatMap
           (\ i -> map (\ a -> (nth ts i, a)) (rel_dep_prod b (pi (f, n) i)))
           (upt zero_nat n);

mk_rtrancl_list_main ::
  forall a. (a -> a -> Bool) -> (a -> [a]) -> [a] -> [a] -> [a];
mk_rtrancl_list_main subsumes r todo fin =
  (case todo of {
    [] -> fin;
    a : tod ->
      (if any (\ b -> subsumes b a) fin
        then mk_rtrancl_list_main subsumes r tod fin
        else mk_rtrancl_list_main subsumes r (r a ++ tod) (a : fin));
  });

mk_rtrancl_list :: forall a. (a -> a -> Bool) -> (a -> [a]) -> [a] -> [a];
mk_rtrancl_list subsumes r init = mk_rtrancl_list_main subsumes r init [];

usable_rules_gen ::
  forall a b.
    (Eq a,
      Eq b) => ((a, Nat) -> Nat -> Dependance) ->
                 [(Term a b, Term a b)] ->
                   [(Term a b, Term a b)] -> [(Term a b, Term a b)];
usable_rules_gen pi r p =
  concatMap (usable_rules_gen2 r)
    (remdups
      (map (\ (t, a) -> (root t, a))
        (mk_rtrancl_list (\ a b -> a == b) (usable_rules_gen1 pi r)
          (map (\ (_, t) -> (t, True)) p))));

generate_lists :: forall a. Nat -> [a] -> [[a]];
generate_lists n xs = concat_lists (map (\ _ -> xs) (upt zero_nat n));

initial_conditions_gen_impl ::
  forall a. (a -> a -> Bool) -> Nat -> Nat -> [a] -> a -> [[a]];
initial_conditions_gen_impl pa bef_len aft_len p st =
  let {
    pairs = (\ n -> generate_lists n p);
    a = concatMap (\ bef -> map (\ aft -> bef ++ st : aft) (pairs aft_len))
          (pairs bef_len);
  } in filter
         (\ bef_st_aft ->
           let {
             d = minus_nat (plus_nat bef_len aft_len) one_nat;
           } in (if less_nat d (plus_nat bef_len aft_len)
                  then all_interval
                         (\ i -> pa (nth bef_st_aft i) (nth bef_st_aft (suc i)))
                         zero_nat d
                  else True))
         a;

is_partition_impl ::
  forall a.
    (Card_UNIV a, Ceq a, Cproper_interval a,
      Set_impl a) => [Set a] -> Maybe (Set a);
is_partition_impl [] = Just bot_set;
is_partition_impl (asa : rest) =
  bind (is_partition_impl rest)
    (\ alla ->
      (if is_empty (inf_set asa alla) then Just (sup_set alla asa)
        else Nothing));

is_partition ::
  forall a.
    (Card_UNIV a, Ceq a, Cproper_interval a, Set_impl a) => [Set a] -> Bool;
is_partition asa = not (is_none (is_partition_impl asa));

disjoint_variant ::
  forall a b.
    (Eq a, Card_UNIV b, Ceq b, Cproper_interval b, Eq b, Mapping_impl b,
      Set_impl b) => [(Term a b, Term a b)] -> [(Term a b, Term a b)] -> Bool;
disjoint_variant sts uvs =
  equal_nat (size_list sts) (size_list uvs) &&
    let {
      d = minus_nat (size_list sts) one_nat;
    } in (if less_nat d (size_list sts)
           then all_interval (\ i -> eq_rule_mod_vars (nth sts i) (nth uvs i))
                  zero_nat d
           else True) &&
      is_partition (map vars_rule uvs);

condition_of ::
  forall a b.
    a -> Condition_type -> (Term a b, Term a b) -> Cond_constraint a b;
condition_of c Bound (s, uu) = CC_cond False (s, Fun c []);
condition_of c Strict st = CC_cond True st;
condition_of c Non_Strict st = CC_cond False st;

constraint_of ::
  forall a b.
    a -> Condition_type -> [(Term a b, Term a b)] -> Nat -> Cond_constraint a b;
constraint_of c ctype uvs bef =
  CC_impl
    (map (\ i -> CC_rewr (snd (nth uvs i)) (fst (nth uvs (suc i))))
      (upt zero_nat (minus_nat (size_list uvs) one_nat)))
    (condition_of c ctype (nth uvs bef));

the_set_impl_main_lazy ::
  forall a b.
    (Ceq a, Ccompare a, Set_impl a,
      Eq b) => (a -> [b]) -> (b -> [a]) -> [a] -> Set a -> [b] -> [a];
the_set_impl_main_lazy q gen_as have_asa have_as bs =
  let {
    new_as =
      concatMap
        (\ b ->
          concatMap (\ a -> (if not (member a have_as) then [a] else []))
            (gen_as b))
        bs;
  } in (if null new_as then have_asa
         else the_set_impl_main_lazy q gen_as (new_as ++ have_asa)
                (sup_set (set new_as) have_as) (remdups (concatMap q new_as)));

the_set_impl_lazy ::
  forall a b.
    (Ceq a, Ccompare a, Set_impl a,
      Eq b) => (a -> [b]) -> (b -> [a]) -> [b] -> [a];
the_set_impl_lazy q gen_as bs = the_set_impl_main_lazy q gen_as [] bot_set bs;

inductive_set_impl_lazy ::
  forall a b.
    (Eq a, Ceq b, Ccompare b,
      Set_impl b) => (a -> [b]) -> (b -> [a]) -> [a] -> [b];
inductive_set_impl_lazy q p = the_set_impl_lazy p q;

rule_match_impl ::
  forall a b.
    (Eq a) => (Term a [Char] -> Bool) ->
                (b -> Term a (Sum () [Char])) ->
                  [Term a [Char]] -> a -> [b] -> Term a [Char] -> Bool;
rule_match_impl nfq e_cap s f ts l =
  (case mgu_class (Fun f (map e_cap ts)) l of {
    Nothing -> False;
    Just mu ->
      all (\ u ->
            nfq (eval_term Fun (map_term (\ x -> x) (\ a -> char_0x79 : a) u)
                  mu))
        (args l) &&
        all (\ u -> nfq (eval_term Fun u mu)) s;
  });

ur_term_impl ::
  forall a b c.
    (Eq a,
      Eq c) => (Term a [Char] -> Bool) ->
                 (Term a b -> Term a (Sum () [Char])) ->
                   [(Term a [Char], c)] ->
                     ((a, Nat) -> Set Nat) ->
                       [Term a [Char]] -> Term a b -> [(Term a [Char], c)];
ur_term_impl nfq e_cap r pi s (Var x) = [];
ur_term_impl nfq e_cap r pi s (Fun f ts) =
  let {
    n = size_list ts;
    rec = map (ur_term_impl nfq e_cap r pi s) ts;
  } in remdups
         (concatMap (\ (i, urs) -> (if member i (pi (f, n)) then urs else []))
            (zip (upt zero_nat n) rec) ++
           filter (\ (l, _) -> rule_match_impl nfq e_cap s f ts l) r);

precompute_fun :: forall a b. (Compare_order a) => (a -> b) -> [a] -> a -> b;
precompute_fun f asa =
  fun_of_map_fun (ceta_map_of (map (\ a -> (a, f a)) asa)) f;

usable_rules_calc_impl ::
  forall a.
    (Compare_order a,
      Eq a) => (Term a [Char] -> Bool) ->
                 ([Term a [Char]] -> Term a [Char] -> Term a (Sum () [Char])) ->
                   [(Term a [Char], Term a [Char])] ->
                     [([Term a [Char]], Term a [Char])] ->
                       [(Term a [Char], Term a [Char])];
usable_rules_calc_impl nfq e_cap r =
  let {
    urt = (\ (s, t) ->
            let {
              sa = map (map_term (\ x -> x) (\ a -> char_0x78 : a)) s;
            } in ur_term_impl nfq (e_cap sa) r full_af sa
                   (map_term (\ x -> x) (\ a -> char_0x78 : a) t));
    urules = map (\ (l, a) -> (args l, a)) r;
    ufun = precompute_fun urt urules;
  } in inductive_set_impl_lazy ufun (\ (l, ra) -> [(args l, ra)]);

ur_calc_singleton ::
  forall a.
    (Compare_order a,
      Eq a) => (Term a [Char] -> Bool) ->
                 ([Term a [Char]] -> Term a [Char] -> Term a (Sum () [Char])) ->
                   [(Term a [Char], Term a [Char])] ->
                     ([Term a [Char]], Term a [Char]) ->
                       [(Term a [Char], Term a [Char])];
ur_calc_singleton nfq e_cap r st = usable_rules_calc_impl nfq e_cap r [st];

inn_usable_rules_pair ::
  forall a b.
    (Compare_order b,
      Eq b) => Dpp_ops_ext a b [Char] () ->
                 a -> (Term b [Char], Term b [Char]) ->
                        [(Term b [Char], Term b [Char])];
inn_usable_rules_pair i d =
  let {
    inn = nFQ_subset_NF_rulesc i d;
    r = rulesf i d;
    qnf = is_QNFc i d;
    ic = icap_impl_dpp i d;
    calc = ur_calc_singleton qnf ic r;
    nfs = nfsc i d;
    wwf = wwf_rulesa i d;
    m = minimal i d;
  } in (\ (s, t) ->
         (if inn &&
               (nfs || less_eq_set (vars_term t) (vars_term s)) &&
                 (nfs || (m || wwf))
           then calc ([s], t) else r));

icap_impl_dpp_mv ::
  forall a b.
    (Eq b) => Dpp_ops_ext a b [Char] () ->
                a -> [Term b [Char]] -> Term b [Char] -> Term b (Sum () [Char]);
icap_impl_dpp_mv i d =
  let {
    qr = nFQ_subset_NF_rulesc i d;
    qnf = is_QNFc i d;
    r = rulesf i d;
    ic = icap_impl_gen qr qnf (map fst r);
  } in (\ s ->
         let {
           sa = map (map_term (\ x -> x) (\ a -> char_0x78 : a)) s;
           sx = ceta_set_of (concatMap vars_term_list sa);
         } in (\ t -> ic sa sx (map_term (\ x -> x) (\ a -> char_0x78 : a) t)));

reverse_rules :: forall a b. [(Term a b, Term a b)] -> [(Term a b, Term a b)];
reverse_rules rs = map swap rs;

is_iedg_edge_dpp ::
  forall a b.
    (Compare_order b, Eq b,
      Showl b) => Dpp_ops_ext a b [Char] () ->
                    a -> (Term b [Char], Term b [Char]) ->
                           Term b [Char] -> Bool;
is_iedg_edge_dpp i d =
  let {
    qnf = is_QNFc i d;
    ic = icap_impl_dpp_mv i d;
    _ = rulesf i d;
    urules = inn_usable_rules_pair i d;
  } in (\ (s, t) ->
         let {
           cst = ic [s] t;
           urls = reverse_rules (urules (s, t));
           ica = icap_impl (is_NF_terms []) urls;
         } in (\ u ->
                (case mgu_class cst u of {
                  Nothing -> False;
                  Just mu ->
                    qnf (eval_term Fun
                          (map_term (\ x -> x) (\ a -> char_0x78 : a) s) mu) &&
                      qnf (eval_term Fun
                            (map_term (\ x -> x) (\ a -> char_0x79 : a) u) mu);
                }) &&
                  let {
                    cu = ica [] u;
                  } in (case mgu_class cu t of {
                         Nothing -> False;
                         Just mu ->
                           qnf (eval_term Fun
                                 (map_term (\ x -> x) (\ a -> char_0x79 : a) s)
                                 mu);
                       })));

deep_normalize_cca :: forall a b. Cond_constraint a b -> Cond_constraint a b;
deep_normalize_cca (CC_impl [] c) = deep_normalize_cca c;
deep_normalize_cca (CC_impl (v : va) c) =
  CC_impl (map deep_normalize_cca (v : va)) (deep_normalize_cca c);
deep_normalize_cca (CC_cond s c) = CC_cond s c;
deep_normalize_cca (CC_all s c) = CC_all s (deep_normalize_cca c);
deep_normalize_cca (CC_rewr s c) = CC_rewr s c;

vars_cc_list :: forall a b. (Eq b) => Cond_constraint a b -> [b];
vars_cc_list (CC_cond ct (s, t)) = vars_term_list s ++ vars_term_list t;
vars_cc_list (CC_rewr s t) = vars_term_list s ++ vars_term_list t;
vars_cc_list (CC_impl c1 c2) = concatMap vars_cc_list c1 ++ vars_cc_list c2;
vars_cc_list (CC_all x c) =
  concatMap (\ y -> (if not (y == x) then [y] else [])) (vars_cc_list c);

cc_subst_apply ::
  forall a b.
    (Eq a) => ([a] -> a) ->
                Cond_constraint b a ->
                  (a -> Term b a, [a]) -> Cond_constraint b a;
cc_subst_apply fresh (CC_cond ct (s, t)) (sigma, uu) =
  CC_cond ct (eval_term Fun s sigma, eval_term Fun t sigma);
cc_subst_apply fresh (CC_rewr s t) (sigma, uv) =
  CC_rewr (eval_term Fun s sigma) (eval_term Fun t sigma);
cc_subst_apply fresh (CC_impl c1 c2) sigma =
  CC_impl (map (\ c -> cc_subst_apply fresh c sigma) c1)
    (cc_subst_apply fresh c2 sigma);
cc_subst_apply fresh (CC_all x c) (sigma, vs) =
  let {
    y = fresh (vs ++ vars_cc_list (CC_all x c));
  } in CC_all y (cc_subst_apply fresh c (fun_upd sigma x (Var y), y : vs));

normalize_alpha ::
  forall a b.
    (Eq a) => ([a] -> a) -> Cond_constraint b a -> Cond_constraint b a;
normalize_alpha fresh c = cc_subst_apply fresh c (Var, []);

deep_normalize_cc ::
  forall a b.
    (Eq a) => ([a] -> a) -> Cond_constraint b a -> Cond_constraint b a;
deep_normalize_cc fresh c = normalize_alpha fresh (deep_normalize_cca c);

check_subsumesa ::
  forall a b.
    (Eq a, Eq b) => Cond_constraint a b -> Cond_constraint a b -> Bool;
check_subsumesa (CC_impl cs c) (CC_impl ds d) =
  check_subsumesa c d &&
    all (\ ca -> any (\ da -> check_subsumesa da ca) ds) cs;
check_subsumesa (CC_cond v va) (CC_impl ds d) =
  check_subsumesa (CC_cond v va) d;
check_subsumesa (CC_rewr v va) (CC_impl ds d) =
  check_subsumesa (CC_rewr v va) d;
check_subsumesa (CC_all v va) (CC_impl ds d) = check_subsumesa (CC_all v va) d;
check_subsumesa (CC_all x c) (CC_all y d) = x == y && check_subsumesa c d;
check_subsumesa (CC_cond v va) (CC_cond vb vc) =
  equal_cond_constraint (CC_cond v va) (CC_cond vb vc);
check_subsumesa (CC_cond v va) (CC_rewr vb vc) =
  equal_cond_constraint (CC_cond v va) (CC_rewr vb vc);
check_subsumesa (CC_cond v va) (CC_all vb vc) =
  equal_cond_constraint (CC_cond v va) (CC_all vb vc);
check_subsumesa (CC_rewr v va) (CC_cond vb vc) =
  equal_cond_constraint (CC_rewr v va) (CC_cond vb vc);
check_subsumesa (CC_rewr v va) (CC_rewr vb vc) =
  equal_cond_constraint (CC_rewr v va) (CC_rewr vb vc);
check_subsumesa (CC_rewr v va) (CC_all vb vc) =
  equal_cond_constraint (CC_rewr v va) (CC_all vb vc);
check_subsumesa (CC_all v va) (CC_cond vb vc) =
  equal_cond_constraint (CC_all v va) (CC_cond vb vc);
check_subsumesa (CC_all v va) (CC_rewr vb vc) =
  equal_cond_constraint (CC_all v va) (CC_rewr vb vc);
check_subsumesa c (CC_cond v va) = equal_cond_constraint c (CC_cond v va);
check_subsumesa c (CC_rewr v va) = equal_cond_constraint c (CC_rewr v va);
check_subsumesa (CC_impl vb vc) (CC_all v va) =
  equal_cond_constraint (CC_impl vb vc) (CC_all v va);

check_subsumes ::
  forall a b.
    (Eq a,
      Eq b) => ([a] -> a) -> Cond_constraint b a -> Cond_constraint b a -> Bool;
check_subsumes fresh c d = let {
                             n = deep_normalize_cc fresh;
                           } in check_subsumesa (n c) (n d);

showsl_rules ::
  forall a b. (Showl a, Showl b) => [(Term a b, Term a b)] -> String -> String;
showsl_rules = showsl_rulesa showsl showsl " -> ";

check_constraint_present ::
  forall a b.
    (Compare_order b, Eq b,
      Showl b) => Dpp_ops_ext a b [Char] () ->
                    a -> b -> [(Term b [Char], Term b [Char])] ->
                                Nat ->
                                  Nat ->
                                    [(Cond_constraint b [Char],
                                       [(Term b [Char], Term b [Char])])] ->
                                      Condition_type ->
(Term b [Char], Term b [Char]) -> Sum (String -> String) ();
check_constraint_present i dpp constant p bef aft ccs =
  let {
    edg = is_iedg_edge_dpp i dpp;
    init_conds =
      initial_conditions_gen_impl (\ st uv -> edg st (fst uv)) bef aft p;
  } in (\ ct st ->
         catch_errora
           (forallM
             (\ sts ->
               check (any (\ (c, uvs) ->
                            disjoint_variant sts uvs &&
                              check_subsumes
                                (fresh_string [char_0x78, char_0x78]) c
                                (constraint_of constant ct uvs bef))
                       ccs)
                 (((showsl_lit "did not find " .
                     showsl_lit (case ct of {
                                  Bound -> "bound";
                                  Strict -> "strict";
                                  Non_Strict -> "non-strict";
                                })) .
                    showsl_lit " constraint for sequence ") .
                   showsl_rules sts))
             (init_conds st))
           (\ x -> Inl (snd x)));

map_actxt :: forall a b c d. (a -> b) -> (c -> d) -> Actxt a c -> Actxt b d;
map_actxt f1 f2 Hole = Hole;
map_actxt f1 f2 (More x21 x22 x23 x24) =
  More (f1 x21) (map f2 x22) (map_actxt f1 f2 x23) (map f2 x24);

critical_pairs_impl ::
  forall a b.
    (Infinite a, Eq a,
      Eq b) => Renaming2 a ->
                 [(Term b a, Term b a)] ->
                   [(Term b a, Term b a)] -> [(Bool, (Term b a, Term b a))];
critical_pairs_impl ren p r =
  concatMap
    (\ (l, ra) ->
      concatMap
        (\ pa ->
          let {
            c = ctxt_of_pos_term pa l;
            la = subt_at l pa;
            b = equal_actxt c Hole;
          } in (if is_Var la then []
                 else concatMap
                        (\ (laa, rb) ->
                          (case mgu_vd ren la laa of {
                            Nothing -> [];
                            Just (sigma, tau) ->
                              [(b, (intp_actxt Fun
                                      (map_actxt (\ x -> x)
(\ t -> eval_term Fun t sigma) c)
                                      (eval_term Fun rb tau),
                                     eval_term Fun ra sigma))];
                          }))
                        r))
        (poss_list l))
    p;

check_left_linear_trs ::
  forall a b.
    (Showl a, Ceq b, Ccompare b, Set_impl b,
      Showl b) => [(Term a b, Term a b)] -> Sum (String -> String) ();
check_left_linear_trs trs =
  catch_errora
    (catch_errora
      (forallM (\ x -> (if linear_term (fst x) then Inr () else Inl x)) trs)
      (\ x -> Inl (snd x)))
    (\ _ -> Inl (showsl_trs trs . showsl_literal "\nis not left-linear\n"));

check_weakly_orthogonal ::
  forall a b.
    (Ceq a, Ccompare a, Infinite a, Eq a, Set_impl a, Showl a, Eq b,
      Showl b) => Renaming2 a ->
                    [(Term b a, Term b a)] -> Sum (String -> String) ();
check_weakly_orthogonal ren r =
  catch_errora
    (bindb (check_left_linear_trs r)
      (\ _ ->
        bindb (catch_errora
                (forallM
                  (\ (l, _) ->
                    check (not (is_Var l))
                      (showsl_lit "the TRS has variables as left-hand sides"))
                  r)
                (\ x -> Inl (snd x)))
          (\ _ ->
            catch_errora
              (forallM
                (\ (_, (s, t)) ->
                  check (equal_term s t)
                    (((showsl_lit "there is a non-trivial critical pair: " .
                        showsl_terma s) .
                       showsl_lit " <- . -> ") .
                      showsl_terma t))
                (critical_pairs_impl ren r r))
              (\ x -> Inl (snd x)))))
    (\ x ->
      Inl ((x . showsl_lit
                  "\nhence, the following TRS is not weakly orthogonal\n") .
            showsl_trs r));

validb :: forall a b c. Non_inf_order_ext a b c -> Sum (String -> String) ();
validb (Non_inf_order_ext valid ns cc af desc more) = valid;

qc :: forall a b c d. Dpp_ops_ext a b c d -> a -> [Term b c];
qc (Dpp_ops_ext dpp p pw pairs q r rw rules q_empty rules_no_left_var
     rules_non_collapsing is_QNF nFQ_subset_NF_rules rules_map reverse_rules_map
     intersect_pairs replace_pair intersect_rules delete_P_Pw delete_R_Rw
     split_pairs split_rules mk minimal nfs wwf_rules more)
  = q;

descb :: forall a b c. Non_inf_order_ext a b c -> String -> String;
descb (Non_inf_order_ext valid ns cc af desc more) = desc;

nsa ::
  forall a b c.
    Non_inf_order_ext a b c ->
      (Term a b, Term a b) -> Sum (String -> String) ();
nsa (Non_inf_order_ext valid ns cc af desc more) = ns;

cc :: forall a b c.
        Non_inf_order_ext a b c ->
          C_constraint a b -> Sum (String -> String) ();
cc (Non_inf_order_ext valid ns cc af desc more) = cc;

afa :: forall a b c. Non_inf_order_ext a b c -> (a, Nat) -> Nat -> Dependance;
afa (Non_inf_order_ext valid ns cc af desc more) = af;

range_vars_impl :: forall a b. (Eq a, Eq b) => [(a, Term b a)] -> [a];
range_vars_impl sigma = let {
                          a = mk_subst_domain sigma;
                        } in concatMap (vars_term_list . snd) a;

cc_bound :: forall a b. [a] -> Cond_constraint b a -> Cond_constraint b a;
cc_bound [] c = c;
cc_bound (x : xs) c = CC_all x (cc_bound xs c);

cc_ih_prems ::
  forall a b.
    (Eq a,
      Eq b) => ([a] -> a) ->
                 b -> Term b a ->
                        [a] ->
                          [Cond_constraint b a] ->
                            Cond_constraint b a ->
                              [(Term b a, [a])] -> [Cond_constraint b a];
cc_ih_prems fresh f q xs phi psi rs_ys_list =
  map (\ (r, ys) ->
        let {
          rs = args r;
          mu = mk_subst Var (zip xs rs);
          vs = range_vars_impl (zip xs rs);
          mua = (\ c -> cc_subst_apply fresh c (mu, vs));
          a = CC_impl (CC_rewr r (eval_term Fun q mu) : map mua phi) (mua psi);
        } in cc_bound ys a)
    rs_ys_list;

cc_rule_constraint ::
  forall a b.
    (Eq a,
      Eq b) => ([a] -> a) ->
                 b -> [Term b a] ->
                        Term b a ->
                          Term b a ->
                            [a] ->
                              [Cond_constraint b a] ->
                                Cond_constraint b a ->
                                  [(Term b a, [a])] -> Cond_constraint b a;
cc_rule_constraint fresh f ls r q xs phi psi rs_ys_list =
  let {
    sigma = mk_subst Var (zip xs ls);
    vs = range_vars_impl (zip xs ls);
    rew = CC_rewr r (eval_term Fun q sigma);
    phi_sig = map (\ c -> cc_subst_apply fresh c (sigma, vs)) phi;
    psi_sig = cc_subst_apply fresh psi (sigma, vs);
    ihs = cc_ih_prems fresh f q xs phi psi rs_ys_list;
  } in CC_impl (rew : phi_sig ++ ihs) psi_sig;

cc_unbound :: forall a b. Cond_constraint a b -> ([b], Cond_constraint a b);
cc_unbound (CC_all x c) = (case cc_unbound c of {
                            (xs, a) -> (x : xs, a);
                          });
cc_unbound (CC_cond v va) = ([], CC_cond v va);
cc_unbound (CC_rewr v va) = ([], CC_rewr v va);
cc_unbound (CC_impl v va) = ([], CC_impl v va);

showsl_cc_aux ::
  forall a b.
    (Showl a, Showl b) => Bool -> Cond_constraint a b -> String -> String;
showsl_cc_aux b (CC_rewr s t) =
  (showsl_terma s . showsl_lit " = ") . showsl_terma t;
showsl_cc_aux b (CC_cond stri (s, t)) =
  (showsl_terma s . showsl_lit (if stri then " > " else " >= ")) .
    showsl_terma t;
showsl_cc_aux b (CC_all x c) =
  let {
    s = ((showsl_lit "ALL " . showsl x) . showsl_lit ". ") .
          showsl_cc_aux False c;
  } in (if b then (showsl_lit "(" . s) . showsl_lit ")" else s);
showsl_cc_aux b (CC_impl cs c2) =
  (((showsl_lit "(" .
      showsl_list_gen id "True" "" " and " "" (map (showsl_cc_aux True) cs)) .
     showsl_lit " => ") .
    showsl_cc_aux True c2) .
    showsl_lit ")";

showsl_cc ::
  forall a b. (Showl a, Showl b) => Cond_constraint a b -> String -> String;
showsl_cc = showsl_cc_aux False;

funas_term_list :: forall a b. Term a b -> [(a, Nat)];
funas_term_list (Var uu) = [];
funas_term_list (Fun f ts) = (f, size_list ts) : concatMap funas_term_list ts;

funas_args_term_list :: forall a b. Term a b -> [(a, Nat)];
funas_args_term_list t = concatMap funas_term_list (args t);

check_disjoint :: forall a. (Eq a) => [a] -> [a] -> Sum a ();
check_disjoint xs ys =
  catch_errora
    (forallM (\ x -> (if not (membera ys x) then Inr () else Inl x)) xs)
    (\ x -> Inl (snd x));

check_rys ::
  forall a b.
    (Eq a, Showl a, Eq b,
      Showl b) => ((a, Nat) -> Bool) ->
                    Maybe (a, Nat) ->
                      Term a b -> (Term a b, [b]) -> Sum (String -> String) ();
check_rys d rt r rys =
  (case rys of {
    (ra, ys) ->
      bindb (check (root ra == rt)
              (((showsl_lit "root of " . showsl_terma ra) .
                 showsl_lit " is not ") .
                showsl_prod (the rt)))
        (\ _ ->
          bindb (check (equal_term r ra || supt_impl r ra)
                  ((showsl_terma ra . showsl_lit " is not a subterm of ") .
                    showsl_terma r))
            (\ _ ->
              bindb (catch_errora
                      (forallM
                        (\ f ->
                          check (not (d f))
                            ((((showsl_lit "the defined symbol " .
                                 showsl_prod f) .
                                showsl_lit " occurs in the subterm ") .
                               showsl_terma ra) .
                              showsl_lit " of the rhs"))
                        (funas_args_term_list ra))
                      (\ x -> Inl (snd x)))
                (\ _ ->
                  catch_errora (check_disjoint ys (vars_term_list r))
                    (\ x ->
                      Inl ((showsl x . showsl_lit " occurs in ") .
                            showsl_terma r)))));
  });

prems_of :: forall a b. Cond_constraint a b -> [Cond_constraint a b];
prems_of (CC_impl c1 c2) = c1;
prems_of (CC_cond v va) = [];
prems_of (CC_rewr v va) = [];
prems_of (CC_all v va) = [];

concl_of :: forall a b. Cond_constraint a b -> Cond_constraint a b;
concl_of (CC_impl c1 c2) = c2;
concl_of (CC_cond v va) = CC_cond v va;
concl_of (CC_rewr v va) = CC_rewr v va;
concl_of (CC_all v va) = CC_all v va;

normalize_cc :: forall a b. Cond_constraint a b -> Cond_constraint a b;
normalize_cc c = CC_impl (prems_of c) (concl_of c);

check_cc_prf ::
  forall a.
    (Ceq a, Ccompare a, Eq a, Set_impl a,
      Showl a) => [(Term a [Char], Term a [Char])] ->
                    ((a, Nat) -> Bool) ->
                      [(a, Nat)] ->
                        Bool ->
                          Cond_constraint a [Char] ->
                            Cond_constraint_prf a [Char] ->
                              Sum (String -> String) [C_constraint a [Char]];
check_cc_prf r d f m_ortho cc Final =
  (case normalize_cc cc of {
    CC_cond _ _ ->
      Inl (showsl_lit
             "problem in final constraint: it is neither a condition nor an implification of two conditions, but it is\n" .
            showsl_cc cc);
    CC_rewr _ _ ->
      Inl (showsl_lit
             "problem in final constraint: it is neither a condition nor an implification of two conditions, but it is\n" .
            showsl_cc cc);
    CC_impl [] (CC_cond stri st) -> Inr [Unconditional_C stri st];
    CC_impl [] (CC_rewr _ _) ->
      Inl (showsl_lit
             "problem in final constraint: it is neither a condition nor an implification of two conditions, but it is\n" .
            showsl_cc cc);
    CC_impl [] (CC_impl _ _) ->
      Inl (showsl_lit
             "problem in final constraint: it is neither a condition nor an implification of two conditions, but it is\n" .
            showsl_cc cc);
    CC_impl [] (CC_all _ _) ->
      Inl (showsl_lit
             "problem in final constraint: it is neither a condition nor an implification of two conditions, but it is\n" .
            showsl_cc cc);
    CC_impl [CC_cond stri uv] (CC_cond stria st) ->
      (if stri == stria then Inr [Conditional_C stri uv st]
        else Inl (showsl_lit
                    "problem in final constraint: different relations for finalizing " .
                   showsl_cc cc));
    CC_impl [CC_cond _ _] (CC_rewr _ _) ->
      Inl (showsl_lit
             "problem in final constraint: it is neither a condition nor an implification of two conditions, but it is\n" .
            showsl_cc cc);
    CC_impl [CC_cond _ _] (CC_impl _ _) ->
      Inl (showsl_lit
             "problem in final constraint: it is neither a condition nor an implification of two conditions, but it is\n" .
            showsl_cc cc);
    CC_impl [CC_cond _ _] (CC_all _ _) ->
      Inl (showsl_lit
             "problem in final constraint: it is neither a condition nor an implification of two conditions, but it is\n" .
            showsl_cc cc);
    CC_impl (CC_cond _ _ : _ : _) _ ->
      Inl (showsl_lit
             "problem in final constraint: it is neither a condition nor an implification of two conditions, but it is\n" .
            showsl_cc cc);
    CC_impl (CC_rewr _ _ : _) _ ->
      Inl (showsl_lit
             "problem in final constraint: it is neither a condition nor an implification of two conditions, but it is\n" .
            showsl_cc cc);
    CC_impl (CC_impl _ _ : _) _ ->
      Inl (showsl_lit
             "problem in final constraint: it is neither a condition nor an implification of two conditions, but it is\n" .
            showsl_cc cc);
    CC_impl (CC_all _ _ : _) _ ->
      Inl (showsl_lit
             "problem in final constraint: it is neither a condition nor an implification of two conditions, but it is\n" .
            showsl_cc cc);
    CC_all _ _ ->
      Inl (showsl_lit
             "problem in final constraint: it is neither a condition nor an implification of two conditions, but it is\n" .
            showsl_cc cc);
  });
check_cc_prf r da f m_ortho c (Delete_Condition d prf) =
  bindb (check (check_subsumes (fresh_string [char_0x78, char_0x78]) d c)
          (((showsl_lit "problem in delete conditions when switching from\n" .
              showsl_cc c) .
             showsl_lit " to\n") .
            showsl_cc d))
    (\ _ -> check_cc_prf r da f m_ortho d prf);
check_cc_prf r da f m_ortho c (Different_Constructor d) =
  (case normalize_cc c of {
    CC_impl cs _ ->
      catch_errora
        (bindb
          (check (membera cs d)
            ((showsl_cc d . showsl_lit "\nis not a premise of ") . showsl_cc c))
          (\ _ ->
            (case d of {
              CC_cond _ _ ->
                Inl (showsl_cc d .
                      showsl_lit
                        " is not a rewrite condition of the correct shape");
              CC_rewr (Var _) _ ->
                Inl (showsl_cc d .
                      showsl_lit
                        " is not a rewrite condition of the correct shape");
              CC_rewr (Fun _ _) (Var _) ->
                Inl (showsl_cc d .
                      showsl_lit
                        " is not a rewrite condition of the correct shape");
              CC_rewr (Fun fa ss) (Fun g ts) ->
                bindb (check (not (da (fa, size_list ss)))
                        (showsl fa . showsl_lit " is defined"))
                  (\ _ ->
                    bindb (check (not ((fa, size_list ss) == (g, size_list ts)))
                            ((showsl_lit "the root " . showsl fa) .
                              showsl_lit " is identical on both sides"))
                      (\ _ -> Inr []));
              CC_impl _ _ ->
                Inl (showsl_cc d .
                      showsl_lit
                        " is not a rewrite condition of the correct shape");
              CC_all _ _ ->
                Inl (showsl_cc d .
                      showsl_lit
                        " is not a rewrite condition of the correct shape");
            })))
        (\ x ->
          Inl (((((showsl_lit
                     "problem in Different Constructor with rewrite condition " .
                    showsl_cc d) .
                   showsl_lit "\non input constraint\n") .
                  showsl_cc c) .
                 showsl_literal "\n") .
                x));
  });
check_cc_prf r da f m_ortho ca (Same_Constructor d c p) =
  (case normalize_cc ca of {
    CC_impl cs con ->
      bindb (catch_errora
              (bindb
                (check (membera cs d)
                  ((showsl_cc d . showsl_lit "\nis not a premise of ") .
                    showsl_cc ca))
                (\ _ ->
                  (case d of {
                    CC_cond _ _ ->
                      Inl (showsl_cc d .
                            showsl_lit
                              " is not a rewrite condition of the correct shape");
                    CC_rewr (Var _) _ ->
                      Inl (showsl_cc d .
                            showsl_lit
                              " is not a rewrite condition of the correct shape");
                    CC_rewr (Fun _ _) (Var _) ->
                      Inl (showsl_cc d .
                            showsl_lit
                              " is not a rewrite condition of the correct shape");
                    CC_rewr (Fun fa ss) (Fun g ts) ->
                      bindb (check (not (da (fa, size_list ss)))
                              (showsl fa . showsl_lit " is defined"))
                        (\ _ ->
                          bindb (check ((fa, size_list ss) == (g, size_list ts))
                                  (((showsl fa . showsl_lit " and ") .
                                     showsl g) .
                                    showsl_lit " are not identical"))
                            (\ _ ->
                              let {
                                ds = cs ++ map (\ (a, b) -> CC_rewr a b)
     (zip ss ts);
                                db = CC_impl ds con;
                              } in check (check_subsumes
   (fresh_string [char_0x78, char_0x78]) c db)
                                     (((showsl_lit "new constraint is " .
 showsl_cc c) .
showsl_lit "\nbut expected was ") .
                                       showsl_cc db)));
                    CC_impl _ _ ->
                      Inl (showsl_cc d .
                            showsl_lit
                              " is not a rewrite condition of the correct shape");
                    CC_all _ _ ->
                      Inl (showsl_cc d .
                            showsl_lit
                              " is not a rewrite condition of the correct shape");
                  })))
              (\ x ->
                Inl (((((((showsl_lit
                             "problem in Same Constructor with rewrite condition " .
                            showsl_cc d) .
                           showsl_lit "\n when switching from\n") .
                          showsl_cc ca) .
                         showsl_lit " to\n") .
                        showsl_cc c) .
                       showsl_literal "\n") .
                      x)))
        (\ _ -> check_cc_prf r da f m_ortho c p);
  });
check_cc_prf r da f m_ortho c (Variable_Equation x t d p) =
  (case normalize_cc c of {
    CC_impl cs _ ->
      bindb (catch_errora
              (bindb
                (check
                  (membera cs (CC_rewr (Var x) t) ||
                    membera cs (CC_rewr t (Var x)) &&
                      ball (funas_term t) (\ fa -> not (da fa)))
                  (((showsl_lit "could not find " .
                      showsl_cc (CC_rewr (Var x) t)) .
                     showsl_lit " or reversed as a premise of\n") .
                    showsl_cc c))
                (\ _ ->
                  let {
                    ca = cc_subst_apply (fresh_string [char_0x78, char_0x78]) c
                           (fun_upd Var x t, vars_term_list t);
                  } in check (check_subsumes
                               (fresh_string [char_0x78, char_0x78]) d ca)
                         (((showsl_lit "new constraint is " . showsl_cc d) .
                            showsl_lit "\nbut expected was ") .
                           showsl_cc ca)))
              (\ xa ->
                Inl (((((((((showsl_lit
                               "problem in Variable Equation with substitution " .
                              showsl_lista x) .
                             showsl_lit "/") .
                            showsl_terma t) .
                           showsl_lit " to switch from\n") .
                          showsl_cc c) .
                         showsl_lit "\nto\n") .
                        showsl_cc d) .
                       showsl_literal "\n") .
                      xa)))
        (\ _ -> check_cc_prf r da f m_ortho d p);
  });
check_cc_prf r da f m_ortho ca (Funarg_Into_Var c i x d p) =
  (case normalize_cc ca of {
    CC_impl cs con ->
      bindb (catch_errora
              (bindb
                (check (membera cs c)
                  ((showsl_cc c . showsl_lit "\nis not a premise of ") .
                    showsl_cc ca))
                (\ _ ->
                  bindb (check (not (membera (vars_cc_list ca) x))
                          ((showsl_lit "variable " . showsl_lista x) .
                            showsl_lit " is not fresh"))
                    (\ _ ->
                      (case c of {
                        CC_cond _ _ ->
                          Inl (showsl_cc c .
                                showsl_lit
                                  " is not a rewrite condition of the correct shape");
                        CC_rewr (Var _) _ ->
                          Inl (showsl_cc c .
                                showsl_lit
                                  " is not a rewrite condition of the correct shape");
                        CC_rewr (Fun fa ss) q ->
                          bindb (check (less_nat i (size_list ss))
                                  (showsl_lit "invalid position"))
                            (\ _ ->
                              (case (take i ss, (nth ss i, drop (suc i) ss)) of
                                {
                                (bef, (pa, aft)) ->
                                  bindb (catch_errora
  (check_subseteq (funas_term_list pa) f)
  (\ xa ->
    Inl ((showsl_lit "function symbol " . showsl_prod xa) .
          showsl_lit " is not allowed in argument")))
                                    (\ _ ->
                                      let {
px = CC_rewr pa (Var x);
fq = CC_rewr (Fun fa (bef ++ Var x : aft)) q;
ds = px : fq : cs;
daa = CC_impl ds con;
                                      } in
check (check_subsumes (fresh_string [char_0x78, char_0x78]) d daa)
  (((showsl_lit "new constraint is " . showsl_cc d) .
     showsl_lit "\nbut expected was ") .
    showsl_cc daa));
                              }));
                        CC_impl _ _ ->
                          Inl (showsl_cc c .
                                showsl_lit
                                  " is not a rewrite condition of the correct shape");
                        CC_all _ _ ->
                          Inl (showsl_cc c .
                                showsl_lit
                                  " is not a rewrite condition of the correct shape");
                      }))))
              (\ xa ->
                Inl (((((((((((showsl_lit
                                 "problem in introducing fresh variable " .
                                showsl_lista x) .
                               showsl_lit " on ") .
                              showsl_nat (suc i)) .
                             showsl_lit "-th argument of lhs of ") .
                            showsl_cc c) .
                           showsl_lit " to switch from ") .
                          showsl_cc ca) .
                         showsl_lit "to\n") .
                        showsl_cc d) .
                       showsl_literal "\n") .
                      xa)))
        (\ _ -> check_cc_prf r da f m_ortho d p);
  });
check_cc_prf r da f m_ortho c (Simplify_Condition bc sigma d p) =
  (case normalize_cc c of {
    CC_impl cs psi ->
      bindb (catch_errora
              (bindb
                (check (membera cs bc)
                  ((showsl_cc bc . showsl_lit "\nis not a premise of ") .
                    showsl_cc c))
                (\ _ ->
                  (case cc_unbound bc of {
                    (ys, cc) ->
                      (case (case normalize_cc cc of {
                              CC_impl a b -> (a, b);
                            })
                        of {
                        (phi, psia) ->
                          let {
                            dom_ran = mk_subst_domain sigma;
                          } in bindb (catch_errora
                                       (check_subseteq (map fst dom_ran) ys)
                                       (\ x ->
 Inl (showsl_lista x .
       showsl_lit " is in the domain of sigma, but not a bound variable ")))
                                 (\ _ ->
                                   bindb (catch_errora
   (forallM
     (\ fn ->
       bindb (check (not (da fn))
               ((showsl_lit "symbol " . showsl_prod fn) .
                 showsl_lit
                   " is not allowed in range of sigma, as it is defined"))
         (\ _ ->
           check (membera f fn)
             ((showsl_lit "symbol " . showsl_prod fn) .
               showsl_lit
                 " is not allowed in range of sigma, as it is not in F")))
     (concatMap (\ x_t -> funas_term_list (snd x_t)) dom_ran))
   (\ x -> Inl (snd x)))
                                     (\ _ ->
                                       let {
 vs = remdups (concatMap (\ x_t -> vars_term_list (snd x_t)) dom_ran);
 sigmaa =
   (\ ca ->
     cc_subst_apply (fresh_string [char_0x78, char_0x78]) ca
       (mk_subst Var sigma, vs));
                                       } in
 bindb (catch_errora
         (forallM
           (\ ca ->
             check (any (\ caa ->
                          check_subsumes (fresh_string [char_0x78, char_0x78])
                            caa (sigmaa ca))
                     cs)
               (showsl_cc (sigmaa ca) .
                 showsl_lit
                   "\nis not contained as premise of the input implication"))
           phi)
         (\ x -> Inl (snd x)))
   (\ _ ->
     let {
       daa = CC_impl (sigmaa psia : cs) psi;
     } in check (check_subsumes (fresh_string [char_0x78, char_0x78]) d daa)
            (((showsl_lit "new constraint is " . showsl_cc d) .
               showsl_lit "\nbut expected was ") .
              showsl_cc daa))));
                      });
                  })))
              (\ x ->
                Inl (((((((((showsl_lit
                               "problem in Simplify Condition with substitution " .
                              showsl_lista sigma) .
                             showsl_lit " on IH\n") .
                            showsl_cc bc) .
                           showsl_lit "\nto switch from\n") .
                          showsl_cc c) .
                         showsl_lit "\nto\n") .
                        showsl_cc d) .
                       showsl_literal "\n") .
                      x)))
        (\ _ -> check_cc_prf r da f m_ortho d p);
  });
check_cc_prf r da f m_ortho c (Induction d ccs ihs) =
  (case normalize_cc c of {
    CC_impl cs ca ->
      bindb (catch_errora
              (bindb (check m_ortho (showsl_lit "CR or minimality required"))
                (\ _ ->
                  bindb (catch_errora
                          (forallM
                            (\ cc ->
                              check (membera cs cc)
                                ((showsl_cc cc .
                                   showsl_lit "\nis not a premise of ") .
                                  showsl_cc c))
                            (d : ccs))
                          (\ x -> Inl (snd x)))
                    (\ _ ->
                      (case d of {
                        CC_cond _ _ ->
                          Inl (showsl_cc d .
                                showsl_lit
                                  " is not a rewrite condition of the correct shape");
                        CC_rewr (Var _) _ ->
                          Inl (showsl_cc d .
                                showsl_lit
                                  " is not a rewrite condition of the correct shape");
                        CC_rewr (Fun fa xs) q ->
                          let {
                            csa = vars_cc_list
                                    (CC_impl (CC_rewr (Fun fa xs) q : ccs) ca);
                          } in bindb (check
                                       (all is_Var xs &&
 distinct (map the_Var xs))
                                       ((showsl_lit "arguments of " .
  showsl_terma (Fun fa xs)) .
 showsl_lit " are not different variables"))
                                 (\ _ ->
                                   let {
                                     xsa = map the_Var xs;
                                     rt = root (Fun fa xs);
                                   } in bindb
  (check (is_none (mgu (Fun fa xs) q)) (showsl_lit "lhs and rhs unify"))
  (\ _ ->
    bindb (catch_errora
            (forallM
              (\ lr ->
                check (if root (fst lr) == rt
                        then any (\ lra ->
                                   eq_rule_mod_vars lr lra &&
                                     isOK (check_disjoint csa
    (vars_rule_list lra)))
                               (map (\ (ra, _) -> ra) ihs)
                        else True)
                  (showsl_lit
                     "could not find variable renamed version of rule " .
                    showsl_rule lr))
              r)
            (\ x -> Inl (snd x)))
      (\ _ ->
        catch_errora
          (forallM
            (\ (a, b) ->
              (case a of {
                (l, ra) ->
                  (\ (rys, (cc, _)) ->
                    catch_errora
                      (let {
                         cca = cc_rule_constraint
                                 (fresh_string [char_0x78, char_0x78]) fa
                                 (args l) ra q xsa ccs ca rys;
                       } in bindb (catch_errora
                                    (forallM (check_rys da rt ra) rys)
                                    (\ x -> Inl (snd x)))
                              (\ _ ->
                                check (check_subsumes
(fresh_string [char_0x78, char_0x78]) cc cca)
                                  (((showsl_lit "new constraint is " .
                                      showsl_cc cc) .
                                     showsl_lit "\nbut expected was ") .
                                    showsl_cc cca)))
                      (\ x ->
                        Inl (((showsl_lit "problem in constraint for rule " .
                                showsl_rule (l, ra)) .
                               showsl_literal "\n") .
                              x)));
              })
                b)
            ihs)
          (\ x -> Inl (snd x)))));
                        CC_impl _ _ ->
                          Inl (showsl_cc d .
                                showsl_lit
                                  " is not a rewrite condition of the correct shape");
                        CC_all _ _ ->
                          Inl (showsl_cc d .
                                showsl_lit
                                  " is not a rewrite condition of the correct shape");
                      }))))
              (\ x ->
                Inl ((((((showsl_lit
                            "problem in Induction rule with rewrite condition " .
                           showsl_cc d) .
                          showsl_lit " to switch from\n") .
                         showsl_cc c) .
                        showsl_lit "\nto\n") .
                       showsl_list_gen
                         (\ (_, (_, (cb, _))) ->
                           showsl_cc cb . showsl_literal "\n")
                         "" "" "" "" ihs) .
                      x)))
        (\ _ ->
          bindb (mapM (\ (_, (_, (a, b))) -> check_cc_prf r da f m_ortho a b)
                  ihs)
            (\ fcss -> Inr (concat fcss)));
  });

check_cc_prfs ::
  forall a b.
    (Ceq a, Ccompare a, Eq a, Set_impl a,
      Showl a) => [(Term a [Char], Term a [Char])] ->
                    ((a, Nat) -> Bool) ->
                      [(a, Nat)] ->
                        Bool ->
                          [(Cond_constraint a [Char],
                             (b, Cond_constraint_prf a [Char]))] ->
                            Sum (String -> String) [C_constraint a [Char]];
check_cc_prfs r d f m_ortho [] = Inr [];
check_cc_prfs r d f m_ortho ((c, (uu, prf)) : cpfs) =
  bindb (check_cc_prf r d f m_ortho c prf)
    (\ l1 -> bindb (check_cc_prfs r d f m_ortho cpfs) (\ l2 -> Inr (l1 ++ l2)));

string_rename :: Renaming2 [Char];
string_rename = Abs_renaming2 ((\ a -> char_0x78 : a), (\ a -> char_0x79 : a));

add_funas_args_term :: forall a b. Term a b -> [(a, Nat)] -> [(a, Nat)];
add_funas_args_term t fs = foldr add_funas_term (args t) fs;

add_funas_args_rule ::
  forall a b. (Term a b, Term a b) -> [(a, Nat)] -> [(a, Nat)];
add_funas_args_rule r fs =
  add_funas_args_term (fst r) (add_funas_args_term (snd r) fs);

funas_args_trs_list :: forall a b. [(Term a b, Term a b)] -> [(a, Nat)];
funas_args_trs_list trs = foldr add_funas_args_rule trs [];

conditional_general_reduction_pair_proc ::
  forall a b.
    (Ceq b, Ccompare b, Compare_order b, Eq b, Set_impl b,
      Showl b) => Dpp_ops_ext a b [Char] () ->
                    ([(b, Nat)] -> Non_inf_order_ext b [Char] ()) ->
                      [(Term b [Char], Term b [Char])] ->
                        [(Term b [Char], Term b [Char])] ->
                          Cond_red_pair_prf b [Char] ->
                            Bool -> a -> Sum (String -> String) [a];
conditional_general_reduction_pair_proc i grp pstrict pbound prof merge dpp =
  (case prof of {
    Cond_Red_Pair_Prf c ccs bef aft ->
      let {
        p = pairsb i dpp;
        r = rulesf i dpp;
        f = remdups
              (funas_trs_list r ++
                funas_args_trs_list p ++ concatMap funas_term_list (qc i dpp));
        rp = grp f;
      } in (case catch_errora
                   (bindb (validb rp)
                     (\ _ ->
                       bindb (check (wwf_rulesa i dpp)
                               (showsl_lit "require well-formedness of TRS"))
                         (\ _ ->
                           let {
                             is_def =
                               (\ fn -> not (null (rules_mapc i dpp fn)));
                           } in bindb (check_varcond_subset p)
                                  (\ _ ->
                                    bindb (catch_errora
    (forallM
      (\ (l, ra) ->
        bindb (check_no_var l)
          (\ _ ->
            bindb (check_no_var ra) (\ _ -> check_no_defined_root is_def ra)))
      p)
    (\ x -> Inl (snd x)))
                                      (\ _ ->
let {
  ccsa = map (\ (ca, (uvs, _)) -> (ca, uvs)) ccs;
  check_present = check_constraint_present i dpp c p bef aft ccsa;
} in (case split_pairsa i dpp pstrict of {
       (ps, pns) ->
         (case split_pairsa i dpp pbound of {
           (pb, _) ->
             let {
               pi = afa rp;
               us = usable_rules_gen pi r p;
             } in bindb (catch_errora (forallM (check_present Strict) ps)
                          (\ x -> Inl (snd x)))
                    (\ _ ->
                      bindb (catch_errora
                              (forallM (check_present Non_Strict) pns)
                              (\ x -> Inl (snd x)))
                        (\ _ ->
                          bindb (catch_errora (forallM (check_present Bound) pb)
                                  (\ x -> Inl (snd x)))
                            (\ _ ->
                              bindb (check (nFQ_subset_NF_rulesc i dpp)
                                      (showsl_lit "innermost required"))
                                (\ _ ->
                                  bindb (catch_errora
  (catch_errora (forallM (nsa rp) us) (\ x -> Inl (snd x)))
  (\ x -> Inl (showsl_lit "problem when orienting usable rules\n" . x)))
                                    (\ _ ->
                                      let {
m = minimal i dpp;
ortho = isOK (check_weakly_orthogonal string_rename r);
                                      } in
bindb (catch_errora
        (check_cc_prfs r (\ fn -> not (null (rules_mapc i dpp fn))) f
          (m || ortho) ccs)
        (\ x ->
          Inl (showsl_lit "problem when simplifying conditional constraints\n" .
                x)))
  (\ fcs ->
    catch_errora (catch_errora (forallM (cc rp) fcs) (\ x -> Inl (snd x)))
      (\ x ->
        Inl (showsl_lit
               "problem when orienting final (conditional) constraints for pairs\n" .
              x))))))));
         });
     }))))))
                   (\ x ->
                     Inl (((showsl_lit
                              "could not apply the bounded increase processor with the following\n" .
                             descb rp) .
                            showsl_literal "\n") .
                           x))
             of {
             Inl a -> Inl a;
             Inr _ ->
               Inr (if merge
                     then [delete_P_Pwa i dpp (inter_list_set pstrict pbound)
                             (inter_list_set pstrict pbound)]
                     else [delete_P_Pwa i dpp pstrict pstrict,
                            delete_P_Pwa i dpp pbound pbound]);
           });
  });

rules_no_left_vara :: forall a b c d. Dpp_ops_ext a b c d -> a -> Bool;
rules_no_left_vara
  (Dpp_ops_ext dpp p pw pairs q r rw rules q_empty rules_no_left_var
    rules_non_collapsing is_QNF nFQ_subset_NF_rules rules_map reverse_rules_map
    intersect_pairs replace_pair intersect_rules delete_P_Pw delete_R_Rw
    split_pairs split_rules mk minimal nfs wwf_rules more)
  = rules_no_left_var;

critical_pairs_top_impl ::
  forall a b.
    (Infinite a, Eq a,
      Eq b) => Renaming2 a ->
                 [(Term b a, Term b a)] ->
                   [(Term b a, Term b a)] -> [(Term b a, Term b a)];
critical_pairs_top_impl ren p r =
  concatMap
    (\ (l, ra) ->
      (if is_Var l then []
        else concatMap
               (\ (la, rb) ->
                 (case mgu_vd ren l la of {
                   Nothing -> [];
                   Just (sigma, tau) ->
                     [(eval_term Fun rb tau, eval_term Fun ra sigma)];
                 }))
               r))
    p;

showsl_crit_pair ::
  forall a b. (Showl a, Showl b) => (Term a b, Term a b) -> String -> String;
showsl_crit_pair lr =
  (((showsl_lit "(" . showsl_terma (fst lr)) . showsl_lit ", ") .
    showsl_terma (snd lr)) .
    showsl_lit ")";

check_critical_pairs_innermost ::
  forall a b.
    (Infinite a, Eq a, Showl a, Eq b,
      Showl b) => Renaming2 a ->
                    [(Term b a, Term b a)] -> Sum (String -> String) ();
check_critical_pairs_innermost ren r =
  catch_errora
    (forallM
      (\ (l, ra) ->
        check (equal_term l ra)
          (showsl_lit "there is a non-trivial critical pair " .
            showsl_crit_pair (l, ra)))
      (critical_pairs_top_impl ren r r))
    (\ x -> Inl (snd x));

extract_fresh_var ::
  forall a b.
    [((Term a b, Term a b), (Term a b, Term a b))] -> Sum (String -> String) b;
extract_fresh_var sts =
  (case (case sts of {
          [] -> Nothing;
          (_, (Var _, _)) : _ -> Nothing;
          (_, (Fun _ ss, _)) : _ ->
            (if null ss then Nothing else (case last ss of {
    Var a -> Just a;
    Fun _ _ -> Nothing;
  }));
        })
    of {
    Nothing ->
      Inl (showsl_lit
            "could not extract fresh variable (as last argument from some lhs of new pairs)");
    Just a -> Inr a;
  });

extract_ren ::
  forall a b.
    (Eq a) => [((Term a b, Term a b), (Term a b, Term a b))] ->
                Sum (String -> String) ((a, Nat) -> a);
extract_ren ps_ps =
  bindb (check
          (all (\ (a, b) ->
                 (case a of {
                   (s, t) ->
                     (\ (sa, ta) ->
                       not (is_Var s) &&
                         not (is_Var t) && not (is_Var sa) && not (is_Var ta));
                 })
                   b)
            ps_ps)
          (showsl_lit "all lhss and rhss of pairs must be non-variables"))
    (\ _ ->
      let {
        rt = (\ t -> the (root t));
        pair = (\ s sa -> (rt s, fst (rt sa)));
        pairs =
          (\ (st, sta) -> [pair (fst st) (fst sta), pair (snd st) (snd sta)]);
        ren = map_of (remdups (concatMap pairs ps_ps));
        a = (\ fn -> (case ren fn of {
                       Nothing -> fst fn;
                       Just f -> f;
                     }));
      } in Inr a);

check_drop ::
  forall a b.
    (Eq a, Showl a, Eq b,
      Showl b) => a -> Term b a ->
                         ((b, Nat) -> b) ->
                           ((Term b a, Term b a), (Term b a, Term b a)) ->
                             Sum (String -> String) ();
check_drop x c ren st_st =
  (case st_st of {
    ((s, t), (sa, ta)) ->
      (case s of {
        Fun f ss ->
          (case t of {
            Fun g ts ->
              bindb (check
                      (equal_term sa
                        (Fun (ren (f, size_list ss)) (ss ++ [Var x])))
                      (((showsl_lit "could not relate " . showsl_terma s) .
                         showsl_lit " with ") .
                        showsl_terma sa))
                (\ _ ->
                  let {
                    tsa = args ta;
                    tsaa = take (minus_nat (size_list tsa) one_nat) tsa;
                  } in check (equal_term ta
                                (Fun (ren (g, size_list ts))
                                  (tsaa ++ [Var x])) &&
                               ts == map (\ tb -> eval_term Fun tb (subst x c))
                                       tsaa)
                         (((showsl_lit "could not relate " . showsl_terma t) .
                            showsl_lit " with ") .
                           showsl_terma ta));
          });
      });
  });

mkd ::
  forall a b c d.
    Dpp_ops_ext a b c d ->
      Bool ->
        Bool ->
          [(Term b c, Term b c)] ->
            [(Term b c, Term b c)] ->
              [Term b c] ->
                [(Term b c, Term b c)] -> [(Term b c, Term b c)] -> a;
mkd (Dpp_ops_ext dpp p pw pairs q r rw rules q_empty rules_no_left_var
      rules_non_collapsing is_QNF nFQ_subset_NF_rules rules_map
      reverse_rules_map intersect_pairs replace_pair intersect_rules delete_P_Pw
      delete_R_Rw split_pairs split_rules mk minimal nfs wwf_rules more)
  = mk;

rwd :: forall a b c d. Dpp_ops_ext a b c d -> a -> [(Term b c, Term b c)];
rwd (Dpp_ops_ext dpp p pw pairs q r rw rules q_empty rules_no_left_var
      rules_non_collapsing is_QNF nFQ_subset_NF_rules rules_map
      reverse_rules_map intersect_pairs replace_pair intersect_rules delete_P_Pw
      delete_R_Rw split_pairs split_rules mk minimal nfs wwf_rules more)
  = rw;

pwb :: forall a b c d. Dpp_ops_ext a b c d -> a -> [(Term b c, Term b c)];
pwb (Dpp_ops_ext dpp p pw pairs q r rw rules q_empty rules_no_left_var
      rules_non_collapsing is_QNF nFQ_subset_NF_rules rules_map
      reverse_rules_map intersect_pairs replace_pair intersect_rules delete_P_Pw
      delete_R_Rw split_pairs split_rules mk minimal nfs wwf_rules more)
  = pw;

rd :: forall a b c d. Dpp_ops_ext a b c d -> a -> [(Term b c, Term b c)];
rd (Dpp_ops_ext dpp p pw pairs q r rw rules q_empty rules_no_left_var
     rules_non_collapsing is_QNF nFQ_subset_NF_rules rules_map reverse_rules_map
     intersect_pairs replace_pair intersect_rules delete_P_Pw delete_R_Rw
     split_pairs split_rules mk minimal nfs wwf_rules more)
  = r;

pb :: forall a b c d. Dpp_ops_ext a b c d -> a -> [(Term b c, Term b c)];
pb (Dpp_ops_ext dpp p pw pairs q r rw rules q_empty rules_no_left_var
     rules_non_collapsing is_QNF nFQ_subset_NF_rules rules_map reverse_rules_map
     intersect_pairs replace_pair intersect_rules delete_P_Pw delete_R_Rw
     split_pairs split_rules mk minimal nfs wwf_rules more)
  = p;

complex_constant_removal_proc ::
  forall a b c.
    (Ccompare a, Infinite a, Eq a, Mapping_impl a, Showl a, Compare_order c,
      Eq c,
      Showl c) => Renaming2 a ->
                    Dpp_ops_ext b c a () ->
                      Complex_constant_removal_prf c a ->
                        b -> Sum (String -> String) b;
complex_constant_removal_proc rename i (Complex_Constant_Removal_Proof c ps) dpp
  = catch_errora
      (let {
         p = pb i dpp;
         pw = pwb i dpp;
         r = rwd i dpp;
         q = qc i dpp;
         pairs = pairsb i dpp;
       } in bindb (extract_fresh_var ps)
              (\ x ->
                bindb (extract_ren ps)
                  (\ ren ->
                    let {
                      is_def = (\ fn -> not (null (rules_mapc i dpp fn)));
                      rQs = remdups (map root q);
                    } in bindb (catch_errora
                                 (forallM
                                   (\ (s, t) ->
                                     bindb (check_no_var s)
                                       (\ _ ->
 bindb (check_no_var t)
   (\ _ ->
     bindb (check_no_defined_root is_def t)
       (\ _ ->
         bindb (check (not (membera (vars_rule_list (s, t)) x))
                 ((showsl x . showsl_lit " is not fresh for pair ") .
                   showsl_rule (s, t)))
           (\ _ ->
             let {
               f = the (root s);
               fa = (ren f, suc (snd f));
             } in bindb (check (not (membera rQs (Just fa)))
                          (showsl_lit "renaming delivers defined symbol of Q"))
                    (\ _ ->
                      check (not (is_def fa))
                        (showsl_lit
                          "renaming delivers defined symbol of R")))))))
                                   pairs)
                                 (\ xa -> Inl (snd xa)))
                           (\ _ ->
                             let {
                               pps = filter (\ st_st -> membera p (fst st_st))
                                       ps;
                               pwps =
                                 filter (\ st_st -> membera pw (fst st_st)) ps;
                             } in bindb (catch_errora
  (forallM
    (\ st ->
      check (membera (map fst pps) st)
        (showsl_lit "could not find entry for pair " . showsl_rule st))
    p)
  (\ xa -> Inl (snd xa)))
                                    (\ _ ->
                                      bindb
(catch_errora
  (forallM
    (\ st ->
      check (membera (map fst pwps) st)
        (showsl_lit "could not find entry for pair " . showsl_rule st))
    pw)
  (\ xa -> Inl (snd xa)))
(\ _ ->
  bindb (check (ground c)
          ((showsl_lit "the term " . showsl_terma c) .
            showsl_lit " is not ground"))
    (\ _ ->
      bindb (check (nFQ_subset_NF_rulesc i dpp)
              (showsl_lit "innermost required"))
        (\ _ ->
          bindb (check (null (rd i dpp))
                  (showsl_lit "strict rules not allowed"))
            (\ _ ->
              bindb (check (rules_no_left_vara i dpp)
                      (showsl_lit "rules may not have variables as lhss"))
                (\ _ ->
                  bindb (if is_NF_trs r c then Inr ()
                          else catch_errora
                                 (check_critical_pairs_innermost rename r)
                                 (\ xa ->
                                   Inl (showsl_lit
  "could not ensure confluence\n" .
 xa)))
                    (\ _ ->
                      bindb (catch_errora
                              (forallM
                                (\ st_st ->
                                  catch_errora (check_drop x c ren st_st)
                                    (\ xa ->
                                      Inl
(((((showsl_lit "problem in finding correspondence between rule " .
      showsl_rule (fst st_st)) .
     showsl_lit " and rule ") .
    showsl_rule (snd st_st)) .
   showsl_literal "\n") .
  xa)))
                                ps)
                              (\ xa -> Inl (snd xa)))
                        (\ _ ->
                          Inr (mkd i (nfsc i dpp) (minimal i dpp) (map snd pps)
                                (map snd pwps) q [] r)))))))))))))
      (\ x ->
        Inl (showsl_lit "problem in complex constant removal proc:\n" . x));

fun_of_default :: forall a b. (Eq a) => [(a, b)] -> b -> a -> b;
fun_of_default m d = let {
                       mm = map_of m;
                     } in (\ i -> (case mm i of {
                                    Nothing -> d;
                                    Just e -> e;
                                  }));

get_arg :: forall a b. Term a b -> Nat -> Term a b;
get_arg t n =
  (if equal_nat n zero_nat then t else nth (args t) (minus_nat n one_nat));

iteratei_bset_op_list_it_dflt_basic_oops_rm_basic_ops ::
  forall a b.
    (Linorder a) => Rbt a () -> (b -> Bool) -> (a -> b -> b) -> b -> b;
iteratei_bset_op_list_it_dflt_basic_oops_rm_basic_ops s =
  (\ c f -> rm_iterateoi (impl_of s) c (f . fst));

g_ball_dflt_basic_oops_rm_basic_ops ::
  forall a. (Linorder a) => Rbt a () -> (a -> Bool) -> Bool;
g_ball_dflt_basic_oops_rm_basic_ops s p =
  iteratei_bset_op_list_it_dflt_basic_oops_rm_basic_ops s (\ c -> c)
    (\ x _ -> p x) True;

subtract_list_sorted :: forall a. (Eq a, Linorder a) => [a] -> [a] -> [a];
subtract_list_sorted (x : xs) (y : ys) =
  (if x == y then subtract_list_sorted xs (y : ys)
    else (if less x y then x : subtract_list_sorted xs (y : ys)
           else subtract_list_sorted (x : xs) ys));
subtract_list_sorted [] ys = [];
subtract_list_sorted (v : va) [] = v : va;

remdups_sort :: forall a. (Eq a, Linorder a) => [a] -> [a];
remdups_sort xs = remdups_adj (sort_key (\ x -> x) xs);

comp :: forall a. (Eq a, Linorder a) => [(a, a)] -> [(a, a)] -> [(a, a)];
comp esa es =
  remdups_sort
    (concatMap
      (\ (x, y) ->
        concatMap (\ (ya, z) -> (if y == ya then [(x, z)] else [])) es)
      esa);

scg_comp ::
  forall a b.
    (Eq b, Linorder b) => (a -> a -> Bool) -> Scg a b -> Scg a b -> Scg a b;
scg_comp conn (Scg pa qa stra wka) (Scg p q str wk) =
  (if not (conn qa p) then Null
    else let {
           strs = remdups_sort (comp stra str ++ comp stra wk ++ comp wka str);
           a = subtract_list_sorted (remdups_sort (comp wka wk)) strs;
         } in Scg pa q strs a);
scg_comp conn Null g = Null;
scg_comp conn (Scg v va vb vc) Null = Null;

generate_scgs ::
  forall a b.
    (Eq a, Eq b,
      Linorder b) => (a -> a -> Bool) -> [Scg a b] -> Scg a b -> [Scg a b];
generate_scgs conn base g =
  filter (\ ga -> not (equal_scg ga Null)) (map (scg_comp conn g) base);

subsumes :: forall a b. (Eq a, Eq b) => Scg a b -> Scg a b -> Bool;
subsumes (Scg pa qa stra wka) (Scg p q str wk) =
  pa == p && qa == q && superset str stra && superset (str ++ wk) wka;
subsumes g Null = True;
subsumes Null (Scg v va vb vc) = False;

in_situ :: forall a b. (Eq b) => Scg a b -> Bool;
in_situ Null = True;
in_situ (Scg p q str wk) = any (\ (a, b) -> a == b) str;

union_list_sorted :: forall a. (Eq a, Ord a) => [a] -> [a] -> [a];
union_list_sorted (x : xs) (y : ys) =
  (if x == y then x : union_list_sorted xs ys
    else (if less x y then x : union_list_sorted xs (y : ys)
           else y : union_list_sorted (x : xs) ys));
union_list_sorted [] ys = ys;
union_list_sorted (v : va) [] = v : va;

combinea :: forall a b. (Eq b, Linorder b) => Scg a b -> Scg a b -> Scg a b;
combinea (Scg pa qa stra wka) (Scg p q str wk) =
  Scg pa qa (union_list_sorted stra str) (union_list_sorted wka wk);
combinea Null s = Null;
combinea (Scg v va vb vc) Null = Null;

sagiv ::
  forall a b. (Eq a, Eq b, Linorder b) => (a -> a -> Bool) -> Scg a b -> Bool;
sagiv conn g =
  (if in_situ g then True
    else let {
           gg = scg_comp conn g g;
         } in (if subsumes gg g then False else sagiv conn (combinea g gg)));

ins_dj_rm_basic_ops :: forall a. (Compare_order a) => a -> Rbt a () -> Rbt a ();
ins_dj_rm_basic_ops x s = insert x () s;

mk_rtrancl_set_main ::
  forall a. (Compare_order a) => (a -> [a]) -> [a] -> Rbt a () -> Rbt a ();
mk_rtrancl_set_main r todo fin =
  (case todo of {
    [] -> fin;
    a : tod ->
      (if memb_rm_basic_ops a fin then mk_rtrancl_set_main r tod fin
        else mk_rtrancl_set_main r (r a ++ tod) (ins_dj_rm_basic_ops a fin));
  });

mk_rtrancl_set :: forall a. (Compare_order a) => (a -> [a]) -> [a] -> Rbt a ();
mk_rtrancl_set r init = mk_rtrancl_set_main r init (empty_rm_basic_ops ());

check_SCT ::
  forall a b.
    (Compare_order a, Eq a, Compare_order b,
      Eq b) => (a -> a -> Bool) -> [Scg a b] -> Bool;
check_SCT conn gs =
  g_ball_dflt_basic_oops_rm_basic_ops
    (mk_rtrancl_set (generate_scgs conn gs) gs) (sagiv conn);

check_supteq ::
  forall a b.
    (Eq a, Showl a, Eq b,
      Showl b) => Term a b -> Term a b -> Sum (String -> String) ();
check_supteq s t =
  check (equal_term s t || supt_impl s t)
    ((showsl_terma t . showsl_literal " is not a subterm of ") .
      showsl_terma s);

sct_subterm_precise_proc ::
  forall a b.
    (Compare_order b, Eq b,
      Showl b) => Dpp_ops_ext a b [Char] () ->
                    [((Term b [Char], Term b [Char]),
                       ([(Nat, Nat)], [(Nat, Nat)]))] ->
                      a -> Sum (String -> String) ();
sct_subterm_precise_proc i gs dpp =
  catch_errora
    (let {
       p = pairsb i dpp;
       is_def = (\ fn -> not (null (rules_mapc i dpp fn)));
       eidg = is_iedg_edge_dpp i dpp;
     } in bindb (catch_errora (check_subseteq p (map fst gs))
                  (\ x ->
                    Inl (showsl_lit
                           "there is no size-change graph for the pair " .
                          showsl_rule x)))
            (\ _ ->
              let {
                gGs = filter (\ g -> membera p (fst g)) gs;
              } in bindb (check (minimal i dpp || nFQ_subset_NF_rulesc i dpp)
                           (showsl_lit "minimality or innermost required"))
                     (\ _ ->
                       bindb (catch_errora
                               (forallM (\ (l, _) -> check_no_var l)
                                 (rulesf i dpp))
                               (\ x -> Inl (snd x)))
                         (\ _ ->
                           bindb (catch_errora
                                   (forallM
                                     (\ (a, b) ->
                                       (case a of {
 (s, t) ->
   (\ (stri, nstri) ->
     catch_errora
       (bindb (check_no_var s)
         (\ _ ->
           bindb (check_no_var t)
             (\ _ ->
               bindb (check_no_defined_root is_def t)
                 (\ _ ->
                   let {
                     m = size_list (args t);
                     n = size_list (args s);
                   } in bindb (catch_errora
                                (forallM
                                  (\ (ia, j) ->
                                    check (less_eq_nat ia n &&
    less_eq_nat j m && isOK (check_supt (get_arg s ia) (get_arg t j)))
                                      ((((showsl_lit "problem with edge " .
   showsl_nat ia) .
  showsl_lit " |> ") .
 showsl_nat j) .
showsl_literal "\n"))
                                  stri)
                                (\ x -> Inl (snd x)))
                          (\ _ ->
                            catch_errora
                              (forallM
                                (\ (ia, j) ->
                                  check (less_eq_nat ia n &&
  less_eq_nat j m && isOK (check_supteq (get_arg s ia) (get_arg t j)))
                                    ((((showsl_lit "problem with edge " .
 showsl_nat ia) .
showsl_lit " |>= ") .
                                       showsl_nat j) .
                                      showsl_literal "\n"))
                                nstri)
                              (\ x -> Inl (snd x)))))))
       (\ x ->
         Inl (((showsl_lit "problem with pair " . showsl_rule (s, t)) .
                showsl_literal "\n") .
               x)));
                                       })
 b)
                                     gGs)
                                   (\ x -> Inl (snd x)))
                             (\ _ ->
                               let {
                                 n = size_list p;
                                 nums = upt zero_nat n;
                                 numPs = zip p nums;
                                 num_of = fun_of_default numPs n;
                               } in check (check_SCT
    (\ (_, succs) (uv, _) -> membera succs uv)
    (map (\ (st, (stri, nstri)) ->
           let {
             eidg_st = eidg st;
             ia = num_of st;
             e = (ia, map_filter
                        (\ x ->
                          (if ((eidg_st . fst) . fst) x then Just (snd x)
                            else Nothing))
                        numPs);
           } in Scg e e (remdups_sort stri) (remdups_sort nstri))
      gGs))
                                      (showsl_lit
"size-change analysis failed\n"))))))
    (\ x ->
      Inl (showsl_lit
             "could not apply the size-change processor based on the subterm-relation\n" .
            x));

sct_subterm_approx_proc ::
  forall a b.
    (Compare_order b, Eq b,
      Showl b) => Dpp_ops_ext a b [Char] () ->
                    [((Term b [Char], Term b [Char]),
                       ([(Nat, Nat)], [(Nat, Nat)]))] ->
                      a -> Sum (String -> String) ();
sct_subterm_approx_proc i gs dpp =
  catch_errora
    (let {
       p = pairsb i dpp;
       is_def = (\ fn -> not (null (rules_mapc i dpp fn)));
     } in bindb (catch_errora (check_subseteq p (map fst gs))
                  (\ x ->
                    Inl (showsl_lit
                           "there is no size-change graph for the pair " .
                          showsl_rule x)))
            (\ _ ->
              let {
                gGs = filter (\ g -> membera p (fst g)) gs;
              } in bindb (check (minimal i dpp || nFQ_subset_NF_rulesc i dpp)
                           (showsl_lit "minimality or innermost required"))
                     (\ _ ->
                       bindb (catch_errora
                               (forallM (\ (l, _) -> check_no_var l)
                                 (rulesf i dpp))
                               (\ x -> Inl (snd x)))
                         (\ _ ->
                           bindb (catch_errora
                                   (forallM
                                     (\ (a, b) ->
                                       (case a of {
 (s, t) ->
   (\ (stri, nstri) ->
     catch_errora
       (bindb (check_no_var s)
         (\ _ ->
           bindb (check_no_var t)
             (\ _ ->
               bindb (check_no_defined_root is_def t)
                 (\ _ ->
                   let {
                     m = size_list (args t);
                     n = size_list (args s);
                   } in bindb (catch_errora
                                (forallM
                                  (\ (ia, j) ->
                                    check (less_eq_nat ia n &&
    less_eq_nat j m && isOK (check_supt (get_arg s ia) (get_arg t j)))
                                      ((((showsl_lit "problem with edge " .
   showsl_nat ia) .
  showsl_lit " |> ") .
 showsl_nat j) .
showsl_literal "\n"))
                                  stri)
                                (\ x -> Inl (snd x)))
                          (\ _ ->
                            catch_errora
                              (forallM
                                (\ (ia, j) ->
                                  check (less_eq_nat ia n &&
  less_eq_nat j m && isOK (check_supteq (get_arg s ia) (get_arg t j)))
                                    ((((showsl_lit "problem with edge " .
 showsl_nat ia) .
showsl_lit " |>= ") .
                                       showsl_nat j) .
                                      showsl_literal "\n"))
                                nstri)
                              (\ x -> Inl (snd x)))))))
       (\ x ->
         Inl (((showsl_lit "problem with pair " . showsl_rule (s, t)) .
                showsl_literal "\n") .
               x)));
                                       })
 b)
                                     gGs)
                                   (\ x -> Inl (snd x)))
                             (\ _ ->
                               check (check_SCT (\ (_, g) (h, _) -> g == h)
                                       (remdups
 (map (\ (st, (stri, nstri)) ->
        let {
          e = (the (root (fst st)), the (root (snd st)));
        } in Scg e e (remdups_sort stri) (remdups_sort nstri))
   gGs)))
                                 (showsl_lit
                                   "size-change analysis failed\n"))))))
    (\ x ->
      Inl (showsl_lit
             "could not apply the size-change processor based on the subterm-relation\n" .
            x));

sct_subterm_proc ::
  forall a b.
    (Compare_order b, Eq b,
      Showl b) => Dpp_ops_ext a b [Char] () ->
                    [((Term b [Char], Term b [Char]),
                       ([(Nat, Nat)], [(Nat, Nat)]))] ->
                      a -> Sum (String -> String) ();
sct_subterm_proc i gs dpp =
  (if isOK (sct_subterm_approx_proc i gs dpp) then Inr ()
    else sct_subterm_precise_proc i gs dpp);

sct_entry_to_sts ::
  forall a b c d. a -> Term b c -> [(d, Nat)] -> [(d, Nat)] -> [(a, Term b c)];
sct_entry_to_sts s t stri nstri = let {
                                    a = remdups (map snd (stri ++ nstri));
                                  } in map (\ j -> (s, get_arg t j)) a;

check_sct_entry ::
  forall a b c d e f.
    (Showl a,
      Showl b) => ((a, Nat) -> Bool) ->
                    ((Term a b, Term a b) -> Sum c d) ->
                      ((Term a b, Term a b) -> Sum e f) ->
                        Term a b ->
                          Term a b ->
                            [(Nat, Nat)] ->
                              [(Nat, Nat)] -> Sum (String -> String) ();
check_sct_entry is_def sa nst s t stri nstri =
  catch_errora
    (bindb (check_no_var s)
      (\ _ ->
        bindb (check_no_var t)
          (\ _ ->
            bindb (check_no_defined_root is_def t)
              (\ _ ->
                let {
                  m = size_list (args t);
                  n = size_list (args s);
                } in bindb (catch_errora
                             (forallM
                               (\ i ->
                                 check (less_eq_nat i n)
                                   ((showsl_lit "left-index to large" .
                                      showsl_nat i) .
                                     showsl_literal "\n"))
                               (remdups (map fst (stri ++ nstri))))
                             (\ x -> Inl (snd x)))
                       (\ _ ->
                         bindb (catch_errora
                                 (forallM
                                   (\ j ->
                                     check (less_eq_nat j m)
                                       (showsl_lit
  "right-index to large or argument violates usable-rules condition" .
 showsl_nat j))
                                   (remdups (map snd (stri ++ nstri))))
                                 (\ x -> Inl (snd x)))
                           (\ _ ->
                             let {
                               _ = args s;
                               _ = args t;
                             } in bindb (catch_errora
  (forallM
    (\ (i, j) ->
      check (isOK (sa (get_arg s i, get_arg t j)))
        (((showsl_lit "problem with edge " . showsl_nat i) .
           showsl_lit " -S-> ") .
          showsl_nat j))
    stri)
  (\ x -> Inl (snd x)))
                                    (\ _ ->
                                      catch_errora
(forallM
  (\ (i, j) ->
    check (isOK (nst (get_arg s i, get_arg t j)))
      (((showsl_lit "problem with edge " . showsl_nat i) .
         showsl_lit " -NS-> ") .
        showsl_nat j))
  nstri)
(\ x -> Inl (snd x)))))))))
    (\ x ->
      Inl (((showsl_lit "problems with DP " . showsl_rule (s, t)) .
             showsl_literal "\n") .
            x));

sct_ur_af_proc ::
  forall a b.
    (Compare_order b, Eq b,
      Showl b) => Dpp_ops_ext a b [Char] () ->
                    Rel_impl_ext b [Char] () ->
                      [((Term b [Char], Term b [Char]),
                         ([(Nat, Nat)], [(Nat, Nat)]))] ->
                        Maybe [(Term b [Char], Term b [Char])] ->
                          a -> Sum (String -> String) ();
sct_ur_af_proc i rp gs u_opt dpp =
  catch_errora
    (bindb (rel_impl_redtriple rp)
      (\ _ ->
        let {
          is_def = (\ fn -> not (null (rules_mapc i dpp fn)));
          pi = af rp;
          sa = s rp;
          nsa = ns rp;
          nsta = nst rp;
          p = pairsb i dpp;
          gGs = filter (\ g -> membera p (fst g)) gs;
        } in bindb (catch_errora
                     (forallM (\ (l, _) -> check_no_var l) (rulesf i dpp))
                     (\ x -> Inl (snd x)))
               (\ _ ->
                 bindb (catch_errora
                         (forallM
                           (\ (a, b) ->
                             (case a of {
                               (saa, t) ->
                                 (\ (aa, ba) ->
                                   check_sct_entry is_def sa nsta saa t aa ba);
                             })
                               b)
                           gGs)
                         (\ x -> Inl (snd x)))
                   (\ _ ->
                     let {
                       sts = concatMap
                               (\ (a, b) ->
                                 (case a of {
                                   (sb, t) ->
                                     (\ (aa, ba) ->
                                       sct_entry_to_sts sb t aa ba);
                                 })
                                   b)
                               gGs;
                     } in bindb (smart_usable_rules_checker_impl i dpp
                                  (isOK (ce_compat rp)) pi u_opt sts)
                            (\ u ->
                              bindb (catch_errora
                                      (catch_errora (forallM nsa u)
(\ x -> Inl (snd x)))
                                      (\ x ->
Inl (showsl_lit "problem when orienting usable rules\n" . x)))
                                (\ _ ->
                                  let {
                                    eidg = is_iedg_edge_dpp i dpp;
                                  } in bindb
 (catch_errora (check_subseteq p (map fst gs))
   (\ x ->
     Inl (showsl_lit "there is no size-change graph for DP " . showsl_rule x)))
 (\ _ ->
   let {
     n = size_list p;
     nums = upt zero_nat n;
     numPs = zip p nums;
     num_of = fun_of_default numPs n;
   } in check (check_SCT (\ (_, succs) (uv, _) -> membera succs uv)
                (map (\ (st, (stri, nstri)) ->
                       let {
                         eidg_st = eidg st;
                         ia = num_of st;
                         e = (ia, map_filter
                                    (\ x ->
                                      (if ((eidg_st . fst) . fst) x
then Just (snd x) else Nothing))
                                    numPs);
                       } in Scg e e stri nstri)
                  gGs))
          (showsl_lit "size-change analysis failed\n"))))))))
    (\ x ->
      Inl (((showsl_lit
               "could not apply the size-change processor with the following\n" .
              desca rp) .
             showsl_lit "\nfor the following reason\n") .
            x));

proj_terma ::
  forall a b.
    (Ceq a, Ccompare a, Eq a,
      Eq b) => Status a -> Set (a, Nat) -> Term a b -> Multiset (Term a b);
proj_terma proj f (Var x) = add_mset (Var x) zero_multiset;
proj_terma proj fa (Fun f ts) =
  (if member (f, size_list ts) fa
    then sum_mset
           (mset (map (\ i -> proj_terma proj fa (nth ts i))
                   (status proj (f, size_list ts))))
    else add_mset (Fun f ts) zero_multiset);

multeqp_code ::
  forall a.
    (Ceq a, Ccompare a, Eq a,
      Set_impl a) => (a -> a -> Bool) -> Multiset a -> Multiset a -> Bool;
multeqp_code p n m = let {
                       z = inter_mset m n;
                       x = minus_multiset m z;
                       y = minus_multiset n z;
                     } in ball (set_mset y) (\ ya -> bex (set_mset x) (p ya));

weak_supt_mul ::
  forall a b.
    (Ceq a, Ccompare a, Compare a, Eq a, Compare b,
      Eq b) => Status a -> Set (a, Nat) -> Term a b -> Term a b -> Bool;
weak_supt_mul =
  (\ proj f s t ->
    multeqp_code (\ x y -> supt_impl y x) (proj_terma proj f t)
      (proj_terma proj f s));

check_supteqproj_pred ::
  forall a b.
    (Ceq a, Ccompare a, Compare a, Eq a, Showl a, Compare b, Eq b,
      Showl b) => Status a ->
                    Set (a, Nat) ->
                      (Term a b, Term a b) -> Sum (String -> String) ();
check_supteqproj_pred pi f lr =
  check (case lr of {
          (a, b) -> weak_supt_mul pi f a b;
        })
    ((showsl_lit "could not orient rule " . showsl_rule lr) .
      showsl_lit " by supteq^mul");

strict_supt_mul ::
  forall a b.
    (Ceq a, Ccompare a, Compare a, Eq a, Compare b,
      Eq b) => Status a -> Set (a, Nat) -> Term a b -> Term a b -> Bool;
strict_supt_mul =
  (\ proj f s t ->
    multeqp_code (\ x y -> supt_impl y x) (proj_terma proj f t)
      (proj_terma proj f s) &&
      not (equal_multiset (proj_terma proj f s) (proj_terma proj f t)));

check_suptproj_pred ::
  forall a b.
    (Ceq a, Ccompare a, Compare a, Eq a, Showl a, Compare b, Eq b,
      Showl b) => Status a ->
                    Set (a, Nat) ->
                      (Term a b, Term a b) -> Sum (String -> String) ();
check_suptproj_pred pi f lr =
  check (case lr of {
          (a, b) -> strict_supt_mul pi f a b;
        })
    ((showsl_lit "could not orient rule " . showsl_rule lr) .
      showsl_lit " by supt^mul");

rep_x_f_status_option_x_x_nat_list_nat_x_f_prod_fun_option ::
  forall a.
    X_f_status_option_x_x_nat_list_nat_x_f_prod_fun_option a ->
      Maybe ((a, Nat) -> [Nat]);
rep_x_f_status_option_x_x_nat_list_nat_x_f_prod_fun_option
  (Abs_x_f_status_option_x_x_nat_list_nat_x_f_prod_fun_option x) = x;

sel21 ::
  forall a.
    X_f_status_option_x_x_nat_list_nat_x_f_prod_fun_option a -> Status a;
sel21 xa =
  Abs_status
    (case rep_x_f_status_option_x_x_nat_list_nat_x_f_prod_fun_option xa of {
      Nothing -> status (error "undefined");
      Just x2 -> x2;
    });

dis1 ::
  forall a. X_f_status_option_x_x_nat_list_nat_x_f_prod_fun_option a -> Bool;
dis1 xa =
  (case rep_x_f_status_option_x_x_nat_list_nat_x_f_prod_fun_option xa of {
    Nothing -> True;
    Just _ -> False;
  });

rep_isom ::
  forall a.
    X_f_status_option_x_x_nat_list_nat_x_f_prod_fun_option a ->
      Maybe (Status a);
rep_isom x = (if dis1 x then Nothing else Just (sel21 x));

status_of_aux ::
  forall a.
    (Eq a) => [((a, Nat), [Nat])] ->
                X_f_status_option_x_x_nat_list_nat_x_f_prod_fun_option a;
status_of_aux xa =
  Abs_x_f_status_option_x_x_nat_list_nat_x_f_prod_fun_option
    (if all (\ fidx -> all (\ i -> less_nat i (snd (fst fidx))) (snd fidx)) xa
      then Just (fun_of_map_fun (map_of xa) (\ (_, a) -> upt zero_nat a))
      else Nothing);

status_of :: forall a. (Eq a) => [((a, Nat), [Nat])] -> Maybe (Status a);
status_of x = rep_isom (status_of_aux x);

generalized_subterm_proc ::
  forall a b c.
    (Ceq b, Ccompare b, Compare b, Eq b, Set_impl b, Showl b, Compare c, Eq c,
      Showl c) => Dpp_ops_ext a b c () ->
                    [((b, Nat), [Nat])] ->
                      [(Term b c, Term b c)] -> a -> Sum (String -> String) a;
generalized_subterm_proc i pi p_remove dpp =
  (case catch_errora
          (let {
             p = pairsb i dpp;
             r = rulesf i dpp;
             f = map fst pi;
             ff = set f;
             pi_opt = status_of pi;
           } in bindb (check (null (qc i dpp))
                        (showsl_lit
                          "currently generalized subterm criterion does not support strategies"))
                  (\ _ ->
                    bindb (check (minimal i dpp)
                            (showsl_lit "minimality required"))
                      (\ _ ->
                        bindb (check (not (is_none pi_opt))
                                (showsl_lit
                                  "argument filter lists invalid positions"))
                          (\ _ ->
                            let {
                              pia = the pi_opt;
                              premove = set p_remove;
                            } in (case partition (\ lr -> member lr premove) p
                                   of {
                                   (ps, pns) ->
                                     bindb (catch_errora
     (forallM
       (\ fa ->
         check (not (null (status pia fa)))
           ((showsl_lit "status of symbol " . showsl_prod fa) .
             showsl_lit " in F must be non-empty"))
       f)
     (\ x -> Inl (snd x)))
                                       (\ _ ->
 bindb (catch_errora
         (forallM
           (\ (l, _) ->
             check (not (is_Var l))
               (showsl_lit "variables as lhss not allowed"))
           r)
         (\ x -> Inl (snd x)))
   (\ _ ->
     bindb (catch_errora
             (catch_errora
               (forallM (check_supteqproj_pred pia ff)
                 (filter (\ lr -> member (the (root (fst lr))) ff) r))
               (\ x -> Inl (snd x)))
             (\ x ->
               Inl (showsl_lit "problem when orienting rules with root in F\n" .
                     x)))
       (\ _ ->
         bindb (catch_errora
                 (catch_errora (forallM (check_supteqproj_pred pia ff) pns)
                   (\ x -> Inl (snd x)))
                 (\ x -> Inl (showsl_lit "problem when orienting DPs\n" . x)))
           (\ _ ->
             catch_errora
               (catch_errora (forallM (check_suptproj_pred pia ff) ps)
                 (\ x -> Inl (snd x)))
               (\ x -> Inl (showsl_lit "problem when orienting DPs\n" . x))))));
                                 })))))
          (\ x ->
            Inl (showsl_lit "could not apply the subterm processor\n" . x))
    of {
    Inl a -> Inl a;
    Inr _ -> Inr (delete_P_Pwa i dpp p_remove p_remove);
  });

faulty_non_inf_order ::
  forall a b c. (Showl b, Showl c) => String -> a -> Non_inf_order_ext b c ();
faulty_non_inf_order s f =
  Non_inf_order_ext (Inl (showsl_lit s)) (\ _ -> Inr ()) (\ _ -> Inr ())
    (\ _ _ -> Wild) id ();

sqrt_real :: Real -> [Real];
sqrt_real x =
  (if less_eq_real zero_real x then let {
                                      y = sqrt x;
                                    } in remdups [y, uminus_real y]
    else []);

check_poly_weak_mono_discrete ::
  forall a b.
    (Eq a, Linorder a, Eq b, Poly_carrier b) => [(Monom a, b)] -> a -> Bool;
check_poly_weak_mono_discrete p v =
  check_poly_ge
    (poly_subst
      (\ w -> poly_of (if w == v then PSum [PNum onea, PVar v] else PVar w)) p)
    p;

check_poly_weak_mono_all ::
  forall a b. (Ordered_semiring_0a b) => [(Monom a, b)] -> Bool;
check_poly_weak_mono_all p = all (\ (_, a) -> less_eq zerob a) p;

eval_monom_list ::
  forall a b. (Linorder a, Comm_semiring_1 b) => (a -> b) -> [(a, Nat)] -> b;
eval_monom_list alpha [] = onea;
eval_monom_list alpha ((x, p) : m) =
  times (eval_monom_list alpha m) (binary_power (alpha x) p);

eval_monom ::
  forall a b. (Linorder a, Comm_semiring_1 b) => (a -> b) -> Monom a -> b;
eval_monom x xc = eval_monom_list x (rep_monom xc);

eval_poly ::
  forall a b.
    (Linorder a, Comm_semiring_1 b) => (a -> b) -> [(Monom a, b)] -> b;
eval_poly alpha [] = zerob;
eval_poly alpha (mc : p) =
  plus (times (eval_monom alpha (fst mc)) (snd mc)) (eval_poly alpha p);

check_poly_weak_mono_and_pos ::
  forall a b.
    (Eq a, Linorder a, Eq b, Poly_carrier b) => Bool -> [(Monom a, b)] -> Bool;
check_poly_weak_mono_and_pos discrete p =
  (if discrete
    then all (check_poly_weak_mono_discrete p) (poly_vars_list p) &&
           less_eq zerob (eval_poly (\ _ -> zerob) p)
    else check_poly_weak_mono_all p);

check_non_inf_poly_inter_list ::
  forall a b.
    (Eq a, Eq b,
      Poly_carrier b) => Bool ->
                           [(a, Nat)] ->
                             [((a, Nat), [(Monom Nat, b)])] ->
                               Sum (a, [(Monom Nat, b)]) ();
check_non_inf_poly_inter_list discrete f i =
  catch_errora
    (catch_errora
      (forallM
        (\ x ->
          (if (case x of {
                (_, a) -> check_poly_weak_mono_and_pos discrete a;
              })
            then Inr () else Inl x))
        (filter (\ (fn, _) -> membera f fn) i))
      (\ x -> Inl (snd x)))
    (\ x -> Inl (case x of {
                  (a, b) -> (case a of {
                              (fa, _) -> (\ aa -> (fa, aa));
                            })
                              b;
                }));

poly_inter_list_to_inter ::
  forall a b.
    (Poly_carrier a,
      Compare_order b) => a -> [((b, Nat), [(Monom Nat, a)])] ->
                                 (b, Nat) -> [(Monom Nat, a)];
poly_inter_list_to_inter def i =
  fun_of_map_fun (ceta_map_of i) (\ fn -> default_I def (snd fn));

check_poly_weak_anti_mono_discrete ::
  forall a b.
    (Eq a, Linorder a, Eq b, Poly_carrier b) => [(Monom a, b)] -> a -> Bool;
check_poly_weak_anti_mono_discrete p v =
  check_poly_ge p
    (poly_subst
      (\ w -> poly_of (if w == v then PSum [PNum onea, PVar v] else PVar w)) p);

monom_vars ::
  forall a. (Ceq a, Ccompare a, Linorder a, Set_impl a) => Monom a -> Set a;
monom_vars m = set (monom_vars_list m);

check_poly_weak_anti_mono ::
  forall a b.
    (Ceq a, Ccompare a, Linorder a, Set_impl a,
      Ordered_semiring_0a b) => [(Monom a, b)] -> a -> Bool;
check_poly_weak_anti_mono p v =
  all (\ (m, c) -> less_eq c zerob || not (member v (monom_vars m))) p;

check_poly_weak_anti_mono_smart ::
  forall a b.
    (Ceq a, Ccompare a, Eq a, Linorder a, Set_impl a, Eq b,
      Poly_carrier b) => Bool -> [(Monom a, b)] -> a -> Bool;
check_poly_weak_anti_mono_smart discrete =
  (if discrete then check_poly_weak_anti_mono_discrete
    else check_poly_weak_anti_mono);

check_poly_weak_mono ::
  forall a b.
    (Ceq a, Ccompare a, Linorder a, Set_impl a,
      Ordered_semiring_0a b) => [(Monom a, b)] -> a -> Bool;
check_poly_weak_mono p v =
  all (\ (m, c) -> less_eq zerob c || not (member v (monom_vars m))) p;

check_poly_weak_mono_smart ::
  forall a b.
    (Ceq a, Ccompare a, Eq a, Linorder a, Set_impl a, Eq b,
      Poly_carrier b) => Bool -> [(Monom a, b)] -> a -> Bool;
check_poly_weak_mono_smart discrete =
  (if discrete then check_poly_weak_mono_discrete else check_poly_weak_mono);

create_dep ::
  forall a b.
    (Eq a, Poly_carrier a, Compare_order b,
      Eq b) => Bool ->
                 a -> [((b, Nat), [(Monom Nat, a)])] ->
                        (b, Nat) -> Nat -> Dependance;
create_dep discrete def i =
  let {
    fs = remdups (map fst i);
    ii = poly_inter_list_to_inter def i;
    fsres =
      map (\ fn ->
            let {
              p = ii fn;
              vars = poly_vars_list p;
              is = upt zero_nat (snd fn);
              a = map (\ ia ->
                        (if membera vars ia
                          then (if check_poly_weak_mono_smart discrete p ia
                                 then Increase
                                 else (if check_poly_weak_anti_mono_smart
    discrete p ia
then Decrease else Wild))
                          else Ignore))
                    is;
            } in (fn, a))
        fs;
    iii = fun_of_map_funa (ceta_map_of fsres) (\ _ _ -> Increase) nth;
  } in iii;

create_nlpoly_non_inf_order ::
  forall a b c.
    (Eq a, Poly_carrier a, Showl a, Compare_order b, Eq b, Showl b, Eq c,
      Linorder c,
      Showl c) => Sum (String -> String) () ->
                    a -> (a -> a -> Bool) ->
                           Bool ->
                             Bool ->
                               (a -> [a]) ->
                                 [((b, Nat), [(Monom Nat, a)])] ->
                                   [(b, Nat)] -> Non_inf_order_ext b c ();
create_nlpoly_non_inf_order cI def gt power_mono discrete sqrt i f =
  let {
    j = poly_inter_list_to_inter def i;
    x = poly_subst
          (\ n ->
            poly_of
              (PVar ([char_0x78, char_0x5F] ++ shows_prec_nat zero_nat n [])));
  } in Non_inf_order_ext
         (bindb cI
           (\ _ ->
             catch_errora (check_non_inf_poly_inter_list discrete f i)
               (\ xa ->
                 Inl (case xa of {
                       (fa, p) ->
                         (((showsl_literal "interpretation " .
                             showsl_poly (x p)) .
                            showsl_literal " of ") .
                           showsl fa) .
                           showsl_literal " invalid ";
                     }))))
         (check_ns j) (check_cc sqrt gt j) (create_dep discrete def i)
         (showsl_literal "polynomial interpretation\n" .
           showsl_sep
             (\ (a, b) ->
               (case a of {
                 (fa, n) ->
                   (\ p ->
                     ((((showsl_literal "Pol(" . showsl fa) .
                         showsl_literal "/") .
                        showsl_nat n) .
                       showsl_literal ") = ") .
                       showsl_poly (x p));
               })
                 b)
             (showsl_literal "\n") i)
         ();

delta_gt :: forall a. (Floor_ceiling a) => a -> a -> a -> Bool;
delta_gt delta = (\ x y -> less_eq delta (minusa x y));

check_def_pos :: forall a. (Zero a, Ord a) => a -> Sum (String -> String) ();
check_def_pos d =
  check (less zerob d) (showsl_lit "default value must be positive");

sqrt_rat :: Rat -> [Rat];
sqrt_rat x =
  (case quotient_of x of {
    (z, n) ->
      (case sqrt_int n of {
        [] -> [];
        sn : _ -> map (\ sz -> divide_rat (of_int sz) (of_int sn)) (sqrt_int z);
      });
  });

get_non_inf_order ::
  forall a b.
    (Compare_order a, Eq a, Showl a, Eq b, Linorder b,
      Showl b) => Redtriple_impl a -> [(a, Nat)] -> Non_inf_order_ext a b ();
get_non_inf_order (Int_nl_carrier i) =
  create_nlpoly_non_inf_order (Inr ()) one_int (\ x y -> less_int y x) True True
    sqrt_int i;
get_non_inf_order (Rat_nl_carrier d i) =
  create_nlpoly_non_inf_order (check_def_pos d) d (delta_gt d)
    (less_eq_rat one_rat d) False sqrt_rat i;
get_non_inf_order (Real_nl_carrier d i) =
  create_nlpoly_non_inf_order (check_def_pos d) d (delta_gt d)
    (less_eq_real one_real d) False sqrt_real i;
get_non_inf_order (Int_carrier v) =
  faulty_non_inf_order
    "only integers, rationals and reals are supported for non-inf orders";
get_non_inf_order (Neg_Integer_Poly v) =
  faulty_non_inf_order
    "only integers, rationals and reals are supported for non-inf orders";
get_non_inf_order (Rat_carrier v) =
  faulty_non_inf_order
    "only integers, rationals and reals are supported for non-inf orders";
get_non_inf_order (Real_carrier v) =
  faulty_non_inf_order
    "only integers, rationals and reals are supported for non-inf orders";
get_non_inf_order (Arctic_carrier v) =
  faulty_non_inf_order
    "only integers, rationals and reals are supported for non-inf orders";
get_non_inf_order (Arctic_rat_carrier v) =
  faulty_non_inf_order
    "only integers, rationals and reals are supported for non-inf orders";
get_non_inf_order (Int_mat_carrier v va vb) =
  faulty_non_inf_order
    "only integers, rationals and reals are supported for non-inf orders";
get_non_inf_order (Rat_mat_carrier v va vb) =
  faulty_non_inf_order
    "only integers, rationals and reals are supported for non-inf orders";
get_non_inf_order (Real_mat_carrier v va vb) =
  faulty_non_inf_order
    "only integers, rationals and reals are supported for non-inf orders";
get_non_inf_order (Core_matrix v) =
  faulty_non_inf_order
    "only integers, rationals and reals are supported for non-inf orders";
get_non_inf_order (Core_matrix_delta v va) =
  faulty_non_inf_order
    "only integers, rationals and reals are supported for non-inf orders";
get_non_inf_order (Arctic_mat_carrier v va) =
  faulty_non_inf_order
    "only integers, rationals and reals are supported for non-inf orders";
get_non_inf_order (Arctic_rat_mat_carrier v va) =
  faulty_non_inf_order
    "only integers, rationals and reals are supported for non-inf orders";
get_non_inf_order (RPO v va) =
  faulty_non_inf_order
    "only integers, rationals and reals are supported for non-inf orders";
get_non_inf_order (KBO v va) =
  faulty_non_inf_order
    "only integers, rationals and reals are supported for non-inf orders";
get_non_inf_order (ACKBO v va) =
  faulty_non_inf_order
    "only integers, rationals and reals are supported for non-inf orders";
get_non_inf_order (WPO v va) =
  faulty_non_inf_order
    "only integers, rationals and reals are supported for non-inf orders";
get_non_inf_order (GWPO v va) =
  faulty_non_inf_order
    "only integers, rationals and reals are supported for non-inf orders";
get_non_inf_order (MSPO v) =
  faulty_non_inf_order
    "only integers, rationals and reals are supported for non-inf orders";
get_non_inf_order (COWPO v va) =
  faulty_non_inf_order
    "only integers, rationals and reals are supported for non-inf orders";
get_non_inf_order (Max_poly v) =
  faulty_non_inf_order
    "only integers, rationals and reals are supported for non-inf orders";
get_non_inf_order (Max_monus v) =
  faulty_non_inf_order
    "only integers, rationals and reals are supported for non-inf orders";
get_non_inf_order (Filtered_Redtriple v va) =
  faulty_non_inf_order
    "only integers, rationals and reals are supported for non-inf orders";
get_non_inf_order (SCNP v va vb) =
  faulty_non_inf_order
    "only integers, rationals and reals are supported for non-inf orders";

all_terms_impl ::
  forall a.
    (Compare_order a,
      Eq a) => [(Term a [Char], Term a [Char])] ->
                 [([Term a [Char]],
                    (Term a [Char], (Term a [Char], Term a [Char])))] ->
                   [([Term a [Char]], Term a [Char])];
all_terms_impl rr initt =
  remdups
    (map (\ (ss, (t, _)) -> (ss, t)) initt ++ map (\ (l, a) -> (args l, a)) rr);

all_subterms_impl ::
  forall a.
    (Compare_order a,
      Eq a) => [(Term a [Char], Term a [Char])] ->
                 [([Term a [Char]],
                    (Term a [Char], (Term a [Char], Term a [Char])))] ->
                   [([Term a [Char]], Term a [Char])];
all_subterms_impl rr initt =
  remdups
    (concatMap (\ (ss, s) -> map (\ a -> (ss, a)) (supteq_list s))
      (all_terms_impl rr initt));

everything_impl ::
  forall a.
    (Compare_order a,
      Eq a) => [(Term a [Char], Term a [Char])] ->
                 [([Term a [Char]],
                    (Term a [Char], (Term a [Char], Term a [Char])))] ->
                   [Sum ([Term a [Char]],
                          (Term a [Char], (Term a [Char], Term a [Char])))
                      ((a, Nat), Nat)];
everything_impl rr initt =
  map Inl
    (concatMap
      (\ (ss, t) ->
        map (\ lr -> (ss, (t, lr))) (remdups (map (snd . snd) initt)))
      (all_subterms_impl rr initt)) ++
    remdups
      (map Inr
        (concatMap
          (\ t ->
            (if not (is_Var t)
              then concatMap
                     (\ (f, ts) ->
                       map (\ a -> ((f, size_list ts), a))
                         (upt zero_nat (size_list ts)))
                     (case t of {
                       Fun f ts -> [(f, ts)];
                     })
              else []))
          (remdups (map snd (all_subterms_impl rr initt)))));

generate_impl ::
  forall a b c d.
    (Compare_order a, Eq a, Eq b,
      Eq c) => [(Term a [Char], Term a [Char])] ->
                 (Term a [Char] -> Bool) ->
                   ([Term a [Char]] ->
                     Term a [Char] -> Term a (Sum () [Char])) ->
                     ([Term a [Char]] -> Term a [Char] -> [(b, c)]) ->
                       Sum ([Term a [Char]], (Term a [Char], (b, c))) d ->
                         [Sum ([Term a [Char]], (Term a [Char], (b, c)))
                            ((a, Nat), Nat)];
generate_impl rr nfq e_cap uu (Inl (ss, (Fun f ts, (l, r)))) =
  concatMap
    (\ i ->
      (if membera (uu ss (nth ts i)) (l, r)
        then map (\ u -> u)
               [Inl (ss, (nth ts i, (l, r))), Inr ((f, size_list ts), i)]
        else []))
    (upt zero_nat (size_list ts)) ++
    concatMap
      (\ (la, ra) ->
        concatMap
          (\ mss ->
            (if rule_match_impl nfq (e_cap mss) mss f
                  (map (map_term (\ x -> x) (\ a -> char_0x78 : a)) ts) la
              then (if membera (uu (args la) ra) (l, r)
                     then [Inl (args la, (ra, (l, r)))] else [])
              else []))
          [map (map_term (\ x -> x) (\ a -> char_0x78 : a)) ss])
      rr;
generate_impl rr nfq e_cap uu (Inl (va, (Var ve, vd))) = [];
generate_impl rr nfq e_cap uu (Inr v) = [];

new_as :: forall a b. (a -> b -> Bool) -> [a] -> [b] -> [b];
new_as p bs asa = filter (\ a -> any (\ b -> p b a) bs) asa;

list_diff :: forall a. (Eq a) => [a] -> [a] -> [a];
list_diff [] ys = [];
list_diff (x : xs) ys = let {
                          zs = list_diff xs ys;
                        } in (if membera ys x then zs else x : zs);

the_set_impl_main ::
  forall a b.
    (Eq a, Eq b) => (a -> b -> Bool) -> (b -> [a]) -> [b] -> [b] -> [a] -> [b];
the_set_impl_main p q remain have bs =
  let {
    new = new_as p bs remain;
  } in (if null new then have
         else the_set_impl_main p q (list_diff remain new) (new ++ have)
                (remdups (concatMap q new)));

the_set_impl ::
  forall a b.
    (Eq a, Eq b) => [a] -> (b -> a -> Bool) -> (a -> [b]) -> [b] -> [a];
the_set_impl r p q bs = the_set_impl_main p q r [] bs;

inductive_set_impl ::
  forall a b.
    (Eq a, Eq b) => [a] -> (b -> a -> Bool) -> (a -> [b]) -> [b] -> [a];
inductive_set_impl = the_set_impl;

mu_approx_impl ::
  forall a.
    (Compare_order a,
      Eq a) => [(Term a [Char], Term a [Char])] ->
                 [([Term a [Char]],
                    (Term a [Char], (Term a [Char], Term a [Char])))] ->
                   ([Term a [Char]] ->
                     Term a [Char] -> [(Term a [Char], Term a [Char])]) ->
                     (Term a [Char] -> Bool) ->
                       ([Term a [Char]] ->
                         Term a [Char] -> Term a (Sum () [Char])) ->
                         ([(a, Nat)], ((a, Nat) -> Set Nat, String));
mu_approx_impl rr initt u_impl nfq e_cap =
  let {
    uu = precompute_fun (\ (a, b) -> u_impl a b) (all_subterms_impl rr initt);
    uua = (\ s t -> uu (s, t));
    fis = remdups
            (concatMap (\ entry -> map (\ fi -> fi) (case entry of {
              Inl _ -> [];
              Inr fi -> [fi];
            }))
              (inductive_set_impl (everything_impl rr initt) equal_sum
                (generate_impl rr nfq e_cap uua) (map Inl initt)));
    fs = remdups (map fst fis);
    mu = (\ f ->
           set (map_filter
                 (\ x ->
                   (if (case x of {
                         (g, _) -> g == f;
                       })
                     then Just (snd x) else Nothing))
                 fis));
  } in (fs, (precompute_fun mu fs, "innermost URM wrt. specific rules"));

inn_usable_rules_wf ::
  forall a.
    (Compare_order a,
      Eq a) => (Term a [Char] -> Bool) ->
                 ([Term a [Char]] -> Term a [Char] -> Term a (Sum () [Char])) ->
                   [(Term a [Char], Term a [Char])] ->
                     Bool ->
                       ([Term a [Char]], Term a [Char]) ->
                         [(Term a [Char], Term a [Char])];
inn_usable_rules_wf nfq e_cap r nfs =
  (\ (ss, t) ->
    (if nfs ||
          all (\ x -> any (contains_var_term x) ss) (remdups (vars_term_list t))
      then ur_calc_singleton nfq e_cap r (ss, t) else r));

inn_usable_rules_wf_dpp ::
  forall a b.
    (Compare_order b,
      Eq b) => Dpp_ops_ext a b [Char] () ->
                 a -> Bool ->
                        ([Term b [Char]], Term b [Char]) ->
                          [(Term b [Char], Term b [Char])];
inn_usable_rules_wf_dpp i d nfs =
  inn_usable_rules_wf (is_QNFc i d) (icap_impl_dpp i d) (rulesf i d) nfs;

get_innermost_strict_repl_map_dpp ::
  forall a b.
    (Compare_order b,
      Eq b) => Dpp_ops_ext a b [Char] () ->
                 a -> [(Term b [Char], Term b [Char])] ->
                        ([(b, Nat)], ((b, Nat) -> Set Nat, String));
get_innermost_strict_repl_map_dpp i d s =
  let {
    r = rulesf i d;
    p = pairsb i d;
    isNF = is_QNFc i d;
    u = inn_usable_rules_wf_dpp i d True;
    a = icap_impl_dpp i d;
  } in mu_approx_impl r
         (concatMap (\ (sa, t) -> map (\ lr -> ([sa], (t, lr))) s) p)
         (\ ss t -> u (ss, t)) isNF a;

split_rulesc ::
  forall a b c d.
    Dpp_ops_ext a b c d ->
      a -> [(Term b c, Term b c)] ->
             ([(Term b c, Term b c)], [(Term b c, Term b c)]);
split_rulesc
  (Dpp_ops_ext dpp p pw pairs q r rw rules q_empty rules_no_left_var
    rules_non_collapsing is_QNF nFQ_subset_NF_rules rules_map reverse_rules_map
    intersect_pairs replace_pair intersect_rules delete_P_Pw delete_R_Rw
    split_pairs split_rules mk minimal nfs wwf_rules more)
  = split_rules;

showsl_position_set :: forall a. (a, Nat) -> Set Nat -> String -> String;
showsl_position_set f s =
  showsl_list_nat
    (concatMap (\ i -> (if member i s then [suc i] else []))
      (upt zero_nat (snd f)));

rel_impl_redpair ::
  forall a b. Rel_impl_ext a b () -> Sum (String -> String) ();
rel_impl_redpair ri =
  catch_errora
    (bindb (valid ri)
      (\ _ ->
        bindb (standard ri)
          (\ _ ->
            bindb (catch_errora (sn ri)
                    (\ x ->
                      Inl (x . showsl_lit
                                 "\nproblem in ensuring strong normalization of relation")))
              (\ _ ->
                catch_errora (subst_s ri)
                  (\ x ->
                    Inl (x . showsl_lit
                               "\nproblem in ensuring stability of strict relation"))))))
    (\ x -> Inl (showsl_lit "problem with being a reduction pair\n" . x));

mono_af :: forall a b c. Rel_impl_ext a b c -> (a, Nat) -> Set Nat;
mono_af
  (Rel_impl_ext valid standard desc s ns nst af top_af sn subst_s ce_compat
    co_rewr top_mono top_refl mono_af mono not_wst not_sst cpx more)
  = mono_af;

check_wf_trs ::
  forall a b.
    (Showl a, Eq b,
      Showl b) => [(Term a b, Term a b)] -> Sum (String -> String) ();
check_wf_trs r =
  catch_errora
    (bindb (check_varcond_no_Var_lhs r) (\ _ -> check_varcond_subset r))
    (\ x -> Inl (showsl_literal "the TRS is not well-formed\n" . x));

mono_urm_redpair_proc ::
  forall a b.
    (Compare_order b, Eq b,
      Showl b) => Dpp_ops_ext a b [Char] () ->
                    Rel_impl_ext b [Char] () ->
                      [(Term b [Char], Term b [Char])] ->
                        [(Term b [Char], Term b [Char])] ->
                          a -> Sum (String -> String) a;
mono_urm_redpair_proc i rp premove rremove dpp =
  (case catch_errora
          (case split_pairsa i dpp premove of {
            (ps, pns) ->
              (case split_rulesc i dpp rremove of {
                (rs, rns) ->
                  let {
                    r = rulesf i dpp;
                    _ = qc i dpp;
                    p = pairsb i dpp;
                  } in bindb (check_wf_trs p)
                         (\ _ ->
                           bindb (check_wf_trs r)
                             (\ _ ->
                               bindb (check (nFQ_subset_NF_rulesc i dpp)
                                       (showsl_lit "innermost required"))
                                 (\ _ ->
                                   (case get_innermost_strict_repl_map_dpp i dpp
   rs
                                     of {
                                     (fs, (mu, info)) ->
                                       bindb (rel_impl_redpair rp)
 (\ _ ->
   let {
     mua = mono_af rp;
   } in bindb (catch_errora
                (catch_errora
                  (forallM
                    (\ f ->
                      check (less_eq_set (mu f) (mua f))
                        (((((showsl_lit
                               "error in monotonicity: strict order for " .
                              showsl_prod f) .
                             showsl_lit " ensures monotonicity in positions ") .
                            showsl_position_set f (mua f)) .
                           showsl_lit "\nbut usable replacement map is ") .
                          showsl_position_set f (mu f)))
                    fs)
                  (\ x -> Inl (snd x)))
                (\ x ->
                  Inl (((((x . showsl_lit
                                 "\nthe computed usable replacement map (") .
                           showsl_literal info) .
                          showsl_lit ") is\n") .
                         showsl_sep
                           (\ f ->
                             ((showsl_lit "mu(" . showsl_prod f) .
                               showsl_lit ") = ") .
                               showsl_position_set f (mu f))
                           (showsl_literal "\n") fs) .
                        showsl_lit "\nand mu(f) = {} for all other symbols f")))
          (\ _ ->
            bindb (catch_errora (rel_impl_ns rp rns)
                    (\ x ->
                      Inl (showsl_lit "problem when orienting TRS\n" . x)))
              (\ _ ->
                bindb (catch_errora (rel_impl_s rp rs)
                        (\ x ->
                          Inl (showsl_lit "problem when orienting TRS\n" . x)))
                  (\ _ ->
                    bindb (catch_errora (rel_impl_ns rp pns)
                            (\ x ->
                              Inl (showsl_lit "problem when orienting DPs\n" .
                                    x)))
                      (\ _ ->
                        catch_errora (rel_impl_s rp ps)
                          (\ x ->
                            Inl (showsl_lit "problem when orienting DPs\n" .
                                  x)))))));
                                   }))));
              });
          })
          (\ x ->
            Inl (((showsl_lit
                     "could not apply the reduction pair processor with usable repl. maps and the following\n" .
                    desca rp) .
                   showsl_literal "\n") .
                  x))
    of {
    Inl a -> Inl a;
    Inr _ ->
      Inr (delete_R_Rwc i (delete_P_Pwa i dpp premove premove) rremove rremove);
  });

check_prop_rstep_rule ::
  forall a b.
    (Eq a, Showl a, Ccompare b, Eq b, Mapping_impl b,
      Showl b) => Bool ->
                    (Term a b -> Sum (String -> String) ()) ->
                      [Nat] ->
                        (Term a b, Term a b) ->
                          Term a b -> Term a b -> Sum (String -> String) ();
check_prop_rstep_rule nfs pa p rule s t =
  bindb (check (in_poss p s)
          (((showsl_pos p . showsl_literal " is not a position of ") .
             showsl_terma s) .
            showsl_literal "\n"))
    (\ _ ->
      bindb (check (in_poss p t)
              (((showsl_pos p . showsl_literal " is not a position of ") .
                 showsl_terma t) .
                showsl_literal "\n"))
        (\ _ ->
          let {
            c = ctxt_of_pos_term p s;
            d = ctxt_of_pos_term p t;
            u = subt_at s p;
            v = subt_at t p;
          } in (case match_list Var [(fst rule, u), (snd rule, v)] of {
                 Nothing ->
                   Inl ((((((showsl_literal "the term " . showsl_terma t) .
                             showsl_literal
                               " does not result from a proper application of rule\n") .
                            showsl_rule rule) .
                           showsl_literal " at position ") .
                          showsl_pos p) .
                         showsl_literal "\n");
                 Just tau ->
                   bindb (catch_errora
                           (forallM pa
                             (args u ++
                               (if nfs then map tau (vars_rule_list rule)
                                 else [])))
                           (\ x -> Inl (snd x)))
                     (\ _ ->
                       check (equal_actxt c d)
                         ((((((showsl_literal "the term " . showsl_terma t) .
                               showsl_literal
                                 " does not result from a proper application of rule\n") .
                              showsl_rule rule) .
                             showsl_literal " at position ") .
                            showsl_pos p) .
                           showsl_literal "\n"));
               })));

check_prop_rstep ::
  forall a b.
    (Eq a, Showl a, Ccompare b, Eq b, Mapping_impl b,
      Showl b) => Bool ->
                    (Term a b -> Sum (String -> String) ()) ->
                      [(Term a b, Term a b)] ->
                        [Nat] ->
                          (Term a b, Term a b) ->
                            Term a b -> Term a b -> Sum (String -> String) ();
check_prop_rstep nfs pa r p rule s t =
  check (any (\ ra ->
               eq_rule_mod_vars rule ra &&
                 isOK (check_prop_rstep_rule nfs pa p ra s t))
          r)
    ((((((((showsl_literal "the step from " . showsl_terma s) .
            showsl_literal " to ") .
           showsl_terma t) .
          showsl_literal " via rule ") .
         showsl_rule rule) .
        showsl_literal " at position ") .
       showsl_pos p) .
      showsl_literal " is problematic\n");

check_qrstep ::
  forall a b.
    (Eq a, Showl a, Ccompare b, Eq b, Mapping_impl b,
      Showl b) => (Term a b -> Bool) ->
                    Bool ->
                      [(Term a b, Term a b)] ->
                        [Nat] ->
                          (Term a b, Term a b) ->
                            Term a b -> Term a b -> Sum (String -> String) ();
check_qrstep nf nfs =
  check_prop_rstep nfs
    (\ t ->
      check (nf t)
        (showsl_terma t . showsl_literal " is not in Q-normal form"));

check_strict_one_rstep ::
  forall a b.
    (Eq a, Showl a, Ccompare b, Eq b, Mapping_impl b,
      Showl b) => [(Term a b, Term a b)] ->
                    ((Term a b, Term a b) ->
                      Maybe [([Nat], ((Term a b, Term a b), Term a b))]) ->
                      ((a, Nat) -> Nat) ->
                        (Term a b, Term a b) -> Sum (String -> String) ();
check_strict_one_rstep ra rseqm p r =
  let {
    s = proj_term p (fst r);
    t = proj_term p (snd r);
  } in (case rseqm r of {
         Nothing -> check_supt s t;
         Just [] ->
           Inl (showsl_lit "more than a single rewrite step is not allowed");
         Just [(pos, (rule, u))] ->
           bindb (check_qrstep (\ _ -> True) False ra pos rule s u)
             (\ _ -> check_supteq u t);
         Just ((_, (_, _)) : _ : _) ->
           Inl (showsl_lit "more than a single rewrite step is not allowed");
       });

check_rqrstep ::
  forall a b.
    (Eq a, Showl a, Ccompare b, Eq b, Mapping_impl b,
      Showl b) => (Term a b -> Bool) ->
                    Bool ->
                      [(Term a b, Term a b)] ->
                        (Term a b, Term a b) ->
                          Term a b -> Term a b -> Sum (String -> String) ();
check_rqrstep nf nfs r rule s t = check_qrstep nf nfs r [] rule s t;

check_qsteps ::
  forall a b.
    (Eq a, Showl a, Ccompare b, Eq b, Mapping_impl b,
      Showl b) => (Term a b -> Bool) ->
                    Bool ->
                      [(Term a b, Term a b)] ->
                        [(Term a b, Term a b)] ->
                          [([Nat], ((Term a b, Term a b), (Bool, Term a b)))] ->
                            Term a b -> Term a b -> Sum (String -> String) ();
check_qsteps nf nfs p r [] s u =
  check (equal_term s u)
    ((((showsl_literal "the last term of the rewrite sequence\n" .
         showsl_terma s) .
        showsl_literal "\ndoes not correspond to the goal term\n") .
       showsl_terma u) .
      showsl_literal "\n");
check_qsteps nf nfs p ra ((uu, (r, (True, t))) : prts) s u =
  bindb (check_rqrstep nf nfs p r s t)
    (\ _ -> check_qsteps nf nfs p ra prts t u);
check_qsteps nf nfs pa ra ((p, (r, (False, t))) : prts) s u =
  bindb (check_qrstep nf nfs ra p r s t)
    (\ _ -> check_qsteps nf nfs pa ra prts t u);

check_qrsteps ::
  forall a b.
    (Eq a, Showl a, Ccompare b, Eq b, Mapping_impl b,
      Showl b) => (Term a b -> Bool) ->
                    Bool ->
                      [(Term a b, Term a b)] ->
                        [([Nat], ((Term a b, Term a b), Term a b))] ->
                          Term a b -> Term a b -> Sum (String -> String) ();
check_qrsteps nf nfs r prts s u =
  check_qsteps nf nfs [] r (map (\ (p, (ra, t)) -> (p, (ra, (False, t)))) prts)
    s u;

check_rsteps ::
  forall a b.
    (Eq a, Showl a, Ccompare b, Eq b, Mapping_impl b,
      Showl b) => [(Term a b, Term a b)] ->
                    [([Nat], ((Term a b, Term a b), Term a b))] ->
                      Term a b -> Term a b -> Sum (String -> String) ();
check_rsteps = check_qrsteps (\ _ -> True) False;

rseq_last ::
  forall a b.
    Term a b -> [([Nat], ((Term a b, Term a b), Term a b))] -> Term a b;
rseq_last s steps = last (s : map (\ (_, (_, sa)) -> sa) steps);

check_rsteps_last ::
  forall a b.
    (Eq a, Showl a, Ccompare b, Eq b, Mapping_impl b,
      Showl b) => [(Term a b, Term a b)] ->
                    Term a b ->
                      [([Nat], ((Term a b, Term a b), Term a b))] ->
                        Sum (String -> String) ();
check_rsteps_last = (\ r s steps -> check_rsteps r steps s (rseq_last s steps));

check_strict_rstep ::
  forall a b.
    (Eq a, Showl a, Ccompare b, Eq b, Mapping_impl b,
      Showl b) => [(Term a b, Term a b)] ->
                    ((Term a b, Term a b) ->
                      Maybe [([Nat], ((Term a b, Term a b), Term a b))]) ->
                      ((a, Nat) -> Nat) ->
                        (Term a b, Term a b) -> Sum (String -> String) ();
check_strict_rstep ra rseqm p r =
  let {
    s = proj_term p (fst r);
    t = proj_term p (snd r);
  } in (case rseqm r of {
         Nothing -> check_supt s t;
         Just rseq ->
           (if equal_nat (size_list rseq) zero_nat then check_supt s t
             else bindb (check_rsteps_last ra s rseq)
                    (\ _ -> check_supteq (rseq_last s rseq) t));
       });

create_rseq_map ::
  forall a b.
    (Compare_order a,
      Compare_order b) => [((Term a b, Term a b),
                             [([Nat], ((Term a b, Term a b), Term a b))])] ->
                            (Term a b, Term a b) ->
                              Maybe [([Nat], ((Term a b, Term a b), Term a b))];
create_rseq_map rseqs = ceta_map_of rseqs;

create_proj :: forall a. (Compare_order a) => ProjL a -> (a, Nat) -> Nat;
create_proj (Projection p) = let {
                               i = ceta_map_of p;
                             } in (\ f -> (case i f of {
    Nothing -> zero_nat;
    Just n -> n;
  }));

check_weak ::
  forall a b.
    (Eq a, Showl a, Eq b,
      Showl b) => ((a, Nat) -> Nat) ->
                    (Term a b, Term a b) -> Sum (String -> String) ();
check_weak p r =
  catch_errora
    (check (equal_term (proj_term p (fst r)) (proj_term p (snd r)))
      (showsl_lit "the projected lhs is not equal to the projected rhs\n"))
    (\ x ->
      Inl (((((((showsl_lit "Could not orient rule " . showsl_rule r) .
                 showsl_lit ", since\n") .
                showsl_terma (proj_term p (fst r))) .
               showsl_lit " != ") .
              showsl_terma (proj_term p (snd r))) .
             showsl_literal "\n") .
            x));

wf_rules_impl ::
  forall a b. (Eq b) => [(Term a b, Term a b)] -> [(Term a b, Term a b)];
wf_rules_impl r = filter wf_rule r;

subterm_criterion_proc ::
  forall a b c.
    (Compare_order b, Eq b, Showl b, Ccompare c, Compare_order c, Eq c,
      Mapping_impl c,
      Showl c) => Dpp_ops_ext a b c () ->
                    ProjL b ->
                      [((Term b c, Term b c),
                         [([Nat], ((Term b c, Term b c), Term b c))])] ->
                        [(Term b c, Term b c)] -> a -> Sum (String -> String) a;
subterm_criterion_proc i pL rseqmL prm dpp =
  (case let {
          p = create_proj pL;
          rseqm = create_rseq_map rseqmL;
          pa = pairsb i dpp;
          _ = nfsc i dpp;
          r = rulesf i dpp;
          pb = snd (split_pairsa i dpp prm);
          wfR = wf_rules_impl r;
        } in bindb (catch_errora
                     (forallM
                       (\ (l, ra) ->
                         bindb (check_no_var l)
                           (\ _ ->
                             bindb (check_no_var ra)
                               (\ _ ->
                                 check_no_defined_root
                                   (\ fn -> not (null (rules_mapc i dpp fn)))
                                   ra)))
                       pa)
                     (\ x -> Inl (snd x)))
               (\ _ ->
                 bindb (check (minimal i dpp || nFQ_subset_NF_rulesc i dpp)
                         (showsl_lit "minimality or innermost required"))
                   (\ _ ->
                     bindb (catch_errora
                             (forallM (\ (l, _) -> check_no_var l) r)
                             (\ x -> Inl (snd x)))
                       (\ _ ->
                         bindb (if q_emptyc i dpp
                                 then catch_errora
(forallM (check_strict_rstep r rseqm p) prm) (\ x -> Inl (snd x))
                                 else catch_errora
(forallM (check_strict_one_rstep wfR rseqm p) prm) (\ x -> Inl (snd x)))
                           (\ _ ->
                             catch_errora (forallM (check_weak p) pb)
                               (\ x -> Inl (snd x))))))
    of {
    Inl a -> Inl a;
    Inr _ -> Inr (delete_P_Pwa i dpp prm prm);
  });

replace_paira ::
  forall a b c d.
    Dpp_ops_ext a b c d ->
      a -> (Term b c, Term b c) -> [(Term b c, Term b c)] -> a;
replace_paira
  (Dpp_ops_ext dpp p pw pairs q r rw rules q_empty rules_no_left_var
    rules_non_collapsing is_QNF nFQ_subset_NF_rules rules_map reverse_rules_map
    intersect_pairs replace_pair intersect_rules delete_P_Pw delete_R_Rw
    split_pairs split_rules mk minimal nfs wwf_rules more)
  = replace_pair;

forward_instantiation_proc ::
  forall a b.
    (Compare_order b, Eq b,
      Showl b) => Dpp_ops_ext a b [Char] () ->
                    (Term b [Char], Term b [Char]) ->
                      [(Term b [Char], Term b [Char])] ->
                        Maybe [(Term b [Char], Term b [Char])] ->
                          a -> Sum (String -> String) a;
forward_instantiation_proc i st sts u_opt dpp =
  (case let {
          isnf = is_QNFc i dpp;
        } in (case st of {
               (s, t) ->
                 let {
                   iedg = is_iedg_edge_dpp i dpp (s, t);
                   sy = map_term (\ x -> x) (\ a -> char_0x79 : a) s;
                   ty = map_term (\ x -> x) (\ a -> char_0x79 : a) t;
                   u = (case u_opt of {
                         Nothing -> rulesf i dpp;
                         Just u -> u;
                       });
                 } in bindb (if is_none u_opt then Inr ()
                              else let {
                                     urc = is_ur_closed_impl_dpp_mv i dpp u;
                                     check_urc =
                                       (\ sa ta ->
 check (urc sa ta)
   ((showsl_lit "term " . showsl_terma ta) .
     showsl_lit " is not closed under usable rules"));
                                   } in bindb
  (check (nfsc i dpp || minimal i dpp)
    (showsl_lit "minimality or normal subst required"))
  (\ _ ->
    bindb (check (nFQ_subset_NF_rulesc i dpp)
            (showsl_lit "innermost rewriting required"))
      (\ _ ->
        bindb (catch_errora (forallM (\ (l, a) -> check_urc (args l) a) u)
                (\ x -> Inl (snd x)))
          (\ _ ->
            bindb (check_urc [s] t)
              (\ _ ->
                (if nfsc i dpp then Inr ()
                  else catch_errora
                         (check_subseteq (vars_term_list t) (vars_term_list s))
                         (\ _ ->
                           Inl (showsl_lit
                                 "variable condition in pair violated"))))))))
                        (\ _ ->
                          let {
                            ur = map (\ (l, r) -> (r, l)) u;
                            ic = icap_impl (is_NF_terms []) ur [];
                          } in catch_errora
                                 (forallM
                                   (\ (ua, v) ->
                                     (case mgu_class (ic ua) t of {
                                       Nothing -> Inr ();
                                       Just mu ->
 check (not (isnf (eval_term Fun sy mu)) ||
         (not (isnf (eval_term Fun
                      (map_term (\ x -> x) (\ a -> char_0x78 : a) ua) mu)) ||
           any (\ sta ->
                 instance_rule sta st &&
                   instance_rule (eval_term Fun sy mu, eval_term Fun ty mu) sta)
             sts))
   (((showsl_lit "could not find instance of pair " .
       showsl_rule (eval_term Fun sy mu, eval_term Fun ty mu)) .
      showsl_lit "\nwhich resulted from DP ") .
     showsl_rule (ua, v));
                                     }))
                                   (filter (\ (ua, _) -> iedg ua)
                                     (pairsb i dpp)))
                                 (\ x -> Inl (snd x)));
             })
    of {
    Inl a -> Inl a;
    Inr _ -> Inr (replace_paira i dpp st sts);
  });

filter_prec_weight_ac_repr ::
  forall a.
    ((a, Nat) -> Af_entry) ->
      ([((a, Nat), (Nat, (Nat, Bool)))], Nat) ->
        ([((Filtered a, Nat), (Nat, (Nat, Bool)))], Nat);
filter_prec_weight_ac_repr pi (prw, w0) =
  let {
    fprw = filter (\ (fn, _) -> (case pi fn of {
                                  Collapse _ -> False;
                                  AFList _ -> True;
                                }))
             prw;
    mprw =
      map (\ (a, b) ->
            (case a of {
              (f, n) ->
                (\ aa -> ((FPair f n, (case pi (f, n) of {
Collapse _ -> zero_nat;
AFList ab -> size_list ab;
                                      })),
                           aa));
            })
              b)
        fprw;
  } in (mprw, w0);

filter_prec_weight_repr ::
  forall a.
    ((a, Nat) -> Af_entry) ->
      ([((a, Nat), (Nat, (Nat, Maybe [Nat])))], Nat) ->
        ([((Filtered a, Nat), (Nat, (Nat, Maybe [Nat])))], Nat);
filter_prec_weight_repr pi (prw, w0) =
  let {
    fprw = filter (\ (fn, _) -> (case pi fn of {
                                  Collapse _ -> False;
                                  AFList _ -> True;
                                }))
             prw;
    mprw =
      map (\ (a, b) ->
            (case a of {
              (f, n) ->
                (\ aa -> ((FPair f n, (case pi (f, n) of {
Collapse _ -> zero_nat;
AFList ab -> size_list ab;
                                      })),
                           aa));
            })
              b)
        fprw;
  } in (mprw, w0);

prec_repr_to_status ::
  forall a.
    (Compare_order a) => [((a, Nat), (Nat, Order_tag))] ->
                           (Filtered a, Nat) -> Order_tag;
prec_repr_to_status prs = let {
                            m = ceta_map_of prs;
                          } in (\ (FPair f a, _) -> (case m (f, a) of {
              Nothing -> Lex;
              Just aa -> snd aa;
            }));

prec_repr_to_pr ::
  forall a.
    (Compare_order a) => [((a, Nat), (Nat, Order_tag))] ->
                           (Filtered a, Nat) -> Nat;
prec_repr_to_pr prs = let {
                        m = ceta_map_of prs;
                      } in (\ (FPair f a, _) -> (case m (f, a) of {
          Nothing -> zero_nat;
          Just aa -> fst aa;
        }));

poly_convert ::
  forall a b.
    (Eq a, Linorder a, Eq b,
      Poly_carriera b) => [(Monom a, b)] -> [(Monom a, b)];
poly_convert p = poly_subst (\ v -> [(var_monom v, uminus onea)]) p;

check_poly_weak_mono_easy ::
  forall a b.
    (Eq a, Linorder a, Eq b, Poly_carriera b) => [(Monom a, b)] -> Bool;
check_poly_weak_mono_easy p =
  check_poly_weak_mono_all
    (monom_mult_poly (one_monom, uminus onea) (poly_convert p));

check_poly_neg_ge ::
  forall a b.
    (Eq a, Linorder a, Eq b,
      Poly_carriera b) => [(Monom a, b)] -> [(Monom a, b)] -> Bool;
check_poly_neg_ge p q = let {
                          pa = poly_convert p;
                          a = poly_convert q;
                        } in check_poly_ge pa a;

check_poly_weak_mono_and_neg ::
  forall a b.
    (Eq a, Linorder a, Eq b, Poly_carriera b) => [(Monom a, b)] -> Bool;
check_poly_weak_mono_and_neg p =
  check_poly_neg_ge zero_poly p && check_poly_weak_mono_easy p;

check_poly_inter_list_neg ::
  forall a b.
    (Eq a, Showl a, Eq b,
      Poly_carriera b) => [((a, Nat), [(Monom Nat, b)])] ->
                            Sum (String -> String) ();
check_poly_inter_list_neg i =
  bindb (check (distinct (map fst i))
          (showsl_literal "some symbol has two interpretations"))
    (\ _ ->
      catch_errora
        (catch_errora
          (forallM
            (\ x ->
              (if (case x of {
                    (_, a) -> check_poly_weak_mono_and_neg a;
                  })
                then Inr () else Inl x))
            i)
          (\ x -> Inl (snd x)))
        (\ x ->
          Inl (case x of {
                (a, b) ->
                  (case a of {
                    (f, _) ->
                      (\ _ ->
                        showsl_literal
                          "could not ensure weak-mono-, or neg.-property of interpretation of symbol " .
                          showsl f);
                  })
                    b;
              })));

mat_ge :: forall a. (Ord a) => Mat a -> Mat a -> Bool;
mat_ge a b =
  let {
    d = minus_nat (dim_row a) one_nat;
  } in (if less_nat d (dim_row a)
         then all_interval
                (\ i ->
                  let {
                    da = minus_nat (dim_col a) one_nat;
                  } in (if less_nat da (dim_col a)
                         then all_interval
                                (\ j ->
                                  less_eq (index_mat b (i, j))
                                    (index_mat a (i, j)))
                                zero_nat da
                         else True))
                zero_nat d
         else True);

check_valid_dims ::
  forall a b c.
    (Showl a, Zero b, Eq b, Ord b,
      Eq c) => Nat -> ((a, Nat), ([Mat b], Mat c)) -> Sum (String -> String) ();
check_valid_dims n =
  (\ (a, b) ->
    (case a of {
      (f, k) ->
        (\ (cs, c) ->
          bindb (check
                  (all (\ ca ->
                         member ca (carrier_mat n n) &&
                           mat_ge ca (zero_mat n n))
                    cs)
                  (showsl_literal "coefficients must be in N"))
            (\ _ ->
              bindb (check (member c (carrier_mat n n))
                      (showsl_literal
                        "wrong matrix dimension of constant part"))
                (\ _ ->
                  check (equal_nat (size_list cs) k)
                    ((showsl_literal "number of coefficient of symbol " .
                       showsl f) .
                      showsl_literal " differs from arity of symbol"))));
    })
      b);

check_lpoly_generic ::
  forall a b.
    (Ordered_ab_group_add a, Ordered_semiring_0 a, Ring_1 a, Zero_less_one a,
      Ordered_semiring_1a a) => Nat ->
                                  (Mat a -> Bool) -> L_poly b (Mat a) -> Bool;
check_lpoly_generic n cond (LPoly c cs) =
  cond c && all (\ xci -> mat_ge (snd xci) (zero_mat n n)) cs;

check_lpoly_N_P_I ::
  forall a b.
    (Ordered_ab_group_add a, Ordered_semiring_0 a, Ring_1 a, Zero_less_one a,
      Ordered_semiring_1a a) => Nat -> a -> [Nat] -> L_poly b (Mat a) -> Bool;
check_lpoly_N_P_I n delta il =
  check_lpoly_generic n
    (\ a ->
      mat_ge a (zero_mat n n) &&
        any (\ i -> any (\ j -> less_eq delta (index_mat a (i, j))) il) il);

oneE_I ::
  forall a.
    (Ordered_ab_group_add a, Ordered_semiring_0 a, Ring_1 a, Zero_less_one a,
      Ordered_semiring_1a a) => Nat -> Set Nat -> Mat a;
oneE_I n i =
  mat n n
    (\ (ia, j) -> (if equal_nat ia j && member ia i then onea else zerob));

check_lpoly_N_E_I ::
  forall a b.
    (Ordered_ab_group_add b, Ordered_semiring_0 b, Ring_1 b, Zero_less_one b,
      Ordered_semiring_1a b) => Nat -> Set Nat -> L_poly a (Mat b) -> Bool;
check_lpoly_N_E_I n i = check_lpoly_generic n (\ a -> mat_ge a (oneE_I n i));

showsl_l_poly ::
  forall a b. (Showl a, Showl b) => L_poly a b -> String -> String;
showsl_l_poly (LPoly c xcs) =
  showsl c .
    (if null xcs then id
      else showsl_lit " + " .
             showsl_sep (\ (x, ca) -> (showsl ca . showsl_lit " * ") . showsl x)
               (showsl_lit " + ") xcs);

show_core_matrix_inter_main ::
  forall a b c.
    (Showl a, Showl b,
      Showl c) => String ->
                    a -> [Nat] -> [((b, Nat), ([c], c))] -> String -> String;
show_core_matrix_inter_main mode d idx intr =
  (((((((showsl_lit "core matrix interpretation (mode = " . showsl_lit mode) .
         showsl_lit ") with dimension ") .
        showsl d) .
       showsl_lit " and strict indices I = ") .
      showsl_lista (map suc idx)) .
     showsl_lit " where\n") .
    showsl_sep
      (\ (a, b) ->
        (case a of {
          (f, n) ->
            (\ (cs, c) ->
              ((showsl_lit "[" .
                 showsl_terma
                   (Fun f
                     (map (\ i ->
                            Var ([char_0x78] ++ shows_prec_nat zero_nat i []))
                       (upt one_nat (suc n))))) .
                showsl_lit "] = ") .
                showsl_l_poly
                  (LPoly c
                    (zip (map (\ i ->
                                [char_0x78] ++ shows_prec_nat zero_nat i [])
                           (upt one_nat (suc n)))
                      cs)));
        })
          b)
      (showsl_lit "\n") intr) .
    showsl_lit
      "\nand\n[f(x1,..,xn)] = x1 + ... + xn + 1 for all other symbols f\n\n";

check_lpoly_N_N ::
  forall a b.
    (Ordered_ab_group_add b, Ordered_semiring_0 b, Ring_1 b, Zero_less_one b,
      Ordered_semiring_1a b) => Nat -> L_poly a (Mat b) -> Bool;
check_lpoly_N_N n = check_lpoly_generic n (\ a -> mat_ge a (zero_mat n n));

add_var ::
  forall a b c.
    (Eq a,
      Eq c) => Partial_object_ext a (Monoid_ext a (Ring_ext a b)) ->
                 c -> a -> [(c, a)] -> [(c, a)];
add_var r x a [] = [(x, a)];
add_var r x a ((y, b) : vas) =
  (if x == y then let {
                    s = add r a b;
                  } in (if s == zero r then vas else (x, s) : vas)
    else (y, b) : add_var r x a vas);

sum_pvars ::
  forall a b c.
    (Eq a,
      Eq c) => Partial_object_ext a (Monoid_ext a (Ring_ext a b)) ->
                 [(c, a)] -> [(c, a)] -> [(c, a)];
sum_pvars r [] vbs = vbs;
sum_pvars r ((x, a) : vas) vbs =
  (if a == zero r then sum_pvars r vas vbs
    else sum_pvars r vas (add_var r x a vbs));

sum_lpolya ::
  forall a b c.
    (Eq a,
      Eq c) => Partial_object_ext a (Monoid_ext a (Ring_ext a b)) ->
                 L_poly c a -> L_poly c a -> L_poly c a;
sum_lpolya r (LPoly a vas) (LPoly b vbs) =
  LPoly (add r a b) (sum_pvars r vas vbs);

sum_list_lpoly ::
  forall a b.
    (Eq a, Ordered_ab_group_add b, Eq b, Ordered_semiring_0 b, Ring_1 b,
      Zero_less_one b,
      Ordered_semiring_1a b) => Nat -> [L_poly a (Mat b)] -> L_poly a (Mat b);
sum_list_lpoly n =
  rec_list (LPoly (zero (ring_mat Type n ())) [])
    (\ x _ -> sum_lpolya (ring_mat Type n ()) x);

mul_pvars ::
  forall a b c.
    (Eq a) => Partial_object_ext a (Monoid_ext a (Ring_ext a b)) ->
                a -> [(c, a)] -> [(c, a)];
mul_pvars r a [] = [];
mul_pvars r a ((x, b) : vas) = let {
                                 p = mult r a b;
                                 res = mul_pvars r a vas;
                               } in (if p == zero r then res else (x, p) : res);

mul_lpoly ::
  forall a b c.
    (Eq a) => Partial_object_ext a (Monoid_ext a (Ring_ext a b)) ->
                a -> L_poly c a -> L_poly c a;
mul_lpoly r a (LPoly b vas) = LPoly (mult r a b) (mul_pvars r a vas);

subst_lpoly ::
  forall a b c.
    (Eq b, Ordered_ab_group_add c, Eq c, Ordered_semiring_0 c, Ring_1 c,
      Zero_less_one c,
      Ordered_semiring_1a c) => Nat ->
                                  (a -> L_poly b (Mat c)) ->
                                    L_poly a (Mat c) -> L_poly b (Mat c);
subst_lpoly n sigma (LPoly c cs) =
  sum_lpolya (ring_mat Type n ())
    (sum_list_lpoly n
      (map (\ (x, cx) -> mul_lpoly (ring_mat Type n ()) cx (sigma x)) cs))
    (LPoly c []);

var_lpoly ::
  forall a b c.
    Partial_object_ext a (Monoid_ext a (Ring_ext a b)) -> c -> L_poly c a;
var_lpoly r x = LPoly (zero r) [(x, one r)];

switchE_IN ::
  forall a b.
    (Eq a, Ordered_ab_group_add b, Eq b, Ordered_semiring_0 b, Ring_1 b,
      Zero_less_one b,
      Ordered_semiring_1a b) => Nat ->
                                  Set Nat ->
                                    L_poly a (Mat b) -> L_poly a (Mat b);
switchE_IN n i p =
  subst_lpoly n
    (\ x ->
      sum_lpolya (ring_mat Type n ()) (var_lpoly (ring_mat Type n ()) x)
        (LPoly (oneE_I n i) []))
    p;

uminus_mat :: forall a. (Uminus a) => Mat a -> Mat a;
uminus_mat a = mat (dim_row a) (dim_col a) (\ ij -> uminus (index_mat a ij));

sub_lpolya ::
  forall a b.
    (Eq a, Ordered_ab_group_add b, Eq b, Ordered_semiring_0 b, Ring_1 b,
      Zero_less_one b,
      Ordered_semiring_1a b) => Nat ->
                                  L_poly a (Mat b) ->
                                    L_poly a (Mat b) -> L_poly a (Mat b);
sub_lpolya n p q =
  sum_lpolya (ring_mat Type n ()) p
    (mul_lpoly (ring_mat Type n ()) (uminus_mat (one_mat n)) q);

alphap ::
  forall a b c.
    (Ordered_ab_group_add b, Eq b, Ordered_semiring_0 b, Ring_1 b,
      Zero_less_one b, Ordered_semiring_1a b,
      Eq c) => Nat ->
                 ((a, Nat) -> ([Mat b], Mat b)) ->
                   a -> [L_poly c (Mat b)] -> L_poly c (Mat b);
alphap n ii f lps =
  (case ii (f, size_list lps) of {
    (cs, c) ->
      sum_lpolya (ring_mat Type n ())
        (sum_list_lpoly n
          (map (\ (a, b) -> mul_lpoly (ring_mat Type n ()) a b) (zip cs lps)))
        (LPoly c []);
  });

poly_of_rule_N ::
  forall a b c.
    (Ordered_ab_group_add b, Eq b, Ordered_semiring_0 b, Ring_1 b,
      Zero_less_one b, Ordered_semiring_1a b,
      Eq c) => Nat ->
                 ((a, Nat) -> ([Mat b], Mat b)) ->
                   Set Nat -> (Term a c, Term a c) -> L_poly c (Mat b);
poly_of_rule_N n ii i (l, r) =
  switchE_IN n i
    (sub_lpolya n (eval_term (alphap n ii) l (var_lpoly (ring_mat Type n ())))
      (eval_term (alphap n ii) r (var_lpoly (ring_mat Type n ()))));

inter_lpoly ::
  forall a b.
    (Ordered_ab_group_add b, Eq b, Ordered_semiring_0 b, Ring_1 b,
      Zero_less_one b,
      Ordered_semiring_1a b) => Nat ->
                                  ((a, Nat) -> ([Mat b], Mat b)) ->
                                    (a, Nat) -> L_poly Nat (Mat b);
inter_lpoly n ii fk =
  (case ii fk of {
    (cs, c) ->
      sum_lpolya (ring_mat Type n ())
        (sum_list_lpoly n
          (map (\ (x, y) ->
                 mul_lpoly (ring_mat Type n ()) x
                   (var_lpoly (ring_mat Type n ()) y))
            (zip cs (upt zero_nat (size_list cs)))))
        (LPoly c []);
  });

inter_lpoly_N ::
  forall a b.
    (Ordered_ab_group_add b, Eq b, Ordered_semiring_0 b, Ring_1 b,
      Zero_less_one b,
      Ordered_semiring_1a b) => Nat ->
                                  ((a, Nat) -> ([Mat b], Mat b)) ->
                                    Set Nat -> (a, Nat) -> L_poly Nat (Mat b);
inter_lpoly_N n ii i = switchE_IN n i . inter_lpoly n ii;

default_II ::
  forall a b.
    (Ordered_ab_group_add a, Ordered_semiring_0 a, Ring_1 a, Zero_less_one a,
      Ordered_semiring_1a a) => Nat -> a -> (b, Nat) -> ([Mat a], Mat a);
default_II n delta fk =
  let {
    k = snd fk;
  } in (replicate k (one_mat n), smult_mat (plus delta onea) (one_mat n));

iI_list_to_II ::
  forall a b.
    (Ordered_ab_group_add a, Ordered_semiring_0 a, Ring_1 a, Zero_less_one a,
      Ordered_semiring_1a a,
      Eq b) => Nat ->
                 a -> [((b, Nat), ([Mat a], Mat a))] ->
                        (b, Nat) -> ([Mat a], Mat a);
iI_list_to_II n delta fk_cs fk = (case map_of fk_cs fk of {
                                   Nothing -> default_II n delta fk;
                                   Just i -> i;
                                 });

no_complexity_check :: forall a b. a -> b -> Sum (String -> String) ();
no_complexity_check =
  (\ _ _ -> Inl (showsl_literal "complexity analysis unsupported"));

core_EI_rel_impl ::
  forall a b c.
    (Ordered_ab_group_add a, Eq a, Ordered_semiring_0 a, Ring_1 a,
      Zero_less_one a, Ordered_semiring_1a a, Showl a, Eq b, Showl b, Eq c,
      Showl c) => Nat ->
                    a -> [Nat] ->
                           [((b, Nat), ([Mat a], Mat a))] ->
                             Rel_impl_ext b c ();
core_EI_rel_impl n delta i fk_cs =
  let {
    ii = iI_list_to_II n delta fk_cs;
    checkNS =
      (\ lr ->
        check (check_lpoly_N_N n (poly_of_rule_N n ii (set i) lr))
          (showsl_literal "could not weakly orient rule " . showsl_rule lr));
  } in Rel_impl_ext
         (bindb
           (check (less zerob delta) (showsl_literal "delta must be positive"))
           (\ _ ->
             bindb (check (all (\ ia -> less_nat ia n) i)
                     (showsl_literal
                       "indices in I must be below matrix dimension"))
               (\ _ ->
                 bindb (check (not (null i))
                         (showsl_literal "indices I must be non-empty"))
                   (\ _ ->
                     bindb (catch_errora (forallM (check_valid_dims n) fk_cs)
                             (\ x -> Inl (snd x)))
                       (\ _ ->
                         bindb (catch_errora
                                 (forallM
                                   (\ (fk, _) ->
                                     check (check_lpoly_N_E_I n (set i)
     (inter_lpoly_N n ii (set i) fk))
                                       ((showsl_literal
   "interpretation of symbol " .
  showsl (fst fk)) .
 showsl_literal " exceeds E-I carrier"))
                                   fk_cs)
                                 (\ x -> Inl (snd x)))
                           (\ _ ->
                             catch_errora
                               (forallM
                                 (\ (_, csc) ->
                                   check (all
   (\ a -> mat_ge a (oneE_I n (set i))) (fst csc))
                                     (showsl_literal
                                       " require monotone coefficient in E-I"))
                                 fk_cs)
                               (\ x -> Inl (snd x))))))))
         (Inr ()) (show_core_matrix_inter_main "E_I" n i fk_cs)
         (\ lr ->
           check (check_lpoly_N_P_I n delta i (poly_of_rule_N n ii (set i) lr))
             (showsl_literal "could not strictly orient rule " .
               showsl_rule lr))
         checkNS checkNS full_af full_af (Inr ()) (Inr ()) (Inr ()) (Inr ())
         (Inr ()) (Inr ()) (\ _ -> top_set) (\ _ -> Inr ()) Nothing Nothing
         no_complexity_check ();

core_EI_rel_impl_fract ::
  forall a b c.
    (Floor_ceiling a, Eq a, Showl a, Eq b, Showl b, Eq c,
      Showl c) => Nat ->
                    a -> [Nat] ->
                           [((b, Nat), ([Mat a], Mat a))] ->
                             Rel_impl_ext b c ();
core_EI_rel_impl_fract n delta = core_EI_rel_impl n delta;

check_carrier :: forall a. Nat -> Mat a -> Sum (String -> String) ();
check_carrier n m =
  bindb (check (equal_nat (dim_row m) n)
          (((showsl_lit "Expected " . showsl_nat n) .
             showsl_lit " rows in matrix, got ") .
            showsl_nat (dim_row m)))
    (\ _ ->
      check (equal_nat (dim_col m) n)
        (((showsl_lit "Expected " . showsl_nat n) .
           showsl_lit " columns in matrix, got ") .
          showsl_nat (dim_col m)));

check_N ::
  forall a.
    (Zero a, Ord a, Showl a) => Nat -> Mat a -> Sum (String -> String) ();
check_N n m =
  bindb (check_carrier n m)
    (\ _ ->
      check (let {
               d = minus_nat n one_nat;
             } in (if less_nat d n
                    then all_interval
                           (\ i ->
                             let {
                               da = minus_nat n one_nat;
                             } in (if less_nat da n
                                    then all_interval
   (\ j -> less_eq zerob (index_mat m (i, j))) zero_nat da
                                    else True))
                           zero_nat d
                    else True))
        (showsl_lit "Expected all matrix element to be non-negative: " .
          showsl_lista (mat_to_list m)));

check_coefficients_N ::
  forall a b.
    (Showl a, Zero b, Ord b,
      Showl b) => Nat ->
                    [Nat] ->
                      [((a, Nat), ([Mat b], Mat b))] ->
                        Sum (String -> String) ();
check_coefficients_N n ids fc =
  catch_errora
    (catch_errora
      (forallM
        (\ ((f, _), (cs, c)) ->
          catch_errora
            (catch_errora (forallM (check_N n) (c : cs)) (\ x -> Inl (snd x)))
            (\ x ->
              Inl (((showsl_lit
                       "Expected all interpretation coefficients of symbol " .
                      showsl f) .
                     showsl_lit " to be in N\n") .
                    x)))
        fc)
      (\ x -> Inl (snd x)))
    (\ x ->
      Inl (showsl_lit
             "Expected all interpretation coefficients of all function symbols used to be in N.\n" .
            x));

check_M_I ::
  forall a.
    (One a, Ord a,
      Showl a) => Nat -> [Nat] -> Mat a -> Sum (String -> String) ();
check_M_I n ids m =
  check (all (\ i -> any (\ j -> less_eq onea (index_mat m (i, j))) ids) ids)
    (showsl_lit
       "[M_I set] Expected at least one element element per row that is at least 1 " .
      showsl_lista (mat_to_list m));

check_coefficients_M_I ::
  forall a b.
    (Showl a, One b, Zero b, Ord b,
      Showl b) => Nat ->
                    [Nat] ->
                      [((a, Nat), ([Mat b], Mat b))] ->
                        Sum (String -> String) ();
check_coefficients_M_I n ids fc =
  bindb (check_coefficients_N n ids fc)
    (\ _ ->
      catch_errora
        (catch_errora
          (forallM
            (\ ((f, _), (cs, c)) ->
              bindb (catch_errora
                      (catch_errora (forallM (check_M_I n ids) cs)
                        (\ x -> Inl (snd x)))
                      (\ x ->
                        Inl (((showsl_lit
                                 "Expected all interpretation multiplicative coefficients of symbol " .
                                showsl f) .
                               showsl_lit " to be in M_I.\n") .
                              x)))
                (\ _ ->
                  check (any (\ ci -> isOK (check_M_I n ids ci)) (c : cs))
                    ((((showsl_lit "Expected the constant coefficient " .
                         showsl_lista (mat_to_list c)) .
                        showsl_lit " of symbol ") .
                       showsl f) .
                      showsl_lit
                        " to be in M_I whenever there are no multiplicative coefficient (i.e. symbol of arity 0).")))
            fc)
          (\ x -> Inl (snd x)))
        (\ x ->
          Inl (showsl_lit
                 "Expected all interpretation multiplicative coeffs to be in M_I\n and the constant coeff to be in M_I whenever there are none multiplicative coeffs, for all function symbols.\n" .
                x)));

check_coeffs_length ::
  forall a b c.
    (Showl a) => [((a, Nat), ([Mat b], Mat c))] -> Sum (String -> String) ();
check_coeffs_length fc =
  catch_errora
    (catch_errora
      (forallM
        (\ ((f, n), (cs, _)) ->
          check (equal_nat (size_list cs) n)
            (((((showsl_lit
                   "Expected as many multiplicative coefficients as the arity of " .
                  showsl f) .
                 showsl_lit ". Got ") .
                showsl_nat (size_list cs)) .
               showsl_lit " instead of ") .
              showsl_nat n))
        fc)
      (\ x -> Inl (snd x)))
    (\ x ->
      Inl (showsl_lit
             "The number of interpretation coefficients (multiplicative, i.e. not the constant coefficient)\n should always match the arity of the corresponding function symbol.\n" .
            x));

check_coeffs_M_I_final ::
  forall a b.
    (Showl a, One b, Zero b, Ord b,
      Showl b) => Nat ->
                    [Nat] ->
                      [((a, Nat), ([Mat b], Mat b))] ->
                        Sum (String -> String) ();
check_coeffs_M_I_final n ids fc =
  bindb (check_coeffs_length fc)
    (\ _ ->
      bindb (check_coefficients_N n ids fc)
        (\ _ -> check_coefficients_M_I n ids fc));

check_E_I ::
  forall a.
    (One a, Ord a,
      Showl a) => Nat -> [Nat] -> Mat a -> Sum (String -> String) ();
check_E_I n ids m =
  check (all (\ i -> less_eq onea (index_mat m (i, i))) ids)
    (showsl_lit "[E_I set] Expected all diagonal elements to be at least 1: " .
      showsl_lista (mat_to_list m));

check_coefficients_E_I ::
  forall a b.
    (Showl a, One b, Zero b, Ord b,
      Showl b) => Nat ->
                    [Nat] ->
                      [((a, Nat), ([Mat b], Mat b))] ->
                        Sum (String -> String) ();
check_coefficients_E_I n ids fc =
  bindb (check_coefficients_N n ids fc)
    (\ _ ->
      catch_errora
        (catch_errora
          (forallM
            (\ ((f, _), (cs, c)) ->
              bindb (catch_errora
                      (catch_errora (forallM (check_E_I n ids) cs)
                        (\ x -> Inl (snd x)))
                      (\ x ->
                        Inl (((showsl_lit
                                 "Expected all interpretation multiplicative coefficients of symbol " .
                                showsl f) .
                               showsl_lit " to be in E_I.\n") .
                              x)))
                (\ _ ->
                  check (any (\ ci -> isOK (check_E_I n ids ci)) (c : cs))
                    ((((showsl_lit "Expected the constant coefficient " .
                         showsl_lista (mat_to_list c)) .
                        showsl_lit " of symbol ") .
                       showsl f) .
                      showsl_lit
                        " to be in E_I whenever there are no multiplicative coefficient (i.e. symbol of arity 0).")))
            fc)
          (\ x -> Inl (snd x)))
        (\ x ->
          Inl (showsl_lit
                 "Expected all interpretation multiplicative coeffs to be in E_I\n and the constant coeff to be in E_I whenever there are none multiplicative coeffs, for all function symbols.\n" .
                x)));

check_coeffs_E_I_final ::
  forall a b.
    (Showl a, One b, Zero b, Ord b,
      Showl b) => Nat ->
                    [Nat] ->
                      [((a, Nat), ([Mat b], Mat b))] ->
                        Sum (String -> String) ();
check_coeffs_E_I_final n ids fc =
  bindb (check_coeffs_length fc)
    (\ _ ->
      bindb (check_coefficients_N n ids fc)
        (\ _ -> check_coefficients_E_I n ids fc));

coeffs_of_pvars_better :: forall a b. [(a, b)] -> [b];
coeffs_of_pvars_better = map snd;

coeffs_of_lpoly_better :: forall a b. L_poly a b -> [b];
coeffs_of_lpoly_better (LPoly a_0 a_is) = a_0 : coeffs_of_pvars_better a_is;

check_L_I ::
  forall a b.
    (Showl a,
      Zero b) => Nat ->
                   (a -> b -> Bool) ->
                     [Nat] -> [Mat a] -> Sum (String -> String) ();
check_L_I n gt ids ms =
  check (all (\ i ->
               any (\ m -> any (\ j -> gt (index_mat m (i, j)) zerob) ids) ms)
          ids)
    (showsl_lit
       "[L_I set] Expected at least one positive element per row for coefficients: " .
      showsl_list_list (map mat_to_list ms));

check_poly_coef_one_L_I ::
  forall a b c.
    (Showl a,
      Zero b) => Nat ->
                   (a -> b -> Bool) ->
                     [Nat] -> L_poly c (Mat a) -> Sum (String -> String) ();
check_poly_coef_one_L_I n gt ids lp =
  catch_errora (check_L_I n gt ids (coeffs_of_lpoly_better lp))
    (\ x -> Inl (showsl_lit "problem in checking strict L_I-decrease.\n" . x));

minusb ::
  forall a b.
    Partial_object_ext a
      (Monoid_ext a
        (Ring_ext a
          (Ordered_semiring_ext a (Explicit_minus_semiring_ext a b)))) ->
      a -> a;
minusb
  (Partial_object_ext carrier
    (Monoid_ext mult one
      (Ring_ext zero add
        (Ordered_semiring_ext geq gt max
          (Explicit_minus_semiring_ext minus more)))))
  = minus;

expl_a_minus ::
  forall a b.
    Partial_object_ext a
      (Monoid_ext a
        (Ring_ext a
          (Ordered_semiring_ext a (Explicit_minus_semiring_ext a b)))) ->
      a -> a -> a;
expl_a_minus r x y = add r x (minusb r y);

sub_var ::
  forall a b c.
    (Eq a,
      Eq c) => Partial_object_ext a
                 (Monoid_ext a
                   (Ring_ext a
                     (Ordered_semiring_ext a
                       (Explicit_minus_semiring_ext a b)))) ->
                 [(c, a)] -> c -> a -> [(c, a)];
sub_var r [] x b = [(x, minusb r b)];
sub_var r ((y, a) : vas) x b =
  (if x == y then let {
                    s = expl_a_minus r a b;
                  } in (if s == zero r then vas else (x, s) : vas)
    else (y, a) : sub_var r vas x b);

sub_pvars ::
  forall a b c.
    (Eq a,
      Eq c) => Partial_object_ext a
                 (Monoid_ext a
                   (Ring_ext a
                     (Ordered_semiring_ext a
                       (Explicit_minus_semiring_ext a b)))) ->
                 [(c, a)] -> [(c, a)] -> [(c, a)];
sub_pvars r vas [] = vas;
sub_pvars r vas ((x, b) : vbs) =
  (if b == zero r then sub_pvars r vas vbs
    else sub_pvars r (sub_var r vas x b) vbs);

sub_lpoly ::
  forall a b c.
    (Eq a,
      Eq c) => Partial_object_ext a
                 (Monoid_ext a
                   (Ring_ext a
                     (Ordered_semiring_ext a
                       (Explicit_minus_semiring_ext a b)))) ->
                 L_poly c a -> L_poly c a -> L_poly c a;
sub_lpoly r (LPoly a vas) (LPoly b vbs) =
  LPoly (expl_a_minus r a b) (sub_pvars r vas vbs);

vpoly ::
  forall a b c.
    Partial_object_ext a
      (Monoid_ext a
        (Ring_ext a
          (Ordered_semiring_ext a (Explicit_minus_semiring_ext a b)))) ->
      c -> L_poly c a;
vpoly r x = LPoly (zero r) [(x, one r)];

list_sum_poly ::
  forall a b c.
    (Eq a,
      Eq c) => Partial_object_ext a
                 (Monoid_ext a
                   (Ring_ext a
                     (Ordered_semiring_ext a
                       (Explicit_minus_semiring_ext a b)))) ->
                 [L_poly c a] -> L_poly c a;
list_sum_poly r [] = LPoly (zero r) [];
list_sum_poly r (p : ps) = sum_lpolya r p (list_sum_poly r ps);

ip :: forall a b c d.
        (Eq a,
          Eq d) => Partial_object_ext a
                     (Monoid_ext a
                       (Ring_ext a
                         (Ordered_semiring_ext a
                           (Explicit_minus_semiring_ext a b)))) ->
                     ((c, Nat) -> ([a], a)) -> c -> [L_poly d a] -> L_poly d a;
ip r pI f asa =
  (case pI (f, size_list asa) of {
    (cs, c) ->
      list_sum_poly r
        (LPoly c [] : map (\ ca -> mul_lpoly r (fst ca) (snd ca)) (zip cs asa));
  });

evalp_rule ::
  forall a b c d.
    (Eq a,
      Eq d) => Partial_object_ext a
                 (Monoid_ext a
                   (Ring_ext a
                     (Ordered_semiring_ext a
                       (Explicit_minus_semiring_ext a b)))) ->
                 ((c, Nat) -> ([a], a)) -> Term c d -> Term c d -> L_poly d a;
evalp_rule ra pI l r =
  sub_lpoly ra (eval_term (ip ra pI) l (vpoly ra))
    (eval_term (ip ra pI) r (vpoly ra));

check_lpoly_coef_N ::
  forall a b.
    (Zero b, Ord b,
      Showl b) => Nat -> L_poly a (Mat b) -> Sum (String -> String) ();
check_lpoly_coef_N n lp =
  catch_errora
    (catch_errora (forallM (check_N n) (coeffs_of_lpoly_better lp))
      (\ x -> Inl (snd x)))
    (\ x ->
      Inl (showsl_lit
             "Expected all lpoly coefficient to be greater or equal to 0 mat.\n" .
            x));

mat_gt ::
  forall a. (Ord a) => (a -> a -> Bool) -> Nat -> Mat a -> Mat a -> Bool;
mat_gt gt sd a b =
  mat_ge a b &&
    let {
      d = minus_nat sd one_nat;
    } in less_nat d sd &&
           not (all_interval
                 (not .
                   (\ i ->
                     let {
                       da = minus_nat sd one_nat;
                     } in less_nat da sd &&
                            not (all_interval
                                  (not .
                                    (\ j ->
                                      gt (index_mat a (i, j))
(index_mat b (i, j))))
                                  zero_nat da)))
                 zero_nat d);

less_eq_mat :: forall a. (Ord a) => Mat a -> Mat a -> Bool;
less_eq_mat a b =
  equal_nat (dim_row a) (dim_row b) &&
    equal_nat (dim_col a) (dim_col b) &&
      let {
        d = minus_nat (dim_row b) one_nat;
      } in (if less_nat d (dim_row b)
             then all_interval
                    (\ i ->
                      let {
                        da = minus_nat (dim_col b) one_nat;
                      } in (if less_nat da (dim_col b)
                             then all_interval
                                    (\ j ->
                                      less_eq (index_mat a (i, j))
(index_mat b (i, j)))
                                    zero_nat da
                             else True))
                    zero_nat d
             else True);

less_mat :: forall a. (Ord a) => Mat a -> Mat a -> Bool;
less_mat a b = less_eq_mat a b && not (less_eq_mat b a);

matsemiring ::
  forall a.
    (Ordered_semiring_0 a, Ring_1 a,
      Ordered_semiring_1a a) => Nat ->
                                  (a -> a -> Bool) ->
                                    Partial_object_ext (Mat a)
                                      (Monoid_ext (Mat a)
(Ring_ext (Mat a)
  (Ordered_semiring_ext (Mat a) (Explicit_minus_semiring_ext (Mat a) ()))));
matsemiring n gt =
  Partial_object_ext (carrier_mat n n)
    (Monoid_ext times_mat (one_mat n)
      (Ring_ext (zero_mat n n) plus_mat
        (Ordered_semiring_ext mat_ge (mat_gt gt n)
          (\ a b -> (if less_mat b a then a else b))
          (Explicit_minus_semiring_ext uminus_mat ()))));

rring ::
  forall a.
    (Ordered_semiring_0 a, Ring_1 a,
      Ordered_semiring_1a a) => Nat ->
                                  Partial_object_ext (Mat a)
                                    (Monoid_ext (Mat a)
                                      (Ring_ext (Mat a)
(Ordered_semiring_ext (Mat a) (Explicit_minus_semiring_ext (Mat a) ()))));
rring n = matsemiring n (\ _ _ -> True);

check_M_I_strict ::
  forall a b c d.
    (Eq a, Ordered_semiring_0 a, Ring_1 a, Ordered_semiring_1a a, Showl a,
      Zero b, Eq c, Showl c, Eq d,
      Showl d) => Nat ->
                    (a -> b -> Bool) ->
                      [Nat] ->
                        [((c, Nat), ([Mat a], Mat a))] ->
                          (Term c d, Term c d) -> Sum (String -> String) ();
check_M_I_strict n gt ids fc =
  (\ (l, r) ->
    let {
      diff = evalp_rule (rring n) (pI n fc) l r;
    } in catch_errora
           (bindb (check_lpoly_coef_N n diff)
             (\ _ -> check_poly_coef_one_L_I n gt ids diff))
           (\ x ->
             Inl ((((((showsl_lit "problem in M_I-strict decrease of " .
                        showsl_rule (l, r)) .
                       showsl_literal "\n") .
                      showsl_lit "with interpretation [left] - [right] = ") .
                     showsl_l_poly diff) .
                    showsl_literal "\n") .
                   x)));

check_P_I ::
  forall a b.
    (Zero b) => Nat ->
                  (a -> b -> Bool) ->
                    [Nat] -> Mat a -> Sum (String -> String) ();
check_P_I n gt ids m =
  check (any (\ i -> any (\ j -> gt (index_mat m (i, j)) zerob) ids) ids)
    (showsl_lit "[P_I set] Expected at least one positive element");

check_poly_coef_one_P_I ::
  forall a b c.
    (Zero a, Ord a, Showl a,
      Zero b) => Nat ->
                   (a -> b -> Bool) ->
                     [Nat] -> L_poly c (Mat a) -> Sum (String -> String) ();
check_poly_coef_one_P_I n gt ids lp =
  bindb (check_lpoly_coef_N n lp)
    (\ _ ->
      check (any (\ c -> isOK (check_P_I n gt ids c))
              (coeffs_of_lpoly_better lp))
        (showsl_lit
           "Expected at least one lpoly coefficient to be in P_I, got none." .
          showsl_list_list (map mat_to_list (coeffs_of_lpoly_better lp))));

check_E_I_strict ::
  forall a b c d.
    (Eq a, Ordered_semiring_0 a, Ring_1 a, Ordered_semiring_1a a, Showl a,
      Zero b, Eq c, Showl c, Eq d,
      Showl d) => Nat ->
                    (a -> b -> Bool) ->
                      [Nat] ->
                        [((c, Nat), ([Mat a], Mat a))] ->
                          (Term c d, Term c d) -> Sum (String -> String) ();
check_E_I_strict n gt ids fc =
  (\ (l, r) ->
    let {
      diff = evalp_rule (rring n) (pI n fc) l r;
    } in catch_errora
           (bindb (check_lpoly_coef_N n diff)
             (\ _ -> check_poly_coef_one_P_I n gt ids diff))
           (\ x ->
             Inl ((((((showsl_lit "problem in E_I-strict decrease of " .
                        showsl_rule (l, r)) .
                       showsl_literal "\n") .
                      showsl_lit "with interpretation [left] - [right] = ") .
                     showsl_l_poly diff) .
                    showsl_literal "\n") .
                   x)));

check_M_I_weak ::
  forall a b c d.
    (Eq b, Showl b, Eq c, Ordered_semiring_0 c, Ring_1 c, Ordered_semiring_1a c,
      Showl c, Eq d,
      Showl d) => Nat ->
                    a -> [((b, Nat), ([Mat c], Mat c))] ->
                           (Term b d, Term b d) -> Sum (String -> String) ();
check_M_I_weak n ids fc =
  (\ (l, r) ->
    let {
      diff = evalp_rule (rring n) (pI n fc) l r;
    } in catch_errora (check_lpoly_coef_N n diff)
           (\ x ->
             Inl ((((((showsl_lit "problem in M_I-weak decrease of " .
                        showsl_rule (l, r)) .
                       showsl_literal "\n") .
                      showsl_lit "with interpretation [left] - [right] = ") .
                     showsl_l_poly diff) .
                    showsl_literal "\n") .
                   x)));

check_E_I_weak ::
  forall a b c d.
    (Eq b, Showl b, Eq c, Ordered_semiring_0 c, Ring_1 c, Ordered_semiring_1a c,
      Showl c, Eq d,
      Showl d) => Nat ->
                    a -> [((b, Nat), ([Mat c], Mat c))] ->
                           (Term b d, Term b d) -> Sum (String -> String) ();
check_E_I_weak n ids fc =
  (\ (l, r) ->
    let {
      diff = evalp_rule (rring n) (pI n fc) l r;
    } in catch_errora (check_lpoly_coef_N n diff)
           (\ x ->
             Inl ((((((showsl_lit "problem in E_I-weak decrease of " .
                        showsl_rule (l, r)) .
                       showsl_literal "\n") .
                      showsl_lit "with interpretation [left] - [right] = ") .
                     showsl_l_poly diff) .
                    showsl_literal "\n") .
                   x)));

check_indices :: Nat -> [Nat] -> Sum (String -> String) ();
check_indices n ids =
  bindb (check (not (set_eq (set ids) (set_empty (of_phantom set_impl_nat))))
          (showsl_lit "Set of indices should not be empty"))
    (\ _ ->
      check (less_eq_set (set ids) (atLeastLessThan zero_nat n))
        (showsl_lit "I should be a subset of {0..n-1}"));

create_core_matrix_rel_impl ::
  forall a b c d.
    (Eq a, Ordered_semiring_0 a, Ring_1 a, Ordered_semiring_1a a, Showl a,
      Zero b, Compare_order c, Eq c, Showl c, Eq d,
      Showl d) => Sum (String -> String) (a -> b -> Bool) ->
                    Core_matrix_inter c a -> Rel_impl_ext c d ();
create_core_matrix_rel_impl gtc (Core_Matrix_Inter mode n ids fc) =
  let {
    ns = (case mode of {
           E_I -> check_E_I_weak n ids fc;
           M_I -> check_M_I_weak n ids fc;
         });
    s = let {
          gt = projr gtc;
        } in (case mode of {
               E_I -> check_E_I_strict n gt ids fc;
               M_I -> check_M_I_strict n gt ids fc;
             });
  } in Rel_impl_ext
         (bindb gtc
           (\ _ ->
             bindb (check_indices n ids)
               (\ _ -> (case mode of {
                         E_I -> check_coeffs_E_I_final n ids fc;
                         M_I -> check_coeffs_M_I_final n ids fc;
                       }))))
         (Inr ()) (show_core_matrix_inter_main (case mode of {
         E_I -> "E_I";
         M_I -> "M_I";
       })
                    n ids fc)
         s ns ns full_af full_af (Inr ()) (Inr ()) (Inr ()) (Inr ()) (Inr ())
         (Inr ()) (\ _ -> top_set) (\ _ -> Inr ()) Nothing Nothing
         no_complexity_check ();

core_matrix_gt_delta ::
  forall a.
    (Floor_ceiling a, Showl a) => a -> Sum (String -> String) (a -> a -> Bool);
core_matrix_gt_delta d =
  bindb (check (less zerob d && less_eq d onea)
          ((showsl_lit "parameter delta " . showsl d) .
            showsl_lit " must be between 0 and 1"))
    (\ _ -> Inr (delta_gt d));

create_core_matrix_fract ::
  forall a b c.
    (Floor_ceiling a, Eq a, Showl a, Compare_order b, Eq b, Showl b, Eq c,
      Showl c) => a -> Core_matrix_inter b a -> Rel_impl_ext b c ();
create_core_matrix_fract delta rel =
  (case rel of {
    Core_Matrix_Inter E_I n i fk_cs -> core_EI_rel_impl_fract n delta i fk_cs;
    Core_Matrix_Inter M_I _ _ _ ->
      create_core_matrix_rel_impl (core_matrix_gt_delta delta) rel;
  });

list_ext_name :: List_order_type -> String;
list_ext_name MS_Ext = "MS";
list_ext_name Dms_Ext = "DMS";
list_ext_name Min_Ext = "MIN";
list_ext_name Max_Ext = "MAX";

default_Ia :: forall a. (Poly_carriera a) => a -> Nat -> [(Monom Nat, a)];
default_Ia def n = zero_poly;

poly_inter_list_to_inter_neg ::
  forall a b.
    (Poly_carriera a,
      Compare_order b) => a -> [((b, Nat), [(Monom Nat, a)])] ->
                                 (b, Nat) -> [(Monom Nat, a)];
poly_inter_list_to_inter_neg def i =
  fun_of_map_fun (ceta_map_of i) (\ fn -> default_Ia def (snd fn));

check_neg_ns ::
  forall a b c.
    (Showl a, Eq b, Preorder b, Poly_carriera b, Showl b, Eq c, Linorder c,
      Showl c) => ((a, Nat) -> [(Monom Nat, b)]) ->
                    (Term a c, Term a c) -> Sum (String -> String) ();
check_neg_ns i =
  (\ (s, t) ->
    let {
      p = eval_terma i s;
      q = eval_terma i t;
    } in check (check_poly_neg_ge p q)
           (((((((showsl_literal "could not ensure " . showsl_terma s) .
                  showsl_literal " >= ") .
                 showsl_terma t) .
                showsl_literal " since we\ncould not ensure ") .
               showsl_poly p) .
              showsl_literal " >= ") .
             showsl_poly q));

check_poly_neg_gt ::
  forall a b.
    (Eq a, Poly_carriera a, Eq b,
      Linorder b) => (a -> a -> Bool) ->
                       [(Monom b, a)] -> [(Monom b, a)] -> Bool;
check_poly_neg_gt gt p q = let {
                             pa = poly_convert p;
                             a = poly_convert q;
                           } in check_poly_gt gt pa a;

check_neg_s ::
  forall a b c.
    (Eq a, Poly_carriera a, Showl a, Showl b, Eq c, Linorder c,
      Showl c) => (a -> a -> Bool) ->
                    ((b, Nat) -> [(Monom Nat, a)]) ->
                      (Term b c, Term b c) -> Sum (String -> String) ();
check_neg_s gt i =
  (\ (s, t) ->
    let {
      p = eval_terma i s;
      q = eval_terma i t;
    } in check (check_poly_neg_gt gt p q)
           (((((((showsl_literal "could not ensure " . showsl_terma s) .
                  showsl_literal " > ") .
                 showsl_terma t) .
                showsl_literal " since we\ncould not ensure ") .
               showsl_poly p) .
              showsl_literal " > ") .
             showsl_poly q));

create_negpoly_rel_impl ::
  forall a b c.
    (Eq a, Preorder a, Poly_carriera a, Showl a, Compare_order b, Eq b, Showl b,
      Eq c, Linorder c,
      Showl c) => Sum (String -> String) () ->
                    a -> (a -> a -> Bool) ->
                           Bool ->
                             [((b, Nat), [(Monom Nat, a)])] ->
                               Rel_impl_ext b c ();
create_negpoly_rel_impl cI def gt discrete i =
  let {
    j = poly_inter_list_to_inter_neg def i;
    x = poly_subst
          (\ n ->
            poly_of
              (PVar ([char_0x78, char_0x5F] ++ shows_prec_nat zero_nat n [])));
  } in Rel_impl_ext (bindb cI (\ _ -> check_poly_inter_list_neg i)) (Inr ())
         (showsl_literal "polynomial interpretation\n" .
           showsl_sep
             (\ (a, b) ->
               (case a of {
                 (f, n) ->
                   (\ p ->
                     ((((showsl_literal "Pol(" . showsl f) .
                         showsl_literal "/") .
                        showsl_nat n) .
                       showsl_literal ") = ") .
                       showsl_poly (x p));
               })
                 b)
             (showsl_literal "\n") i)
         (check_neg_s gt j) (check_neg_ns j)
         (\ _ -> Inl (showsl_lit "top-order not supported by neg-polys"))
         full_af full_af (Inl (showsl_lit "SN not supported by neg-polys"))
         (Inr ()) (Inl (showsl_lit "Ce not supported by neg-polys")) (Inr ())
         (Inl (showsl_lit "top-mono not supported by neg-polys"))
         (Inl (showsl_lit "top-refl not supported by neg-polys")) empty_af
         (\ _ ->
           Inl (showsl_lit "strict monotonicity not supported by neg-polys"))
         Nothing Nothing no_complexity_check ();

core_EI_rel_impl_int ::
  forall a b.
    (Eq a, Showl a, Eq b,
      Showl b) => Nat ->
                    [Nat] ->
                      [((a, Nat), ([Mat Int], Mat Int))] -> Rel_impl_ext a b ();
core_EI_rel_impl_int n = core_EI_rel_impl n one_int;

core_matrix_gt_int :: Sum (String -> String) (Int -> Int -> Bool);
core_matrix_gt_int = Inr (\ x y -> less_int y x);

create_core_matrix_int ::
  forall a b.
    (Compare_order a, Eq a, Showl a, Eq b,
      Showl b) => Core_matrix_inter a Int -> Rel_impl_ext a b ();
create_core_matrix_int rel =
  (case rel of {
    Core_Matrix_Inter E_I n i fk_cs -> core_EI_rel_impl_int n i fk_cs;
    Core_Matrix_Inter M_I _ _ _ ->
      create_core_matrix_rel_impl core_matrix_gt_int rel;
  });

plus_single_mono ::
  forall a b.
    Partial_object_ext a
      (Monoid_ext a
        (Ring_ext a (Ordered_semiring_ext a (Lpoly_order_semiring_ext a b)))) ->
      Bool;
plus_single_mono
  (Partial_object_ext carrier
    (Monoid_ext mult one
      (Ring_ext zero add
        (Ordered_semiring_ext geq gt max
          (Lpoly_order_semiring_ext plus_single_mono defaulta arcpos checkmono
            bound check_complexity description more)))))
  = plus_single_mono;

check_complexity ::
  forall a b.
    Partial_object_ext a
      (Monoid_ext a
        (Ring_ext a (Ordered_semiring_ext a (Lpoly_order_semiring_ext a b)))) ->
      a -> Nat -> Sum (String -> String) ();
check_complexity
  (Partial_object_ext carrier
    (Monoid_ext mult one
      (Ring_ext zero add
        (Ordered_semiring_ext geq gt max
          (Lpoly_order_semiring_ext plus_single_mono defaulta arcpos checkmono
            bound check_complexity description more)))))
  = check_complexity;

maxb ::
  forall a b.
    Partial_object_ext a
      (Monoid_ext a (Ring_ext a (Ordered_semiring_ext a b))) ->
      a -> a -> a;
maxb (Partial_object_ext carrier
       (Monoid_ext mult one
         (Ring_ext zero add (Ordered_semiring_ext geq gt max more))))
  = max;

poly_c_max_inter_bcoeff_strict ::
  forall a b c.
    Partial_object_ext a
      (Monoid_ext a (Ring_ext a (Ordered_semiring_ext a b))) ->
      [(c, Nat)] -> ((c, Nat) -> (a, [a])) -> a;
poly_c_max_inter_bcoeff_strict r f pi =
  foldr (maxb r) (concatMap (\ fn -> snd (pi fn)) f) (zero r);

geq ::
  forall a b.
    Partial_object_ext a
      (Monoid_ext a (Ring_ext a (Ordered_semiring_ext a b))) ->
      a -> a -> Bool;
geq (Partial_object_ext carrier
      (Monoid_ext mult one
        (Ring_ext zero add (Ordered_semiring_ext geq gt max more))))
  = geq;

poly_c_max_inter_bcoeff ::
  forall a b c.
    Partial_object_ext a
      (Monoid_ext a (Ring_ext a (Ordered_semiring_ext a b))) ->
      [(c, Nat)] -> ((c, Nat) -> (a, [a])) -> a;
poly_c_max_inter_bcoeff r f pi =
  foldr (maxb r)
    (concatMap (\ fn -> filter (\ b -> not (geq r (one r) b)) (snd (pi fn))) f)
    (zero r);

convert_lpoly_complexity ::
  forall a b c d.
    (Eq a) => Partial_object_ext a
                (Monoid_ext a
                  (Ring_ext a
                    (Ordered_semiring_ext a (Lpoly_order_semiring_ext a b)))) ->
                ((c, Nat) -> (a, [a])) ->
                  Complexity_measure c d ->
                    Complexity_class -> Sum (String -> String) ();
convert_lpoly_complexity r pi cm (Comp_Poly deg) =
  let {
    f = (case cm of {
          Derivational_Complexity f -> f;
          Runtime_Complexity c _ -> c;
        });
    bc = poly_c_max_inter_bcoeff r f pi;
    bca = poly_c_max_inter_bcoeff_strict r f pi;
  } in bindb (check (less_nat zero_nat deg || bca == zero r)
               (showsl_literal
                 "constant complexity not fully supported for linear (poly/matrix)-interpretations"))
         (\ _ -> check_complexity r bc (minus_nat deg one_nat));

check_poly_mono_npsm ::
  forall a b c.
    (Eq a, Showl a, Eq c,
      Showl c) => Partial_object_ext a
                    (Monoid_ext a
                      (Ring_ext a
                        (Ordered_semiring_ext a
                          (Lpoly_order_semiring_ext a b)))) ->
                    [(c, Nat)] ->
                      [((c, Nat), (a, [a]))] -> Sum (String -> String) ();
check_poly_mono_npsm r f pi =
  bindb (catch_errora
          (forallM
            (\ (a, b) ->
              (case a of {
                (fa, n) ->
                  (\ (c, cs) ->
                    catch_errora
                      (bindb
                        (check
                          (if equal_nat n (suc zero_nat) then c == zero r
                            else True)
                          ((showsl_literal "constant part " . showsl c) .
                            showsl_literal " must be 0\n"))
                        (\ _ ->
                          bindb (check (equal_nat n (size_list cs))
                                  (showsl_literal
                                    "the arity is not the same as the number of arguments\n"))
                            (\ _ ->
                              check (less_eq_nat n (suc zero_nat))
                                (showsl_literal
                                  "symbol has arity larger than 1\n"))))
                      (\ x ->
                        Inl (((((showsl_literal
                                   "problem with monotonicity due to interpretation of " .
                                  showsl fa) .
                                 showsl_literal "/") .
                                showsl_nat n) .
                               showsl_literal "\n") .
                              x)));
              })
                b)
            pi)
          (\ x -> Inl (snd x)))
    (\ _ ->
      catch_errora (check_subseteq f (map fst pi))
        (\ x ->
          Inl ((showsl_literal "unknown interpretation for " . showsl_prod x) .
                showsl_literal "\n")));

arcpos ::
  forall a b.
    Partial_object_ext a
      (Monoid_ext a
        (Ring_ext a (Ordered_semiring_ext a (Lpoly_order_semiring_ext a b)))) ->
      a -> Bool;
arcpos
  (Partial_object_ext carrier
    (Monoid_ext mult one
      (Ring_ext zero add
        (Ordered_semiring_ext geq gt max
          (Lpoly_order_semiring_ext plus_single_mono defaulta arcpos checkmono
            bound check_complexity description more)))))
  = arcpos;

carrier :: forall a b. Partial_object_ext a b -> Set a;
carrier (Partial_object_ext carrier more) = carrier;

check_lpoly_coeffs ::
  forall a b c.
    (Ceq a, Ccompare a, Showl a,
      Showl c) => Partial_object_ext a
                    (Monoid_ext a
                      (Ring_ext a
                        (Ordered_semiring_ext a
                          (Lpoly_order_semiring_ext a b)))) ->
                    [((c, Nat), (a, [a]))] -> Sum (String -> String) ();
check_lpoly_coeffs r i =
  catch_errora
    (forallM
      (\ (a, b) ->
        (case a of {
          (f, n) ->
            (\ (c, cs) ->
              catch_errora
                (bindb
                  (check (member c (carrier r))
                    ((showsl_literal "constant part " . showsl c) .
                      showsl_literal " is not well-formed\n"))
                  (\ _ ->
                    bindb (check (less_eq_nat (size_list cs) n)
                            (showsl_literal
                               "number of coefficients exceeds arity of symbol " .
                              showsl f))
                      (\ _ ->
                        bindb (check (arcpos r c || any (arcpos r) cs)
                                (showsl_literal
                                  "could not find positive entry which is required for arctic interpretations\n"))
                          (\ _ ->
                            catch_errora
                              (forallM
                                (\ aa ->
                                  check (geq r aa (zero r) &&
  member aa (carrier r))
                                    ((showsl_literal "coefficient " .
                                       showsl aa) .
                                      showsl_literal " is not allowed\n"))
                                cs)
                              (\ x -> Inl (snd x))))))
                (\ x ->
                  Inl (((((showsl_literal "problem with interpretation of " .
                            showsl f) .
                           showsl_literal "/") .
                          showsl_nat n) .
                         showsl_literal "\n") .
                        x)));
        })
          b)
      i)
    (\ x -> Inl (snd x));

description ::
  forall a b.
    Partial_object_ext a
      (Monoid_ext a
        (Ring_ext a (Ordered_semiring_ext a (Lpoly_order_semiring_ext a b)))) ->
      String -> String;
description
  (Partial_object_ext carrier
    (Monoid_ext mult one
      (Ring_ext zero add
        (Ordered_semiring_ext geq gt max
          (Lpoly_order_semiring_ext plus_single_mono defaulta arcpos checkmono
            bound check_complexity description more)))))
  = description;

defaultb ::
  forall a b.
    Partial_object_ext a
      (Monoid_ext a
        (Ring_ext a (Ordered_semiring_ext a (Lpoly_order_semiring_ext a b)))) ->
      a;
defaultb
  (Partial_object_ext carrier
    (Monoid_ext mult one
      (Ring_ext zero add
        (Ordered_semiring_ext geq gt max
          (Lpoly_order_semiring_ext plus_single_mono defaulta arcpos checkmono
            bound check_complexity description more)))))
  = defaulta;

to_lpoly_inter ::
  forall a b c.
    (Compare_order c) => Partial_object_ext a
                           (Monoid_ext a
                             (Ring_ext a
                               (Ordered_semiring_ext a
                                 (Lpoly_order_semiring_ext a b)))) ->
                           [((c, Nat), (a, [a]))] -> (c, Nat) -> (a, [a]);
to_lpoly_inter r i =
  fun_of_map_fun (ceta_map_of i)
    (\ fn -> (defaultb r, replicate (snd fn) (one r)));

showl_pvars ::
  forall a b c.
    (Eq a, Showl a,
      Showl c) => Partial_object_ext a (Monoid_ext a (Ring_ext a b)) ->
                    [(c, a)] -> [String];
showl_pvars r [] = [];
showl_pvars r ((x, c) : vas) =
  (if c == one r then id else showsl c) (showsl x "") : showl_pvars r vas;

showsl_lpoly ::
  forall a b c.
    (Eq a, Showl a,
      Showl c) => Partial_object_ext a (Monoid_ext a (Ring_ext a b)) ->
                    L_poly c a -> String -> String;
showsl_lpoly r (LPoly c cs) =
  (case showl_pvars r cs of {
    [] -> showsl c;
    a : list ->
      (if c == zero r then id else showsl c . showsl_literal " + ") .
        showsl_list_gen showsl_literal "" "" " + " "" (a : list);
  });

list_prod :: forall a b. Partial_object_ext a (Monoid_ext a b) -> [a] -> a;
list_prod r [] = one r;
list_prod r (x : xs) = mult r x (list_prod r xs);

wf_pvars ::
  forall a b c.
    (Cenum a, Ceq a, Ccompare a,
      Set_impl a) => Partial_object_ext a b -> [(c, a)] -> Bool;
wf_pvars r vas = less_eq_set (set (map snd vas)) (carrier r);

wf_lpoly ::
  forall a b c.
    (Cenum a, Ceq a, Ccompare a,
      Set_impl a) => Partial_object_ext a b -> L_poly c a -> Bool;
wf_lpoly r (LPoly a vas) = member a (carrier r) && wf_pvars r vas;

pleftI ::
  forall a b c d.
    (Cenum a, Ceq a, Ccompare a, Eq a, Set_impl a,
      Eq d) => Partial_object_ext a
                 (Monoid_ext a (Ring_ext a (Ordered_semiring_ext a b))) ->
                 ((c, Nat) -> (a, [a])) -> Term c d -> L_poly d a;
pleftI r pi (Var x) = LPoly (zero r) [(x, one r)];
pleftI r pi (Fun f ts) =
  (case pi (f, size_list ts) of {
    (c, asa) ->
      (case sum_lpolya r (LPoly c [])
              (list_prod
                (Partial_object_ext (collect (wf_lpoly r))
                  (Monoid_ext (sum_lpolya r) (LPoly (zero r) []) ()))
                (map (\ at -> mul_lpoly r (fst at) (pleftI r pi (snd at)))
                  (zip asa ts)))
        of {
        LPoly d [] -> LPoly (maxb r (zero r) d) [];
        LPoly d (ab : lista) -> LPoly d (ab : lista);
      });
  });

create_lpoly_repr ::
  forall a b.
    (Cenum a, Ceq a, Ccompare a, Eq a, Set_impl a, Showl a, Compare_order b,
      Eq b,
      Showl b) => Partial_object_ext a
                    (Monoid_ext a
                      (Ring_ext a
                        (Ordered_semiring_ext a
                          (Lpoly_order_semiring_ext a ())))) ->
                    [((b, Nat), (a, [a]))] -> String -> String;
create_lpoly_repr c i =
  let {
    pi = to_lpoly_inter c i;
  } in ((showsl_literal "polynomial interpretation over " . description c) .
         showsl_literal "\n") .
         showsl_sep
           (\ (f, n) ->
             let {
               t = Fun f (map Var
                           (fresh_strings_list [char_0x78, char_0x5F] one_nat []
                             n));
             } in ((showsl_literal "Pol(" . showsl_terma t) .
                    showsl_literal ") = ") .
                    showsl_lpoly c (pleftI c pi t))
           (showsl_literal "\n") (remdups (map fst i));

checkmono ::
  forall a b.
    Partial_object_ext a
      (Monoid_ext a
        (Ring_ext a (Ordered_semiring_ext a (Lpoly_order_semiring_ext a b)))) ->
      a -> Bool;
checkmono
  (Partial_object_ext carrier
    (Monoid_ext mult one
      (Ring_ext zero add
        (Ordered_semiring_ext geq gt max
          (Lpoly_order_semiring_ext plus_single_mono defaulta arcpos checkmono
            bound check_complexity description more)))))
  = checkmono;

check_poly_mono ::
  forall a b c.
    (Showl a,
      Showl c) => Partial_object_ext a
                    (Monoid_ext a
                      (Ring_ext a
                        (Ordered_semiring_ext a
                          (Lpoly_order_semiring_ext a b)))) ->
                    [((c, Nat), (a, [a]))] -> Sum (String -> String) ();
check_poly_mono r =
  (\ xs ->
    catch_errora
      (forallM
        (\ (a, b) ->
          (case a of {
            (f, n) ->
              (\ (c, cs) ->
                catch_errora
                  (bindb
                    (check (geq r c (zero r))
                      ((((showsl_literal "constant part " . showsl c) .
                          showsl_literal " must be at least ") .
                         showsl (zero r)) .
                        showsl_literal "\n"))
                    (\ _ ->
                      bindb (check (less_eq_nat n (size_list cs))
                              (showsl_literal "the last argument is ignored\n"))
                        (\ _ ->
                          catch_errora
                            (forallM
                              (\ d ->
                                check (checkmono r d)
                                  ((showsl_literal "coefficient " . showsl d) .
                                    showsl_literal " is not allowed\n"))
                              cs)
                            (\ x -> Inl (snd x)))))
                  (\ x ->
                    Inl (((((showsl_literal
                               "problem with monotonicity due to interpretation of " .
                              showsl f) .
                             showsl_literal "/") .
                            showsl_nat n) .
                           showsl_literal "\n") .
                          x)));
          })
            b)
        xs)
      (\ x -> Inl (snd x)));

create_mono_af ::
  forall a b c.
    (Eq a,
      Compare_order c) => Partial_object_ext a
                            (Monoid_ext a
                              (Ring_ext a
                                (Ordered_semiring_ext a
                                  (Lpoly_order_semiring_ext a b)))) ->
                            [((c, Nat), (a, [a]))] -> (c, Nat) -> Set Nat;
create_mono_af r i =
  (if plus_single_mono r
    then fun_of_map_funa (ceta_map_of i)
           (\ (_, a) -> atLeastLessThan zero_nat a)
           (\ (c, coeffs) ->
             set (if geq r c (zero r)
                   then concatMap
                          (\ (ca, ia) ->
                            (if ca == one r || checkmono r ca then [ia]
                              else []))
                          (zip coeffs (upt zero_nat (size_list coeffs)))
                   else []))
    else empty_af);

lookup_rest :: forall a b. (Eq a) => a -> [(a, b)] -> Maybe (b, [(a, b)]);
lookup_rest x [] = Nothing;
lookup_rest x ((y, c) : ycs) =
  (if x == y then Just (c, ycs)
    else (case lookup_rest x ycs of {
           Nothing -> Nothing;
           Just (d, yccs) -> Just (d, (y, c) : yccs);
         }));

check_pvars ::
  forall a b c.
    (Showl a,
      Eq c) => Partial_object_ext a (Monoid_ext a (Ring_ext a b)) ->
                 (a -> a -> Bool) -> [(c, a)] -> [(c, a)] -> Sum c ();
check_pvars r rel vas [] =
  catch_errora (forallM (\ va -> check (rel (snd va) (zero r)) (fst va)) vas)
    (\ x -> Inl (snd x));
check_pvars r rel vas ((x, b) : vbs) =
  (case (case lookup_rest x vas of {
          Nothing -> (zero r, vas);
          Just (a, ba) -> (a, ba);
        })
    of {
    (a, vasa) -> bindb (check (rel a b) x) (\ _ -> check_pvars r rel vasa vbs);
  });

check_lpoly_ns ::
  forall a b c.
    (Eq a, Showl a, Eq c,
      Showl c) => Partial_object_ext a
                    (Monoid_ext a (Ring_ext a (Ordered_semiring_ext a b))) ->
                    L_poly c a -> L_poly c a -> Sum (String -> String) ();
check_lpoly_ns r (LPoly a vas) (LPoly b vbs) =
  catch_errora
    (bindb
      (check (geq r a b)
        (showsl_literal "problem when comparing constant parts"))
      (\ _ ->
        catch_errora (check_pvars r (geq r) vas vbs)
          (\ x ->
            Inl (showsl_literal
                   "problem when comparing coefficients of variable " .
                  showsl x))))
    (\ x ->
      Inl (((((showsl_literal "problem when comparing " .
                showsl_lpoly r (LPoly a vas)) .
               showsl_literal " >= ") .
              showsl_lpoly r (LPoly b vbs)) .
             showsl_literal "\n") .
            x));

prightI ::
  forall a b c d.
    (Cenum a, Ceq a, Ccompare a, Eq a, Set_impl a,
      Eq d) => Partial_object_ext a
                 (Monoid_ext a (Ring_ext a (Ordered_semiring_ext a b))) ->
                 ((c, Nat) -> (a, [a])) -> Term c d -> L_poly d a;
prightI r pi (Var x) = LPoly (zero r) [(x, one r)];
prightI r pi (Fun f ts) =
  (case pi (f, size_list ts) of {
    (c, asa) ->
      (case sum_lpolya r (LPoly c [])
              (list_prod
                (Partial_object_ext (collect (wf_lpoly r))
                  (Monoid_ext (sum_lpolya r) (LPoly (zero r) []) ()))
                (map (\ at -> mul_lpoly r (fst at) (prightI r pi (snd at)))
                  (zip asa ts)))
        of {
        LPoly d a -> LPoly (maxb r (zero r) d) a;
      });
  });

check_polo_ns ::
  forall a b c d.
    (Cenum a, Ceq a, Ccompare a, Eq a, Set_impl a, Showl a, Showl c, Eq d,
      Showl d) => Partial_object_ext a
                    (Monoid_ext a
                      (Ring_ext a
                        (Ordered_semiring_ext a
                          (Lpoly_order_semiring_ext a b)))) ->
                    ((c, Nat) -> (a, [a])) ->
                      (Term c d, Term c d) -> Sum (String -> String) ();
check_polo_ns r pi (s, t) =
  let {
    left = pleftI r pi s;
    right = prightI r pi t;
  } in catch_errora (check_lpoly_ns r left right)
         (\ x ->
           Inl (((((showsl_literal "could not ensure " . showsl_terma s) .
                    showsl_literal " >= ") .
                   showsl_terma t) .
                  showsl_literal "\n") .
                 x));

gt :: forall a b.
        Partial_object_ext a
          (Monoid_ext a (Ring_ext a (Ordered_semiring_ext a b))) ->
          a -> a -> Bool;
gt (Partial_object_ext carrier
     (Monoid_ext mult one
       (Ring_ext zero add (Ordered_semiring_ext geq gt max more))))
  = gt;

check_lpoly_s ::
  forall a b c.
    (Eq a, Showl a, Eq c,
      Showl c) => Partial_object_ext a
                    (Monoid_ext a
                      (Ring_ext a
                        (Ordered_semiring_ext a
                          (Lpoly_order_semiring_ext a b)))) ->
                    L_poly c a -> L_poly c a -> Sum (String -> String) ();
check_lpoly_s r (LPoly a vas) (LPoly b vbs) =
  catch_errora
    (bindb
      (check (gt r a b) (showsl_literal "problem when comparing constant part"))
      (\ _ ->
        catch_errora
          (check_pvars r (if plus_single_mono r then geq r else gt r) vas vbs)
          (\ x ->
            Inl (showsl_literal
                   "problem when comparing coefficients of variable " .
                  showsl x))))
    (\ x ->
      Inl (((((showsl_literal "problem when comparing " .
                showsl_lpoly r (LPoly a vas)) .
               showsl_literal " > ") .
              showsl_lpoly r (LPoly b vbs)) .
             showsl_literal "\n") .
            x));

check_polo_s ::
  forall a b c d.
    (Cenum a, Ceq a, Ccompare a, Eq a, Set_impl a, Showl a, Showl c, Eq d,
      Showl d) => Partial_object_ext a
                    (Monoid_ext a
                      (Ring_ext a
                        (Ordered_semiring_ext a
                          (Lpoly_order_semiring_ext a b)))) ->
                    ((c, Nat) -> (a, [a])) ->
                      (Term c d, Term c d) -> Sum (String -> String) ();
check_polo_s r pi (s, t) =
  let {
    left = pleftI r pi s;
    right = prightI r pi t;
  } in catch_errora (check_lpoly_s r left right)
         (\ x ->
           Inl (((((showsl_literal "could not ensure " . showsl_terma s) .
                    showsl_literal " > ") .
                   showsl_terma t) .
                  showsl_literal "\n") .
                 x));

create_af ::
  forall a b c.
    (Eq a,
      Compare_order c) => Partial_object_ext a
                            (Monoid_ext a
                              (Ring_ext a
                                (Ordered_semiring_ext a
                                  (Lpoly_order_semiring_ext a b)))) ->
                            [((c, Nat), (a, [a]))] -> (c, Nat) -> Set Nat;
create_af r i =
  fun_of_map_funa (ceta_map_of i) (\ (_, a) -> atLeastLessThan zero_nat a)
    (\ (_, coeffs) ->
      set (concatMap (\ (c, ia) -> (if not (c == zero r) then [ia] else []))
            (zip coeffs (upt zero_nat (size_list coeffs)))));

create_poly_rel_impl ::
  forall a b c.
    (Cenum a, Ceq a, Ccompare a, Eq a, Set_impl a, Showl a, Compare_order b,
      Eq b, Showl b, Eq c,
      Showl c) => Partial_object_ext a
                    (Monoid_ext a
                      (Ring_ext a
                        (Ordered_semiring_ext a
                          (Lpoly_order_semiring_ext a ())))) ->
                    Sum (String -> String) () ->
                      [((b, Nat), (a, [a]))] -> Rel_impl_ext b c ();
create_poly_rel_impl c cI i =
  let {
    pi = to_lpoly_inter c i;
    ns = check_polo_ns c pi;
  } in Rel_impl_ext (bindb cI (\ _ -> check_lpoly_coeffs c i)) (Inr ())
         (create_lpoly_repr c i) (check_polo_s c pi) ns ns (create_af c i)
         (create_af c i) (Inr ()) (Inr ()) (Inr ()) (Inr ()) (Inr ()) (Inr ())
         (create_mono_af c i)
         (\ sig ->
           (if plus_single_mono c then check_poly_mono c i
             else check_poly_mono_npsm c sig i))
         (Just (map fst i))
         (if plus_single_mono c then Just (map fst i) else Nothing)
         (if plus_single_mono c then convert_lpoly_complexity c pi
           else no_complexity_check)
         ();

weak_gt_arctic_delta ::
  forall a. (Floor_ceiling a) => Arctic_delta a -> Arctic_delta a -> Bool;
weak_gt_arctic_delta uu MinInfty_delta = True;
weak_gt_arctic_delta MinInfty_delta (Num_arc_delta uv) = False;
weak_gt_arctic_delta (Num_arc_delta x) (Num_arc_delta y) = less y x;

simplifya :: forall a. (Eq a) => Term Sigb a -> Term Sigb a;
simplifya (Var x) = Var x;
simplifya (Fun (ConstFb n) ss) = Fun (ConstFb n) [];
simplifya (Fun SumFb ss) =
  let {
    ssa = filter (\ s -> not (equal_term s (Fun (ConstFb zero_nat) [])))
            (map simplifya ss);
  } in (case ssa of {
         [] -> Fun (ConstFb zero_nat) [];
         [s] -> s;
         _ : _ : _ -> Fun SumFb ssa;
       });
simplifya (Fun ProdFa ss) =
  let {
    ssa = filter (\ s -> not (equal_term s (Fun (ConstFb one_nat) [])))
            (map simplifya ss);
  } in (if membera ssa (Fun (ConstFb zero_nat) [])
         then Fun (ConstFb zero_nat) [] else (case ssa of {
       [] -> Fun (ConstFb one_nat) [];
       [s] -> s;
       _ : _ : _ -> Fun ProdFa ssa;
     }));
simplifya (Fun MaxFa ss) =
  let {
    ssa = filter (\ s -> not (equal_term s (Fun (ConstFb zero_nat) [])))
            (map simplifya ss);
  } in (case ssa of {
         [] -> Fun (ConstFb zero_nat) [];
         [s] -> s;
         _ : _ : _ -> Fun MaxFa ssa;
       });

simplified_alista ::
  forall a.
    (Showl a) => [((a, Nat), Term Sigb Nat)] -> [((a, Nat), Term Sigb Nat)];
simplified_alista alist = map (map_prod id simplifya) alist;

normalize_lits ::
  forall a b c.
    (Showl b) => (Bool -> Term a (b, c) -> Formula (Term a (b, c))) ->
                   Formula (Term a (b, c)) -> Formula (Term a (b, c));
normalize_lits normalize_lit (Conjunction phi_s) =
  Conjunction (map (normalize_lits normalize_lit) phi_s);
normalize_lits normalize_lit (Disjunction phi_s) =
  Disjunction (map (normalize_lits normalize_lit) phi_s);
normalize_lits normalize_lit (NegAtom phi) = normalize_lit False phi;
normalize_lits normalize_lit (Atom phi) = normalize_lit True phi;

showsl_formula ::
  forall a. (a -> String -> String) -> Formula a -> String -> String;
showsl_formula showsl_atom (Atom a) = showsl_atom a;
showsl_formula showsl_atom (NegAtom a) =
  (showsl_literal "! (" . showsl_atom a) . showsl_literal ")";
showsl_formula showsl_atom (Conjunction fs) =
  let {
    a = map (showsl_formula showsl_atom) fs;
  } in showsl_list_gen id "True" "Conj[" ", " "]" a;
showsl_formula showsl_atom (Disjunction fs) =
  let {
    a = map (showsl_formula showsl_atom) fs;
  } in showsl_list_gen id "False" "Disj[" ", " "]" a;

trivial_checker :: forall a. (Eq a) => [Formula a] -> Bool;
trivial_checker lits = (case partition is_Atom lits of {
                         (asa, nas) -> let {
 pos = map get_Atom asa;
 neg = map get_Atom nas;
                                       } in any (membera neg) pos;
                       });

trivial_clause_checker :: forall a. (Eq a) => Formula a -> Bool;
trivial_clause_checker f = (case f of {
                             Disjunction a -> trivial_checker a;
                           });

check_valid_formula ::
  forall a b c d.
    (Eq a, Eq b, Showl b, Eq c, Default d,
      Showl d) => (Term a (b, c) -> String -> String) ->
                    (d -> Formula (Term a (b, c)) ->
                            Sum (String -> String) ()) ->
                      (Bool -> Term a (b, c) -> Formula (Term a (b, c))) ->
                        d -> Formula (Term a (b, c)) ->
                               Sum (String -> String) ();
check_valid_formula showsl_atom logic_checker normalize_lit h phi =
  catch_errora
    (case flatten phi of {
      Conjunction phi_s ->
        catch_errora
          (forallM
            (\ phia ->
              catch_errora
                (check (trivial_clause_checker phia)
                  "trivial clause checker failed")
                (\ _ ->
                  (case flatten (normalize_lits normalize_lit phia) of {
                    Conjunction phi_sa ->
                      catch_errora (forallM (logic_checker h) phi_sa)
                        (\ x -> Inl (snd x));
                  })))
            phi_s)
          (\ x -> Inl (snd x));
    })
    (\ x ->
      Inl (((showsl_lit "problem in checking validity of formula " .
              showsl_formula showsl_atom phi) .
             showsl_literal "\n") .
            x));

iA_exp_to_tpoly :: forall a. Term Siga (a, Ty) -> Tpoly a Int;
iA_exp_to_tpoly (Var (a, ty)) = PVar a;
iA_exp_to_tpoly (Fun (SumFa uu) asa) = PSum (map iA_exp_to_tpoly asa);
iA_exp_to_tpoly (Fun (ConstFa a) []) = PNum a;
iA_exp_to_tpoly (Fun (ProdF uv) asa) = PMult (map iA_exp_to_tpoly asa);

iA_exp_to_poly ::
  forall a. (Eq a, Linorder a) => Term Siga (a, Ty) -> [(Monom a, Int)];
iA_exp_to_poly = poly_of . iA_exp_to_tpoly;

showsl_IA_exp ::
  forall a.
    (Eq a, Linorder a, Showl a) => Term Siga (a, Ty) -> String -> String;
showsl_IA_exp (Fun LessF [s, t]) =
  (showsl_IA_exp s . showsl_lit " < ") . showsl_IA_exp t;
showsl_IA_exp (Fun LeF [s, t]) =
  (showsl_IA_exp s . showsl_lit " <= ") . showsl_IA_exp t;
showsl_IA_exp (Fun EqF [s, t]) =
  (showsl_IA_exp s . showsl_lit " = ") . showsl_IA_exp t;
showsl_IA_exp (Var v) = showsl_poly (iA_exp_to_poly (Var v));
showsl_IA_exp (Fun LeF []) =
  (showsl_poly :: [(Monom a, Int)] -> String -> String)
    ((iA_exp_to_poly :: Term Siga (a, Ty) -> [(Monom a, Int)]) (Fun LeF []));
showsl_IA_exp (Fun LeF [v]) = showsl_poly (iA_exp_to_poly (Fun LeF [v]));
showsl_IA_exp (Fun LeF (v : vc : ve : vf)) =
  showsl_poly (iA_exp_to_poly (Fun LeF (v : vc : ve : vf)));
showsl_IA_exp (Fun (SumFa vb) va) =
  showsl_poly (iA_exp_to_poly (Fun (SumFa vb) va));
showsl_IA_exp (Fun (ConstFa vb) va) =
  showsl_poly (iA_exp_to_poly (Fun (ConstFa vb) va));
showsl_IA_exp (Fun (ProdF vb) va) =
  showsl_poly (iA_exp_to_poly (Fun (ProdF vb) va));
showsl_IA_exp (Fun EqF []) =
  (showsl_poly :: [(Monom a, Int)] -> String -> String)
    ((iA_exp_to_poly :: Term Siga (a, Ty) -> [(Monom a, Int)]) (Fun EqF []));
showsl_IA_exp (Fun EqF [v]) = showsl_poly (iA_exp_to_poly (Fun EqF [v]));
showsl_IA_exp (Fun EqF (v : vc : ve : vf)) =
  showsl_poly (iA_exp_to_poly (Fun EqF (v : vc : ve : vf)));
showsl_IA_exp (Fun v []) =
  (showsl_poly :: [(Monom a, Int)] -> String -> String)
    ((iA_exp_to_poly :: Term Siga (a, Ty) -> [(Monom a, Int)]) (Fun v []));
showsl_IA_exp (Fun v [vb]) = showsl_poly (iA_exp_to_poly (Fun v [vb]));
showsl_IA_exp (Fun v (vb : vd : vf : vg)) =
  showsl_poly (iA_exp_to_poly (Fun v (vb : vd : vf : vg)));

to_IAa :: forall a. Term Sigb a -> [Term Siga (a, Ty)];
to_IAa (Var x) = [Var (x, IntT)];
to_IAa (Fun f ss) =
  (case f of {
    ConstFb n -> [Fun (ConstFa (int_of_nat n)) []];
    SumFb ->
      (if null ss then [Fun (SumFa zero_nat) []]
        else map (Fun (SumFa (size_list ss))) (product_lists (map to_IAa ss)));
    ProdFa ->
      (if null ss then [Fun (ProdF zero_nat) []]
        else map (Fun (ProdF (size_list ss))) (product_lists (map to_IAa ss)));
    MaxFa ->
      (if null ss then [Fun (ConstFa zero_int) []] else concatMap to_IAa ss);
  });

le_via_IAa ::
  forall a. Term Sigb a -> Term Sigb a -> Formula (Term Siga (a, Ty));
le_via_IAa s t =
  form_or
    (form_not
      (Conjunction
        (map (\ x -> Atom (Fun LeF [Fun (ConstFa zero_int) [], Var (x, IntT)]))
          (vars_term_list s ++ vars_term_list t))))
    (Conjunction
      (map (\ sa ->
             Disjunction (map (\ ta -> Atom (Fun LeF [sa, ta])) (to_IAa t)))
        (to_IAa s)));

ea :: forall a b.
        (Eq a, Showl a,
          Showl b) => [((a, Nat), Term b Nat)] ->
                        (Nat -> b) -> a -> Nat -> Term b Nat;
ea alist default_fun =
  curry (fun_of_map_fun (map_of alist)
          (\ (_, n) -> Fun (default_fun n) (map Var (upt zero_nat n))));

lit_normalize ::
  forall a. Bool -> Term Siga (a, Ty) -> Formula (Term Siga (a, Ty));
lit_normalize False e = NegAtom e;
lit_normalize True (Fun LessF [a, b]) = NegAtom (Fun LeF [b, a]);
lit_normalize True (Fun LeF [a, b]) = NegAtom (Fun LessF [b, a]);
lit_normalize True (Fun EqF [a, b]) =
  Conjunction [NegAtom (Fun LessF [a, b]), NegAtom (Fun LessF [b, a])];
lit_normalize True (Var x) = Atom (Var x);

poly_minus ::
  forall a b.
    (Eq a, Linorder a, Eq b,
      Ring_1 b) => [(Monom a, b)] -> [(Monom a, b)] -> [(Monom a, b)];
poly_minus f g = poly_add f (monom_mult_poly (one_monom, uminus onea) g);

iA_exp_to_poly_constraint ::
  forall a. (Eq a, Linorder a) => Term Siga (a, Ty) -> Poly_constraint a;
iA_exp_to_poly_constraint (Fun LeF [a, b]) =
  Poly_Ge (poly_minus (iA_exp_to_poly b) (iA_exp_to_poly a));
iA_exp_to_poly_constraint (Fun EqF [a, b]) =
  Poly_Eq (poly_minus (iA_exp_to_poly b) (iA_exp_to_poly a));
iA_exp_to_poly_constraint (Fun LessF [a, b]) =
  Poly_Ge
    (poly_minus (poly_minus (iA_exp_to_poly b) (iA_exp_to_poly a)) one_poly);

showsl_poly_constraint ::
  forall a.
    (Eq a, Linorder a, Showl a) => Poly_constraint a -> String -> String;
showsl_poly_constraint (Poly_Ge p) = showsl_poly p . showsl_lit " >= 0";
showsl_poly_constraint (Poly_Eq p) = showsl_poly p . showsl_lit " = 0";

unsat_bool_checker :: forall a. (Eq a) => [Formula a] -> Bool;
unsat_bool_checker blits = any (\ blit -> membera blits (form_not blit)) blits;

translate_atom :: forall a. Formula a -> a;
translate_atom (Atom e) = e;

translate_atoms :: forall a. [Formula a] -> [a];
translate_atoms = map translate_atom;

split_bool_vars ::
  forall a b.
    [Formula (Term a b)] -> ([Formula (Term a b)], [Formula (Term a b)]);
split_bool_vars = partition (\ lit -> is_Var (get_Atom lit));

translate_conj ::
  forall a b. Formula (Term a b) -> ([Formula (Term a b)], [Term a b]);
translate_conj (Conjunction phi_s) =
  (case split_bool_vars phi_s of {
    (bvars, ia_lits) -> (bvars, translate_atoms ia_lits);
  });

vars_poly_constraint_list ::
  forall a. (Eq a, Linorder a) => Poly_constraint a -> [a];
vars_poly_constraint_list (Poly_Ge p) = poly_vars_list p;
vars_poly_constraint_list (Poly_Eq p) = poly_vars_list p;

interpret_poly_constraint ::
  forall a. (Linorder a) => (a -> Int) -> Poly_constraint a -> Bool;
interpret_poly_constraint f (Poly_Ge p) = less_eq_int zero_int (eval_poly f p);
interpret_poly_constraint f (Poly_Eq p) = equal_int (eval_poly f p) zero_int;

lp_monom :: Rat -> Nat -> Linear_poly;
lp_monom c x =
  LinearPoly (if equal_rat c zero_rat then fmempty else fmupd x c fmempty);

monom_list_linearity :: forall a. [(a, Nat)] -> Linearity a;
monom_list_linearity [] = Onea;
monom_list_linearity [(x, n)] =
  (if equal_nat n one_nat then Variable x else Non_Linear);
monom_list_linearity (v : vb : vc) = Non_Linear;

monom_linearity :: forall a. (Linorder a) => Monom a -> Linearity a;
monom_linearity xa = monom_list_linearity (rep_monom xa);

ipoly_to_linear_poly ::
  forall a.
    (Linorder a) => (a -> Nat) -> [(Monom a, Int)] -> Maybe (Linear_poly, Int);
ipoly_to_linear_poly rho [] = Just (zero_linear_poly, zero_int);
ipoly_to_linear_poly rho ((monomial, c) : rest) =
  bind (ipoly_to_linear_poly rho rest)
    (\ (p, d) ->
      (case monom_linearity monomial of {
        Non_Linear -> Nothing;
        Onea -> Just (p, plus_int c d);
        Variable x ->
          Just (plus_linear_poly (lp_monom (of_int c) (rho x)) p, d);
      }));

to_linear_constraints ::
  forall a. (Linorder a) => (a -> Nat) -> Poly_constraint a -> [Constraint];
to_linear_constraints rho (Poly_Ge p) =
  (case ipoly_to_linear_poly rho p of {
    Nothing -> [];
    Just (q, c) -> [GEQ q (of_int (uminus_int c))];
  });
to_linear_constraints rho (Poly_Eq p) =
  (case ipoly_to_linear_poly rho p of {
    Nothing -> [];
    Just (q, c) -> [EQ q (of_int (uminus_int c))];
  });

unsat_via_la_solver ::
  forall a.
    (Ccompare a, Eq a, Mapping_impl a,
      Linorder a) => La_solver_type ->
                       [Poly_constraint a] -> Maybe (Maybe ([a], a -> Int));
unsat_via_la_solver typea les =
  let {
    vs = remdups (concatMap vars_poly_constraint_list les);
    ren_map = of_alist (zip vs (upt zero_nat (size_list vs)));
    ren_fun = (\ v -> (case lookupb ren_map v of {
                        Nothing -> zero_nat;
                        Just n -> n;
                      }));
    cs = concatMap (to_linear_constraints ren_fun) les;
  } in (case la_solver typea cs of {
         Nothing -> Just Nothing;
         Just beta ->
           let {
             alpha = beta . ren_fun;
           } in (if all (interpret_poly_constraint alpha) les
                  then Just (Just (vs, alpha)) else Nothing);
       });

unsat_checker ::
  forall a.
    (Ccompare a, Eq a, Mapping_impl a, Linorder a,
      Showl a) => La_solver_type ->
                    [Poly_constraint a] -> Sum (String -> String) ();
unsat_checker solver cnjs =
  catch_errora
    (case unsat_via_la_solver solver cnjs of {
      Nothing ->
        Inl (showsl_lit
              "could not use linear arithmetic solver to prove unsatisfiability");
      Just Nothing -> Inr ();
      Just (Just (vs, alpha)) ->
        Inl (showsl_lit "the linear inequalities are satisfiable:\n" .
              showsl_list_gen
                (\ v ->
                  (showsl_monom (var_monom v) . showsl_lit " := ") .
                    showsl_int (alpha v))
                "" "" "\n" "" vs);
    })
    (\ x ->
      Inl (((((showsl_lit "The linear inequalities\n  " .
                showsl_sep showsl_poly_constraint (showsl_lit "\n  ") cnjs) .
               showsl_lit "\ncannot be proved unsatisfiable via solver\n  ") .
              showsl_la_solver_type solver) .
             showsl_literal "\n") .
            x));

check_clause ::
  forall a.
    (Ccompare a, Eq a, Mapping_impl a, Linorder a,
      Showl a) => La_solver_type ->
                    Formula (Term Siga (a, Ty)) -> Sum (String -> String) ();
check_clause typea phi =
  (case translate_conj (form_not phi) of {
    (bvars, ia_lits) ->
      let {
        es = map iA_exp_to_poly_constraint ia_lits;
      } in (if unsat_bool_checker bvars then Inr ()
             else catch_errora (unsat_checker typea es)
                    (\ x ->
                      Inl (((showsl_lit
                               "Could not prove unsatisfiability of IA conjunction\n" .
                              showsl_list_gen showsl_poly_constraint "False" ""
                                " && " "" es) .
                             showsl_literal "\n") .
                            x)));
  });

eval :: forall a b c. (a -> [b] -> b) -> Term a c -> (c -> b) -> b;
eval i (Var x) alpha = alpha x;
eval i (Fun f ss) alpha = i f (map (\ s -> eval i s alpha) ss);

check_less_eq_terma ::
  forall a b.
    (Eq a, Showl a, Ccompare b, Eq b, Mapping_impl b, Linorder b,
      Showl b) => [((a, Nat), Term Sigb Nat)] ->
                    La_solver_type ->
                      Term a b -> Term a b -> Sum (String -> String) ();
check_less_eq_terma alist solver s t =
  check_valid_formula showsl_IA_exp check_clause lit_normalize solver
    (le_via_IAa
      (eval (\ f ss ->
              eval_term Fun
                (ea (simplified_alista alist) (\ _ -> MaxFa) f (size_list ss))
                (nth ss))
        s Var)
      (eval (\ f ss ->
              eval_term Fun
                (ea (simplified_alista alist) (\ _ -> MaxFa) f (size_list ss))
                (nth ss))
        t Var));

less_via_IAa ::
  forall a. Term Sigb a -> Term Sigb a -> Formula (Term Siga (a, Ty));
less_via_IAa s t =
  form_or
    (form_not
      (Conjunction
        (map (\ x -> Atom (Fun LeF [Fun (ConstFa zero_int) [], Var (x, IntT)]))
          (vars_term_list s ++ vars_term_list t))))
    (Conjunction
      (map (\ sa ->
             Disjunction (map (\ ta -> Atom (Fun LessF [sa, ta])) (to_IAa t)))
        (to_IAa s)));

check_less_terma ::
  forall a b.
    (Eq a, Showl a, Ccompare b, Eq b, Mapping_impl b, Linorder b,
      Showl b) => [((a, Nat), Term Sigb Nat)] ->
                    La_solver_type ->
                      Term a b -> Term a b -> Sum (String -> String) ();
check_less_terma alist solver s t =
  check_valid_formula showsl_IA_exp check_clause lit_normalize solver
    (less_via_IAa
      (eval (\ f ss ->
              eval_term Fun
                (ea (simplified_alista alist) (\ _ -> MaxFa) f (size_list ss))
                (nth ss))
        s Var)
      (eval (\ f ss ->
              eval_term Fun
                (ea (simplified_alista alist) (\ _ -> MaxFa) f (size_list ss))
                (nth ss))
        t Var));

showsl_encoding ::
  forall a b.
    (Showl a, Showl b) => [((a, Nat), Term b Nat)] -> String -> String;
showsl_encoding alist =
  showsl_sep
    (\ (a, b) ->
      (case a of {
        (f, n) ->
          (\ e ->
            (showsl f .
              showsl_list_gen (\ i -> showsl_lit "x" . showsl_nat i) " = " "("
                "," ") = " (upt zero_nat n)) .
              showsl_term showsl (\ i -> showsl_lit "x" . showsl_nat i) e);
      })
        b)
    (showsl_literal "\n") alist;

check_encoding ::
  forall a b.
    (Showl a, Showl b) => [((a, Nat), Term b Nat)] -> Sum (String -> String) ();
check_encoding alist =
  catch_errora
    (forallM
      (\ (a, b) ->
        (case a of {
          (f, n) ->
            (\ t ->
              check (less_eq_set (vars_term t) (atLeastLessThan zero_nat n))
                ((((showsl_lit "interpretation of " . showsl f) .
                    showsl_lit " arity ") .
                   showsl_nat n) .
                  showsl_lit " has extra parameter"));
        })
          b)
      alist)
    (\ x -> Inl (snd x));

constant_positions :: forall a b. (a -> Nat -> Term b Nat) -> a -> Nat -> [Nat];
constant_positions e f n =
  filter (\ i -> not (contains_var_term i (e f n))) (upt zero_nat n);

minus_set :: forall a. (Ceq a, Ccompare a) => Set a -> Set a -> Set a;
minus_set (RBT_set rbt1) (RBT_set rbt2) =
  (case (ccompare :: Maybe (a -> a -> Ordera)) of {
    Nothing ->
      (error :: forall a. String -> (() -> a) -> a)
        "minus RBT_set RBT_set: ccompare = None"
        (\ _ -> minus_set (RBT_set rbt1) (RBT_set rbt2));
    Just _ -> RBT_set (minus rbt1 rbt2);
  });
minus_set a b = inf_set a (uminus_set b);

create_max_poly_rel_impl ::
  forall a b.
    (Eq a, Showl a, Ccompare b, Eq b, Mapping_impl b, Linorder b,
      Showl b) => [((a, Nat), Term Sigb Nat)] ->
                    La_solver_type -> Rel_impl_ext a b ();
create_max_poly_rel_impl alist solver =
  Rel_impl_ext (check_encoding (simplified_alista alist)) (Inr ())
    ((showsl_lit "max-polynomial interpretations:" . showsl_literal "\n") .
      showsl_encoding (simplified_alista alist))
    (\ (s, t) -> check_less_terma alist solver t s)
    (\ (s, t) -> check_less_eq_terma alist solver t s)
    (\ (s, t) -> check_less_eq_terma alist solver t s)
    (\ (f, n) ->
      minus_set (atLeastLessThan zero_nat n)
        (set (constant_positions (ea (simplified_alista alist) (\ _ -> MaxFa)) f
               n)))
    (\ (f, n) ->
      minus_set (atLeastLessThan zero_nat n)
        (set (constant_positions (ea (simplified_alista alist) (\ _ -> MaxFa)) f
               n)))
    (Inr ()) (Inr ()) (Inr ()) (Inr ()) (Inr ()) (Inr ()) empty_af
    (\ _ -> Inl (showsl_lit "monotonicity of max-poly is not yet supported"))
    (Just (map fst (simplified_alista alist))) Nothing no_complexity_check ();

max_poly_rel_impl ::
  forall a b.
    (Eq a, Showl a, Ccompare b, Eq b, Mapping_impl b, Linorder b,
      Showl b) => Max_poly_impl a -> Rel_impl_ext a b ();
max_poly_rel_impl (Max_Poly_Impl typea rp) = create_max_poly_rel_impl rp typea;

not_wst :: forall a b c. Rel_impl_ext a b c -> Maybe [(a, Nat)];
not_wst
  (Rel_impl_ext valid standard desc s ns nst af top_af sn subst_s ce_compat
    co_rewr top_mono top_refl mono_af mono not_wst not_sst cpx more)
  = not_wst;

mono_af_entry :: Nat -> Af_entry -> Bool;
mono_af_entry n (Collapse i) = less_eq_nat n one_nat;
mono_af_entry n (AFList ids) = all (membera ids) (upt zero_nat n);

afs_syms :: forall a. Afs a -> Set (a, Nat);
afs_syms xa = snd (rep_afs xa);

mono_afs :: forall a. (Ceq a, Ccompare a) => Afs a -> Bool;
mono_afs pi = ball (afs_syms pi) (\ (f, n) -> mono_af_entry n (afs pi (f, n)));

check_mono_afs ::
  forall a. (Ceq a, Ccompare a) => Afs a -> Sum (String -> String) ();
check_mono_afs pi =
  check (mono_afs pi) (showsl_literal "argument filter is not monotone");

afs_with_af ::
  forall a.
    (Compare_order a) => Afs a -> ((a, Nat) -> Set Nat) -> (a, Nat) -> Set Nat;
afs_with_af pia pi fn =
  (case afs pia fn of {
    Collapse j -> inserta j (set_empty (of_phantom set_impl_nat));
    AFList ids -> (if ids == upt zero_nat (snd fn) then pi fn else set ids);
  });

showsl_afs :: forall a. (Showl a) => [((a, Nat), Af_entry)] -> String -> String;
showsl_afs af =
  foldr (\ (a, b) ->
          (case a of {
            (f, n) ->
              (\ e ->
                (((((showsl_literal "pi(" . showsl f) . showsl_literal "/") .
                    showsl_nat n) .
                   showsl_literal ") = ") .
                  (case e of {
                    Collapse i -> showsl_nat (suc i);
                    AFList ids -> showsl_list_nat (map suc ids);
                  })) .
                  showsl_literal "\n");
          })
            b)
    af;

apply_af_entry :: forall a b. a -> Af_entry -> [Term a b] -> Term a b;
apply_af_entry uu (Collapse i) ts = nth ts i;
apply_af_entry f (AFList is) ts = Fun f (map (nth ts) is);

af_term :: forall a b. Afs a -> Term a b -> Term a b;
af_term pi (Fun f ts) =
  apply_af_entry f (afs pi (f, size_list ts)) (map (af_term pi) ts);
af_term pi (Var x) = Var x;

af_check ::
  forall a b.
    (Showl a,
      Showl b) => (String -> String) ->
                    Afs a ->
                      ((Term a b, Term a b) -> Sum (String -> String) ()) ->
                        (Term a b, Term a b) -> Sum (String -> String) ();
af_check r pi g lr =
  let {
    pl = af_term pi (fst lr);
    pr = af_term pi (snd lr);
  } in catch_errora (g (pl, pr))
         (\ x ->
           Inl (((((((((((((((showsl_literal "could not orient " .
                               showsl_terma (fst lr)) .
                              showsl_literal " ") .
                             r) .
                            showsl_literal " ") .
                           showsl_terma (snd lr)) .
                          showsl_literal "\npi( ") .
                         showsl_terma (fst lr)) .
                        showsl_literal " ) = ") .
                       showsl_terma pl) .
                      showsl_literal "\npi( ") .
                     showsl_terma (snd lr)) .
                    showsl_literal " ) = ") .
                   showsl_terma pr) .
                  showsl_literal "\n") .
                 x));

rep_x_compare_order_x_x_f_afs_option_x_x_nat_x_compare_order_x_x_f_prod_set_af_entry_nat_x_compare_order_x_x_f_prod_fun_prod_option ::
  forall a.
    (Compare_order a) => X_compare_order_x_x_f_afs_option_x_x_nat_x_compare_order_x_x_f_prod_set_af_entry_nat_x_compare_order_x_x_f_prod_fun_prod_option
                           a ->
                           Maybe ((a, Nat) -> Af_entry, Set (a, Nat));
rep_x_compare_order_x_x_f_afs_option_x_x_nat_x_compare_order_x_x_f_prod_set_af_entry_nat_x_compare_order_x_x_f_prod_fun_prod_option
  (Abs_x_compare_order_x_x_f_afs_option_x_x_nat_x_compare_order_x_x_f_prod_set_af_entry_nat_x_compare_order_x_x_f_prod_fun_prod_option
    x)
  = x;

sel21a ::
  forall a.
    (Compare_order a) => X_compare_order_x_x_f_afs_option_x_x_nat_x_compare_order_x_x_f_prod_set_af_entry_nat_x_compare_order_x_x_f_prod_fun_prod_option
                           a ->
                           Afs a;
sel21a xa =
  Abs_afs
    (case rep_x_compare_order_x_x_f_afs_option_x_x_nat_x_compare_order_x_x_f_prod_set_af_entry_nat_x_compare_order_x_x_f_prod_fun_prod_option
            xa
      of {
      Nothing -> rep_afs (error "undefined");
      Just x2 -> x2;
    });

dis1a ::
  forall a.
    (Compare_order a) => X_compare_order_x_x_f_afs_option_x_x_nat_x_compare_order_x_x_f_prod_set_af_entry_nat_x_compare_order_x_x_f_prod_fun_prod_option
                           a ->
                           Bool;
dis1a xa =
  (case rep_x_compare_order_x_x_f_afs_option_x_x_nat_x_compare_order_x_x_f_prod_set_af_entry_nat_x_compare_order_x_x_f_prod_fun_prod_option
          xa
    of {
    Nothing -> True;
    Just _ -> False;
  });

rep_isoma ::
  forall a.
    (Compare_order a) => X_compare_order_x_x_f_afs_option_x_x_nat_x_compare_order_x_x_f_prod_set_af_entry_nat_x_compare_order_x_x_f_prod_fun_prod_option
                           a ->
                           Maybe (Afs a);
rep_isoma x = (if dis1a x then Nothing else Just (sel21a x));

default_af_entry :: Nat -> Af_entry;
default_af_entry n = AFList (upt zero_nat n);

wf_af_entry :: Nat -> Af_entry -> Bool;
wf_af_entry n (Collapse i) = less_nat i n;
wf_af_entry n (AFList is) = all (\ i -> less_nat i n) is;

afs_of_aux ::
  forall a.
    (Ceq a, Ccompare a, Compare_order a,
      Set_impl a) => [((a, Nat), Af_entry)] ->
                       X_compare_order_x_x_f_afs_option_x_x_nat_x_compare_order_x_x_f_prod_set_af_entry_nat_x_compare_order_x_x_f_prod_fun_prod_option
                         a;
afs_of_aux xa =
  Abs_x_compare_order_x_x_f_afs_option_x_x_nat_x_compare_order_x_x_f_prod_set_af_entry_nat_x_compare_order_x_x_f_prod_fun_prod_option
    (if all (\ ((_, n), e) -> wf_af_entry n e) xa
      then Just (fun_of_map_fun (ceta_map_of xa)
                   (\ fn -> default_af_entry (snd fn)),
                  set (map fst xa))
      else Nothing);

afs_of ::
  forall a.
    (Ceq a, Ccompare a, Compare_order a,
      Set_impl a) => [((a, Nat), Af_entry)] -> Maybe (Afs a);
afs_of x = rep_isoma (afs_of_aux x);

afs_sym :: forall a. Afs a -> (a, Nat) -> [(Filtered a, Nat)];
afs_sym af (f, n) = (case afs af (f, n) of {
                      Collapse _ -> [];
                      AFList is -> [(FPair f n, size_list is)];
                    });

afs_sig :: forall a. Afs a -> [(a, Nat)] -> [(Filtered a, Nat)];
afs_sig af = concatMap (afs_sym af);

af_sig :: forall a. Afs a -> [(a, Nat)] -> [(a, Nat)];
af_sig af = map (map_prod filtered_fun id) . afs_sig af;

filtered_rel_impl_af ::
  forall a b.
    (Ceq a, Ccompare a, Compare_order a, Set_impl a, Showl a,
      Showl b) => [((a, Nat), Af_entry)] ->
                    Rel_impl_ext a b () -> Rel_impl_ext a b ();
filtered_rel_impl_af pi rp =
  let {
    afso = afs_of pi;
    afs = the afso;
    afa = afs_with_af afs (af rp);
  } in Rel_impl_ext
         (bindb
           (check (not (is_none afso))
             (showsl_literal "invalid positions in argument filter"))
           (\ _ ->
             bindb (valid rp)
               (\ _ -> bindb (top_refl rp) (\ _ -> standard rp))))
         (Inr ())
         (((showsl_literal "Argument Filter:\n" . showsl_afs pi) .
            showsl_literal "\n") .
           desca rp)
         (af_check (showsl_literal ">") afs (s rp))
         (af_check (showsl_literal ">=") afs (ns rp))
         (af_check (showsl_literal ">=") afs (nst rp)) afa full_af (sn rp)
         (subst_s rp) (ce_compat rp) (co_rewr rp)
         (Inl (showsl_lit "top-mono with argument filter not yet supported"))
         (Inr ()) empty_af
         (\ sig -> bindb (check_mono_afs afs) (\ _ -> mono rp (af_sig afs sig)))
         (map_option (\ a -> map fst pi ++ a) (not_wst rp)) Nothing
         no_complexity_check ();

dms_preprocess :: [[(Nat, (Bool, Bool))]] -> [[(Nat, (Bool, Bool))]];
dms_preprocess p = map (filter (\ (_, (a, b)) -> a || b)) p;

dms_simplify ::
  Bool -> [Nat] -> [[(Nat, (Bool, Bool))]] -> [[(Nat, (Bool, Bool))]];
dms_simplify stri is p = (if any (\ i -> null (nth p i)) is then [[]] else p);

dms_decide_singletons :: Bool -> Nat -> [(Nat, (Bool, Bool))] -> Bool;
dms_decide_singletons stri n p =
  let {
    d = minus_nat (size_list p) one_nat;
  } in (if less_nat d (size_list p)
         then all_interval
                (\ i ->
                  (case nth p i of {
                    (j, (s, ns)) ->
                      s && not (membera (drop (suc i) p) (j, (False, True))) ||
                        ns && not (membera (map fst (drop (suc i) p)) j);
                  }))
                zero_nat d
         else True) &&
    (if stri
      then any (\ j -> not (membera p (j, (False, True)))) (upt zero_nat n)
      else True);

dms_select :: Bool -> [[(Nat, (Bool, Bool))]] -> Nat;
dms_select stri p =
  snd (hda (sort_key fst
             (filter (\ (l, _) -> less_nat one_nat l)
               (zip (map size_list p) (upt zero_nat (size_list p))))));

dms_solve_or_select :: Bool -> Nat -> [[(Nat, (Bool, Bool))]] -> Sum Bool Nat;
dms_solve_or_select stri n p =
  (if all (\ jsns -> less_eq_nat (size_list jsns) one_nat) p
    then Inl (if membera p [] then False
               else dms_decide_singletons stri n (map hda p))
    else Inr (dms_select stri p));

dms_solve :: Bool -> Nat -> [[(Nat, (Bool, Bool))]] -> Bool;
dms_solve stri n p =
  (case dms_solve_or_select stri n p of {
    Inl res -> res;
    Inr k ->
      let {
        ksns = nth p k;
      } in dms_solve stri n
             (dms_simplify stri [k] (list_update p k [hda ksns])) ||
             dms_solve stri n
               (dms_simplify stri [k] (list_update p k (tla ksns)));
  });

dms_bool_ex_idx_impl :: Bool -> Nat -> [[(Nat, (Bool, Bool))]] -> Bool;
dms_bool_ex_idx_impl stri n p =
  dms_solve stri n
    (dms_simplify stri (upt zero_nat (size_list p)) (dms_preprocess p));

dms_bool_ex_idx :: Bool -> Nat -> [[(Nat, (Bool, Bool))]] -> Bool;
dms_bool_ex_idx = dms_bool_ex_idx_impl;

dms_convert ::
  forall a. (a -> a -> (Bool, Bool)) -> [a] -> [a] -> [[(Nat, (Bool, Bool))]];
dms_convert f asa bs = let {
                         jbs = zip (upt zero_nat (size_list bs)) bs;
                       } in map (\ a -> map (\ (j, b) -> (j, f a b)) jbs) asa;

dms_order_ext ::
  forall a. Nat -> (a -> a -> (Bool, Bool)) -> [a] -> [a] -> (Bool, Bool);
dms_order_ext n f asa bs =
  let {
    p = dms_convert f asa bs;
    lts = size_list bs;
    len = less_eq_nat lts n || equal_nat (size_list asa) lts;
  } in (len && dms_bool_ex_idx True lts p, len && dms_bool_ex_idx False lts p);

min_set_ext :: forall a. (a -> a -> (Bool, Bool)) -> [a] -> [a] -> (Bool, Bool);
min_set_ext s_ns =
  (\ asa bs ->
    (not (null bs) && all (\ a -> any (\ b -> fst (s_ns a b)) bs) asa,
      all (\ a -> any (\ b -> snd (s_ns a b)) bs) asa));

mul_ext_impl ::
  forall a. (a -> a -> (Bool, Bool)) -> [a] -> [a] -> (Bool, Bool);
mul_ext_impl sns [] [] = (False, True);
mul_ext_impl sns [] (v : va) = (False, False);
mul_ext_impl sns (v : va) [] = (True, True);
mul_ext_impl sns (v : va) (y : ys) = mul_ex_dom sns (v : va) [] y ys;

mul_ex_dom ::
  forall a. (a -> a -> (Bool, Bool)) -> [a] -> [a] -> a -> [a] -> (Bool, Bool);
mul_ex_dom sns [] xs y ys = (False, False);
mul_ex_dom sns (x : xsa) xs y ys =
  (case sns x y of {
    (True, _) ->
      (if snd (mul_ext_impl sns (xsa ++ xs)
                (filter (\ ya -> not (fst (sns x ya))) ys))
        then (True, True) else mul_ex_dom sns xsa (x : xs) y ys);
    (False, True) ->
      or2 (mul_ext_impl sns (xsa ++ xs) ys) (mul_ex_dom sns xsa (x : xs) y ys);
    (False, False) -> mul_ex_dom sns xsa (x : xs) y ys;
  });

mul_ext :: forall a. (a -> a -> (Bool, Bool)) -> [a] -> [a] -> (Bool, Bool);
mul_ext = mul_ext_impl;

set_ext :: forall a. (a -> a -> (Bool, Bool)) -> [a] -> [a] -> (Bool, Bool);
set_ext s_ns =
  (\ asa bs ->
    (not (null asa) && all (\ b -> any (\ a -> fst (s_ns a b)) asa) bs,
      all (\ b -> any (\ a -> snd (s_ns a b)) asa) bs));

list_ext ::
  forall a.
    Nat ->
      List_order_type -> (a -> a -> (Bool, Bool)) -> [a] -> [a] -> (Bool, Bool);
list_ext uu MS_Ext = mul_ext;
list_ext uv Max_Ext = set_ext;
list_ext uw Min_Ext = min_set_ext;
list_ext n Dms_Ext = dms_order_ext n;

pos_arctic_delta :: forall a. (Floor_ceiling a) => Arctic_delta a -> Bool;
pos_arctic_delta MinInfty_delta = False;
pos_arctic_delta (Num_arc_delta n) = less_eq zerob n;

check_poly_strict_mono_discrete ::
  forall a b.
    (Eq a, Poly_carrier a, Eq b,
      Linorder b) => (a -> a -> Bool) -> [(Monom b, a)] -> b -> Bool;
check_poly_strict_mono_discrete gt p v =
  check_poly_gt gt
    (poly_subst
      (\ w -> poly_of (if w == v then PSum [PNum onea, PVar v] else PVar w)) p)
    p;

univariate_power_list :: forall a. (Eq a) => a -> [(a, Nat)] -> Maybe Nat;
univariate_power_list x [(y, n)] = (if x == y then Just n else Nothing);
univariate_power_list uu [] = Nothing;
univariate_power_list uu (v : vb : vc) = Nothing;

univariate_power :: forall a. (Eq a, Linorder a) => a -> Monom a -> Maybe Nat;
univariate_power x xc = univariate_power_list x (rep_monom xc);

check_monom_strict_mono ::
  forall a. (Eq a, Linorder a) => Bool -> Monom a -> a -> Bool;
check_monom_strict_mono pm m v = (case univariate_power v m of {
                                   Nothing -> False;
                                   Just p -> pm || equal_nat p one_nat;
                                 });

check_poly_strict_mono ::
  forall a b.
    (Eq a, Linorder a, Poly_carrier b) => Bool -> [(Monom a, b)] -> a -> Bool;
check_poly_strict_mono pm p v =
  any (\ (m, c) -> less_eq onea c && check_monom_strict_mono pm m v) p;

check_poly_strict_mono_smart ::
  forall a b.
    (Eq a, Poly_carrier a, Eq b,
      Linorder b) => Bool ->
                       Bool -> (a -> a -> Bool) -> [(Monom b, a)] -> b -> Bool;
check_poly_strict_mono_smart discrete pm gt p v =
  (if discrete then check_poly_strict_mono_discrete gt p v
    else check_poly_strict_mono pm p v);

poly_inter_to_mono_af ::
  forall a b.
    (Eq a, Poly_carrier a,
      Compare_order b) => Bool ->
                            Bool ->
                              (a -> a -> Bool) ->
                                [((b, Nat), [(Monom Nat, a)])] ->
                                  (b, Nat) -> Set Nat;
poly_inter_to_mono_af discrete power_mono gt i =
  fun_of_map_fun
    (ceta_map_of
      (map (\ (a, b) ->
             (case a of {
               (f, n) ->
                 (\ e ->
                   ((f, n),
                     set (filter
                           (\ ia ->
                             check_poly_weak_mono_and_pos discrete e &&
                               check_poly_strict_mono_smart discrete power_mono
                                 gt e ia)
                           (upt zero_nat n))));
             })
               b)
        i))
    (\ fn -> atLeastLessThan zero_nat (snd fn));

check_poly_inter_list ::
  forall a b.
    (Eq a, Eq b,
      Poly_carrier b) => Bool ->
                           [((a, Nat), [(Monom Nat, b)])] ->
                             Sum (Sum (String -> String) (a, [(Monom Nat, b)]))
                               ();
check_poly_inter_list discrete i =
  bindb (check (distinct (map fst i))
          (Inl (showsl_literal "some symbol has two interpretations")))
    (\ _ ->
      catch_errora
        (catch_errora
          (forallM
            (\ x ->
              (if (case x of {
                    (_, a) -> check_poly_weak_mono_and_pos discrete a;
                  })
                then Inr () else Inl x))
            i)
          (\ x -> Inl (snd x)))
        (\ x -> Inl (case x of {
                      (a, b) -> (case a of {
                                  (f, _) -> (\ p -> Inr (f, p));
                                })
                                  b;
                    })));

less_eq_complexity_class :: Complexity_class -> Complexity_class -> Bool;
less_eq_complexity_class x y = less_eq_nat (degree x) (degree y);

check_ge_v :: forall a. (Poly_carrier a) => a -> [(Monom Nat, a)] -> Bool;
check_ge_v v p = (case p of {
                   [] -> True;
                   [(m, c)] -> equal_monom m one_monom && less_eq c v;
                   (_, _) : _ : _ -> False;
                 });

strongly_linear ::
  forall a. (Poly_carrier a) => Nat -> [(Monom Nat, a)] -> a -> Bool;
strongly_linear x p v =
  (if equal_nat x zero_nat then check_ge_v v p
    else (case poly_split (var_monom (minus_nat x one_nat)) p of {
           (a, pa) ->
             less_eq a onea && strongly_linear (minus_nat x one_nat) pa v;
         }));

sl_complexity_sig_check ::
  forall a b.
    (Poly_carrier b) => ((a, Nat) -> [(Monom Nat, b)]) ->
                          b -> [(a, Nat)] -> Sum (a, Nat) ();
sl_complexity_sig_check i v f =
  catch_errora
    (forallM (\ (fa, n) -> check (strongly_linear n (i (fa, n)) v) (fa, n)) f)
    (\ x -> Inl (snd x));

sl_complexity_check ::
  forall a b.
    (Poly_carrier a,
      Showl b) => a -> ((b, Nat) -> [(Monom Nat, a)]) ->
                         [(b, Nat)] -> Sum (String -> String) ();
sl_complexity_check v i f =
  let {
    w = max_v v i f;
  } in catch_errora (sl_complexity_sig_check i w f)
         (\ x ->
           Inl (case x of {
                 (fa, _) ->
                   (showsl_literal "symbol " . showsl fa) .
                     showsl_literal
                       " does not possess a strongly linear interpretation";
               }));

nl_complexity_check ::
  forall a b c.
    (Showl a,
      Poly_carrier b) => ((a, Nat) -> [(Monom Nat, b)]) ->
                           Complexity_measure a c ->
                             Complexity_class -> Sum (String -> String) ();
nl_complexity_check i (Derivational_Complexity f) cc =
  bindb (sl_complexity_check zerob i f)
    (\ _ ->
      check (less_eq_complexity_class (Comp_Poly one_nat) cc)
        (showsl_literal
          "cannot deduce constant complexity for derivational complexity"));
nl_complexity_check i (Runtime_Complexity c d) (Comp_Poly deg) =
  bindb (sl_complexity_check onea i c)
    (\ _ ->
      catch_errora
        (forallM
          (\ f ->
            check (less_eq_nat (poly_degree (i f)) deg)
              ((showsl_literal "degree of interpretation for " .
                 showsl_prod f) .
                showsl_literal " exceeds bound "))
          d)
        (\ x -> Inl (snd x)));

poly_vars ::
  forall a b.
    (Ceq a, Ccompare a, Linorder a, Set_impl a) => [(Monom a, b)] -> Set a;
poly_vars p = set (concatMap (monom_vars_list . fst) p);

poly_inter_to_af ::
  forall a b.
    (Compare_order a) => [((a, Nat), [(Monom Nat, b)])] -> (a, Nat) -> Set Nat;
poly_inter_to_af i =
  fun_of_map_fun (ceta_map_of (map (\ (fn, e) -> (fn, poly_vars e)) i))
    (\ fn -> atLeastLessThan zero_nat (snd fn));

create_nlpoly_rel_impl ::
  forall a b c.
    (Eq a, Poly_carrier a, Showl a, Compare_order b, Eq b, Showl b, Eq c,
      Linorder c,
      Showl c) => Sum (String -> String) () ->
                    a -> (a -> a -> Bool) ->
                           Bool ->
                             Bool ->
                               [((b, Nat), [(Monom Nat, a)])] ->
                                 Rel_impl_ext b c ();
create_nlpoly_rel_impl cI def gt power_mono discrete i =
  let {
    j = poly_inter_list_to_inter def i;
    x = poly_subst
          (\ n ->
            poly_of
              (PVar ([char_0x78, char_0x5F] ++ shows_prec_nat zero_nat n [])));
  } in Rel_impl_ext
         (bindb cI
           (\ _ ->
             catch_errora (check_poly_inter_list discrete i)
               (\ xa ->
                 Inl (case xa of {
                       Inl a -> id a;
                       Inr (f, p) ->
                         (((showsl_literal "interpretation " .
                             showsl_poly (x p)) .
                            showsl_literal " of ") .
                           showsl f) .
                           showsl_literal " invalid ";
                     }))))
         (Inr ())
         (showsl_literal "polynomial interpretation\n" .
           showsl_sep
             (\ (a, b) ->
               (case a of {
                 (f, n) ->
                   (\ p ->
                     ((((showsl_literal "Pol(" . showsl f) .
                         showsl_literal "/") .
                        showsl_nat n) .
                       showsl_literal ") = ") .
                       showsl_poly (x p));
               })
                 b)
             (showsl_literal "\n") i)
         (check_s gt j) (check_ns j) (check_ns j) (poly_inter_to_af i)
         (poly_inter_to_af i) (Inr ()) (Inr ()) (Inr ()) (Inr ()) (Inr ())
         (Inr ()) (poly_inter_to_mono_af discrete power_mono gt i)
         (\ _ ->
           catch_errora
             (catch_errora
               (forallM
                 (\ xa ->
                   (if (case xa of {
                         (a, b) ->
                           (case a of {
                             (_, n) ->
                               (\ p ->
                                 all (check_poly_strict_mono_smart discrete
                                       power_mono gt p)
                                   (upt zero_nat n));
                           })
                             b;
                       })
                     then Inr () else Inl xa))
                 i)
               (\ xa -> Inl (snd xa)))
             (\ xa ->
               Inl (case xa of {
                     (a, b) ->
                       (case a of {
                         (f, _) ->
                           (\ p ->
                             ((showsl_literal
                                 "could not ensure monotonicty of " .
                                showsl_poly (x p)) .
                               showsl_literal " as interpretation of ") .
                               showsl f);
                       })
                         b;
                   })))
         (Just (map fst i)) (Just (map fst i)) (nl_complexity_check j) ();

simplify :: forall a. (Eq a) => Term Sig a -> Term Sig a;
simplify (Var x) = Var x;
simplify (Fun (ConstF n) ss) = Fun (ConstF n) [];
simplify (Fun SumF ss) =
  let {
    ssa = filter (\ s -> not (equal_term s (Fun (ConstF zero_nat) [])))
            (map simplify ss);
  } in (case ssa of {
         [] -> Fun (ConstF zero_nat) [];
         [s] -> s;
         _ : _ : _ -> Fun SumF ssa;
       });
simplify (Fun MaxF ss) =
  let {
    ssa = filter (\ s -> not (equal_term s (Fun (ConstF zero_nat) [])))
            (map simplify ss);
  } in (case ssa of {
         [] -> Fun (ConstF zero_nat) [];
         [s] -> s;
         _ : _ : _ -> Fun MaxF ssa;
       });
simplify (Fun (MaxExtF c0 cds) ss) =
  (case map simplify ss of {
    [] -> Fun (ConstF c0) [];
    a : list -> Fun (MaxExtF c0 cds) (a : list);
  });

simplified_alist ::
  forall a.
    (Showl a) => [((a, Nat), Term Sig Nat)] -> [((a, Nat), Term Sig Nat)];
simplified_alist alist = map (map_prod id simplify) alist;

madd_IA :: forall a. Int -> Int -> Term Siga a -> Term Siga a;
madd_IA c d e =
  Fun (SumFa (nat_of_integer (2 :: Integer)))
    [Fun (ConstFa c) [],
      Fun (ProdF (nat_of_integer (2 :: Integer))) [Fun (ConstFa d) [], e]];

madd_IA_list ::
  forall a. [(Int, Nat)] -> [Term Siga (a, Ty)] -> [Term Siga (a, Ty)];
madd_IA_list uu [] = [];
madd_IA_list [] (e : es) = madd_IA zero_int one_int e : madd_IA_list [] es;
madd_IA_list ((c, d) : cds) (e : es) =
  madd_IA c (int_of_nat d) e : madd_IA_list cds es;

to_IA :: forall a. Term Sig a -> [Term Siga (a, Ty)];
to_IA (Var x) = [Var (x, IntT)];
to_IA (Fun f ss) =
  (case f of {
    ConstF n -> [Fun (ConstFa (int_of_nat n)) []];
    SumF ->
      (if null ss then [Fun (SumFa zero_nat) []]
        else map (Fun (SumFa (size_list ss))) (product_lists (map to_IA ss)));
    MaxF ->
      (if null ss then [Fun (ConstFa zero_int) []] else concatMap to_IA ss);
    MaxExtF c0 cds ->
      (if null ss then [Fun (ConstFa (int_of_nat c0)) []]
        else Fun (ConstFa (int_of_nat c0)) [] :
               concatMap (madd_IA_list cds) (product_lists (map to_IA ss)));
  });

le_via_IA :: forall a. Term Sig a -> Term Sig a -> Formula (Term Siga (a, Ty));
le_via_IA s t =
  form_or
    (form_not
      (Conjunction
        (map (\ x -> Atom (Fun LeF [Fun (ConstFa zero_int) [], Var (x, IntT)]))
          (vars_term_list s ++ vars_term_list t))))
    (Conjunction
      (map (\ sa ->
             Disjunction (map (\ ta -> Atom (Fun LeF [sa, ta])) (to_IA t)))
        (to_IA s)));

check_less_eq_term ::
  forall a b.
    (Eq a, Showl a, Ccompare b, Eq b, Mapping_impl b, Linorder b,
      Showl b) => [((a, Nat), Term Sig Nat)] ->
                    La_solver_type ->
                      Term a b -> Term a b -> Sum (String -> String) ();
check_less_eq_term alist solver s t =
  check_valid_formula showsl_IA_exp check_clause lit_normalize solver
    (le_via_IA
      (eval (\ f ss ->
              eval_term Fun
                (ea (simplified_alist alist) (\ _ -> MaxF) f (size_list ss))
                (nth ss))
        s Var)
      (eval (\ f ss ->
              eval_term Fun
                (ea (simplified_alist alist) (\ _ -> MaxF) f (size_list ss))
                (nth ss))
        t Var));

less_via_IA ::
  forall a. Term Sig a -> Term Sig a -> Formula (Term Siga (a, Ty));
less_via_IA s t =
  form_or
    (form_not
      (Conjunction
        (map (\ x -> Atom (Fun LeF [Fun (ConstFa zero_int) [], Var (x, IntT)]))
          (vars_term_list s ++ vars_term_list t))))
    (Conjunction
      (map (\ sa ->
             Disjunction (map (\ ta -> Atom (Fun LessF [sa, ta])) (to_IA t)))
        (to_IA s)));

check_less_term ::
  forall a b.
    (Eq a, Showl a, Ccompare b, Eq b, Mapping_impl b, Linorder b,
      Showl b) => [((a, Nat), Term Sig Nat)] ->
                    La_solver_type ->
                      Term a b -> Term a b -> Sum (String -> String) ();
check_less_term alist solver s t =
  check_valid_formula showsl_IA_exp check_clause lit_normalize solver
    (less_via_IA
      (eval (\ f ss ->
              eval_term Fun
                (ea (simplified_alist alist) (\ _ -> MaxF) f (size_list ss))
                (nth ss))
        s Var)
      (eval (\ f ss ->
              eval_term Fun
                (ea (simplified_alist alist) (\ _ -> MaxF) f (size_list ss))
                (nth ss))
        t Var));

create_max_monus_rel_impl ::
  forall a b.
    (Eq a, Showl a, Ccompare b, Eq b, Mapping_impl b, Linorder b,
      Showl b) => [((a, Nat), Term Sig Nat)] ->
                    La_solver_type -> Rel_impl_ext a b ();
create_max_monus_rel_impl alist solver =
  Rel_impl_ext (check_encoding (simplified_alist alist)) (Inr ())
    ((showsl_lit "max-monus interpretations:" . showsl_literal "\n") .
      showsl_encoding (simplified_alist alist))
    (\ (s, t) -> check_less_term alist solver t s)
    (\ (s, t) -> check_less_eq_term alist solver t s)
    (\ (s, t) -> check_less_eq_term alist solver t s)
    (\ (f, n) ->
      minus_set (atLeastLessThan zero_nat n)
        (set (constant_positions (ea (simplified_alist alist) (\ _ -> MaxF)) f
               n)))
    (\ (f, n) ->
      minus_set (atLeastLessThan zero_nat n)
        (set (constant_positions (ea (simplified_alist alist) (\ _ -> MaxF)) f
               n)))
    (Inr ()) (Inr ()) (Inr ()) (Inr ()) (Inr ()) (Inr ()) empty_af
    (\ _ -> Inl (showsl_lit "monotonicity of max-monus is not yet supported"))
    (Just (map fst (simplified_alist alist))) Nothing no_complexity_check ();

max_monus_rel_impl ::
  forall a b.
    (Eq a, Showl a, Ccompare b, Eq b, Mapping_impl b, Linorder b,
      Showl b) => Max_monus_impl a -> Rel_impl_ext a b ();
max_monus_rel_impl (Max_Monus_Impl typea rp) =
  create_max_monus_rel_impl rp typea;

class_semiring ::
  forall a b.
    (Ceq a, Ccompare a, One a, Plus a, Times a, Zero a,
      Set_impl a) => Itself a ->
                       b -> Partial_object_ext a (Monoid_ext a (Ring_ext a b));
class_semiring uu b =
  Partial_object_ext top_set (Monoid_ext times onea (Ring_ext zerob plus b));

class_ordered_semiring ::
  forall a b.
    (Ceq a, Ccompare a, Ordered_semiring_1a a,
      Set_impl a) => Itself a ->
                       (a -> a -> Bool) ->
                         b -> Partial_object_ext a
                                (Monoid_ext a
                                  (Ring_ext a (Ordered_semiring_ext a b)));
class_ordered_semiring a gt b =
  class_semiring a (Ordered_semiring_ext (\ x y -> less_eq y x) gt max b);

class_arc_complexity :: forall a. a -> Nat -> Sum (String -> String) ();
class_arc_complexity a deg =
  Inl (showsl_literal "complexity for arctic semirings not supported");

class_arc_lpoly_order ::
  forall a.
    (Ceq a, Ccompare a, Ordered_semiring_1a a,
      Set_impl a) => a -> (a -> Bool) ->
                            (a -> a -> Bool) ->
                              Partial_object_ext a
                                (Monoid_ext a
                                  (Ring_ext a
                                    (Ordered_semiring_ext a
                                      (Lpoly_order_semiring_ext a ()))));
class_arc_lpoly_order def apos gtt =
  class_ordered_semiring Type gtt
    (Lpoly_order_semiring_ext False def apos (\ _ -> False) (\ _ -> zero_nat)
      class_arc_complexity
      (showsl_lit "polynomial interpretation over arctic semiring") ());

fpair_f :: forall a. Filtered a -> a;
fpair_f (FPair x1 x2) = x1;

afs_to_af :: forall a. (Compare_order a) => Afs a -> (a, Nat) -> Set Nat;
afs_to_af pi fn =
  (case afs pi fn of {
    Collapse j -> inserta j (set_empty (of_phantom set_impl_nat));
    AFList a -> set a;
  });

afs_term :: forall a b. Afs a -> Term a b -> Term (Filtered a) b;
afs_term pi (Fun f ts) =
  let {
    l = size_list ts;
  } in apply_af_entry (FPair f l) (afs pi (f, l)) (map (afs_term pi) ts);
afs_term pi (Var x) = Var x;

afs_check ::
  forall a b.
    (Showl a,
      Showl b) => (String -> String) ->
                    Afs a ->
                      ((Term (Filtered a) b, Term (Filtered a) b) ->
                        Sum (String -> String) ()) ->
                        (Term a b, Term a b) -> Sum (String -> String) ();
afs_check r pi g lr =
  let {
    pl = afs_term pi (fst lr);
    pr = afs_term pi (snd lr);
  } in catch_errora (g (pl, pr))
         (\ x ->
           Inl (((((((((((((((showsl_literal "could not orient " .
                               showsl_terma (fst lr)) .
                              showsl_literal " ") .
                             r) .
                            showsl_literal " ") .
                           showsl_terma (snd lr)) .
                          showsl_literal "\npi( ") .
                         showsl_terma (fst lr)) .
                        showsl_literal " ) = ") .
                       showsl_terma pl) .
                      showsl_literal "\npi( ") .
                     showsl_terma (snd lr)) .
                    showsl_literal " ) = ") .
                   showsl_terma pr) .
                  showsl_literal "\n") .
                 x));

filtered_rel_impl ::
  forall a b.
    (Ceq a, Ccompare a, Compare_order a, Set_impl a, Showl a,
      Showl b) => [((a, Nat), Af_entry)] ->
                    Rel_impl_ext (Filtered a) b () -> Rel_impl_ext a b ();
filtered_rel_impl pi rp =
  let {
    afso = afs_of pi;
    afs = the afso;
    af = afs_to_af afs;
  } in Rel_impl_ext
         (bindb
           (check (not (is_none afso))
             (showsl_literal "invalid positions in argument filter"))
           (\ _ ->
             bindb (valid rp)
               (\ _ -> bindb (top_refl rp) (\ _ -> standard rp))))
         (Inr ())
         (((showsl_literal "Argument Filter:\n" . showsl_afs pi) .
            showsl_literal "\n") .
           desca rp)
         (afs_check (showsl_literal ">") afs (s rp))
         (afs_check (showsl_literal ">=") afs (ns rp))
         (afs_check (showsl_literal ">=") afs (nst rp)) af full_af (sn rp)
         (subst_s rp) (ce_compat rp) (co_rewr rp)
         (Inl (showsl_lit "top-mono with argument filter not yet supported"))
         (Inr ()) empty_af
         (\ sig ->
           bindb (check_mono_afs afs) (\ _ -> mono rp (afs_sig afs sig)))
         (map_option (\ fs -> map fst pi ++ map (\ (f, a) -> (fpair_f f, a)) fs)
           (not_wst rp))
         Nothing no_complexity_check ();

prec_weight_ac_repr_to_prec_weight_funs ::
  forall a.
    (Ceq a, Ccompare a, Compare_order a,
      Set_impl a) => ([((a, Nat), (Nat, (Nat, Bool)))], Nat) ->
                       ((a, Nat) -> (a, Nat) -> Bool,
                         ((a, Nat) -> Nat, (Nat, Set a)));
prec_weight_ac_repr_to_prec_weight_funs prw_w0 =
  (case prw_w0 of {
    (prw, w0) ->
      let {
        prwm = ceta_map_of prw;
        w_fun = fun_of_map_funa prwm (\ _ -> suc w0) (fst . snd);
        p_fun = prec_exta prwm;
        acset =
          set (map_filter
                (\ x ->
                  (if (case x of {
                        (a, b) -> (case a of {
                                    (_, _) -> (\ (_, (_, ac)) -> ac);
                                  })
                                    b;
                      })
                    then Just ((fst . fst) x) else Nothing))
                prw);
      } in (p_fun, (w_fun, (w0, acset)));
  });

prec_weight_ac_repr_to_prec_weight ::
  forall a.
    (Ceq a, Ccompare a, Compare_order a, Eq a, Set_impl a,
      Showl a) => ([((a, Nat), (Nat, (Nat, Bool)))], Nat) ->
                    (Sum (String -> String) (),
                      ((a, Nat) -> (a, Nat) -> Bool,
                        ((a, Nat) -> Nat, (Nat, Set a))));
prec_weight_ac_repr_to_prec_weight prw_w0 =
  (case prec_weight_ac_repr_to_prec_weight_funs prw_w0 of {
    (p_fun, (w_fun, (_, acset))) ->
      (case prw_w0 of {
        (prw, w0) ->
          let {
            fs = map fst prw;
            cw_okay =
              catch_errora
                (forallM
                  (\ fn ->
                    check (if equal_nat (snd fn) zero_nat
                            then less_eq_nat w0 (w_fun fn) else True)
                      ((showsl_lit "weight of constant " . showsl (fst fn)) .
                        showsl_lit " must be at least w0"))
                  fs)
                (\ x -> Inl (snd x));
            adm = catch_errora
                    (forallM
                      (\ fn ->
                        check (if equal_nat (snd fn) one_nat
                                then (if equal_nat (w_fun fn) zero_nat
                                       then all (\ x -> p_fun fn x || x == fn)
      fs
                                       else True)
                                else True)
                          ((showsl_lit "unary symbol " . showsl (fst fn)) .
                            showsl_lit
                              " with weight 0 does not have maximal precedence"))
                      (map fst prw))
                    (\ x -> Inl (snd x));
            irr = catch_errora
                    (forallM
                      (\ fn ->
                        check (not (p_fun fn fn))
                          ((showsl_lit "function symbol " . showsl (fst fn)) .
                            showsl_lit " violates irreflexibity"))
                      fs)
                    (\ x -> Inl (snd x));
            ok = bindb (check (less_nat zero_nat w0)
                         (showsl_lit "w0 must be larger than 0"))
                   (\ _ -> bindb adm (\ _ -> bindb cw_okay (\ _ -> irr)));
          } in (ok, (p_fun, (w_fun, (w0, acset))));
      });
  });

showsl_funa :: forall a. (Showl a) => (a, Nat) -> String -> String;
showsl_funa (f, n) = (showsl f . showsl_lit "/") . showsl_nat n;

showsl_ackbo_repr ::
  forall a.
    (Showl a) => ([((a, Nat), (Nat, (Nat, Bool)))], Nat) -> String -> String;
showsl_ackbo_repr (prs, w0) =
  ((((((((((((showsl_lit
                "ACKBO with the following precedence and weight function:\n" .
               foldr (\ (fn, (pr, (_, _))) ->
                       (((showsl_lit "precedence(" . showsl_funa fn) .
                          showsl_lit ") = ") .
                         showsl_nat pr) .
                         showsl_literal "\n")
                 prs) .
              showsl_lit "precedence(_) = 0\n\n") .
             foldr (\ (fn, (_, (w, _))) ->
                     (((showsl_lit "weight(" . showsl_funa fn) .
                        showsl_lit ") = ") .
                       showsl_nat w) .
                       showsl_literal "\n")
               prs) .
            showsl_lit "weight(_) = ") .
           showsl_nat (suc w0)) .
          showsl_lit "\nw0 = ") .
         showsl_nat w0) .
        showsl_literal "\n") .
       showsl_literal "\n") .
      showsl_list_gen (\ (fn, _) -> showsl_funa fn) "no AC function symbols"
        "AC function symbols: " ", " ""
        (filter (\ (_, (_, (_, ac))) -> ac) prs)) .
     showsl_literal "\n") .
    showsl_list_gen (\ (fn, _) -> showsl_funa fn) "no non AC function symbols"
      "non AC function symbols: " ", " ""
      (filter (\ (_, (_, (_, a))) -> not a) prs)) .
    showsl_literal "\n";

size_multiset :: forall a. Multiset a -> Nat;
size_multiset (Bag ms) = foldd (\ _ -> plus_nat) zero_nat ms;

lex_ext ::
  forall a. (a -> a -> (Bool, Bool)) -> Nat -> [a] -> [a] -> (Bool, Bool);
lex_ext f n ss ts =
  let {
    lts = size_list ts;
  } in (if equal_nat (size_list ss) lts || less_eq_nat lts n
         then lex_ext_unbounded f ss ts else (False, False));

ass_list_to_single_list :: forall a. [(a, Nat)] -> [a];
ass_list_to_single_list [] = [];
ass_list_to_single_list ((x, n) : xs) =
  replicate n x ++ ass_list_to_single_list xs;

smulextp ::
  forall a. (a -> a -> (Bool, Bool)) -> Multiset a -> Multiset a -> Bool;
smulextp f (Bag xs) (Bag ys) =
  fst (mul_ext f (ass_list_to_single_list (impl_ofa xs))
        (ass_list_to_single_list (impl_ofa ys)));

mulextp ::
  forall a.
    (a -> a -> (Bool, Bool)) -> Multiset a -> Multiset a -> (Bool, Bool);
mulextp f (Bag xs) (Bag ys) =
  mul_ext f (ass_list_to_single_list (impl_ofa xs))
    (ass_list_to_single_list (impl_ofa ys));

weighta :: forall a b. ((a, Nat) -> Nat) -> Nat -> Term a b -> Nat;
weighta w w0 (Var x) = w0;
weighta w w0 (Fun f ts) =
  plus_nat (w (f, size_list ts)) (sum_list (map (weighta w w0) ts));

ackbo_impl ::
  forall a b.
    (Ceq a, Ccompare a, Eq a,
      Eq b) => ((a, Nat) -> Nat) ->
                 Nat ->
                   ((a, Nat) -> (a, Nat) -> Bool) ->
                     Set a -> Term a b -> Term a b -> Bool;
ackbo_impl w w0 pr_strict ac s t =
  (if subseteq_mset (vars_term_ms t) (vars_term_ms s) &&
        less_eq_nat (weighta w w0 t) (weighta w w0 s)
    then (if less_nat (weighta w w0 t) (weighta w w0 s) then True
           else (case s of {
                  Var _ -> False;
                  Fun f ss ->
                    (case t of {
                      Var _ -> True;
                      Fun g ts ->
                        (if pr_strict (f, size_list ss) (g, size_list ts)
                          then True
                          else (if (f, size_list ss) == (g, size_list ts)
                                 then (if not (member f ac) ||
    not (equal_nat (size_list ss) (nat_of_integer (2 :: Integer)))
then fst (lex_ext
           (\ x y ->
             (ackbo_impl w w0 pr_strict ac x y,
               equal_acterm (aocnf ac ac x) (aocnf ac ac y)))
           (size_list ss) ss ts)
else (case (actop f (Fun f ss), actop f (Fun g ts)) of {
       (sa, ta) ->
         (case mulextp
                 (\ tb u ->
                   (ackbo_impl w w0 pr_strict ac tb u,
                     equal_acterm (aocnf ac ac tb) (aocnf ac ac u)))
                 (filter_fun sa (\ x y -> not (pr_strict y x))
                   (f, nat_of_integer (2 :: Integer)))
                 (plus_multiset
                   (filter_fun ta (\ x y -> not (pr_strict y x))
                     (f, nat_of_integer (2 :: Integer)))
                   (minus_multiset (filter_mset is_Var ta)
                     (filter_mset is_Var sa)))
           of {
           (True, _) -> True;
           (False, ns) ->
             (if ns && less_nat (size_multiset ta) (size_multiset sa) then True
               else (if ns && equal_nat (size_multiset sa) (size_multiset ta)
                      then smulextp
                             (\ tb u ->
                               (ackbo_impl w w0 pr_strict ac tb u,
                                 equal_acterm (aocnf ac ac tb) (aocnf ac ac u)))
                             (filter_fun sa (\ x y -> pr_strict y x)
                               (f, nat_of_integer (2 :: Integer)))
                             (filter_fun ta (\ x y -> pr_strict y x)
                               (f, nat_of_integer (2 :: Integer)))
                      else False));
         });
     }))
                                 else False));
                    });
                }))
    else False);

ackbo_nstrict ::
  forall a b.
    (Ceq a, Ccompare a, Eq a, Showl a, Eq b,
      Showl b) => ((a, Nat) -> (a, Nat) -> Bool) ->
                    ((a, Nat) -> Nat) ->
                      Nat ->
                        Set a ->
                          (Term a b, Term a b) -> Sum (String -> String) ();
ackbo_nstrict pr w w0 acset =
  (\ (s, t) ->
    check (ackbo_impl w w0 pr acset s t ||
            equal_acterm (aocnf acset acset s) (aocnf acset acset t))
      ((((showsl_lit "could not orient " . showsl_terma s) .
          showsl_lit " >=ACKBO ") .
         showsl_terma t) .
        showsl_literal "\n"));

ackbo_strict ::
  forall a b.
    (Ceq a, Ccompare a, Eq a, Showl a, Eq b,
      Showl b) => ((a, Nat) -> (a, Nat) -> Bool) ->
                    ((a, Nat) -> Nat) ->
                      Nat ->
                        Set a ->
                          (Term a b, Term a b) -> Sum (String -> String) ();
ackbo_strict pr w w0 acset =
  (\ (s, t) ->
    check (ackbo_impl w w0 pr acset s t)
      ((((showsl_lit "could not orient " . showsl_terma s) .
          showsl_lit " >ACKBO ") .
         showsl_terma t) .
        showsl_literal "\n"));

create_ACKBO_rel_impl ::
  forall a b c.
    (Showl a, Ceq b, Ccompare b, Compare_order b, Eq b, Set_impl b, Showl b,
      Eq c,
      Showl c) => (([((a, Nat), (Nat, (Nat, Bool)))], Nat) ->
                    ([((b, Nat), (Nat, (Nat, Bool)))], Nat)) ->
                    ([((a, Nat), (Nat, (Nat, Bool)))], Nat) ->
                      Rel_impl_ext b c ();
create_ACKBO_rel_impl f_to_g pr =
  (case prec_weight_ac_repr_to_prec_weight (f_to_g pr) of {
    (ch, (p, (w, (w0, ac)))) ->
      let {
        ns = ackbo_nstrict p w w0 ac;
        s = ackbo_strict p w w0 ac;
      } in Rel_impl_ext ch (Inr ()) (showsl_ackbo_repr pr) s ns ns full_af
             full_af (Inr ()) (Inr ()) (Inr ()) (Inr ()) (Inr ()) (Inr ())
             full_af (\ _ -> Inr ()) (Just []) (Just []) no_complexity_check ();
  });

mat_max :: forall a. (Ord a) => Mat a -> Mat a -> Mat a;
mat_max a b =
  mat (dim_row a) (dim_col a) (\ ij -> max (index_mat a ij) (index_mat b ij));

mat_comp_all :: forall a. (a -> a -> Bool) -> Mat a -> Mat a -> Bool;
mat_comp_all r a b =
  let {
    d = minus_nat (dim_row a) one_nat;
  } in (if less_nat d (dim_row a)
         then all_interval
                (\ i ->
                  let {
                    da = minus_nat (dim_col a) one_nat;
                  } in (if less_nat da (dim_col a)
                         then all_interval
                                (\ j ->
                                  r (index_mat a (i, j)) (index_mat b (i, j)))
                                zero_nat da
                         else True))
                zero_nat d
         else True);

mat_both_ordered_semiring ::
  forall a b.
    (Ordered_semiring_1a a) => Nat ->
                                 (a -> a -> Bool) ->
                                   b -> Partial_object_ext (Mat a)
  (Monoid_ext (Mat a) (Ring_ext (Mat a) (Ordered_semiring_ext (Mat a) b)));
mat_both_ordered_semiring n gt b =
  ring_mat Type n (Ordered_semiring_ext mat_ge (mat_comp_all gt) mat_max b);

mat_default :: forall a. (Zero a) => a -> Nat -> Mat a;
mat_default d n = mat n n (\ (i, j) -> (if equal_nat i j then d else zerob));

mat_arc_complexity :: forall a. a -> Nat -> Sum (String -> String) ();
mat_arc_complexity m deg =
  Inl (showsl_lit "complexity for arctic matrices not supported");

mat_arc_posI :: forall a. (a -> Bool) -> Mat a -> Bool;
mat_arc_posI ap a = ap (index_mat a (zero_nat, zero_nat));

mat_arc_lpoly_order ::
  forall a.
    (Ordered_semiring_1a a) => Nat ->
                                 a -> (a -> Bool) ->
(a -> a -> Bool) ->
  Partial_object_ext (Mat a)
    (Monoid_ext (Mat a)
      (Ring_ext (Mat a)
        (Ordered_semiring_ext (Mat a) (Lpoly_order_semiring_ext (Mat a) ()))));
mat_arc_lpoly_order n def apos gtt =
  mat_both_ordered_semiring n gtt
    (Lpoly_order_semiring_ext False (mat_default def n) (mat_arc_posI apos)
      (\ _ -> False) (\ _ -> zero_nat) mat_arc_complexity
      (showsl_lit "arctic matrix interpretation") ());

check_arc_dimension ::
  forall a. (Zero a, Ord a) => a -> Sum (String -> String) ();
check_arc_dimension n =
  check (less zerob n) (showsl_lit "dimension must be at least 1");

class_complexity ::
  forall a. (Ordered_semiring_1a a) => a -> Nat -> Sum (String -> String) ();
class_complexity a deg =
  check (less_eq a onea) (showsl_literal "value is larger than 1");

class_lpoly_order ::
  forall a.
    (Ceq a, Ccompare a, Ordered_semiring_1a a,
      Set_impl a) => a -> (a -> Bool) ->
                            (a -> a -> Bool) ->
                              Partial_object_ext a
                                (Monoid_ext a
                                  (Ring_ext a
                                    (Ordered_semiring_ext a
                                      (Lpoly_order_semiring_ext a ()))));
class_lpoly_order def cmon gtt =
  class_ordered_semiring Type gtt
    (Lpoly_order_semiring_ext True def (\ _ -> True) cmon (\ _ -> zero_nat)
      class_complexity (showsl_literal "polynomial interpretation") ());

rpo_unbounded ::
  forall a b.
    (Eq b) => ((a, Nat) -> (a, Nat) -> (Bool, Bool), (a, Nat) -> Bool) ->
                ((a, Nat) -> Order_tag) -> Term a b -> Term a b -> (Bool, Bool);
rpo_unbounded pr c s t =
  fst (rpo_mem pr c
        (mapping_empty
          (of_phantom (mapping_impl_prod :: Phantom (Int, Int) Mapping_impla)))
        (index_term s, index_term t));

rpo_nstrict_unbounded ::
  forall a b.
    (Showl a, Eq b,
      Showl b) => ((a, Nat) -> (a, Nat) -> (Bool, Bool), (a, Nat) -> Bool) ->
                    ((a, Nat) -> Order_tag) ->
                      (Term a b, Term a b) -> Sum (String -> String) ();
rpo_nstrict_unbounded pr c =
  (\ (s, t) ->
    check (snd (rpo_unbounded pr c s t))
      ((((showsl_literal "could not orient " . showsl_terma s) .
          showsl_literal " >=RPO ") .
         showsl_terma t) .
        showsl_literal "\n"));

rpo_strict_unbounded ::
  forall a b.
    (Showl a, Eq b,
      Showl b) => ((a, Nat) -> (a, Nat) -> (Bool, Bool), (a, Nat) -> Bool) ->
                    ((a, Nat) -> Order_tag) ->
                      (Term a b, Term a b) -> Sum (String -> String) ();
rpo_strict_unbounded pr c =
  (\ (s, t) ->
    check (fst (rpo_unbounded pr c s t))
      ((((showsl_literal "could not orient " . showsl_terma s) .
          showsl_literal " >RPO ") .
         showsl_terma t) .
        showsl_literal "\n"));

showsl_rpo_repr ::
  forall a. (Showl a) => [((a, Nat), (Nat, Order_tag))] -> String -> String;
showsl_rpo_repr prs =
  (((showsl_literal "RPO with the following precedence\n" .
      foldr (\ (a, b) ->
              (case a of {
                (f, n) ->
                  (\ (pr, _) ->
                    (((((showsl_literal "precedence(" . showsl f) .
                         showsl_literal "[") .
                        showsl_nat n) .
                       showsl_literal "]) = ") .
                      showsl_nat pr) .
                      showsl_literal "\n");
              })
                b)
        prs) .
     showsl_literal "\nprecedence(_) = 0\nand the following status\n") .
    foldr (\ (a, b) ->
            (case a of {
              (f, n) ->
                (\ (_, s) ->
                  (((((showsl_literal "status(" . showsl f) .
                       showsl_literal "[") .
                      showsl_nat n) .
                     showsl_literal "]) = ") .
                    showsl_literal (case s of {
                                     Lex -> "lex";
                                     Mul -> "mul";
                                   })) .
                    showsl_literal "\n");
            })
              b)
      prs) .
    showsl_literal "\nstatus(_) = lex\n";

prl_nat :: forall a. ((a, Nat) -> Nat) -> (a, Nat) -> Bool;
prl_nat pr = (\ f -> equal_nat (pr f) zero_nat);

create_RPO_rel_impl ::
  forall a b c.
    (Showl a, Showl b, Eq c,
      Showl c) => ([((a, Nat), (Nat, Order_tag))] ->
                    ((b, Nat) -> Nat, (b, Nat) -> Order_tag)) ->
                    [((a, Nat), (Nat, Order_tag))] -> Rel_impl_ext b c ();
create_RPO_rel_impl prec_repr_to_pr pr =
  (case prec_repr_to_pr pr of {
    (p, tau) ->
      let {
        ns = rpo_nstrict_unbounded (prc_nat p, prl_nat p) tau;
      } in Rel_impl_ext (Inr ()) (Inr ()) (showsl_rpo_repr pr)
             (rpo_strict_unbounded (prc_nat p, prl_nat p) tau) ns ns full_af
             full_af (Inr ()) (Inr ()) (Inr ()) (Inr ()) (Inr ()) (Inr ())
             full_af (\ _ -> Inr ()) (Just []) (Just []) no_complexity_check ();
  });

check_dimensions ::
  Nat -> Nat -> Sum (String -> String) () -> Sum (String -> String) ();
check_dimensions n sd c =
  bindb c
    (\ _ ->
      check (less_eq_nat sd n && less_nat zero_nat sd)
        (showsl_literal
          "strict dimension must be at least 1 and less than total dimension"));

shows_kbo_repr ::
  forall a.
    (Showl a) => ([((a, Nat), (Nat, (Nat, Maybe [Nat])))], Nat) ->
                   String -> String;
shows_kbo_repr (prs, w0) =
  (((((((((showsl_literal
             "KBO with the following precedence and weight function\n" .
            foldr (\ (a, b) ->
                    (case a of {
                      (f, n) ->
                        (\ (pr, (_, _)) ->
                          (((((showsl_literal "precedence(" . showsl f) .
                               showsl_literal "[") .
                              showsl_nat n) .
                             showsl_literal "]) = ") .
                            showsl_nat pr) .
                            showsl_literal "\n");
                    })
                      b)
              prs) .
           showsl_literal "\nprecedence(_) = 0\nand the following weight\n") .
          foldr (\ (a, b) ->
                  (case a of {
                    (f, n) ->
                      (\ (_, (w, _)) ->
                        (((((showsl_literal "weight(" . showsl f) .
                             showsl_literal "[") .
                            showsl_nat n) .
                           showsl_literal "]) = ") .
                          showsl_nat w) .
                          showsl_literal "\n");
                  })
                    b)
            prs) .
         showsl_literal "\nweight(_) = ") .
        showsl_nat (suc w0)) .
       showsl_literal "\nw0 = ") .
      showsl_nat w0) .
     showsl_literal "\nand the following subterm coefficient functions\n") .
    foldr (\ (a, b) ->
            (case a of {
              (f, n) ->
                (\ (_, (_, scf)) ->
                  (((((showsl_literal "scf(" . showsl f) . showsl_literal "[") .
                      showsl_nat n) .
                     showsl_literal "]) = ") .
                    (if is_none scf then showsl_literal "all 1"
                      else showsl_list_nat (the scf))) .
                    showsl_literal "\n");
            })
              b)
      prs) .
    showsl_literal "\nscf(_) = all 1\n";

create_KBO_rel_impl ::
  forall a b c.
    (Showl a, Compare_order b, Eq b, Showl b, Eq c,
      Showl c) => (([((a, Nat), (Nat, (Nat, Maybe [Nat])))], Nat) ->
                    ([((b, Nat), (Nat, (Nat, Maybe [Nat])))], Nat)) ->
                    ([((a, Nat), (Nat, (Nat, Maybe [Nat])))], Nat) ->
                      Rel_impl_ext b c ();
create_KBO_rel_impl f_to_g pr =
  (case prec_weight_repr_to_prec_weight (f_to_g pr) of {
    (ch, (p, (w, (w0, (lcs, scf))))) ->
      let {
        ns = kbo_nstrict p w w0 (membera lcs) scf;
        s = kbo_strict p w w0 (membera lcs) scf;
      } in Rel_impl_ext ch (Inr ()) (shows_kbo_repr pr) s ns ns full_af full_af
             (Inr ()) (Inr ()) (Inr ()) (Inr ()) (Inr ()) (Inr ()) full_af
             (\ _ -> Inr ()) (Just []) (Just []) no_complexity_check ();
  });

pos_arctic :: Arctic -> Bool;
pos_arctic MinInfty = False;
pos_arctic (Num_arc n) = less_eq_int zero_int n;

delta_mono :: forall a. (Floor_ceiling a) => a -> Bool;
delta_mono x = less_eq onea x;

mat_ordered_semiring ::
  forall a b.
    (Ordered_semiring_1a a) => Nat ->
                                 Nat ->
                                   (a -> a -> Bool) ->
                                     b -> Partial_object_ext (Mat a)
    (Monoid_ext (Mat a) (Ring_ext (Mat a) (Ordered_semiring_ext (Mat a) b)));
mat_ordered_semiring n sd gt b =
  ring_mat Type n (Ordered_semiring_ext mat_ge (mat_gt gt sd) mat_max b);

nth_default :: forall a. a -> [a] -> Nat -> a;
nth_default dflt xs n = (if less_nat n (size_list xs) then nth xs n else dflt);

coeff :: forall a. (Zero a) => Poly a -> Nat -> a;
coeff p = nth_default zerob (coeffs p);

normalize_poly ::
  forall a.
    (Eq a, Idom_divide a, Semidom_divide_unit_factor a) => Poly a -> Poly a;
normalize_poly p =
  divide_poly p (pCons (unit_factor (coeff p (degreea p))) zero_polya);

primitive_part :: forall a. (Semiring_gcd a, Eq a) => Poly a -> Poly a;
primitive_part p = map_poly (\ x -> divide x (content p)) p;

pseudo_mod_main_list ::
  forall a. (Eq a, Comm_ring_1 a) => a -> [a] -> [a] -> Nat -> [a];
pseudo_mod_main_list lc r d n =
  (if equal_nat n zero_nat then r
    else let {
           rr = map (times lc) r;
           a = hda r;
           rrr = tla (if a == zerob then rr
                       else minus_poly_rev_list rr (map (times a) d));
         } in pseudo_mod_main_list lc rrr d (minus_nat n one_nat));

pseudo_mod_list :: forall a. (Eq a, Comm_ring_1 a) => [a] -> [a] -> [a];
pseudo_mod_list p q =
  (if null q then p
    else let {
           rq = reverse q;
           a = pseudo_mod_main_list (hda rq) (reverse p) rq
                 (minus_nat (plus_nat one_nat (size_list p)) (size_list q));
         } in reverse a);

pseudo_mod ::
  forall a.
    (Eq a, Comm_ring_1 a,
      Semiring_1_no_zero_divisors a) => Poly a -> Poly a -> Poly a;
pseudo_mod f g = poly_of_list (pseudo_mod_list (coeffs f) (coeffs g));

gcd_poly_code_aux ::
  forall a. (Factorial_ring_gcd a, Eq a) => Poly a -> Poly a -> Poly a;
gcd_poly_code_aux p q =
  (if (case coeffs q of {
        [] -> True;
        _ : _ -> False;
      })
    then normalize_poly p
    else gcd_poly_code_aux q (primitive_part (pseudo_mod p q)));

gcd_poly_code ::
  forall a. (Factorial_ring_gcd a, Eq a) => Poly a -> Poly a -> Poly a;
gcd_poly_code p q =
  (if (case coeffs p of {
        [] -> True;
        _ : _ -> False;
      })
    then normalize_poly q
    else (if (case coeffs q of {
               [] -> True;
               _ : _ -> False;
             })
           then normalize_poly p
           else let {
                  c1 = content p;
                  c2 = content q;
                  pa = map_poly (\ x -> divide x c1) p;
                  qa = map_poly (\ x -> divide x c2) q;
                } in smult (gcda c1 c2) (gcd_poly_code_aux pa qa)));

gcd_poly ::
  forall a.
    (Factorial_ring_gcd a, Semiring_gcd_mult_normalize a,
      Eq a) => Poly a -> Poly a -> Poly a;
gcd_poly p q = gcd_poly_code p q;

divmod_poly_one_main_list ::
  forall a. (Eq a, Comm_ring_1 a) => [a] -> [a] -> [a] -> Nat -> ([a], [a]);
divmod_poly_one_main_list q r d n =
  (if equal_nat n zero_nat then (q, r)
    else let {
           a = hda r;
           qqq = cCons a q;
           rr = tla (if a == zerob then r
                      else minus_poly_rev_list r (map (times a) d));
         } in divmod_poly_one_main_list qqq rr d (minus_nat n one_nat));

div_field_poly_impl :: forall a. (Field a, Eq a) => Poly a -> Poly a -> Poly a;
div_field_poly_impl f g =
  let {
    cg = coeffs g;
  } in (if null cg then zero_polya
         else let {
                cf = coeffs f;
                ilc = inverse (last cg);
                ch = map (times ilc) cg;
                q = fst (divmod_poly_one_main_list [] (reverse cf) (reverse ch)
                          (minus_nat (plus_nat one_nat (size_list cf))
                            (size_list cg)));
              } in poly_of_list (map (times ilc) q));

sturm_squarefree :: Poly Real -> [Poly Real];
sturm_squarefree p = sturm (div_field_poly_impl p (gcd_poly p (pderiv p)));

poly_inf :: forall a. (Real_normed_vector a) => Poly a -> a;
poly_inf p = sgn (coeff p (degreea p));

sign_changes_inf :: forall a. (Eq a, Real_normed_vector a) => [Poly a] -> Nat;
sign_changes_inf ps =
  minus_nat
    (size_list
      (remdups_adj (filter (\ x -> not (x == zerob)) (map poly_inf ps))))
    one_nat;

sign_changes :: [Poly Real] -> Real -> Nat;
sign_changes ps x =
  minus_nat
    (size_list
      (remdups_adj
        (filter (\ xa -> not (equal_real xa zero_real))
          (map (\ p -> sgn_real (polya p x)) ps))))
    one_nat;

count_roots_above :: Poly Real -> Real -> Nat;
count_roots_above p a =
  let {
    q = pderiv p;
  } in (if equal_poly p zero_polya then zero_nat
         else (if not (equal_real (polya p a) zero_real) ||
                    not (equal_real (polya q a) zero_real)
                then let {
                       ps = sturm p;
                     } in minus_nat (sign_changes ps a) (sign_changes_inf ps)
                else let {
                       ps = sturm_squarefree p;
                     } in minus_nat (sign_changes ps a) (sign_changes_inf ps)));

minus_mat :: forall a. (Minus a) => Mat a -> Mat a -> Mat a;
minus_mat a b =
  mat (dim_row b) (dim_col b)
    (\ ij -> minusa (index_mat a ij) (index_mat b ij));

pivot_positions_main_gen ::
  forall a. (Eq a) => a -> Mat a -> Nat -> Nat -> Nat -> Nat -> [(Nat, Nat)];
pivot_positions_main_gen zero a nr nc i j =
  (if less_nat i nr
    then (if less_nat j nc
           then (if index_mat a (i, j) == zero
                  then pivot_positions_main_gen zero a nr nc i (suc j)
                  else (i, j) :
                         pivot_positions_main_gen zero a nr nc (suc i) (suc j))
           else [])
    else []);

pivot_positions_gen :: forall a. (Eq a) => a -> Mat a -> [(Nat, Nat)];
pivot_positions_gen zer a =
  pivot_positions_main_gen zer a (dim_row a) (dim_col a) zero_nat zero_nat;

eliminate_entries_gen ::
  forall a.
    (a -> a -> a) ->
      (a -> a -> a) -> (Nat -> a) -> Mat a -> Nat -> Nat -> Mat a;
eliminate_entries_gen minus times v a i j =
  mat (dim_row a) (dim_col a)
    (\ (ia, ja) ->
      (if not (equal_nat ia i)
        then minus (index_mat a (ia, ja)) (times (v ia) (index_mat a (i, ja)))
        else index_mat a (ia, ja)));

gauss_jordan_main ::
  forall a. (Field a, Eq a) => Mat a -> Mat a -> Nat -> Nat -> (Mat a, Mat a);
gauss_jordan_main a b i j =
  let {
    nr = dim_row a;
    nc = dim_col a;
  } in (if less_nat i nr && less_nat j nc
         then let {
                aij = index_mat a (i, j);
              } in (if aij == zerob
                     then (case concatMap
                                  (\ ia ->
                                    (if not (index_mat a (ia, j) == zerob)
                                      then [ia] else []))
                                  (upt (suc i) nr)
                            of {
                            [] -> gauss_jordan_main a b i (suc j);
                            ia : _ ->
                              gauss_jordan_main (mat_swaprows i ia a)
                                (mat_swaprows i ia b) i j;
                          })
                     else (if aij == onea
                            then let {
                                   v = (\ ia -> index_mat a (ia, j));
                                 } in gauss_jordan_main
(eliminate_entries_gen minusa times v a i j)
(eliminate_entries_gen minusa times v b i j) (suc i) (suc j)
                            else let {
                                   iaij = inverse aij;
                                   aa = mat_multrow_gen times i iaij a;
                                   ba = mat_multrow_gen times i iaij b;
                                   v = (\ ia -> index_mat aa (ia, j));
                                 } in gauss_jordan_main
(eliminate_entries_gen minusa times v aa i j)
(eliminate_entries_gen minusa times v ba i j) (suc i) (suc j)))
         else (a, b));

gauss_jordan :: forall a. (Field a, Eq a) => Mat a -> Mat a -> (Mat a, Mat a);
gauss_jordan a b = gauss_jordan_main a b zero_nat zero_nat;

gauss_jordan_single :: forall a. (Field a, Eq a) => Mat a -> Mat a;
gauss_jordan_single a = fst (gauss_jordan a (zero_mat (dim_row a) zero_nat));

kernel_dim :: forall a. (Field a, Eq a) => Mat a -> Nat;
kernel_dim a =
  minus_nat (dim_col a)
    (size_list (pivot_positions_gen zerob (gauss_jordan_single a)));

check_matrix_complexity :: Mat Real -> Poly Real -> Nat -> Bool;
check_matrix_complexity a cp d =
  equal_nat (count_roots_above cp one_real) zero_nat &&
    (if equal_real (polya cp one_real) zero_real
      then let {
             ord = order one_real cp;
           } in (if less_nat (plus_nat d one_nat) ord
                  then equal_nat
                         (kernel_dim
                           (pow_mat (minus_mat a (one_mat (dim_row a)))
                             (plus_nat d one_nat)))
                         ord
                  else True)
      else True);

nonneg_mat ::
  forall a. (Ceq a, Ccompare a, Linordered_idom a, Set_impl a) => Mat a -> Bool;
nonneg_mat a = ball (elements_mat a) (less_eq zerob);

complexity_via_perron_frobenius :: Nat -> Poly Real -> Mat Real -> Bool;
complexity_via_perron_frobenius d cp a =
  nonneg_mat a && check_matrix_complexity a cp (minus_nat d one_nat);

count_ones_check :: [Real] -> Nat -> Bool;
count_ones_check diag d =
  all (\ a ->
        let {
          aa = abs_real a;
        } in less_eq_real aa one_real &&
               (if equal_real aa one_real
                 then less_eq_nat (size_list (filter (equal_real a) diag)) d
                 else True))
    diag;

upper_triangular :: forall a. (Zero a, Eq a) => Mat a -> Bool;
upper_triangular a =
  let {
    d = minus_nat (dim_row a) one_nat;
  } in (if less_nat d (dim_row a)
         then all_interval
                (\ i ->
                  let {
                    da = minus_nat i one_nat;
                  } in (if less_nat da i
                         then all_interval (\ j -> index_mat a (i, j) == zerob)
                                zero_nat da
                         else True))
                zero_nat d
         else True);

combined_growth_check_real_mat :: Nat -> Mat Real -> Sum (String -> String) ();
combined_growth_check_real_mat d a =
  catch_errora
    (if upper_triangular a && count_ones_check (diag_mat a) d then Inr ()
      else (if complexity_via_perron_frobenius d (char_poly a) a then Inr ()
             else Inl (if nonneg_mat a
                        then showsl_lit
                               "matrix does not have intended growth rate"
                        else showsl_lit
                               "only non-negative matrices supported")))
    (\ x ->
      Inl (((((showsl_lit "could not deduce that " . showsl_mat a) .
               showsl_literal " in O(n^") .
              showsl_nat (minus_nat d one_nat)) .
             showsl_lit ")\n") .
            x));

mat_estimate_complexity_jb ::
  forall a.
    (Large_real_ordered_semiring_1 a) => Nat ->
   Mat a -> Sum (String -> String) ();
mat_estimate_complexity_jb d a =
  let {
    b = map_mat real_of a;
  } in bindb (check (equal_nat (dim_row a) (dim_col a))
               (showsl_lit "expected square matrix but got \n" . showsl_mat b))
         (\ _ -> combined_growth_check_real_mat d b);

mat_complexity ::
  forall a.
    (Large_real_ordered_semiring_1 a) => Nat ->
   Mat a -> Nat -> Sum (String -> String) ();
mat_complexity n m d = mat_estimate_complexity_jb (suc d) m;

mat_mono :: forall a. (a -> Bool) -> Nat -> Mat a -> Bool;
mat_mono p sd a =
  let {
    d = minus_nat sd one_nat;
  } in (if less_nat d sd
         then all_interval
                (\ j ->
                  let {
                    da = minus_nat sd one_nat;
                  } in less_nat da sd &&
                         not (all_interval
                               (not . (\ i -> p (index_mat a (i, j)))) zero_nat
                               da))
                zero_nat d
         else True);

mat_lpoly_order ::
  forall a.
    (Large_real_ordered_semiring_1 a) => Nat ->
   Nat ->
     a -> (a -> Bool) ->
            (a -> a -> Bool) ->
              Partial_object_ext (Mat a)
                (Monoid_ext (Mat a)
                  (Ring_ext (Mat a)
                    (Ordered_semiring_ext (Mat a)
                      (Lpoly_order_semiring_ext (Mat a) ()))));
mat_lpoly_order n sd def cmon gtt =
  mat_ordered_semiring n sd gtt
    (Lpoly_order_semiring_ext True (mat_default def n) (\ _ -> True)
      (mat_mono cmon sd) (\ _ -> zero_nat) (mat_complexity n)
      (showsl_lit "matrix interpretation") ());

label_s_ns_impl ::
  forall a b.
    (Showl a,
      Showl b) => ((Term a b, Term a b) -> Sum (String -> String) ()) ->
                    ((Term a b, Term a b) -> Sum (String -> String) ()) ->
                      (Term a b, Nat) -> (Term a b, Nat) -> (Bool, Bool);
label_s_ns_impl cS cNS s t =
  (case s of {
    (sa, i) ->
      (case t of {
        (ta, j) ->
          (if isOK (cS (sa, ta)) then (True, True)
            else (if isOK (cNS (sa, ta)) then (less_nat j i, less_eq_nat j i)
                   else (False, False)));
      });
  });

nST_label_mul_impl ::
  forall a b.
    (Showl a,
      Showl b) => (((Term a b, Nat) -> (Term a b, Nat) -> (Bool, Bool)) ->
                    [(Term a b, Nat)] -> [(Term a b, Nat)] -> (Bool, Bool)) ->
                    ((a, Nat) -> [(Nat, Nat)]) ->
                      ((Term a b, Term a b) -> Sum (String -> String) ()) ->
                        ((Term a b, Term a b) -> Sum (String -> String) ()) ->
                          (Term a b, Term a b) -> Sum (String -> String) ();
nST_label_mul_impl list_ext af cS cNS st =
  (case st of {
    (Var _, _) ->
      Inl ((showsl_literal "roots of " . showsl_rule st) .
            showsl_literal " must be non-variable");
    (Fun _ _, Var _) ->
      Inl ((showsl_literal "roots of " . showsl_rule st) .
            showsl_literal " must be non-variable");
    (Fun f ss, Fun g ts) ->
      check (snd (list_ext (label_s_ns_impl cS cNS) (lterms af (Fun f ss))
                   (lterms af (Fun g ts))))
        ((((((showsl_literal "cannot orient pair " . showsl_rule st) .
              showsl_literal " weakly:\n") .
             showsl_list_prod (lterms af (Fun f ss))) .
            showsl_literal " >=mu ") .
           showsl_list_prod (lterms af (Fun g ts))) .
          showsl_literal " could not be ensured");
  });

s_label_mul_impl ::
  forall a b.
    (Showl a,
      Showl b) => (((Term a b, Nat) -> (Term a b, Nat) -> (Bool, Bool)) ->
                    [(Term a b, Nat)] -> [(Term a b, Nat)] -> (Bool, Bool)) ->
                    ((a, Nat) -> [(Nat, Nat)]) ->
                      ((Term a b, Term a b) -> Sum (String -> String) ()) ->
                        ((Term a b, Term a b) -> Sum (String -> String) ()) ->
                          (Term a b, Term a b) -> Sum (String -> String) ();
s_label_mul_impl list_ext af cS cNS st =
  (case st of {
    (Var _, _) ->
      Inl ((showsl_lit "roots of " . showsl_rule st) .
            showsl_lit " must be non-variable");
    (Fun _ _, Var _) ->
      Inl ((showsl_lit "roots of " . showsl_rule st) .
            showsl_lit " must be non-variable");
    (Fun f ss, Fun g ts) ->
      check (fst (list_ext (label_s_ns_impl cS cNS) (lterms af (Fun f ss))
                   (lterms af (Fun g ts))))
        ((((((showsl_lit "cannot orient pair " . showsl_rule st) .
              showsl_lit " strictly:\n") .
             showsl_list_prod (lterms af (Fun f ss))) .
            showsl_lit " >mu ") .
           showsl_list_prod (lterms af (Fun g ts))) .
          showsl_lit " could not be ensured");
  });

generate_scnp_rp ::
  forall a b.
    (Compare_order a, Showl a,
      Showl b) => (((Term a b, Nat) -> (Term a b, Nat) -> (Bool, Bool)) ->
                    [(Term a b, Nat)] -> [(Term a b, Nat)] -> (Bool, Bool)) ->
                    (String -> String) ->
                      [((a, Nat), [(Nat, Nat)])] ->
                        Rel_impl_ext a b () -> Rel_impl_ext a b ();
generate_scnp_rp list_ext list_ext_name afa rt =
  let {
    afaa = fun_of_map (ceta_map_of afa) [];
    pi = af rt;
    cS = s rt;
    cNS = ns rt;
  } in Rel_impl_ext (rel_impl_redpair rt)
         (Inl (showsl_lit
                "SCNP does not satisfy standard requirements such as S subset NS"))
         (scnp_desc afa list_ext_name . desca rt)
         (s_label_mul_impl list_ext afaa cS cNS) (ns rt)
         (nST_label_mul_impl list_ext afaa cS cNS) pi (scnp_af_to_af afaa pi)
         (Inr ()) (Inr ()) (ce_compat rt)
         (Inl (showsl_lit "SCNP cannot be used as co-rewrite pair")) (Inr ())
         (Inl (showsl_lit "SCNP does not ensure top-non-strict refl.")) empty_af
         (\ _ ->
           Inl (showsl_lit "SCNP does not support strictly monotone orders"))
         Nothing Nothing no_complexity_check ();

int_mono :: Int -> Bool;
int_mono x = less_eq_int one_int x;

faulty_rel_impl ::
  forall a b.
    Itself a ->
      Itself b ->
        (String -> String) -> (String -> String) -> Rel_impl_ext a b ();
faulty_rel_impl uu uv err desc =
  Rel_impl_ext (Inl err) (Inr ()) desc (\ _ -> Inr ()) (\ _ -> Inr ())
    (\ _ -> Inr ()) full_af full_af (Inr ()) (Inr ()) (Inr ()) (Inr ()) (Inr ())
    (Inr ()) empty_af (\ _ -> Inr ()) Nothing Nothing no_complexity_check ();

check_status_ws_info ::
  forall a.
    (Showl a) => Status a ->
                   ((Term a [Char], Term a [Char]) ->
                     Sum (String -> String) ()) ->
                     Maybe [(a, Nat)] -> Sum (String -> String) ();
check_status_ws_info sigma cns Nothing =
  Inl (showsl_lit "missing weak-subterm status of base reduction pair");
check_status_ws_info sigma cns (Just fs) =
  catch_errora
    (forallM
      (\ (f, n) ->
        catch_errora
          (forallM
            (\ i ->
              let {
                s = Fun f (map (\ ia ->
                                 Var ([char_0x78] ++
                                       shows_prec_nat zero_nat ia []))
                            (upt zero_nat n));
                t = Var ([char_0x78] ++ shows_prec_nat zero_nat i []);
              } in catch_errora (cns (s, t))
                     (\ _ ->
                       Inl (((((((((showsl_lit "argument #" .
                                     showsl_nat (suc i)) .
                                    showsl_lit " is in status of ") .
                                   showsl_funa (f, n)) .
                                  showsl_literal "\n") .
                                 showsl_lit "but ") .
                                showsl_terma s) .
                               showsl_lit " >= ") .
                              showsl_lit "x" . showsl_nat i) .
                             showsl_lit " is not satisfied")))
            (status sigma (f, n)))
          (\ x -> Inl (snd x)))
      fs)
    (\ x -> Inl (snd x));

showsl_wpo_params ::
  forall a.
    (Showl a) => [((a, Nat), (Nat, ([Nat], Order_tag)))] -> String -> String;
showsl_wpo_params params =
  showsl_lit "status and precedence:\n" .
    showsl_sep
      (\ (f, (p, (s, lm))) ->
        (((((((((((((showsl_lit "precedence(" . showsl_funa f) .
                     showsl_lit ") = ") .
                    showsl_nat p) .
                   showsl_literal "\n") .
                  showsl_lit "  status(") .
                 showsl_funa f) .
                showsl_lit ") = ") .
               showsl_list_nat s) .
              showsl_literal "\n") .
             showsl_lit "  arg-status(") .
            showsl_funa f) .
           showsl_lit ") = ") .
          showsl_literal (case lm of {
                           Lex -> "lex";
                           Mul -> "mul";
                         })) .
          showsl_literal "\n")
      (showsl_literal "\n") params;

cowpo_rel_impl ::
  forall a.
    (Compare_order a, Eq a,
      Showl a) => Rel_impl_ext a [Char] () ->
                    [((a, Nat), (Nat, ([Nat], Order_tag)))] ->
                      Rel_impl_ext a [Char] ();
cowpo_rel_impl rt params =
  let {
    stat = map (\ (f, ps) -> (f, fst (snd ps))) params;
    mparams = ceta_map_of params;
    pr = fun_of_map_funa mparams (\ _ -> zero_nat) fst;
    ot = (\ _ -> Lex);
    desc1 = showsl_lit "Co-WPO ";
    desc2 =
      ((showsl_lit "with " . showsl_wpo_params params) .
        showsl_lit "\nover the following relation:\n") .
        desca rt;
  } in (case status_of stat of {
         Nothing ->
           faulty_rel_impl Type Type
             (showsl_lit "problem with indices in status of co-WPO!")
             (desc1 . desc2);
         Just sigma ->
           let {
             large = (\ _ -> False);
             ssimple = False;
             sa = (\ sa t -> isOK (s rt (sa, t)));
             nsa = (\ sb t -> isOK (ns rt (sb, t)));
             wpo = wpo_ub (prc_nat pr) (\ _ -> False) ssimple large sa nsa sigma
                     ot;
             invS = nsa;
             invNS = sa;
             cowpo =
               wpo_ub
                 (\ f g ->
                   (not (snd (prc_nat pr g f)), not (fst (prc_nat pr g f))))
                 (\ _ -> False) ssimple large invNS invS sigma ot;
             wpo_s =
               (\ (sb, t) ->
                 check (fst (cowpo sb t))
                   (((showsl_terma sb . showsl_lit " >co-wpo ") .
                      showsl_terma t) .
                     showsl_lit " could not be ensured"));
             wpo_ns =
               (\ (sb, t) ->
                 check (snd (wpo sb t))
                   (((showsl_terma sb . showsl_lit " >=wpo ") .
                      showsl_terma t) .
                     showsl_lit " could not be ensured"));
           } in Rel_impl_ext
                  (bindb (valid rt)
                    (\ _ ->
                      bindb (standard rt)
                        (\ _ ->
                          bindb (catch_errora (subst_s rt)
                                  (\ x ->
                                    Inl (showsl_lit
   "Co-WPO requires stability of strict base relation\n" .
  x)))
                            (\ _ ->
                              check_status_ws_info sigma (ns rt)
                                (not_wst rt)))))
                  (Inl (showsl_lit
                         "Co-WPO does not support standard properties"))
                  (desc1 . desc2) wpo_s wpo_ns
                  (\ _ ->
                    Inl (showsl_lit "Co-WPO does not support nst-comparisons"))
                  full_af full_af
                  (Inl (showsl_lit "Co-WPO does not support SN")) (Inr ())
                  (Inl (showsl_lit "Co-WPO does not support Ce")) (Inr ())
                  (Inl (showsl_lit "Co-WPO does not support top-mono"))
                  (Inl (showsl_lit "Co-WPO does not support top-refl")) empty_af
                  (\ _ ->
                    Inl (showsl_lit
                          "Co-WPO does not support strong monotonicity"))
                  Nothing Nothing no_complexity_check ();
       });

showsl_gwpo_params ::
  forall a. (Showl a) => ([((a, Nat), Nat)], a -> a) -> String -> String;
showsl_gwpo_params params =
  showsl_lit "precedence:\n" .
    showsl_sep
      (\ (f, p) ->
        (((showsl_lit "precedence(" . showsl_funa f) . showsl_lit ") = ") .
          showsl_nat p) .
          showsl_literal "\n")
      (showsl_literal "\n") (fst params);

gwpo_rel_impl ::
  forall a.
    (Compare_order a, Eq a,
      Showl a) => Rel_impl_ext a [Char] () ->
                    ([((a, Nat), Nat)], a -> a) -> Rel_impl_ext a [Char] ();
gwpo_rel_impl rt params =
  (case params of {
    (pr_list, shp) ->
      let {
        sa = (\ l r -> isOK (s rt (l, r)));
        nsa = (\ l r -> isOK (ns rt (l, r)));
      } in Rel_impl_ext (rel_impl_redpair rt)
             (Inl (showsl_lit "standard is not supported by GWPO"))
             (((showsl_lit "quasi-reduction triple for GWPO with " .
                 showsl_gwpo_params params) .
                showsl_lit "\nover the following reduction pair:\n") .
               desca rt)
             (\ (l, r) ->
               check (gwpo_s sa nsa (prc pr_list) shp l r)
                 (showsl_lit "cannot strictly orient " . showsl_prod (l, r)))
             (\ (l, r) ->
               check (nsa l r)
                 (showsl_lit "cannot weakly orient (nst)" . showsl_prod (l, r)))
             (\ (l, r) ->
               check (gwpo_ns sa nsa (prc pr_list) shp l r)
                 (showsl_lit "cannot weakly orient (ns)" . showsl_prod (l, r)))
             full_af full_af (Inr ()) (Inr ())
             (Inl (showsl_lit "ce is not supported by GWPO"))
             (Inl (showsl_lit "co rewrite is not supported by GWPO")) (Inr ())
             (Inr ()) empty_af
             (\ _ -> Inl (showsl_lit "mono is not supported by GWPO")) Nothing
             Nothing no_complexity_check ();
  });

rel_impl_quasi_reduction_triple ::
  forall a b. Rel_impl_ext a b () -> Sum (String -> String) ();
rel_impl_quasi_reduction_triple ri =
  catch_errora
    (bindb (valid ri)
      (\ _ ->
        bindb (catch_errora (subst_s ri)
                (\ x ->
                  Inl (x . showsl_lit
                             "\nproblem in ensuring stability of strict relation")))
          (\ _ ->
            bindb (catch_errora (sn ri)
                    (\ x ->
                      Inl (x . showsl_lit
                                 "\nproblem in ensuring strong normalization of strict relation")))
              (\ _ ->
                bindb (catch_errora (top_mono ri)
                        (\ x ->
                          Inl (x . showsl_lit
                                     "\nproblem in ensuring top-monotonicity of non-strict relations")))
                  (\ _ ->
                    catch_errora (top_refl ri)
                      (\ x ->
                        Inl (x . showsl_lit
                                   "\nproblem in ensuring top-reflexivity")))))))
    (\ x ->
      Inl (showsl_lit "problem with being a quasi-reduction triple\n" . x));

mspo_rel_impl ::
  forall a.
    (Compare_order a, Eq a,
      Showl a) => Rel_impl_ext a [Char] () -> Rel_impl_ext a [Char] ();
mspo_rel_impl rt =
  let {
    sa = (\ l r -> isOK (s rt (l, r)));
    nsa = (\ l r -> isOK (nst rt (l, r)));
    h = (\ l r -> isOK (ns rt (l, r)));
    mspo_s =
      (\ lr ->
        check (mspo_ub sa nsa h (fst lr) (snd lr))
          (showsl_lit "cannot strictly orient " . showsl_prod lr));
    mspo_ns =
      (\ (l, r) ->
        check (equal_term l r || mspo_ub sa nsa h l r)
          (showsl_lit "cannot weakly orient " . showsl_prod (l, r)));
  } in Rel_impl_ext (rel_impl_quasi_reduction_triple rt) (Inr ())
         (showsl_lit "MSPO over the following quasi-reduction triple:\n" .
           desca rt)
         mspo_s mspo_ns mspo_ns full_af full_af (Inr ()) (Inr ())
         (Inl (showsl_lit "ce is not supported by MSPO"))
         (Inl (showsl_lit "co rewrite is not supported by MSPO"))
         (Inl (showsl_lit "top-mono is not supported by MSPO"))
         (Inl (showsl_lit "top-refl is not supported by MSPO")) empty_af
         (\ _ -> Inr ()) Nothing Nothing no_complexity_check ();

not_sst :: forall a b c. Rel_impl_ext a b c -> Maybe [(a, Nat)];
not_sst
  (Rel_impl_ext valid standard desc s ns nst af top_af sn subst_s ce_compat
    co_rewr top_mono top_refl mono_af mono not_wst not_sst cpx more)
  = not_sst;

is_None :: forall a. Maybe a -> Bool;
is_None a = (case a of {
              Nothing -> True;
              Just _ -> False;
            });

wpo_rel_impl ::
  forall a.
    (Compare_order a, Eq a,
      Showl a) => Rel_impl_ext a [Char] () ->
                    [((a, Nat), (Nat, ([Nat], Order_tag)))] ->
                      Rel_impl_ext a [Char] ();
wpo_rel_impl rt params =
  let {
    stat = map (\ (f, ps) -> (f, fst (snd ps))) params;
    mparams = ceta_map_of params;
    pr = fun_of_map_funa mparams (\ _ -> zero_nat) fst;
    ot = fun_of_map_funa mparams (\ _ -> Lex) (snd . snd);
    desc1 = showsl_lit "WPO ";
    desc2 =
      ((showsl_lit "with " . showsl_wpo_params params) .
        showsl_lit "\nover the following reduction pair:\n") .
        desca rt;
  } in (case status_of stat of {
         Nothing ->
           faulty_rel_impl Type Type
             (showsl_lit "problem with indices in status of WPO!")
             (desc1 . desc2);
         Just sigma ->
           let {
             large_opt = large_of pr sigma (map fst params);
             ssimple =
               not (is_None large_opt) &&
                 isOK (check_status_ws_info sigma (s rt) (not_sst rt));
             large =
               (if ssimple then (\ f -> equal_nat (pr f) (the large_opt))
                 else (\ _ -> False));
             sa = (\ sa t -> isOK (s rt (sa, t)));
             nsa = (\ sb t -> isOK (ns rt (sb, t)));
             wpo = wpo_ub (prc_nat pr) (prl_nat pr) ssimple large sa nsa sigma
                     ot;
             wpo_s =
               (\ (sb, t) ->
                 check (fst (wpo sb t))
                   (((showsl_terma sb . showsl_lit " >wpo ") . showsl_terma t) .
                     showsl_lit " could not be ensured"));
             wpo_ns =
               (\ (sb, t) ->
                 check (snd (wpo sb t))
                   (((showsl_terma sb . showsl_lit " >=wpo ") .
                      showsl_terma t) .
                     showsl_lit " could not be ensured"));
           } in Rel_impl_ext
                  (bindb (valid rt)
                    (\ _ ->
                      bindb (standard rt)
                        (\ _ ->
                          bindb (catch_errora (subst_s rt)
                                  (\ x ->
                                    Inl (showsl_lit
   "WPO requires stability of strict base relation\n" .
  x)))
                            (\ _ ->
                              check_status_ws_info sigma (ns rt)
                                (not_wst rt)))))
                  (Inr ())
                  (if ssimple
                    then (desc1 . showsl_lit "(strictly simple) ") . desc2
                    else desc1 . desc2)
                  wpo_s wpo_ns wpo_ns (af_wpo (af rt) sigma)
                  (af_wpo (af rt) sigma) (sn rt) (Inr ()) (Inr ()) (Inr ())
                  (Inr ()) (Inr ()) empty_af
                  (\ _ ->
                    catch_errora
                      (forallM
                        (\ (a, b) ->
                          (case a of {
                            (f, n) ->
                              (\ idx ->
                                check (set_eq (set idx) (set (upt zero_nat n)))
                                  (((showsl_lit
                                       "for monotonicity, status must be complete, but status of " .
                                      showsl_funa (f, n)) .
                                     showsl_lit " is ") .
                                    showsl_lista (map suc idx)));
                          })
                            b)
                        stat)
                      (\ x -> Inl (snd x)))
                  (Just (map fst stat)) (Just (map fst stat))
                  no_complexity_check ();
       });

get_rel_impl ::
  forall a.
    (Ceq a, Ccompare a, Compare_order a, Eq a, Set_impl a,
      Showl a) => Redtriple_impl a -> Rel_impl_ext a [Char] ();
get_rel_impl (Int_carrier i) =
  create_poly_rel_impl
    (class_lpoly_order one_int int_mono (\ x y -> less_int y x)) (Inr ()) i;
get_rel_impl (Neg_Integer_Poly i) =
  create_negpoly_rel_impl (bindb (check_poly_inter_list_neg i) (\ _ -> Inr ()))
    zero_int (\ x y -> less_int y x) True i;
get_rel_impl (Int_nl_carrier i) =
  create_nlpoly_rel_impl (Inr ()) one_int (\ x y -> less_int y x) True True i;
get_rel_impl (Rat_carrier i) =
  create_poly_rel_impl
    (class_lpoly_order one_rat delta_mono (\ x y -> less_rat y x))
    (check_def_pos one_rat) i;
get_rel_impl (Rat_nl_carrier d i) =
  create_nlpoly_rel_impl (check_def_pos d) d (delta_gt d)
    (less_eq_rat one_rat d) False i;
get_rel_impl (Real_carrier i) =
  create_poly_rel_impl
    (class_lpoly_order one_real delta_mono (\ x y -> less_real y x))
    (check_def_pos one_real) i;
get_rel_impl (Real_nl_carrier d i) =
  create_nlpoly_rel_impl (check_def_pos d) d (delta_gt d)
    (less_eq_real one_real d) False i;
get_rel_impl (Arctic_carrier i) =
  create_poly_rel_impl
    (class_arc_lpoly_order one_arctic pos_arctic (\ x y -> less_arctic y x))
    (Inr ()) i;
get_rel_impl (Arctic_rat_carrier i) =
  create_poly_rel_impl
    (class_arc_lpoly_order one_arctic_delta pos_arctic_delta
      weak_gt_arctic_delta)
    (Inr ()) i;
get_rel_impl (Int_mat_carrier n sd i) =
  create_poly_rel_impl
    (mat_lpoly_order n sd one_int int_mono (\ x y -> less_int y x))
    (check_dimensions n sd (Inr ())) i;
get_rel_impl (Rat_mat_carrier n sd i) =
  create_poly_rel_impl
    (mat_lpoly_order n sd one_rat delta_mono (\ x y -> less_rat y x))
    (check_dimensions n sd (check_def_pos one_rat)) i;
get_rel_impl (Real_mat_carrier n sd i) =
  create_poly_rel_impl
    (mat_lpoly_order n sd one_real delta_mono (\ x y -> less_real y x))
    (check_dimensions n sd (check_def_pos one_real)) i;
get_rel_impl (Arctic_mat_carrier n i) =
  create_poly_rel_impl
    (mat_arc_lpoly_order n one_arctic pos_arctic (\ x y -> less_arctic y x))
    (check_arc_dimension n) i;
get_rel_impl (Core_matrix mI) = create_core_matrix_int mI;
get_rel_impl (Core_matrix_delta d mI) = create_core_matrix_fract d mI;
get_rel_impl (Arctic_rat_mat_carrier n i) =
  create_poly_rel_impl
    (mat_arc_lpoly_order n one_arctic_delta pos_arctic_delta
      weak_gt_arctic_delta)
    (check_arc_dimension n) i;
get_rel_impl (Max_poly alist) =
  max_poly_rel_impl (Max_Poly_Impl BB_Solver alist);
get_rel_impl (Max_monus alist) =
  max_monus_rel_impl (Max_Monus_Impl BB_Solver alist);
get_rel_impl (RPO prec_tau pi) =
  filtered_rel_impl pi
    (create_RPO_rel_impl (\ pr -> (prec_repr_to_pr pr, prec_repr_to_status pr))
      prec_tau);
get_rel_impl (KBO precw pi) =
  filtered_rel_impl pi
    (create_KBO_rel_impl
      (filter_prec_weight_repr
        (fun_of_map_fun (ceta_map_of pi) (\ fn -> default_af_entry (snd fn))))
      precw);
get_rel_impl (ACKBO precw pi) =
  filtered_rel_impl pi
    (create_ACKBO_rel_impl
      (filter_prec_weight_ac_repr
        (fun_of_map_fun (ceta_map_of pi) (\ fn -> default_af_entry (snd fn))))
      precw);
get_rel_impl (WPO params rp) = wpo_rel_impl (get_rel_impl rp) params;
get_rel_impl (GWPO params rp) = gwpo_rel_impl (get_rel_impl rp) params;
get_rel_impl (MSPO rp) = mspo_rel_impl (get_rel_impl rp);
get_rel_impl (COWPO params rp) = cowpo_rel_impl (get_rel_impl rp) params;
get_rel_impl (Filtered_Redtriple alist rp) =
  filtered_rel_impl_af alist (get_rel_impl rp);
get_rel_impl (SCNP typea af rp) =
  generate_scnp_rp (list_ext (scnp_arity af) typea)
    (showsl_lit (list_ext_name typea)) af (get_rel_impl rp);

cp_right :: forall a b. Crit_pair_info a b -> Term a b;
cp_right (Crit_Pair_Info x1 x2 x3 x4 x5 x6) = x3;

cp_left :: forall a b. Crit_pair_info a b -> Term a b;
cp_left (Crit_Pair_Info x1 x2 x3 x4 x5 x6) = x1;

cp_join :: forall a b. Crit_pair_info a b -> [Term a b];
cp_join (Crit_Pair_Info x1 x2 x3 x4 x5 x6) = x4;

is_par_rstep ::
  forall a b.
    (Compare a, Eq a, Ccompare b, Compare b, Eq b,
      Mapping_impl b) => [(Term a b, Term a b)] -> Term a b -> Term a b -> Bool;
is_par_rstep r (Fun f ss) (Fun g ts) =
  equal_term (Fun f ss) (Fun g ts) ||
    (is_root_step (set r) (Fun f ss) (Fun g ts) ||
      f == g &&
        equal_nat (size_list ss) (size_list ts) &&
          list_all2 (is_par_rstep r) ss ts);
is_par_rstep r (Var v) t =
  equal_term (Var v) t || is_root_step (set r) (Var v) t;
is_par_rstep r s (Var v) =
  equal_term s (Var v) || is_root_step (set r) s (Var v);

finalize_steps ::
  forall a. (Eq a, Showl a) => a -> [a] -> a -> Sum (String -> String) ();
finalize_steps x xs y =
  check (x == y)
    (let {
       z = (case xs of {
             [] -> y;
             z : _ -> z;
           });
     } in (((showsl_lit "got stuck at step from " . showsl x) .
             showsl_lit " to ") .
            showsl z) .
            showsl_literal "\n");

check_steps ::
  forall a b.
    (Eq a,
      Eq b) => (Term a b -> Term a b -> Bool) ->
                 Term a b -> [Term a b] -> Term a b -> (Term a b, [Term a b]);
check_steps f s [] u = (if f s u then (u, []) else (s, []));
check_steps f s (t : ts) u =
  (if equal_term s t || f s t then check_steps f t ts u else (s, t : ts));

check_join_sequence ::
  forall a b.
    (Compare a, Eq a, Showl a, Ccompare b, Compare b, Eq b, Mapping_impl b,
      Showl b) => [(Term a b, Term a b)] ->
                    [(Term a b, Term a b)] ->
                      Term a b ->
                        Term a b -> [Term a b] -> Sum (String -> String) ();
check_join_sequence r sa s t terms =
  (case check_steps (is_par_rstep r) s terms t of {
    (x, xs) ->
      (case check_steps (\ sb ta -> is_par_rstep sa ta sb) x xs t of {
        (y, ys) ->
          catch_errora (finalize_steps y ys t)
            (\ xa ->
              Inl (((((showsl_lit "could not ensure " . showsl_terma s) .
                       showsl_lit " ->* . *<- ") .
                      showsl_terma t) .
                     showsl_literal "\n") .
                    xa));
      });
  });

reachable_terms ::
  forall a b.
    (Eq a, Ccompare b, Eq b,
      Mapping_impl b) => [(Term a b, Term a b)] ->
                           Term a b -> Nat -> [Term a b];
reachable_terms r s n =
  (if equal_nat n zero_nat then [s]
    else let {
           ts = reachable_terms r s (minus_nat n one_nat);
         } in remdups (ts ++ concatMap (rewrite r) ts));

is_rsteps_join ::
  forall a b.
    (Eq a, Ccompare b, Eq b,
      Mapping_impl b) => [(Term a b, Term a b)] ->
                           [(Term a b, Term a b)] ->
                             Nat -> Term a b -> Term a b -> Bool;
is_rsteps_join r sa n s t = let {
                              ss = reachable_terms sa t n;
                            } in any (membera ss) (reachable_terms r s n);

is_rsteps_join_one ::
  forall a b.
    (Compare a, Eq a, Showl a, Ccompare b, Compare b, Eq b, Mapping_impl b,
      Showl b) => [(Term a b, Term a b)] ->
                    Cp_join_hints a b ->
                      Sum (String -> String)
                        ((Term a b, Term a b) -> Sum (String -> String) ());
is_rsteps_join_one r (CP_Auto n) =
  Inr (\ (s, t) ->
        check (is_rsteps_join r r n s t)
          (((((showsl_nat n .
                showsl_lit " steps do not suffice to show joinability of ") .
               showsl_terma s) .
              showsl_lit " and ") .
             showsl_terma t) .
            showsl_literal "\n"));
is_rsteps_join_one r (CP_Sequences cp_infos) =
  bindb (catch_errora
          (catch_errora
            (forallM
              (\ cp ->
                check_join_sequence r r (cp_left cp) (cp_right cp) (cp_join cp))
              cp_infos)
            (\ x -> Inl (snd x)))
          (\ x ->
            Inl ((x . showsl_lit "\nunderlying TRS:\n") . showsl_rules r)))
    (\ _ ->
      Inr (\ (s, t) ->
            check (equal_term s t ||
                    any (\ cp ->
                          instance_rule (s, t) (cp_left cp, cp_right cp) ||
                            instance_rule (s, t) (cp_right cp, cp_left cp))
                      cp_infos)
              ((((showsl_literal " could not find joining sequence for " .
                   showsl_terma s) .
                  showsl_lit " and ") .
                 showsl_terma t) .
                showsl_literal "\n")));

check_critical_pairs_cp_info ::
  forall a b.
    (Compare a, Eq a, Showl a, Ccompare b, Compare b, Eq b, Mapping_impl b,
      Showl b) => [(Term a b, Term a b)] ->
                    [(Bool, (Term a b, Term a b))] ->
                      Cp_join_hints a b -> Sum (String -> String) ();
check_critical_pairs_cp_info r cp hints =
  bindb (is_rsteps_join_one r hints)
    (\ checker ->
      catch_errora (forallM (\ (_, a) -> checker a) cp) (\ x -> Inl (snd x)));

first_rewrite ::
  forall a b.
    (Eq a, Ccompare b, Eq b,
      Mapping_impl b) => [(Term a b, Term a b)] -> Term a b -> Maybe (Term a b);
first_rewrite r s = (case rewrite r s of {
                      [] -> Nothing;
                      t : _ -> Just t;
                    });

compute_rstep_NF ::
  forall a b.
    (Eq a, Ccompare b, Eq b,
      Mapping_impl b) => [(Term a b, Term a b)] -> Term a b -> Maybe (Term a b);
compute_rstep_NF r s = compute_NF (first_rewrite r) s;

check_join_NF ::
  forall a b.
    (Eq a, Showl a, Ccompare b, Eq b, Mapping_impl b,
      Showl b) => [(Term a b, Term a b)] ->
                    Term a b -> Term a b -> Sum (String -> String) ();
check_join_NF r s t =
  (case (compute_rstep_NF r s, compute_rstep_NF r t) of {
    (Nothing, _) ->
      Inl (showsl_literal "strange error in normal form computation");
    (Just _, Nothing) ->
      Inl (showsl_literal "strange error in normal form computation");
    (Just sa, Just ta) ->
      check (equal_term sa ta)
        (((((((showsl_literal "the normal form " . showsl_terma sa) .
               showsl_literal " of ") .
              showsl_terma s) .
             showsl_literal " differs from\nthe normal form ") .
            showsl_terma ta) .
           showsl_literal " of ") .
          showsl_terma t);
  });

check_critical_pairs_NF ::
  forall a b.
    (Eq a, Showl a, Ccompare b, Eq b, Mapping_impl b,
      Showl b) => [(Term a b, Term a b)] ->
                    [(Bool, (Term a b, Term a b))] -> Sum (String -> String) ();
check_critical_pairs_NF r cp =
  catch_errora
    (forallM
      (\ (_, (s, t)) ->
        (if equal_term s t then Inr ()
          else catch_errora (check_join_NF r s t)
                 (\ x ->
                   Inl (((showsl_lit "problem when joining critical pair " .
                           showsl_crit_pair (s, t)) .
                          showsl_literal "\n") .
                         x))))
      cp)
    (\ x -> Inl (snd x));

check_critical_pairs ::
  forall a b.
    (Compare a, Eq a, Showl a, Ccompare b, Compare b, Eq b, Mapping_impl b,
      Showl b) => [(Term a b, Term a b)] ->
                    [(Bool, (Term a b, Term a b))] ->
                      Join_info a b -> Sum (String -> String) ();
check_critical_pairs r cp join_info =
  (case join_info of {
    Guided_BFS a -> check_critical_pairs_cp_info r cp a;
    Join_NF -> check_critical_pairs_NF r cp;
  });

switch_innermost_proc ::
  forall a b c.
    (Ccompare a, Compare a, Infinite a, Eq a, Mapping_impl a, Showl a,
      Compare c, Eq c,
      Showl c) => Renaming2 a ->
                    Dpp_ops_ext b c a () ->
                      Join_info c a -> b -> Sum (String -> String) b;
switch_innermost_proc ren i joins_i dpp =
  let {
    r = rwd i dpp;
    p = pb i dpp;
    pw = pwb i dpp;
    nfs = nfsc i dpp;
  } in (case bindb (catch_errora
                     (forallM
                       (\ (l, _) ->
                         check (not (is_Var l))
                           (showsl_lit "left variables in R forbidden"))
                       (if nfs then r else []))
                     (\ x -> Inl (snd x)))
               (\ _ ->
                 bindb (check (minimal i dpp)
                         (showsl_lit "minimality required"))
                   (\ _ ->
                     bindb (check (null (qc i dpp))
                             (showsl_lit "non-empty Q not yet supported"))
                       (\ _ ->
                         bindb (check (null (rd i dpp))
                                 (showsl_lit "strict rules not allowed"))
                           (\ _ ->
                             bindb (check
                                     (null (critical_pairs_impl ren (p ++ pw)
     r))
                                     (showsl_lit
                                       "overlaps between P and R not allowed"))
                               (\ _ ->
                                 check_critical_pairs r
                                   (critical_pairs_impl ren r r) joins_i)))))
         of {
         Inl a -> Inl a;
         Inr _ -> Inr (mkd i nfs True p pw (map fst r) [] r);
       });

rel_impl_mono_redpair ::
  forall a b.
    Rel_impl_ext a b () ->
      [(Term a b, Term a b)] ->
        [(Term a b, Term a b)] -> Sum (String -> String) ();
rel_impl_mono_redpair ri s ns =
  catch_errora
    (bindb (valid ri)
      (\ _ ->
        bindb (standard ri)
          (\ _ ->
            bindb (catch_errora (sn ri)
                    (\ x ->
                      Inl (x . showsl_lit
                                 "\nproblem in ensuring strong normalization of relation")))
              (\ _ ->
                bindb (catch_errora (subst_s ri)
                        (\ x ->
                          Inl (x . showsl_lit
                                     "\nproblem in ensuring stability of strict relation")))
                  (\ _ ->
                    catch_errora (mono ri (funas_trs_list (s ++ ns)))
                      (\ x ->
                        Inl (x . showsl_lit
                                   "\nproblem in ensuring monotonicity of strict relation")))))))
    (\ x ->
      Inl (showsl_lit "problem with being a monotone reduction pair\n" . x));

mono_redpair_proc ::
  forall a b c.
    (Showl b,
      Showl c) => Dpp_ops_ext a b c () ->
                    Rel_impl_ext b c () ->
                      [(Term b c, Term b c)] ->
                        [(Term b c, Term b c)] -> a -> Sum (String -> String) a;
mono_redpair_proc i rp premove rremove dpp =
  (case catch_errora
          (case split_pairsa i dpp premove of {
            (ps, pns) ->
              (case split_rulesc i dpp rremove of {
                (rs, rns) ->
                  bindb (rel_impl_mono_redpair rp (ps ++ rs) (pns ++ rns))
                    (\ _ ->
                      bindb (catch_errora (rel_impl_ns rp rns)
                              (\ x ->
                                Inl (showsl_lit "problem when orienting TRS\n" .
                                      x)))
                        (\ _ ->
                          bindb (catch_errora (rel_impl_s rp rs)
                                  (\ x ->
                                    Inl (showsl_lit
   "problem when orienting TRS\n" .
  x)))
                            (\ _ ->
                              bindb (catch_errora (rel_impl_ns rp pns)
                                      (\ x ->
Inl (showsl_lit "problem when orienting DPs\n" . x)))
                                (\ _ ->
                                  catch_errora (rel_impl_s rp ps)
                                    (\ x ->
                                      Inl
(showsl_lit "problem when orienting DPs\n" . x))))));
              });
          })
          (\ x ->
            Inl (((showsl_lit
                     "could not apply the reduction pair processor with the following\n" .
                    desca rp) .
                   showsl_literal "\n") .
                  x))
    of {
    Inl a -> Inl a;
    Inr _ ->
      Inr (delete_R_Rwc i (delete_P_Pwa i dpp premove premove) rremove rremove);
  });

quasi_splitter ::
  forall a b c.
    (Compare a, Eq a, Compare c,
      Eq c) => (a -> (a, b)) ->
                 [(Term a c, Term a c)] ->
                   Set (Term a c, Term a c) ->
                     ([(Term a c, Term a c)],
                       ([(Term a c, Term a c)], [(Term a c, Term a c)]));
quasi_splitter ld lAll uRw =
  let {
    unlab = (\ lf -> fst (ld lf));
    la = map (\ r -> (r, map_funs_rule unlab r)) lAll;
  } in (case partition
               (\ (r, ur) ->
                 equal_term (fst ur) (snd ur) &&
                   not (equal_term (fst r) (snd r)))
               la
         of {
         (d, nD) -> (case partition (\ (_, ur) -> member ur uRw) nD of {
                      (rw, r) -> (map fst r, (map fst rw, map fst d));
                    });
       });

model_splitter ::
  forall a b c.
    (Compare a, Eq a, Compare c,
      Eq c) => (a -> (a, b)) ->
                 [(Term a c, Term a c)] ->
                   Set (Term a c, Term a c) ->
                     ([(Term a c, Term a c)],
                       ([(Term a c, Term a c)], [(Term a c, Term a c)]));
model_splitter ld lAll uRw =
  let {
    unlab = (\ lf -> fst (ld lf));
    la = map (\ r -> (r, map_funs_rule unlab r)) lAll;
  } in (case partition (\ (_, ur) -> member ur uRw) la of {
         (rw, r) -> (map fst r, (map fst rw, []));
       });

check_sl_Q ::
  forall a b c.
    (Eq a, Showl a, Ccompare c, Eq c, Mapping_impl c,
      Showl c) => (a -> (a, b)) ->
                    [Term a c] -> [Term a c] -> Sum (String -> String) ();
check_sl_Q ld lQ q =
  let {
    u = (\ l -> fst (ld l));
  } in catch_errora
         (forallM
           (\ lq ->
             check (let {
                      mlq = map_term u (\ x -> x) lq;
                    } in any (\ qa -> matches mlq qa && matches qa mlq) q)
               ((showsl_lit "unlabeling " . showsl_terma lq) .
                 showsl_lit " yields a term not in Q"))
           lQ)
         (\ x -> Inl (snd x));

sem_lab_quasi_root_proc ::
  forall a b c d.
    (Compare a, Eq a, Showl a, Ceq d, Ccompare d, Compare d, Eq d,
      Mapping_impl d, Set_impl d,
      Showl d) => (a -> (a, b)) ->
                    Dpp_ops_ext c a d () ->
                      Sum (String -> String) () ->
                        ([(Term a d, Term a d)] -> Sum (String -> String) ()) ->
                          ([(Term a d, Term a d)] ->
                            Sum (String -> String) ()) ->
                            ([Term a d] ->
                              [Term a d] -> Sum (String -> String) ()) ->
                              (Set (Term a d, Term a d) ->
                                [(Term a d, Term a d)] ->
                                  Sum (String -> String) ()) ->
                                ([(Term a d, Term a d)] ->
                                  [(Term a d, Term a d)] ->
                                    Sum (String -> String) ()) ->
                                  (Set (Term a d, Term a d) ->
                                    [(Term a d, Term a d)] ->
                                      Sum (String -> String) ()) ->
                                    [(Term a d, Term a d)] ->
                                      [Term a d] ->
[(Term a d, Term a d)] -> c -> Sum (String -> String) c;
sem_lab_quasi_root_proc ld i valid check_decra check_decr check_lhss_more
  check_lab_all check_lab_all_trs check_model_lab lPAll lQ lRAll dpp =
  let {
    r = rd i dpp;
    rw = rwd i dpp;
    pw = pwb i dpp;
    p = pb i dpp;
    nfs = nfsc i dpp;
    m = minimal i dpp;
  } in (case model_splitter ld lPAll (set pw) of {
         (lP, (lPw, _)) ->
           (case quasi_splitter ld lRAll (set rw) of {
             (lR, (lRw, d)) ->
               let {
                 qempty = q_emptyc i dpp;
               } in (case bindb valid
                            (\ _ ->
                              bindb (check
                                      (if nfs
then (if not qempty then wwf_rulesa i dpp else True) else True)
                                      (showsl_lit "well formedness required"))
                                (\ _ ->
                                  bindb (catch_errora
  (forallM
    (\ (l, ra) ->
      bindb (check_no_var l)
        (\ _ ->
          bindb (check_no_var ra)
            (\ _ ->
              check_no_defined_root (\ fn -> not (null (rules_mapc i dpp fn)))
                ra)))
    (pairsb i dpp))
  (\ x -> Inl (snd x)))
                                    (\ _ ->
                                      bindb
(catch_errora (forallM (\ (l, _) -> check_no_var l) (rulesf i dpp))
  (\ x -> Inl (snd x)))
(\ _ ->
  let {
    q = qc i dpp;
  } in bindb (if nfs && not qempty then check_wf_trs d else Inr ())
         (\ _ ->
           bindb (check_decra d)
             (\ _ ->
               bindb (check_decr d)
                 (\ _ ->
                   bindb (catch_errora
                           (forallM
                             (\ qa ->
                               check (linear_term qa)
                                 (showsl_lit
                                   "Q must not contain non-linear terms"))
                             q)
                           (\ x -> Inl (snd x)))
                     (\ _ ->
                       catch_errora
                         (bindb (check_lhss_more lQ q)
                           (\ _ ->
                             bindb (check_sl_Q ld lQ q)
                               (\ _ ->
                                 bindb (check_lab_all (set lP) p)
                                   (\ _ ->
                                     bindb (check_lab_all (set lPw) pw)
                                       (\ _ ->
 bindb (check_model_lab (set lR) r)
   (\ _ ->
     bindb (check_model_lab (set lRw) rw)
       (\ _ ->
         bindb (check_lab_all_trs lR r) (\ _ -> check_lab_all_trs lRw rw))))))))
                         (\ x ->
                           Inl (showsl_lit "problem during labeling:\n" .
                                 x))))))))))
                      of {
                      Inl a -> Inl a;
                      Inr _ -> Inr (mkd i nfs m lP lPw lQ lR (lRw ++ d));
                    });
           });
       });

eval_lab ::
  forall a b c d e.
    (a -> [b] -> b) ->
      (a -> [b] -> c) ->
        (a -> Nat -> c -> d) -> (e -> b) -> Term a e -> (b, Term d e);
eval_lab i l lc alpha (Var x) = (alpha x, Var x);
eval_lab i l lc alpha (Fun f ts) =
  let {
    clts = map (eval_lab i l lc alpha) ts;
    cs = map fst clts;
    c = i f cs;
    lts = map snd clts;
  } in (c, Fun (lc f (size_list ts) (l f cs)) lts);

check_sl_rule_ass ::
  forall a b c d e.
    (Showl a, Showl b, Compare d, Eq d, Showl d, Compare e, Eq e,
      Showl e) => Bool ->
                    (a -> [b] -> b) ->
                      (a -> [b] -> c) ->
                        (a -> Nat -> c -> d) ->
                          (b -> b -> Bool) ->
                            Set (Term d e, Term d e) ->
                              (e -> b) ->
                                (Term a e, Term a e) ->
                                  Sum (String -> String) ();
check_sl_rule_ass mc i la lc cge lR alpha (l, r) =
  let {
    cl_ll = eval_lab i la lc alpha l;
    cr_lr = eval_lab i la lc alpha r;
  } in bindb (check (if mc then cge (fst cl_ll) (fst cr_lr) else True)
               (((((showsl_lit "rule " . showsl_rule (l, r)) .
                    showsl_lit " violates the model condition, [lhs] = ") .
                   showsl (fst cl_ll)) .
                  showsl_lit ", [rhs] = ") .
                 showsl (fst cr_lr)))
         (\ _ ->
           check (member (snd cl_ll, snd cr_lr) lR)
             ((showsl_lit "labeled rule " .
                showsl_rule (snd cl_ll, snd cr_lr)) .
               showsl_lit " missing"));

check_sl_rule ::
  forall a b c d e.
    (Showl a, Showl b, Compare d, Eq d, Showl d, Compare e, Eq e,
      Showl e) => (a -> [b] -> b) ->
                    (a -> [b] -> c) ->
                      (a -> Nat -> c -> d) ->
                        [b] ->
                          (b -> b -> Bool) ->
                            Bool ->
                              Set (Term d e, Term d e) ->
                                (Term a e, Term a e) ->
                                  Sum (String -> String) ();
check_sl_rule i l lc c cge mc lR lr =
  catch_errora
    (forallM (\ alpha -> check_sl_rule_ass mc i l lc cge lR alpha lr)
      (map fun_of (enum_vectors c (insert_vars_rule lr []))))
    (\ x -> Inl (snd x));

check_sl_model_lab_trs_set ::
  forall a b c d.
    (Compare a, Eq a, Showl a, Showl b, Compare d, Eq d,
      Showl d) => (a -> [b] -> b) ->
                    (a -> [b] -> c) ->
                      [b] ->
                        (b -> b -> Bool) ->
                          (a -> Nat -> c -> a) ->
                            Set (Term a d, Term a d) ->
                              [(Term a d, Term a d)] ->
                                Sum (String -> String) ();
check_sl_model_lab_trs_set i l c cge labl lR r =
  catch_errora (forallM (check_sl_rule i l labl c cge True lR) r)
    (\ x -> Inl (snd x));

check_sl_model_lab_trs ::
  forall a b c d.
    (Compare a, Eq a, Showl a, Showl b, Compare d, Eq d,
      Showl d) => (a -> [b] -> b) ->
                    (a -> [b] -> c) ->
                      [b] ->
                        (b -> b -> Bool) ->
                          (a -> Nat -> c -> a) ->
                            Set (Term a d, Term a d) ->
                              [(Term a d, Term a d)] ->
                                Sum (String -> String) ();
check_sl_model_lab_trs i l c cge labl lR r =
  check_sl_model_lab_trs_set i l c cge labl lR r;

check_NF_vars_subset ::
  forall a b.
    (Eq a, Ccompare b, Eq b,
      Mapping_impl b) => [Term a b] -> [Term a b] -> Sum (Term a b) ();
check_NF_vars_subset qa q =
  catch_errora (forallM (\ qaa -> check (any (