theory Matrix_Core_Order_Impl
  imports 
    Matrix_Core_Order
    Jordan_Normal_Form.Matrix_Impl
    Certification_Monads.Check_Monad
    Certification_Monads.Error_Monad
    Show.Shows_Literal
    Term_Order_Impl
    First_Order_Rewriting.Trs_Impl
begin


type_synonym ('f,'a) fun_coeffs = "(('f \<times> nat) \<times> ('a mat list \<times> 'a mat)) list"
  \<comment> \<open>the list of function symbols occurring in a TRS and their corresponding interpretation coefficients\<close>

definition "show_core_matrix_inter_main mode d idx intr =
     showsl_lit (STR ''core matrix interpretation (mode = '')
   o showsl_lit mode
   o showsl_lit (STR '') with dimension '') o showsl d o showsl_lit (STR '' and strict indices I = '')
   o showsl (map Suc idx) o showsl_lit (STR '' where\<newline>'')
   o showsl_sep (\<lambda> ((f,n),(cs,c)). 
          showsl_lit (STR ''['')
        o showsl (Fun f (map (\<lambda> i. Var (''x'' @ show i)) [1..<Suc n])) 
        o showsl_lit (STR ''] = '')
        o showsl (LPoly c (zip (map (\<lambda> i. ''x'' @ show i) [1..<Suc n]) cs))
     ) (showsl_lit (STR ''\<newline>'')) intr
   o showsl_lit (STR ''\<newline>and\<newline>[f(x1,..,xn)] = x1 + ... + xn + 1 for all other symbols f\<newline>\<newline>'')"  


locale core_mat_inter_impl = core_mat_inter n \<delta> for n :: nat and 
  \<delta> :: "'a :: {showl, ring_1,zero_less_one,ordered_ab_group_add,ordered_semiring_1,Rings.ordered_semiring_0}" 
begin

(* TODOs: make strong monotonicity optional *)

definition check_valid_dims where "check_valid_dims = 
  (\<lambda> ((f,k),(cs,c)). do { 
       check (Ball (set cs) (\<lambda> c. c \<in> carrier_mat n n \<and> c \<ge>\<^sub>m 0\<^sub>m n n)) (showsl (STR ''coefficients must be in N''));
       check (c \<in> carrier_mat n n) (showsl (STR ''wrong matrix dimension of constant part''));
       check (length cs = k) (
         showsl (STR ''number of coefficient of symbol '') o showsl f o showsl (STR '' differs from arity of symbol''))
      })" 

definition core_EI_rel_impl :: "nat list \<Rightarrow> ('f :: showl,'a)fun_coeffs \<Rightarrow> ('f, 'v :: showl) rel_impl" where "core_EI_rel_impl I fk_cs = (let 
   II = II_list_to_II fk_cs;
   checkNS = (\<lambda> lr. check (check_lpoly_N_N (poly_of_rule_N II (set I) lr)) 
       (showsl (STR ''could not weakly orient rule '') o showsl_rule lr)) in
   \<lparr>rel_impl.valid = do {check (\<delta> > 0) (showsl (STR ''delta must be positive''));
       check (Ball (set I) (\<lambda> i. i < n)) (showsl (STR ''indices in I must be below matrix dimension''));
       check (I \<noteq> []) (showsl (STR ''indices I must be non-empty''));
       check_allm check_valid_dims fk_cs;
       check_allm (\<lambda> (fk,_). check (check_lpoly_N_E\<^sub>I (set I) (inter_lpoly_N II (set I) fk)) 
        (showsl (STR ''interpretation of symbol '') o showsl (fst fk) o showsl (STR '' exceeds E-I carrier''))) fk_cs;
       check_allm (\<lambda> (_,csc). check (Ball (set (fst csc)) (\<lambda> a. a \<ge>\<^sub>m oneE\<^sub>I (set I))) (showsl (STR '' require monotone coefficient in E-I''))) fk_cs
     },
     standard = succeed,
     desc = show_core_matrix_inter_main (STR ''E_I'') n I fk_cs,
     s = (\<lambda> lr. check (check_lpoly_N_P\<^sub>I I (poly_of_rule_N II (set I) lr)) 
       (showsl (STR ''could not strictly orient rule '') o showsl_rule lr)),
     ns = checkNS, 
     nst = checkNS,
     af = full_af,
     top_af = full_af,
     SN = succeed,
     subst_s = succeed,
     ce_compat = succeed,
     co_rewr = succeed,
     top_mono = succeed,
     top_refl = succeed,
     mono_af = (\<lambda> f. UNIV),
     mono = (\<lambda> _. succeed),
     not_wst = None, 
     not_sst = None, 
     cpx = no_complexity_check \<rparr>)"

lemma core_EI_rel_impl: assumes SN: "\<delta> > 0 \<Longrightarrow> SN {(x, y). 0 \<le> y \<and> \<delta> \<le> x - y}" 
  shows "rel_impl (core_EI_rel_impl I fk_cs)" 
  unfolding rel_impl_def
proof (intro impI allI, goal_cases)
  case (1 U)
  let ?I = "set I" 
  define II where "II = II_list_to_II fk_cs" 
  note valid = 1[unfolded core_EI_rel_impl_def Let_def, simplified, folded II_def]
  have pre: "0 < \<delta>" "0 \<le> \<delta>" "?I \<subseteq> {..<n}" "?I \<noteq> {}" using valid by auto
  note SN = SN[OF pre(1)]
  have pre1: "\<forall>f k cs c. II (f, k) = (cs, c) \<longrightarrow> set cs \<subseteq> N \<and> length cs = k \<and> c \<in> carrier_mat n n" 
  proof (intro allI impI, rule II_list_to_II_dim[OF II_def], goal_cases)
    case (1 f' k' cs' c' f k cs c)
    from valid 1 have "isOK (check_valid_dims ((f, k), cs, c))" by auto
    from this[unfolded check_valid_dims_def split]
    show ?case by (auto simp: N_def)
  qed
  note p1 = pre1 pre(3,2)
  have pre2: "\<forall>as f. set as \<subseteq> E\<^sub>I (set I) \<longrightarrow> alpha II f as \<in> E\<^sub>I (set I)" 
    by (rule II_list_to_II_EI[OF p1 II_def], insert valid, auto)
  note p2 = p1 SN pre2
  note p3 = p2 pre(4)
  note redtriple_main = EI_mat_order[OF p3 II_def]
  note redtrip = redtriple_main[THEN conjunct1]
  note ceNS = redtriple_main[THEN conjunct2]
  have pre3: "\<forall>f k cs c. II (f, k) = (cs, c) \<longrightarrow> set cs \<subseteq> E\<^sub>I (set I)" 
    by (rule II_list_to_II_mono[OF p2 II_def], insert valid, auto)
  note mono_red = EI_mono_mat_order[OF p2 pre3 pre(4) II_def]
  note ceS = mono_red[THEN conjunct2]
  note mono = mono_red[THEN conjunct1]
  let ?S = "wf_algebra.S_A (S\<^sub>E (set I)) (E\<^sub>I (set I)) (alpha II)" 
  let ?NS = "wf_algebra.NS_A (NS\<^sub>E (set I)) (E\<^sub>I (set I)) (alpha II)" 
  interpret mono_redtriple_order ?S ?NS ?NS by fact
  show ?case unfolding core_EI_rel_impl_def Let_def rel_impl.simps II_def[symmetric]
  proof (rule exI[of _ ?S], intro exI[of _ ?NS], intro conjI impI allI
      refl_NST ctxt_NS ctxt_S subst_NS subst_S full_af not_subterm_rel_info.simps ceNS ceS
          compat_S_NS compat_NS_S trans_S trans_NS S_imp_NS SN ctxt_closed_imp_af_monotone top_mono_same)
    show "irrefl ?S" using SN by (meson SN_on_irrefl irrefl_on_def)
    show "?NS \<inter> ?S\<inverse> = {}" by (simp add: \<open>irrefl ?S\<close> co_rewrite_irrefl compat_NS_S)
  qed (auto simp: isOK_no_complexity 
      intro!: EI_S_criterion[OF p2 _ refl] EI_NS_criterion[OF p2])
qed
end

lemmas core_mat_inter_impl_code = 
  core_mat_inter_impl.core_EI_rel_impl_def
  core_mat_inter_impl.check_valid_dims_def

declare core_mat_inter_impl_code[code]


definition "core_EI_rel_impl_int n = core_mat_inter_impl.core_EI_rel_impl n (1 :: int)" 

definition "core_EI_rel_impl_fract n (\<delta> :: 'a :: {floor_ceiling,showl}) = core_mat_inter_impl.core_EI_rel_impl n \<delta>"

lemma core_EI_rel_impl_int: "rel_impl (core_EI_rel_impl_int n I fk_cs)" 
proof -
  have id: "1 \<le> x - (y :: int) = (x > y)" for x y by linarith
  show ?thesis unfolding core_EI_rel_impl_int_def
    apply (rule core_mat_inter_impl.core_EI_rel_impl)
    apply (unfold id)
    apply (rule int_SN.SN)
    done
qed

lemma core_EI_rel_impl_fract: "rel_impl (core_EI_rel_impl_fract n \<delta> I fk_cs)" 
proof -
  show ?thesis unfolding core_EI_rel_impl_fract_def
    apply (rule core_mat_inter_impl.core_EI_rel_impl) 
    apply (drule delta_gt_SN)
    apply (auto simp: delta_gt_def)
    done
qed

end

