# crest-cr, crest-sn and crest-{cr,sn}-benchmark

## Installation
You need to install the Z3 SMT solver [Z3](https://github.com/Z3Prover/z3) (or if the respective flags are used also [Yices2](https://github.com/SRI-CSL/yices2) and [CVC5](https://github.com/cvc5/cvc5)) and [Haskell](https://www.haskell.org/).
To resolve package dependencies within Haskell we recommend using one of the options below.
Furthermore crest-benchmark uses the tool [find](https://www.gnu.org/software/findutils/).
The following information below belongs to ```crest-cr``` (confluence tool) as well as applies also to ```crest-sn``` (termination tool), ```crest-cr-benchmark``` and ```crest-sn-benchmark```.
Be aware that currently ```yices``` and ```cvc5``` support is experimental and do not always work with crest, hence we recommend Z3.

### Cabal
Install [cabal](https://www.haskell.org/cabal/) and either build the project with
```cabal build```
and run it with 
```cabal run crest-cr -- ARGUMENTS```
or install a native binary with
```cabal install```.

### Stack
Install [stack](https://haskellstack.org) and either build the project with
```stack build```
and run it with 
```stack run crest-cr -- ARGUMENTS```
or install a native binary with
```stack install```.

### Makefile
Install [cabal](https://www.haskell.org/cabal/) and build the project with
```make```
This copies the respective compiled binaries to the root folder.

### Docker
We also provide a Dockerfile and shell scripts to build statically 
linked Linux binaries via Alpine Linux.
Install [Docker](https://www.docker.com/) for your operating system and configure it.
After that follow the instructions in ```./docker/README``` to 
build those executables.

### Documentation
In order to access the (rather limited) documentation of the crest library you have to execute
```cabal build --enable-documentation```.

## Usage 
The usage information of tools can be accessed via the respective ```--help``` flag for each
executable.

## Contribution
If you decide to contribute to this project, please use the haskell formatter ```fourmolu```
with the provided configuration file ```fourmolu.yaml``` in the repository in order to 
keep a common style across all *.hs files. Also follow the GPL 3.0 (or later) license which is used
for crest.

## Input Format
The input format of crest follows almost the [ARI format](https://project-coco.uibk.ac.at/ARI/index.php).
Although some generalizations/restrictions on the [LCTRS format](https://project-coco.uibk.ac.at/ARI/lctrs.php) are imposed:
* *smt-def* allows in the formula part arbitrary SMT-LIB formulas w.r.t. the theories of the LCTRS
* it allows all function symbols (including special symbols with "_") from theories and defined in the logic **QF_BV**
* identifiers need to follow the syntax of simple symbols specified in the [SMT-LIB language](https://smtlib.cs.uiowa.edu/papers/smt-lib-reference-v2.6-r2021-05-12.pdf#page=24)
* crest parses the following values for theories:
  + theory **Core**: the values **true** and **false**
  + theory **Ints**: standard integers
  + theory **Reals**: standard decimal numbers ("." is mandatory, which means that for "1" we need to write "1.0")
  + theory **Reals_Ints**: all values from **Ints** and **Reals**
  + theory **FixedSizeBitVectors**: standard bitvectors constants defined in the theory [FixedSizeBitVectors](https://smt-lib.org/theories-FixedSizeBitVectors.shtml) and the logic [QF_BV](https://smt-lib.org/logics.shtml#QF_BV)

## Output
Variables are renamed at different stages of the analysis, hence may be different from the input.
To distinguish original from fresh variables we prefix them with "!" and "?", respectively.

## Problems
In case of experiencing any problems please contact ```(λ name domain. name@domain) jonas.schoepf uibk.ac.at```.

## Contributors 
+ Jonas Schöpf (main author and current maintainer) 
+ Jonathan Bodemann 
