#!/bin/bash

# directory setup
DIR=$(pwd)
BDIR="$(pwd)/static_binaries"
TMPDIR=$(mktemp -d)
trap '{ rm -rf $TMPDIR; }' EXIT
cp . "$TMPDIR" -r

mkdir -p "$BDIR"

cd "$TMPDIR" \
&& cabal clean \
&& cabal update \
&& cabal build -j --enable-executable-static --enable-executable-stripping \
&& cp "$(cabal list-bin crest-cr)" "$BDIR" \
&& cp "$(cabal list-bin crest-sn)" "$BDIR" \
&& cp "$(cabal list-bin crest-cr-benchmark)" "$BDIR" \
&& cp "$(cabal list-bin crest-sn-benchmark)" "$BDIR" \
&& cp "$(cabal list-bin lctrs-tagging)" "$BDIR" \
&& cp "$(cabal list-bin ari2ctrl)" "$BDIR" \
&& cp "$(cabal list-bin ari2cora)" "$BDIR" \
&& cp "$(cabal list-bin ari2crest-cade)" "$BDIR" \
&& chown "$1:$2" -R "$BDIR"
# && chown "$1:$2" -R dist-newstyle
# && cabal install -j --enable-executable-static --install-method=copy --installdir=$BDIR --overwrite-policy=always \
# && chown "$1:$2" -R $BDIR
