module Analysis.Termination.ReductionPair where

import Analysis.Termination.DependencyPairs (DPProblem)
import Analysis.Termination.Termination (SNInfo)
import Data.LCTRS.FIdentifier (FId)
import Data.LCTRS.Rule (Rule, lvar, rhs)
import Data.LCTRS.Term (
  Term,
  isLogicTerm,
  vars,
 )
import qualified Data.LCTRS.Term as T
import Data.LCTRS.VIdentifier (VId)
import Data.Monad
import Data.SExpr (ToSExpr)
import Data.Set (Set, fromList, isSubsetOf)
import Prettyprinter (Pretty)

applyReductionPair
  :: (Ord v, Pretty f, Ord f, ToSExpr v)
  => DPProblem (FId f) (VId v)
  -> (DPProblem (FId f) (VId v) -> StateM (DPProblem (FId f) (VId v), Maybe (SNInfo (FId f) (VId v))))
  -> StateM (Maybe (DPProblem (FId f) (VId v), SNInfo (FId f) (VId v)))
applyReductionPair dpp rp = do
  (newDPP, msninfo) <- rp dpp
  case msninfo of
    Nothing -> return Nothing
    Just sninfo -> return $ Just (newDPP, sninfo)

allRhsSubtermsGroundLogicalTerms :: (Ord v) => Rule (FId f) (VId v) -> Bool
allRhsSubtermsGroundLogicalTerms dp = all (isGroundLogicalTerm (lvar dp)) $ getArgs (rhs dp)
 where
  getArgs (T.Var _) = []
  getArgs (T.Fun _ _ ss) = ss

isGroundLogicalTerm :: (Ord v) => Set (VId v) -> Term (FId f) (VId v) -> Bool
isGroundLogicalTerm lvars t = isLogicTerm t && fromList (vars t) `isSubsetOf` lvars
