{- |
Module      : Monomial
Description :
Copyright   : (c) Jonas Schöpf, 2024
License     : GPL-3
Maintainer  : jonas.schoepf@uibk.ac.at
Stability   : stable


This module provides the main types and auxiliary functions for monomials.
-}
module Data.Polynomial.Monomial where

import Data.MultiSet (MultiSet)
import qualified Data.MultiSet as MS
import qualified Data.Set as S

newtype Monomial v = Monomial (MultiSet v)
  deriving (Eq, Ord)

unitMonomial :: Monomial v
unitMonomial = Monomial MS.empty

fromPowers :: (Ord v) => [(v, Int)] -> Monomial v
fromPowers = Monomial . MS.fromOccurList

toPowers :: Monomial v -> [(v, Int)]
toPowers (Monomial m) = MS.toOccurList m

monoVariables :: Monomial v -> [v]
monoVariables (Monomial m) = S.toAscList (MS.toSet m)

monoIsFactorOf :: (Ord v) => Monomial v -> Monomial v -> Bool
Monomial m1 `monoIsFactorOf` Monomial m2 = m1 `MS.isSubsetOf` m2
