module Exercise07(checkARIs) where

import Text.ParserCombinators.Parsec

import System.IO(hFlush, stdout)

type Metadata = [(String,String)]
type Id = String
type Signature = [(Id,Int)]
data Term = Var Id | Fun Id [Term] deriving Show
type Rule = (Term,Term)

eol = (try (string "\n\r")
  <|> try (string "\r\n")
  <|> string "\n" 
  <|> string "\r"
  <?> "end of line") >> return ()



{- Task 1: define header -}

header :: GenParser Char u Metadata
header = undefined 


{- Task 2 and 3: define content -}

content :: GenParser Char u [Rule]  
content = undefined 

ari :: GenParser Char u (Metadata, [Rule])
ari = do 
  meta <- header
  trs <- content
  return (meta, trs)

parseARI :: FilePath -> IO (Either ParseError (Metadata, [Rule]))
parseARI file = do
  input <- readFile file
  return $ parse ari file input
  
-- check a single ARI file
checkARI :: FilePath -> IO Bool     
checkARI file = do
  putStr $ "Parsing " ++ file ++ " ... "
  hFlush stdout
  p <- parseARI file
  case p of
    Right _ -> putStrLn "ok" >> return True
    _ -> putStrLn "FAILED" >> return False

-- check all ARI files that are listed in input file
checkARIs :: FilePath -> IO ()
checkARIs file = do
  aris <- lines <$> readFile file
  checks <- mapM checkARI aris
  putStrLn $ if and checks then "all files parsed" else "some files failed"