module Demo08_Parser_ARI_Applicative where

import Text.ParserCombinators.Parsec
import TRS

-- A simplified TRS-rule parser for ARI (Exercise 7, Task 2)

contentSimple :: GenParser Char u [Rule]  
contentSimple = spaces *> many rule <* eof  

lexeme p = p <* spaces 
charS c = () <$ lexeme (char c)
exactlyS s = lexeme $ try (string s *> (notFollowedBy identChar <?> "end of tag " ++ s))

identChar = noneOf " \t\n();:"
identifier = lexeme $ many1 identChar

term =  Var <$> identifier 
    <|> Fun <$> (charS '(' *> identifier) <*> many term <* charS ')'

rule = (,) <$> (try (charS '(' *> exactlyS "rule") *> term) <*> term <* charS ')'
