module Demo08_Parser_ARI_Do_Blocks where

import Text.ParserCombinators.Parsec
import TRS

-- A simplified TRS-rule parser for ARI (Exercise 7, Task 2)

contentSimple :: GenParser Char u [Rule]  
contentSimple = do  
   spaces
   rs <- many rule
   eof
   return rs

-- drop trailing whitespace
lexeme :: GenParser Char u a -> GenParser Char u a
lexeme p = do 
  a <- p
  spaces
  return a
  
-- a parser for characters that may be used in identifiers
identChar :: GenParser Char u Char
identChar = noneOf " \t\n();:"

identifier :: GenParser Char u Id
identifier = lexeme $ many1 identChar

charS :: Char -> GenParser Char u ()
charS c = do 
  _ <- lexeme (char c)
  return ()
  
variable = do 
  i <- identifier
  return $ Var i
  
funapp = do 
    charS '('
    f <- identifier
    ts <- many term
    charS ')'
    return $ Fun f ts

term :: GenParser Char u Term
term = variable <|> funapp

exactlyS s = lexeme $ try $ do
    _ <- string s
    notFollowedBy identChar <?> "end of tag" ++ s

rule :: GenParser Char u Rule
rule = do 
   try $ do 
      charS '('
      exactlyS "rule"
   l <- term
   r <- term
   charS ')'
   return (l,r)
