module Exercise08_LPO where

{-  Task 3 -}

import SMT
import TRS
import Exercise08_SMT
import Demo08_Parser_ARI_Applicative
import Text.ParserCombinators.Parsec(parse) 

-- this type clearly needs to be extended by suitable monad transformers
type LPOEncoder = SmtEncoder

-- this function should return the precedence of a function f,
-- i.e., a unique integer variable for f with range 1 .. n 
getPrec :: Id -> LPOEncoder IAExpr
getPrec = undefined 

-- this function is the wrapper that takes care of memoization
-- and it should introduce Tseitin-variables b for large formulas;
-- the result of lpoEncoder should be a small formula (use atomic :: Formula -> Bool
-- to test on small/large formulas),
-- but in the background several auxiliary formulas such as
-- "b <-> formula" might be asserted.

lpoEncoder :: (Term, Term) -> LPOEncoder Formula
lpoEncoder = undefined "write the wrapper around" lpo2

-- the syntactic definition of LPO encoded into a formula
lpo2 (Var _, _) = return false
lpo2 (Fun _ ss, t@(Var _)) = disj <$> mapM (\ si -> lpoEq (si,t)) ss
lpo2 (s@(Fun f ss), t@(Fun g ts)) 
  | f /= g = do
      phi <- mapM (\ si -> lpoEq (si,t)) ss
      pf <- getPrec f
      pg <- getPrec g
      psi <- mapM (\ tj -> lpoEncoder (s,tj)) ts
      return $ disj (conj (Gt pf pg : psi) : phi)
  | s == t = return false
  | otherwise = case dropWhile ( \ (si, ti) -> si == ti) $ zip ss ts of
      (si_ti : other) -> do
        phi <- mapM (\ si -> lpoEq (si,t)) ss
        psi <- lpoEncoder si_ti
        chi <- mapM ( \ (_, tj) -> lpoEncoder (s,tj)) other
        return $ disj $ conj (psi : chi) : phi

-- greater-equal for LPO
lpoEq (s,t) 
  | s == t = return true
  | otherwise = lpoEncoder (s,t)

-- take the result of the lpoEncoder and assert it (might need adjustments)
ruleEncoder :: Rule -> LPOEncoder ()
ruleEncoder st = lpoEncoder st >>= assertFormula

trsEncoder :: [Rule] -> LPOEncoder ()
trsEncoder = mapM_ ruleEncoder

-- run everything (might need adjustments)
runTrsEncoder :: [Rule] -> String
runTrsEncoder r = runSmtEncoder $ trsEncoder r

runTest :: String -> IO ()
runTest ariSimple = case parse contentSimple "" ariSimple of
  Left e -> putStrLn $ "parse error: " ++ show e
  Right r -> putStrLn $ runTrsEncoder r 

testInput1 = "(rule (f (s x)) (g x (h x)))    (rule (g x (s y)) (g x (f y)))"

{- output of "runTest testInput1" might be:

(set-logic QF_LIA)
(declare-fun x1 () Int)
(assert (and (<= 1 x1) (<= x1 4)))
(declare-fun x2 () Int)
(assert (and (<= 1 x2) (<= x2 4)))
(declare-fun x3 () Int)
(assert (and (<= 1 x3) (<= x3 4)))
(declare-fun x4 () Bool)
(assert (= x4 (and (> x1 x2) (> x1 x3))))
(declare-fun x5 () Int)
(assert (and (<= 1 x5) (<= x5 4)))
(declare-fun x6 () Bool)
(assert (= x6 (or (> x5 x3) (> x1 x3))))
(declare-fun x7 () Bool)
(assert (= x7 (or (and (> x5 x2) x6) x4)))
(assert x7)
(assert (> x1 x5))
(check-sat)

; this formulas should be satisfiable, e.g. by the z3 smt solver

-}

testInput2 = "(rule (f x y (a)) (f x y (b)))   (rule (f x (b) y) (f x (a) (a)))"

{- output of "runTest testInput2" might be:

(set-logic QF_LIA)
(declare-fun x1 () Int)
(assert (and (<= 1 x1) (<= x1 3)))
(declare-fun x2 () Int)
(assert (and (<= 1 x2) (<= x2 3)))
(declare-fun x3 () Int)
(assert (and (<= 1 x3) (<= x3 3)))
(assert (> x1 x3))
(declare-fun x4 () Bool)
(assert (= x4 (or (> x2 x1) (> x3 x1))))
(declare-fun x5 () Bool)
(assert (= x5 (and (> x3 x1) x4)))
(assert x5)
(check-sat)

; this formulas should not be satisfiable, e.g., by the z3 smt solver

-}
