module Demo09 where

import Control.Exception
import System.IO

badNumber, goodNumber :: Int
badNumber = 5 `div` 0
goodNumber = 5 `div` 1

tryBad, tryGood :: IO (Either SomeException ())
tryBad = try (putStrLn $ show badNumber)
tryGood = try (putStrLn $ show goodNumber)

tryReturnBad, tryEvaluateBad :: IO ()

tryReturnBad = (try (return badNumber) :: IO (Either SomeException Int))
  >>= (\ x -> putStrLn $ show x)
  
tryEvaluateBad = (try (evaluate badNumber) :: IO (Either SomeException Int))
  >>= putStrLn . show

tryToRead :: FilePath -> IO String
tryToRead f = catch (readFile f) $ \e -> 
  do let err = show (e :: IOException)
     hPutStr stderr ("Warning: Couldn't open " ++ f ++ ": " ++ err)
     return ""
  
  
data MyException = Negative | TooLarge
   deriving (Show)

instance Exception MyException

primeList = [2,3,5,7,11,13,17,21,23,29]

easyPrimeTest :: Integer -> Bool
easyPrimeTest x 
 | x < 0 = throw Negative
 | x > 30 = throw TooLarge
 | otherwise = x `elem` primeList
 
prime x = catchJust 
  ( \ myE -> case myE of {TooLarge -> Just (); _ -> Nothing} )
  (evaluate $ easyPrimeTest x)
  (\ () -> error $ "TODO: run full prime test on " ++ show x)
 