module Main(main) where

import qualified Data.Map as M
import System.IO
import System.IO.Temp
import System.Environment(getArgs)
import System.Process
import System.Directory

import Parser_ARI
import Demo09_LPO_Encoder
import Exercise09_SMT
import SMT
import TRS


import Control.DeepSeq(($!!))

commFile1 trs = do 
  let smtFile = "file.smt2"
  let enc = snd $ lpoTrsEncoder trs
  writeFile smtFile enc
  let answerFile = "answer.txt"
  -- TODO: invoke "z3 -smt2 file.smt2 > answer.txt", or simulate by
  writeFile answerFile $ "sat\n" ++ concat (replicate 100000 "ab\n")
  answer <- readFile answerFile
  removeFile answerFile
  removeFile smtFile
  let (firstLine : rest) = lines answer
  result <- if firstLine == "sat" 
    then return $ Just $ 
       "parse " ++ show (length rest) ++ " lines and convert to precedence"
    else return Nothing
  return result

crash = do 
   originalContent <- readFile "foo.txt"
   writeFile "foo.txt" "overwrite the content"
   return $ take 20 originalContent

stillCrash = do 
   hr <- openFile "foo.txt" ReadMode
   originalContent <- hGetContents hr
   hClose hr
   return $ take 20 originalContent

noCrash = withFile "foo.txt" ReadMode (\h -> do
   s <- hGetContents h
   return $!! take 20 s)

commFile2 trs = 
  withSystemTempFile "file.smt2" (\ smtFile hf ->
  withSystemTempFile "answer.txt" (\ answerFile ha -> do
    let enc = snd $ lpoTrsEncoder trs
    hPutStrLn hf enc
    hFlush hf
    
    -- TODO: invoke "z3 -smt2 smtFile > answerFile", or simulate by
    hPutStrLn ha $ "sat\n" ++ concat (replicate 100000 "ab\n")
    hFlush ha >> hSeek ha AbsoluteSeek 0
    
    answer <- hGetContents ha
    
    let (firstLine : rest) = lines answer
    result <- if firstLine == "sat" 
      then return $!! Just $ 
         "parse " ++ show (length rest) ++ " lines"
      else return Nothing
    return result
  ))

commFile3 trs = 
  withSystemTempFile "file.smt2" (\ smtFile hf -> do
    answerFile <- emptySystemTempFile "answer.txt"
    
    let enc = snd $ lpoTrsEncoder trs
    hPutStrLn hf enc
    hPutStrLn hf "(exit)\n"
    hClose hf -- flush and release write-lock on smtFile
    
    let cpConfig = shell $ "z3 -smt2 " ++ smtFile ++ " > " ++ answerFile
    (_,_,_,ph) <- createProcess cpConfig
    _ <- waitForProcess ph 
    
    answer <- readFile answerFile    
    let result = head (lines answer) == "sat"         -- no precedence extraction
      
    removeFile answerFile
    return result
  )
  
lpoSearchCommFile ariPath = do
  readFile ariPath >>= commFile3 . parseAri 
  
newtype LPO = LPO_with_Precedence [(Id,Integer)] deriving (Show,Eq)
  
lpoSolver :: TRS -> IO (Maybe LPO)
lpoSolver trs = do
  let (precMap, smtString) = lpoTrsEncoder trs
  let cpConfig = (proc "z3" ["-in"]){ std_out = CreatePipe, std_in  = CreatePipe }
  (Just hSmtIn, Just hSmtOut, _, pHandle) <- createProcess cpConfig
  hPutStrLn hSmtIn smtString >> hFlush hSmtIn
  satStatus <- hGetLine hSmtOut
  answer <- if satStatus /= "sat" then return Nothing else 
    if null precMap then return $ Just $ LPO_with_Precedence [] 
    else do hPutStrLn hSmtIn $ smtRequestValues (map snd precMap)
            hFlush hSmtIn
            parsedModel <- M.fromList <$> smtAnswerFromHandle hSmtOut     
            return $ Just $ LPO_with_Precedence $ 
              map (\ (f, xi) -> (f, parsedModel M.! show xi)) precMap
  hPutStrLn hSmtIn "(exit)"
  hClose hSmtOut
  hClose hSmtIn
  terminateProcess pHandle
  return $ answer
  
searchLPOariFile path = do
  cnt <- readFile path
  putStr path >> putStr " ... searching for LPO ... " >> hFlush stdout
  result <- lpoSolver . parseAri $ cnt
  putStrLn $ show result
  return result

searchLPOariFiles :: FilePath -> IO ()
searchLPOariFiles file = do
  aris <- lines <$> readFile file
  results <- mapM searchLPOariFile aris
  putStrLn $ show (length $ filter (/= Nothing) results) ++ " LPOs found"

main = do
  args <- getArgs
  case args of
    [path] -> searchLPOariFiles path
    _ -> putStrLn "invoke with exactly one argument"
