module Exercise09_LPO_Main(main) where

import qualified Data.Map as M
import System.Environment(getArgs)
import System.IO
import System.Process
import Control.Exception

import Parser_ARI
import Demo09_LPO_Encoder
import Exercise09_SMT
import SMT
import TRS


newtype LPO = LPO_with_Precedence [(Id,Integer)] deriving (Show,Eq)
  
lpoSolverOld :: TRS -> IO (Maybe LPO)
lpoSolverOld trs = do
  let (precMap, smtString) = lpoTrsEncoder trs
  let cpConfig = (proc "z3" ["-in"]){ std_out = CreatePipe, std_in  = CreatePipe }
  (Just hSmtIn, Just hSmtOut, _, pHandle) <- createProcess cpConfig
  hPutStrLn hSmtIn smtString >> hFlush hSmtIn
  satStatus <- hGetLine hSmtOut
  answer <- if satStatus /= "sat" then return Nothing else 
    if null precMap then return $ Just $ LPO_with_Precedence [] 
    else do hPutStrLn hSmtIn $ smtRequestValues (map snd precMap)
            hFlush hSmtIn
            parsedValues <- smtBIAnswerFromHandle hSmtOut
            let intValues = M.fromList [ (f, p) | (f, Right p) <- parsedValues ]
            return $ Just $ LPO_with_Precedence $ 
              map (\ (f, xi) -> (f, intValues M.! show xi)) precMap
  hPutStrLn hSmtIn "(exit)"
  hClose hSmtOut
  hClose hSmtIn
  terminateProcess pHandle
  return $ answer


{- 
Task 2.2 (2 points)  

  Adjust the definition of lpoSolver above, so that is uses
  runSmtSolver and runTrsEncoder instead of lpoTrsEncoder and the smt communication
-}

lpoSolver :: TRS -> IO (Maybe LPO)
lpoSolver trs = undefined


{- 
Task 3 (2 points)
-}

data LPO_Result = YES LPO | NO | MAYBE deriving Show

lpoWrapper :: TRS -> IO LPO_Result
lpoWrapper r = undefined


-- Auxiliary functions for testing

-- e.g., invoke by: searchLPOariFile "ariTRSs/100.ari"
searchLPOariFile path = do
  cnt <- readFile path
  putStr path >> putStr " ... searching for LPO ... " >> hFlush stdout
  result <- lpoSolver . parseAri $ cnt
  putStrLn $ show result
  return result

-- e.g., invoke by: searchLPOariFiles "ariTRSs.txt" 
searchLPOariFiles :: FilePath -> IO ()
searchLPOariFiles file = do
  aris <- lines <$> readFile file
  results <- mapM searchLPOariFile aris
  putStrLn $ show (length $ filter (/= Nothing) results) ++ " LPOs found"

main = do
  args <- getArgs
  case args of
    [path] -> searchLPOariFiles path
    _ -> putStrLn "invoked with exactly one argument"
