module Exercise09_SMT(
  SmtEncoder,
  runSmtEncoder,
  runSmtSolver,
  smtBIAnswerFromHandle,
  smtAnswerFromHandle) where

import SMT
import Exercise09_SMT_Answer_Parser
import Abstract_SMT_Encoder
import System.IO
import System.Process
import Control.Exception
import qualified Data.Map as M

smtAnswerFromHandle :: Handle -> IO [(String, Integer)]
smtAnswerFromHandle h = do
  inp <- hGetContents h
  case parseAnswer inp of
     Left e -> error $ e
     Right res -> return res

smtBIAnswerFromHandle :: Handle -> IO [(String, Either Bool Integer)]
smtBIAnswerFromHandle h = do
  inp <- hGetContents h
  case parseBIAnswer inp of
     Left e -> error e
     Right res -> return res


{-
  Task 2.1 (3 points) 
  Think of a better interface for the smt-communication with the solver,
  so that the communication with the solver is performed inside this module,
  and not revealed to the user.
  
  the encoder app might produce something of value a, and from this a one can compute
  via vars the relevant variables
  -}

runSmtSolver :: SmtEncoder a -> (a -> [SmtVar]) -> your_decision
runSmtSolver app vars = undefined
