module Exercise09_SMT_Answer_Parser(
  parseAnswer,
  parseBIAnswer) where

import Data.Bifunctor(first)
import Data.Char(isAlphaNum)
import Text.ParserCombinators.Parsec
  
-- Task 1 (3 points): 

-- testParser should result in 
--   Right [("x",Right (-5)),("y",Left True),("z",Right 178),("u",Left False)]

testInput =  "((x ( - 5 ) )\n ( y true ) (z 178) (u false))" ++ error "do not read this"
testParser = parse smtBIAnswerParser "" testInput

smtAnswerParser :: Parser [(String, Integer)]
smtAnswerParser = (\ xs -> [(x,v) | (x, Right v) <- xs]) <$> smtBIAnswerParser

-- a parser for answers with Boolean or Integer values
smtBIAnswerParser :: Parser [(String, Either Bool Integer)]
smtBIAnswerParser = undefined


parseAnswer :: String -> Either String [(String, Integer)]
parseAnswer inp = first show $ parse smtAnswerParser "" inp

parseBIAnswer :: String -> Either String [(String, Either Bool Integer)]
parseBIAnswer inp = first show $ parse smtBIAnswerParser "" inp
  