module Demo10_Logger(initLogger, logMessage, logStop) where

import Control.Concurrent

initLogger :: IO Logger
logMessage :: Logger -> String -> IO ()
logStop :: Logger -> IO ()


newtype Logger = Logger (MVar LogCommand)
data LogCommand = Message String | Stop (MVar ())


initLogger = do 
  m <- newEmptyMVar
  let l = Logger m
  forkIO (logger l)
  return l

logger :: Logger -> IO ()
logger (Logger m) = loop where
  loop = do 
    cmd <- takeMVar m
    case cmd of 
      Message msg -> do
        putStrLn msg
        loop
      Stop s -> do 
        putStrLn "logger: stop"
        putMVar s ()
      
logMessage (Logger m) s = putMVar m (Message s)
logStop (Logger m) = do
  s <- newEmptyMVar 
  putMVar m (Stop s)
  takeMVar s

