module Main where

import Data.Time.Clock (diffUTCTime, getCurrentTime)
import System.Environment (getArgs)
import Control.Monad(forever)
import Control.Concurrent(getNumCapabilities, forkIO, threadDelay,
  takeMVar, putMVar, newEmptyMVar)
import qualified Data.ByteString as B
import GetURL


import Demo11_Logger
import Demo11_Chan
import qualified Demo11_Async_Simple as A
import Demo11_Async
 
message s i = "message " ++ show i ++ " of " ++ s

announceLogMessage l m = do
  putStrLn $ "sending message to logger: " ++ m
  logMessage l m

mainLogger = do 
  l <- initLogger 
  forkIO $ mapM_ (announceLogMessage l . message "fork 1") [1..100 :: Int]
  forkIO $ mapM_ (announceLogMessage l . message "fork 2") [1..100 :: Int]
  mapM_ (announceLogMessage l . message "main thread") [1..100 :: Int]
  logStop l

mainChannel = do
  c <- newChan
  mapM_ (writeChan c) ['a' .. 'k']
  d <- dupChan c
  forkIO $ do 
     mapM_ (writeChan c) ['l' .. 's']
     forever (readChan c >>= \ a -> putStrLn $ "read from c: " ++ [a])
  forkIO $ do 
     mapM_ (writeChan d) ['t' .. 'z']
     forever (readChan d >>= \ a -> putStrLn $ replicate 20 ' ' ++ "read from d: " ++ [a])
  threadDelay $ 1000
     
mainGetURL1 = do
  m1 <- newEmptyMVar                                    
  m2 <- newEmptyMVar                                    
  forkIO $ do                                           
    r <- getURL "http://www.wikipedia.org/wiki/Red"
    putMVar m1 r
  forkIO $ do                                           
    r <- getURL "http://www.wikipedia.org/wiki/Green"
    putMVar m2 r
  r1 <- takeMVar m1                                     
  r2 <- takeMVar m2                                     
  print (B.length r1, B.length r2)  


mainGetURL2 = do
  a1 <- A.async $ getURL "http://www.wikipedia.org/wiki/Red"
  a2 <- A.async $ getURL "http://www.wikipedia.org/wiki/Green"
  r1 <- A.wait a1
  r2 <- A.wait a2
  print (B.length r1, B.length r2)  

timeit a = do 
  start <- getCurrentTime
  x <- a
  end <- getCurrentTime
  return (x, end `diffUTCTime` start)


timeDownload url = do
  (page, time) <- timeit $ getURL url
  putStrLn $ "downloaded " ++ url 
     ++ " (" ++ show (B.length page) ++ " bytes, " ++ show time ++ ")"

sites = ["http://www.bing.com",
         "http://www.google.com",
         "http://www.metager.de",
         "http://www.duckduckgo.com"]

mainGetURL3 = do
 as <- mapM (A.async . timeDownload) sites
 mapM_ A.wait as  

sitesBad = ["http://www.bing.com",
         "http://someurlThatDoesNot.Exist",
         "http://www.metager.de",
         "http://www.duckduckgo.com"]

mainGetURL3bad = do
 as <- mapM (A.async . timeDownload) sitesBad
 mapM_ A.wait as  

mainGetURL4 = do
 as <- mapM (async . timeDownload) sites
 mapM_ wait as  

mainGetURL4bad = do
 as <- mapM (async . timeDownload) sitesBad
 mapM_ wait as  

mainGetURL5 = do 
  let download url = (,) url <$> getURL url  
  as <- mapM (async . download) sites
  (url, r) <- waitAny as
  putStrLn $ url ++ " was first (" ++ show (B.length r) ++ " size)"



main = do
  nc <- getNumCapabilities
  putStrLn $ "number of cores: " ++ show nc
  args <- getArgs
  putStrLn $ "args: " ++ show args
  case args of 
    ["logger"] -> mainLogger
    ["channel"] -> mainChannel
    ["url1"] -> mainGetURL1
    ["url2"] -> mainGetURL2
    ["url3"] -> mainGetURL3
    ["url3bad"] -> mainGetURL3bad
    ["url4"] -> mainGetURL4
    ["url4bad"] -> mainGetURL4bad
    ["url5"] -> mainGetURL5
    _ -> error "unknown invocation"
