module Demo11_Async where

import Control.Concurrent
import Control.Exception

data Async a = Async (MVar (Either SomeException a)) 

async :: IO a -> IO (Async a)
async action = do
  var <- newEmptyMVar
  forkIO $ do { r <- try action; putMVar var r }  
  return $ Async var

waitCatch :: Async a -> IO (Either SomeException a) 
waitCatch (Async var) = readMVar var

wait :: Async a -> IO a 
wait a = do
  r <- waitCatch a
  case r of
    Left e  -> throwIO e
    Right a -> return a

waitAny :: [Async a] -> IO a
waitAny as = do
  m <- newEmptyMVar
  let forkWait a = forkIO $ do r <- try (wait a); putMVar m r
  mapM_ forkWait as
  wait (Async m)
