module Demo11_Async_Simple where

import Control.Concurrent

data Async a = Async (MVar a)

async :: IO a -> IO (Async a)
async action = do 
  var <- newEmptyMVar
  forkIO (do r <- action; putMVar var r)
  return (Async var)

wait :: Async a -> IO a
wait (Async var) = readMVar var
