module Demo11_Chan(Chan, newChan, writeChan, readChan, dupChan) where

import Control.Concurrent(MVar, newEmptyMVar, newMVar, takeMVar, putMVar)

type Stream a = MVar (Item a)
data Item a = Item a (Stream a)

data Chan a = Chan { readVar :: MVar (Stream a), writeVar :: MVar (Stream a) }

newChan :: IO (Chan a)
newChan = do
  hole <- newEmptyMVar
  rVar <- newMVar hole
  wVar <- newMVar hole
  return $ Chan { readVar = rVar, writeVar = wVar }

writeChan :: Chan a -> a -> IO ()
writeChan c x = do
  newHole <- newEmptyMVar
  oldHole <- takeMVar (writeVar c)
  putMVar oldHole $ Item x newHole
  putMVar (writeVar c) newHole

readChan :: Chan a -> IO a
readChan c = do
  rVar <- takeMVar (readVar c)
--  Item x next <- takeMVar rVar   -- does not work with dupChan
  Item x next <- readMVar rVar
  putMVar (readVar c) next
  return x

-- multicast: one writer, several readers
dupChan :: Chan a -> IO (Chan a)
dupChan c = do
  hole <- readMVar (writeVar c)
  newRVar <- newMVar hole
  return $ Chan { readVar = newRVar, writeVar = writeVar c}

-- read some mvar, but don't consume it
readMVar :: MVar a -> IO a
readMVar m = do
  x <- takeMVar m
  putMVar m x
  return x
