module Demo11_Logger(initLogger, logMessage, logStop) where

import Control.Concurrent(forkIO, threadDelay, MVar, takeMVar, putMVar, newEmptyMVar)
import Demo11_Chan

initLogger :: IO Logger
logMessage :: Logger -> String -> IO ()
logStop :: Logger -> IO ()


-- only change to version in Demo 10: use Chan LogCommand 
-- instead of MVar LogCommand for logger


newtype Logger = Logger (Chan LogCommand)
data LogCommand = Message String | Stop (MVar ())


initLogger = do 
  c <- newChan
  let l = Logger c
  forkIO (logger l)
  return l

logger :: Logger -> IO ()
logger (Logger c) = do
  putStrLn $ "logger initialized, but sleeping for 2 seconds"
  threadDelay $ 2 * 10^(6 :: Int)  
  putStrLn $ "logger starting to work"
  loop where
  loop = do 
    cmd <- readChan c
    case cmd of 
      Message msg -> do
        putStrLn $ "logger: " ++ msg
        loop
      Stop s -> do 
        putStrLn "logger: stop"
        putMVar s ()
      
logMessage (Logger c) s = writeChan c (Message s)
logStop (Logger c) = do
  s <- newEmptyMVar 
  writeChan c (Stop s)
  takeMVar s

