module Main where

import Data.List(delete)
import System.Environment (getArgs)
import System.IO
import Control.Concurrent
import Control.Exception
import Control.Concurrent.Async
import System.Process
import System.Timeout

import LPO(lpoSolver, reverseLpoSolver, TerminationProof)
import Parser_ARI
import TRS


{-
  Task 1 (2 points): Reason for a bracket-version of async  
-}


{-
  Task 2 (4 points): firstJust
-}

firstJust :: [IO (Maybe a)] -> IO (Maybe a)
firstJust = undefined
    

{- 
  Task 3 (2 points): Killing External Computations 
-}

workerExternal :: Integer -> IO (Maybe Integer)
workerExternal n = do
  -- adjust "fibExtern" to your executable!!!
  let cpConfig = (proc "fibExtern" []){ std_out = CreatePipe, std_in  = CreatePipe }
  (Just hIn, Just hOut, _, pHandle) <- createProcess cpConfig
  pid <- getPid pHandle
  let p = "    (" ++ show pid ++ ") "
  putStrLn $ p ++ "Trying fib " ++ show n
  hPutStrLn hIn (show n)
  hClose hIn
  answer <- hGetLine hOut
  if (read answer == magicNumber) 
    then putStrLn (p ++ show n ++ " success") >> return (Just n) 
    else putStrLn (p ++ show n ++ " fail") >> return Nothing


{- 
  Task 4 (2 points): Putting everything together: Strategies for Termination Proving
-}

terminationProver :: Int -> TRS -> IO (Maybe TerminationProof)
terminationProver seconds trs = undefined
            
            
            
            
            
{- Auxiliary functions that do not have to be changed -}

workerInHaskell :: Integer -> IO (Maybe Integer)
workerInHaskell n = onException (do
  tid <- myThreadId
  let t = "    (" ++ show tid ++ ") "
  putStrLn $ t ++ "Trying fib " ++ show n
  if n < 0 then error "fib on negative number is not allowed" else return ()
  if fib n == magicNumber
    then putStrLn (t ++ show n ++ " success") >> return (Just n) 
    else putStrLn (t ++ show n ++ " fail") >> return Nothing)
  (myThreadId >>= putStrLn . (\s -> "    (" ++ s ++ ") got exception") . show)

fib :: Integer -> Integer
fib 0 = 0
fib 1 = 1
fib n = fib (n - 1) + fib (n - 2)

magicNumber :: Integer
magicNumber = 267914296

mainTask2and3 worker = do 
  tid <- forkIO $ do 
     res <- catch (firstJust 
         [worker (-7), worker 40, worker 45, worker 42, worker 17])
         (\ (_ :: SomeException) -> return Nothing)
     putStrLn $ "result of firstJust: " ++ show res
  threadDelay $ 500000 -- wait half a second before printing this message
  putStrLn "press enter to kill firstJust, or to proceed after result is printed"
  getLine
  killThread tid -- kill firstJust-thread
  threadDelay $ 10000 -- wait a bit
  putStrLn "all computations should have been stopped now"
  putStrLn "press enter to quit"
  getLine
  return ()
            
searchTerminationAriFile sec path = do
  cnt <- readFile path
  putStr path >> putStrLn " ... searching for proof ... " >> hFlush stdout
  result <- terminationProver sec . parseAri $ cnt
  putStrLn $ show result
  return result

mainLPO :: Int -> FilePath -> IO ()
mainLPO seconds file = do
  aris <- lines <$> readFile file
  results <- mapM (searchTerminationAriFile seconds) aris
  putStrLn $ show (length $ filter (/= Nothing) results) ++ " termination proofs found"

main = do
  numCores <- getNumCapabilities
  putStrLn $ "number of cores: " ++ show numCores
  args <- getArgs
  putStrLn $ "args: " ++ show args
  case args of
     ["haskell"] -> mainTask2and3 workerInHaskell
     ["extern"] -> mainTask2and3 workerExternal
     ["lpo", seconds, file] -> mainLPO (read seconds) file
     _ -> error $ "invoke with argument \"haskell\" or \"extern\" or " ++ 
           "\"lpo <timeout in seconds> <file>\""
    
