-- solution to week 9, input to week 11
module Exercise11_SMT(
  runSmtEncoder,
  runSmtSolver,
  smtBIAnswerFromHandle,
  smtAnswerFromHandle) where

import SMT
import SMT_Answer_Parser
import Abstract_SMT_Encoder
import System.IO
import System.Process
import qualified Data.Map as M

smtAnswerFromHandle :: Handle -> IO [(String, Integer)]
smtAnswerFromHandle h = do
  inp <- hGetContents h
  case parseAnswer inp of
     Left e -> error $ "problem parsing SMT-answer: " ++ e
     Right res -> return res

smtBIAnswerFromHandle :: Handle -> IO [(String, Either Bool Integer)]
smtBIAnswerFromHandle h = do
  inp <- hGetContents h
  case parseBIAnswer inp of
     Left e -> error $ "problem parsing SMT-answer: " ++ e
     Right res -> return res



runSmtSolver :: SmtEncoder a -> (a -> [SmtVar]) -> 
   IO (a, Maybe [(SmtVar, Either Bool Integer)])
runSmtSolver app vars = do 
  let (a, smtString) = runSmtEncoder app
  let relevantVars = vars a
  let cpConfig = (proc "z3" ["-in"]){ std_out = CreatePipe, std_in  = CreatePipe }
  (Just hSmtIn, Just hSmtOut, _, pHandle) <- createProcess cpConfig     
  hPutStrLn hSmtIn smtString >> hFlush hSmtIn
  satStatus <- hGetLine hSmtOut
  answer <- if satStatus /= "sat" then return Nothing else 
    if null relevantVars then return $ Just [] 
    else do hPutStrLn hSmtIn $ smtRequestValues relevantVars
            hFlush hSmtIn
            parsedValues <- M.fromList <$> smtBIAnswerFromHandle hSmtOut
            let values = [(x, parsedValues M.! show x) | x <- relevantVars]
            return $ Just $ values
  hPutStrLn hSmtIn "(exit)"
  hClose hSmtOut
  hClose hSmtIn
  terminateProcess pHandle
  return $ (a, answer)
