module GetURL (getURL) where

import Network.HTTP.Conduit
import Data.ByteString (ByteString)
import Network.HTTP.Types.Header(hUserAgent)
import qualified Data.ByteString.Lazy as L
import qualified Data.ByteString.Char8 as B

getURL :: String -> IO ByteString
getURL url = do 
  manager <- newManager tlsManagerSettings
  req' <- parseRequest $ "GET " ++ url
  let req = req' { requestHeaders = requestHeaders req' ++ [(hUserAgent, B.pack "demoAdvFp/2025 (just show network access in Haskell via HTTP-Conduit library)")]}
  resp <- httpLbs req manager
  return $ L.toStrict $ responseBody resp
