module LPO(reverseLpoSolver, lpoSolver, TerminationProof) where

import qualified Data.Map as M
import Data.Bifunctor

import TRS
import LPO_Encoder
import Exercise11_SMT


data TerminationProof = 
   LPO_Left_Right [(Id,Integer)] 
 | LPO_Right_Left [(Id,Integer)] 
     deriving (Show,Eq)

lpoSolver :: TRS -> IO (Maybe TerminationProof)
lpoSolver trs = do 
  (prec, solution) <- runSmtSolver (runTrsEncoder trs) (map snd)
  return $ convert prec <$> solution 
 where convert precMap model = let 
         intValues = M.fromList [ (f, p) | (f, Right p) <- model]
        in LPO_Left_Right $ map ( \ (f, xi) -> (f, intValues M.! xi)) $ precMap

reverseTerm :: Term -> Term
reverseTerm (Var x) = Var x
reverseTerm (Fun f ts) = Fun f $ reverse $ map reverseTerm ts

reverseRule :: Rule -> Rule
reverseRule = bimap reverseTerm reverseTerm

reverseTrs :: TRS -> TRS
reverseTrs = fmap (map reverseRule)

reverseLPO :: TerminationProof -> TerminationProof
reverseLPO (LPO_Left_Right prec) = LPO_Right_Left prec
reverseLPO (LPO_Right_Left prec) = LPO_Left_Right prec

reverseLpoSolver :: TRS -> IO (Maybe TerminationProof)
reverseLpoSolver trs = fmap reverseLPO <$> lpoSolver (reverseTrs trs)
