-- solution to exercise sheet 9
module SMT_Answer_Parser(
  parseAnswer,
  parseBIAnswer) where

import Data.Bifunctor(first)
import Data.Char(isAlphaNum)
import Text.ParserCombinators.Parsec
  
smtAnswerParser :: Parser [(String, Integer)]
smtAnswerParser = (\ xs -> [(x,v) | (x, Right v) <- xs]) <$> smtBIAnswerParser

smtBIAnswerParser :: Parser [(String, Either Bool Integer)]
smtBIAnswerParser = spaces *> string "(" *> spaces *> many pair <* string ")" 
  where
    charS c = char c <* spaces
    pair = (,) <$> (charS '(' *> identifier) <*> elem <* charS ')'
    nat = (read :: String -> Integer) <$> many1 digit <* spaces
    negNat = negate <$> (charS '(' *> charS '-' *> nat <* charS ')')
    num = nat <|> negNat
    bool = ((False <$ string "false") <|> (True <$ string "true")) <* spaces
    elem = (Left <$> bool) <|> (Right <$> num)
    identChar = satisfy isAlphaNum
    identifier = many1 identChar <* spaces

parseAnswer :: String -> Either String [(String, Integer)]
parseAnswer inp = first show $ parse smtAnswerParser "" inp

parseBIAnswer :: String -> Either String [(String, Either Bool Integer)]
parseBIAnswer inp = first show $ parse smtBIAnswerParser "" inp
  
