module Abstract_SMT_Encoder(
  SmtEncoder, 
  runSmtEncoder,
  getNewSmtVariable,
  assertFormula) where

import Data.Bifunctor(bimap)
import Control.Monad.Writer
import Control.Monad.State
import Data.Monoid
import SMT


newtype SmtState = SmtState {
    nextFreshVar :: Int
  }

-- hide monad transformer stack in newtype, using GeneralizedNewtypeDeriving
newtype SmtEncoder a = SmtEncoder (StateT SmtState (Writer (Endo [SmtStmt])) a)
  deriving (Functor, Applicative, Monad, 
     MonadState SmtState, MonadWriter (Endo [SmtStmt]))


tellStmt :: MonadWriter (Endo [SmtStmt]) m => SmtStmt -> m ()
tellStmt x = tell $ Endo (x :)

assertFormula :: Formula -> SmtEncoder ()
assertFormula phi = tellStmt (SmtAssert phi)

runSmtEncoder :: SmtEncoder a -> (a, String)
runSmtEncoder (SmtEncoder app) = bimap fst (showSmt2 . flip appEndo [])
  $ runWriter 
  $ flip runStateT (SmtState 1)
  $ app

getNewSmtVariable :: SmtType -> SmtEncoder SmtVar
getNewSmtVariable ty = do
  s <- get
  let x = nextFreshVar s
  put $ s {nextFreshVar = x + 1}
  tellStmt $ SmtVarDecl ty (SmtVar x)
  return $ SmtVar x

