module Main(main) where

import Exercise12_LPO_Encoder
import Parser_ARI
import System.Environment (getArgs)


main = do
  args <- getArgs
  putStrLn $ "args: " ++ show args
  case args of
     ["queue", n] -> testQueue $ read n
     ["lpo", file] -> mainLPO file
     _ -> error $ "invoke with argument \"queue <n>\" or " ++ 
           "\"lpo <file>\""


{- 
Task 1.1
-}

testQueue :: Int -> IO ()
testQueue n = undefined


data Queue1 a = Queue1 [a] [a]

empty1 :: Queue1 a
empty1 = Queue1 [] []

insert1 :: a -> Queue1 a -> Queue1 a
insert1 x (Queue1 b e) = Queue1 b (x : e)

remove1 :: Queue1 a -> (a, Queue1 a)
remove1 (Queue1 (x : b) e) = (x, Queue1 b e)
remove1 (Queue1 [] []) = error "empty queue"
remove1 (Queue1 [] e) = remove1 (Queue1 (reverse e) [])


{- 
Task 1.2 

  foldl (flip insert2) empty2 [1..n] by evaluation;
= ...
= ...


=> complexity of remove2-step in expression

  remove2 (foldl (flip insert2) empty2 [1..n])

  is  ...

-}
 

{- 
Task 2 

Improve the efficiency of the SMT-encoding of LPO;
you may change mainLPO, the imports in this file,
and everything in file Exercise12_LPO_Encoder,
but no other Haskell-files may be touched.
-}

mainLPO file = do
  aris <- lines <$> readFile file
  mapM_ showSMTEncoding aris
 where
  showSMTEncoding path = do
    cnt <- readFile path
    putStr path >> putStrLn " ... generating LPO encoding ... "
    let trs = parseAri cnt
    let smtEncoding = lpoTrsEncoder trs
    putStrLn $ smtEncoding
