module Parser_ARI(parseAri) where

import Text.ParserCombinators.Parsec
import TRS

-- space' and spaces' support ARI line-comments everywhere
space' = () <$ (space <|> (char ';' <* manyTill anyChar (char '\n')))
spaces' = many space'

-- relaxed: (format TRS) is optional
content :: GenParser Char u TRS
content = do
  _ <- spaces' <* optional format
  signature <- many fun
  (,) signature <$> many (rule signature) <* eof

num :: GenParser Char u Int
num = read <$> lexeme (many1 digit)

format = try (charS '(' *> exactlyS "format") *> exactlyS "TRS" *> charS ')'

fun :: GenParser Char u (Id,Int)
fun = try (charS '(' *> exactlyS "fun" ) *> ((,) <$> identifier <*> num) <* charS ')'

lexeme p = p <* spaces' 
charS c = () <$ lexeme (char c)
exactlyS s = lexeme $ try (string s *> (notFollowedBy identChar <?> "end of tag " ++ s))

identChar = noneOf " \t\n();:"
identifier = lexeme $ many1 identChar

-- simplified: arities are not checked and function application does not check signature
term sig =  (\ v -> if v `elem` map fst sig then Fun v [] else Var v) <$> identifier 
    <|> Fun <$> (charS '(' *> identifier) <*> many1 (term sig) <* charS ')'

rule s = (,) <$> (try (charS '(' *> exactlyS "rule") *> term s) <*> term s <* charS ')'

parseAri :: String -> TRS
parseAri inp = case parse content "" inp of
  Left e -> error $ "parse error: " ++ show e
  Right r -> r
