{-# LANGUAGE GADTs #-}

module Tests_01(runTests, boolTests) where

import Template_01(volumeCube, volumeSphere, heliumCost, cubeSidelength)
import Test.LeanCheck

-- Generic Setup 
data Test = forall a. Testable a => Test String String a

runTests = flip mapM_ tests
  (\ (Test ex name t) -> putStrLn ("running " ++ ex ++ "(" ++ name ++ ")" ++ "-tests") >> checkFor 1000 t)

-- Tests for this week 


data CT = CT Integer Integer

instance Show CT where
  show (CT x y) = "side = " ++ show x ++ ", volume = " ++ show y

instance Listable CT where
  tiers = [[CT 0 0, CT 1 1, CT 2 8, CT 3 27, CT 4 64, CT 5 125, CT 6 216, CT 7 343, CT 8 512, CT 9 729, CT 10 1000]]

cubeTest :: CT -> Bool
cubeTest (CT s v) = volumeCube s == v

data ST = ST Double Double

instance Show ST where
  show (ST r v) = "radius = " ++ show r ++ ", volume = " ++ show v

instance Listable ST where
  tiers = [[ ST 0 0
           , ST 1 4.1887902047863905
           , ST 2 33.510321638291124
           , ST 3 113.09733552923255
           , ST 4 268.082573106329
           , ST 5 523.5987755982989
           , ST 6 904.7786842338603
           , ST 7 1436.7550402417319
           , ST 8 2144.660584850632
           , ST 9 3053.6280592892786
           , ST 10 4188.790204786391
           ]]


sphereTest :: ST -> Bool
sphereTest (ST r v) = abs (volumeSphere r - v) < 0.00001


data HT = HT Double Double

instance Show HT where
  show (HT x a) = "length = " ++ show x ++ ", amount = " ++ show a

instance Listable HT where
  tiers = [[ HT 0 0
           , HT 1 0.6083856515112043
           , HT 2 4.867085212089634
           , HT 3 16.426412590802514
           , HT 4 38.93668169671707
           , HT 5 76.04820643890054
           , HT 6 131.4113007264201
           , HT 7 208.67627846834304
           , HT 8 311.4934535737366
           , HT 9 443.5131399516679
           , HT 10 608.3856515112043
           ]]


heliumTest :: HT -> Bool
heliumTest (HT x a) = abs (heliumCost x - a) < 0.00001

data SLT = SLT Double Double

instance Show SLT where
  show (SLT a s) = "amount = " ++ show a ++ ", sidelength = " ++ show s

instance Listable SLT where
  tiers = [[ SLT 0 0
           , SLT 1 2.0431286613968336
           , SLT 2 2.574180808137405
           , SLT 3 2.946701433982334
           , SLT 4 3.243264586407713
           , SLT 5 3.4937008669543435
           , SLT 6 3.71261116442975
           , SLT 7 3.908364526802013
           , SLT 8 4.086257322793667
           , SLT 9 4.249878876985244
           , SLT 10 4.401787264311744
           ]]


sidelengthTest :: SLT -> Bool
sidelengthTest (SLT a s) = abs (cubeSidelength a - s) < 0.00001

tests :: [Test]
tests = [
  Test "1" "volumeCube s = v" cubeTest,
  Test "2" "volumeSphere r = v" sphereTest,
  Test "3" "heliumCost x = a" heliumTest,
  Test "4" "cubeSidelength a = s" sidelengthTest
  ]

boolTests :: [((String,String), Bool)]
boolTests = map (\ (Test ex descr t) -> ((ex, descr), holds 1000 t)) tests
