{-# LANGUAGE GADTs #-}

module Tests_03 (runTests, boolTests) where

import Data.List (sort)
import Template_03
import Test.LeanCheck

-- Generic Setup
data Test = forall a. (Testable a) => Test String String a

runTests =
  flip
    mapM_
    tests
    (\(Test ex name t) -> putStrLn ("running " ++ ex ++ "(" ++ name ++ ")" ++ "-tests") >> checkFor 1000 t)

-- Tests for this week

-- only take a few sample numbers, more important is to increase in length of list
sampleIntegers :: [[Integer]]
sampleIntegers = [[4490], [-3901], [-17], [0], [22]]

instance Listable List where
  tiers = cons0 Empty \/ (delay $ mapT (uncurry Cons) (sampleIntegers >< tiers))

toList Empty = []
toList (Cons x xs) = x : toList xs

testGen f1 f2 f3 g1 g2 g3 x = (f3 . f2 . f1) x == (g3 . g2 . g1) x

-- only take a few sample numbers, more important is to increase in size of expr
instance Listable Expr where
  tiers = (delay $ mapT Number sampleIntegers) \/ cons1 Negate \/ cons2 Plus

maxListTest :: List -> Bool
-- Not sure how else to handle this, I don't really know LeanCheck
maxListTest Empty = True
maxListTest l = maximum (toList l) == maxList l

addedValue :: Integer
addedValue = 8

addSecondCompare :: List -> [Integer] -> Bool
addSecondCompare Empty [] = True
addSecondCompare (Cons _ Empty) (_ : []) = True
addSecondCompare (Cons x1 (Cons x2 xs)) (y1 : y2 : ys) = x1 == y1 && x2 == y2 + addedValue && addSecondCompare xs ys
addSecondCompare _ _ = False

addSecondTest :: List -> Bool
addSecondTest l = addSecondCompare (addSecond addedValue l) (toList l)

convertTestEval :: Expr -> Bool
convertTestEval e = eval (convert e) == eval e

noNegIntegers :: Expr -> Bool
noNegIntegers (Number x) = x >= 0
noNegIntegers (Negate e) = noNegIntegers e
noNegIntegers (Plus e1 e2) = noNegIntegers e1 && noNegIntegers e2

convertTestNoNegNumbers :: Expr -> Bool
convertTestNoNegNumbers e = noNegIntegers (convert e)

normalizeTestEval :: Expr -> Bool
normalizeTestEval e = eval (normalize e) == eval e

normalizeTestNoNegNumbers :: Expr -> Bool
normalizeTestNoNegNumbers e = noNegIntegers (normalize e)

negateOnlyAboveLeafNodes :: Expr -> Bool
negateOnlyAboveLeafNodes (Negate (Number x)) = True
negateOnlyAboveLeafNodes (Number x) = True
negateOnlyAboveLeafNodes (Plus e1 e2) = negateOnlyAboveLeafNodes e1 && negateOnlyAboveLeafNodes e2
negateOnlyAboveLeafNodes (Negate _) = False

normalizeTestNegateOnlyAboveLeafNodes :: Expr -> Bool
normalizeTestNegateOnlyAboveLeafNodes e = negateOnlyAboveLeafNodes (normalize e)

listToExprTestEval :: List -> Bool
listToExprTestEval xs = eval (listToExpr xs) == sum (toList xs)

extractNumbers :: Expr -> [Integer]
extractNumbers (Negate (Number x)) = [-x]
extractNumbers (Number x) = [x]
extractNumbers (Plus e1 e2) = extractNumbers e1 ++ extractNumbers e2

listToExprTestExprContainsListNumbers :: List -> Bool
listToExprTestExprContainsListNumbers Empty = extractNumbers (listToExpr Empty) == [0]
listToExprTestExprContainsListNumbers xs = sort (extractNumbers (listToExpr xs)) == sort (toList xs)

listToExprTestNoNegNumbers :: List -> Bool
listToExprTestNoNegNumbers xs = noNegIntegers (listToExpr xs)

tests :: [Test]
tests =
  [ Test "2.2" "maxList" maxListTest,
    Test "2.3" "addSecond" addSecondTest,
    Test "3.1" "convertEval" convertTestEval,
    Test "3.1" "convertNoNegNumbers" convertTestNoNegNumbers,
    Test "3.2" "normalizeEval" normalizeTestEval,
    Test "3.2" "normalizeNoNegNumbers" normalizeTestNoNegNumbers,
    Test "3.2" "normalizeNegateOnlyAboveLeafNodes" normalizeTestNegateOnlyAboveLeafNodes,
    Test "3.3" "listToExprEval" listToExprTestEval,
    Test "3.3" "listToExprExprContainsListNumbers" listToExprTestExprContainsListNumbers,
    Test "3.3" "listToExprNoNegNumbers" listToExprTestNoNegNumbers
  ]

boolTests :: [((String, String), Bool)]
boolTests = map (\(Test ex descr t) -> ((ex, descr), holds 1000 t)) tests
