{-# LANGUAGE GADTs #-}
{-# LANGUAGE GeneralizedNewtypeDeriving #-}

module Tests_05 (runTests, boolTests) where

import Data.List (sort, isPrefixOf)
import Template_05
import Test.LeanCheck

-- Generic Setup
data Test = forall a. (Testable a) => Test String String a

runTests =
  flip
    mapM_
    tests
    (\(Test ex name t) -> putStrLn ("running " ++ ex ++ "(" ++ name ++ ")" ++ "-tests") >> checkFor 1000 t)

------------------------------------------------------------
-- Tests für Template_05
------------------------------------------------------------

-- Aufgabe 1

data BinomialTest = BinomialTest (Integer, Integer) (Maybe Integer)

instance Show BinomialTest where
  show (BinomialTest x y) = "x = " ++ show x ++ ", y = " ++ show y

instance Listable BinomialTest where
  tiers = [[BinomialTest (5, 5) (Just 1), BinomialTest (4, 2) (Just 6), BinomialTest (-12, -15) Nothing, BinomialTest (-4, -1) Nothing, BinomialTest (-11, 3) Nothing, BinomialTest (0, -123) Nothing, BinomialTest (0, 0) (Just 1), BinomialTest (32, 3) (Just 4960), BinomialTest (4, 9) (Just 0), BinomialTest (40, 60) (Just 0), BinomialTest (50, 23) Nothing, BinomialTest (49, 23) (Just 58343356817424)]]

binomialTest :: BinomialTest -> Bool
binomialTest (BinomialTest (n, k) y) = binomial n k == y

partitionTest :: Integer -> [Integer] -> Bool
partitionTest x ys =
  let (zs1, zs2) = partition x ys
   in sort ys == sort zs1 ++ sort zs2 && all (<= x) zs1 && all (> x) zs2

quicksortTest :: [Integer] -> Bool
quicksortTest xs = quicksort xs == sort xs

-- Aufgabe 2
data SqrtTest = ST Int

instance Show SqrtTest where
  show (ST x) = "n = " ++ (show x)

instance Listable SqrtTest where
  tiers = [map ST [2..20]]

sqrtRangeTest :: SqrtTest -> Bool
sqrtRangeTest (ST n) = let sq = approxSqrt2 n in sq >= 1.4 && sq <= 1.5

sqrtPrecisionTest :: SqrtTest -> Bool
sqrtPrecisionTest (ST n) = let sq = sqrt 2 in abs (sq - (approxSqrt2 n)) <= abs (sq - (approxSqrt2 (n - 1 )))

-- Aufgabe 3
data RangeTest = RT Int Int 

instance Show RangeTest where 
  show (RT l u) = "l = " ++ show l ++ ", u = " ++ show u

instance Listable RangeTest where
  tiers = [concat $ map (\l -> map (\u -> RT l u) [l..100]) [1..100]]

rangeLengthTest :: RangeTest -> Bool 
rangeLengthTest (RT l u) = (length $ ranges l u) == u - l + 1

rangePrefTest :: RangeTest -> Bool
rangePrefTest (RT l u) = all (flip isPrefixOf [l..u]) $ ranges l u

rangeUniquenessTest :: RangeTest -> Bool 
rangeUniquenessTest (RT l u) = allDifferent $ ranges l u where
  allDifferent [] = True
  allDifferent (x:xs) = notElem x xs && allDifferent xs

data ABTest = ABT Int String Char

instance Show ABTest where
  show (ABT n s c) = "n = " ++ show n ++ ", s = " ++ show s

instance Listable ABTest where
  tiers = [[ABT 2 "GGCCABBA" 'B', ABT 3 "BB" 'C', ABT 7 "tomato" 'C', ABT 10 [] 'C', ABT 1 "A" 'A', ABT 5 "ABABBABABABABAAAAAA"'B', ABT 3 "BAABCCA" 'A']]

thresholdABTest :: ABTest -> Bool
thresholdABTest (ABT n s c) = thresholdAB n s == c
------------------------------------------------------------
-- Testsammlung
------------------------------------------------------------

tests :: [Test]
tests =
  [ Test "1.1" "binomial" binomialTest,
    Test "1.2" "partition" partitionTest,
    Test "1.3" "quicksort" quicksortTest,
    Test "2.1" "1.4 <= Approximated sqrt <= 1.5" sqrtRangeTest,
    Test "2.2" "increasing n increases precision" sqrtPrecisionTest,
    Test "3.1.1" "Number of ranges" rangeLengthTest,
    Test "3.1.2" "No illegal ranges" rangePrefTest,
    Test "3.1.3" "No duplicate ranges" rangeUniquenessTest,
    Test "3.2" "thresholdAB" thresholdABTest
  ]

boolTests :: [((String, String), Bool)]
boolTests = map (\(Test ex descr t) -> ((ex, descr), holds 1000 t)) tests
