{-# LANGUAGE GADTs #-}
{-# LANGUAGE GeneralizedNewtypeDeriving #-}

module Tests_07 (runTests, boolTests) where

import Data.List (sort)
import Template_07
import Test.LeanCheck

-- Generic Setup
data Test = forall a. (Testable a) => Test String String a

runTests =
  flip
    mapM_
    tests
    (\(Test ex name t) -> putStrLn ("running " ++ ex ++ "(" ++ name ++ ")" ++ "-tests") >> checkFor 1000 t)

------------------------------------------------------------
-- Tests für Template_07
------------------------------------------------------------

-- Aufgabe 2
testEmpty :: Int -> Bool
testEmpty = (== 0) . flip count empty

testAdd :: [Int] -> Bool
testAdd xs = all (\x -> countList x xs == count x (addAll xs empty)) xs

testRemove :: Int -> [Int] -> Bool
testRemove x xs =
  let m = addAll xs empty
      m' = remove x m
      n = countList x xs
      wasRemoved = count x m' == max 0 (n - 1)
      othersKept = all (\y -> x == y || count y m == count y m') xs
   in wasRemoved && othersKept

testUnion :: [Int] -> [Int] -> Bool
testUnion xs ys =
  let addUnion = union (addAll xs empty) $ addAll ys empty
   in all (\x -> countList x (xs ++ ys) == count x addUnion) $ xs ++ ys

testIntersection :: [Int] -> [Int] -> Bool
testIntersection xs ys =
  let listIntersect = listInter xs ys
      setIntersect = intersection (addAll xs empty) (addAll ys empty)
   in all (\x -> countList x listIntersect == count x setIntersect) $ xs ++ ys

listInter :: [Int] -> [Int] -> [Int]
listInter xs ys =
  let go [] _ = []
      go _ [] = []
      go (a : as) (b : bs) = case compare a b of
        LT -> go as (b : bs)
        EQ -> a : go as bs
        GT -> go (a : as) bs
   in go (sort xs) (sort ys)

data InvFun = InvFun String (Int -> [Int]) (Int -> Int)

instance Show InvFun where
  show (InvFun name _ _) = name

instance Listable InvFun where
  tiers = [[InvFun "Add one" (\x -> [x - 1]) (+ 1), InvFun "Max" (\x -> if x <= 4 then [0 .. 4] else [x]) (max 4), InvFun "Div 2" (\x -> [2 * x, 2 * x + 1]) (`div` 2)]]

testImage :: InvFun -> [Int] -> Bool
testImage (InvFun _ f g) xs =
  let absXs = map abs xs
      ys = map g absXs
      setImage = image f $ addAll absXs empty
   in all (\y -> countList y ys == count y setImage) ys

addAll :: [Int] -> Multiset Int -> Multiset Int
addAll xs m = foldr add empty xs

countList :: (Eq a) => a -> [a] -> Int
countList x = length . filter (== x)

-- Aufgabe 3
data LargestSectionTest = LST Library String

instance Show Section where 
  show (Section name xs) = "Section " ++ name ++ " containting: " ++ (show xs)

instance Show Item where
  show (Item name medium) = name ++ " (" ++ (show medium) ++ ")"

instance Show Medium where
  show x = case x of 
    Book -> "book"
    BookChapter -> "book chapter"
    Article -> "article"
    DVD -> "DVD"

instance Show LargestSectionTest where
  show (LST ss s) = show $ map show ss

instance Listable LargestSectionTest where 
  tiers = [[
      LST [Section "Fiction" [
        Item "Twilight" Book, 
        Item "Krieg und Frieden" Book,
        Item "Oppenheimer" DVD
      ], Section "History" [
          Item "1950" Article,
          Item "1960" Article,
          Item "1970" Article,
          Item "1980" Article
      ], Section "Empty" []] "History", 
      LST [Section "Fiction" [
        Item "Twilight" Book, 
        Item "Krieg und Frieden" Book,
        Item "Oppenheimer" DVD
      ], Section "LessHistory" [
          Item "1950" Article,
          Item "1960" Article
      ], Section "Empty" []] "Fiction", 
      LST [Section "Empty" []] "Empty"
    ]]

largestSectionTest :: LargestSectionTest -> Bool
largestSectionTest (LST l s) = largestSection l == s


data SearchItemTest = SIT Section String [Item]

instance Show SearchItemTest where
  show (SIT s str _) = "Searching " ++ (show s) ++ " for term " ++ str

instance Listable SearchItemTest where 
  tiers = let
      prpr = Item "Pride and Prejudice" Book
      susu = Item "Soup and Superficiality" DVD
      sese = Item "Sense and Sensibility" Book
      s1 = Section "Fiction" [prpr, susu, sese]
      s2 = Section "Empty" []
    in [[
      SIT s1 "UP" [susu], 
      SIT s2 "UP" [], 
      SIT s1 "and" [prpr, susu, sese],
      SIT s1 "a n d" []    
    ]]

searchItemTest :: SearchItemTest -> Bool
searchItemTest (SIT sec str res) = searchItem sec str == res


data SingleTypeTest = STT Section Bool 

instance Show SingleTypeTest where
  show (STT s b) = show s

instance Listable SingleTypeTest where
  tiers = let 
      b = Item "some book" Book
      bc = Item "chapter of some book" BookChapter
      a = Item "some article" Article
      ss = Section "Some section"
    in [[
      STT (ss [b, b, b, bc, b]) False,
      STT (ss []) True,
      STT (ss [a, a, a, a]) True,
      STT (ss [bc, bc, bc]) True,
      STT (ss [a, bc, bc, bc]) False,
      STT (ss [b, b, b, b, b, b, b, bc]) False
    ]]

singleTypeTest :: SingleTypeTest -> Bool
singleTypeTest (STT s res) = singleType s == res


data FilterByMediumTest = FBMT Library [Medium] Library

instance Show FilterByMediumTest where 
  show (FBMT l m _) = "Filtering " ++ (show l) ++ "for items with mediums " ++ (show m)

instance Listable FilterByMediumTest where
  tiers = let 
      b1 = Item "some book" Book
      b2 = Item "some other book" Book
      a1 = Item "some article" Article
      a2 = Item "some other article" Article
      d1 = Item "some DVD" DVD
      d2 = Item "some other DVD" DVD
      s1 = Section "some section" 
      s2 = Section "some other section"
      s3 = Section "yet another section"
    in [[
      FBMT [s1 [b1, a1, d1, d2], s2 [a2], s3 [b2]] [Book, DVD] [s1 [b1, d1, d2], s3 [b2]],
      FBMT [s1 [b1, b2], s2 [b1, a1, b2]] [Article] [s2 [a1]],
      FBMT [s1 [b1, b2, a1, a2, d1]] [] [],
      FBMT [s1 [b1, b2, a1, a2, d1]] [Book, Article, DVD] [s1 [b1, b2, a1, a2, d1]],
      FBMT [s1 [a1, d1], s2 [b1, b2, d2], s3 [d2, b1]] [Article, Book] [s1 [a1], s2 [b1, b2], s3 [b1]]
    ]]

filterByMediumTest :: FilterByMediumTest -> Bool
filterByMediumTest (FBMT l ms res) = filterByMedium l ms == res
------------------------------------------------------------
-- Testsammlung
------------------------------------------------------------

tests :: [Test]
tests =
  [ Test "2.1" "empty" testEmpty,
    Test "2.1" "add" testAdd,
    Test "2.1" "remove" testRemove,
    Test "2.2" "union" testUnion,
    Test "2.2" "intersection" testIntersection,
    Test "2.3" "image" testImage,
    Test "3.1" "largest section" largestSectionTest,
    Test "3.2" "search item" searchItemTest,
    Test "3.3" "single medium type" singleTypeTest,
    Test "3.4" "filter by medium" filterByMediumTest
  ]

boolTests :: [((String, String), Bool)]
boolTests = map (\(Test ex descr t) -> ((ex, descr), holds 1000 t)) tests
