{-# LANGUAGE GADTs #-}
{-# LANGUAGE GeneralizedNewtypeDeriving #-}
{-# LANGUAGE ScopedTypeVariables #-}

module Tests_08 (runTests, boolTests) where

import Data.Foldable (toList)
import Data.List ((\\), sort)
import Data.Char (ord, chr)
import Template_08
import Test.LeanCheck

-- Generic Setup
data Test = forall a. (Testable a) => Test String String a

runTests =
  flip
    mapM_
    tests
    (\(Test ex name t) -> putStrLn ("running " ++ ex ++ "(" ++ name ++ ")" ++ "-tests") >> checkFor 1000 t)

------------------------------------------------------------
-- Tests für Template_08
------------------------------------------------------------

------------------------------------------------------------
-- Tests für divisors, isPerfect, perfectNumberUpTo, pairNumbers,
-- removeNonLetters, shiftRight, everyNth
------------------------------------------------------------

testDivisorsCorrect :: Int -> Bool
testDivisorsCorrect n =
  n > 1 ==>
  let ds = divisors n
      allDivisors = filter (\d -> n `mod` d == 0) [1..n-1]
  in sort ds == sort allDivisors

testPerfectUpTo :: Int -> Bool
testPerfectUpTo n =
  n >= 0 ==>
    let xs = perfectNumberUpTo n
    in all isPerfect xs && all (<= n) xs

testPairNumbers :: Int -> Bool
testPairNumbers n =
  n >= 1 ==>
    let ps = pairNumbers n
    in all (\(a,b) ->
             a < b &&
             b <= n &&
             sum (divisors a) == b &&
             sum (divisors b) == a)
           ps

testRemoveNonLetters :: String -> Bool
testRemoveNonLetters s =
  let result = removeNonLetters s
      isValid c = (c >= 'a' && c <= 'z') || (c >= 'A' && c <= 'Z') || c == ' '
      expectedChars = filter isValid s
  in result == expectedChars

testShiftRight :: Int -> String -> Bool
testShiftRight n s =
  all check (zip s (shiftRight n s))
  where
    check (orig,new)
      | orig >= 'a' && orig <= 'z' = 
          let shifted = chr (((ord orig - ord 'a' + n) `mod` 26) + ord 'a')
          in new == shifted
      | otherwise = orig == new

testEveryNth :: Int -> String -> Bool
testEveryNth n s =
  n > 0 ==>
    let r = everyNth n s
        getEveryNth [] = []
        getEveryNth xs 
          | length xs < n = []
          | otherwise = (xs !! (n-1)) : getEveryNth (drop n xs)
    in r == getEveryNth s

-- Aufgabe 2

instance Listable a => Listable (Tree a) where
  tiers = cons0 Leaf \/ cons3 (\t1 t2 t3 -> Node t1 t2 t3)

testHeight :: Tree Int -> Bool
testHeight t = height (Node t 0 t) == height t + 1

testSize :: Tree Int -> Bool
testSize t = size (Node t 0 t) == 2* size t + 1

testSumT :: Tree Int -> Bool
testSumT t = sumT (Node t 2 t) == 2 * sumT t + 2
  
testMirror :: Tree Int -> Bool
testMirror t = mirror (mirror t) == t

testMapT :: Tree Int -> Bool
testMapT t = inOrder (Template_08.mapT (+1) t) == map (+1) (inOrder t)

testFromList :: [Int] -> Bool
testFromList xs = inOrder (fromList xs) == xs

testPreOrder :: Tree Int -> Bool
testPreOrder t = null (inOrder t \\ preOrder t) && null (preOrder t \\ inOrder t)

testPostOrder :: Tree Int -> Bool
testPostOrder t = null (inOrder t \\ postOrder t) && null (postOrder t \\ inOrder t)

testFoldable :: Tree Int -> Bool
testFoldable t = inOrder t == toList t


-- Test Collection

tests :: [Test]
tests =
  [    
    Test "1.1" "test divisors" testDivisorsCorrect,
    Test "1.2" "test perfectNumberUpTo" testPerfectUpTo,
    Test "1.3" "test pairNumbers" testPairNumbers,
    Test "1.4" "test removeNonLetters" testRemoveNonLetters,
    Test "1.5" "test shiftRight" testShiftRight,
    Test "1.6" "test everyNth" testEveryNth,
    Test "2.2" "test height" testHeight,
    Test "2.2" "test size" testSize,
    Test "2.3" "mirror . mirror == id" testMirror,
    Test "2.3" "toList . mapT f == map f . toList" testMapT,
    Test "2.4" "inOrder . fromList == id" testFromList,
    Test "2.4" "elems . preOrder == elems . inOrder" testPreOrder,
    Test "2.4" "elems . postOrder == elems . inOrder" testPostOrder,
    Test "2.5" "inOrder == toList" testFoldable
  ]

boolTests :: [((String, String), Bool)]
boolTests = map (\(Test ex descr t) -> ((ex, descr), holds 1000 t)) tests
