module DList_09 where

data DList a = DList [a]
    
empty :: DList a
empty = DList []

member :: Eq a => a -> DList a -> Bool
member x (DList xs) = x `elem` xs

insert :: Eq a => a -> DList a -> DList a
insert x a@(DList xs)
  | member x a = a
  | otherwise = DList $ x : xs

remove :: Eq a => a -> DList a -> DList a
remove x a@(DList xs) = case span (/= x) xs of
  (_, []) -> a
  (first, _ : last) -> DList $ first ++ last

instance Show a => Show (DList a) where
  show = undefined

instance Eq a => Eq (DList a) where
  (==) = undefined

