{-# LANGUAGE GADTs, PartialTypeSignatures #-}

module Tests_09(runTests, boolTests) where

import qualified DList_09 as D
import Test.LeanCheck

-- Generic Setup 
data Test = forall a. Testable a => Test String String a

runTests = flip mapM_ tests
  (\ (Test ex name t) -> putStrLn ("running " ++ ex ++ "(" ++ name ++ ")" ++ "-tests") >> checkFor 1000 t)


-- TODO: Extend tests for DList

listToDList :: Eq a => [a] -> D.DList a
listToDList = foldr D.insert D.empty

testEquivD :: [Int] -> Bool
testEquivD xs = listToDList (xs ++ xs) == listToDList (reverse xs)

testInsertRemoveD :: Int -> [Int] -> Bool
testInsertRemoveD x xs = undefined


-- TODO: Write tests for OList

tests :: [Test]
tests = [
  Test "2.5" "equivTestD" testEquivD,
  Test "2.5" "testInsertRemoveD" testInsertRemoveD
  ]

boolTests :: [((String,String), Bool)]
boolTests = map (\ (Test ex n t) -> ((ex,n), holds 1000 t)) tests

