module Better_Queue(Queue, empty, isEmpty, dequeue, enqueue) 
  where

type Queue a = ([a], [a])

empty :: Queue a
empty = ([], [])

isEmpty :: Queue a -> Bool
isEmpty (front, _) = null front

enqueue :: a -> Queue a -> Queue a
enqueue x (front, rear) = maybe_mtf (front, x : rear)

dequeue :: Queue a -> (a, Queue a)
dequeue ([], _) = error "dequeue on empty queue"
dequeue (x : front, rear) = (x, maybe_mtf (front, rear))

maybe_mtf ([], rear) = (reverse rear, [])
maybe_mtf q = q

