module Data_Queue(Queue, empty, isEmpty, dequeue, enqueue) 
  where

data Queue a = Queue ([a], [a])

empty :: Queue a
empty = Queue ([], [])

isEmpty :: Queue a -> Bool
isEmpty (Queue (front, _)) = null front

queue = Queue . maybe_mtf

enqueue :: a -> Queue a -> Queue a
enqueue x (Queue (front, rear)) = queue (front, x : rear)

dequeue :: Queue a -> (a, Queue a)
dequeue (Queue ([], _)) = error "dequeue on empty queue"
dequeue (Queue (x : front, rear)) = (x, queue (front, rear))

maybe_mtf ([], rear) = (reverse rear, [])
maybe_mtf q = q

