module Trees where

import Basic_Queue 

data Tree a = Empty | Node (Tree a) a (Tree a)

inorder :: Tree a -> [a]
inorder Empty = []
inorder (Node l n r) = inorder l ++ [n] ++ inorder r

preorder :: Tree a -> [a]
preorder Empty = []
preorder (Node l n r) = [n] ++ preorder l ++ preorder r

bfs :: Tree a -> [a]
bfs t = bfsMain (enqueue t empty) where
  bfsMain :: Queue (Tree a) -> [a]
  bfsMain q 
    | isEmpty q = []
    | otherwise = let (t', q') = dequeue q in
        case t' of
           Empty -> bfsMain q'
           Node l n r -> 
             n : (bfsMain $ enqueue r . enqueue l $ q')

exampleTree :: Tree Integer
exampleTree = 
  Node 
    (Node 
      (Node 
        (Node Empty 2 Empty) 
        7 
        (Node Empty 12 Empty))
      4
      (Node Empty 9 Empty))
    8
    (Node 
      Empty
      2
      (Node
        (Node Empty 17 Empty)
        11
        (Node Empty 8 Empty)))
     
