
"""
Parameters and constants used across the files
"""

# ##### Default values for Main function
default_learning_rate = 0.001
default_decay_rate = 0.9
default_decay_steps = 200
default_num_epoch = 16
default_batch_size = 16
default_embedding_dim = 128
default_max_len = 256
default_projection_dim = default_max_len
default_num_lstm_layers = 2
default_vocab_size = 2048
default_eval_examples = 20
default_log_dir = 'models/logdir'
default_training_data = '../small_training_data'
default_evaluation_data = '../evaluation_data'
default_test_data = '../test_data'
default_train_ev_split = 10


# ##### Hyperparamters for Models

# the length of the tuple is the number of filters
hyperparam_lstm_state_dims = (256, 256, 256)

# the length of the list is the number of filters
hyperparam_cnn_filter_sizes = [1, 2, 4, 8, 16, 32, 64, 128]

# the length of the tuple is the number of filters
hyperparam_hidden_fc_after_main_models = (256, 256)
