from os import listdir
from os.path import isfile, join
from typing import List
import os
from enum import Enum, auto
import itertools


class DataDirNames(Enum):
    SUBFORMULAS = 'subformulas'
    MODUS_PONENS = 'modus_ponens'
    TERM_FORMULA = 'term_formula'
    UNIFIABILITY = 'unifiability'
    WELL_FORMEDNESS = 'well_formedness'
    ALPHA_EQUIVALENCE = "alpha_equivalence"


class DeephiMode(Enum):
    EMBED = auto()
    EVAL = auto()
    PREDICT = auto()
    DEFAULT = auto()


def split_into(a: List, n):
    if len(a) == 0:
        return []
    k, m = divmod(len(a), n)
    return (a[i * k + min(i, m):(i + 1) * k + min(i + 1, m)] for i in range(n))


def chunks(l: List, n: int):
    for i in range(0, len(l), n):
        yield l[i:i + n]


def unique_order_preserving(seq):
    seen = set()
    seen_add = seen.add
    return [x for x in seq if not (x in seen or seen_add(x))]


def move_files(source, dest):
    files = [os.path.basename(file) for file in list_files_from_directory(source)]
    for file in files:
        os.rename(os.path.join(source, file), os.path.join(dest, file))


def list_files_from_directory(directory):
    return [join(directory, f) for f in listdir(directory) if isfile(join(directory, f))]


def remove_duplicates_in_list_list(lst):
    b_set = set(tuple(x) for x in lst)
    return [list(x) for x in b_set]


def count_lines_in_files(files):
    res = 0
    for file in files:
        with open(file, 'r') as f:
            for line in f:
                res += 1
    return res


def file_to_string_list(file: str) -> List[str]:
    with open(file, 'r') as f:
        lines = f.read().splitlines()
    return lines


def splitter(data, p):
    yes, no = [], []
    for d in data:
        (yes if p(d) else no).append(d)
    return yes, no


def count_symbols_in_dir(dir: str):
    files = list_files_from_directory(dir)
    lls = [file_to_string_list(f) for f in files]
    strings = list(itertools.chain.from_iterable(lls))
    return len(set(''.join(strings)))
