open Batteries

let add2 (x1, y1) (x2, y2) = (x1 + x2, y1 + y2)

let () =
  let litcls = Hashtbl.create 10000 in
  let filelines = IO.lines_of stdin in
  Enum.iter
    (fun line ->
      try Scanf.sscanf line "%d\t%d\t%s\t%s"
        (fun p n lit cl -> Hashtbl.modify_def (0,0) (lit, cl) (add2 (p, n)) litcls)
      with End_of_file -> Format.eprintf "unmatched line: %s\n" line
    ) filelines;
  Hashtbl.iter (fun (lit, cl) (p, n) -> Format.printf "%d\t%d\t%s\t%s\n" p n lit cl) litcls
