open Batteries

(* Module overriding taken from: http://gallium.inria.fr/blog/overriding-submodules/ *)
module Option = struct
  include (Option : module type of Option with module Infix := Option.Infix)
  module Infix = struct
    include Option.Infix
    let (>>=) = Option.Monad.bind
  end
end


module LazyList = struct

include LazyList

(* The default implementation of `take` in OCaml Batteries was not lazy,
   fixed it with the help of
   <https://github.com/ocaml-batteries-team/batteries-included/issues/688>.
*)

let split_at n li =
  let last_n = ref n in
  let last_li = ref li in
  let rec take n li =
    last_n := n;
    last_li := li;
    if n = 0 then lazy LazyList.Nil
    else
      lazy
        (match (Lazy.force li) with
         | Nil -> Nil
         | Cons (x, xs) -> Cons (x, take (n - 1) xs))
  in
  take n li, lazy (Lazy.force (drop !last_n !last_li))

let take n l = fst (split_at n l)

let take_test () =
  from (fun () -> Unix.sleep 1; 0) |> take 5 |> iter (Printf.printf "%d%!")

end
