open Batteries
open Mapping
open Fof
open Term
open Print
open Arglean.Lean
open Matrix.Clausal

let nocontent_dcnf () =
  let defno = ref 0 in
  let def cl = incr defno; "def" ^ string_of_int !defno in
  def

let content_dcnf t =
  "'def(" ^ String.filter ((<>) '\'') (string_of_form t) ^ ")'"

let dcnf content = dcnf_of_form
  (const_number % if content then content_dcnf else nocontent_dcnf ())

let clause_prefix cl = if clause_positive cl then cl else hash_lit :: cl

let shuffle_clause =
  List.map (fun lit -> Random.bits (), lit) %> List.sort compare %> List.map snd

let shuffle_matrix =
  List.map (fun cl -> Random.bits (), shuffle_clause cl) %> List.sort compare %> List.map snd

let file_mat conj def = let open Preprocess in
  Fof_lexer.file %> List.rev %>
  split_goal %> (if conj then add_hash else identity) %> combine_goal %>
  map_form_vars var %>
  Equality.equal_axioms eqn %>
  neg %>
  unfold_equiv true %> miniscope %> nnf %>
  strip_conj [] %> List.map (rename_form false) %> conj_of_forms %>
  (*tap (strip_conj [] %> pp_nl (pp_iter "\n" pp_print_form) Format.std_formatter) %>*)
  skolem !content %>
  noforall %>
  (if def then dcnf !content else cnf_of_form) %>
  List.map rename_clause %>
  (*tap (pp_nl (pp_iter "\n" pp_print_clause) Format.std_formatter) %>*)
  List.filter nontriv_clause %>
  List.map (List.unique_hash %> if conj then identity else clause_prefix) %>
  (if !shuffle then shuffle_matrix else identity)
